/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.DVTSynchronizableDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.OptimizedHashMap;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;

public class CodePreprocFileInfo
implements Serializable {
    private static final String ENDIF = "`endif";
    private static final String IFNDEF = "`ifndef";
    private static final String IFDEF = "`ifdef";
    private static final long serialVersionUID = 1L;
    private boolean fReduced;
    private Map<Integer, CodePreprocLineInfo> fLineInfos;
    private transient Map<Integer, CodePreprocLineInfo> fReducedLineInfos;

    public void putInfo(int line, CodePreprocLineInfo info) {
        if (this.fLineInfos == null) {
            this.fLineInfos = new OptimizedHashMap();
        }
        this.fLineInfos.put(line, info);
        this.fReduced = false;
    }

    public CodePreprocLineInfo getInfo(int line) {
        return this.fLineInfos == null ? null : this.fLineInfos.get(line);
    }

    public TreeSet<Integer> getLines() {
        return this.fLineInfos == null ? null : new TreeSet<Integer>(this.fLineInfos.keySet());
    }

    private void reduce() {
        if (this.fLineInfos == null || this.fLineInfos.size() == 0) {
            this.fReducedLineInfos = null;
            return;
        }
        this.fReducedLineInfos = new HashMap<Integer, CodePreprocLineInfo>(this.fLineInfos);
        Object[] sortedLineInfos = this.fReducedLineInfos.values().toArray(new CodePreprocLineInfo[this.fReducedLineInfos.size()]);
        Arrays.sort(sortedLineInfos);
        if (((CodePreprocLineInfo)sortedLineInfos[0]).getType() == 0) {
            this.fReducedLineInfos.remove(((CodePreprocLineInfo)sortedLineInfos[0]).getLine());
        }
        int i = 1;
        while (i < sortedLineInfos.length) {
            if (((CodePreprocLineInfo)sortedLineInfos[i]).getType() == 0 && ((CodePreprocLineInfo)sortedLineInfos[i - 1]).getType() != 1) {
                this.fReducedLineInfos.remove(((CodePreprocLineInfo)sortedLineInfos[i]).getLine());
            }
            if (((CodePreprocLineInfo)sortedLineInfos[i]).getType() == 1 && ((CodePreprocLineInfo)sortedLineInfos[i - 1]).getType() == 1) {
                this.fReducedLineInfos.remove(((CodePreprocLineInfo)sortedLineInfos[i]).getLine());
            }
            ++i;
        }
        if (((CodePreprocLineInfo)sortedLineInfos[sortedLineInfos.length - 1]).getType() == 1) {
            this.fReducedLineInfos.remove(((CodePreprocLineInfo)sortedLineInfos[sortedLineInfos.length - 1]).getLine());
        }
    }

    public CodePreprocLineInfo[] getCodePreprocLineInfo() {
        if (!this.fReduced) {
            this.reduce();
        }
        if (this.fReducedLineInfos == null || this.fReducedLineInfos.size() == 0) {
            return null;
        }
        if (this.fReducedLineInfos.size() % 2 != 0) {
            return null;
        }
        Object[] sortedLineInfos = this.fReducedLineInfos.values().toArray(new CodePreprocLineInfo[this.fReducedLineInfos.size()]);
        Arrays.sort(sortedLineInfos);
        return sortedLineInfos;
    }

    public void addPositions(IDocument document, String positionCategory) {
        CodePreprocLineInfo[] preprocLineInfo = this.getCodePreprocLineInfo();
        if (preprocLineInfo == null) {
            return;
        }
        if (document.getLength() == 0) {
            return;
        }
        try {
            int documentLines = document.getNumberOfLines();
            int i = 0;
            while (i < preprocLineInfo.length) {
                int startLine = preprocLineInfo[i].getLine() - 1;
                int endLine = preprocLineInfo[i + 1].getLine() - 1;
                if (!(document instanceof DVTSynchronizableDocument || startLine <= documentLines && endLine <= documentLines)) {
                    return;
                }
                int startOffset = document.getLineOffset(startLine);
                int endOffset = document.getLineOffset(endLine) + 1;
                DVTDocumentUtils.addDocumentPosition((Object)document, (String)positionCategory, (Object)new DVTPosition(startOffset, endOffset - startOffset));
                i += 2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public List<List<Integer>> getPreprocUsageOffsetRangesForDocument(IDocument document) {
        CodePreprocLineInfo[] preprocLineInfo;
        ArrayList<List<Integer>> lineRanges;
        block11: {
            lineRanges = new ArrayList<List<Integer>>();
            preprocLineInfo = this.getSortedRawPreprocLineInfo();
            if (preprocLineInfo != null) break block11;
            return null;
        }
        try {
            int documentLines = document.getNumberOfLines();
            int depth = 0;
            ArrayList<Integer> lineRange = new ArrayList<Integer>(2);
            int i = 0;
            while (i < preprocLineInfo.length) {
                CodePreprocLineInfo currentLineInfo = preprocLineInfo[i];
                int line = currentLineInfo.getLine() - 1;
                int column = currentLineInfo.getColumn();
                if (line <= documentLines) {
                    int offset = document.getLineOffset(line) + column;
                    IRegion wordRegion = VlogWordFinder.getDefault().getWordAtOffset(document, offset);
                    if (wordRegion != null) {
                        String candidateName = document.get(wordRegion.getOffset(), wordRegion.getLength()).trim();
                        if (candidateName.isEmpty()) {
                            wordRegion = VlogWordFinder.getDefault().getWordAtOffset(document, offset - 1);
                            candidateName = document.get(wordRegion.getOffset(), wordRegion.getLength()).trim();
                        }
                        boolean isEnterPreprocRegion = IFNDEF.equals(candidateName) || IFDEF.equals(candidateName);
                        boolean isEndPreprocRegion = ENDIF.equals(candidateName);
                        if (isEnterPreprocRegion) {
                            if (depth == 0) {
                                lineRange.add(offset);
                            }
                            ++depth;
                        } else if (isEndPreprocRegion && --depth == 0) {
                            lineRange.add(offset);
                            lineRanges.add(lineRange);
                            lineRange = new ArrayList(2);
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return lineRanges;
    }

    public CodePreprocLineInfo[] getSortedRawPreprocLineInfo() {
        if (this.fLineInfos == null || this.fLineInfos.size() == 0) {
            return null;
        }
        if (this.fLineInfos.size() % 2 != 0) {
            return null;
        }
        Object[] sortedLineInfos = this.fLineInfos.values().toArray(new CodePreprocLineInfo[this.fLineInfos.size()]);
        Arrays.sort(sortedLineInfos);
        return sortedLineInfos;
    }

    public List<List<Integer>> getPreprocLinesRangesForDocument(IDocument document) {
        CodePreprocLineInfo[] preprocLineInfo = this.getCodePreprocLineInfo();
        if (preprocLineInfo == null) {
            return null;
        }
        ArrayList<List<Integer>> lineRanges = new ArrayList<List<Integer>>();
        int documentLines = document.getNumberOfLines();
        int i = 0;
        while (i < preprocLineInfo.length) {
            int startLine = preprocLineInfo[i].getLine() - 1;
            int endLine = preprocLineInfo[i + 1].getLine() - 1;
            if (startLine <= documentLines && endLine <= documentLines) {
                ArrayList<Integer> lineRange = new ArrayList<Integer>(2);
                lineRange.add(startLine);
                lineRange.add(endLine);
                lineRanges.add(lineRange);
            }
            i += 2;
        }
        return lineRanges;
    }
}

