/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.Serializable;
import java.util.Objects;

public class CodePreprocLineInfo
implements Serializable,
Comparable<CodePreprocLineInfo> {
    private static final long serialVersionUID = 1L;
    public static final int ENTER = 0;
    public static final int SKIP = 1;
    private int fType;
    private int fLine;
    private int fColumn;

    public CodePreprocLineInfo(int type, int line, int column) {
        this.fType = type;
        this.fLine = line;
        this.fColumn = column;
    }

    public int getType() {
        return this.fType;
    }

    public int getLine() {
        return this.fLine;
    }

    public int getColumn() {
        return this.fColumn;
    }

    public String toString() {
        return "[" + (this.fType == 0 ? "ENTER" : "SKIP") + "@" + this.fLine + "]";
    }

    @Override
    public int compareTo(CodePreprocLineInfo o) {
        if (o == null) {
            return 1;
        }
        if (this.fLine != o.getLine()) {
            return this.fLine - o.getLine();
        }
        return this.fColumn - o.getColumn();
    }

    public int hashCode() {
        return Objects.hash(this.fLine, this.fColumn, this.fType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodePreprocLineInfo)) {
            return false;
        }
        CodePreprocLineInfo other = (CodePreprocLineInfo)obj;
        return this.fLine == other.fLine && this.fColumn == other.fColumn && this.fType == other.fType;
    }
}

