/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.parser.MacroCallItem;

public class MacroCallInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<MacroCallItem> fMacroCalls;

    public void addItem(MacroCallItem item) {
        if (this.fMacroCalls == null) {
            this.fMacroCalls = new ArrayList<MacroCallItem>();
        }
        this.fMacroCalls.add(item);
    }

    public List<MacroCallItem> getItems() {
        return this.fMacroCalls;
    }

    public List<MacroCallItem> getItems(String name) {
        ArrayList<MacroCallItem> result = null;
        if (this.fMacroCalls == null) {
            return null;
        }
        for (MacroCallItem item : this.fMacroCalls) {
            if (!name.equals(item.getName())) continue;
            if (result == null) {
                result = new ArrayList<MacroCallItem>();
            }
            result.add(item);
        }
        return result;
    }

    public List<MacroCallItem> getItems(Set<String> names) {
        ArrayList<MacroCallItem> result = null;
        if (this.fMacroCalls == null) {
            return null;
        }
        for (MacroCallItem item : this.fMacroCalls) {
            if (!names.contains(item.getName())) continue;
            if (result == null) {
                result = new ArrayList<MacroCallItem>();
            }
            result.add(item);
        }
        return result;
    }

    public List<MacroCallItem> getItemsWithPrefix(String prefix) {
        if (this.fMacroCalls == null) {
            return null;
        }
        ArrayList<MacroCallItem> result = new ArrayList<MacroCallItem>();
        for (MacroCallItem item : this.fMacroCalls) {
            if (!item.getName().startsWith(prefix)) continue;
            result.add(item);
        }
        return result;
    }

    public List<MacroCallItem> getItemsWithArgs(String name, String[] args) {
        ArrayList<MacroCallItem> result = null;
        if (this.fMacroCalls == null) {
            return null;
        }
        for (MacroCallItem item : this.fMacroCalls) {
            if (!name.equals(item.getName()) || !item.parametersEqual(args)) continue;
            if (result == null) {
                result = new ArrayList<MacroCallItem>();
            }
            result.add(item);
        }
        return result;
    }

    public List<MacroCallItem> getItemsWithFirstArg(String name, String arg) {
        ArrayList<MacroCallItem> result = null;
        if (this.fMacroCalls == null) {
            return null;
        }
        for (MacroCallItem item : this.fMacroCalls) {
            if (!name.equals(item.getName()) || !item.firstParametersEquals(arg)) continue;
            if (result == null) {
                result = new ArrayList<MacroCallItem>();
            }
            result.add(item);
        }
        return result;
    }

    public void clear() {
        if (this.fMacroCalls != null) {
            this.fMacroCalls.clear();
        }
        this.fMacroCalls = null;
    }
}

