/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class MacroCallListener {
    public static final String SCOPE_ALL = "all";
    public static final String SCOPE_CLASS = "class";
    public static final String SCOPE_CONSTRUCTOR = "constructor";
    public static final String SCOPE_FUNCTION = "function";
    public static final String SCOPE_TASK = "task";
    public static final String SCOPE_ASSERT_ELSE = "assert_else";
    public static final int LINT_TAG_DO_NOT_TRACK = 0;
    public static final int LINT_TAG_TRACKED_BY_NAME = 1;
    public static final int LINT_TAG_TRACKED_BY_DEPRECATED_COMMENT = 2;
    private Set<String> fTrackByMacroNames;
    private Set<String> fTrackByDeprecatedComments;
    private Set<MacroCallItem> fStoredMacroCalls;

    public MacroCallListener(Set<String> trackByMacroNames, Set<String> trackByDeprecatedComments) {
        this.fTrackByMacroNames = trackByMacroNames;
        this.fTrackByDeprecatedComments = trackByDeprecatedComments;
    }

    public void addTrackByMacroNames(List<String> additionalMacroNames) {
        if (this.fTrackByMacroNames != null && additionalMacroNames != null) {
            this.fTrackByMacroNames.addAll(additionalMacroNames);
        }
    }

    public void addTrackByMacroNames(Set<String> additionalMacroNames) {
        if (this.fTrackByMacroNames != null && additionalMacroNames != null) {
            this.fTrackByMacroNames.addAll(additionalMacroNames);
        }
    }

    public ArrayList<MacroCallItem> getStoredMacroCalls() {
        if (this.fStoredMacroCalls == null) {
            return null;
        }
        return new ArrayList<MacroCallItem>(this.fStoredMacroCalls);
    }

    public void notifyMacroCall(VlogMacroInfo macroInfo, String[] macroParameters, ReparseInfo reparseInfo, ParserPath parserPath, LineInfo lineInfo) {
        if (macroInfo == null) {
            return;
        }
        int lintTrackByTag = this.shouldStoreMacroCall(macroInfo);
        if (lintTrackByTag == 0) {
            return;
        }
        MacroCallItem item = new MacroCallItem("`" + macroInfo.getName(), macroParameters, parserPath, lineInfo, reparseInfo);
        item.fLintTrackedByTag = lintTrackByTag;
        if (this.fStoredMacroCalls == null) {
            this.fStoredMacroCalls = new LinkedHashSet<MacroCallItem>();
        }
        this.fStoredMacroCalls.add(item);
    }

    protected int shouldStoreMacroCall(VlogMacroInfo macroInfo) {
        if (this.fTrackByMacroNames != null && this.fTrackByMacroNames.contains("`" + macroInfo.getName())) {
            return 1;
        }
        if (this.fTrackByDeprecatedComments == null) {
            return 0;
        }
        CommentBlock macroComment = macroInfo.getCommentBlock();
        if (macroComment == null) {
            return 0;
        }
        for (String relevantComment : this.fTrackByDeprecatedComments) {
            if (!macroComment.contains(relevantComment)) continue;
            return 2;
        }
        return 0;
    }
}

