/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallListener;

public class MacroCallListenerFactory {
    private static volatile MacroCallListenerFactory fInstance;

    private MacroCallListenerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MacroCallListenerFactory getInstance() {
        Class<MacroCallListenerFactory> clazz = MacroCallListenerFactory.class;
        synchronized (MacroCallListenerFactory.class) {
            if (fInstance == null) {
                fInstance = new MacroCallListenerFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fInstance;
        }
    }

    public MacroCallListener createMacroCallListener(String scope, RfProject rfProject) {
        Set<String> scopeMacros;
        MacroCallListener result = this.createBaseMacroCallListener(rfProject);
        if (rfProject != null && (scopeMacros = rfProject.lintGetTrackMacrosByNames(scope)) != null) {
            result.addTrackByMacroNames(scopeMacros);
        }
        return result;
    }

    private MacroCallListener createBaseMacroCallListener(RfProject rfProject) {
        Set<String> scopeMacros;
        HashSet<String> relevantMacroNames = new HashSet<String>();
        if (rfProject != null && (scopeMacros = rfProject.lintGetTrackMacrosByNames("all")) != null) {
            relevantMacroNames.addAll(scopeMacros);
        }
        Set<String> relevantComments = new HashSet<String>();
        if (rfProject != null && rfProject.lintGetTrackMacrosByDeprecatedComments() != null) {
            relevantComments = rfProject.lintGetTrackMacrosByDeprecatedComments();
        }
        return new MacroCallListener(relevantMacroNames, relevantComments);
    }
}

