/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IReparseElement;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class ReparseInfo
implements IReparseInfo,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final int OVERFLOW_SIZE_LIMIT = 100;
    public static final String MACRO_PART_FORMAT = "    inside macro {0} at line {1} in ''{2}''";
    private ReparseElement[] fReparseStack;
    private ReparseElement fLastReparseElement;
    private volatile transient boolean fNotificationDone;

    public ReparseInfo(ReparseElement[] reparseStack, ReparseElement lastReparseElement) {
        this.fReparseStack = reparseStack;
        this.fLastReparseElement = lastReparseElement;
    }

    public final int getReparseStackSize() {
        int offset;
        int n = offset = this.fLastReparseElement == null ? 0 : 1;
        if (this.fReparseStack == null || this.fReparseStack.length == 0) {
            return offset;
        }
        return this.fReparseStack.length + offset;
    }

    public final boolean isNotificationDone() {
        return this.fNotificationDone;
    }

    public final void setNotificationDone(boolean notifyDone) {
        this.fNotificationDone = notifyDone;
    }

    public final void collectParserPaths(Collection<ParserPath> parserPaths) {
        ParserPath lastReparseMacroFile = this.getLastReparseMacroFile();
        if (lastReparseMacroFile != null) {
            parserPaths.add(lastReparseMacroFile);
        }
        if (this.fReparseStack == null || this.fReparseStack.length == 0) {
            return;
        }
        ReparseElement[] reparseElementArray = this.fReparseStack;
        int n = this.fReparseStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseElement reparseElement = reparseElementArray[n2];
            ParserPath reparseMacroFile = reparseElement.getReparseMacroFile();
            if (reparseMacroFile != null) {
                parserPaths.add(reparseMacroFile);
            }
            ++n2;
        }
    }

    public final ReparseElement[] getReparseStack() {
        int size = this.getReparseStackSize();
        ReparseElement[] result = new ReparseElement[size];
        System.arraycopy(this.fReparseStack, 0, result, 0, this.fReparseStack.length);
        if (this.fLastReparseElement != null) {
            result[size - 1] = this.fLastReparseElement;
        }
        return result;
    }

    public final String getReparseStackTrace() {
        if (this.getReparseStackSize() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        ReparseElement[] reparseElementArray = this.fReparseStack;
        int n = this.fReparseStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseElement element = reparseElementArray[n2];
            if (result.length() > 9000) {
                result.append("...");
                break;
            }
            result.append(element.toString());
            ++n2;
        }
        if (this.fLastReparseElement != null) {
            result.append(this.fLastReparseElement.toString());
        }
        return result.toString();
    }

    public final String toString() {
        return this.getReparseStackTrace();
    }

    public final String getLastReparseMacroName() {
        if (this.fLastReparseElement == null) {
            return "";
        }
        return this.fLastReparseElement.getReparseMacroName();
    }

    public final ParserPath getLastReparseMacroFile() {
        if (this.fLastReparseElement == null) {
            return null;
        }
        return this.fLastReparseElement.getReparseMacroFile();
    }

    public final int getLastReparseMacroLine() {
        if (this.fLastReparseElement == null) {
            return -1;
        }
        return this.fLastReparseElement.getReparseMacroLine();
    }

    public final ReparseElement getLastReparseElement() {
        return this.fLastReparseElement;
    }

    protected boolean equals(ReparseElement[] reparseStack, ReparseElement lastReparseElement) {
        if (!this.fLastReparseElement.equals(lastReparseElement)) {
            return false;
        }
        return Arrays.equals(reparseStack, this.fReparseStack);
    }

    public final int hashCode() {
        int result = 1;
        result = 31 * result + (this.fLastReparseElement == null ? 0 : this.fLastReparseElement.hashCode());
        result = 31 * result + Arrays.hashCode(this.fReparseStack);
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReparseInfo reparseInfo = (ReparseInfo)obj;
        if (this.fLastReparseElement == null ? reparseInfo.fLastReparseElement != null : !this.fLastReparseElement.equals(reparseInfo.fLastReparseElement)) {
            return false;
        }
        if (this.fReparseStack == null && reparseInfo.fReparseStack == null) {
            return true;
        }
        return Arrays.equals(this.fReparseStack, reparseInfo.fReparseStack);
    }

    public static class OverflowReparseElement
    extends ReparseElement {
        private static final long serialVersionUID = 1L;

        public OverflowReparseElement() {
            super(null, null, null, null, -1);
        }

        @Override
        public final String toString() {
            StringBuilder trace = new StringBuilder("    ... (stack size too large to print)");
            return trace.toString();
        }
    }

    public static class ReparseElement
    implements Serializable,
    IReparseElement {
        public static final Map<VlogMacroInfo, Map<ReparseElement, ReparseElement>> REPARSE_ELEMENT_CACHE = Collections.synchronizedMap(new IdentityHashMap());
        private static final long serialVersionUID = 2L;
        private ParserPath fReparseMacroFile;
        private String fReparseMacroName;
        private int fReparseMacroLine;
        private String[] fReparseMacroParams;
        private String[] fReparseMacroUnprocessedParams;
        private VlogMacroInfo fReparseMacroInfo;

        private ReparseElement(VlogMacroInfo macroInfo, String[] macroParameters, String[] macroUnprocessedParameters, ParserPath macroFile, int macroLine) {
            this.fReparseMacroInfo = macroInfo;
            this.fReparseMacroName = DVTStringUtil.intern((String)(macroInfo == null || macroInfo.getName() == null ? "" : macroInfo.getName()));
            this.fReparseMacroParams = macroParameters;
            this.fReparseMacroUnprocessedParams = macroUnprocessedParameters;
            this.fReparseMacroFile = macroFile;
            this.fReparseMacroLine = macroLine;
        }

        public final VlogMacroInfo getTransientReparseMacroInfo() {
            return this.fReparseMacroInfo;
        }

        public final String getReparseMacroName() {
            return this.fReparseMacroName;
        }

        public final String[] getReparseMacroParams() {
            return this.fReparseMacroParams;
        }

        public final String[] getReparseMacroUnprocessedParams() {
            return this.fReparseMacroUnprocessedParams;
        }

        public final ParserPath getReparseMacroFile() {
            return this.fReparseMacroFile;
        }

        public final int getReparseMacroLine() {
            return this.fReparseMacroLine;
        }

        public String toString() {
            StringBuilder trace = new StringBuilder("    inside macro `").append(this.fReparseMacroName).append(" at line ").append(this.fReparseMacroLine).append(" in '").append(this.fReparseMacroFile.path).append("'\n");
            return trace.toString();
        }

        public static ReparseElement of(VlogMacroInfo macroInfo, String[] macroParameters, String[] macroUnprocessedParameters, ParserPath macroFile, int macroLine) {
            ReparseElement reparseElement = new ReparseElement(macroInfo, macroParameters, macroUnprocessedParameters, macroFile, macroLine);
            Map<ReparseElement, ReparseElement> reparseElements = REPARSE_ELEMENT_CACHE.get(macroInfo);
            if (reparseElements == null) {
                reparseElements = new HashMap<ReparseElement, ReparseElement>();
                REPARSE_ELEMENT_CACHE.put(macroInfo, reparseElements);
            } else {
                ReparseElement cachedElement = reparseElements.get(reparseElement);
                if (cachedElement != null) {
                    return cachedElement;
                }
            }
            reparseElements.put(reparseElement, reparseElement);
            return reparseElement;
        }

        public static void clearCache() {
            REPARSE_ELEMENT_CACHE.clear();
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ReparseElement)) {
                return false;
            }
            ReparseElement reparseElement = (ReparseElement)obj;
            if (this.fReparseMacroLine != reparseElement.fReparseMacroLine) {
                return false;
            }
            if (this.fReparseMacroParams != null && reparseElement.fReparseMacroParams == null) {
                return false;
            }
            if (this.fReparseMacroParams == null && reparseElement.fReparseMacroParams != null) {
                return false;
            }
            if (!this.fReparseMacroName.equals(reparseElement.fReparseMacroName)) {
                return false;
            }
            if (!this.fReparseMacroFile.equals((Object)reparseElement.fReparseMacroFile)) {
                return false;
            }
            if (this.fReparseMacroInfo == null ? reparseElement.fReparseMacroInfo != null : !this.fReparseMacroInfo.equals(reparseElement.fReparseMacroInfo)) {
                return false;
            }
            return Arrays.equals(this.fReparseMacroParams, reparseElement.fReparseMacroParams) && Arrays.equals(this.fReparseMacroUnprocessedParams, reparseElement.fReparseMacroUnprocessedParams);
        }

        public final int hashCode() {
            int result = 1;
            result = 31 * result + this.fReparseMacroLine;
            result = 31 * result + (this.fReparseMacroFile == null ? 0 : this.fReparseMacroFile.hashCode());
            result = 31 * result + (this.fReparseMacroName == null ? 0 : this.fReparseMacroName.hashCode());
            result = 31 * result + (this.fReparseMacroInfo == null ? 0 : this.fReparseMacroInfo.hashCode());
            result = 31 * result + Arrays.hashCode(this.fReparseMacroParams);
            result = 31 * result + Arrays.hashCode(this.fReparseMacroUnprocessedParams);
            return result;
        }
    }
}

