/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import antlr.Token;
import java.util.concurrent.atomic.AtomicInteger;

public class VlogConcurrentArray {
    private final int SIZE;
    private final int HALF_SIZE;
    private int fWriteAddr;
    private int fReadAddr;
    private AtomicInteger fSize = new AtomicInteger();
    private volatile Object[] fTable;
    private final Object fWriteLock = new Object();
    private final Object fReadLock = new Object();

    public VlogConcurrentArray(int log2size) {
        this.SIZE = 1 << log2size;
        this.HALF_SIZE = this.SIZE / 2;
        this.fTable = new Object[this.SIZE];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Object item) throws InterruptedException {
        Object object;
        if (this.fSize.intValue() == this.SIZE) {
            object = this.fWriteLock;
            synchronized (object) {
                while (this.fSize.intValue() == this.SIZE) {
                    this.fWriteLock.wait();
                }
            }
        }
        if (this.fSize.intValue() == this.HALF_SIZE || item instanceof Token && ((Token)item).getType() == 1) {
            object = this.fReadLock;
            synchronized (object) {
                this.fReadLock.notifyAll();
            }
        }
        this.fTable[this.fWriteAddr] = item;
        this.fWriteAddr = (this.fWriteAddr + 1) % this.SIZE;
        this.fSize.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object take() throws InterruptedException {
        while (this.fSize.intValue() == 0) {
            Object object = this.fReadLock;
            synchronized (object) {
                this.fReadLock.wait(50L);
            }
        }
        return this.poll();
    }

    public final boolean isEmpty() {
        return this.fSize.intValue() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object poll() throws InterruptedException {
        if (this.fSize.intValue() == this.HALF_SIZE) {
            Object object = this.fWriteLock;
            synchronized (object) {
                this.fWriteLock.notifyAll();
            }
        }
        Object result = this.fTable[this.fReadAddr];
        this.fReadAddr = (this.fReadAddr + 1) % this.SIZE;
        this.fSize.decrementAndGet();
        return result;
    }
}

