/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.precompiled.PrecompiledAutoDebugUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBManager;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentsTable;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.reflection.IRfFileInstanceVisitor;
import ro.amiq.vlogdt.model.reflection.IRfMacroVisitor;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.parser.IDefinesProvider;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroText;
import ro.amiq.vlogdt.parser.VlogMacroZone;
import ro.amiq.vlogdt.parser.VlogUtil;
import ro.amiq.vlogdt.precompiled.VlogPrecompiledDBUtils;
import ro.amiq.vlogdt.utils.Utils;

public class VlogFileInstance
implements IDVTFileInstance,
Serializable,
IDefinesProvider {
    private static final long serialVersionUID = 6L;
    public static final int INCLUDE_INCREMENTAL_COMPILED_TOP = -1;
    public static final int INCLUDE_INCREMENTAL_COMPILED_NON_TOP = -2;
    public static final int NOT_TOP_FILE = 0;
    public static final String LINTER_DUMMY_FILE = "dummy lint check";
    private transient RfProject fRfProject;
    private transient RfNamedElement fSemanticScope;
    private transient RfNamedElement fInitialLibrary;
    private ParserPath fParserPath;
    private List<VlogMacroZone> fMacroZones;
    private VlogMacroZone fMacroZoneBeforeIncremental;
    private Map<Integer, String> fDefaultNetTypes;
    private Map<Integer, HidImplicit[]> fTimescales;
    private String fShortFileName;
    private VlogIncludingScope fIncludingScope;
    private int fIndex;
    private List<String> fUndeclaredElements;
    private boolean fIsVcsModeForMinusY;
    private boolean fOptimizeSkip;
    private int fInvocNumber;
    private boolean fAOPSupport;
    private boolean fAMSSupport;
    private boolean fWrealSupport;
    private IBuildConfigParserConstants.ToolCompat fToolCompat;
    private int fNofRawLines;
    private boolean fIsBuildConfigFileInstance;
    private IBuildConfigParserConstants.LanguageSyntax fLanguageSyntax = IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009;
    private List<String> fIncdirs = Collections.emptyList();
    private List<CustomPragmaUsage> fCustomPragmas;
    private transient Set<VlogFileInstance> fSavedIncludedFilesInfo;
    private transient CommentsTable fComments;
    private transient int fCompactSLStartLine;
    private transient int fCompactSLEndLine;
    private transient Object fIncrBuildMacroLookup;
    private static final byte FULL = 0;
    private static final byte SHALLOW = 1;
    private static final byte PRECOMPILED_MANUAL = 2;
    private static final byte PRECOMPILED_AUTO = 4;
    private static final byte INCREMENTAL = 8;
    private byte fCompilationState = 0;
    private VlogMacroZone cachedMacroZone;
    private Map<String, VlogMacroInfo> cachedMacroZoneLookupMap;

    protected VlogFileInstance(RfProject rfProject, ParserPath parserPath, VlogIncludingScope includingScope, int index, List<String> incdirs, int invocNumber, boolean hasAOPSupport, boolean hasAMSSupport, boolean hasWrealSupport, IBuildConfigParserConstants.ToolCompat toolCompat, boolean isPrecompiledDb) {
        this.setFileName(parserPath);
        this.updateMacroZone(includingScope, index);
        this.fRfProject = rfProject;
        if (this.fRfProject != null) {
            this.fRfProject.addInvocationIndexForPath(parserPath, invocNumber);
        }
        this.fOptimizeSkip = false;
        this.fIncdirs = incdirs;
        this.fInvocNumber = invocNumber;
        this.fToolCompat = toolCompat;
        this.fAOPSupport = hasAOPSupport;
        this.fAMSSupport = hasAMSSupport;
        this.fWrealSupport = hasWrealSupport;
        this.fNofRawLines = 0;
        this.fCompilationState = 0;
        if (rfProject == null) {
            return;
        }
        List invocations = BuildConfigManager.getInvocations((IProject)rfProject.getProject());
        if (invocations == null) {
            return;
        }
        if (this.fInvocNumber < 0) {
            return;
        }
        Invocation invocation = (Invocation)invocations.get(this.fInvocNumber);
        if (invocation == null) {
            return;
        }
        if (parserPath != null) {
            this.fInitialLibrary = rfProject.getOrCreateLibrary(invocation.getLibName());
        }
        if (!isPrecompiledDb) {
            return;
        }
        BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode = BuildConfigManager.getPrecompiledDbMode((IProject)rfProject.getProject());
        this.fCompilationState = precompiledDbMode.isAny(new BuildConfigManagerCommon.PrecompileGlobalMode[]{BuildConfigManagerCommon.PrecompileGlobalMode.NO_GLOBAL_PRECOMPILE, BuildConfigManagerCommon.PrecompileGlobalMode.MANUAL_SAVE}) || BuildConfigManager.isPrecompiledDbLoadInvocation((Invocation)invocation) ? (byte)2 : (byte)4;
    }

    protected final void updateMacroZone(VlogIncludingScope includingScope, int index) {
        this.fIncludingScope = includingScope;
        VlogMacroZone prevMacroZone = null;
        VlogFileInstance includingInstance = this.fIncludingScope.getIncludingInstance();
        if (includingInstance != null) {
            prevMacroZone = includingInstance.getCurrMacroZone();
        }
        this.fMacroZones = OptimizedUtils.listAdd(null, (Object)new VlogMacroZone(prevMacroZone));
        if (includingInstance != null) {
            includingInstance.addIncludedFile(this);
        }
        this.fIndex = index;
    }

    private final Object getIncrementalLookupSyncObject() {
        if (this.fIncrBuildMacroLookup == null) {
            this.fIncrBuildMacroLookup = new Object();
        }
        return this.fIncrBuildMacroLookup;
    }

    public final List<String> getIncdirs() {
        return this.fIncdirs;
    }

    public final void setRfProject(RfProject rfProject) {
        this.fRfProject = rfProject;
    }

    public final void setOptimizeSkip() {
        this.fOptimizeSkip = true;
    }

    public final boolean isOptimizeSkip() {
        return this.fOptimizeSkip;
    }

    public final void setIsShallowCompiled(boolean isShallowCompiled) {
        if (isShallowCompiled) {
            this.fCompilationState = (byte)(this.fCompilationState | 1);
        } else if (this.fCompilationState == 1) {
            this.fCompilationState = (byte)(this.fCompilationState | 9);
        }
    }

    public final void setIsIncrementalCompiled() {
        this.fCompilationState = (byte)(this.fCompilationState | 8);
    }

    public final boolean isShallowCompiled() {
        if ((this.fCompilationState & 1) == 1) {
            return true;
        }
        return this.getSemanticScope() != null && this.getSemanticScope().isShallowCompiled();
    }

    public final boolean isIncrementalShallowCompiled() {
        if (this.isShallowCompiled() && (this.fCompilationState & 8) == 8) {
            return true;
        }
        return this.getSemanticScope() != null && this.getSemanticScope().isIncrementalShallowCompiled();
    }

    public final int getInvocNumber() {
        return this.fInvocNumber;
    }

    public final void updateInvocNumber(int precompiledInvocNumber, boolean isAuto, boolean uvmLibWasLoaded, boolean isUvmLibPresent) {
        int updatedInvocationNumber = VlogPrecompiledDBUtils.getCleanupInvocationNumber(precompiledInvocNumber, this.fInvocNumber, isAuto, uvmLibWasLoaded, isUvmLibPresent);
        this.fRfProject.updateInvocationIndexForPath(this.fParserPath, this.fInvocNumber, updatedInvocationNumber);
        this.fInvocNumber = updatedInvocationNumber;
    }

    public void setIndex(int index) {
        this.fIndex = index;
    }

    public void updateIndex(int precompiledLibraryStartIndex) {
        this.fIndex += precompiledLibraryStartIndex;
    }

    public final boolean getAOPSupport() {
        return this.fAOPSupport;
    }

    public final boolean getAMSSupport() {
        return this.fAMSSupport;
    }

    public final boolean getWrealSupport() {
        return this.fWrealSupport;
    }

    public final VlogIncludingScope getIncludingScope() {
        return this.fIncludingScope;
    }

    public IDVTFileInstance getIncludingInstance() {
        if (this.fIncludingScope == null) {
            return null;
        }
        return this.fIncludingScope.getIncludingInstance();
    }

    protected final VlogMacroZone getCurrMacroZone() {
        return this.fMacroZones.get(this.fMacroZones.size() - 1);
    }

    protected final VlogMacroZone getFirstMacroZone() {
        return this.fMacroZones.get(0);
    }

    protected final VlogMacroZone getMacroZoneBeforeIncremental() {
        return this.fMacroZoneBeforeIncremental;
    }

    private final VlogMacroZone getNextMacroZone(VlogFileInstance includedFile) {
        int nofMacroZones = this.fMacroZones.size();
        int i = nofMacroZones - 2;
        while (i >= 0) {
            VlogMacroZone macroZone = this.fMacroZones.get(i);
            if (macroZone.getIncludedFile() == includedFile) {
                return this.fMacroZones.get(i + 1);
            }
            --i;
        }
        return this.fMacroZones.get(nofMacroZones - 1);
    }

    public final String getShortFileName() {
        return this.fShortFileName;
    }

    public final void addIncludedFile(VlogFileInstance includedFile) {
        this.addIncludedFile(includedFile, null);
    }

    public final void addIncludedFile(VlogFileInstance includedFile, Collection<VlogMacroInfo> macroMap) {
        if (includedFile == this) {
            throw new RuntimeException("File '" + this.getParserPath() + "' is included by itself");
        }
        VlogMacroZone currMacroZone = this.getCurrMacroZone();
        currMacroZone.setIncludedFile(includedFile);
        if (macroMap != null) {
            currMacroZone.putAllMacroInfo(macroMap);
        }
        VlogMacroZone nextMacroZone = new VlogMacroZone(includedFile.getCurrMacroZone());
        includedFile.fMacroZones.get(0).setPrevZone(currMacroZone);
        VlogFileInstance includingInstance = this.fIncludingScope.getIncludingInstance();
        if (includingInstance != null) {
            VlogMacroZone nextMacroZoneInIncluding = includingInstance.getNextMacroZone(this);
            nextMacroZoneInIncluding.setPrevZone(nextMacroZone);
        }
        this.fMacroZones.add(nextMacroZone);
    }

    public final void removeIncludedFile(VlogFileInstance includedFile) {
        Iterator<VlogMacroZone> iterator = this.fMacroZones.iterator();
        while (iterator.hasNext()) {
            VlogMacroZone macroZone = iterator.next();
            if (macroZone.getIncludedFile() != includedFile) continue;
            macroZone.setIncludedFile(null);
            if (iterator.hasNext()) {
                macroZone = iterator.next();
                iterator.remove();
            }
            return;
        }
    }

    protected final VlogMacroInfo addAutoDefine(String macroName, VlogMacroText macroText, LineInfo startLine, LineInfo endLine, VlogUtil util) {
        VlogMacroInfo newInfo = VlogMacroInfo.createDefineVlogMacroInfo(this.fRfProject, this, macroName, macroText, startLine, endLine, null);
        this.getFirstMacroZone().putMacroInfo(macroName, newInfo);
        util.putMacroLookupInfo(macroName, newInfo);
        return newInfo;
    }

    protected final VlogMacroInfo addDefine(String macroName, VlogMacroText macroText, LineInfo startLine, LineInfo endLine, ReparseInfo reparseInfo, VlogUtil util) {
        VlogMacroZone currMacroZone = this.getCurrMacroZone();
        VlogMacroInfo oldInfo = currMacroZone.getMacroInfo(macroName);
        VlogMacroInfo newInfo = VlogMacroInfo.createDefineVlogMacroInfo(this.fRfProject, this, macroName, macroText, startLine, endLine, reparseInfo);
        newInfo.setPrevMacroInfo(oldInfo);
        currMacroZone.putMacroInfo(macroName, newInfo);
        if (this.cachedMacroZone == currMacroZone) {
            this.cachedMacroZoneLookupMap.put(macroName, newInfo);
        }
        util.putMacroLookupInfo(macroName, newInfo);
        return newInfo;
    }

    public final void addUndef(String macroName, LineInfo startLine, LineInfo endLine) {
        this.addUndef(macroName, startLine, endLine, null, null);
    }

    protected final void addUndef(String macroName, LineInfo startLine, LineInfo endLine, ReparseInfo reparseInfo, VlogUtil util) {
        VlogMacroZone currMacroZone = this.getCurrMacroZone();
        VlogMacroInfo oldInfo = currMacroZone.getMacroInfo(macroName);
        VlogMacroInfo newInfo = VlogMacroInfo.createUndefVlogMacroInfo(this.fRfProject, this, macroName, startLine, endLine, reparseInfo);
        newInfo.setPrevMacroInfo(oldInfo);
        currMacroZone.putMacroInfo(macroName, newInfo);
        if (this.cachedMacroZone == currMacroZone) {
            this.cachedMacroZoneLookupMap.put(macroName, newInfo);
        }
        if (util != null) {
            util.putMacroLookupInfo(macroName, newInfo);
        }
    }

    public final ParserPath getParserPath() {
        return this.fParserPath;
    }

    public final void setFileName(ParserPath parserPath) {
        if (parserPath == null) {
            return;
        }
        this.fParserPath = parserPath;
        this.fShortFileName = Utils.getInstance().getFileName(parserPath.path);
        this.fIsBuildConfigFileInstance = this.fShortFileName != null && this.fShortFileName.startsWith("__vlog__");
    }

    public final VlogFileInstance getIncludingFileInfo() {
        return this.fIncludingScope.getIncludingInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createIncrBuildMacrosLookupMap() {
        Object object = this.getIncrementalLookupSyncObject();
        synchronized (object) {
            this.cachedMacroZoneLookupMap = new HashMap<String, VlogMacroInfo>();
            this.cachedMacroZone = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeIncrBuildMacrosLookupMap() {
        Object object = this.getIncrementalLookupSyncObject();
        synchronized (object) {
            this.cachedMacroZoneLookupMap = null;
            this.cachedMacroZone = null;
        }
    }

    protected final VlogMacroInfo getDefine(String macroName) {
        VlogMacroZone currMacroZone = this.getCurrMacroZone();
        if (this.cachedMacroZone != currMacroZone) {
            Set visited = Collections.newSetFromMap(new IdentityHashMap());
            HashMap<String, VlogMacroInfo> lookupMap = new HashMap<String, VlogMacroInfo>();
            VlogMacroZone macroZone = currMacroZone;
            while (macroZone != null && !visited.contains(macroZone)) {
                visited.add(macroZone);
                for (VlogMacroInfo macroInfo : macroZone.getMacroInfos()) {
                    if (lookupMap.containsKey(macroInfo.getName())) continue;
                    lookupMap.put(macroInfo.getName(), macroInfo);
                }
                if ((macroZone = macroZone.getPrevZone()) != this.cachedMacroZone) continue;
            }
            this.cachedMacroZone = currMacroZone;
            if (this.cachedMacroZoneLookupMap == null) {
                this.cachedMacroZoneLookupMap = lookupMap;
            } else {
                this.cachedMacroZoneLookupMap.putAll(lookupMap);
            }
        }
        if (this.cachedMacroZoneLookupMap == null) {
            return null;
        }
        VlogMacroInfo macroInfo = this.cachedMacroZoneLookupMap.get(macroName);
        if (macroInfo == null) {
            return null;
        }
        if (macroInfo.isUndef()) {
            return null;
        }
        return macroInfo;
    }

    protected final void prepareForReparse(boolean saveIncludedFilesInfo) {
        this.fSavedIncludedFilesInfo = null;
        if (saveIncludedFilesInfo) {
            this.fSavedIncludedFilesInfo = new LinkedHashSet<VlogFileInstance>(this.fMacroZones.size() - 1);
            int i = 0;
            while (i < this.fMacroZones.size() - 1) {
                VlogFileInstance includedFile = this.fMacroZones.get(i).getIncludedFile();
                if (includedFile != null) {
                    this.fSavedIncludedFilesInfo.add(includedFile);
                }
                ++i;
            }
        }
        VlogMacroZone firstZonePrevZone = this.fMacroZones.get(0).getPrevZone();
        this.fMacroZoneBeforeIncremental = this.fMacroZones.get(0);
        this.fMacroZones.clear();
        VlogMacroZone nextMacroZone = new VlogMacroZone(firstZonePrevZone);
        this.fMacroZones.add(nextMacroZone);
        VlogFileInstance includingInstance = this.fIncludingScope.getIncludingInstance();
        if (includingInstance == this) {
            throw new RuntimeException("File '" + this.getParserPath() + "' is included by itself");
        }
        if (includingInstance != null) {
            VlogMacroZone nextMacroZoneInIncluding = includingInstance.getNextMacroZone(this);
            nextMacroZoneInIncluding.setPrevZone(nextMacroZone);
        }
        this.cleanAllDefaultNettypes();
        this.cleanAllTimescales();
    }

    protected final void restoreIncludedFile(ParserPath parserPath, int line, int offset) {
        if (this.fSavedIncludedFilesInfo == null) {
            return;
        }
        boolean restored = false;
        for (VlogFileInstance includedFile : this.fSavedIncludedFilesInfo) {
            if (!includedFile.getParserPath().equals((Object)parserPath)) continue;
            this.addIncludedFile(includedFile);
            VlogIncludingScope includingScope = includedFile.getIncludingScope();
            if (includingScope != null) {
                includingScope.setIncludingLine(line);
                includingScope.setIncludingOffset(offset);
            }
            this.fSavedIncludedFilesInfo.remove(includedFile);
            restored = true;
            break;
        }
        if (!restored) {
            new VlogFileInstance(this.fRfProject, parserPath, new VlogIncludingScope(this, -1, -1), 0, null, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, (this.fCompilationState & 2) == 2 || (this.fCompilationState & 4) == 4);
        }
        if (this.fSavedIncludedFilesInfo.isEmpty()) {
            this.fSavedIncludedFilesInfo = null;
        }
    }

    protected final boolean isNewIncludedFile(ParserPath parserPath) {
        if (this.fSavedIncludedFilesInfo == null) {
            return true;
        }
        for (VlogFileInstance file : this.fSavedIncludedFilesInfo) {
            if (!file.getParserPath().equals((Object)parserPath)) continue;
            return false;
        }
        return true;
    }

    public final void cleanRemovedIncludedFiles() {
        if (this.fSavedIncludedFilesInfo == null || this.fSavedIncludedFilesInfo.isEmpty()) {
            return;
        }
        if (BuildConfigManager.getPrecompiledDbMode((IProject)this.fRfProject.getProject()).equals((Object)BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD)) {
            PrecompiledDBManager.getInstance().addFileWithIncludesChangedInIncremental(this.getParserPath());
        }
    }

    protected final void clear(boolean restoreFirstMacroZone) {
        int i = 0;
        while (i < this.fMacroZones.size()) {
            this.fMacroZones.get(i).clear();
            ++i;
        }
        if (restoreFirstMacroZone) {
            VlogMacroZone firstMacroZone = this.fMacroZones.get(0);
            this.fMacroZones.clear();
            this.fMacroZones.add(firstMacroZone);
        } else {
            this.fMacroZones.clear();
        }
        this.fSavedIncludedFilesInfo = null;
        this.cleanAllDefaultNettypes();
        this.cleanAllTimescales();
    }

    public final void getDefinesInFile(List<VlogMacroInfo> allDefines) {
        allDefines.addAll(this.fMacroZones.get(0).getMacroInfos());
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            allDefines.addAll(this.fMacroZones.get(i + 1).getMacroInfos());
            ++i;
        }
    }

    public final void getAllDefines(List<VlogMacroInfo> allDefines) {
        VlogFileInstance parent = this.getIncludingFileInfo();
        if (parent != null) {
            parent.internalGetAllDefinesBeforeFile(this, allDefines);
        }
        this.internalGetAllDefinesInFileAndIncludedFiles(allDefines);
    }

    private final void internalGetAllDefinesBeforeFile(VlogFileInstance fileUpTo, List<VlogMacroInfo> allDefines) {
        VlogFileInstance parent = this.getIncludingFileInfo();
        if (parent != null) {
            parent.internalGetAllDefinesBeforeFile(this, allDefines);
        }
        allDefines.addAll(this.fMacroZones.get(0).getMacroInfos());
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            VlogFileInstance file = this.fMacroZones.get(i).getIncludedFile();
            if (file == fileUpTo) break;
            file.internalGetAllDefinesInFileAndIncludedFiles(allDefines);
            allDefines.addAll(this.fMacroZones.get(i + 1).getMacroInfos());
            ++i;
        }
    }

    private final boolean internalGetAllDefinesBeforeFile(VlogFileInstance fileUpTo, IRfMacroVisitor visitor) {
        VlogFileInstance parent = this.getIncludingFileInfo();
        if (parent != null && !parent.internalGetAllDefinesBeforeFile(this, visitor)) {
            return false;
        }
        for (VlogMacroInfo macroInfo : this.fMacroZones.get(0).getMacroInfos()) {
            if (visitor.visit(macroInfo)) continue;
            return false;
        }
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            VlogFileInstance file = this.fMacroZones.get(i).getIncludedFile();
            if (file == fileUpTo) break;
            if (!file.internalGetAllDefinesInFileAndIncludedFiles(visitor)) {
                return false;
            }
            for (VlogMacroInfo macroInfo : this.fMacroZones.get(i + 1).getMacroInfos()) {
                if (visitor.visit(macroInfo)) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    private final void internalGetAllDefinesInFileAndIncludedFiles(List<VlogMacroInfo> allDefines) {
        allDefines.addAll(this.fMacroZones.get(0).getMacroInfos());
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            VlogFileInstance file = this.fMacroZones.get(i).getIncludedFile();
            if (file != null) {
                file.internalGetAllDefinesInFileAndIncludedFiles(allDefines);
            }
            allDefines.addAll(this.fMacroZones.get(i + 1).getMacroInfos());
            ++i;
        }
    }

    private final boolean internalGetAllDefinesInFileAndIncludedFiles(IRfMacroVisitor visitor) {
        VlogMacroZone firstMacroZone = this.fMacroZones.get(0);
        Collection<VlogMacroInfo> macroInfos = firstMacroZone.getMacroInfos();
        for (VlogMacroInfo macroInfo : macroInfos) {
            if (visitor.visit(macroInfo)) continue;
            return false;
        }
        int nofMacroZones = this.fMacroZones.size();
        int i = 0;
        while (i < nofMacroZones - 1) {
            VlogFileInstance file = this.fMacroZones.get(i).getIncludedFile();
            if (file != null && !file.internalGetAllDefinesInFileAndIncludedFiles(visitor)) {
                return false;
            }
            if (nofMacroZones > i + 1) {
                VlogMacroZone vlogMacroZone = this.fMacroZones.get(i + 1);
                macroInfos = vlogMacroZone.getMacroInfos();
                for (VlogMacroInfo macroInfo : macroInfos) {
                    if (visitor.visit(macroInfo)) continue;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public final List<VlogFileInstance> getFileInstances(ParserPath parserPath) {
        ArrayList<VlogFileInstance> fileList = new ArrayList<VlogFileInstance>();
        this.internalGetFileInstances(parserPath, fileList);
        return fileList;
    }

    private final void internalGetFileInstances(ParserPath parserPath, List<VlogFileInstance> fileList) {
        if (this.fParserPath != null && this.fParserPath.equals((Object)parserPath)) {
            fileList.add(this);
        }
        if (this.fMacroZones == null) {
            return;
        }
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            VlogFileInstance includedFile = this.fMacroZones.get(i).getIncludedFile();
            if (includedFile != null) {
                includedFile.internalGetFileInstances(parserPath, fileList);
            }
            ++i;
        }
    }

    protected final VlogFileInstance getFirstFileInstance(ParserPath parserPath) {
        if (this.fParserPath.equals((Object)parserPath)) {
            return this;
        }
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            VlogFileInstance fileInstance;
            VlogFileInstance includedFile = this.fMacroZones.get(i).getIncludedFile();
            if (includedFile != null && (fileInstance = includedFile.getFirstFileInstance(parserPath)) != null) {
                return fileInstance;
            }
            ++i;
        }
        return null;
    }

    @NotNull
    public final List<VlogFileInstance> getIncludedInstances() {
        ArrayList<VlogFileInstance> result = new ArrayList<VlogFileInstance>(this.fMacroZones.size() - 1);
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            VlogFileInstance includedFile = this.fMacroZones.get(i).getIncludedFile();
            if (includedFile != null) {
                result.add(includedFile);
            }
            ++i;
        }
        return result;
    }

    @NotNull
    public final List<DVTPair<VlogMacroZone, VlogFileInstance>> getIncludedInstancesWithMacroZones() {
        ArrayList<DVTPair<VlogMacroZone, VlogFileInstance>> result = new ArrayList<DVTPair<VlogMacroZone, VlogFileInstance>>(this.fMacroZones.size() - 1);
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            VlogMacroZone vlogMacroZone = this.fMacroZones.get(i);
            VlogFileInstance includedFile = vlogMacroZone.getIncludedFile();
            if (includedFile != null) {
                result.add((DVTPair<VlogMacroZone, VlogFileInstance>)new DVTPair((Object)vlogMacroZone, (Object)includedFile));
            }
            ++i;
        }
        return result;
    }

    public final void newLine(int line) {
        if (this.fComments == null) {
            this.fComments = new CommentsTable();
        }
        this.fComments.add(Comment.EMPTY_LINE_INFO, line);
    }

    public final void nextTokenLine(int line) {
        if (this.fComments == null) {
            this.fComments = new CommentsTable();
        }
        this.fComments.add(Comment.CODE_LINE_INFO, line);
    }

    public final void setNofRawLines(int nofRawLines) {
        this.fNofRawLines = nofRawLines;
    }

    public final int getNofRawLines() {
        return this.fNofRawLines;
    }

    protected final void addComment(Comment comment) {
        int line;
        Comment oldComment;
        if (this.fComments == null) {
            this.fComments = new CommentsTable();
        }
        if (!Comment.isComment((Comment)(oldComment = this.fComments.add(comment, line = comment.getEndLine())))) {
            return;
        }
        comment.setProtected(oldComment.isProtected());
    }

    public final CommentsTable getComments() {
        return this.fComments;
    }

    public final RfNamedElement getSemanticScope() {
        return this.fSemanticScope;
    }

    public final void setSemanticScope(RfNamedElement semanticScope) {
        this.fSemanticScope = semanticScope instanceof RfProject ? this.fInitialLibrary : semanticScope;
    }

    public final void cleanAllComments(boolean recursive) {
        if (this.fComments != null) {
            this.fComments.clear();
        }
        this.fComments = null;
        this.fCompactSLEndLine = 0;
        this.fCompactSLStartLine = 0;
        if (!recursive) {
            return;
        }
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            VlogFileInstance includedFile = this.fMacroZones.get(i).getIncludedFile();
            if (includedFile != null) {
                includedFile.cleanAllComments(recursive);
            }
            ++i;
        }
    }

    public final int getIndex() {
        return this.fIndex;
    }

    public final String toString() {
        return "[" + this.fShortFileName + ": " + this.fIndex + "]";
    }

    protected final void addDefaultNettype(int line, String defaultNetTypeValue) {
        if (this.fDefaultNetTypes == null) {
            this.fDefaultNetTypes = new HashMap<Integer, String>();
        }
        defaultNetTypeValue = defaultNetTypeValue.trim();
        this.fDefaultNetTypes.put(line, defaultNetTypeValue);
        this.fDefaultNetTypes.put(Integer.MAX_VALUE, defaultNetTypeValue);
    }

    protected final void addTimescale(int line, String values) {
        int divIndex;
        if (this.fTimescales == null) {
            this.fTimescales = new HashMap<Integer, HidImplicit[]>();
        }
        if ((divIndex = values.indexOf(47)) <= 0) {
            return;
        }
        String timeunit = values.substring(0, divIndex).trim();
        String timeprecision = values.substring(divIndex + 1).trim();
        HidImplicit[] timescale = new HidImplicit[]{RfHidImplicit.makeImplicit(timeunit, 283), RfHidImplicit.makeImplicit(timeprecision, 283)};
        this.fTimescales.put(line, timescale);
        this.fTimescales.put(Integer.MAX_VALUE, timescale);
    }

    protected final void resetTimescale(int line, HidImplicit[] buildConfigTimescale) {
        if (this.fTimescales == null) {
            this.fTimescales = new HashMap<Integer, HidImplicit[]>();
        }
        HidImplicit[] defaultTimescale = buildConfigTimescale != null ? buildConfigTimescale : RfInstanceHolder.DEFAULT_TIMESCALE;
        this.fTimescales.put(line, defaultTimescale);
        this.fTimescales.put(Integer.MAX_VALUE, defaultTimescale);
    }

    public final void cleanAllDefaultNettypes() {
        this.fDefaultNetTypes = null;
    }

    public final void cleanAllTimescales() {
        this.fTimescales = null;
    }

    public final String getDefaultNetType(ParserPath fileName, int line) {
        return this.getDefaultNetTypeWithPartialResult((ParserPath)fileName, (int)line, (DefaultNetTypeResult)new DefaultNetTypeResult()).result;
    }

    private final DefaultNetTypeResult getDefaultNetTypeWithPartialResult(ParserPath fileName, int line, DefaultNetTypeResult partialResult) {
        if (partialResult == null) {
            return null;
        }
        if (partialResult.found) {
            return partialResult;
        }
        boolean isCurrentFile = false;
        if (this.getParserPath().equals((Object)fileName)) {
            isCurrentFile = true;
        }
        int lastDefaultNetTypeLine = -1;
        if (this.fDefaultNetTypes != null && !this.fDefaultNetTypes.isEmpty()) {
            if (isCurrentFile) {
                Set<Integer> keySet = this.fDefaultNetTypes.keySet();
                for (Integer key : keySet) {
                    if (key > line || key <= lastDefaultNetTypeLine) continue;
                    lastDefaultNetTypeLine = key;
                    partialResult.result = this.fDefaultNetTypes.get(key);
                }
            } else {
                partialResult.result = this.fDefaultNetTypes.get(Integer.MAX_VALUE);
            }
        }
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            DefaultNetTypeResult includedResult;
            int includingLine;
            VlogIncludingScope includeScope;
            VlogFileInstance file = this.fMacroZones.get(i).getIncludedFile();
            if (!(file == null || (includeScope = file.getIncludingScope()) == null || lastDefaultNetTypeLine >= (includingLine = includeScope.getIncludingLine()) && includingLine != -1 || isCurrentFile && includingLine >= line || (includedResult = file.getDefaultNetTypeWithPartialResult(fileName, line, partialResult)) == null || includedResult.result == null)) {
                partialResult = includedResult;
            }
            ++i;
        }
        if (isCurrentFile) {
            partialResult.found = true;
        }
        return partialResult;
    }

    public final HidImplicit[] getTimescale(ParserPath fileName, int line) {
        return this.getTimescaleWithPartialResult((ParserPath)fileName, (int)line, (TimescaleResult)new TimescaleResult()).result;
    }

    private final TimescaleResult getTimescaleWithPartialResult(ParserPath fileName, int line, TimescaleResult partialResult) {
        if (partialResult == null) {
            return null;
        }
        if (partialResult.found) {
            return partialResult;
        }
        boolean isCurrentFile = false;
        if (this.getParserPath().equals((Object)fileName)) {
            isCurrentFile = true;
        }
        int lastTimescaleLine = -1;
        if (this.fTimescales != null && !this.fTimescales.isEmpty()) {
            if (isCurrentFile) {
                Set<Integer> keySet = this.fTimescales.keySet();
                for (Integer key : keySet) {
                    if (key > line || key <= lastTimescaleLine) continue;
                    lastTimescaleLine = key;
                    partialResult.result = this.fTimescales.get(key);
                }
            } else {
                partialResult.result = this.fTimescales.get(Integer.MAX_VALUE);
            }
        }
        int i = 0;
        while (i < this.fMacroZones.size() - 1) {
            TimescaleResult includedResult;
            int includingLine;
            VlogIncludingScope includeScope;
            VlogFileInstance file = this.fMacroZones.get(i).getIncludedFile();
            if (!(file == null || (includeScope = file.getIncludingScope()) == null || lastTimescaleLine >= (includingLine = includeScope.getIncludingLine()) && includingLine != -1 || isCurrentFile && includingLine >= line || (includedResult = file.getTimescaleWithPartialResult(fileName, line, partialResult)) == null || includedResult.result == null)) {
                partialResult = includedResult;
            }
            ++i;
        }
        if (isCurrentFile) {
            partialResult.found = true;
        }
        return partialResult;
    }

    public final VlogMacroInfo getMacroBeforeLine(String macroName, int line) {
        VlogMacroZone macroZone = null;
        int i = 0;
        while (i < this.fMacroZones.size()) {
            macroZone = this.fMacroZones.get(i);
            VlogFileInstance includedFile = macroZone.getIncludedFile();
            if (includedFile == null) break;
            VlogIncludingScope includingScope = includedFile.getIncludingScope();
            if (line >= 0 && includingScope != null && includingScope.getIncludingLine() > line) break;
            ++i;
        }
        if (macroZone == null) {
            return null;
        }
        VlogMacroZone firstZoneInFile = this.fMacroZones.get(0);
        Set macroZonesInFile = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.fMacroZones.size())));
        macroZonesInFile.addAll(this.fMacroZones);
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        boolean isLineCheckEnable = true;
        while (!visited.contains(macroZone)) {
            visited.add(macroZone);
            VlogMacroInfo macroInfo = macroZone.getMacroInfo(macroName);
            if (macroInfo != null) {
                if (!isLineCheckEnable) {
                    return macroInfo;
                }
                boolean isMacroInCurrentFile = macroZonesInFile.contains(macroZone);
                if (!isMacroInCurrentFile) {
                    return macroInfo;
                }
                List<VlogMacroInfo> layers = macroInfo.getMacroZoneLayers();
                int i2 = layers.size() - 1;
                while (i2 >= 0) {
                    VlogMacroInfo macroInfoLayer = layers.get(i2);
                    if (macroInfoLayer.getLine() <= line) {
                        return macroInfoLayer;
                    }
                    --i2;
                }
                if (macroZone == firstZoneInFile) {
                    isLineCheckEnable = false;
                }
            }
            if ((macroZone = macroZone.getPrevZone()) != null) continue;
        }
        return null;
    }

    public final void visitMacrosBeforeLine(int line, IRfMacroVisitor visitor) {
        VlogMacroZone macroZone = null;
        int i = 0;
        while (i < this.fMacroZones.size()) {
            macroZone = this.fMacroZones.get(i);
            VlogFileInstance includedFile = macroZone.getIncludedFile();
            if (includedFile == null) break;
            VlogIncludingScope includingScope = includedFile.getIncludingScope();
            if (line >= 0 && includingScope != null && includingScope.getIncludingLine() > line) break;
            ++i;
        }
        if (macroZone == null) {
            return;
        }
        VlogMacroZone firstZoneInFile = this.fMacroZones.get(0);
        Set macroZonesInFile = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.fMacroZones.size())));
        macroZonesInFile.addAll(this.fMacroZones);
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        boolean isLineCheckEnable = true;
        while (!visited.contains(macroZone)) {
            visited.add(macroZone);
            Collection<VlogMacroInfo> macroInfos = macroZone.getMacroInfos();
            if (macroInfos != null && !macroInfos.isEmpty()) {
                for (VlogMacroInfo macroInfo : macroInfos) {
                    if (!isLineCheckEnable) {
                        if (visitor.visit(macroInfo)) continue;
                        return;
                    }
                    boolean isMacroInCurrentFile = macroZonesInFile.contains(macroZone);
                    if (!isMacroInCurrentFile) {
                        if (visitor.visit(macroInfo)) continue;
                        return;
                    }
                    List<VlogMacroInfo> layers = macroInfo.getMacroZoneLayers();
                    int i2 = layers.size() - 1;
                    while (i2 >= 0) {
                        VlogMacroInfo macroInfoLayer = layers.get(i2);
                        if (macroInfoLayer.getLine() <= line && !visitor.visit(macroInfoLayer)) {
                            return;
                        }
                        --i2;
                    }
                }
                if (macroZone == firstZoneInFile) {
                    isLineCheckEnable = false;
                }
            }
            if ((macroZone = macroZone.getPrevZone()) != null) continue;
        }
    }

    public final void addUndeclaredElement(String name) {
        if (this.fUndeclaredElements == null) {
            this.fUndeclaredElements = new ArrayList<String>();
        }
        this.fUndeclaredElements.add(name);
    }

    public final void setVcsModeForMinusY(boolean isVcsModeForMinusY) {
        this.fIsVcsModeForMinusY = isVcsModeForMinusY;
    }

    public final List<String> getUndeclaredElements() {
        return this.fUndeclaredElements;
    }

    public final boolean getIsVcsModeForMinusY() {
        return this.fIsVcsModeForMinusY;
    }

    public final void setLanguageSyntax(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        this.fLanguageSyntax = languageSyntax;
    }

    public final IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return this.fLanguageSyntax;
    }

    @Override
    public final IBuildConfigParserConstants.ToolCompat getToolCompat() {
        return this.fToolCompat;
    }

    public final Map<Integer, String> getDefaultNettypes() {
        return this.fDefaultNetTypes;
    }

    public final Map<Integer, HidImplicit[]> getTimescales() {
        return this.fTimescales;
    }

    public void cleanMacroZoneBeforeIncremental() {
        if (this.fMacroZoneBeforeIncremental != null) {
            this.fMacroZoneBeforeIncremental.clear();
        }
        this.fMacroZoneBeforeIncremental = null;
    }

    public final void deepClean() {
        this.fParserPath = null;
        if (this.fMacroZones != null) {
            List<VlogMacroZone> macroZones = this.fMacroZones;
            this.fMacroZones = null;
            for (VlogMacroZone macroZone : macroZones) {
                macroZone.deepClean();
            }
        }
        this.cleanMacroZoneBeforeIncremental();
        if (this.fDefaultNetTypes != null) {
            this.fDefaultNetTypes.clear();
        }
        this.fDefaultNetTypes = null;
        if (this.fTimescales != null) {
            this.fTimescales.clear();
        }
        this.fTimescales = null;
        this.fSemanticScope = null;
        this.fShortFileName = null;
        if (this.fIncludingScope != null) {
            VlogIncludingScope includingScope = this.fIncludingScope;
            this.fIncludingScope = null;
            includingScope.deepClean();
        }
        this.fRfProject = null;
        if (this.fUndeclaredElements != null) {
            this.fUndeclaredElements.clear();
        }
        this.fUndeclaredElements = null;
        if (this.fIncdirs != null) {
            this.fIncdirs.clear();
        }
        this.fIncdirs = null;
        if (this.fSavedIncludedFilesInfo != null) {
            Set<VlogFileInstance> savedIncludedFilesInfo = this.fSavedIncludedFilesInfo;
            this.fSavedIncludedFilesInfo = null;
            for (VlogFileInstance fileInstance : savedIncludedFilesInfo) {
                fileInstance.deepClean();
            }
        }
        this.fComments = null;
    }

    public final void clean() {
        this.fMacroZones.clear();
        VlogFileInstance includingInstance = this.fIncludingScope.getIncludingInstance();
        if (includingInstance != null) {
            includingInstance.removeIncludedFile(this);
        }
        this.fRfProject = null;
        this.fIncdirs = null;
    }

    public final boolean visitMacros(IRfMacroVisitor visitor) {
        VlogFileInstance parent = this.getIncludingFileInfo();
        if (parent != null && !parent.internalGetAllDefinesBeforeFile(this, visitor)) {
            return false;
        }
        return this.internalGetAllDefinesInFileAndIncludedFiles(visitor);
    }

    public final void visitInstances(IRfFileInstanceVisitor visitor) throws Exception {
        visitor.preVisit(this);
        if (!visitor.visit(this)) {
            return;
        }
        List<VlogFileInstance> includedInstances = this.getIncludedInstances();
        for (VlogFileInstance includedInstance : includedInstances) {
            if (includedInstance == null) continue;
            includedInstance.visitInstances(visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public final VlogMacroInfo getSimpleDefine(String macroName) {
        return this.getDefine(macroName);
    }

    public final void endDefElement(IRfDefElement defElement) {
        if (this.fRfProject == null) {
            return;
        }
        if (defElement == null || this.fComments == null) {
            return;
        }
        int i = defElement.getStartLine() + 1;
        while (i < defElement.getEndLine()) {
            Comment comment = this.fComments.get(i);
            if (Comment.isComment((Comment)comment)) {
                this.fComments.remove(i);
            }
            ++i;
        }
    }

    public final void addCustomPragma(CustomPragmaUsage pragma) {
        this.fCustomPragmas = OptimizedUtils.listAdd(this.fCustomPragmas, (Object)pragma);
    }

    public final List<CustomPragmaUsage> getCustomPragmas() {
        if (this.fCustomPragmas == null) {
            return Collections.emptyList();
        }
        return this.fCustomPragmas;
    }

    public final void setCustomPragmas(List<CustomPragmaUsage> pragmas) {
        this.fCustomPragmas = OptimizedUtils.listAdd(this.fCustomPragmas, pragmas);
    }

    public final void cleanCustomPragmas() {
        if (this.fCustomPragmas == null) {
            return;
        }
        this.fCustomPragmas.clear();
        this.fCustomPragmas = Collections.emptyList();
    }

    public final boolean isBuildConfigFileInstance() {
        return this.fIsBuildConfigFileInstance;
    }

    public boolean isInstanceInScope(IRfNamedElement instance) {
        if (instance == null) {
            return false;
        }
        if (instance == this.fSemanticScope) {
            return true;
        }
        IRfScopeElement scope = instance.getEnclosingScope();
        while (scope != null) {
            if (scope == this.fSemanticScope) {
                return true;
            }
            scope = scope.getEnclosingScope();
        }
        if (this.fSemanticScope == null) {
            return false;
        }
        scope = this.fSemanticScope.getEnclosingScope();
        while (scope != null) {
            if (scope == instance.getEnclosingScope() || scope == instance) {
                return true;
            }
            scope = scope.getEnclosingScope();
        }
        return false;
    }

    public boolean isValid() {
        return this.fSemanticScope != null;
    }

    protected ParserPath getIncludedFile(String fileSuffix) {
        if (this.fSavedIncludedFilesInfo == null) {
            return null;
        }
        for (VlogFileInstance file : this.fSavedIncludedFilesInfo) {
            if (!file.getParserPath().path.endsWith(fileSuffix)) continue;
            return file.getParserPath();
        }
        return null;
    }

    public final boolean isPrecompiledDbFile() {
        return this.isPrecompiledDbManualFile() || this.isPrecompiledDbAutoFile();
    }

    public final boolean isPrecompiledDbManualFile() {
        if ((this.fCompilationState & 8) == 8) {
            return false;
        }
        return (this.fCompilationState & 2) == 2 && !BuildConfigManager.isPrecompiledDbSaveMode((IProject)this.fRfProject.getProject());
    }

    public final boolean isPrecompiledDbAutoFile() {
        if ((this.fCompilationState & 8) == 8) {
            return false;
        }
        return (this.fCompilationState & 4) == 4 && !BuildConfigManager.isPrecompiledDbSaveMode((IProject)this.fRfProject.getProject());
    }

    public void setIncludingInstance(VlogFileInstance includingFileInstance) {
        this.fIncludingScope.setIncludingInstance(includingFileInstance);
    }

    public void clearAllMacroZoneIndices() {
        this.getCurrMacroZone().clearAllPreviousIndices();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PrecompiledAutoDebugUtils.INSTANCE.objectWritten((Object)this);
    }

    private static class DefaultNetTypeResult {
        String result;
        boolean found;

        private DefaultNetTypeResult() {
        }
    }

    private static class TimescaleResult {
        HidImplicit[] result;
        boolean found;

        private TimescaleResult() {
        }
    }
}

