/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import antlr.ANTLRHashString;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.CharScanner;
import antlr.CharStreamException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.MismatchedCharException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.impl.BitSet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.encrypted.EncryptedUtils;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.custompragma.TranslatePragma;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.FileInputStreamUtils;
import ro.amiq.dvt.utils.MD5InputStream;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.expr.ExprEval;
import ro.amiq.dvt.utils.expr.IExprValueProvider;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.DVTLexerStack;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.model.reflection.RfNonStandardProblem;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.parser.CompilerDirectiveKind;
import ro.amiq.vlogdt.parser.DVTCustomToken;
import ro.amiq.vlogdt.parser.EncryptedPragmaInfo;
import ro.amiq.vlogdt.parser.LibrarySpecPath;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogLexerTokenTypes;
import ro.amiq.vlogdt.parser.VlogLexersStack;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroParameter;
import ro.amiq.vlogdt.parser.VlogMacroText;
import ro.amiq.vlogdt.parser.VlogSkipInfo;
import ro.amiq.vlogdt.parser.VlogUtil;

public class VlogLexer
extends CharScanner
implements VlogLexerTokenTypes,
TokenStream {
    protected static final Map<String, List<String>> BEGIN_TO_END_WORDS_MAP = new ImmutableMap.Builder().put((Object)"`ifdef", Arrays.asList("`endif", "`else", "`elsif")).put((Object)"`ifndef", Arrays.asList("`endif", "`else", "`elsif")).put((Object)"`elsif", Arrays.asList("`endif", "`else", "`elsif")).put((Object)"`else", Arrays.asList("`endif")).build();
    protected static final Map<String, CompilerDirectiveKind> COMPILER_DIRECTIVES = new ImmutableMap.Builder().put((Object)"delay_mode_distributed", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"delay_mode_path", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"delay_mode_unit", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"delay_mode_zero", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"default_trireg_strength", (Object)CompilerDirectiveKind.NUMBER_ARG).put((Object)"suppress_faults", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"enable_portfaults", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"disable_portfaults", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"nosuppress_faults", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"begin_faultfree", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"end_faultfree", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"default_discipline", (Object)CompilerDirectiveKind.ID_ARG).put((Object)"default_transition", (Object)CompilerDirectiveKind.NUMBER_ARG).put((Object)"rs_technology", (Object)CompilerDirectiveKind.ID_ARG).put((Object)"uselib", (Object)CompilerDirectiveKind.ID_ARG).put((Object)"nouselib", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"worklib", (Object)CompilerDirectiveKind.ID_ARG).put((Object)"noworklib", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"view", (Object)CompilerDirectiveKind.ID_ARG).put((Object)"noview", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"accelerate", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"autoexpand_vectornets", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"expand_vectornets", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"noaccelerate", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"noexpand_vectornets", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"noremove_gatenames", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"noremove_netnames", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"remove_gatenames", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"remove_netnames", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"vcs_mipdexpand", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"vcs_mipdnoexpand", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"noportcoerce", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"portcoerce", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"protect128", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"endprotect128", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"race", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"endrace", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"inline", (Object)CompilerDirectiveKind.NO_ARG).put((Object)"noinline", (Object)CompilerDirectiveKind.NO_ARG).build();
    protected static final Set<String> PSL_SPECIAL_KEYWORDS = new ImmutableSet.Builder().add((Object)"restrict").add((Object)"eventually").add((Object)"until").add((Object)"before").add((Object)"X").add((Object)"next").add((Object)"next_a").add((Object)"next_e").add((Object)"next_event_a").add((Object)"next_event_e").build();
    protected static final Set<String> WREAL_MACROS = new ImmutableSet.Builder().add((Object)"wrealXState").add((Object)"wrealZState").build();
    protected static final int IFDEF = 1;
    protected static final int ELSIF = 2;
    protected static final int ELSE = 3;
    private RfProject rfp;
    private boolean isEncrypted;
    protected VlogLexersStack lS;
    protected boolean loading;
    protected boolean followImports = true;
    protected boolean mustGenerateIncrementalInclude = false;
    protected IBuildConfigParserConstants.LanguageSyntax defaultLanguageSyntax = VlogUtil.getDefaultLanguageSyntax();
    protected VlogUtil util;
    protected ParserPath parserPath;
    protected int fileIndex;
    protected boolean isPVlogPreprocessing;
    protected String reparseMacroName;
    protected VlogMacroInfo reparseMacro;
    protected String[] reparseMacroParameters;
    protected String[] reparseMacroUnprocessedParameters;
    protected ParserPath reparseFileName;
    protected int reparseFileLine;
    protected VirtualOffset virtualOffset;
    protected boolean skipElseBranch;
    protected int preprocessingType;
    protected int preprocessingLine;
    protected String preprocessingFile;
    protected String ifdefID;
    protected boolean ifndefGuard;
    protected IIdentifierIndexerExtension indexer;
    protected int kind = 0;
    protected ReparseInfo.ReparseElement[] fReparseStack = new ReparseInfo.ReparseElement[0];
    protected VlogLexer parentLexer;
    protected boolean disableUponEof;
    protected InputStream inputStream;
    protected Reader reader;
    private boolean lockLineNumber = false;
    private boolean macroTraceIgnore = false;
    private boolean startFileDef = false;
    private boolean newIncludedFile = false;
    public static final BitSet _tokenSet_0 = new BitSet(VlogLexer.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(VlogLexer.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(VlogLexer.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(VlogLexer.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(VlogLexer.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(VlogLexer.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(VlogLexer.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(VlogLexer.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(VlogLexer.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(VlogLexer.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(VlogLexer.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(VlogLexer.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(VlogLexer.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(VlogLexer.mk_tokenSet_13());
    public static final BitSet _tokenSet_14 = new BitSet(VlogLexer.mk_tokenSet_14());
    public static final BitSet _tokenSet_15 = new BitSet(VlogLexer.mk_tokenSet_15());
    public static final BitSet _tokenSet_16 = new BitSet(VlogLexer.mk_tokenSet_16());
    public static final BitSet _tokenSet_17 = new BitSet(VlogLexer.mk_tokenSet_17());
    public static final BitSet _tokenSet_18 = new BitSet(VlogLexer.mk_tokenSet_18());
    public static final BitSet _tokenSet_19 = new BitSet(VlogLexer.mk_tokenSet_19());
    public static final BitSet _tokenSet_20 = new BitSet(VlogLexer.mk_tokenSet_20());
    public static final BitSet _tokenSet_21 = new BitSet(VlogLexer.mk_tokenSet_21());
    public static final BitSet _tokenSet_22 = new BitSet(VlogLexer.mk_tokenSet_22());
    public static final BitSet _tokenSet_23 = new BitSet(VlogLexer.mk_tokenSet_23());
    public static final BitSet _tokenSet_24 = new BitSet(VlogLexer.mk_tokenSet_24());
    public static final BitSet _tokenSet_25 = new BitSet(VlogLexer.mk_tokenSet_25());
    public static final BitSet _tokenSet_26 = new BitSet(VlogLexer.mk_tokenSet_26());
    public static final BitSet _tokenSet_27 = new BitSet(VlogLexer.mk_tokenSet_27());
    public static final BitSet _tokenSet_28 = new BitSet(VlogLexer.mk_tokenSet_28());
    public static final BitSet _tokenSet_29 = new BitSet(VlogLexer.mk_tokenSet_29());
    public static final BitSet _tokenSet_30 = new BitSet(VlogLexer.mk_tokenSet_30());
    public static final BitSet _tokenSet_31 = new BitSet(VlogLexer.mk_tokenSet_31());
    public static final BitSet _tokenSet_32 = new BitSet(VlogLexer.mk_tokenSet_32());
    public static final BitSet _tokenSet_33 = new BitSet(VlogLexer.mk_tokenSet_33());
    public static final BitSet _tokenSet_34 = new BitSet(VlogLexer.mk_tokenSet_34());
    public static final BitSet _tokenSet_35 = new BitSet(VlogLexer.mk_tokenSet_35());
    public static final BitSet _tokenSet_36 = new BitSet(VlogLexer.mk_tokenSet_36());
    public static final BitSet _tokenSet_37 = new BitSet(VlogLexer.mk_tokenSet_37());
    public static final BitSet _tokenSet_38 = new BitSet(VlogLexer.mk_tokenSet_38());
    public static final BitSet _tokenSet_39 = new BitSet(VlogLexer.mk_tokenSet_39());
    public static final BitSet _tokenSet_40 = new BitSet(VlogLexer.mk_tokenSet_40());
    public static final BitSet _tokenSet_41 = new BitSet(VlogLexer.mk_tokenSet_41());
    public static final BitSet _tokenSet_42 = new BitSet(VlogLexer.mk_tokenSet_42());
    public static final BitSet _tokenSet_43 = new BitSet(VlogLexer.mk_tokenSet_43());
    public static final BitSet _tokenSet_44 = new BitSet(VlogLexer.mk_tokenSet_44());
    public static final BitSet _tokenSet_45 = new BitSet(VlogLexer.mk_tokenSet_45());
    public static final BitSet _tokenSet_46 = new BitSet(VlogLexer.mk_tokenSet_46());
    public static final BitSet _tokenSet_47 = new BitSet(VlogLexer.mk_tokenSet_47());
    public static final BitSet _tokenSet_48 = new BitSet(VlogLexer.mk_tokenSet_48());
    public static final BitSet _tokenSet_49 = new BitSet(VlogLexer.mk_tokenSet_49());
    public static final BitSet _tokenSet_50 = new BitSet(VlogLexer.mk_tokenSet_50());
    public static final BitSet _tokenSet_51 = new BitSet(VlogLexer.mk_tokenSet_51());
    public static final BitSet _tokenSet_52 = new BitSet(VlogLexer.mk_tokenSet_52());
    public static final BitSet _tokenSet_53 = new BitSet(VlogLexer.mk_tokenSet_53());
    public static final BitSet _tokenSet_54 = new BitSet(VlogLexer.mk_tokenSet_54());
    public static final BitSet _tokenSet_55 = new BitSet(VlogLexer.mk_tokenSet_55());
    public static final BitSet _tokenSet_56 = new BitSet(VlogLexer.mk_tokenSet_56());
    public static final BitSet _tokenSet_57 = new BitSet(VlogLexer.mk_tokenSet_57());
    public static final BitSet _tokenSet_58 = new BitSet(VlogLexer.mk_tokenSet_58());
    public static final BitSet _tokenSet_59 = new BitSet(VlogLexer.mk_tokenSet_59());
    public static final BitSet _tokenSet_60 = new BitSet(VlogLexer.mk_tokenSet_60());
    public static final BitSet _tokenSet_61 = new BitSet(VlogLexer.mk_tokenSet_61());
    public static final BitSet _tokenSet_62 = new BitSet(VlogLexer.mk_tokenSet_62());
    public static final BitSet _tokenSet_63 = new BitSet(VlogLexer.mk_tokenSet_63());
    public static final BitSet _tokenSet_64 = new BitSet(VlogLexer.mk_tokenSet_64());
    public static final BitSet _tokenSet_65 = new BitSet(VlogLexer.mk_tokenSet_65());
    public static final BitSet _tokenSet_66 = new BitSet(VlogLexer.mk_tokenSet_66());
    public static final BitSet _tokenSet_67 = new BitSet(VlogLexer.mk_tokenSet_67());
    public static final BitSet _tokenSet_68 = new BitSet(VlogLexer.mk_tokenSet_68());
    public static final BitSet _tokenSet_69 = new BitSet(VlogLexer.mk_tokenSet_69());
    public static final BitSet _tokenSet_70 = new BitSet(VlogLexer.mk_tokenSet_70());
    public static final BitSet _tokenSet_71 = new BitSet(VlogLexer.mk_tokenSet_71());
    public static final BitSet _tokenSet_72 = new BitSet(VlogLexer.mk_tokenSet_72());
    public static final BitSet _tokenSet_73 = new BitSet(VlogLexer.mk_tokenSet_73());
    public static final BitSet _tokenSet_74 = new BitSet(VlogLexer.mk_tokenSet_74());
    public static final BitSet _tokenSet_75 = new BitSet(VlogLexer.mk_tokenSet_75());

    protected void setRfProject(RfProject project) {
        this.rfp = project;
    }

    public VlogLexersStack getLexerStack() {
        return this.lS;
    }

    public String getReparseMacroName() {
        return this.reparseMacroName;
    }

    public String[] getReparseMacroParameters() {
        return this.reparseMacroParameters;
    }

    public void setTokenObjectClass(String cl) {
        this.tokenObjectClass = DVTCustomToken.class;
    }

    public void reportError(RecognitionException ex) {
        this.reportError("*** Error: ", ex.getFilename(), ex.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
    }

    protected void reportError(String severity, String fileName, int line, int offset, int length, String message) {
        this.reportError(severity, fileName, line, offset, length, message, null);
    }

    protected void reportError(String severity, String fileName, int line, int offset, int length, String message, ReparseInfo reparseInfo) {
        this.reportError(severity, fileName, line, offset, length, message, reparseInfo, null);
    }

    protected void reportError(String severity, String fileName, int line, int offset, int length, String message, ReparseInfo reparseInfo, Map<String, Object> attributes) {
        if (this.lS == null || this.lS.isSkip()) {
            return;
        }
        this.lS.reportErrorLT(severity, fileName, this.getLanguageSyntax(), line, reparseInfo == null && !this.isMacroReparsing() ? offset : -1, length, message, this.fileIndex, reparseInfo, attributes);
    }

    public int getOffset() {
        int offset = super.getOffset();
        if (this.isPVlogPreprocessingOutsideMacro()) {
            return this.util.getPVlogCompilationOffset(this.parserPath, offset);
        }
        return offset;
    }

    public int getLine() {
        int pvlogCompilationLine;
        if (this.isPVlogPreprocessingOutsideMacro() && (pvlogCompilationLine = this.util.getPVlogCompilationLine(this.parserPath, this.getOffset())) > 0) {
            return pvlogCompilationLine;
        }
        return super.getLine();
    }

    private boolean isPVlogPreprocessingOutsideMacro() {
        return this.isPVlogPreprocessing && !this.isMacroReparsing();
    }

    public final void uponEOF() throws TokenStreamException, CharStreamException {
        if (this.disableUponEof) {
            return;
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (this.lS != null) {
            this.util.debug("Lexing done!");
            this.lS.pop();
            if (this.preprocessingType != 0 && this.isMacroReparsing()) {
                this.continueIFDEFLexingOutsideMacro();
            }
            this.lS.removeSkipDefine(this);
            if (!this.followImports) {
                this.util.endNewIncludedFile();
            }
            if (this.indexer != null && this.lS.peek() != null) {
                this.indexer.startFile(this.lS.peek().getFilename(), false);
            }
        }
    }

    protected boolean isID(String name) {
        if (name == null) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isWhitespace(c)) {
                return false;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || i > 0 && c >= '0' && c <= '9')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final void newline() {
        if (!this.lockLineNumber) {
            super.newline();
            this.util.newLine(this.getLine());
        } else {
            ++this.reparseFileLine;
        }
    }

    public final void incOffset() {
        if (!this.lockLineNumber) {
            super.incOffset();
        } else if (this.virtualOffset != null) {
            ++this.virtualOffset.offset;
        }
    }

    public final void incColumn() {
        if (!this.lockLineNumber) {
            super.incColumn();
        }
    }

    protected final void setLockLine(int line, int offset, int column) {
        this.lockLineNumber = true;
        this.setLine(line);
        this.setOffset(offset);
        this.setColumn(column);
    }

    protected void setMacroTraceIgnore() {
        this.macroTraceIgnore = true;
    }

    protected boolean getMacroTraceIgnore() {
        return this.macroTraceIgnore;
    }

    protected boolean isMacroReparsing() {
        return this.lockLineNumber;
    }

    public void setTabSize(int size) {
        DVTLogger.INSTANCE.logError("setTabSize() is not called in all the constructors so we override tab()");
        throw new RuntimeException("setTabSize() is not called in all the constructors so we override tab()");
    }

    public void tab() {
        int c = this.getColumn();
        this.setColumn(c + 1);
    }

    protected VlogLexer(Reader in, Map<ANTLRHashString, Integer> literals) {
        super(new LexerSharedInputState((InputBuffer)new CharBuffer(in)));
        this.reader = in;
        this.caseSensitiveLiterals = true;
        this.setCaseSensitive(true);
        this.literals = literals;
    }

    protected VlogLexer(InputStream in, Map<ANTLRHashString, Integer> literals) {
        this(new InputStreamReader(in), literals);
        this.inputStream = in;
    }

    public VlogLexer(LexerSharedInputState state, Map<ANTLRHashString, Integer> literals) {
        super(state);
        this.caseSensitiveLiterals = true;
        this.setCaseSensitive(true);
        this.literals = literals;
    }

    public final int testLiteralsTable(int ttype) {
        int ttypePrev = ttype;
        this.hashString.setBuffer(this.text.getBuffer(), this.text.length());
        Integer literalsIndex = (Integer)this.literals.get(this.hashString);
        if (literalsIndex != null) {
            int length;
            IBuildConfigParserConstants.LanguageSyntax languageSyntax = this.getLanguageSyntax();
            Set<String> kewordsSet = this.util.getRemovedKeywordsSet(languageSyntax);
            String identifier = this.text.toString();
            if (kewordsSet == null || !kewordsSet.contains(identifier)) {
                ttype = literalsIndex;
            }
            if (ttypePrev != ttype && this.indexer != null && this._returnToken != null && !this.isMacroReparsing()) {
                this.indexer.index2(this._returnToken.getText(), this._returnToken.getLine(), this._returnToken.getColumn(), this._returnToken.getType(), true, this.lS.isSkip(), false);
            }
            if (((length = identifier.length()) == 8 || length == 12) && identifier.startsWith("rand")) {
                if (length == 8 && identifier.endsWith("case")) {
                    this.notAllowed(6);
                } else if (length == 12 && identifier.endsWith("sequence")) {
                    this.notAllowed(7);
                }
            }
        }
        return ttype;
    }

    protected IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        if (this.util.fCurrentLanguageSyntax.isEmpty()) {
            return this.defaultLanguageSyntax;
        }
        return this.util.fCurrentLanguageSyntax.peek();
    }

    protected IBuildConfigParserConstants.LanguageSyntax getOverriddenLanguageSyntax() {
        return this.util.fCurrentLanguageSyntax.peek();
    }

    private String grabEncryptedData() throws MismatchedCharException, CharStreamException {
        char la1 = this.LA(1);
        StringBuilder str = new StringBuilder();
        boolean hasEncryptedCodeSupport = this.lS.hasEncryptedCodeSupport();
        while (!(la1 == '\uffff' || la1 == '/' && this.LA(2) == '/' || la1 == '`' && this.LA(2) == 'p' && this.LA(3) == 'r' && this.LA(4) == 'a' && this.LA(5) == 'g' && this.LA(6) == 'm' && this.LA(7) == 'a')) {
            if (hasEncryptedCodeSupport) {
                str.append(la1);
            }
            if (la1 == '\r') {
                this.newline();
                if (this.LA(2) == '\n') {
                    this.consume();
                }
            } else if (la1 == '\n') {
                this.newline();
            }
            this.consume();
            la1 = this.LA(1);
        }
        return str.toString();
    }

    private String grabProtectedData(String endWord) throws MismatchedCharException, CharStreamException {
        int length = 0;
        char la1 = this.LA(1);
        StringBuilder str = new StringBuilder();
        boolean hasEncryptedCodeSupport = this.lS.hasEncryptedCodeSupport();
        while (la1 != '\uffff') {
            if (hasEncryptedCodeSupport) {
                str.append(la1);
            }
            if (length == endWord.length() && Character.isWhitespace((int)la1)) {
                return str.toString();
            }
            if (la1 == '\r') {
                this.newline();
                if (this.LA(2) == '\n') {
                    this.consume();
                }
                if (length == endWord.length()) {
                    this.consume();
                    return str.toString();
                }
            } else if (la1 == '\n') {
                this.newline();
                if (length == endWord.length()) {
                    this.consume();
                    return str.toString();
                }
            } else {
                length = length < endWord.length() && la1 == endWord.charAt(length) ? ++length : 0;
            }
            this.consume();
            la1 = this.LA(1);
        }
        return str.toString();
    }

    public Object[] findFileInRelativePath(String fileName) {
        Object[] result = new Object[3];
        File file = null;
        String fullFileName = null;
        boolean fileExists = false;
        ParserPath existingIncludingFile = this.util.getIncludedFile(fileName);
        if (existingIncludingFile != null) {
            file = new File(existingIncludingFile.path);
            fileExists = this.util.isFile(file);
            fullFileName = existingIncludingFile.path;
        } else {
            if (this.util.getToolCompat() == IBuildConfigParserConstants.ToolCompat.QUESTA_VLOG || this.util.getToolCompat() == IBuildConfigParserConstants.ToolCompat.QUESTA_QRUN) {
                fullFileName = String.valueOf(new File(this.parserPath.path).getParent()) + File.separator + fileName;
                fullFileName = this.util.getCrossPlatformPath(fullFileName);
                fullFileName = this.util.getFileSubstitute(fullFileName);
                file = new File(fullFileName);
                fileExists = this.util.isFile(file);
            }
            if (!fileExists) {
                List<String> incdirs = this.util.getIncdirs();
                int i = 0;
                while (i < incdirs.size()) {
                    fullFileName = String.valueOf(incdirs.get(i)) + fileName;
                    fullFileName = this.util.getCrossPlatformPath(fullFileName);
                    file = new File(fullFileName = this.util.getFileSubstitute(fullFileName));
                    fileExists = this.util.isFile(file);
                    if (fileExists) break;
                    ++i;
                }
            }
        }
        result[0] = file;
        result[1] = fullFileName;
        result[2] = fileExists;
        return result;
    }

    private void consumeTokensUntilEndif(String beginWord, int nestedLevel, IBuildConfigParserConstants.LanguageSyntax languageSyntax, Stack<VlogLexer> macroReparsingLexerStack) throws MismatchedCharException, CharStreamException {
        char la1 = this.lS.peek().LA(1);
        int currentLine = this.lS.peek().getLine();
        int currentColumn = this.lS.peek().getColumn();
        StringBuilder tokenBuffer = new StringBuilder();
        boolean isInsideMacroDefinition = false;
        int nestedPreprocInsideMacroDefinition = 0;
        boolean isMacroRelatedToBeginWord = false;
        if (nestedLevel > 1) {
            isMacroRelatedToBeginWord = true;
        }
        List<String> endWords = BEGIN_TO_END_WORDS_MAP.getOrDefault(beginWord, Collections.emptyList());
        while (true) {
            if (la1 != '\uffff') {
                if (la1 == '`') {
                    this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
                    MatchedWordInfo matchedWord = this.lookAheadMatches(endWords, nestedLevel, tokenBuffer, isInsideMacroDefinition, nestedPreprocInsideMacroDefinition);
                    if (matchedWord.isEndWord()) {
                        tokenBuffer.setLength(0);
                        if (nestedLevel > 1 && matchedWord.getMatchedWord().equals("`endif") || nestedLevel == 1) {
                            if (!isInsideMacroDefinition || isInsideMacroDefinition && nestedPreprocInsideMacroDefinition == 0) {
                                return;
                            }
                            if (matchedWord.getMatchedWord().equals("`endif") && isInsideMacroDefinition && nestedPreprocInsideMacroDefinition > 0) {
                                --nestedPreprocInsideMacroDefinition;
                            }
                        }
                        la1 = this.lS.peek().LA(1);
                        currentLine = this.lS.peek().getLine();
                        currentColumn = this.lS.peek().getColumn();
                        continue;
                    }
                    if (matchedWord.isBeginWord()) {
                        if (!isInsideMacroDefinition) {
                            this.lS.peek().consumeTokensUntilEndif(matchedWord.getMatchedWord(), nestedLevel + 1, languageSyntax, macroReparsingLexerStack);
                            tokenBuffer.setLength(0);
                        } else {
                            ++nestedPreprocInsideMacroDefinition;
                            this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
                        }
                    } else {
                        if (tokenBuffer.toString().equals("define")) {
                            isInsideMacroDefinition = true;
                            nestedPreprocInsideMacroDefinition = 0;
                        }
                        this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
                    }
                    la1 = this.lS.peek().LA(1);
                    currentLine = this.lS.peek().getLine();
                    currentColumn = this.lS.peek().getColumn();
                    isMacroRelatedToBeginWord = false;
                    continue;
                }
                if (la1 == '/') {
                    String firstIdentifier;
                    String comment;
                    String rawComment;
                    StringBuilder commentText;
                    int startOffset;
                    int startLine;
                    char la2 = this.lS.peek().LA(2);
                    if (la2 == '/') {
                        this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
                        this.lS.peek().consume();
                        this.lS.peek().consume();
                        startLine = this.lS.peek().getLine();
                        startOffset = this.getOffset();
                        commentText = new StringBuilder();
                        la1 = this.lS.peek().LA(1);
                        while (la1 != '\n' && la1 != '\r' && la1 != '\uffff') {
                            commentText.append(la1);
                            this.lS.peek().consume();
                            la1 = this.lS.peek().LA(1);
                        }
                        rawComment = commentText.toString();
                        comment = this.getTrimmedText(rawComment, new int[]{startOffset, this.getOffset()});
                        firstIdentifier = this.getFirstIdentifier(comment);
                        this.util.collectTaskTag(firstIdentifier, comment, startLine, startOffset, this.getOffset(), this.parserPath);
                        la1 = this.lS.peek().LA(1);
                        currentLine = this.lS.peek().getLine();
                        currentColumn = this.lS.peek().getColumn();
                        isMacroRelatedToBeginWord = false;
                        continue;
                    }
                    if (la2 == '*') {
                        this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
                        this.lS.peek().consume();
                        this.lS.peek().consume();
                        startLine = this.lS.peek().getLine();
                        startOffset = this.getOffset();
                        la1 = this.lS.peek().LA(1);
                        commentText = new StringBuilder();
                        while (la1 != '\uffff') {
                            if (la1 == '*' && this.lS.peek().LA(2) == '/') {
                                this.lS.peek().consume();
                                this.lS.peek().consume();
                                break;
                            }
                            commentText.append(la1);
                            if (la1 == '\r' || la1 == '\n') {
                                if (la1 == '\r' && this.lS.peek().LA(2) == '\n') {
                                    this.lS.peek().consume();
                                }
                                this.lS.peek().newline();
                            }
                            this.lS.peek().consume();
                            la1 = this.lS.peek().LA(1);
                        }
                        rawComment = commentText.toString();
                        comment = this.getTrimmedText(rawComment, new int[]{startOffset, this.getOffset() - 2});
                        firstIdentifier = this.getFirstIdentifier(comment);
                        this.util.collectTaskTag(firstIdentifier, comment, startLine, startOffset, this.getOffset() - 2, this.parserPath);
                        la1 = this.lS.peek().LA(1);
                        currentLine = this.lS.peek().getLine();
                        currentColumn = this.lS.peek().getColumn();
                        isMacroRelatedToBeginWord = false;
                        continue;
                    }
                }
                if (la1 == '\"') {
                    this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
                    this.lS.peek().consume();
                    la1 = this.lS.peek().LA(1);
                    while (la1 != '\"' && la1 != '\r' && la1 != '\n' && la1 != '\uffff') {
                        if (la1 == '\\') {
                            this.lS.peek().consume();
                            la1 = this.lS.peek().LA(1);
                            if (la1 == '\r' || la1 == '\n') {
                                if (la1 == '\r') {
                                    this.lS.peek().consume();
                                    la1 = this.lS.peek().LA(1);
                                    if (la1 == '\n') {
                                        this.lS.peek().consume();
                                        la1 = this.lS.peek().LA(1);
                                    }
                                } else {
                                    this.lS.peek().consume();
                                    la1 = this.lS.peek().LA(1);
                                }
                                this.lS.peek().newline();
                                continue;
                            }
                            if (la1 == '\\' || la1 == '\"') {
                                this.lS.peek().consume();
                                la1 = this.lS.peek().LA(1);
                                continue;
                            }
                            this.lS.peek().consume();
                            la1 = this.lS.peek().LA(1);
                            continue;
                        }
                        this.lS.peek().consume();
                        la1 = this.lS.peek().LA(1);
                    }
                    if (la1 == '\"') {
                        this.lS.peek().consume();
                        la1 = this.lS.peek().LA(1);
                    }
                    currentLine = this.lS.peek().getLine();
                    currentColumn = this.lS.peek().getColumn();
                    isMacroRelatedToBeginWord = false;
                    continue;
                }
                if (la1 == '\r' || la1 == '\n') {
                    this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
                    isInsideMacroDefinition = false;
                    if (la1 == '\r' && this.lS.peek().LA(2) == '\n') {
                        this.lS.peek().consume();
                    }
                    this.lS.peek().consume();
                    la1 = this.lS.peek().LA(1);
                    this.lS.peek().newline();
                    currentLine = this.lS.peek().getLine();
                    currentColumn = this.lS.peek().getColumn();
                    isMacroRelatedToBeginWord = false;
                    continue;
                }
                if (Character.isJavaIdentifierStart((int)la1)) {
                    currentLine = this.lS.peek().getLine();
                    currentColumn = this.lS.peek().getColumn();
                    int offset = this.lS.peek().getOffset();
                    tokenBuffer.append(la1);
                    this.lS.peek().consume();
                    la1 = this.lS.peek().LA(1);
                    while (Character.isJavaIdentifierPart((int)la1)) {
                        tokenBuffer.append(la1);
                        this.lS.peek().consume();
                        la1 = this.lS.peek().LA(1);
                    }
                    if (isMacroRelatedToBeginWord) {
                        this.rfp.lintTrackMacroCall(this.parserPath, tokenBuffer.toString());
                        this.util.getConditionDefine(tokenBuffer.toString(), false, new LineInfo(currentLine, offset, -1), new LineInfo(this.lS.peek().getLine(), this.lS.peek().getOffset(), -1));
                    }
                    isMacroRelatedToBeginWord = false;
                    continue;
                }
                this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
                this.lS.peek().consume();
                la1 = this.lS.peek().LA(1);
                continue;
            }
            this.processTokenBuffer(tokenBuffer, currentLine, currentColumn, languageSyntax);
            if (!this.lS.peek().isMacroReparsing()) break;
            macroReparsingLexerStack.push(this.lS.peek());
            int tmp = this.lS.peek().reparseFileLine;
            this.lS.pop(true);
            this.lS.peek().reparseFileLine = tmp;
            if (!this.lS.peek().isMacroReparsing()) {
                macroReparsingLexerStack.pop();
                VlogLexer parentLexer = this.lS.peek();
                while (!macroReparsingLexerStack.isEmpty()) {
                    this.pushMacroReparsedLexer(macroReparsingLexerStack.pop(), parentLexer);
                }
            }
            la1 = this.lS.peek().LA(1);
            currentLine = this.lS.peek().getLine();
            currentColumn = this.lS.peek().getColumn();
        }
    }

    private MatchedWordInfo lookAheadMatches(List<String> endWords, int nestedLevel, StringBuilder tokenBuffer, boolean isInsideMacroDefinition, int nestedPreprocInsideMacroDefinition) throws CharStreamException {
        StringBuilder wordToBeMatched = new StringBuilder();
        char la1 = this.lS.peek().LA(1);
        int numberOfWhitespaces = 0;
        if (nestedLevel > 1) {
            wordToBeMatched.append(la1);
            this.lS.peek().consume();
            la1 = this.lS.peek().LA(1);
            while ((char)la1 == ' ') {
                this.lS.peek().consume();
                la1 = this.lS.peek().LA(1);
                ++numberOfWhitespaces;
            }
            while (Character.isJavaIdentifierPart(la1)) {
                wordToBeMatched.append(la1);
                this.lS.peek().consume();
                la1 = this.lS.peek().LA(1);
            }
            tokenBuffer.append(wordToBeMatched.toString().substring(1));
        } else {
            wordToBeMatched.append(la1);
            int index = 1;
            char laIndex = this.lS.peek().LA(index + 1);
            while ((char)laIndex == ' ') {
                laIndex = this.lS.peek().LA(++index + 1);
                ++numberOfWhitespaces;
            }
            while (Character.isJavaIdentifierPart(laIndex)) {
                wordToBeMatched.append(laIndex);
                laIndex = this.lS.peek().LA(++index + 1);
            }
        }
        String wordToBeMatchedAsString = wordToBeMatched.toString();
        if (nestedLevel == 1) {
            if (isInsideMacroDefinition && nestedPreprocInsideMacroDefinition > 0 || !endWords.contains(wordToBeMatchedAsString)) {
                int i = 0;
                while (i < wordToBeMatchedAsString.length() + numberOfWhitespaces) {
                    this.lS.peek().consume();
                    ++i;
                }
            }
            if (!endWords.contains(wordToBeMatchedAsString)) {
                tokenBuffer.append(wordToBeMatched.toString().substring(1));
            }
        }
        if (endWords.contains(wordToBeMatchedAsString)) {
            return new MatchedWordInfo(wordToBeMatchedAsString, true, false);
        }
        if (BEGIN_TO_END_WORDS_MAP.containsKey(wordToBeMatchedAsString)) {
            return new MatchedWordInfo(wordToBeMatchedAsString, false, true);
        }
        return new MatchedWordInfo(wordToBeMatchedAsString, false, false);
    }

    private void processTokenBuffer(StringBuilder tokenBuffer, int currentLine, int currentColumn, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        if (tokenBuffer.length() > 0 && !this.isKeyword(tokenBuffer.toString(), languageSyntax)) {
            this.indexer.index2(tokenBuffer.toString(), currentLine, currentColumn, 542, true, true, true);
        }
        tokenBuffer.setLength(0);
    }

    private final boolean isKeyword(String word, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        ANTLRHashString hashString = new ANTLRHashString((CharScanner)this);
        hashString.setBuffer(word.toCharArray(), word.length());
        Integer literalsIndex = (Integer)this.literals.get(hashString);
        if (literalsIndex == null) {
            return false;
        }
        Set<String> keywordsSet = this.util.getRemovedKeywordsSet(languageSyntax);
        return !keywordsSet.contains(word);
    }

    private void pushMacroReparsedLexer(VlogLexer newLexer, VlogLexer parentLexer) {
        if (newLexer == null || parentLexer == null) {
            return;
        }
        newLexer.inputState = parentLexer.inputState;
        newLexer.lS = parentLexer.lS;
        newLexer.parentLexer = parentLexer;
        newLexer.util = parentLexer.util;
        newLexer.followImports = parentLexer.followImports;
        newLexer.defaultLanguageSyntax = parentLexer.defaultLanguageSyntax;
        newLexer.rfp = parentLexer.rfp;
        newLexer.parserPath = parentLexer.parserPath;
        newLexer.fileIndex = parentLexer.fileIndex;
        newLexer.setFilename(parentLexer.getFilename(), parentLexer.indexer, false);
        newLexer.lockLineNumber = false;
        newLexer.reparseMacro = null;
        newLexer.reparseMacroName = null;
        newLexer.reparseMacroParameters = null;
        newLexer.reparseMacroUnprocessedParameters = null;
        newLexer.reparseFileName = null;
        this.lS.push(newLexer);
    }

    private String removeComments(String replacement) {
        StringBuilder result = new StringBuilder();
        boolean comment = false;
        int i = 0;
        while (i < replacement.length()) {
            int n;
            char c = replacement.charAt(i);
            int n2 = n = i < replacement.length() - 1 ? (int)replacement.charAt(i + 1) : 32;
            if (!comment && c == '/' && n == 42) {
                comment = true;
            } else if (comment && c == '*' && n == 47) {
                comment = false;
                ++i;
            } else if (!comment) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private void notAllowed(int kind) {
        this.notAllowed(kind, null);
    }

    private void notAllowed(int kind, String info) {
        this.notAllowed(kind, info, null);
    }

    private void notAllowed(int kind, String info, ReparseInfo reparseInfo) {
        try {
            if (this.rfp != null && this.rfp.isLintingEnabled() && this.lS != null && !this.lS.isSkip()) {
                this.rfp.lintAddSVTBIssueLT(this.parserPath, kind, this.getLine(), this.getOffset(), this.virtualOffset == null ? 0 : this.virtualOffset.offset, 0, info, null, null, null, reparseInfo);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String appendWS(String text) {
        if (text != null && !text.isEmpty() && text.charAt(text.length() - 1) == '\uffff') {
            text = text.substring(0, text.length() - 1);
        }
        return String.valueOf(text) + '\ufff0';
    }

    private final boolean isKeyword(int minLen) throws CharStreamException {
        char[] cbuf = new char[16];
        char ch = '\u0000';
        int length = 0;
        int i = 0;
        while (i < 15) {
            ch = this.LA(i + 1);
            if (ch == '_' || !Character.isJavaIdentifierStart(ch)) break;
            cbuf[i] = ch;
            ++length;
            ++i;
        }
        if (length < minLen) {
            return false;
        }
        this.hashString.setBuffer(cbuf, length);
        Integer literalsIndex = (Integer)this.literals.get(this.hashString);
        if (literalsIndex != null) {
            IBuildConfigParserConstants.LanguageSyntax languageSyntax = this.getLanguageSyntax();
            Set<String> kewordsSet = this.util.getRemovedKeywordsSet(languageSyntax);
            String identifier = this.text.toString();
            if (kewordsSet == null || !kewordsSet.contains(identifier)) {
                return true;
            }
        }
        return false;
    }

    private int indexOfWhitespace(String text) {
        if (text == null) {
            return -1;
        }
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                return i;
            }
            ++i;
        }
        return text.length();
    }

    @Deprecated
    public void setFilename(String fileName) {
        throw new RuntimeException("Wrong usage of deprecated setFilename() method");
    }

    public void setFilename(String fileName, boolean clearIndexerEntries) {
        this.setFilename(fileName, null, clearIndexerEntries);
    }

    public void setFilename(String fileName, IIdentifierIndexerExtension indexer, boolean clearIndexerEntries) {
        super.setFilename(fileName);
        if (this.parserPath == null) {
            this.parserPath = new ParserPath(fileName);
        }
        if (indexer == null) {
            this.indexer = RfBatchUtils.getIndexer(this.util.getRfProject().getProject());
            if (this.indexer != null) {
                this.indexer.startFile(fileName, !this.followImports && clearIndexerEntries);
            }
        } else {
            this.indexer = indexer;
        }
    }

    public void dependsOn(String macroName, boolean undefined) {
        this.util.dependsOn(macroName, undefined);
    }

    public void dependsOn(String macroName, VlogMacroText replacement) {
        this.util.dependsOn(macroName, replacement);
    }

    public void userExceptionHandler(Exception ex) throws RecognitionException, CharStreamException, TokenStreamException {
        if (ex instanceof RecognitionException) {
            throw (RecognitionException)((Object)ex);
        }
        if (ex instanceof CharStreamException) {
            throw (CharStreamException)((Object)ex);
        }
        if (ex instanceof TokenStreamException) {
            throw (TokenStreamException)ex;
        }
        DVTLogger.INSTANCE.logError((Throwable)ex);
    }

    private void checkTimeRef(Token id, String replacement) {
        String original = replacement;
        if (replacement.startsWith("100")) {
            replacement = replacement.substring(3);
        } else if (replacement.startsWith("10")) {
            replacement = replacement.substring(2);
        } else if (replacement.startsWith("1")) {
            replacement = replacement.substring(1);
        }
        replacement = replacement.trim();
        if (!(replacement.equals("s") || replacement.equals("ms") || replacement.equals("us") || replacement.equals("ns") || replacement.equals("ps") || replacement.equals("fs"))) {
            this.reportError("*** Error: ", this.getFilename(), id.getLine(), id.getOffset(), id.getLength(), "Unexpected time reference: '" + original + "'");
        }
    }

    private String getFirstIdentifier(String trimmedText) {
        if (trimmedText == null || trimmedText.isEmpty()) {
            return null;
        }
        int length = trimmedText.length();
        int index = 0;
        char ch = '\u0000';
        while (index < length && (ch = trimmedText.charAt(index)) != '@' && !Character.isJavaIdentifierPart(ch)) {
            ++index;
        }
        StringBuilder sb = new StringBuilder();
        int i = index;
        while (i < length) {
            ch = trimmedText.charAt(i);
            if (!Character.isJavaIdentifierPart(ch) && (i != 0 || ch != '@')) break;
            sb.append(ch);
            ++i;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    protected Token makeToken(int t) {
        Token result = super.makeToken(t);
        if (this.virtualOffset != null) {
            ((DVTCustomToken)result).setVirtualOffset(this.virtualOffset.offset);
        }
        if (this.isPVlogPreprocessingOutsideMacro()) {
            int pVlogCompilationOffset = this.util.getPVlogCompilationOffset(this.parserPath, result.getOffset());
            result.setOffset(pVlogCompilationOffset);
            int pvlogCompilationLine = this.util.getPVlogCompilationLine(this.parserPath, pVlogCompilationOffset);
            result.setLine(pvlogCompilationLine);
            if (this.util.isInsidePVlogRegion(this.parserPath, pVlogCompilationOffset)) {
                ((DVTCustomToken)result).setVirtualOffset(super.getOffset());
            }
        }
        return result;
    }

    private String getTrimmedText(String text, int[] offsets) {
        int startIndex = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (!Character.isWhitespace(ch)) break;
            ++startIndex;
            ++i;
        }
        int endIndex = length;
        int i2 = length - 1;
        while (i2 > startIndex) {
            char ch = text.charAt(i2);
            if (!Character.isWhitespace(ch)) break;
            --endIndex;
            --i2;
        }
        if (offsets != null && offsets.length == 2) {
            offsets[0] = offsets[0] + startIndex;
            offsets[1] = offsets[1] - (length - endIndex);
        }
        return text.substring(startIndex, endIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Token nextTokenCustom() throws TokenStreamException {
        if (this.startFileDef) {
            this.startFileDef = false;
            DVTCustomToken result = new DVTCustomToken(288);
            result.setFileInstance(this.util.getCurrentFileInstance());
            result.setNewIncludedFile(this.newIncludedFile);
            return result;
        }
        DVTCustomToken result = null;
        try {
            result = (DVTCustomToken)this.nextToken();
            result.setOverriddenLanguageSyntax(this.getOverriddenLanguageSyntax());
        }
        catch (TokenStreamRecognitionException e) {
            if (!this.lS.isSkip()) throw e;
            try {
                this.consume();
                return new DVTCustomToken(-1);
            }
            catch (CharStreamException e1) {
                throw new TokenStreamException(e1.getMessage());
            }
        }
        if (!this.isMacroReparsing() && this.rfp != null && this.rfp.lintIsStoreTokens()) {
            VlogFileInstance currentFileInstance = this.lS.getCurrentFileInstance();
            if (result != null && this.lS != null && currentFileInstance != null) {
                result.setFileInstance(currentFileInstance);
                result.setMacroZone(currentFileInstance.getCurrMacroZone());
            }
            if (!this.lS.isSkip()) {
                this.rfp.lintStoreToken((Token)result);
            }
        }
        if (result == null || this.isMacroReparsing() || result.getType() == 1) return result;
        if (result.getType() == 565 && result.getText().startsWith("`include")) {
            this.util.nextTokenLine(this.getLine(), true);
            try {
                if (this.lS.isSkip() || !this.mustGenerateIncrementalInclude) return result;
                CharScanner.UserMark userMark = this.userMark();
                try {
                    this.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
                }
                catch (RecognitionException recognitionException) {}
                if (this.LA(1) == ',' || this.LA(1) == ')') {
                    result.setType(286);
                    result.setText("INCREMENTAL_INCLUDE");
                }
                this.userRewind(userMark);
                return result;
            }
            catch (CharStreamException e) {
                throw new TokenStreamException(e.getMessage());
            }
        }
        this.util.nextTokenLine(this.getLine(), false);
        return result;
    }

    private LineInfo getLineInfo(Token t) throws TokenStreamException {
        if (t == null) {
            return new LineInfo(this.getLine(), this.getOffset(), -1);
        }
        return new LineInfo(t.getLine(), t.getOffset(), -1);
    }

    private LineInfo getLineInfo() throws TokenStreamException {
        return new LineInfo(this.getLine(), this.getOffset(), -1);
    }

    public byte[] getMD5() {
        if (!(this.inputStream instanceof MD5InputStream)) {
            return null;
        }
        try {
            if (!((MD5InputStream)this.inputStream).isClosed() && this.inputStream.available() > 0) {
                return IDVTConstants.BLANK_MD5;
            }
            return ((MD5InputStream)this.inputStream).getMD5();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void continueIFDEFLexingOutsideMacro() {
        if (this.parentLexer == null) {
            return;
        }
        this.continueIFDEFLexing(this.parentLexer.parentLexer);
    }

    private void continueIFDEFLexing(VlogLexer parentLexer) {
        if (parentLexer == null) {
            return;
        }
        VlogLexer newLexer = new VlogLexer(parentLexer.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
        newLexer.lS = parentLexer.lS;
        newLexer.parentLexer = parentLexer;
        newLexer.util = parentLexer.util;
        newLexer.followImports = parentLexer.followImports;
        newLexer.defaultLanguageSyntax = parentLexer.defaultLanguageSyntax;
        newLexer.rfp = parentLexer.rfp;
        newLexer.parserPath = parentLexer.parserPath;
        newLexer.fileIndex = parentLexer.fileIndex;
        newLexer.setFilename(parentLexer.getFilename(), parentLexer.indexer, false);
        newLexer.ifdefID = this.ifdefID;
        if (parentLexer.isMacroReparsing()) {
            newLexer.setLockLine(parentLexer.getLine(), parentLexer.getOffset(), parentLexer.getColumn());
            newLexer.reparseMacro = parentLexer.reparseMacro;
            newLexer.reparseMacroName = parentLexer.reparseMacroName;
            newLexer.reparseMacroParameters = parentLexer.reparseMacroParameters;
            newLexer.reparseMacroUnprocessedParameters = parentLexer.reparseMacroUnprocessedParameters;
            newLexer.reparseFileName = parentLexer.reparseFileName;
            newLexer.reparseFileLine = parentLexer.reparseFileLine;
            newLexer.virtualOffset = parentLexer.virtualOffset;
        }
        newLexer.isPVlogPreprocessing = parentLexer.isPVlogPreprocessing;
        newLexer.kind = 2;
        this.lS.push(newLexer);
        newLexer.preprocessingType = this.preprocessingType;
        newLexer.preprocessingLine = this.preprocessingLine;
        newLexer.preprocessingFile = this.preprocessingFile;
        newLexer.skipElseBranch = this.skipElseBranch;
        if (this.lS.containsSkipDefine(this)) {
            this.lS.addSkipDefine(newLexer);
        }
    }

    public VlogLexer(InputStream in) {
        this((InputBuffer)new ByteBuffer(in));
    }

    public VlogLexer(Reader in) {
        this((InputBuffer)new CharBuffer(in));
    }

    public VlogLexer(InputBuffer ib) {
        this(new LexerSharedInputState(ib));
    }

    public VlogLexer(LexerSharedInputState state) {
        super(state);
        this.caseSensitiveLiterals = true;
        this.setCaseSensitive(true);
        this.literals = new HashMap();
        this.literals.put(new ANTLRHashString("release", (CharScanner)this), 191);
        this.literals.put(new ANTLRHashString("idtmod", (CharScanner)this), 339);
        this.literals.put(new ANTLRHashString("AF", (CharScanner)this), 441);
        this.literals.put(new ANTLRHashString("units", (CharScanner)this), 372);
        this.literals.put(new ANTLRHashString("accept_on", (CharScanner)this), 14);
        this.literals.put(new ANTLRHashString("always", (CharScanner)this), 26);
        this.literals.put(new ANTLRHashString("inside", (CharScanner)this), 128);
        this.literals.put(new ANTLRHashString("connectrules", (CharScanner)this), 314);
        this.literals.put(new ANTLRHashString("nexttime", (CharScanner)this), 4);
        this.literals.put(new ANTLRHashString("nmos", (CharScanner)this), 154);
        this.literals.put(new ANTLRHashString("asinh", (CharScanner)this), 306);
        this.literals.put(new ANTLRHashString("randsequence", (CharScanner)this), 185);
        this.literals.put(new ANTLRHashString("endnature", (CharScanner)this), 327);
        this.literals.put(new ANTLRHashString("zi_zp", (CharScanner)this), 378);
        this.literals.put(new ANTLRHashString("cross", (CharScanner)this), 63);
        this.literals.put(new ANTLRHashString("restrict", (CharScanner)this), 193);
        this.literals.put(new ANTLRHashString("until_with", (CharScanner)this), 11);
        this.literals.put(new ANTLRHashString("potential", (CharScanner)this), 359);
        this.literals.put(new ANTLRHashString("endparamset", (CharScanner)this), 328);
        this.literals.put(new ANTLRHashString("join_any", (CharScanner)this), 136);
        this.literals.put(new ANTLRHashString("disable", (CharScanner)this), 68);
        this.literals.put(new ANTLRHashString("endspecify", (CharScanner)this), 90);
        this.literals.put(new ANTLRHashString("implies", (CharScanner)this), 13);
        this.literals.put(new ANTLRHashString("hypot", (CharScanner)this), 337);
        this.literals.put(new ANTLRHashString("local", (CharScanner)this), 141);
        this.literals.put(new ANTLRHashString("end", (CharScanner)this), 75);
        this.literals.put(new ANTLRHashString("branch", (CharScanner)this), 310);
        this.literals.put(new ANTLRHashString("wand", (CharScanner)this), 254);
        this.literals.put(new ANTLRHashString("$skew", (CharScanner)this), 272);
        this.literals.put(new ANTLRHashString("clock", (CharScanner)this), 393);
        this.literals.put(new ANTLRHashString("domain", (CharScanner)this), 323);
        this.literals.put(new ANTLRHashString("notif1", (CharScanner)this), 159);
        this.literals.put(new ANTLRHashString("initial_step", (CharScanner)this), 342);
        this.literals.put(new ANTLRHashString("cmos", (CharScanner)this), 54);
        this.literals.put(new ANTLRHashString("strong", (CharScanner)this), 18);
        this.literals.put(new ANTLRHashString("automatic", (CharScanner)this), 35);
        this.literals.put(new ANTLRHashString("$timeskew", (CharScanner)this), 273);
        this.literals.put(new ANTLRHashString("$nochange", (CharScanner)this), 278);
        this.literals.put(new ANTLRHashString("bit", (CharScanner)this), 41);
        this.literals.put(new ANTLRHashString("endtask", (CharScanner)this), 93);
        this.literals.put(new ANTLRHashString("endfunction", (CharScanner)this), 81);
        this.literals.put(new ANTLRHashString("notif0", (CharScanner)this), 158);
        this.literals.put(new ANTLRHashString("supply1", (CharScanner)this), 220);
        this.literals.put(new ANTLRHashString("package", (CharScanner)this), 164);
        this.literals.put(new ANTLRHashString("int", (CharScanner)this), 130);
        this.literals.put(new ANTLRHashString("deassign", (CharScanner)this), 64);
        this.literals.put(new ANTLRHashString("$unit", (CharScanner)this), 276);
        this.literals.put(new ANTLRHashString("ac_stim", (CharScanner)this), 301);
        this.literals.put(new ANTLRHashString("packed", (CharScanner)this), 165);
        this.literals.put(new ANTLRHashString("supply0", (CharScanner)this), 219);
        this.literals.put(new ANTLRHashString("virtual", (CharScanner)this), 249);
        this.literals.put(new ANTLRHashString("$recovery", (CharScanner)this), 269);
        this.literals.put(new ANTLRHashString("void", (CharScanner)this), 251);
        this.literals.put(new ANTLRHashString("laplace_zd", (CharScanner)this), 345);
        this.literals.put(new ANTLRHashString("endinterface", (CharScanner)this), 84);
        this.literals.put(new ANTLRHashString("interface", (CharScanner)this), 133);
        this.literals.put(new ANTLRHashString("absdelta", (CharScanner)this), 296);
        this.literals.put(new ANTLRHashString("EX", (CharScanner)this), 447);
        this.literals.put(new ANTLRHashString("unsigned", (CharScanner)this), 244);
        this.literals.put(new ANTLRHashString("endcase", (CharScanner)this), 76);
        this.literals.put(new ANTLRHashString("$removal", (CharScanner)this), 270);
        this.literals.put(new ANTLRHashString("endprogram", (CharScanner)this), 88);
        this.literals.put(new ANTLRHashString("in", (CharScanner)this), 433);
        this.literals.put(new ANTLRHashString("boolean", (CharScanner)this), 388);
        this.literals.put(new ANTLRHashString("tagged", (CharScanner)this), 222);
        this.literals.put(new ANTLRHashString("exclude", (CharScanner)this), 329);
        this.literals.put(new ANTLRHashString("option", (CharScanner)this), 163);
        this.literals.put(new ANTLRHashString("sync_reject_on", (CharScanner)this), 17);
        this.literals.put(new ANTLRHashString("transition", (CharScanner)this), 371);
        this.literals.put(new ANTLRHashString("export", (CharScanner)this), 97);
        this.literals.put(new ANTLRHashString("static", (CharScanner)this), 213);
        this.literals.put(new ANTLRHashString("medium", (CharScanner)this), 147);
        this.literals.put(new ANTLRHashString("ddt_nature", (CharScanner)this), 319);
        this.literals.put(new ANTLRHashString("library", (CharScanner)this), 140);
        this.literals.put(new ANTLRHashString("split", (CharScanner)this), 366);
        this.literals.put(new ANTLRHashString("pull1", (CharScanner)this), 176);
        this.literals.put(new ANTLRHashString("weak1", (CharScanner)this), 256);
        this.literals.put(new ANTLRHashString("genvar", (CharScanner)this), 110);
        this.literals.put(new ANTLRHashString("access", (CharScanner)this), 298);
        this.literals.put(new ANTLRHashString("endchecker", (CharScanner)this), 21);
        this.literals.put(new ANTLRHashString("hard", (CharScanner)this), 115);
        this.literals.put(new ANTLRHashString("noshowcancelled", (CharScanner)this), 156);
        this.literals.put(new ANTLRHashString("merged", (CharScanner)this), 352);
        this.literals.put(new ANTLRHashString("realtime", (CharScanner)this), 188);
        this.literals.put(new ANTLRHashString("$setup", (CharScanner)this), 266);
        this.literals.put(new ANTLRHashString("xnor", (CharScanner)this), 263);
        this.literals.put(new ANTLRHashString("pull0", (CharScanner)this), 175);
        this.literals.put(new ANTLRHashString("weak0", (CharScanner)this), 255);
        this.literals.put(new ANTLRHashString("macromodule", (CharScanner)this), 145);
        this.literals.put(new ANTLRHashString("rtran", (CharScanner)this), 197);
        this.literals.put(new ANTLRHashString("tri1", (CharScanner)this), 234);
        this.literals.put(new ANTLRHashString("timeprecision", (CharScanner)this), 227);
        this.literals.put(new ANTLRHashString("next_e!", (CharScanner)this), 415);
        this.literals.put(new ANTLRHashString("covergroup", (CharScanner)this), 61);
        this.literals.put(new ANTLRHashString("priority", (CharScanner)this), 171);
        this.literals.put(new ANTLRHashString("context", (CharScanner)this), 58);
        this.literals.put(new ANTLRHashString("connect", (CharScanner)this), 312);
        this.literals.put(new ANTLRHashString("tri0", (CharScanner)this), 233);
        this.literals.put(new ANTLRHashString("union", (CharScanner)this), 241);
        this.literals.put(new ANTLRHashString("ground", (CharScanner)this), 336);
        this.literals.put(new ANTLRHashString("pulsestyle_onevent", (CharScanner)this), 179);
        this.literals.put(new ANTLRHashString("from", (CharScanner)this), 335);
        this.literals.put(new ANTLRHashString("clocking", (CharScanner)this), 53);
        this.literals.put(new ANTLRHashString("rnmos", (CharScanner)this), 195);
        this.literals.put(new ANTLRHashString("continue", (CharScanner)this), 59);
        this.literals.put(new ANTLRHashString("ceil", (CharScanner)this), 311);
        this.literals.put(new ANTLRHashString("liblist", (CharScanner)this), 139);
        this.literals.put(new ANTLRHashString("nondet", (CharScanner)this), 431);
        this.literals.put(new ANTLRHashString("endclocking", (CharScanner)this), 78);
        this.literals.put(new ANTLRHashString("G", (CharScanner)this), 437);
        this.literals.put(new ANTLRHashString("countones", (CharScanner)this), 428);
        this.literals.put(new ANTLRHashString("highz1", (CharScanner)this), 114);
        this.literals.put(new ANTLRHashString("do", (CharScanner)this), 70);
        this.literals.put(new ANTLRHashString("struct", (CharScanner)this), 217);
        this.literals.put(new ANTLRHashString("sync_abort", (CharScanner)this), 401);
        this.literals.put(new ANTLRHashString("assume_guarantee", (CharScanner)this), 394);
        this.literals.put(new ANTLRHashString("rand", (CharScanner)this), 182);
        this.literals.put(new ANTLRHashString("wire", (CharScanner)this), 259);
        this.literals.put(new ANTLRHashString("ln", (CharScanner)this), 349);
        this.literals.put(new ANTLRHashString("F", (CharScanner)this), 436);
        this.literals.put(new ANTLRHashString("zi_zd", (CharScanner)this), 377);
        this.literals.put(new ANTLRHashString("wreal", (CharScanner)this), 374);
        this.literals.put(new ANTLRHashString("sqrt", (CharScanner)this), 367);
        this.literals.put(new ANTLRHashString("sin", (CharScanner)this), 363);
        this.literals.put(new ANTLRHashString("highz0", (CharScanner)this), 113);
        this.literals.put(new ANTLRHashString("never", (CharScanner)this), 403);
        this.literals.put(new ANTLRHashString("before_", (CharScanner)this), 404);
        this.literals.put(new ANTLRHashString("sinh", (CharScanner)this), 364);
        this.literals.put(new ANTLRHashString("bind", (CharScanner)this), 38);
        this.literals.put(new ANTLRHashString("assign", (CharScanner)this), 33);
        this.literals.put(new ANTLRHashString("signed", (CharScanner)this), 207);
        this.literals.put(new ANTLRHashString("$width", (CharScanner)this), 277);
        this.literals.put(new ANTLRHashString("E", (CharScanner)this), 444);
        this.literals.put(new ANTLRHashString("resolveto", (CharScanner)this), 362);
        this.literals.put(new ANTLRHashString("nontransitive", (CharScanner)this), 384);
        this.literals.put(new ANTLRHashString("showcancelled", (CharScanner)this), 206);
        this.literals.put(new ANTLRHashString("rcmos", (CharScanner)this), 186);
        this.literals.put(new ANTLRHashString("force", (CharScanner)this), 103);
        this.literals.put(new ANTLRHashString("wildcard", (CharScanner)this), 258);
        this.literals.put(new ANTLRHashString("repeat", (CharScanner)this), 192);
        this.literals.put(new ANTLRHashString("if", (CharScanner)this), 116);
        this.literals.put(new ANTLRHashString("override", (CharScanner)this), 385);
        this.literals.put(new ANTLRHashString("or", (CharScanner)this), 161);
        this.literals.put(new ANTLRHashString("$recrem", (CharScanner)this), 271);
        this.literals.put(new ANTLRHashString("triand", (CharScanner)this), 235);
        this.literals.put(new ANTLRHashString("large", (CharScanner)this), 138);
        this.literals.put(new ANTLRHashString("next_event_a!", (CharScanner)this), 419);
        this.literals.put(new ANTLRHashString("longint", (CharScanner)this), 144);
        this.literals.put(new ANTLRHashString("after", (CharScanner)this), 24);
        this.literals.put(new ANTLRHashString("while", (CharScanner)this), 257);
        this.literals.put(new ANTLRHashString("ddx", (CharScanner)this), 320);
        this.literals.put(new ANTLRHashString("vprop", (CharScanner)this), 380);
        this.literals.put(new ANTLRHashString("analog", (CharScanner)this), 303);
        this.literals.put(new ANTLRHashString("specify", (CharScanner)this), 211);
        this.literals.put(new ANTLRHashString("time", (CharScanner)this), 226);
        this.literals.put(new ANTLRHashString("reg", (CharScanner)this), 190);
        this.literals.put(new ANTLRHashString("import", (CharScanner)this), 121);
        this.literals.put(new ANTLRHashString("tri", (CharScanner)this), 232);
        this.literals.put(new ANTLRHashString("design", (CharScanner)this), 67);
        this.literals.put(new ANTLRHashString("ended", (CharScanner)this), 426);
        this.literals.put(new ANTLRHashString("idt_nature", (CharScanner)this), 340);
        this.literals.put(new ANTLRHashString("defparam", (CharScanner)this), 66);
        this.literals.put(new ANTLRHashString("X!", (CharScanner)this), 435);
        this.literals.put(new ANTLRHashString("noise_table", (CharScanner)this), 356);
        this.literals.put(new ANTLRHashString("ref", (CharScanner)this), 189);
        this.literals.put(new ANTLRHashString("abstol", (CharScanner)this), 297);
        this.literals.put(new ANTLRHashString("const", (CharScanner)this), 56);
        this.literals.put(new ANTLRHashString("cell", (CharScanner)this), 50);
        this.literals.put(new ANTLRHashString("idt", (CharScanner)this), 338);
        this.literals.put(new ANTLRHashString("inherit", (CharScanner)this), 383);
        this.literals.put(new ANTLRHashString("until!_", (CharScanner)this), 409);
        this.literals.put(new ANTLRHashString("eventually!", (CharScanner)this), 402);
        this.literals.put(new ANTLRHashString("specparam", (CharScanner)this), 212);
        this.literals.put(new ANTLRHashString("A", (CharScanner)this), 440);
        this.literals.put(new ANTLRHashString("join_none", (CharScanner)this), 137);
        this.literals.put(new ANTLRHashString("atan", (CharScanner)this), 307);
        this.literals.put(new ANTLRHashString("bufif1", (CharScanner)this), 45);
        this.literals.put(new ANTLRHashString("use", (CharScanner)this), 245);
        this.literals.put(new ANTLRHashString("always_comb", (CharScanner)this), 27);
        this.literals.put(new ANTLRHashString("next_event_e", (CharScanner)this), 420);
        this.literals.put(new ANTLRHashString("inf", (CharScanner)this), 341);
        this.literals.put(new ANTLRHashString("restrict!", (CharScanner)this), 396);
        this.literals.put(new ANTLRHashString("randc", (CharScanner)this), 183);
        this.literals.put(new ANTLRHashString("slew", (CharScanner)this), 365);
        this.literals.put(new ANTLRHashString("laplace_np", (CharScanner)this), 344);
        this.literals.put(new ANTLRHashString("iff", (CharScanner)this), 117);
        this.literals.put(new ANTLRHashString("throughout", (CharScanner)this), 225);
        this.literals.put(new ANTLRHashString("always_latch", (CharScanner)this), 29);
        this.literals.put(new ANTLRHashString("bufif0", (CharScanner)this), 44);
        this.literals.put(new ANTLRHashString("vpkg", (CharScanner)this), 382);
        this.literals.put(new ANTLRHashString("xor", (CharScanner)this), 264);
        this.literals.put(new ANTLRHashString("nature", (CharScanner)this), 354);
        this.literals.put(new ANTLRHashString("ddt", (CharScanner)this), 318);
        this.literals.put(new ANTLRHashString("rose", (CharScanner)this), 424);
        this.literals.put(new ANTLRHashString("async_abort", (CharScanner)this), 400);
        this.literals.put(new ANTLRHashString("table", (CharScanner)this), 221);
        this.literals.put(new ANTLRHashString("binsof", (CharScanner)this), 40);
        this.literals.put(new ANTLRHashString("rules", (CharScanner)this), 200);
        this.literals.put(new ANTLRHashString("constraint", (CharScanner)this), 57);
        this.literals.put(new ANTLRHashString("pullup", (CharScanner)this), 178);
        this.literals.put(new ANTLRHashString("vunit", (CharScanner)this), 379);
        this.literals.put(new ANTLRHashString("weak", (CharScanner)this), 19);
        this.literals.put(new ANTLRHashString("program", (CharScanner)this), 172);
        this.literals.put(new ANTLRHashString("endextends", (CharScanner)this), 80);
        this.literals.put(new ANTLRHashString("s_eventually", (CharScanner)this), 7);
        this.literals.put(new ANTLRHashString("global", (CharScanner)this), 111);
        this.literals.put(new ANTLRHashString("alias", (CharScanner)this), 25);
        this.literals.put(new ANTLRHashString("fell", (CharScanner)this), 425);
        this.literals.put(new ANTLRHashString("fairness", (CharScanner)this), 397);
        this.literals.put(new ANTLRHashString("pulldown", (CharScanner)this), 177);
        this.literals.put(new ANTLRHashString("not", (CharScanner)this), 157);
        this.literals.put(new ANTLRHashString("localparam", (CharScanner)this), 142);
        this.literals.put(new ANTLRHashString("integer", (CharScanner)this), 131);
        this.literals.put(new ANTLRHashString("acos", (CharScanner)this), 299);
        this.literals.put(new ANTLRHashString("pulsestyle_ondetect", (CharScanner)this), 180);
        this.literals.put(new ANTLRHashString("endgroup", (CharScanner)this), 83);
        this.literals.put(new ANTLRHashString("$typeof", (CharScanner)this), 279);
        this.literals.put(new ANTLRHashString("endconfig", (CharScanner)this), 79);
        this.literals.put(new ANTLRHashString("input", (CharScanner)this), 127);
        this.literals.put(new ANTLRHashString("break", (CharScanner)this), 42);
        this.literals.put(new ANTLRHashString("mutable", (CharScanner)this), 391);
        this.literals.put(new ANTLRHashString("shortreal", (CharScanner)this), 205);
        this.literals.put(new ANTLRHashString("checker", (CharScanner)this), 20);
        this.literals.put(new ANTLRHashString("next_event_a", (CharScanner)this), 418);
        this.literals.put(new ANTLRHashString("rtranif1", (CharScanner)this), 199);
        this.literals.put(new ANTLRHashString("EG", (CharScanner)this), 446);
        this.literals.put(new ANTLRHashString("analysis", (CharScanner)this), 304);
        this.literals.put(new ANTLRHashString("implements", (CharScanner)this), 122);
        this.literals.put(new ANTLRHashString("dynamicparam", (CharScanner)this), 72);
        this.literals.put(new ANTLRHashString("s_until_with", (CharScanner)this), 12);
        this.literals.put(new ANTLRHashString("nor", (CharScanner)this), 155);
        this.literals.put(new ANTLRHashString("flow", (CharScanner)this), 334);
        this.literals.put(new ANTLRHashString("next_e", (CharScanner)this), 414);
        this.literals.put(new ANTLRHashString("rtranif0", (CharScanner)this), 198);
        this.literals.put(new ANTLRHashString("instance", (CharScanner)this), 129);
        this.literals.put(new ANTLRHashString("trior", (CharScanner)this), 236);
        this.literals.put(new ANTLRHashString("EF", (CharScanner)this), 445);
        this.literals.put(new ANTLRHashString("numeric", (CharScanner)this), 390);
        this.literals.put(new ANTLRHashString("$hold", (CharScanner)this), 267);
        this.literals.put(new ANTLRHashString("$fullskew", (CharScanner)this), 274);
        this.literals.put(new ANTLRHashString("shortint", (CharScanner)this), 204);
        this.literals.put(new ANTLRHashString("s_until", (CharScanner)this), 10);
        this.literals.put(new ANTLRHashString("let", (CharScanner)this), 22);
        this.literals.put(new ANTLRHashString("log", (CharScanner)this), 350);
        this.literals.put(new ANTLRHashString("matches", (CharScanner)this), 146);
        this.literals.put(new ANTLRHashString("sample", (CharScanner)this), 201);
        this.literals.put(new ANTLRHashString("property", (CharScanner)this), 173);
        this.literals.put(new ANTLRHashString("last_crossing", (CharScanner)this), 347);
        this.literals.put(new ANTLRHashString("string", (CharScanner)this), 214);
        this.literals.put(new ANTLRHashString("max", (CharScanner)this), 351);
        this.literals.put(new ANTLRHashString("before!", (CharScanner)this), 405);
        this.literals.put(new ANTLRHashString("modport", (CharScanner)this), 148);
        this.literals.put(new ANTLRHashString("endproperty", (CharScanner)this), 89);
        this.literals.put(new ANTLRHashString("forever", (CharScanner)this), 105);
        this.literals.put(new ANTLRHashString("absdelay", (CharScanner)this), 295);
        this.literals.put(new ANTLRHashString("until", (CharScanner)this), 9);
        this.literals.put(new ANTLRHashString("zi_np", (CharScanner)this), 376);
        this.literals.put(new ANTLRHashString("dist", (CharScanner)this), 69);
        this.literals.put(new ANTLRHashString("above", (CharScanner)this), 293);
        this.literals.put(new ANTLRHashString("restrict_guarantee", (CharScanner)this), 395);
        this.literals.put(new ANTLRHashString("exp", (CharScanner)this), 330);
        this.literals.put(new ANTLRHashString("foreach", (CharScanner)this), 104);
        this.literals.put(new ANTLRHashString("noise_table_log", (CharScanner)this), 357);
        this.literals.put(new ANTLRHashString("negedge", (CharScanner)this), 151);
        this.literals.put(new ANTLRHashString("pow", (CharScanner)this), 360);
        this.literals.put(new ANTLRHashString("next_a", (CharScanner)this), 412);
        this.literals.put(new ANTLRHashString("s_always", (CharScanner)this), 6);
        this.literals.put(new ANTLRHashString("bitvector", (CharScanner)this), 389);
        this.literals.put(new ANTLRHashString("endmodule", (CharScanner)this), 85);
        this.literals.put(new ANTLRHashString("limexp", (CharScanner)this), 348);
        this.literals.put(new ANTLRHashString("vmode", (CharScanner)this), 381);
        this.literals.put(new ANTLRHashString("forall", (CharScanner)this), 398);
        this.literals.put(new ANTLRHashString("report", (CharScanner)this), 386);
        this.literals.put(new ANTLRHashString("wait_order", (CharScanner)this), 253);
        this.literals.put(new ANTLRHashString("stable", (CharScanner)this), 423);
        this.literals.put(new ANTLRHashString("logic", (CharScanner)this), 143);
        this.literals.put(new ANTLRHashString("tranif1", (CharScanner)this), 231);
        this.literals.put(new ANTLRHashString("class", (CharScanner)this), 52);
        this.literals.put(new ANTLRHashString("soft", (CharScanner)this), 209);
        this.literals.put(new ANTLRHashString("first_match", (CharScanner)this), 101);
        this.literals.put(new ANTLRHashString("flicker_noise", (CharScanner)this), 332);
        this.literals.put(new ANTLRHashString("real", (CharScanner)this), 187);
        this.literals.put(new ANTLRHashString("$setuphold", (CharScanner)this), 268);
        this.literals.put(new ANTLRHashString("tranif0", (CharScanner)this), 230);
        this.literals.put(new ANTLRHashString("type_option", (CharScanner)this), 239);
        this.literals.put(new ANTLRHashString("fork", (CharScanner)this), 106);
        this.literals.put(new ANTLRHashString("next", (CharScanner)this), 410);
        this.literals.put(new ANTLRHashString("reject_on", (CharScanner)this), 15);
        this.literals.put(new ANTLRHashString("join", (CharScanner)this), 135);
        this.literals.put(new ANTLRHashString("laplace_nd", (CharScanner)this), 343);
        this.literals.put(new ANTLRHashString("AX", (CharScanner)this), 443);
        this.literals.put(new ANTLRHashString("new", (CharScanner)this), 153);
        this.literals.put(new ANTLRHashString("vectored", (CharScanner)this), 248);
        this.literals.put(new ANTLRHashString("expect", (CharScanner)this), 96);
        this.literals.put(new ANTLRHashString("include", (CharScanner)this), 124);
        this.literals.put(new ANTLRHashString("atanh", (CharScanner)this), 309);
        this.literals.put(new ANTLRHashString("initial", (CharScanner)this), 125);
        this.literals.put(new ANTLRHashString("free", (CharScanner)this), 392);
        this.literals.put(new ANTLRHashString("virtuals", (CharScanner)this), 250);
        this.literals.put(new ANTLRHashString("aliasparam", (CharScanner)this), 302);
        this.literals.put(new ANTLRHashString("strong1", (CharScanner)this), 216);
        this.literals.put(new ANTLRHashString("hdltype", (CharScanner)this), 387);
        this.literals.put(new ANTLRHashString("hide", (CharScanner)this), 112);
        this.literals.put(new ANTLRHashString("onehot0", (CharScanner)this), 430);
        this.literals.put(new ANTLRHashString("floor", (CharScanner)this), 333);
        this.literals.put(new ANTLRHashString("coverpoint", (CharScanner)this), 62);
        this.literals.put(new ANTLRHashString("strong0", (CharScanner)this), 215);
        this.literals.put(new ANTLRHashString("and", (CharScanner)this), 30);
        this.literals.put(new ANTLRHashString("return", (CharScanner)this), 194);
        this.literals.put(new ANTLRHashString("sync_accept_on", (CharScanner)this), 16);
        this.literals.put(new ANTLRHashString("until_", (CharScanner)this), 407);
        this.literals.put(new ANTLRHashString("around", (CharScanner)this), 31);
        this.literals.put(new ANTLRHashString("timeunit", (CharScanner)this), 228);
        this.literals.put(new ANTLRHashString("forkjoin", (CharScanner)this), 107);
        this.literals.put(new ANTLRHashString("realresolve", (CharScanner)this), 361);
        this.literals.put(new ANTLRHashString("extends", (CharScanner)this), 98);
        this.literals.put(new ANTLRHashString("$period", (CharScanner)this), 275);
        this.literals.put(new ANTLRHashString("randcase", (CharScanner)this), 184);
        this.literals.put(new ANTLRHashString("next!", (CharScanner)this), 411);
        this.literals.put(new ANTLRHashString("task", (CharScanner)this), 223);
        this.literals.put(new ANTLRHashString("protected", (CharScanner)this), 174);
        this.literals.put(new ANTLRHashString("continuous", (CharScanner)this), 315);
        this.literals.put(new ANTLRHashString("acosh", (CharScanner)this), 300);
        this.literals.put(new ANTLRHashString("min", (CharScanner)this), 353);
        this.literals.put(new ANTLRHashString("next_a!", (CharScanner)this), 413);
        this.literals.put(new ANTLRHashString("partition", (CharScanner)this), 167);
        this.literals.put(new ANTLRHashString("pmos", (CharScanner)this), 168);
        this.literals.put(new ANTLRHashString("atan2", (CharScanner)this), 308);
        this.literals.put(new ANTLRHashString("connectmodule", (CharScanner)this), 313);
        this.literals.put(new ANTLRHashString("for", (CharScanner)this), 102);
        this.literals.put(new ANTLRHashString("default", (CharScanner)this), 65);
        this.literals.put(new ANTLRHashString("unique", (CharScanner)this), 242);
        this.literals.put(new ANTLRHashString("abort", (CharScanner)this), 399);
        this.literals.put(new ANTLRHashString("final_step", (CharScanner)this), 331);
        this.literals.put(new ANTLRHashString("enum", (CharScanner)this), 94);
        this.literals.put(new ANTLRHashString("case", (CharScanner)this), 47);
        this.literals.put(new ANTLRHashString("onehot", (CharScanner)this), 429);
        this.literals.put(new ANTLRHashString("uwire", (CharScanner)this), 246);
        this.literals.put(new ANTLRHashString("interconnect", (CharScanner)this), 132);
        this.literals.put(new ANTLRHashString("generate", (CharScanner)this), 109);
        this.literals.put(new ANTLRHashString("edge", (CharScanner)this), 73);
        this.literals.put(new ANTLRHashString("before!_", (CharScanner)this), 406);
        this.literals.put(new ANTLRHashString("endgenerate", (CharScanner)this), 82);
        this.literals.put(new ANTLRHashString("endconnectmodule", (CharScanner)this), 292);
        this.literals.put(new ANTLRHashString("null", (CharScanner)this), 160);
        this.literals.put(new ANTLRHashString("asin", (CharScanner)this), 305);
        this.literals.put(new ANTLRHashString("next_event", (CharScanner)this), 416);
        this.literals.put(new ANTLRHashString("chandle", (CharScanner)this), 51);
        this.literals.put(new ANTLRHashString("untyped", (CharScanner)this), 23);
        this.literals.put(new ANTLRHashString("endprimitive", (CharScanner)this), 87);
        this.literals.put(new ANTLRHashString("zi_nd", (CharScanner)this), 375);
        this.literals.put(new ANTLRHashString("driver_update", (CharScanner)this), 324);
        this.literals.put(new ANTLRHashString("parameter", (CharScanner)this), 166);
        this.literals.put(new ANTLRHashString("sequence", (CharScanner)this), 203);
        this.literals.put(new ANTLRHashString("extern", (CharScanner)this), 99);
        this.literals.put(new ANTLRHashString("within", (CharScanner)this), 261);
        this.literals.put(new ANTLRHashString("endtable", (CharScanner)this), 92);
        this.literals.put(new ANTLRHashString("endsequence", (CharScanner)this), 91);
        this.literals.put(new ANTLRHashString("wor", (CharScanner)this), 262);
        this.literals.put(new ANTLRHashString("s_nexttime", (CharScanner)this), 5);
        this.literals.put(new ANTLRHashString("next_event_e!", (CharScanner)this), 421);
        this.literals.put(new ANTLRHashString("ifnone", (CharScanner)this), 118);
        this.literals.put(new ANTLRHashString("assume", (CharScanner)this), 34);
        this.literals.put(new ANTLRHashString("typedef", (CharScanner)this), 240);
        this.literals.put(new ANTLRHashString("endpackage", (CharScanner)this), 86);
        this.literals.put(new ANTLRHashString("config", (CharScanner)this), 55);
        this.literals.put(new ANTLRHashString("event", (CharScanner)this), 95);
        this.literals.put(new ANTLRHashString("nand", (CharScanner)this), 150);
        this.literals.put(new ANTLRHashString("intersect", (CharScanner)this), 134);
        this.literals.put(new ANTLRHashString("dominates", (CharScanner)this), 71);
        this.literals.put(new ANTLRHashString("enddiscipline", (CharScanner)this), 326);
        this.literals.put(new ANTLRHashString("endclass", (CharScanner)this), 77);
        this.literals.put(new ANTLRHashString("white_noise", (CharScanner)this), 373);
        this.literals.put(new ANTLRHashString("discipline", (CharScanner)this), 321);
        this.literals.put(new ANTLRHashString("illegal_bins", (CharScanner)this), 120);
        this.literals.put(new ANTLRHashString("nettype", (CharScanner)this), 152);
        this.literals.put(new ANTLRHashString("buf", (CharScanner)this), 43);
        this.literals.put(new ANTLRHashString("output", (CharScanner)this), 162);
        this.literals.put(new ANTLRHashString("inout", (CharScanner)this), 126);
        this.literals.put(new ANTLRHashString("wait", (CharScanner)this), 252);
        this.literals.put(new ANTLRHashString("nondet_vector", (CharScanner)this), 432);
        this.literals.put(new ANTLRHashString("pure", (CharScanner)this), 181);
        this.literals.put(new ANTLRHashString("next_event!", (CharScanner)this), 417);
        this.literals.put(new ANTLRHashString("$root", (CharScanner)this), 265);
        this.literals.put(new ANTLRHashString("tan", (CharScanner)this), 368);
        this.literals.put(new ANTLRHashString("laplace_zp", (CharScanner)this), 346);
        this.literals.put(new ANTLRHashString("small", (CharScanner)this), 208);
        this.literals.put(new ANTLRHashString("scalared", (CharScanner)this), 202);
        this.literals.put(new ANTLRHashString("paramset", (CharScanner)this), 358);
        this.literals.put(new ANTLRHashString("super", (CharScanner)this), 218);
        this.literals.put(new ANTLRHashString("prev", (CharScanner)this), 422);
        this.literals.put(new ANTLRHashString("cover", (CharScanner)this), 60);
        this.literals.put(new ANTLRHashString("abs", (CharScanner)this), 294);
        this.literals.put(new ANTLRHashString("endconnectrules", (CharScanner)this), 325);
        this.literals.put(new ANTLRHashString("final", (CharScanner)this), 100);
        this.literals.put(new ANTLRHashString("tanh", (CharScanner)this), 369);
        this.literals.put(new ANTLRHashString("timer", (CharScanner)this), 370);
        this.literals.put(new ANTLRHashString("posedge", (CharScanner)this), 169);
        this.literals.put(new ANTLRHashString("ignore_bins", (CharScanner)this), 119);
        this.literals.put(new ANTLRHashString("X", (CharScanner)this), 434);
        this.literals.put(new ANTLRHashString("assert", (CharScanner)this), 32);
        this.literals.put(new ANTLRHashString("type", (CharScanner)this), 238);
        this.literals.put(new ANTLRHashString("discrete", (CharScanner)this), 322);
        this.literals.put(new ANTLRHashString("begin", (CharScanner)this), 37);
        this.literals.put(new ANTLRHashString("W", (CharScanner)this), 439);
        this.literals.put(new ANTLRHashString("incdir", (CharScanner)this), 123);
        this.literals.put(new ANTLRHashString("primitive", (CharScanner)this), 170);
        this.literals.put(new ANTLRHashString("function", (CharScanner)this), 108);
        this.literals.put(new ANTLRHashString("cos", (CharScanner)this), 316);
        this.literals.put(new ANTLRHashString("until!", (CharScanner)this), 408);
        this.literals.put(new ANTLRHashString("module", (CharScanner)this), 149);
        this.literals.put(new ANTLRHashString("casez", (CharScanner)this), 49);
        this.literals.put(new ANTLRHashString("always_ff", (CharScanner)this), 28);
        this.literals.put(new ANTLRHashString("rpmos", (CharScanner)this), 196);
        this.literals.put(new ANTLRHashString("trireg", (CharScanner)this), 237);
        this.literals.put(new ANTLRHashString("this", (CharScanner)this), 224);
        this.literals.put(new ANTLRHashString("with", (CharScanner)this), 260);
        this.literals.put(new ANTLRHashString("isunknown", (CharScanner)this), 427);
        this.literals.put(new ANTLRHashString("net_resolution", (CharScanner)this), 355);
        this.literals.put(new ANTLRHashString("U", (CharScanner)this), 438);
        this.literals.put(new ANTLRHashString("before", (CharScanner)this), 36);
        this.literals.put(new ANTLRHashString("unique0", (CharScanner)this), 243);
        this.literals.put(new ANTLRHashString("AG", (CharScanner)this), 442);
        this.literals.put(new ANTLRHashString("var", (CharScanner)this), 247);
        this.literals.put(new ANTLRHashString("bins", (CharScanner)this), 39);
        this.literals.put(new ANTLRHashString("byte", (CharScanner)this), 46);
        this.literals.put(new ANTLRHashString("else", (CharScanner)this), 74);
        this.literals.put(new ANTLRHashString("cosh", (CharScanner)this), 317);
        this.literals.put(new ANTLRHashString("tran", (CharScanner)this), 229);
        this.literals.put(new ANTLRHashString("solve", (CharScanner)this), 210);
        this.literals.put(new ANTLRHashString("casex", (CharScanner)this), 48);
        this.literals.put(new ANTLRHashString("eventually", (CharScanner)this), 8);
    }

    /*
     * Exception decompiling
     */
    public Token nextToken() throws TokenStreamException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void mINVALID_CHARS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int adjust;
        int offset;
        int line;
        int _ttype;
        int _begin;
        Token _token;
        block29: {
            _token = null;
            _begin = this.text.length();
            _ttype = 448;
            CharScanner.UserMark userMark = null;
            line = this.getLine();
            offset = this.getOffset();
            adjust = 0;
            this.mINVALID_CHAR(false);
            if (_tokenSet_4.member((int)this.LA(1))) {
                int _cnt6 = 0;
                while (true) {
                    boolean synPredMatched5 = false;
                    if (this.LA(1) >= 'a' && this.LA(1) <= 'z') {
                        int _m5 = this.mark();
                        synPredMatched5 = true;
                        this.inputState.incGuessing();
                        try {
                            if (!this.isKeyword(3)) {
                                throw this.getSemanticException(" isKeyword(3) ");
                            }
                            this.mKEYWORD(false);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched5 = false;
                        }
                        this.rewind(_m5);
                        this.inputState.decGuessing(synPredMatched5);
                    }
                    if (synPredMatched5) {
                        if (this.inputState.guessing() == 0) {
                            try {
                                userMark = this.userMark();
                                adjust -= this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mKEYWORD(false);
                        if (this.inputState.guessing() == 0) {
                            try {
                                adjust += this.getOffset();
                                this.userRewind(userMark);
                                break block29;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else if (_tokenSet_5.member((int)this.LA(1))) {
                        this.mVALID_CHAR(false);
                    } else {
                        if (!_tokenSet_3.member((int)this.LA(1))) {
                            if (_cnt6 < 1) {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            break block29;
                        }
                        this.mINVALID_CHAR(false);
                    }
                    ++_cnt6;
                }
            }
            if (this.LA(1) == '\uffff') {
                this.match('\uffff');
            } else {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (this.inputState.guessing() == 0) {
            try {
                String temp = this.getText();
                if (temp != null && adjust > 0 && adjust < temp.length()) {
                    temp = temp.substring(0, temp.length() - adjust);
                }
                if (temp != null && temp.length() > 0) {
                    if (temp.length() == 1) {
                        this.reportError("*** Error: ", this.getFilename(), line, offset, temp.length(), "Unexpected char '" + temp.charAt(0) + "' (code 0x" + Integer.toHexString(temp.charAt(0)).toUpperCase() + ")");
                    } else if (temp.length() > 1) {
                        this.reportError("*** Error: ", this.getFilename(), line, offset, temp.length() - adjust, "Unexpected char sequence (" + temp.length() + " chars) starting with '" + temp.charAt(0) + "' (code 0x" + Integer.toHexString(temp.charAt(0)).toUpperCase() + ")");
                    }
                    _ttype = -1;
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mINVALID_CHAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 450;
        switch (this.LA(1)) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': {
                this.matchRange('\u0000', '\b');
                break;
            }
            case '\u000b': {
                this.match('\u000b');
                break;
            }
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                this.matchRange('\u000e', '\u001f');
                break;
            }
            case '\u007f': 
            case '\u0080': 
            case '\u0081': 
            case '\u0082': 
            case '\u0083': 
            case '\u0084': 
            case '\u0085': 
            case '\u0086': 
            case '\u0087': 
            case '\u0088': 
            case '\u0089': 
            case '\u008a': 
            case '\u008b': 
            case '\u008c': 
            case '\u008d': 
            case '\u008e': 
            case '\u008f': 
            case '\u0090': 
            case '\u0091': 
            case '\u0092': 
            case '\u0093': 
            case '\u0094': 
            case '\u0095': 
            case '\u0096': 
            case '\u0097': 
            case '\u0098': 
            case '\u0099': 
            case '\u009a': 
            case '\u009b': 
            case '\u009c': 
            case '\u009d': 
            case '\u009e': 
            case '\u009f': {
                this.matchRange('\u007f', '\u009f');
                break;
            }
            default: {
                if (this.LA(1) >= '\u00a1' && this.LA(1) <= '\ufffe') {
                    this.matchRange('\u00a1', '\ufffe');
                    break;
                }
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mKEYWORD(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 449;
        this.matchRange('a', 'z');
        while (this.LA(1) >= 'a' && this.LA(1) <= 'z') {
            this.matchRange('a', 'z');
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mVALID_CHAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 451;
        boolean synPredMatched15 = false;
        if (this.LA(1) == '\r' && this.LA(2) == '\n') {
            int _m15 = this.mark();
            synPredMatched15 = true;
            this.inputState.incGuessing();
            try {
                this.match("\r\n");
            }
            catch (RecognitionException recognitionException) {
                synPredMatched15 = false;
            }
            this.rewind(_m15);
            this.inputState.decGuessing(synPredMatched15);
        }
        if (synPredMatched15) {
            this.match("\r\n");
            if (this.inputState.guessing() == 0) {
                try {
                    this.newline();
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else {
            boolean synPredMatched17 = false;
            if (this.LA(1) == '\r') {
                int _m17 = this.mark();
                synPredMatched17 = true;
                this.inputState.incGuessing();
                try {
                    this.match("\r");
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched17 = false;
                }
                this.rewind(_m17);
                this.inputState.decGuessing(synPredMatched17);
            }
            if (synPredMatched17) {
                this.match("\r");
                if (this.inputState.guessing() == 0) {
                    try {
                        this.newline();
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
            } else {
                boolean synPredMatched19 = false;
                if (this.LA(1) == '\n') {
                    int _m19 = this.mark();
                    synPredMatched19 = true;
                    this.inputState.incGuessing();
                    try {
                        this.match("\n");
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched19 = false;
                    }
                    this.rewind(_m19);
                    this.inputState.decGuessing(synPredMatched19);
                }
                if (synPredMatched19) {
                    this.match("\n");
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else if (_tokenSet_5.member((int)this.LA(1))) {
                    this.match(_tokenSet_5);
                } else {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mWS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 452;
        int _cnt24 = 0;
        block15: while (true) {
            switch (this.LA(1)) {
                case ' ': {
                    this.match(' ');
                    break;
                }
                case '\t': {
                    this.match('\t');
                    break;
                }
                case '\f': {
                    this.match('\f');
                    break;
                }
                case '\u00a0': {
                    this.match('\u00a0');
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) == '\uffff') {
                        this.match("\r\n");
                        this.match('\uffff');
                        break;
                    }
                    if (this.LA(1) == '\r' && this.LA(2) == '\n') {
                        this.match("\r\n");
                        if (this.inputState.guessing() != 0) break;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    if (this.LA(1) == '\r' && this.LA(2) == '\uffff') {
                        this.match('\r');
                        this.match('\uffff');
                        break;
                    }
                    if (this.LA(1) == '\n' && this.LA(2) == '\uffff') {
                        this.match('\n');
                        this.match('\uffff');
                        break;
                    }
                    if (this.LA(1) == '\r') {
                        this.match('\r');
                        if (this.inputState.guessing() != 0) break;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    if (this.LA(1) == '\n') {
                        this.match('\n');
                        if (this.inputState.guessing() != 0) break;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                default: {
                    if (_cnt24 >= 1) break block15;
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            ++_cnt24;
        }
        if (this.inputState.guessing() == 0) {
            try {
                _ttype = -1;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void mSL_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block75: {
            int _saveIndex;
            int offset;
            int startLine;
            block72: {
                _token = null;
                _begin = this.text.length();
                _ttype = 453;
                startLine = this.getLine();
                offset = this.getOffset() + 2;
                _saveIndex = this.text.length();
                this.match("//");
                this.text.setLength(_saveIndex);
                if (this.LA(1) < '\u0000' || this.LA(1) > '\uffff' || this.util.isOSX()) {
                    if (this.LA(1) >= '\u0000' && this.LA(1) <= '\uffff' && this.util.isOSX()) {
                        while (_tokenSet_7.member((int)this.LA(1))) {
                            this.match(_tokenSet_7);
                        }
                        break block72;
                    } else {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                while (true) {
                    boolean synPredMatched30 = false;
                    if (this.LA(1) == '\r' && _tokenSet_6.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                        int _m30 = this.mark();
                        synPredMatched30 = true;
                        this.inputState.incGuessing();
                        try {
                            this.match('\r');
                            this.match(_tokenSet_6);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched30 = false;
                        }
                        this.rewind(_m30);
                        this.inputState.decGuessing(synPredMatched30);
                    }
                    if (synPredMatched30) {
                        this.match('\r');
                        if (this.inputState.guessing() == 0) {
                            try {
                                this.newline();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.match(_tokenSet_6);
                        continue;
                    }
                    if (!_tokenSet_7.member((int)this.LA(1))) break;
                    this.match(_tokenSet_7);
                }
            }
            switch (this.LA(1)) {
                case '\n': {
                    this.match('\n');
                    break;
                }
                case '\uffff': {
                    _saveIndex = this.text.length();
                    this.match('\uffff');
                    this.text.setLength(_saveIndex);
                    break;
                }
                default: {
                    if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                        this.match("\r\n");
                        break;
                    }
                    if (this.LA(1) == '\r' && (this.util.isOSX() || this.LA(2) == '\uffff')) {
                        this.match('\r');
                        break;
                    }
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            if (this.inputState.guessing() != 0) break block75;
            try {
                int tokenType;
                block73: {
                    String processedComment;
                    String comment;
                    String rawComment;
                    block85: {
                        block86: {
                            block87: {
                                block88: {
                                    block90: {
                                        String token;
                                        block89: {
                                            String firstIdentifier;
                                            block84: {
                                                block80: {
                                                    block81: {
                                                        boolean startSinglelinePragma;
                                                        block82: {
                                                            block83: {
                                                                block78: {
                                                                    String firstWord;
                                                                    String translateComment;
                                                                    block79: {
                                                                        block77: {
                                                                            block76: {
                                                                                int[] offsets = new int[]{offset, this.getOffset()};
                                                                                rawComment = this.getText();
                                                                                comment = this.getTrimmedText(rawComment, offsets);
                                                                                firstIdentifier = this.getFirstIdentifier(comment);
                                                                                this.util.collectTaskTag(firstIdentifier, comment, startLine, offsets[0], offsets[1], this.parserPath);
                                                                                translateComment = "";
                                                                                tokenType = -1;
                                                                                firstWord = DVTStringUtil.getFirstIdentifier((String)comment);
                                                                                processedComment = null;
                                                                                if (this.util.isCustomPragmaFirstIdentifier(firstWord)) {
                                                                                    processedComment = this.util.processComment(comment);
                                                                                }
                                                                                if (!"dvt_pragma_start_cuname".equals(firstIdentifier)) break block76;
                                                                                tokenType = 289;
                                                                                comment = comment.substring("dvt_pragma_start_cuname".length()).trim();
                                                                                this.text.setLength(_begin);
                                                                                this.text.append(comment);
                                                                                break block73;
                                                                            }
                                                                            if (!"dvt_pragma_end_cuname".equals(firstIdentifier)) break block77;
                                                                            tokenType = 290;
                                                                            comment = comment.substring("dvt_pragma_end_cuname".length()).trim();
                                                                            this.text.setLength(_begin);
                                                                            this.text.append(comment);
                                                                            break block73;
                                                                        }
                                                                        if (comment == null) break block78;
                                                                        translateComment = this.util.getTranslateUsingPragma(firstIdentifier, comment);
                                                                        if (comment.length() == translateComment.length()) break block78;
                                                                        if (!translateComment.startsWith("translate_off") || translateComment.length() != "translate_off".length() && !Character.isWhitespace(translateComment.charAt("translate_off".length()))) break block79;
                                                                        tokenType = 291;
                                                                        VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                                                                        newLexer.lS = this.lS;
                                                                        newLexer.util = this.util;
                                                                        newLexer.followImports = this.followImports;
                                                                        newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                                                                        newLexer.rfp = this.rfp;
                                                                        newLexer.parserPath = this.parserPath;
                                                                        newLexer.fileIndex = this.fileIndex;
                                                                        newLexer.setFilename(this.getFilename(), this.indexer, false);
                                                                        newLexer.ifdefID = "translate_off";
                                                                        if (this.isMacroReparsing()) {
                                                                            newLexer.setMacroTraceIgnore();
                                                                            newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                                                            newLexer.reparseMacro = this.reparseMacro;
                                                                            newLexer.reparseMacroName = this.reparseMacroName;
                                                                            newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                                                            newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                                                            newLexer.reparseFileName = this.reparseFileName;
                                                                            newLexer.reparseFileLine = this.reparseFileLine;
                                                                            newLexer.virtualOffset = this.virtualOffset;
                                                                        }
                                                                        newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                                                                        newLexer.kind = 2;
                                                                        this.lS.push(newLexer);
                                                                        newLexer.preprocessingType = 1;
                                                                        newLexer.preprocessingLine = this.getLine();
                                                                        newLexer.preprocessingFile = this.getFilename();
                                                                        CustomPragma customPragma = this.util.getStartCustomPragma(processedComment);
                                                                        if (customPragma != null) {
                                                                            this.util.addCustomPragmaUsage(new CustomPragmaUsage(CustomPragmaUsage.Kind.START, startLine, customPragma));
                                                                        } else {
                                                                            this.util.addCustomPragmaUsage(new CustomPragmaUsage(CustomPragmaUsage.Kind.START, this.getLine(), (CustomPragma)new TranslatePragma(firstWord)));
                                                                        }
                                                                        this.lS.addSkipDefine(newLexer);
                                                                        break block73;
                                                                    }
                                                                    if (translateComment.startsWith("translate_on") && (translateComment.length() == "translate_on".length() || Character.isWhitespace(translateComment.charAt("translate_on".length())))) {
                                                                        CustomPragma customPragma;
                                                                        tokenType = 291;
                                                                        if (this.lS.peek().preprocessingType == 1 || "translate_off".equals(this.lS.peek().ifdefID)) {
                                                                            int tmp = this.lS.peek().reparseFileLine;
                                                                            this.lS.pop(true);
                                                                            this.lS.peek().reparseFileLine = tmp;
                                                                            this.lS.removeSkipDefine(this);
                                                                        }
                                                                        if ((customPragma = this.util.getEndCustomPragma(processedComment)) != null) {
                                                                            this.util.addCustomPragmaUsage(new CustomPragmaUsage(CustomPragmaUsage.Kind.END, startLine, customPragma));
                                                                            break block73;
                                                                        } else {
                                                                            this.util.addCustomPragmaUsage(new CustomPragmaUsage(CustomPragmaUsage.Kind.END, this.getLine(), (CustomPragma)new TranslatePragma(firstWord)));
                                                                        }
                                                                    }
                                                                    break block73;
                                                                }
                                                                if (comment == null || firstIdentifier == null || !firstIdentifier.startsWith("@DVT_LINTER_WAIVER")) break block80;
                                                                boolean startMultilinePragma = comment.startsWith("@DVT_LINTER_WAIVER_START") && comment.length() > "@DVT_LINTER_WAIVER_START".length() && Character.isWhitespace(comment.charAt("@DVT_LINTER_WAIVER_START".length()));
                                                                boolean bl = startSinglelinePragma = comment.startsWith("@DVT_LINTER_WAIVER") && comment.length() > "@DVT_LINTER_WAIVER".length() && Character.isWhitespace(comment.charAt("@DVT_LINTER_WAIVER".length()));
                                                                if (!startMultilinePragma && !startSinglelinePragma) break block81;
                                                                comment = startMultilinePragma ? comment.substring("@DVT_LINTER_WAIVER_START".length()).trim() : comment.substring("@DVT_LINTER_WAIVER".length()).trim();
                                                                int index = 0;
                                                                String waiverName = "";
                                                                String waiverDescription = "";
                                                                if (comment.startsWith("\"")) {
                                                                    index = comment.indexOf(34, 1);
                                                                    if (index > 0) {
                                                                        waiverName = comment.substring(1, index);
                                                                        if ((comment = comment.substring(index + 1).trim()).startsWith("\"")) {
                                                                            index = comment.indexOf(34, 1);
                                                                            if (index > 0) {
                                                                                waiverDescription = comment.substring(1, index);
                                                                                comment = comment.substring(index + 1).trim();
                                                                            } else {
                                                                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - waiverName.length(), waiverName.length(), "Unterminated waiver name");
                                                                            }
                                                                        }
                                                                    } else {
                                                                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - waiverName.length(), waiverName.length(), "Unterminated waiver name");
                                                                    }
                                                                }
                                                                if ((index = this.indexOfWhitespace(comment)) <= 0) break block82;
                                                                WaiverStatus status = WaiverStatus.NONE;
                                                                status = this.util.isLinterSeverity(comment.substring(0, index));
                                                                if (status == WaiverStatus.NONE) break block83;
                                                                if (!this.lS.isSkip()) {
                                                                    comment = comment.substring(index).trim();
                                                                    String[] rules = comment.split("\\s*,\\s*");
                                                                    this.util.startLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), status, rules, waiverName, waiverDescription, false);
                                                                    if (startSinglelinePragma) {
                                                                        this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), waiverName, false);
                                                                    }
                                                                }
                                                                break block73;
                                                            }
                                                            if (!this.lS.isSkip()) {
                                                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Wrong waiver status. Must be one of DISABLE, ERROR, WARNING, INFO");
                                                                this.util.startLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), WaiverStatus.NONE, null, "", "", false);
                                                                if (startSinglelinePragma) {
                                                                    this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), "", false);
                                                                }
                                                            }
                                                            break block73;
                                                        }
                                                        if (!this.lS.isSkip()) {
                                                            this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Incomplete waiver statement");
                                                            this.util.startLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), WaiverStatus.NONE, null, "", "", false);
                                                            if (startSinglelinePragma) {
                                                                this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), "", false);
                                                            }
                                                        }
                                                        break block73;
                                                    }
                                                    if (firstIdentifier != null && firstIdentifier.equals("@DVT_LINTER_WAIVER_END") && !this.lS.isSkip()) {
                                                        comment = comment.substring("@DVT_LINTER_WAIVER_END".length()).trim();
                                                        int index = 0;
                                                        String waiverName = "";
                                                        if (comment.startsWith("\"")) {
                                                            index = comment.lastIndexOf(34);
                                                            if (index > 0) {
                                                                waiverName = comment.substring(1, index);
                                                            } else {
                                                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - waiverName.length(), waiverName.length(), "Unterminated waiver name");
                                                            }
                                                        }
                                                        this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), waiverName, false);
                                                    }
                                                    break block73;
                                                }
                                                if (comment == null || !IDVTConstants.DVT_UVMF_ROOT_PRAGMA_PATTERN.matcher(comment).matches()) break block84;
                                                if (IDVTConstants.DVT_UVMF_BEGIN_PRAGMA_PATTERN.matcher(comment).matches()) {
                                                    String waiverName = comment.trim().substring("pragma uvmf".length());
                                                    if ((waiverName = waiverName.substring(0, waiverName.length() - "begin".length()).trim()).trim().isEmpty()) {
                                                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - waiverName.length(), waiverName.length(), "Unterminated waiver name");
                                                    }
                                                    WaiverStatus status = WaiverStatus.ERROR;
                                                    if (!this.lS.isSkip()) {
                                                        this.util.startLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine() + 1, status, null, waiverName, "UVMF Custom Pragma Waiver", true);
                                                    }
                                                    break block73;
                                                } else if (IDVTConstants.DVT_UVMF_END_PRAGMA_PATTERN.matcher(comment).matches() && !this.lS.isSkip()) {
                                                    String waiverName = comment.trim().substring("pragma uvmf".length());
                                                    if ((waiverName = waiverName.substring(0, waiverName.length() - "end".length()).trim()).trim().isEmpty()) {
                                                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - waiverName.length(), waiverName.length(), "Unterminated waiver name");
                                                    }
                                                    this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine() - 1, waiverName, true);
                                                }
                                                break block73;
                                            }
                                            if (comment == null || comment.length() <= 27 || !"pragma".equals(firstIdentifier)) break block85;
                                            StringTokenizer tokenizer = new StringTokenizer(comment);
                                            token = null;
                                            if (!tokenizer.hasMoreElements() || !(token = tokenizer.nextToken()).equals("pragma")) break block86;
                                            if (!tokenizer.hasMoreElements() || !(token = tokenizer.nextToken()).equals("protect")) break block87;
                                            if (!tokenizer.hasMoreElements()) break block88;
                                            token = tokenizer.nextToken();
                                            if (!token.equals("begin_protected")) break block89;
                                            this.isEncrypted = true;
                                            this.util.setEncryptedFile(this.getFilename(), true);
                                            this.util.setEncryptedCodeLineSkip(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                                            EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(comment);
                                            EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(this.grabEncryptedData());
                                            break block73;
                                        }
                                        if (!this.isEncrypted || !token.equals("end_protected")) break block90;
                                        this.isEncrypted = false;
                                        this.util.setEncryptedCodeLineEnter(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                                        EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(comment);
                                        tokenType = 287;
                                        String replacement = EncryptedUtils.INSTANCE.getDecryptedCode();
                                        if (replacement != null) {
                                            EncryptedUtils.INSTANCE.clear();
                                            StringBuilder fullReplacement = new StringBuilder(replacement);
                                            char[] charvals = new char[fullReplacement.length()];
                                            fullReplacement.getChars(0, fullReplacement.length(), charvals, 0);
                                            CharArrayReader charir = new CharArrayReader(charvals);
                                            VlogLexer newLexer = new VlogLexer(charir, (Map<ANTLRHashString, Integer>)this.literals);
                                            newLexer.lS = this.lS;
                                            newLexer.parentLexer = this;
                                            newLexer.util = this.util;
                                            newLexer.followImports = this.followImports;
                                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                                            newLexer.rfp = this.rfp;
                                            newLexer.parserPath = this.parserPath;
                                            newLexer.fileIndex = this.fileIndex;
                                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                                            newLexer.reparseFileName = this.reparseFileName;
                                            newLexer.reparseFileLine = this.reparseFileLine;
                                            newLexer.virtualOffset = this.virtualOffset == null ? new VirtualOffset() : this.virtualOffset;
                                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                                            newLexer.kind = 3;
                                            this.lS.push(newLexer);
                                        }
                                        break block73;
                                    }
                                    if (this.isEncrypted) {
                                        EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(comment);
                                        EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(this.grabEncryptedData());
                                        break block73;
                                    } else if (this.fReparseStack == null || this.fReparseStack.length == 0) {
                                        this.util.addComment(new Comment(Comment.CommentStyle.SL_KIND, this.getLine(), this.getLine(), rawComment, (DVTLexerStack)this.lS, 2));
                                    }
                                    break block73;
                                }
                                if (this.isEncrypted) {
                                    EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(comment);
                                    EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(this.grabEncryptedData());
                                    break block73;
                                } else if (this.fReparseStack == null || this.fReparseStack.length == 0) {
                                    this.util.addComment(new Comment(Comment.CommentStyle.SL_KIND, this.getLine(), this.getLine(), rawComment, (DVTLexerStack)this.lS, 2));
                                }
                                break block73;
                            }
                            if (this.isEncrypted) {
                                EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(comment);
                                EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(this.grabEncryptedData());
                                break block73;
                            } else if (this.fReparseStack == null || this.fReparseStack.length == 0) {
                                this.util.addComment(new Comment(Comment.CommentStyle.SL_KIND, this.getLine(), this.getLine(), rawComment, (DVTLexerStack)this.lS, 2));
                            }
                            break block73;
                        }
                        if (this.isEncrypted) {
                            EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(comment);
                            EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(this.grabEncryptedData());
                            break block73;
                        } else if (this.fReparseStack == null || this.fReparseStack.length == 0) {
                            this.util.addComment(new Comment(Comment.CommentStyle.SL_KIND, this.getLine(), this.getLine(), rawComment, (DVTLexerStack)this.lS, 2));
                        }
                        break block73;
                    }
                    CustomPragma customPragma = this.util.getStartCustomPragma(processedComment);
                    if (customPragma != null) {
                        this.util.addCustomPragmaUsage(new CustomPragmaUsage(CustomPragmaUsage.Kind.START, startLine, customPragma));
                    } else {
                        customPragma = this.util.getEndCustomPragma(processedComment);
                        if (customPragma != null) {
                            this.util.addCustomPragmaUsage(new CustomPragmaUsage(CustomPragmaUsage.Kind.END, startLine, customPragma));
                        } else if (this.isEncrypted) {
                            EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(comment);
                            EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(this.grabEncryptedData());
                        } else if (this.fReparseStack == null || this.fReparseStack.length == 0) {
                            this.util.addComment(new Comment(Comment.CommentStyle.SL_KIND, this.getLine(), this.getLine(), rawComment, (DVTLexerStack)this.lS, 2));
                        }
                    }
                }
                if (this.LA(0) != '\uffff') {
                    this.newline();
                }
                _ttype = tokenType;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mWS_NEWLINE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 454;
        block10: while (true) {
            switch (this.LA(1)) {
                case ' ': {
                    this.match(' ');
                    continue block10;
                }
                case '\t': {
                    this.match('\t');
                    continue block10;
                }
                case '\f': {
                    this.match('\f');
                    continue block10;
                }
                case '\u00a0': {
                    this.match('\u00a0');
                    continue block10;
                }
            }
            break;
        }
        switch (this.LA(1)) {
            case '\n': {
                this.match('\n');
                break;
            }
            case '\r': {
                this.match('\r');
                if (this.LA(1) != '\n') break;
                this.match('\n');
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSVX_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block35: {
            block34: {
                _token = null;
                _begin = this.text.length();
                _ttype = 455;
                boolean synPredMatched47 = false;
                if (this.LA(1) == '\\' && this.LA(2) == 'S' && this.LA(3) == 'V') {
                    int _m47 = this.mark();
                    synPredMatched47 = true;
                    this.inputState.incGuessing();
                    try {
                        this.match("\\SVX");
                        switch (this.LA(1)) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': 
                            case '\u00a0': {
                                this.mWS(false);
                                break;
                            }
                            case '_': {
                                this.match("_version");
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched47 = false;
                    }
                    this.rewind(_m47);
                    this.inputState.decGuessing(synPredMatched47);
                }
                if (!synPredMatched47) break block34;
                this.match("\\SVX");
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mSVX_WS(false);
                        break;
                    }
                    case '_': {
                        this.match("_version");
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                while (true) {
                    boolean synPredMatched51 = false;
                    if (this.LA(1) == '\\' && this.LA(2) == 'S' && this.LA(3) == 'V') {
                        int _m51 = this.mark();
                        synPredMatched51 = true;
                        this.inputState.incGuessing();
                        try {
                            this.match("\\SVX");
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched51 = false;
                        }
                        this.rewind(_m51);
                        this.inputState.decGuessing(synPredMatched51);
                    }
                    if (synPredMatched51) {
                        this.match("\\SVX");
                        continue;
                    }
                    if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                        this.match("\r\n");
                        if (this.inputState.guessing() != 0) continue;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        continue;
                    }
                    if (!(this.LA(1) != '\\' || this.LA(2) < '\u0000' || this.LA(2) > '\uffff' || this.LA(2) == 'S' && this.LA(3) == 'V' && Character.isWhitespace(this.LA(4)))) {
                        this.match('\\');
                        continue;
                    }
                    if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff') {
                        this.match('\r');
                        if (this.inputState.guessing() != 0) continue;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        continue;
                    }
                    if (this.LA(1) == '\n') {
                        this.match('\n');
                        if (this.inputState.guessing() != 0) continue;
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        continue;
                    }
                    if (!_tokenSet_8.member((int)this.LA(1))) break;
                    this.match(_tokenSet_8);
                }
                switch (this.LA(1)) {
                    case '\uffff': {
                        this.match('\uffff');
                        break block35;
                    }
                    case '\\': {
                        this.match("\\SV");
                        this.mSVX_WS(false);
                        break block35;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
            }
            if (this.LA(1) == '\\' && this.LA(2) == 'S' && this.LA(3) == 'V') {
                this.match("\\SV");
                this.mSVX_WS(false);
            } else {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSVX_WS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 456;
        switch (this.LA(1)) {
            case ' ': {
                this.match(' ');
                break;
            }
            case '\t': {
                this.match('\t');
                break;
            }
            case '\f': {
                this.match('\f');
                break;
            }
            case '\u00a0': {
                this.match('\u00a0');
                break;
            }
            case '\n': 
            case '\r': {
                if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                    this.match("\r\n");
                } else if (this.LA(1) == '\r') {
                    this.match('\r');
                } else if (this.LA(1) == '\n') {
                    this.match('\n');
                } else {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                if (this.inputState.guessing() != 0) break;
                try {
                    this.newline();
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_ML_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block26: {
            _token = null;
            _begin = this.text.length();
            _ttype = 457;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            int startLine = this.getLine();
            int offset = this.getOffset() + 2;
            StringBuilder commentb = new StringBuilder();
            try {
                try {
                    this.match("/*");
                    while (true) {
                        if (this.LA(1) == '*' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(2) != '/') {
                            this.match('*');
                            continue;
                        }
                        if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            this.match("\r\n");
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                this.newline();
                                commentb.append("\r\n");
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            continue;
                        }
                        if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            this.match('\r');
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                this.newline();
                                commentb.append('\r');
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            continue;
                        }
                        if (this.LA(1) == '\n') {
                            this.match('\n');
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                this.newline();
                                commentb.append('\n');
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            continue;
                        }
                        if (!_tokenSet_9.member((int)this.LA(1))) break;
                        this.match(_tokenSet_9);
                        if (this.inputState.guessing() != 0) continue;
                        try {
                            commentb.append(this.LA(0));
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.match("*/");
                    if (this.inputState.guessing() == 0) {
                        try {
                            int[] offsets = new int[]{offset, this.getOffset() - 2};
                            String comment = this.getTrimmedText(commentb.toString(), offsets);
                            String firstIdentifier = this.getFirstIdentifier(comment);
                            this.util.collectTaskTag(firstIdentifier, comment, startLine, offsets[0], offsets[1], this.parserPath);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void mML_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block46: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block44: {
                _token = null;
                _begin = this.text.length();
                _ttype = 458;
                userMark = null;
                finalRunnable = null;
                int startLine = this.getLine();
                int offset = this.getOffset() + 2;
                try {
                    try {
                        int _saveIndex = this.text.length();
                        this.match("/*");
                        this.text.setLength(_saveIndex);
                        while (true) {
                            if (this.LA(1) == '*' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(2) != '/') {
                                this.match('*');
                                continue;
                            }
                            if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                                this.match("\r\n");
                                if (this.inputState.guessing() != 0) continue;
                                try {
                                    this.newline();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                continue;
                            }
                            if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                                this.match('\r');
                                if (this.inputState.guessing() != 0) continue;
                                try {
                                    this.newline();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                continue;
                            }
                            if (this.LA(1) == '\n') {
                                this.match('\n');
                                if (this.inputState.guessing() != 0) continue;
                                try {
                                    this.newline();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                continue;
                            }
                            if (!_tokenSet_9.member((int)this.LA(1))) break;
                            this.match(_tokenSet_9);
                        }
                        _saveIndex = this.text.length();
                        this.match("*/");
                        this.text.setLength(_saveIndex);
                        if (this.inputState.guessing() != 0) break block44;
                        try {
                            String rawComment;
                            block49: {
                                String firstIdentifier;
                                String comment;
                                block50: {
                                    boolean startSinglelinePragma;
                                    block51: {
                                        block52: {
                                            block47: {
                                                String translateComment;
                                                block48: {
                                                    _ttype = -1;
                                                    int[] offsets = new int[]{offset, this.getOffset()};
                                                    rawComment = this.getText();
                                                    comment = this.getTrimmedText(this.getText(), offsets);
                                                    firstIdentifier = this.getFirstIdentifier(comment);
                                                    this.util.collectTaskTag(firstIdentifier, comment, startLine, offsets[0], offsets[1], this.parserPath);
                                                    translateComment = "";
                                                    if (comment == null) break block47;
                                                    translateComment = this.util.getTranslateUsingPragma(firstIdentifier, comment);
                                                    if (comment.length() == translateComment.length()) break block47;
                                                    if (!translateComment.startsWith("translate_off") || translateComment.length() != "translate_off".length() && !Character.isWhitespace(translateComment.charAt("translate_off".length()))) break block48;
                                                    VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                                                    newLexer.lS = this.lS;
                                                    newLexer.util = this.util;
                                                    newLexer.followImports = this.followImports;
                                                    newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                                                    newLexer.rfp = this.rfp;
                                                    newLexer.parserPath = this.parserPath;
                                                    newLexer.fileIndex = this.fileIndex;
                                                    newLexer.setFilename(this.getFilename(), this.indexer, false);
                                                    newLexer.ifdefID = "translate_off";
                                                    if (this.isMacroReparsing()) {
                                                        newLexer.setMacroTraceIgnore();
                                                        newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                                        newLexer.reparseMacro = this.reparseMacro;
                                                        newLexer.reparseMacroName = this.reparseMacroName;
                                                        newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                                        newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                                        newLexer.reparseFileName = this.reparseFileName;
                                                        newLexer.reparseFileLine = this.reparseFileLine;
                                                        newLexer.virtualOffset = this.virtualOffset;
                                                    }
                                                    newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                                                    newLexer.kind = 2;
                                                    this.lS.push(newLexer);
                                                    newLexer.preprocessingType = 1;
                                                    newLexer.preprocessingLine = this.getLine();
                                                    newLexer.preprocessingFile = this.getFilename();
                                                    if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                                        this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), this.getLine(), this.getColumn());
                                                    }
                                                    this.lS.addSkipDefine(newLexer);
                                                    break block49;
                                                }
                                                if (!translateComment.startsWith("translate_on") || translateComment.length() != "translate_on".length() && !Character.isWhitespace(translateComment.charAt("translate_on".length()))) break block49;
                                                if (this.lS.peek().preprocessingType != 1 && !"translate_off".equals(this.lS.peek().ifdefID)) {
                                                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - "translate_on".length(), "translate_on".length(), "Unexpected 'translate_on' pragma (no starting 'translate_off' found)");
                                                    break block49;
                                                } else {
                                                    int tmp = this.lS.peek().reparseFileLine;
                                                    this.lS.pop(true);
                                                    this.lS.peek().reparseFileLine = tmp;
                                                    this.lS.removeSkipDefine(this);
                                                    if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                                        this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), this.getLine(), this.getColumn());
                                                    }
                                                }
                                                break block49;
                                            }
                                            if (comment == null || firstIdentifier == null || !firstIdentifier.startsWith("@DVT_LINTER_WAIVER")) break block49;
                                            boolean startMultilinePragma = comment.startsWith("@DVT_LINTER_WAIVER_START") && comment.length() > "@DVT_LINTER_WAIVER_START".length() && Character.isWhitespace(comment.charAt("@DVT_LINTER_WAIVER_START".length()));
                                            boolean bl = startSinglelinePragma = comment.startsWith("@DVT_LINTER_WAIVER") && comment.length() > "@DVT_LINTER_WAIVER".length() && Character.isWhitespace(comment.charAt("@DVT_LINTER_WAIVER".length()));
                                            if (!startMultilinePragma && !startSinglelinePragma) break block50;
                                            comment = startMultilinePragma ? comment.substring("@DVT_LINTER_WAIVER_START".length()).trim() : comment.substring("@DVT_LINTER_WAIVER".length()).trim();
                                            int index = 0;
                                            String waiverName = "";
                                            String waiverDescription = "";
                                            if (comment.startsWith("\"")) {
                                                index = comment.indexOf(34, 1);
                                                if (index > 0) {
                                                    waiverName = comment.substring(1, index);
                                                    if ((comment = comment.substring(index + 1).trim()).startsWith("\"")) {
                                                        index = comment.indexOf(34, 1);
                                                        if (index > 0) {
                                                            waiverDescription = comment.substring(1, index);
                                                            comment = comment.substring(index + 1).trim();
                                                        } else {
                                                            this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - waiverName.length(), waiverName.length(), "Unterminated waiver name");
                                                        }
                                                    }
                                                } else {
                                                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - waiverName.length(), waiverName.length(), "Unterminated waiver name");
                                                }
                                            }
                                            if ((index = this.indexOfWhitespace(comment)) <= 0) break block51;
                                            WaiverStatus status = WaiverStatus.NONE;
                                            status = this.util.isLinterSeverity(comment.substring(0, index));
                                            if (status == WaiverStatus.NONE) break block52;
                                            if (!this.lS.isSkip()) {
                                                comment = comment.substring(index).trim();
                                                String[] rules = comment.split("\\s*,\\s*");
                                                this.util.startLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), status, rules, waiverName, waiverDescription, false);
                                                if (startSinglelinePragma) {
                                                    this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), waiverName, false);
                                                }
                                            }
                                            break block49;
                                        }
                                        if (!this.lS.isSkip()) {
                                            this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Wrong waiver status. Must be one of DISABLE, ERROR, WARNING, INFO");
                                            this.util.startLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), WaiverStatus.NONE, null, "", "", false);
                                            if (startSinglelinePragma) {
                                                this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), "", false);
                                            }
                                        }
                                        break block49;
                                    }
                                    if (!this.lS.isSkip()) {
                                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Incomplete waiver statement");
                                        this.util.startLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), WaiverStatus.NONE, null, "", "", false);
                                        if (startSinglelinePragma) {
                                            this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), "", false);
                                        }
                                    }
                                    break block49;
                                }
                                if (firstIdentifier != null && firstIdentifier.equals("@DVT_LINTER_WAIVER_END") && !this.lS.isSkip()) {
                                    comment = comment.substring("@DVT_LINTER_WAIVER_END".length()).trim();
                                    int index = 0;
                                    String waiverName = "";
                                    if (comment.startsWith("\"")) {
                                        index = comment.lastIndexOf(34);
                                        if (index > 0) {
                                            waiverName = comment.substring(1, index);
                                        } else {
                                            this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - waiverName.length(), waiverName.length(), "Unterminated waiver name");
                                        }
                                    }
                                    this.util.endLinterWaiverPragma(this.getFilename(), this.getLanguageSyntax(), this.getLine(), waiverName, false);
                                }
                            }
                            if (this.fReparseStack == null || this.fReparseStack.length == 0) {
                                this.util.addComment(new Comment(Comment.CommentStyle.ML_KIND, startLine, this.getLine(), rawComment, (DVTLexerStack)this.lS, 2));
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block46;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOMMA(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 459;
        this.match(',');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSEMI(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 460;
        this.match(';');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 461;
        this.match(':');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 462;
        this.match('*');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDIV(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 463;
        this.match('/');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMOD(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 464;
        this.match('%');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPLUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 465;
        this.match('+');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPLUS_PLUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 466;
        this.match("++");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMINUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 467;
        this.match('-');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMINUS_MINUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 468;
        this.match("--");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 469;
        if (this.LA(3) == '>') {
            throw this.getSemanticException(" LA(3) != '>' ");
        }
        this.match(">>");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 470;
        if (this.LA(3) == '<') {
            throw this.getSemanticException(" LA(3) != '<' ");
        }
        this.match("<<");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 471;
        this.match('&');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBNAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 472;
        this.match("~&");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 473;
        this.match('|');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBNOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 474;
        this.match("~|");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBXOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 475;
        this.match('^');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBXNOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 476;
        this.match("^~");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBXNOR_1(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 477;
        this.match("~^");
        if (this.inputState.guessing() == 0) {
            try {
                _ttype = 476;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBNOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 478;
        this.match('~');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLNOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 479;
        this.match('!');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 480;
        if (this.LA(3) == '&') {
            throw this.getSemanticException(" LA(3) != '&' ");
        }
        this.match("&&");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 481;
        this.match("||");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 482;
        if (this.LA(3) == '=') {
            throw this.getSemanticException(" LA(3) != '=' ");
        }
        this.match("==");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mNOT_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 483;
        if (this.LA(3) == '=') {
            throw this.getSemanticException(" LA(3) != '=' ");
        }
        this.match("!=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mEQUAL_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 484;
        if (this.LA(3) != '=') {
            throw this.getSemanticException(" LA(3) == '=' ");
        }
        this.match("===");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mNOT_EQUAL_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 485;
        if (this.LA(3) != '=') {
            throw this.getSemanticException(" LA(3) == '=' ");
        }
        this.match("!==");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 486;
        this.match('<');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mGT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 487;
        this.match('>');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 488;
        this.match("<=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mGE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 489;
        this.match(">=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLPAREN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 490;
        this.match('(');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRPAREN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 491;
        this.match(')');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLBRACK(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 492;
        this.match('[');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRBRACK(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 493;
        this.match(']');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLCURLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 494;
        this.match('{');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRCURLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 495;
        this.match('}');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mAT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 496;
        this.match('@');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mAT_AT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 497;
        this.match("@@");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mEQ(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 498;
        this.match('=');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mQUESTION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 499;
        this.match('?');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void mPOUND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 500;
        if (this.LA(1) == '#' && _tokenSet_10.member((int)this.LA(2)) && this.util.isCpreprocEnabled()) {
            boolean synPredMatched112 = false;
            if (this.LA(1) == '#' && this.LA(2) == 'i' && this.LA(3) == 'f') {
                int _m112 = this.mark();
                synPredMatched112 = true;
                this.inputState.incGuessing();
                try {
                    this.match("#if");
                    this.mDEFINE_WS(false);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched112 = false;
                }
                this.rewind(_m112);
                this.inputState.decGuessing(synPredMatched112);
            }
            if (synPredMatched112) {
                this.mC_IF_DEF(false);
                if (this.inputState.guessing() == 0) {
                    try {
                        _ttype = 565;
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
            } else {
                boolean synPredMatched114 = false;
                if (this.LA(1) == '#' && this.LA(2) == 'i' && this.LA(3) == 'f') {
                    int _m114 = this.mark();
                    synPredMatched114 = true;
                    this.inputState.incGuessing();
                    try {
                        this.match("#ifdef");
                        this.mDEFINE_WS(false);
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched114 = false;
                    }
                    this.rewind(_m114);
                    this.inputState.decGuessing(synPredMatched114);
                }
                if (synPredMatched114) {
                    this.mC_IFDEF(false);
                    if (this.inputState.guessing() == 0) {
                        try {
                            _ttype = 565;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else {
                    boolean synPredMatched116 = false;
                    if (this.LA(1) == '#' && this.LA(2) == 'i' && this.LA(3) == 'f') {
                        int _m116 = this.mark();
                        synPredMatched116 = true;
                        this.inputState.incGuessing();
                        try {
                            this.match("#ifndef");
                            this.mDEFINE_WS(false);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched116 = false;
                        }
                        this.rewind(_m116);
                        this.inputState.decGuessing(synPredMatched116);
                    }
                    if (synPredMatched116) {
                        this.mC_IFNDEF(false);
                        if (this.inputState.guessing() == 0) {
                            try {
                                _ttype = 565;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else {
                        boolean synPredMatched119 = false;
                        if (this.LA(1) == '#' && this.LA(2) == 'e' && this.LA(3) == 'l') {
                            int _m119 = this.mark();
                            synPredMatched119 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("#else");
                                switch (this.LA(1)) {
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case '\r': 
                                    case ' ': 
                                    case '\u00a0': {
                                        this.mWS(false);
                                        break;
                                    }
                                    case '/': {
                                        this.match("//");
                                        break;
                                    }
                                    default: {
                                        if (this.LA(1) != '\uffff') {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched119 = false;
                            }
                            this.rewind(_m119);
                            this.inputState.decGuessing(synPredMatched119);
                        }
                        if (synPredMatched119) {
                            this.mC_ELSE_DEF(false);
                            if (this.inputState.guessing() == 0) {
                                try {
                                    _ttype = 565;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else {
                            boolean synPredMatched121 = false;
                            if (this.LA(1) == '#' && this.LA(2) == 'e' && this.LA(3) == 'l') {
                                int _m121 = this.mark();
                                synPredMatched121 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match("#elif");
                                    this.mDEFINE_WS(false);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched121 = false;
                                }
                                this.rewind(_m121);
                                this.inputState.decGuessing(synPredMatched121);
                            }
                            if (synPredMatched121) {
                                this.mC_ELIF_DEF(false);
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        _ttype = 565;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                boolean synPredMatched123 = false;
                                if (this.LA(1) == '#' && _tokenSet_11.member((int)this.LA(2)) && _tokenSet_12.member((int)this.LA(3))) {
                                    int _m123 = this.mark();
                                    synPredMatched123 = true;
                                    this.inputState.incGuessing();
                                    try {
                                        this.match("#include");
                                        this.mDEFINE_WS(false);
                                    }
                                    catch (RecognitionException recognitionException) {
                                        synPredMatched123 = false;
                                    }
                                    this.rewind(_m123);
                                    this.inputState.decGuessing(synPredMatched123);
                                }
                                if (synPredMatched123) {
                                    this.match('#');
                                    this.mINCLUDE(false);
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            _ttype = 565;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                } else {
                                    boolean synPredMatched126 = false;
                                    if (this.LA(1) == '#' && this.LA(2) == 'e' && this.LA(3) == 'n') {
                                        int _m126 = this.mark();
                                        synPredMatched126 = true;
                                        this.inputState.incGuessing();
                                        try {
                                            this.match("#endif");
                                            if (this.LA(1) != '\uffff' && Character.isJavaIdentifierPart(this.LA(1))) {
                                                throw this.getSemanticException(" LA(1) == EOF_CHAR || !Character.isJavaIdentifierPart(LA(1)) ");
                                            }
                                        }
                                        catch (RecognitionException recognitionException) {
                                            synPredMatched126 = false;
                                        }
                                        this.rewind(_m126);
                                        this.inputState.decGuessing(synPredMatched126);
                                    }
                                    if (synPredMatched126) {
                                        this.mC_ENDIF_DEF(false);
                                        if (this.inputState.guessing() == 0) {
                                            try {
                                                _ttype = 565;
                                            }
                                            catch (Exception ex) {
                                                this.userExceptionHandler(ex);
                                            }
                                        }
                                    } else {
                                        boolean synPredMatched110 = false;
                                        if (this.LA(1) == '#' && this.LA(2) == 'd') {
                                            int _m110 = this.mark();
                                            synPredMatched110 = true;
                                            this.inputState.incGuessing();
                                            try {
                                                this.match("#define");
                                                this.mDEFINE_WS(false);
                                            }
                                            catch (RecognitionException recognitionException) {
                                                synPredMatched110 = false;
                                            }
                                            this.rewind(_m110);
                                            this.inputState.decGuessing(synPredMatched110);
                                        }
                                        if (!synPredMatched110) throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        this.mC_DEFINE_DEFINITION(false);
                                        if (this.inputState.guessing() == 0) {
                                            try {
                                                _ttype = 565;
                                            }
                                            catch (Exception ex) {
                                                this.userExceptionHandler(ex);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            if (this.LA(1) != '#') throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            this.match("#");
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_WS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 567;
        switch (this.LA(1)) {
            case ' ': {
                this.match(' ');
                break;
            }
            case '\t': {
                this.match('\t');
                break;
            }
            case '\f': {
                this.match('\f');
                break;
            }
            case '\u00a0': {
                this.match('\u00a0');
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_DEFINE_DEFINITION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block19: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block18: {
                _token = null;
                _begin = this.text.length();
                _ttype = 626;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                List macroText = OptimizedUtils.listCreate((int)1);
                List<VlogMacroParameter> parameters = null;
                int offset = this.getOffset();
                int line = this.getLine();
                try {
                    try {
                        this.match("#define");
                        int _cnt905 = 0;
                        while (true) {
                            if (!_tokenSet_13.member((int)this.LA(1))) {
                                if (_cnt905 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS(false);
                            ++_cnt905;
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                line = this.getLine();
                                offset = this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mDEFINE_ID(true, true, true);
                        id = this._returnToken;
                        parameters = this.mDEFINE_MACRO_PARAM(false);
                        this.mDEFINE_MACRO_TEXT(false, macroText);
                        if (this.inputState.guessing() != 0) break block18;
                        try {
                            try {
                                this.util.addDefine(id.getText(), new VlogMacroText(parameters, macroText), this.lS.isSkip(), new LineInfo(line, offset, -1), this.getLineInfo(), this.lS.getLastLine(), this.lS.getReparseStackLT(), true);
                            }
                            catch (VlogException e) {
                                this.reportError(e.getSeverity(), this.getFilename(), line, offset, id.getLength(), e.getMessage());
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_IF_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block21: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block20: {
                _token = null;
                _begin = this.text.length();
                _ttype = 627;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                try {
                    try {
                        this.match("#if");
                        int _cnt908 = 0;
                        while (true) {
                            if (!_tokenSet_13.member((int)this.LA(1)) || this.LA(2) < '\u0000' || this.LA(2) > '\ufffe') {
                                if (_cnt908 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS(false);
                            ++_cnt908;
                        }
                        this.mC_EXPRESSION(true);
                        id = this._returnToken;
                        if (this.inputState.guessing() != 0) break block20;
                        try {
                            int value = 0;
                            try {
                                String expression = id.getText();
                                value = ExprEval.evaluate((String)expression, (String)this.getFilename(), (IExprValueProvider)this.util);
                            }
                            catch (RecognitionException ex) {
                                this.reportError("*** Error: ", ex.getFilename(), ex.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                            }
                            catch (Exception ex) {
                                DVTLogger.INSTANCE.logError((Throwable)ex);
                            }
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = id.getText();
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 1;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (value != 0) {
                                this.util.debug("Lexing #if ", id.getText());
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                newLexer.skipElseBranch = true;
                                break block20;
                            }
                            this.util.debug("Skipping #if ", id.getText());
                            if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                            }
                            this.lS.addSkipDefine(newLexer);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_IFDEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block19: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block18: {
                _token = null;
                _begin = this.text.length();
                _ttype = 630;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                VlogMacroInfo macro = null;
                try {
                    try {
                        this.match("#ifdef");
                        int _cnt926 = 0;
                        while (true) {
                            if (!_tokenSet_13.member((int)this.LA(1))) {
                                if (_cnt926 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS(false);
                            ++_cnt926;
                        }
                        this.mDEFINE_ID(true, false, true);
                        id = this._returnToken;
                        if (this.inputState.guessing() != 0) break block18;
                        try {
                            this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                            macro = this.util.getDefine(id.getText(), true);
                            if (!this.lS.isSkip()) {
                                this.dependsOn(id.getText(), macro == null);
                            }
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = id.getText();
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 1;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (macro != null) {
                                this.util.debug("Lexing #ifdef ", id.getText());
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                newLexer.skipElseBranch = true;
                                break block18;
                            }
                            this.util.debug("Skipping #ifdef ", id.getText());
                            if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                            }
                            this.lS.addSkipDefine(newLexer);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_IFNDEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block19: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block18: {
                _token = null;
                _begin = this.text.length();
                _ttype = 631;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                VlogMacroInfo macro = null;
                try {
                    try {
                        this.match("#ifndef");
                        int _cnt929 = 0;
                        while (true) {
                            if (!_tokenSet_13.member((int)this.LA(1))) {
                                if (_cnt929 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS(false);
                            ++_cnt929;
                        }
                        this.mDEFINE_ID(true, false, true);
                        id = this._returnToken;
                        if (this.inputState.guessing() != 0) break block18;
                        try {
                            this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                            macro = this.util.getDefine(id.getText(), true);
                            if (!this.lS.isSkip()) {
                                this.dependsOn(id.getText(), macro == null);
                            }
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = id.getText();
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 1;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (macro != null) {
                                this.util.debug("Skipping #ifndef ", id.getText());
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                this.lS.addSkipDefine(newLexer);
                                break block18;
                            }
                            this.util.debug("Lexing #ifndef ", id.getText());
                            if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                            }
                            newLexer.skipElseBranch = true;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_ELSE_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block18: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block17: {
                _token = null;
                _begin = this.text.length();
                _ttype = 632;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        this.match("#else");
                        if (this.inputState.guessing() != 0) break block17;
                        try {
                            if (this.lS.peek().preprocessingType != 1 && this.lS.peek().preprocessingType != 2) {
                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - 5, 5, "Unexpected #else (no starting #ifdef/#ifndef found)");
                                break block17;
                            }
                            String tmp = this.lS.peek().ifdefID;
                            this.lS.pop(true);
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = tmp;
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 3;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (this.lS.containsSkipDefine(this) && !this.skipElseBranch) {
                                this.util.debug("Lexing #else");
                                if (this.lS.fSkipDefine.size() == 1 && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), this.getLine(), this.getColumn());
                                }
                            } else {
                                this.util.debug("Skipping #else ");
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), this.getLine(), this.getColumn());
                                }
                                this.lS.addSkipDefine(newLexer);
                            }
                            this.lS.removeSkipDefine(this);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_ELIF_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block23: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block22: {
                _token = null;
                _begin = this.text.length();
                _ttype = 628;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                try {
                    try {
                        this.match("#elif");
                        int _cnt911 = 0;
                        while (true) {
                            if (!_tokenSet_13.member((int)this.LA(1)) || this.LA(2) < '\u0000' || this.LA(2) > '\ufffe') {
                                if (_cnt911 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS(false);
                            ++_cnt911;
                        }
                        this.mC_EXPRESSION(true);
                        id = this._returnToken;
                        if (this.inputState.guessing() != 0) break block22;
                        try {
                            if (this.lS.peek().preprocessingType != 1 && this.lS.peek().preprocessingType != 2) {
                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Unexpected #elsif (no starting #if found)");
                                break block22;
                            }
                            int tmp = this.lS.peek().reparseFileLine;
                            String tmp2 = this.lS.peek().ifdefID;
                            this.lS.pop(true);
                            this.lS.peek().reparseFileLine = tmp;
                            int value = 0;
                            try {
                                String expression = id.getText();
                                value = ExprEval.evaluate((String)expression, (String)this.getFilename(), (IExprValueProvider)this.util);
                            }
                            catch (RecognitionException ex) {
                                this.reportError("*** Error: ", ex.getFilename(), ex.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                            }
                            catch (Exception ex) {
                                DVTLogger.INSTANCE.logError((Throwable)ex);
                            }
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = tmp2;
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 2;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (value != 0 && this.lS.containsSkipDefine(this) && !this.skipElseBranch) {
                                this.util.debug("Lexing #elif ", id.getText());
                                if (this.lS.fSkipDefine.size() == 1 && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                newLexer.skipElseBranch = true;
                            } else {
                                this.util.debug("Skipping #elif ", id.getText());
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                newLexer.skipElseBranch = this.skipElseBranch;
                                this.lS.addSkipDefine(newLexer);
                            }
                            this.lS.removeSkipDefine(this);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mINCLUDE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block60: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block59: {
                _token = null;
                _begin = this.text.length();
                _ttype = 601;
                userMark = null;
                finalRunnable = null;
                Token f1 = null;
                Token f2 = null;
                Token f3 = null;
                Token f4 = null;
                String fileName = null;
                String origFileName = null;
                boolean doExecute = true;
                int offset = -1;
                try {
                    try {
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            this.mDEFINE_WS(false);
                        }
                        this.match("include");
                        this.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
                        if (this.inputState.guessing() == 0) {
                            try {
                                offset = this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        switch (this.LA(1)) {
                            case '\"': {
                                this.mSTRING(true);
                                f1 = this._returnToken;
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    f4 = f1;
                                    fileName = f4.getText().trim();
                                    fileName = fileName.substring(1, fileName.length() - 1);
                                    doExecute = true;
                                    origFileName = fileName;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case '<': {
                                this.match('<');
                                this.mFILE_NAME(true);
                                f2 = this._returnToken;
                                this.match('>');
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    f4 = f2;
                                    fileName = f4.getText().trim();
                                    doExecute = true;
                                    origFileName = fileName;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            default: {
                                boolean synPredMatched747 = false;
                                if (this.LA(1) == '`' && this.LA(2) == '\"') {
                                    int _m747 = this.mark();
                                    synPredMatched747 = true;
                                    this.inputState.incGuessing();
                                    try {
                                        this.match("`\"");
                                    }
                                    catch (RecognitionException recognitionException) {
                                        synPredMatched747 = false;
                                    }
                                    this.rewind(_m747);
                                    this.inputState.decGuessing(synPredMatched747);
                                }
                                if (synPredMatched747) {
                                    this.mREPLACE_MACRO_STRING(true);
                                    f3 = this._returnToken;
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        f4 = f3;
                                        fileName = f4.getText();
                                        if (fileName.length() > 0 && fileName.charAt(0) == '\"' && fileName.charAt(fileName.length() - 1) == '\"') {
                                            fileName = fileName.substring(1, fileName.length() - 1).trim();
                                        }
                                        doExecute = true;
                                        origFileName = fileName;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                if (this.LA(1) == '`' && _tokenSet_14.member((int)this.LA(2))) {
                                    this.mDEFINE_REPLACE(false, "`include ", false);
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        doExecute = false;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                boolean synPredMatched750 = false;
                                int _m750 = this.mark();
                                synPredMatched750 = true;
                                this.inputState.incGuessing();
                                try {
                                    switch (this.LA(1)) {
                                        case '/': {
                                            this.match("/");
                                            break;
                                        }
                                        case '\\': {
                                            this.match("\\");
                                            break;
                                        }
                                        case 'A': 
                                        case 'B': 
                                        case 'C': 
                                        case 'D': 
                                        case 'E': 
                                        case 'F': 
                                        case 'G': 
                                        case 'H': 
                                        case 'I': 
                                        case 'J': 
                                        case 'K': 
                                        case 'L': 
                                        case 'M': 
                                        case 'N': 
                                        case 'O': 
                                        case 'P': 
                                        case 'Q': 
                                        case 'R': 
                                        case 'S': 
                                        case 'T': 
                                        case 'U': 
                                        case 'V': 
                                        case 'W': 
                                        case 'X': 
                                        case 'Y': 
                                        case 'Z': 
                                        case '_': 
                                        case 'a': 
                                        case 'b': 
                                        case 'c': 
                                        case 'd': 
                                        case 'e': 
                                        case 'f': 
                                        case 'g': 
                                        case 'h': 
                                        case 'i': 
                                        case 'j': 
                                        case 'k': 
                                        case 'l': 
                                        case 'm': 
                                        case 'n': 
                                        case 'o': 
                                        case 'p': 
                                        case 'q': 
                                        case 'r': 
                                        case 's': 
                                        case 't': 
                                        case 'u': 
                                        case 'v': 
                                        case 'w': 
                                        case 'x': 
                                        case 'y': 
                                        case 'z': {
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    this.mINTERNAL_ID_1(false);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched750 = false;
                                }
                                this.rewind(_m750);
                                this.inputState.decGuessing(synPredMatched750);
                                if (synPredMatched750) {
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        doExecute = false;
                                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "The file path after `include must be surrounded by quotes", null, null);
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (this.inputState.guessing() != 0) break block59;
                        try {
                            if (!doExecute || this.lS.isSkip()) break block59;
                            this.util.debug("Lexing `include ", fileName);
                            if (this.util.isEnableIncludeEnvVarExpansion()) {
                                fileName = this.util.replaceAllSystemVariables(fileName);
                            }
                            File file = new File(fileName);
                            String fullFileName = fileName;
                            boolean fileExists = false;
                            if (!file.isAbsolute()) {
                                Object[] results = this.findFileInRelativePath(fileName);
                                if (results != null) {
                                    file = (File)results[0];
                                    fullFileName = (String)results[1];
                                    fileExists = (Boolean)results[2];
                                }
                            } else {
                                Object[] results;
                                String originalFullFileName = fullFileName;
                                fullFileName = this.util.getCrossPlatformPath(fullFileName);
                                file = new File(fullFileName = this.util.getFileSubstitute(fullFileName));
                                fileExists = this.util.isFile(file);
                                if (!fileExists && originalFullFileName.indexOf("/") == 0 && (results = this.findFileInRelativePath(originalFullFileName = originalFullFileName.replaceFirst("^/+", ""))) != null) {
                                    file = (File)results[0];
                                    fullFileName = (String)results[1];
                                    fileExists = (Boolean)results[2];
                                }
                            }
                            if (f4 != null && file != null && fileName != null && !fileExists) {
                                String input = fileName;
                                String output = this.util.getCrossPlatformPath(input);
                                if (input.equals(output)) {
                                    DVTLogger.INSTANCE.logInfo("Cannot open include file: \"" + input + "\"");
                                } else {
                                    DVTLogger.INSTANCE.logInfo("Cannot open include file: \"" + input + "\", mapped to: \"" + output + "\"");
                                }
                                this.util.includedFileNotFound(origFileName);
                                HashMap<String, Object> attributes = new HashMap<String, Object>();
                                attributes.put("QUICKFIX_ELEMENT_NAME", fileName);
                                attributes.put("QUICKFIX_KIND", 39);
                                this.reportError("*** Error: ", this.getFilename(), f4.getLine(), offset, input.length() + 2, "Cannot open `include file \"" + input + "\"", null, attributes);
                                break block59;
                            }
                            if (file != null && this.util.isIgnored(file)) {
                                this.util.reportMessage("Skip file: ", file.getPath());
                                this.lS.notifyParsingListeners(new VlogSkipInfo(file.getAbsolutePath(), 0, this.getLanguageSyntax()));
                                break block59;
                            }
                            boolean newIncludedFile = this.util.isNewIncludedFile(file);
                            this.mustGenerateIncrementalInclude = !this.followImports && !newIncludedFile;
                            boolean bl = newIncludedFile = !this.followImports && newIncludedFile;
                            if (file != null && (this.followImports || newIncludedFile) && !this.lS.getInterrupt()) {
                                if (newIncludedFile || this.util.shouldRecompile(file, this.getLine(), this.getOffset())) {
                                    if (newIncludedFile) {
                                        this.util.startNewIncludedFile();
                                    } else {
                                        this.util.reportMessage("Parsing file: ", file.getPath());
                                    }
                                    this.notAllowed(75);
                                    ParserPath fileParserPath = new ParserPath(file.getAbsolutePath());
                                    boolean isPVlogPreprocessingFile = this.util.isPVlogPreprocessing(fileParserPath);
                                    InputStream inputStream = isPVlogPreprocessingFile ? this.util.createPVlogCompilationInputStream(fileParserPath) : FileInputStreamUtils.createStream((File)file);
                                    if (!this.util.isProtected(inputStream)) {
                                        inputStream = new MD5InputStream(inputStream, file);
                                        VlogLexer newLexer = new VlogLexer(inputStream, (Map<ANTLRHashString, Integer>)this.literals);
                                        newLexer.startFileDef = true;
                                        newLexer.newIncludedFile = newIncludedFile;
                                        newLexer.lS = this.lS;
                                        newLexer.util = this.util;
                                        newLexer.loading = true;
                                        newLexer.followImports = this.followImports;
                                        newLexer.rfp = this.rfp;
                                        newLexer.setFilename(file.getAbsolutePath(), null, true);
                                        newLexer.defaultLanguageSyntax = this.getFilename() != null && new File(this.getFilename()).getName().startsWith("__vlog__") || this.util.isUseIncludeExtensionLanguageSyntax() ? this.util.getLanguageSyntaxByExtension(file.getName()) : this.defaultLanguageSyntax;
                                        if (this.isMacroReparsing()) {
                                            newLexer.setMacroTraceIgnore();
                                            newLexer.reparseMacro = this.reparseMacro;
                                            newLexer.reparseMacroName = this.reparseMacroName;
                                            newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                            newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                            newLexer.reparseFileName = this.reparseFileName;
                                            newLexer.reparseFileLine = this.reparseFileLine;
                                        }
                                        newLexer.isPVlogPreprocessing = isPVlogPreprocessingFile;
                                        newLexer.kind = 0;
                                        this.lS.push(newLexer);
                                    }
                                } else {
                                    this.lS.notifyParsingListeners(new VlogSkipInfo(file.getAbsolutePath(), 1, this.getLanguageSyntax()));
                                }
                                break block59;
                            }
                            this.util.restoreIncludedFile(fullFileName, this.getLine(), this.getOffset());
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block60;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mC_ENDIF_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block18: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block17: {
                _token = null;
                _begin = this.text.length();
                _ttype = 633;
                userMark = null;
                finalRunnable = null;
                int line = 0;
                try {
                    try {
                        this.LA(1);
                        this.match("#endif");
                        if (this.inputState.guessing() == 0) {
                            try {
                                line = this.getLine();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (this.inputState.guessing() != 0) break block17;
                        try {
                            if (this.lS.peek().preprocessingType != 1 && this.lS.peek().preprocessingType != 2 && this.lS.peek().preprocessingType != 3) {
                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - 6, 6, "Unexpected #endif (no starting #ifdef/#ifndef found)");
                            } else {
                                int tmp = this.lS.peek().reparseFileLine;
                                this.lS.pop(true);
                                this.lS.peek().reparseFileLine = tmp;
                                this.lS.removeSkipDefine(this);
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), line, this.getColumn());
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 501;
        this.match('.');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mWILD_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 502;
        if (this.LA(3) != '?') {
            throw this.getSemanticException(" LA(3) == '?' ");
        }
        this.match("==?");
        if (this.inputState.guessing() == 0) {
            try {
                this.notAllowed(5);
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mWILD_EQUAL_VCS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 503;
        if (this.LA(3) != '=') {
            throw this.getSemanticException(" LA(3) == '=' ");
        }
        this.match("=?=");
        if (this.inputState.guessing() == 0) {
            try {
                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), this.getLine(), this.getOffset() - 3, 3, VlogUtil.getNonStandardMessage(RfNonStandardProblem.WILDCARD_EQUALITY_OPERATOR, new Object[0]));
                this.notAllowed(5);
                _ttype = 502;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mWILD_NOT_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 504;
        if (this.LA(3) != '?') {
            throw this.getSemanticException(" LA(3) == '?' ");
        }
        this.match("!=?");
        if (this.inputState.guessing() == 0) {
            try {
                this.notAllowed(5);
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mWILD_NOT_EQUAL_VCS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 505;
        if (this.LA(3) != '=') {
            throw this.getSemanticException(" LA(3) == '=' ");
        }
        this.match("!?=");
        if (this.inputState.guessing() == 0) {
            try {
                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), this.getLine(), this.getOffset() - 3, 3, VlogUtil.getNonStandardMessage(RfNonStandardProblem.WILDCARD_INEQUALITY_OPERATOR, new Object[0]));
                this.notAllowed(5);
                _ttype = 504;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDOUBLE_STAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 506;
        this.match("**");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSSR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 507;
        if (this.LA(3) != '>' || this.LA(4) == '=') {
            throw this.getSemanticException(" LA(3) == '>' && LA(4) != '=' ");
        }
        this.match(">>>");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSSL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 508;
        if (this.LA(3) != '<' || this.LA(4) == '=') {
            throw this.getSemanticException(" LA(3) == '<' && LA(4) != '=' ");
        }
        this.match("<<<");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPLUS_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 509;
        if (this.LA(3) == '>') {
            throw this.getSemanticException(" LA(3) != '>' ");
        }
        this.match("+=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMINUS_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 510;
        if (this.LA(3) == '>') {
            throw this.getSemanticException(" LA(3) != '>' ");
        }
        this.match("-=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 511;
        this.match("*=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDIV_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 512;
        this.match("/=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMOD_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 513;
        this.match("%=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mAND_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 514;
        this.match("&=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mOR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 515;
        if (this.LA(3) == '>') {
            throw this.getSemanticException(" LA(3) != '>' ");
        }
        this.match("|=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mXOR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 516;
        this.match("^=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSL_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 517;
        if (this.LA(3) != '=') {
            throw this.getSemanticException(" LA(3) == '=' ");
        }
        this.match("<<=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 518;
        if (this.LA(3) != '=') {
            throw this.getSemanticException(" LA(3) == '=' ");
        }
        this.match(">>=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSLL_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 519;
        if (this.LA(3) != '<' || this.LA(4) != '=') {
            throw this.getSemanticException(" LA(3) == '<' && LA(4) == '=' ");
        }
        this.match("<<<=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSRR_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 520;
        if (this.LA(3) != '>' || this.LA(4) != '=') {
            throw this.getSemanticException(" LA(3) == '>' && LA(4) == '=' ");
        }
        this.match(">>>=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON_COLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 521;
        this.match("::");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPLUS_COLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 522;
        this.match("+:");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDASH_COLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 523;
        this.match("-:");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON_EQ(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 524;
        this.match(":=");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON_DIV(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 525;
        if (this.LA(3) == '/' || this.LA(3) == '*') {
            throw this.getSemanticException(" LA(3) != '/' && LA(3) != '*' ");
        }
        this.match(":/");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPOUND_POUND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 526;
        this.match("##");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mOR_DASH_GT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 527;
        if (this.LA(3) != '>') {
            throw this.getSemanticException(" LA(3) == '>' ");
        }
        this.match("|->");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mOR_EQUAL_GT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 528;
        if (this.LA(3) != '>') {
            throw this.getSemanticException(" LA(3) == '>' ");
        }
        this.match("|=>");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDOT_STAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 529;
        this.match(".*");
        if (this.inputState.guessing() == 0) {
            try {
                int column = this.getColumn();
                int line = this.getLine();
                if (this.indexer != null) {
                    this.indexer.index2(".*", line, column, 542, true, this.lS.isSkip(), false);
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLPAREN_STAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 530;
        this.match("(*");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mIMPLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 531;
        this.match("=>");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR_GT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 532;
        this.match("*>");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDOLLAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 533;
        this.match("$");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDASH_GT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 534;
        if (this.LA(3) == '>') {
            throw this.getSemanticException(" LA(3) != '>' ");
        }
        this.match("->");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mEQUIV(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 535;
        if (this.LA(3) != '>') {
            throw this.getSemanticException(" LA(3) == '>' ");
        }
        this.match("<->");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDASH_GT_GT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 536;
        if (this.LA(3) != '>') {
            throw this.getSemanticException(" LA(3) == '>' ");
        }
        this.match("->>");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mAND_AND_AND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 537;
        if (this.LA(3) != '&') {
            throw this.getSemanticException(" LA(3) == '&' ");
        }
        this.match("&&&");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mTICK(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 538;
        this.match('\'');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR_COLON_COLON_STAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 539;
        if (this.LA(3) != ':' || this.LA(4) != '*') {
            throw this.getSemanticException(" LA(3) == ':' && LA(4) == '*' ");
        }
        this.match("*::*");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPOUND_DASH_POUND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 540;
        if (this.LA(3) != '#') {
            throw this.getSemanticException(" LA(3) == '#' ");
        }
        this.match("#-#");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPOUND_EQ_POUND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 541;
        if (this.LA(3) != '#') {
            throw this.getSemanticException(" LA(3) == '#' ");
        }
        this.match("#=#");
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mID(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 542;
        Token lbs = null;
        Token id = null;
        int column = this.getColumn();
        int line = this.getLine();
        List<LibrarySpecPath> paths = null;
        int la1 = 65535;
        boolean synPredMatched171 = false;
        if (this.LA(1) == 'l' && this.LA(2) == 'i' && this.LA(3) == 'b' && !this.lS.isSkip() && this.LA(4) == 'r' && this.LA(5) == 'a' && this.LA(6) == 'r' && this.LA(7) == 'y') {
            int _m171 = this.mark();
            synPredMatched171 = true;
            this.inputState.incGuessing();
            try {
                this.match("library");
                switch (this.LA(1)) {
                    case ' ': {
                        this.match(' ');
                        break;
                    }
                    case '\t': {
                        this.match('\t');
                        break;
                    }
                    case '\f': {
                        this.match('\f');
                        break;
                    }
                    case '\u00a0': {
                        this.match('\u00a0');
                        break;
                    }
                    case '\r': {
                        this.match('\r');
                        break;
                    }
                    case '\n': {
                        this.match('\n');
                        break;
                    }
                    default: {
                        if (this.LA(1) == '/' && this.LA(2) == '/') {
                            this.match("//");
                            break;
                        }
                        if (this.LA(1) == '/' && this.LA(2) == '*') {
                            this.match("/*");
                            break;
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                synPredMatched171 = false;
            }
            this.rewind(_m171);
            this.inputState.decGuessing(synPredMatched171);
        }
        if (synPredMatched171) {
            paths = this.mLIBRARY_SPEC(true);
            lbs = this._returnToken;
            if (this.inputState.guessing() == 0) {
                try {
                    if (paths != null) {
                        ((DVTCustomToken)lbs).setPaths(paths);
                        this._returnToken = lbs;
                        return;
                    }
                    _ttype = 565;
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else {
            boolean synPredMatched174 = false;
            if (this.LA(1) == 'i' && this.LA(2) == 'n' && this.LA(3) == 'c' && !this.lS.isSkip() && this.LA(4) == 'l' && this.LA(5) == 'u' && this.LA(6) == 'd' && this.LA(7) == 'e') {
                int _m174 = this.mark();
                synPredMatched174 = true;
                this.inputState.incGuessing();
                try {
                    this.match("include");
                    switch (this.LA(1)) {
                        case ' ': {
                            this.match(' ');
                            break;
                        }
                        case '\t': {
                            this.match('\t');
                            break;
                        }
                        case '\f': {
                            this.match('\f');
                            break;
                        }
                        case '\u00a0': {
                            this.match('\u00a0');
                            break;
                        }
                        case '\r': {
                            this.match('\r');
                            break;
                        }
                        case '\n': {
                            this.match('\n');
                            break;
                        }
                        default: {
                            if (this.LA(1) == '/' && this.LA(2) == '/') {
                                this.match("//");
                                break;
                            }
                            if (this.LA(1) == '/' && this.LA(2) == '*') {
                                this.match("/*");
                                break;
                            }
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched174 = false;
                }
                this.rewind(_m174);
                this.inputState.decGuessing(synPredMatched174);
            }
            if (synPredMatched174) {
                this.mINCLUDE_SPEC(false);
                if (this.inputState.guessing() == 0) {
                    try {
                        _ttype = 565;
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
            } else {
                boolean synPredMatched176 = false;
                if (this.LA(1) == 'P' && this.LA(2) == 'A' && this.LA(3) == 'T' && !this.lS.isSkip() && this.LA(4) == 'H' && this.LA(5) == 'P' && this.LA(6) == 'U' && this.LA(7) == 'L') {
                    int _m176 = this.mark();
                    synPredMatched176 = true;
                    this.inputState.incGuessing();
                    try {
                        this.match("PATHPULSE$");
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched176 = false;
                    }
                    this.rewind(_m176);
                    this.inputState.decGuessing(synPredMatched176);
                }
                if (synPredMatched176) {
                    this.match("PATHPULSE$");
                    if (_tokenSet_15.member((int)this.LA(1))) {
                        this.mINTERNAL_ID_1(false);
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            _ttype = 280;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else if (_tokenSet_15.member((int)this.LA(1))) {
                    this.mINTERNAL_ID_1(true);
                    id = this._returnToken;
                    boolean synPredMatched182 = false;
                    if (this.LA(1) == '`' && this.lS.isMacroReparsing()) {
                        int _m182 = this.mark();
                        synPredMatched182 = true;
                        this.inputState.incGuessing();
                        try {
                            this.match('`');
                            while (_tokenSet_13.member((int)this.LA(1))) {
                                this.mDEFINE_WS(false);
                            }
                            char c = this.LA(1);
                            la1 = c;
                            if (c == 'i' && this.LA(2) == 'f' && this.LA(3) == 'd' && this.LA(4) == 'e' && this.LA(5) == 'f' && !Character.isJavaIdentifierPart(this.LA(6)) || la1 == 101 && this.LA(2) == 'l' && this.LA(3) == 's' && this.LA(4) == 'i' && this.LA(5) == 'f' && !Character.isJavaIdentifierPart(this.LA(6)) || la1 == 101 && this.LA(2) == 'l' && this.LA(3) == 's' && this.LA(4) == 'e' && !Character.isJavaIdentifierPart(this.LA(5)) || la1 == 101 && this.LA(2) == 'n' && this.LA(3) == 'd' && this.LA(4) == 'i' && this.LA(5) == 'f' && !Character.isJavaIdentifierPart(this.LA(6)) || la1 == 100 && this.LA(2) == 'e' && this.LA(3) == 'f' && this.LA(4) == 'i' && this.LA(5) == 'n' && this.LA(6) == 'e' && !Character.isJavaIdentifierPart(this.LA(7)) || la1 == 117 && this.LA(2) == 'n' && this.LA(3) == 'd' && this.LA(4) == 'e' && this.LA(5) == 'f' && !Character.isJavaIdentifierPart(this.LA(6))) {
                                throw this.getSemanticException(" !(((la1 = LA(1)) == 'i' && LA(2) == 'f' && LA(3) == 'd' && LA(4) == 'e' && LA(5) == 'f' && !Character.isJavaIdentifierPart(LA(6))) ||\n   \t\t    (la1 == 'e' && LA(2) == 'l' && LA(3) == 's' && LA(4) == 'i' && LA(5) == 'f' && !Character.isJavaIdentifierPart(LA(6))) ||\n\t\t    (la1 == 'e' && LA(2) == 'l' && LA(3) == 's' && LA(4) == 'e' && !Character.isJavaIdentifierPart(LA(5))) ||\n\t\t    (la1 == 'e' && LA(2) == 'n' && LA(3) == 'd' && LA(4) == 'i' && LA(5) == 'f' && !Character.isJavaIdentifierPart(LA(6))) ||\n\t\t    (la1 == 'd' && LA(2) == 'e' && LA(3) == 'f' && LA(4) == 'i' && LA(5) == 'n' && LA(6) == 'e' && !Character.isJavaIdentifierPart(LA(7))) ||\n\t\t    (la1 == 'u' && LA(2) == 'n' && LA(3) == 'd' && LA(4) == 'e' && LA(5) == 'f' && !Character.isJavaIdentifierPart(LA(6)))) ");
                            }
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched182 = false;
                        }
                        this.rewind(_m182);
                        this.inputState.decGuessing(synPredMatched182);
                    }
                    if (synPredMatched182) {
                        if (this.inputState.guessing() == 0) {
                            try {
                                _ttype = 565;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mDEFINE_REPLACE(false, id.getText(), false);
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            if (!this.isMacroReparsing() && this.indexer != null && id != null) {
                                this.indexer.index2(id.getText(), line, column, 542, true, this.lS.isSkip(), false);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final List<LibrarySpecPath> mLIBRARY_SPEC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        ArrayList<LibrarySpecPath> paths;
        block76: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block75: {
                paths = null;
                _token = null;
                _begin = this.text.length();
                _ttype = 544;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                Token str1 = null;
                Token str2 = null;
                String path = null;
                Token str = null;
                int offset = 0;
                try {
                    try {
                        this.match("library");
                        this.mCOMMENT_WS(false);
                        this.mINTERNAL_ID_1(true);
                        id = this._returnToken;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (id.getType() != 550) {
                                    throw new RecognitionException("Unexpected token '" + id.getText() + "'", this.getFilename(), id.getLine(), id.getColumn(), id.getOffset(), id.getLength());
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        boolean synPredMatched188 = false;
                        if (_tokenSet_16.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff' && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                            int _m188 = this.mark();
                            synPredMatched188 = true;
                            this.inputState.incGuessing();
                            try {
                                switch (this.LA(1)) {
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case '\r': 
                                    case ' ': 
                                    case '\u00a0': {
                                        this.mWS(false);
                                        break;
                                    }
                                    case '\"': {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                this.match('\"');
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched188 = false;
                            }
                            this.rewind(_m188);
                            this.inputState.decGuessing(synPredMatched188);
                        }
                        if (synPredMatched188) {
                            switch (this.LA(1)) {
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': 
                                case '\u00a0': {
                                    this.mWS(false);
                                    break;
                                }
                                case '\"': {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    offset = this.getOffset();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.mSTRING(true);
                            str1 = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    str = str1;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else if (_tokenSet_17.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
                            path = this.mPATH(false);
                        } else {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (str != null && str.getText() != null && str.getText().length() >= 2) {
                                    path = str.getText().substring(1, str.getText().length() - 1).trim();
                                }
                                if (paths == null) {
                                    paths = new ArrayList<LibrarySpecPath>();
                                }
                                paths.add(new LibrarySpecPath(path, id.getText(), this.getFilename(), id.getLine(), this.fileIndex, this.getLanguageSyntax()));
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        while (this.LA(1) == ',') {
                            this.mCOMMA(false);
                            boolean synPredMatched194 = false;
                            if (_tokenSet_16.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff' && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                                int _m194 = this.mark();
                                synPredMatched194 = true;
                                this.inputState.incGuessing();
                                try {
                                    switch (this.LA(1)) {
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case '\r': 
                                        case ' ': 
                                        case '\u00a0': {
                                            this.mWS(false);
                                            break;
                                        }
                                        case '\"': {
                                            break;
                                        }
                                        default: {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    this.match('\"');
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched194 = false;
                                }
                                this.rewind(_m194);
                                this.inputState.decGuessing(synPredMatched194);
                            }
                            if (synPredMatched194) {
                                switch (this.LA(1)) {
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case '\r': 
                                    case ' ': 
                                    case '\u00a0': {
                                        this.mWS(false);
                                        break;
                                    }
                                    case '\"': {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        if (str == null) {
                                            offset = this.getOffset();
                                        }
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                this.mSTRING(true);
                                str2 = this._returnToken;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        if (str == null) {
                                            str = str2;
                                        }
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else if (_tokenSet_17.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
                                path = this.mPATH(false);
                            } else {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                if (str != null && str.getText() != null && str.getText().length() >= 2) {
                                    path = str.getText().substring(1, str.getText().length() - 1).trim();
                                }
                                if (paths == null) {
                                    paths = new ArrayList();
                                }
                                paths.add(new LibrarySpecPath(path, id.getText(), this.getFilename(), id.getLine(), this.fileIndex, this.getLanguageSyntax()));
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        switch (this.LA(1)) {
                            case '-': {
                                this.mINCDIR_SPEC(false);
                                break;
                            }
                            case ';': {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        this.mSEMI(false);
                        if (this.inputState.guessing() != 0) break block75;
                        try {
                            if (str != null && str.getText() != null && str.getText().length() >= 2) {
                                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), str.getLine(), offset, str.getText().length(), VlogUtil.getNonStandardMessage(RfNonStandardProblem.LIBRARY_PATH, new Object[0]));
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError(ex);
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block76;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return paths;
    }

    protected final void mINCLUDE_SPEC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block18: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block17: {
                _token = null;
                _begin = this.text.length();
                _ttype = 543;
                userMark = null;
                finalRunnable = null;
                Token p0 = null;
                String path = "";
                try {
                    try {
                        this.match("include");
                        path = this.mPATH(true);
                        p0 = this._returnToken;
                        this.mSEMI(false);
                        if (this.inputState.guessing() != 0) break block17;
                        try {
                            path = this.util.getCrossPlatformPath(path);
                            File file = new File(path);
                            if (!file.exists()) {
                                File callerFile = new File(this.getFilename());
                                String callerParentFile = callerFile.getParent();
                                if (callerParentFile != null) {
                                    path = String.valueOf(callerParentFile) + File.separator + path;
                                }
                                path = this.util.getCrossPlatformPath(path);
                                path = this.util.getFileSubstitute(path);
                                file = new File(path);
                            }
                            if (!file.exists()) {
                                if (this.getFilename() != null && p0 != null) {
                                    this.reportError("*** Error: ", this.getFilename(), p0.getLine(), p0.getOffset(), path.length(), "No such file or directory: " + path);
                                }
                                break block17;
                            }
                            if (this.util.isIgnored(file)) {
                                this.util.reportMessage("Skip file: ", path);
                                this.lS.notifyParsingListeners(new VlogSkipInfo(file.getAbsolutePath(), 0, this.getLanguageSyntax()));
                                break block17;
                            }
                            InputStream inputStream = FileInputStreamUtils.createStream((File)file);
                            inputStream = new MD5InputStream(inputStream, file);
                            VlogLexer newLexer = new VlogLexer(inputStream, (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.util = this.util;
                            newLexer.loading = true;
                            newLexer.followImports = true;
                            newLexer.rfp = this.rfp;
                            newLexer.setFilename(file.getAbsolutePath(), null, true);
                            newLexer.defaultLanguageSyntax = this.getFilename() != null && new File(this.getFilename()).getName().startsWith("__vlog__") || this.util.isUseIncludeExtensionLanguageSyntax() ? this.util.getLanguageSyntaxByExtension(file.getName()) : this.defaultLanguageSyntax;
                            if (this.isMacroReparsing()) {
                                newLexer.setMacroTraceIgnore();
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            this.lS.push(newLexer);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError(ex);
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mINTERNAL_ID_1(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block22: {
            _token = null;
            _begin = this.text.length();
            _ttype = 550;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            String tktxt = null;
            try {
                try {
                    switch (this.LA(1)) {
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.matchRange('a', 'z');
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': {
                            this.matchRange('A', 'Z');
                            break;
                        }
                        case '_': {
                            this.match('_');
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    while (true) {
                        if (this.LA(1) >= 'a' && this.LA(1) <= 'z') {
                            this.matchRange('a', 'z');
                            continue;
                        }
                        if (this.LA(1) >= 'A' && this.LA(1) <= 'Z') {
                            this.matchRange('A', 'Z');
                            continue;
                        }
                        if (this.LA(1) >= '0' && this.LA(1) <= '9') {
                            this.matchRange('0', '9');
                            continue;
                        }
                        if (this.LA(1) == '_') {
                            this.match('_');
                            continue;
                        }
                        if (this.LA(1) != '$') break;
                        this.match('$');
                    }
                    if (this.LA(1) == '!' && PSL_SPECIAL_KEYWORDS.contains(tktxt = this.getText()) && this.LA(2) != '=' && this.LA(2) != '?') {
                        this.match('!');
                        if (this.LA(1) == '_' && (tktxt.charAt(0) == 'b' || tktxt.charAt(0) == 'u')) {
                            this.match('_');
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        _ttype = this.testLiteralsTable(new String(this.text.getBuffer(), _begin, this.text.length() - _begin), _ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    /*
     * Unable to fully structure code
     */
    protected final boolean mDEFINE_REPLACE(boolean _createToken, String prefix, boolean doIndex) throws RecognitionException, CharStreamException, TokenStreamException {
        block54: {
            block52: {
                undefined = false;
                _token = null;
                _begin = this.text.length();
                _ttype = 577;
                userMark = null;
                finalRunnable = null;
                id = null;
                par = null;
                sf = null;
                suffix = "";
                macro = null;
                params = null;
                possibleParams = false;
                old_id = new Token();
                column = 0;
                line = 0;
                offset = this.getOffset();
                compilerDirective = null;
                this.match('`');
                while (VlogLexer._tokenSet_13.member((int)this.LA(1))) {
                    this.mDEFINE_WS(false);
                }
                this.mDEFINE_ID(true, false, doIndex);
                id = this._returnToken;
                if (this.inputState.guessing() != 0) ** GOTO lbl46
                if (!this.lS.isSkip()) break block52;
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                return false;
            }
            try {
                try {
                    block53: {
                        block58: {
                            block57: {
                                block56: {
                                    block55: {
                                        compilerDirective = VlogLexer.COMPILER_DIRECTIVES.get(id.getText());
                                        if (compilerDirective == null) {
                                            this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                                            old_id = id;
                                            token = old_id instanceof DVTCustomToken != false ? (DVTCustomToken)old_id : null;
                                            macro = this.util.getDefine(old_id.getText(), false, token);
                                        }
                                        {
                                            catch (Exception ex) {
                                                this.userExceptionHandler(ex);
                                            }
                                        }
lbl46:
                                        // 3 sources

                                        if (!VlogLexer._tokenSet_18.member((int)this.LA(1)) || !VlogLexer._tokenSet_19.member((int)this.LA(2)) || compilerDirective != CompilerDirectiveKind.ID_ARG) break block55;
                                        this.mDEFINE_WS_NL_OR_COMMENT(false);
                                        this.mINTERNAL_ID_1(false);
                                        break block53;
                                    }
                                    if (!VlogLexer._tokenSet_18.member((int)this.LA(1)) || !VlogLexer._tokenSet_20.member((int)this.LA(2)) || compilerDirective != CompilerDirectiveKind.NUMBER_ARG) break block56;
                                    this.mDEFINE_WS_NL_OR_COMMENT(false);
                                    this.mNUMBER_BASE(false);
                                    break block53;
                                }
                                if (compilerDirective == CompilerDirectiveKind.NO_ARG) break block53;
                                if (macro != null) break block57;
                                synPredMatched525 = false;
                                _m525 = this.mark();
                                synPredMatched525 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
                                    this.mLPAREN(false);
                                }
                                catch (RecognitionException v0) {
                                    synPredMatched525 = false;
                                }
                                this.rewind(_m525);
                                this.inputState.decGuessing(synPredMatched525);
                                if (synPredMatched525 && this.inputState.guessing() == 0) {
                                    try {
                                        possibleParams = true;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                break block53;
                            }
                            if (macro == null || macro.hasParams()) break block58;
                            if (this.inputState.guessing() == 0) {
                                // empty if block
                            }
                            break block53;
                        }
                        if (macro == null || !macro.hasParams()) ** GOTO lbl125
                        if (VlogLexer._tokenSet_21.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff' && this.LA(1) != '\uffff') {
                            this.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
                            if (this.inputState.guessing() == 0) {
                                try {
                                    line = this.getLine();
                                    column = this.getColumn() + 1;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.mDEFINE_REPLACE_PARAMS(true, macro.getName());
                            par = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    params = par.getText();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            if (VlogLexer._tokenSet_15.member((int)this.LA(1)) && this.lS.isMacroReparsing()) {
                                this.mID(true);
                                sf = this._returnToken;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        suffix = sf.getText();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            }
                        } else if (this.LA(1) == '\uffff') {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    if (this.parentLexer != null) {
                                        this.parentLexer.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
                                        this.parentLexer.mDEFINE_REPLACE_PARAMS(true, macro.getName());
                                        params = this.parentLexer._returnToken.getText();
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
lbl125:
                            // 1 sources

                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    if (this.inputState.guessing() != 0) break block54;
                    try {
                        try {
                            if (!this.lS.isSkip() && compilerDirective == null) {
                                this.dependsOn(old_id.getText(), macro == null ? null : macro.getMacroText());
                                if (macro != null) {
                                    unprocessedParameters = VlogUtil.splitParameters(params, this.util.getToolCompat());
                                    parameters = this.util.preprocess(unprocessedParameters, this.getLine(), this.parserPath, this.indexer);
                                    replacement = macro.getReplacement(this.util, parameters, this.getLine(), this.parserPath);
                                    if (!this.lS.isMacroReparsing()) {
                                        this.util.setReference(this.lS.getCurrentFileInstance(), old_id.getLine(), this.lS.getLastLine(), old_id.getOffset(), old_id.getText(), parameters, true);
                                    }
                                    if (this.indexer != null && !this.isMacroReparsing() && params != null) {
                                        this.indexer.index2(params, line, column, -1, false, this.lS.isSkip(), false);
                                    }
                                    if (this.indexer != null && macro != null) {
                                        this.indexer.index2(macro.getName(), line, column, -1, false, this.lS.isSkip(), true);
                                    }
                                    this.util.debug(new Object[]{"Lexing: `", prefix, old_id.getText(), "\nusing parameters: '", params, "'\nresult: '", replacement, "'\nline: ", this.getLine()});
                                    fullReplacement = new StringBuilder(prefix).append(replacement).append(suffix);
                                    charvals = new char[fullReplacement.length()];
                                    fullReplacement.getChars(0, fullReplacement.length(), charvals, 0);
                                    charir = new CharArrayReader(charvals);
                                    newLexer = new VlogLexer(charir, (Map<ANTLRHashString, Integer>)this.literals);
                                    newLexer.lS = this.lS;
                                    newLexer.parentLexer = this;
                                    newLexer.util = this.util;
                                    newLexer.followImports = this.followImports;
                                    newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                                    newLexer.rfp = this.rfp;
                                    newLexer.parserPath = this.parserPath;
                                    newLexer.fileIndex = this.fileIndex;
                                    newLexer.setFilename(this.getFilename(), this.indexer, false);
                                    newLexer.setLockLine(old_id.getLine(), old_id.getOffset(), old_id.getColumn());
                                    newLexer.setColumn(old_id.getColumn() + old_id.getLength());
                                    newLexer.reparseMacroName = "`" + old_id.getText();
                                    newLexer.reparseMacro = macro;
                                    newLexer.reparseMacroParameters = parameters;
                                    newLexer.reparseMacroUnprocessedParameters = unprocessedParameters;
                                    macroInfo = macro;
                                    newLexer.reparseFileName = macroInfo.getFileInstance().getParserPath();
                                    newLexer.reparseFileLine = macroInfo.getLine();
                                    newLexer.virtualOffset = this.virtualOffset == null ? new VirtualOffset() : this.virtualOffset;
                                    newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                                    newLexer.kind = 1;
                                    this.lS.push(newLexer);
                                    macro_name = old_id.getText();
                                    if (this.rfp.isStrictNonStandardChecks() && VlogLexer.WREAL_MACROS.contains(macro_name)) {
                                        message = MessageFormat.format(RfSemanticError.NON_STANDARD_MACRO, new Object[]{macro_name});
                                        this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), old_id.getLine(), offset, old_id.getLength() + 1, message);
                                    }
                                } else if (!this.util.isCompilerDirective(old_id.getText())) {
                                    message = null;
                                    message = old_id.getText().startsWith("VMM_HW_") != false ? old_id.getText().substring(7).replace('_', ' ') : "Undefined macro name: `" + old_id.getText();
                                    this.reportError("*** Error: ", this.getFilename(), old_id.getLine(), offset, old_id.getLength() + 1, message);
                                    if (possibleParams) {
                                        this.mUNDEFINED_MACRO_POSSIBLE_PARAMS(false, old_id.getText());
                                    }
                                    undefined = true;
                                }
                            }
                            if (this.LA(1) != ';' || macro == null) break block54;
                            this.notAllowed(112, macro.getName(), this.lS.createPrevReparseInfo());
                        }
                        catch (VlogException e) {
                            this.reportError(e.getSeverity(), this.getFilename(), old_id.getLine(), old_id.getOffset(), old_id.getLength(), e.getMessage(), this.lS.getReparseStackLT());
                        }
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable == null) ** GOTO lbl209
                    finalRunnable.run();
                }
            }
            catch (Throwable var32_45) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw var32_45;
            }
        }
        this.userRelease(userMark);
        if (finalRunnable != null) {
            finalRunnable.run();
        }
lbl209:
        // 5 sources

        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return undefined;
    }

    /*
     * Exception decompiling
     */
    protected final String mPATH(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final void mCOMMENT_WS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 547;
        int _cnt216 = 0;
        while (true) {
            if (!_tokenSet_18.member((int)this.LA(1))) {
                if (_cnt216 >= 1) break;
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.mCOMMENT_WSI(false);
            ++_cnt216;
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTRING(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block30: {
            _token = null;
            _begin = this.text.length();
            _ttype = 557;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            boolean report = true;
            try {
                try {
                    this.match('\"');
                    while (true) {
                        boolean synPredMatched276 = false;
                        if (this.LA(1) == '\\' && _tokenSet_22.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m276 = this.mark();
                            synPredMatched276 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('\\');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                switch (this.LA(1)) {
                                    case '\r': {
                                        this.match('\r');
                                        break;
                                    }
                                    case '\n': {
                                        this.match('\n');
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched276 = false;
                            }
                            this.rewind(_m276);
                            this.inputState.decGuessing(synPredMatched276);
                        }
                        if (synPredMatched276) {
                            this.mSTRING_NEWLINE(false);
                            continue;
                        }
                        boolean synPredMatched278 = false;
                        if (this.LA(1) == '\\' && this.LA(2) == '\\' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m278 = this.mark();
                            synPredMatched278 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("\\\\");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched278 = false;
                            }
                            this.rewind(_m278);
                            this.inputState.decGuessing(synPredMatched278);
                        }
                        if (synPredMatched278) {
                            this.match("\\\\");
                            continue;
                        }
                        boolean synPredMatched280 = false;
                        if (this.LA(1) == '\\' && this.LA(2) == '\"' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m280 = this.mark();
                            synPredMatched280 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("\\\"");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched280 = false;
                            }
                            this.rewind(_m280);
                            this.inputState.decGuessing(synPredMatched280);
                        }
                        if (synPredMatched280) {
                            this.match("\\\"");
                            continue;
                        }
                        if (_tokenSet_23.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
                            this.match(_tokenSet_23);
                            continue;
                        }
                        if (this.LA(1) != '\n' && this.LA(1) != '\r') break;
                        report = this.mNEWLINE(false, report);
                    }
                    this.match('\"');
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mINCDIR_SPEC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 545;
        Token str1 = null;
        Token str2 = null;
        Token str = null;
        int offset = 0;
        this.match('-');
        this.mCOMMENT_WS(false);
        this.match("incdir");
        boolean synPredMatched202 = false;
        if (_tokenSet_16.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff' && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
            int _m202 = this.mark();
            synPredMatched202 = true;
            this.inputState.incGuessing();
            try {
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case '\"': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.match('\"');
            }
            catch (RecognitionException recognitionException) {
                synPredMatched202 = false;
            }
            this.rewind(_m202);
            this.inputState.decGuessing(synPredMatched202);
        }
        if (synPredMatched202) {
            switch (this.LA(1)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u00a0': {
                    this.mWS(false);
                    break;
                }
                case '\"': {
                    break;
                }
                default: {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            if (this.inputState.guessing() == 0) {
                try {
                    offset = this.getOffset();
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
            this.mSTRING(true);
            str1 = this._returnToken;
            if (this.inputState.guessing() == 0) {
                try {
                    str = str1;
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else if (_tokenSet_17.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
            this.mPATH(false);
        } else {
            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        while (this.LA(1) == ',') {
            this.mCOMMA(false);
            boolean synPredMatched208 = false;
            if (_tokenSet_16.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff' && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                int _m208 = this.mark();
                synPredMatched208 = true;
                this.inputState.incGuessing();
                try {
                    switch (this.LA(1)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '\u00a0': {
                            this.mWS(false);
                            break;
                        }
                        case '\"': {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    this.match('\"');
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched208 = false;
                }
                this.rewind(_m208);
                this.inputState.decGuessing(synPredMatched208);
            }
            if (synPredMatched208) {
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case '\"': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                if (this.inputState.guessing() == 0) {
                    try {
                        if (str == null) {
                            offset = this.getOffset();
                        }
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
                this.mSTRING(true);
                str2 = this._returnToken;
                if (this.inputState.guessing() != 0) continue;
                try {
                    if (str != null) continue;
                    str = str2;
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
                continue;
            }
            if (_tokenSet_17.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                this.mPATH(false);
                continue;
            }
            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        this.mSEMI(false);
        if (this.inputState.guessing() == 0) {
            try {
                if (str != null) {
                    this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), str.getLine(), offset, str.getText().length(), VlogUtil.getNonStandardMessage(RfNonStandardProblem.LIBRARY_PATH, new Object[0]));
                }
                _ttype = -1;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mCOMMENT_WSI(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 546;
        switch (this.LA(1)) {
            case '/': {
                if (this.LA(1) == '/' && this.LA(2) == '*') {
                    this.mML_COMMENT(false);
                    break;
                }
                if (this.LA(1) == '/' && this.LA(2) == '/') {
                    this.mSL_COMMENT(false);
                    break;
                }
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            case ' ': {
                this.match(' ');
                break;
            }
            case '\t': {
                this.match('\t');
                break;
            }
            case '\f': {
                this.match('\f');
                break;
            }
            case '\u00a0': {
                this.match('\u00a0');
                break;
            }
            case '\n': 
            case '\r': {
                if (this.LA(1) == '\r' && this.LA(2) == '\n' && _tokenSet_24.member((int)this.LA(3)) && this.LA(1) == '\r' && this.LA(2) == '\n') {
                    this.match("\r\n");
                } else if (this.LA(1) == '\r' && _tokenSet_24.member((int)this.LA(2)) && _tokenSet_17.member((int)this.LA(3))) {
                    this.match('\r');
                } else if (this.LA(1) == '\n') {
                    this.match('\n');
                } else {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                if (this.inputState.guessing() != 0) break;
                try {
                    this.newline();
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mINTERNAL_ID_2(boolean _createToken, boolean reportWarning) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block24: {
            _token = null;
            _begin = this.text.length();
            _ttype = 549;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    switch (this.LA(1)) {
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.matchRange('a', 'z');
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': {
                            this.matchRange('A', 'Z');
                            break;
                        }
                        case '_': {
                            this.match('_');
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.matchRange('0', '9');
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (this.lS.isSkip() || !reportWarning) break;
                                this.reportError("*** Warning: ", this.getFilename(), this.getLine(), -1, -1, "Macro name should start with a letter");
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    while (true) {
                        if (this.LA(1) >= 'a' && this.LA(1) <= 'z') {
                            this.matchRange('a', 'z');
                            continue;
                        }
                        if (this.LA(1) >= 'A' && this.LA(1) <= 'Z') {
                            this.matchRange('A', 'Z');
                            continue;
                        }
                        if (this.LA(1) >= '0' && this.LA(1) <= '9') {
                            this.matchRange('0', '9');
                            continue;
                        }
                        if (this.LA(1) == '_') {
                            this.match('_');
                            continue;
                        }
                        if (this.LA(1) == '$') {
                            this.match('$');
                            continue;
                        }
                        break;
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        _ttype = this.testLiteralsTable(new String(this.text.getBuffer(), _begin, this.text.length() - _begin), _ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSYSTEM_ID(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 551;
        Token id = null;
        int column = this.getColumn();
        int line = this.getLine();
        this.mINTERNAL_SYSTEM_ID(true);
        id = this._returnToken;
        if (this.inputState.guessing() == 0) {
            try {
                if (!this.isMacroReparsing() && this.indexer != null && id != null) {
                    this.indexer.index2(id.getText(), line, column, id.getType(), true, this.lS.isSkip(), false);
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        _ttype = this.testLiteralsTable(_ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mINTERNAL_SYSTEM_ID(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block24: {
            _token = null;
            _begin = this.text.length();
            _ttype = 552;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    this.match('$');
                    switch (this.LA(1)) {
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.matchRange('a', 'z');
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': {
                            this.matchRange('A', 'Z');
                            break;
                        }
                        case '_': {
                            this.match('_');
                            break;
                        }
                        case '$': {
                            this.match('$');
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    block17: while (true) {
                        switch (this.LA(1)) {
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'g': 
                            case 'h': 
                            case 'i': 
                            case 'j': 
                            case 'k': 
                            case 'l': 
                            case 'm': 
                            case 'n': 
                            case 'o': 
                            case 'p': 
                            case 'q': 
                            case 'r': 
                            case 's': 
                            case 't': 
                            case 'u': 
                            case 'v': 
                            case 'w': 
                            case 'x': 
                            case 'y': 
                            case 'z': {
                                this.matchRange('a', 'z');
                                continue block17;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'G': 
                            case 'H': 
                            case 'I': 
                            case 'J': 
                            case 'K': 
                            case 'L': 
                            case 'M': 
                            case 'N': 
                            case 'O': 
                            case 'P': 
                            case 'Q': 
                            case 'R': 
                            case 'S': 
                            case 'T': 
                            case 'U': 
                            case 'V': 
                            case 'W': 
                            case 'X': 
                            case 'Y': 
                            case 'Z': {
                                this.matchRange('A', 'Z');
                                continue block17;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.matchRange('0', '9');
                                continue block17;
                            }
                            case '_': {
                                this.match('_');
                                continue block17;
                            }
                            case '$': {
                                this.match('$');
                                continue block17;
                            }
                        }
                        break;
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        _ttype = this.testLiteralsTable(new String(this.text.getBuffer(), _begin, this.text.length() - _begin), _ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mESCAPED_ID(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block51: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block50: {
                _token = null;
                _begin = this.text.length();
                _ttype = 553;
                userMark = null;
                finalRunnable = null;
                int column = this.getColumn();
                int line = this.getLine();
                try {
                    try {
                        boolean synPredMatched244 = false;
                        if (this.LA(1) == '\\' && this.LA(2) == 'S' && this.LA(3) == 'V' && this.util.isSvxMode()) {
                            int _m244 = this.mark();
                            synPredMatched244 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("\\SV");
                                block8 : switch (this.LA(1)) {
                                    case 'X': {
                                        this.match('X');
                                        switch (this.LA(1)) {
                                            case '_': {
                                                this.match("_version");
                                                break block8;
                                            }
                                            case '\t': 
                                            case '\n': 
                                            case '\f': 
                                            case '\r': 
                                            case ' ': 
                                            case '\u00a0': {
                                                break block8;
                                            }
                                        }
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case '\r': 
                                    case ' ': 
                                    case '\u00a0': {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                this.mWS(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched244 = false;
                            }
                            this.rewind(_m244);
                            this.inputState.decGuessing(synPredMatched244);
                        }
                        if (synPredMatched244) {
                            this.mSVX_COMMENT(false);
                            if (this.inputState.guessing() == 0) {
                                try {
                                    _ttype = -1;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block50;
                        }
                        if (this.LA(1) == '\\' && _tokenSet_25.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                            this.match('\\');
                            int _cnt247 = 0;
                            while (true) {
                                if (!_tokenSet_25.member((int)this.LA(1))) {
                                    if (_cnt247 >= 1) break;
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                                this.match(_tokenSet_25);
                                ++_cnt247;
                            }
                            switch (this.LA(1)) {
                                case ' ': {
                                    this.match(' ');
                                    break;
                                }
                                case '\t': {
                                    this.match('\t');
                                    break;
                                }
                                case '\f': {
                                    this.match('\f');
                                    break;
                                }
                                case '\n': {
                                    this.match('\n');
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        this.newline();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case '\uffff': {
                                    this.match('\uffff');
                                    break;
                                }
                                default: {
                                    if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                                        this.match("\r\n");
                                        if (this.inputState.guessing() != 0) break;
                                        try {
                                            this.newline();
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                        break;
                                    }
                                    if (this.LA(1) == '\r') {
                                        this.match('\r');
                                        if (this.inputState.guessing() != 0) break;
                                        try {
                                            this.newline();
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                        break;
                                    }
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            if (this.inputState.guessing() != 0) break block50;
                            try {
                                String tmp = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                                int type = 553;
                                String rfName = tmp.length() > 0 ? tmp.substring(1, tmp.length() - 1) : "";
                                tmp = this.appendWS(tmp.trim());
                                this.text.setLength(_begin);
                                this.text.append(tmp);
                                if (!this.isMacroReparsing() && this.indexer != null) {
                                    this.indexer.index2(rfName, line, column, type, true, this.lS.isSkip(), false);
                                }
                                break block50;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block50;
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            if (this.LA(1) == '\r' && this.LA(2) == '\n') {
                                this.newline();
                                this.consume();
                                this.consume();
                            } else if (this.LA(1) == '\r' || this.LA(1) == '\n') {
                                this.newline();
                                this.consume();
                            } else {
                                this.consume();
                            }
                        } else {
                            throw ex;
                        }
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block51;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mWS_OR_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block24: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block23: {
                _token = null;
                _begin = this.text.length();
                _ttype = 554;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        switch (this.LA(1)) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': 
                            case '\u00a0': {
                                this.mWS(false);
                                switch (this.LA(1)) {
                                    case '/': {
                                        if (this.LA(1) == '/' && this.LA(2) == '*') {
                                            this.mML_COMMENT(false);
                                        } else if (this.LA(1) == '/' && this.LA(2) == '/') {
                                            this.mSL_COMMENT(false);
                                        } else {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                        this.mWS_OR_COMMENT(false);
                                        break block23;
                                    }
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': 
                                    case '?': 
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': 
                                    case 'X': 
                                    case 'Z': 
                                    case '_': 
                                    case '`': 
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': 
                                    case 'x': 
                                    case 'z': {
                                        break block23;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case '?': 
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'X': 
                            case 'Z': 
                            case '_': 
                            case '`': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'x': 
                            case 'z': {
                                break;
                            }
                            default: {
                                if (this.LA(1) == '/' && this.LA(2) == '*') {
                                    this.mML_COMMENT(false);
                                    this.mWS_OR_COMMENT(false);
                                    break;
                                }
                                if (this.LA(1) == '/' && this.LA(2) == '/') {
                                    this.mSL_COMMENT(false);
                                    this.mWS_OR_COMMENT(false);
                                    break;
                                }
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mNUMBER_FORMAT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block76: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block75: {
                _token = null;
                _begin = this.text.length();
                _ttype = 555;
                userMark = null;
                finalRunnable = null;
                Token nfb = null;
                char type = '?';
                char charZ = ' ';
                char charX = ' ';
                char charN = ' ';
                boolean report = true;
                boolean isFirstDecimalDigit = true;
                try {
                    try {
                        if (this.lS.isSkip()) {
                            throw this.getSemanticException(" !lS.isSkip() ");
                        }
                        this.match('\'');
                        switch (this.LA(1)) {
                            case 'S': 
                            case 's': {
                                switch (this.LA(1)) {
                                    case 's': {
                                        this.match('s');
                                        break;
                                    }
                                    case 'S': {
                                        this.match('S');
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    type = 's';
                                    this.notAllowed(2);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case 'B': 
                            case 'D': 
                            case 'H': 
                            case 'O': 
                            case 'b': 
                            case 'd': 
                            case 'h': 
                            case 'o': {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        switch (this.LA(1)) {
                            case 'D': 
                            case 'd': {
                                switch (this.LA(1)) {
                                    case 'd': {
                                        this.match('d');
                                        break;
                                    }
                                    case 'D': {
                                        this.match('D');
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    type = 'd';
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case 'B': 
                            case 'b': {
                                switch (this.LA(1)) {
                                    case 'b': {
                                        this.match('b');
                                        break;
                                    }
                                    case 'B': {
                                        this.match('B');
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    type = 'b';
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case 'H': 
                            case 'h': {
                                switch (this.LA(1)) {
                                    case 'h': {
                                        this.match('h');
                                        break;
                                    }
                                    case 'H': {
                                        this.match('H');
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    type = 'h';
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case 'O': 
                            case 'o': {
                                switch (this.LA(1)) {
                                    case 'o': {
                                        this.match('o');
                                        break;
                                    }
                                    case 'O': {
                                        this.match('O');
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    type = 'o';
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (_tokenSet_26.member((int)this.LA(1))) {
                            this.mWS_OR_COMMENT(false);
                            if (_tokenSet_27.member((int)this.LA(1))) {
                                int _cnt263 = 0;
                                while (true) {
                                    if (!_tokenSet_27.member((int)this.LA(1)) || type == 'd' && this.LA(1) == '?' && !isFirstDecimalDigit) {
                                        if (_cnt263 < 1) {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                        break block75;
                                    }
                                    this.mNUMBER_FORMAT_DIGIT(true, type);
                                    nfb = this._returnToken;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            if (type == 'd') {
                                                char c = nfb.getText().charAt(0);
                                                isFirstDecimalDigit = false;
                                                if (c == 'x' || c == 'X') {
                                                    char c2 = charN != ' ' ? charN : (tc = charZ != ' ' ? charZ : charX);
                                                    if (tc != ' ' && report) {
                                                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Near '" + tc + "': X is not allowed in decimal constants");
                                                        report = false;
                                                    }
                                                    charX = c;
                                                } else if (c == 'z' || c == 'Z' || c == '?') {
                                                    char c3 = charN != ' ' ? charN : (tc = charZ != ' ' ? charZ : charX);
                                                    if (tc != ' ' && report) {
                                                        c = c == 'z' ? (char)'Z' : (char)c;
                                                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Near '" + tc + "': " + c + " is not allowed in decimal constants");
                                                        report = false;
                                                    }
                                                    charZ = c;
                                                } else if (c >= '\u0000' && c <= '9') {
                                                    char c4 = tc = charZ != ' ' ? charZ : charX;
                                                    if (tc != ' ' && report) {
                                                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "Near '" + tc + "': " + c + " is not allowed in decimal constants");
                                                        report = false;
                                                    }
                                                    charN = c;
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                    ++_cnt263;
                                }
                            }
                            if (this.LA(1) == '`' && !this.lS.isSkip()) {
                                this.mDEFINE_REPLACE(false, "'" + type, false);
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        _ttype = 565;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                break block75;
                            }
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        if (this.LA(1) == '\uffff') {
                            if (this.inputState.guessing() != 0) break block75;
                            try {
                                if (this.parentLexer != null) {
                                    this.parentLexer.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
                                    this.parentLexer.mDEFINE_REPLACE(false, new String(this.text.getBuffer(), _begin, this.text.length() - _begin), false);
                                    _ttype = 565;
                                }
                                break block75;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block75;
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block76;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNUMBER_FORMAT_DIGIT(boolean _createToken, char type) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block31: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block30: {
                _token = null;
                _begin = this.text.length();
                _ttype = 564;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        switch (this.LA(1)) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.matchRange('0', '9');
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                this.matchRange('A', 'F');
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                this.matchRange('a', 'f');
                                break;
                            }
                            case '?': {
                                this.match('?');
                                break;
                            }
                            case '_': {
                                this.match('_');
                                break;
                            }
                            case 'z': {
                                this.match('z');
                                break;
                            }
                            case 'Z': {
                                this.match('Z');
                                break;
                            }
                            case 'x': {
                                this.match('x');
                                break;
                            }
                            case 'X': {
                                this.match('X');
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (this.inputState.guessing() != 0) break block30;
                        try {
                            try {
                                String tmp = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                                char c = tmp != null && tmp.length() == 1 ? tmp.charAt(0) : (char)'\u0000';
                                String numberType = null;
                                switch (type) {
                                    case 'd': {
                                        if (c >= '0' && c <= '9' || c == 'z' || c == 'Z' || c == 'x' || c == 'X' || c == '?' || c == '_') break;
                                        numberType = "decimal";
                                        break;
                                    }
                                    case 'b': {
                                        if (c >= '0' && c <= '1' || c == 'z' || c == 'Z' || c == 'x' || c == 'X' || c == '?' || c == '_') break;
                                        numberType = "binary";
                                        break;
                                    }
                                    case 'o': {
                                        if (c >= '0' && c <= '7' || c == 'z' || c == 'Z' || c == 'x' || c == 'X' || c == '?' || c == '_') break;
                                        numberType = "octal";
                                        break;
                                    }
                                    default: {
                                        if (c >= '0' && c <= '9' || c == 'z' || c == 'Z' || c == 'x' || c == 'X' || c == '?' || c == '_' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') break;
                                        numberType = "hexadecimal";
                                    }
                                }
                                if (numberType != null) {
                                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), -1, -1, "'" + c + "' is not allowed in " + numberType + " number");
                                }
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCONSTANT_PRIM(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block18: {
            _token = null;
            _begin = this.text.length();
            _ttype = 281;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    this.match('\'');
                    switch (this.LA(1)) {
                        case '0': {
                            this.match('0');
                            break;
                        }
                        case '1': {
                            this.match('1');
                            break;
                        }
                        case 'z': {
                            this.match('z');
                            break;
                        }
                        case 'Z': {
                            this.match('Z');
                            break;
                        }
                        case 'x': {
                            this.match('x');
                            break;
                        }
                        case 'X': {
                            this.match('X');
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mFILE_NAME(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 556;
        int _cnt269 = 0;
        while (true) {
            if (!_tokenSet_28.member((int)this.LA(1))) {
                if (_cnt269 >= 1) break;
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.match(_tokenSet_28);
            ++_cnt269;
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSTRING_NEWLINE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 559;
        boolean report = false;
        int _saveIndex = this.text.length();
        this.match('\\');
        this.text.setLength(_saveIndex);
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
            if (this.inputState.guessing() != 0) continue;
            try {
                report = true;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (this.inputState.guessing() == 0) {
            try {
                if (report) {
                    this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), this.getLine(), -1, -1, VlogUtil.getNonStandardMessage(RfNonStandardProblem.STRING_CONTINUATION_WS, new Object[0]));
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        _saveIndex = this.text.length();
        this.mNEWLINE(false, false);
        this.text.setLength(_saveIndex);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final boolean mNEWLINE(boolean _createToken, boolean report) throws RecognitionException, CharStreamException, TokenStreamException {
        boolean doReport = true;
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 558;
        if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(1) == '\r' && this.LA(2) == '\n') {
            this.match("\r\n");
        } else if (this.LA(1) == '\r') {
            this.match('\r');
        } else if (this.LA(1) == '\n') {
            this.match('\n');
        } else {
            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        if (this.inputState.guessing() == 0) {
            try {
                this.newline();
                this.text.setLength(_begin);
                this.text.append(" ");
                doReport = false;
                if (report) {
                    this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), this.getLine(), -1, -1, VlogUtil.getNonStandardMessage(RfNonStandardProblem.STRING_CONTINUATION, new Object[0]));
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return doReport;
    }

    public final void mNUMBER_BASE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block80: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block79: {
                _token = null;
                _begin = this.text.length();
                _ttype = 560;
                userMark = null;
                finalRunnable = null;
                boolean base = true;
                boolean timeref = false;
                boolean verilogAMS = this.getLanguageSyntax() == IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23 || this.getLanguageSyntax() == IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_AMS;
                boolean nonStandardRealTimeRef = false;
                boolean preprocTimeRef = false;
                int offset = this.getOffset();
                int line = this.getLine();
                int la1 = 65535;
                try {
                    try {
                        if (this.lS.isSkip()) {
                            throw this.getSemanticException(" !lS.isSkip() ");
                        }
                        this.matchRange('0', '9');
                        block43: while (true) {
                            switch (this.LA(1)) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    this.matchRange('0', '9');
                                    continue block43;
                                }
                                case '_': {
                                    this.match('_');
                                    continue block43;
                                }
                            }
                            break;
                        }
                        if (this.LA(1) == '.') {
                            this.match('.');
                            block44: while (true) {
                                switch (this.LA(1)) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        this.matchRange('0', '9');
                                        continue block44;
                                    }
                                    case '_': {
                                        this.match('_');
                                        continue block44;
                                    }
                                }
                                break;
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    base = false;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        }
                        boolean synPredMatched299 = false;
                        if (_tokenSet_29.member((int)this.LA(1))) {
                            int _m299 = this.mark();
                            synPredMatched299 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mTIME_UNIT_REF(false);
                                this.match(_tokenSet_30);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched299 = false;
                            }
                            this.rewind(_m299);
                            this.inputState.decGuessing(synPredMatched299);
                        }
                        if (synPredMatched299) {
                            this.mTIME_UNIT_REF(false);
                            if (this.inputState.guessing() == 0) {
                                try {
                                    timeref = true;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        }
                        if (!(this.LA(1) != 'E' && this.LA(1) != 'e' || timeref)) {
                            switch (this.LA(1)) {
                                case 'e': {
                                    this.match('e');
                                    break;
                                }
                                case 'E': {
                                    this.match('E');
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            switch (this.LA(1)) {
                                case '+': {
                                    this.match('+');
                                    break;
                                }
                                case '-': {
                                    this.match('-');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            int _cnt304 = 0;
                            while (true) {
                                if (this.LA(1) < '0' || this.LA(1) > '9') {
                                    if (_cnt304 >= 1) break;
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                                this.matchRange('0', '9');
                                ++_cnt304;
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    base = false;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            boolean synPredMatched308 = false;
                            if (_tokenSet_29.member((int)this.LA(1))) {
                                int _m308 = this.mark();
                                synPredMatched308 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.mTIME_UNIT_REF(false);
                                    this.match(_tokenSet_30);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched308 = false;
                                }
                                this.rewind(_m308);
                                this.inputState.decGuessing(synPredMatched308);
                            }
                            if (synPredMatched308) {
                                this.mTIME_UNIT_REF(false);
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        timeref = true;
                                        nonStandardRealTimeRef = true;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            }
                        } else {
                            boolean synPredMatched311 = false;
                            if (_tokenSet_31.member((int)this.LA(1)) && verilogAMS) {
                                int _m311 = this.mark();
                                synPredMatched311 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.mAMS_UNIT_REF(false);
                                    this.match(_tokenSet_30);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched311 = false;
                                }
                                this.rewind(_m311);
                                this.inputState.decGuessing(synPredMatched311);
                            }
                            if (synPredMatched311) {
                                this.mAMS_UNIT_REF(false);
                            }
                        }
                        boolean synPredMatched316 = false;
                        if (this.LA(1) == '`' && !timeref && this.lS.isMacroReparsing()) {
                            int _m316 = this.mark();
                            synPredMatched316 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                char c = this.LA(1);
                                la1 = c;
                                if (c == 'i' && this.LA(2) == 'f' && this.LA(3) == 'd' && this.LA(4) == 'e' && this.LA(5) == 'f' && !Character.isJavaIdentifierPart(this.LA(6)) || la1 == 101 && this.LA(2) == 'l' && this.LA(3) == 's' && this.LA(4) == 'i' && this.LA(5) == 'f' && !Character.isJavaIdentifierPart(this.LA(6)) || la1 == 101 && this.LA(2) == 'l' && this.LA(3) == 's' && this.LA(4) == 'e' && !Character.isJavaIdentifierPart(this.LA(5)) || la1 == 101 && this.LA(2) == 'n' && this.LA(3) == 'd' && this.LA(4) == 'i' && this.LA(5) == 'f' && !Character.isJavaIdentifierPart(this.LA(6)) || la1 == 100 && this.LA(2) == 'e' && this.LA(3) == 'f' && this.LA(4) == 'i' && this.LA(5) == 'n' && this.LA(6) == 'e' && !Character.isJavaIdentifierPart(this.LA(7)) || la1 == 117 && this.LA(2) == 'n' && this.LA(3) == 'd' && this.LA(4) == 'e' && this.LA(5) == 'f' && !Character.isJavaIdentifierPart(this.LA(6))) {
                                    throw this.getSemanticException(" !(((la1 = LA(1)) == 'i' && LA(2) == 'f' && LA(3) == 'd' && LA(4) == 'e' && LA(5) == 'f' && !Character.isJavaIdentifierPart(LA(6))) ||\n    \t    \t   \t\t    (la1 == 'e' && LA(2) == 'l' && LA(3) == 's' && LA(4) == 'i' && LA(5) == 'f' && !Character.isJavaIdentifierPart(LA(6))) ||\n    \t    \t\t\t    (la1 == 'e' && LA(2) == 'l' && LA(3) == 's' && LA(4) == 'e' && !Character.isJavaIdentifierPart(LA(5))) ||\n    \t    \t\t\t    (la1 == 'e' && LA(2) == 'n' && LA(3) == 'd' && LA(4) == 'i' && LA(5) == 'f' && !Character.isJavaIdentifierPart(LA(6))) ||\n    \t    \t\t\t    (la1 == 'd' && LA(2) == 'e' && LA(3) == 'f' && LA(4) == 'i' && LA(5) == 'n' && LA(6) == 'e' && !Character.isJavaIdentifierPart(LA(7))) ||\n    \t    \t\t\t    (la1 == 'u' && LA(2) == 'n' && LA(3) == 'd' && LA(4) == 'e' && LA(5) == 'f' && !Character.isJavaIdentifierPart(LA(6)))) ");
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched316 = false;
                            }
                            this.rewind(_m316);
                            this.inputState.decGuessing(synPredMatched316);
                        }
                        if (synPredMatched316) {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    preprocTimeRef = true;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.mDEFINE_REPLACE(false, new String(this.text.getBuffer(), _begin, this.text.length() - _begin), false);
                        }
                        if (this.inputState.guessing() != 0) break block79;
                        try {
                            if (preprocTimeRef) {
                                _ttype = 565;
                            } else if (timeref) {
                                _ttype = 283;
                            } else if (!base) {
                                _ttype = 282;
                            }
                            int i = 0;
                            while (this.LA(1 + i) != '\uffff' && Character.isWhitespace(this.LA(1 + i))) {
                                ++i;
                            }
                            String tmp = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                            int length = tmp != null ? tmp.length() : 1;
                            try {
                                if (!(i <= 0 || this.LA(1 + i) == '\uffff' || (this.LA(1 + i) != 's' || this.LA(2 + i) != '\uffff' && Character.isJavaIdentifierPart(this.LA(2 + i))) && (this.LA(1 + i) != 'm' || this.LA(2 + i) != 's' || this.LA(3 + i) != '\uffff' && Character.isJavaIdentifierPart(this.LA(3 + i))) && (this.LA(1 + i) != 'u' || this.LA(2 + i) != 's' || this.LA(3 + i) != '\uffff' && Character.isJavaIdentifierPart(this.LA(3 + i))) && (this.LA(1 + i) != 'n' || this.LA(2 + i) != 's' || this.LA(3 + i) != '\uffff' && Character.isJavaIdentifierPart(this.LA(3 + i))) && (this.LA(1 + i) != 'p' || this.LA(2 + i) != 's' || this.LA(3 + i) != '\uffff' && Character.isJavaIdentifierPart(this.LA(3 + i))) && (this.LA(1 + i) != 'f' || this.LA(2 + i) != 's' || this.LA(3 + i) != '\uffff' && Character.isJavaIdentifierPart(this.LA(3 + i))))) {
                                    this.notAllowed(10);
                                }
                            }
                            catch (Exception exception) {}
                            if (nonStandardRealTimeRef) {
                                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), line, offset, length, VlogUtil.getNonStandardMessage(RfNonStandardProblem.EXPONENT_FORMAT_TIME_VALUE, new Object[0]));
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block80;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mTIME_UNIT_REF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 562;
        switch (this.LA(1)) {
            case 'm': {
                this.match("ms");
                break;
            }
            case 'u': {
                this.match("us");
                break;
            }
            case 'n': {
                this.match("ns");
                break;
            }
            case 'p': {
                this.match("ps");
                break;
            }
            case 'f': {
                this.match("fs");
                break;
            }
            default: {
                if (this.LA(1) == 's' && this.LA(2) == 't') {
                    this.match("step");
                    break;
                }
                if (this.LA(1) == 's') {
                    this.match("s");
                    break;
                }
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mAMS_UNIT_REF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 561;
        switch (this.LA(1)) {
            case 'T': {
                this.match('T');
                break;
            }
            case 'G': {
                this.match('G');
                break;
            }
            case 'M': {
                this.match('M');
                break;
            }
            case 'K': {
                this.match('K');
                break;
            }
            case 'k': {
                this.match('k');
                break;
            }
            case 'm': {
                this.match('m');
                break;
            }
            case 'u': {
                this.match('u');
                break;
            }
            case 'n': {
                this.match('n');
                break;
            }
            case 'p': {
                this.match('p');
                break;
            }
            case 'f': {
                this.match('f');
                break;
            }
            case 'a': {
                this.match('a');
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDECIMAL_DIGIT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 563;
        this.matchRange('0', '9');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPREPROCESSOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block243: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block240: {
                _token = null;
                _begin = this.text.length();
                _ttype = 565;
                userMark = null;
                finalRunnable = null;
                boolean undefined = false;
                String nettype = null;
                String timescale = null;
                try {
                    try {
                        boolean synPredMatched326 = false;
                        if (this.LA(1) == '`' && _tokenSet_32.member((int)this.LA(2)) && _tokenSet_33.member((int)this.LA(3))) {
                            int _m326 = this.mark();
                            synPredMatched326 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("define");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched326 = false;
                            }
                            this.rewind(_m326);
                            this.inputState.decGuessing(synPredMatched326);
                        }
                        if (synPredMatched326) {
                            this.mDEFINE_DEFINITION(false);
                            break block240;
                        }
                        boolean synPredMatched330 = false;
                        if (this.LA(1) == '`' && _tokenSet_34.member((int)this.LA(2)) && _tokenSet_35.member((int)this.LA(3))) {
                            int _m330 = this.mark();
                            synPredMatched330 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("undef");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched330 = false;
                            }
                            this.rewind(_m330);
                            this.inputState.decGuessing(synPredMatched330);
                        }
                        if (synPredMatched330) {
                            this.mUNDEF(false);
                            break block240;
                        }
                        boolean synPredMatched335 = false;
                        if (this.LA(1) == '`' && _tokenSet_36.member((int)this.LA(2)) && _tokenSet_37.member((int)this.LA(3))) {
                            int _m335 = this.mark();
                            synPredMatched335 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("resetall");
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched335 = false;
                            }
                            this.rewind(_m335);
                            this.inputState.decGuessing(synPredMatched335);
                        }
                        if (synPredMatched335) {
                            this.mRESETALL(false);
                            if (this.inputState.guessing() != 0) break block240;
                            try {
                                if (this.lS.isSkip()) {
                                    _ttype = -1;
                                    break block240;
                                }
                                _ttype = 605;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block240;
                        }
                        boolean synPredMatched340 = false;
                        if (this.LA(1) == '`' && _tokenSet_34.member((int)this.LA(2)) && _tokenSet_35.member((int)this.LA(3))) {
                            int _m340 = this.mark();
                            synPredMatched340 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("undefineall");
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched340 = false;
                            }
                            this.rewind(_m340);
                            this.inputState.decGuessing(synPredMatched340);
                        }
                        if (synPredMatched340) {
                            this.mUNDEFINEALL(false);
                            break block240;
                        }
                        boolean synPredMatched344 = false;
                        if (this.LA(1) == '`' && _tokenSet_34.member((int)this.LA(2)) && _tokenSet_35.member((int)this.LA(3))) {
                            int _m344 = this.mark();
                            synPredMatched344 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("unconnected_drive");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched344 = false;
                            }
                            this.rewind(_m344);
                            this.inputState.decGuessing(synPredMatched344);
                        }
                        if (synPredMatched344) {
                            this.mUNCONNECTED_DRIVE(false);
                            break block240;
                        }
                        boolean synPredMatched351 = false;
                        if (this.LA(1) == '`' && _tokenSet_11.member((int)this.LA(2)) && _tokenSet_12.member((int)this.LA(3))) {
                            int _m351 = this.mark();
                            synPredMatched351 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("include");
                                if (Character.isJavaIdentifierPart(this.LA(1))) {
                                    throw this.getSemanticException(" !Character.isJavaIdentifierPart(LA(1)) ");
                                }
                                this.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
                                switch (this.LA(1)) {
                                    case '\"': {
                                        this.match('\"');
                                        break;
                                    }
                                    case '<': {
                                        this.match('<');
                                        break;
                                    }
                                    case '`': {
                                        this.match('`');
                                        break;
                                    }
                                    case '/': 
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': 
                                    case 'G': 
                                    case 'H': 
                                    case 'I': 
                                    case 'J': 
                                    case 'K': 
                                    case 'L': 
                                    case 'M': 
                                    case 'N': 
                                    case 'O': 
                                    case 'P': 
                                    case 'Q': 
                                    case 'R': 
                                    case 'S': 
                                    case 'T': 
                                    case 'U': 
                                    case 'V': 
                                    case 'W': 
                                    case 'X': 
                                    case 'Y': 
                                    case 'Z': 
                                    case '\\': 
                                    case '_': 
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': 
                                    case 'g': 
                                    case 'h': 
                                    case 'i': 
                                    case 'j': 
                                    case 'k': 
                                    case 'l': 
                                    case 'm': 
                                    case 'n': 
                                    case 'o': 
                                    case 'p': 
                                    case 'q': 
                                    case 'r': 
                                    case 's': 
                                    case 't': 
                                    case 'u': 
                                    case 'v': 
                                    case 'w': 
                                    case 'x': 
                                    case 'y': 
                                    case 'z': {
                                        switch (this.LA(1)) {
                                            case '/': {
                                                this.match("/");
                                                break;
                                            }
                                            case '\\': {
                                                this.match("\\");
                                                break;
                                            }
                                            case 'A': 
                                            case 'B': 
                                            case 'C': 
                                            case 'D': 
                                            case 'E': 
                                            case 'F': 
                                            case 'G': 
                                            case 'H': 
                                            case 'I': 
                                            case 'J': 
                                            case 'K': 
                                            case 'L': 
                                            case 'M': 
                                            case 'N': 
                                            case 'O': 
                                            case 'P': 
                                            case 'Q': 
                                            case 'R': 
                                            case 'S': 
                                            case 'T': 
                                            case 'U': 
                                            case 'V': 
                                            case 'W': 
                                            case 'X': 
                                            case 'Y': 
                                            case 'Z': 
                                            case '_': 
                                            case 'a': 
                                            case 'b': 
                                            case 'c': 
                                            case 'd': 
                                            case 'e': 
                                            case 'f': 
                                            case 'g': 
                                            case 'h': 
                                            case 'i': 
                                            case 'j': 
                                            case 'k': 
                                            case 'l': 
                                            case 'm': 
                                            case 'n': 
                                            case 'o': 
                                            case 'p': 
                                            case 'q': 
                                            case 'r': 
                                            case 's': 
                                            case 't': 
                                            case 'u': 
                                            case 'v': 
                                            case 'w': 
                                            case 'x': 
                                            case 'y': 
                                            case 'z': {
                                                break;
                                            }
                                            default: {
                                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                            }
                                        }
                                        this.mINTERNAL_ID_1(false);
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched351 = false;
                            }
                            this.rewind(_m351);
                            this.inputState.decGuessing(synPredMatched351);
                        }
                        if (synPredMatched351) {
                            this.match('`');
                            this.mINCLUDE(false);
                            break block240;
                        }
                        boolean synPredMatched355 = false;
                        if (this.LA(1) == '`' && _tokenSet_38.member((int)this.LA(2)) && _tokenSet_39.member((int)this.LA(3))) {
                            int _m355 = this.mark();
                            synPredMatched355 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("timescale");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched355 = false;
                            }
                            this.rewind(_m355);
                            this.inputState.decGuessing(synPredMatched355);
                        }
                        if (synPredMatched355) {
                            timescale = this.mTIMESCALE(false);
                            if (this.inputState.guessing() != 0) break block240;
                            try {
                                this.text.setLength(_begin);
                                this.text.append(timescale);
                                if (this.lS.isSkip()) {
                                    _ttype = -1;
                                    break block240;
                                }
                                _ttype = 602;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block240;
                        }
                        boolean synPredMatched359 = false;
                        if (this.LA(1) == '`' && _tokenSet_11.member((int)this.LA(2)) && _tokenSet_40.member((int)this.LA(3))) {
                            int _m359 = this.mark();
                            synPredMatched359 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("ifdef");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched359 = false;
                            }
                            this.rewind(_m359);
                            this.inputState.decGuessing(synPredMatched359);
                        }
                        if (synPredMatched359) {
                            this.mIFDEF(false);
                            break block240;
                        }
                        boolean synPredMatched363 = false;
                        if (this.LA(1) == '`' && _tokenSet_11.member((int)this.LA(2)) && _tokenSet_40.member((int)this.LA(3))) {
                            int _m363 = this.mark();
                            synPredMatched363 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("ifndef");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched363 = false;
                            }
                            this.rewind(_m363);
                            this.inputState.decGuessing(synPredMatched363);
                        }
                        if (synPredMatched363) {
                            this.mIFNDEF(false);
                            break block240;
                        }
                        boolean synPredMatched367 = false;
                        if (this.LA(1) == '`' && _tokenSet_41.member((int)this.LA(2)) && _tokenSet_42.member((int)this.LA(3))) {
                            int _m367 = this.mark();
                            synPredMatched367 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("elsif");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched367 = false;
                            }
                            this.rewind(_m367);
                            this.inputState.decGuessing(synPredMatched367);
                        }
                        if (synPredMatched367) {
                            this.mELSIF_DEF(false);
                            break block240;
                        }
                        boolean synPredMatched372 = false;
                        if (this.LA(1) == '`' && _tokenSet_41.member((int)this.LA(2)) && _tokenSet_42.member((int)this.LA(3))) {
                            int _m372 = this.mark();
                            synPredMatched372 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("else");
                                switch (this.LA(1)) {
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case '\r': 
                                    case ' ': 
                                    case '\u00a0': {
                                        this.mWS(false);
                                        break;
                                    }
                                    case '/': {
                                        this.match("//");
                                        break;
                                    }
                                    default: {
                                        if (this.LA(1) != '\uffff') {
                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched372 = false;
                            }
                            this.rewind(_m372);
                            this.inputState.decGuessing(synPredMatched372);
                        }
                        if (synPredMatched372) {
                            this.mELSE_DEF(false);
                            break block240;
                        }
                        boolean synPredMatched377 = false;
                        if (this.LA(1) == '`' && _tokenSet_41.member((int)this.LA(2)) && _tokenSet_43.member((int)this.LA(3))) {
                            int _m377 = this.mark();
                            synPredMatched377 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("endif");
                                if (this.LA(1) != '\uffff' && Character.isJavaIdentifierPart(this.LA(1))) {
                                    throw this.getSemanticException(" LA(1) == EOF_CHAR || !Character.isJavaIdentifierPart(LA(1)) ");
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched377 = false;
                            }
                            this.rewind(_m377);
                            this.inputState.decGuessing(synPredMatched377);
                        }
                        if (synPredMatched377) {
                            this.mENDIF_DEF(false);
                            break block240;
                        }
                        boolean synPredMatched381 = false;
                        if (this.LA(1) == '`' && _tokenSet_44.member((int)this.LA(2)) && _tokenSet_45.member((int)this.LA(3))) {
                            int _m381 = this.mark();
                            synPredMatched381 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("line");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched381 = false;
                            }
                            this.rewind(_m381);
                            this.inputState.decGuessing(synPredMatched381);
                        }
                        if (synPredMatched381) {
                            this.mLINE_DEF(false);
                            break block240;
                        }
                        boolean synPredMatched385 = false;
                        if (this.LA(1) == '`' && _tokenSet_46.member((int)this.LA(2)) && _tokenSet_47.member((int)this.LA(3))) {
                            int _m385 = this.mark();
                            synPredMatched385 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("begin_keywords");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched385 = false;
                            }
                            this.rewind(_m385);
                            this.inputState.decGuessing(synPredMatched385);
                        }
                        if (synPredMatched385) {
                            this.mBEGIN_KEYWORDS(false);
                            break block240;
                        }
                        boolean synPredMatched390 = false;
                        if (this.LA(1) == '`' && _tokenSet_41.member((int)this.LA(2)) && _tokenSet_43.member((int)this.LA(3))) {
                            int _m390 = this.mark();
                            synPredMatched390 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("end_keywords");
                                if (this.LA(1) != '\uffff' && Character.isJavaIdentifierPart(this.LA(1))) {
                                    throw this.getSemanticException(" LA(1) == EOF_CHAR || !Character.isJavaIdentifierPart(LA(1)) ");
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched390 = false;
                            }
                            this.rewind(_m390);
                            this.inputState.decGuessing(synPredMatched390);
                        }
                        if (synPredMatched390) {
                            this.mEND_KEYWORDS(false);
                            break block240;
                        }
                        boolean synPredMatched394 = false;
                        if (this.LA(1) == '`' && _tokenSet_32.member((int)this.LA(2)) && _tokenSet_33.member((int)this.LA(3))) {
                            int _m394 = this.mark();
                            synPredMatched394 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("default_nettype");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched394 = false;
                            }
                            this.rewind(_m394);
                            this.inputState.decGuessing(synPredMatched394);
                        }
                        if (synPredMatched394) {
                            nettype = this.mDEFAULT_NETTYPE(false);
                            if (this.inputState.guessing() != 0) break block240;
                            try {
                                this.text.setLength(_begin);
                                this.text.append(nettype);
                                if (this.lS.isSkip()) {
                                    _ttype = -1;
                                    break block240;
                                }
                                _ttype = 600;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block240;
                        }
                        boolean synPredMatched399 = false;
                        if (this.LA(1) == '`' && _tokenSet_48.member((int)this.LA(2)) && _tokenSet_49.member((int)this.LA(3))) {
                            int _m399 = this.mark();
                            synPredMatched399 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("pragma");
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched399 = false;
                            }
                            this.rewind(_m399);
                            this.inputState.decGuessing(synPredMatched399);
                        }
                        if (synPredMatched399) {
                            this.mPRAGMA(false);
                            break block240;
                        }
                        boolean synPredMatched404 = false;
                        if (this.LA(1) == '`' && _tokenSet_48.member((int)this.LA(2)) && _tokenSet_49.member((int)this.LA(3))) {
                            int _m404 = this.mark();
                            synPredMatched404 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("protect");
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched404 = false;
                            }
                            this.rewind(_m404);
                            this.inputState.decGuessing(synPredMatched404);
                        }
                        if (synPredMatched404) {
                            this.mPROTECT(false);
                            break block240;
                        }
                        boolean synPredMatched411 = false;
                        if (this.LA(1) == '`' && _tokenSet_48.member((int)this.LA(2)) && _tokenSet_49.member((int)this.LA(3))) {
                            int _m411 = this.mark();
                            synPredMatched411 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("protected");
                                while (this.LA(1) >= '0' && this.LA(1) <= '9') {
                                    this.matchRange('0', '9');
                                }
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched411 = false;
                            }
                            this.rewind(_m411);
                            this.inputState.decGuessing(synPredMatched411);
                        }
                        if (synPredMatched411) {
                            this.mPROTECTED(false, !this.lS.isSkip());
                            break block240;
                        }
                        boolean synPredMatched418 = false;
                        if (this.LA(1) == '`' && _tokenSet_48.member((int)this.LA(2)) && _tokenSet_49.member((int)this.LA(3))) {
                            int _m418 = this.mark();
                            synPredMatched418 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("protected_ip");
                                block124: while (true) {
                                    switch (this.LA(1)) {
                                        case 'a': 
                                        case 'b': 
                                        case 'c': 
                                        case 'd': 
                                        case 'e': 
                                        case 'f': 
                                        case 'g': 
                                        case 'h': 
                                        case 'i': 
                                        case 'j': 
                                        case 'k': 
                                        case 'l': 
                                        case 'm': 
                                        case 'n': 
                                        case 'o': 
                                        case 'p': 
                                        case 'q': 
                                        case 'r': 
                                        case 's': 
                                        case 't': 
                                        case 'u': 
                                        case 'v': 
                                        case 'w': 
                                        case 'x': 
                                        case 'y': 
                                        case 'z': {
                                            this.matchRange('a', 'z');
                                            continue block124;
                                        }
                                        case 'A': 
                                        case 'B': 
                                        case 'C': 
                                        case 'D': 
                                        case 'E': 
                                        case 'F': 
                                        case 'G': 
                                        case 'H': 
                                        case 'I': 
                                        case 'J': 
                                        case 'K': 
                                        case 'L': 
                                        case 'M': 
                                        case 'N': 
                                        case 'O': 
                                        case 'P': 
                                        case 'Q': 
                                        case 'R': 
                                        case 'S': 
                                        case 'T': 
                                        case 'U': 
                                        case 'V': 
                                        case 'W': 
                                        case 'X': 
                                        case 'Y': 
                                        case 'Z': {
                                            this.matchRange('A', 'Z');
                                            continue block124;
                                        }
                                        case '_': {
                                            this.match('_');
                                            continue block124;
                                        }
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': 
                                        case '4': 
                                        case '5': 
                                        case '6': 
                                        case '7': 
                                        case '8': 
                                        case '9': {
                                            this.matchRange('0', '9');
                                            continue block124;
                                        }
                                    }
                                    break;
                                }
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched418 = false;
                            }
                            this.rewind(_m418);
                            this.inputState.decGuessing(synPredMatched418);
                        }
                        if (synPredMatched418) {
                            this.mPROTECTED_IP(false, !this.lS.isSkip());
                            break block240;
                        }
                        boolean synPredMatched423 = false;
                        if (this.LA(1) == '`' && _tokenSet_41.member((int)this.LA(2)) && _tokenSet_43.member((int)this.LA(3))) {
                            int _m423 = this.mark();
                            synPredMatched423 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("endprotect");
                                if (this.LA(1) != '\uffff' && Character.isJavaIdentifierPart(this.LA(1))) {
                                    throw this.getSemanticException(" LA(1) == EOF_CHAR || !Character.isJavaIdentifierPart(LA(1)) ");
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched423 = false;
                            }
                            this.rewind(_m423);
                            this.inputState.decGuessing(synPredMatched423);
                        }
                        if (synPredMatched423) {
                            this.mENDPROTECT(false);
                            break block240;
                        }
                        boolean synPredMatched430 = false;
                        if (this.LA(1) == '`' && _tokenSet_41.member((int)this.LA(2)) && _tokenSet_43.member((int)this.LA(3))) {
                            int _m430 = this.mark();
                            synPredMatched430 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("endprotected");
                                while (this.LA(1) >= '0' && this.LA(1) <= '9') {
                                    this.matchRange('0', '9');
                                }
                                if (this.LA(1) != '\uffff' && Character.isJavaIdentifierPart(this.LA(1))) {
                                    throw this.getSemanticException(" LA(1) == EOF_CHAR || !Character.isJavaIdentifierPart(LA(1)) ");
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched430 = false;
                            }
                            this.rewind(_m430);
                            this.inputState.decGuessing(synPredMatched430);
                        }
                        if (synPredMatched430) {
                            this.mENDPROTECTED(false);
                            break block240;
                        }
                        boolean synPredMatched437 = false;
                        if (this.LA(1) == '`' && _tokenSet_41.member((int)this.LA(2)) && _tokenSet_43.member((int)this.LA(3))) {
                            int _m437 = this.mark();
                            synPredMatched437 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("endprotected_ip");
                                block129: while (true) {
                                    switch (this.LA(1)) {
                                        case 'a': 
                                        case 'b': 
                                        case 'c': 
                                        case 'd': 
                                        case 'e': 
                                        case 'f': 
                                        case 'g': 
                                        case 'h': 
                                        case 'i': 
                                        case 'j': 
                                        case 'k': 
                                        case 'l': 
                                        case 'm': 
                                        case 'n': 
                                        case 'o': 
                                        case 'p': 
                                        case 'q': 
                                        case 'r': 
                                        case 's': 
                                        case 't': 
                                        case 'u': 
                                        case 'v': 
                                        case 'w': 
                                        case 'x': 
                                        case 'y': 
                                        case 'z': {
                                            this.matchRange('a', 'z');
                                            continue block129;
                                        }
                                        case 'A': 
                                        case 'B': 
                                        case 'C': 
                                        case 'D': 
                                        case 'E': 
                                        case 'F': 
                                        case 'G': 
                                        case 'H': 
                                        case 'I': 
                                        case 'J': 
                                        case 'K': 
                                        case 'L': 
                                        case 'M': 
                                        case 'N': 
                                        case 'O': 
                                        case 'P': 
                                        case 'Q': 
                                        case 'R': 
                                        case 'S': 
                                        case 'T': 
                                        case 'U': 
                                        case 'V': 
                                        case 'W': 
                                        case 'X': 
                                        case 'Y': 
                                        case 'Z': {
                                            this.matchRange('A', 'Z');
                                            continue block129;
                                        }
                                        case '_': {
                                            this.match('_');
                                            continue block129;
                                        }
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': 
                                        case '4': 
                                        case '5': 
                                        case '6': 
                                        case '7': 
                                        case '8': 
                                        case '9': {
                                            this.matchRange('0', '9');
                                            continue block129;
                                        }
                                    }
                                    break;
                                }
                                if (this.LA(1) != '\uffff' && Character.isJavaIdentifierPart(this.LA(1))) {
                                    throw this.getSemanticException(" LA(1) == EOF_CHAR || !Character.isJavaIdentifierPart(LA(1)) ");
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched437 = false;
                            }
                            this.rewind(_m437);
                            this.inputState.decGuessing(synPredMatched437);
                        }
                        if (synPredMatched437) {
                            this.mENDPROTECTED_IP(false);
                            break block240;
                        }
                        boolean synPredMatched441 = false;
                        if (this.LA(1) == '`' && _tokenSet_32.member((int)this.LA(2)) && _tokenSet_33.member((int)this.LA(3))) {
                            int _m441 = this.mark();
                            synPredMatched441 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("default_decay_time");
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched441 = false;
                            }
                            this.rewind(_m441);
                            this.inputState.decGuessing(synPredMatched441);
                        }
                        if (synPredMatched441) {
                            this.mDEFAULT_DECAY_TIME(false);
                            break block240;
                        }
                        boolean synPredMatched446 = false;
                        if (this.LA(1) == '`' && _tokenSet_34.member((int)this.LA(2)) && _tokenSet_50.member((int)this.LA(3))) {
                            int _m446 = this.mark();
                            synPredMatched446 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("uselib");
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched446 = false;
                            }
                            this.rewind(_m446);
                            this.inputState.decGuessing(synPredMatched446);
                        }
                        if (synPredMatched446) {
                            this.mUSELIB(false);
                            break block240;
                        }
                        boolean synPredMatched451 = false;
                        if (this.LA(1) == '`' && _tokenSet_51.member((int)this.LA(2)) && _tokenSet_52.member((int)this.LA(3))) {
                            int _m451 = this.mark();
                            synPredMatched451 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("worklib");
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched451 = false;
                            }
                            this.rewind(_m451);
                            this.inputState.decGuessing(synPredMatched451);
                        }
                        if (synPredMatched451) {
                            this.mWORKLIB(false);
                            if (this.inputState.guessing() != 0) break block240;
                            try {
                                if (this.lS.isSkip()) {
                                    _ttype = -1;
                                    break block240;
                                }
                                _ttype = 634;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block240;
                        }
                        boolean synPredMatched456 = false;
                        if (this.LA(1) == '`' && _tokenSet_53.member((int)this.LA(2)) && _tokenSet_54.member((int)this.LA(3))) {
                            int _m456 = this.mark();
                            synPredMatched456 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("noworklib");
                                if (_tokenSet_22.member((int)this.LA(1))) {
                                    this.mWS(false);
                                } else if (this.LA(1) != '\uffff') {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched456 = false;
                            }
                            this.rewind(_m456);
                            this.inputState.decGuessing(synPredMatched456);
                        }
                        if (synPredMatched456) {
                            this.mNOWORKLIB(false);
                            if (this.inputState.guessing() != 0) break block240;
                            try {
                                if (this.lS.isSkip()) {
                                    _ttype = -1;
                                    break block240;
                                }
                                _ttype = 635;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block240;
                        }
                        boolean synPredMatched458 = false;
                        if (this.LA(1) == '`' && this.LA(2) == '\"') {
                            int _m458 = this.mark();
                            synPredMatched458 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("`\"");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched458 = false;
                            }
                            this.rewind(_m458);
                            this.inputState.decGuessing(synPredMatched458);
                        }
                        if (synPredMatched458) {
                            this.mREPLACE_MACRO_STRING(false);
                            if (this.inputState.guessing() == 0) {
                                try {
                                    _ttype = 557;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block240;
                        }
                        boolean synPredMatched462 = false;
                        if (this.LA(1) == '`' && _tokenSet_14.member((int)this.LA(2))) {
                            int _m462 = this.mark();
                            synPredMatched462 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.mDEFINE_ID(false, false, true);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched462 = false;
                            }
                            this.rewind(_m462);
                            this.inputState.decGuessing(synPredMatched462);
                        }
                        if (synPredMatched462) {
                            undefined = this.mDEFINE_REPLACE(false, "", true);
                            if (this.inputState.guessing() != 0) break block240;
                            try {
                                if (undefined) {
                                    _ttype = 285;
                                }
                                break block240;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block240;
                        }
                        if (this.LA(1) == '`' && this.lS.containsSkipDefine(this)) {
                            this.match('`');
                            break block240;
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block243;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_WS_NL_OR_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 575;
        switch (this.LA(1)) {
            case '\t': 
            case '\f': 
            case ' ': 
            case '\u00a0': {
                this.mDEFINE_WS(false);
                break;
            }
            case '\n': {
                this.match('\n');
                if (this.inputState.guessing() != 0) break;
                try {
                    this.newline();
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
                break;
            }
            default: {
                if (this.LA(1) == '/' && this.LA(2) == '*') {
                    this.mML_COMMENT(false);
                    break;
                }
                if (this.LA(1) == '/' && this.LA(2) == '/') {
                    this.mSL_COMMENT(false);
                    break;
                }
                if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                    this.match("\r\n");
                    if (this.inputState.guessing() != 0) break;
                    try {
                        this.newline();
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    break;
                }
                if (this.LA(1) == '\r') {
                    this.match('\r');
                    if (this.inputState.guessing() != 0) break;
                    try {
                        this.newline();
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    break;
                }
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_DEFINITION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block21: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block20: {
                _token = null;
                _begin = this.text.length();
                _ttype = 576;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                List macroText = OptimizedUtils.listCreate((int)1);
                List<VlogMacroParameter> parameters = null;
                int offset = this.getOffset();
                int line = this.getLine();
                try {
                    try {
                        int _saveIndex = this.text.length();
                        this.match('`');
                        this.text.setLength(_saveIndex);
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            _saveIndex = this.text.length();
                            this.mDEFINE_WS(false);
                            this.text.setLength(_saveIndex);
                        }
                        _saveIndex = this.text.length();
                        this.match("define");
                        this.text.setLength(_saveIndex);
                        int _cnt515 = 0;
                        while (true) {
                            if (!_tokenSet_55.member((int)this.LA(1))) {
                                if (_cnt515 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS_OR_COMMENT(false);
                            ++_cnt515;
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                line = this.getLine();
                                offset = this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mDEFINE_ID(true, true, true);
                        id = this._returnToken;
                        parameters = this.mDEFINE_MACRO_PARAM(false);
                        this.mDEFINE_MACRO_TEXT(false, macroText);
                        if (this.inputState.guessing() != 0) break block20;
                        try {
                            try {
                                VlogMacroInfo macro;
                                if (this.lS.isSkip() && this.ifdefID != null && this.ifndefGuard && (macro = this.util.getDefine(this.ifdefID, false)) != null && macro.isIfndefGuard()) {
                                    macro.setReplacementMacro();
                                }
                                this.util.addDefine(id.getText(), new VlogMacroText(parameters, macroText), this.lS.isSkip(), new LineInfo(line, offset, -1), this.getLineInfo(), this.lS.getLastLine(), this.lS.getReparseStackLT(), false);
                            }
                            catch (VlogException e) {
                                this.reportError(e.getSeverity(), this.getFilename(), line, offset, id.getLength(), e.getMessage());
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mUNDEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block20: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block19: {
                _token = null;
                _begin = this.text.length();
                _ttype = 592;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                int offset = this.getOffset();
                int line = this.getLine();
                try {
                    try {
                        this.match('`');
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            this.mDEFINE_WS(false);
                        }
                        this.match("undef");
                        int _cnt637 = 0;
                        while (true) {
                            if (!_tokenSet_18.member((int)this.LA(1))) {
                                if (_cnt637 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS_NL_OR_COMMENT(false);
                            ++_cnt637;
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                line = this.getLine();
                                offset = this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mDEFINE_ID(true, false, true);
                        id = this._returnToken;
                        if (this.inputState.guessing() != 0) break block19;
                        try {
                            try {
                                this.util.addUndef(id.getText(), this.lS.isSkip(), new LineInfo(line, offset, -1), this.getLineInfo(), this.lS.getLastLine(), this.lS.getReparseStackLT());
                            }
                            catch (VlogException e) {
                                this.reportError(e.getSeverity(), this.getFilename(), line, offset, id.getLength(), e.getMessage());
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mRESETALL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 605;
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("resetall");
        if (this.inputState.guessing() == 0) {
            try {
                if (this.lS.isSkip()) {
                    return;
                }
                this.util.debug("Lexing `resetall ");
                this.util.addDefaultNettype(this.getLine(), "wire");
                this.util.resetTimescale(this.getLine());
                this.notAllowed(44, "resetall");
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mUNDEFINEALL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 606;
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("undefineall");
        if (this.inputState.guessing() == 0) {
            try {
                if (this.lS.isSkip()) {
                    return;
                }
                this.util.debug("Lexing `undefineall ");
                this.util.undefAllMacros(this.lS.isSkip(), false);
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mUNCONNECTED_DRIVE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 607;
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("unconnected_drive");
        int _cnt791 = 0;
        while (true) {
            if (!_tokenSet_18.member((int)this.LA(1))) {
                if (_cnt791 >= 1) break;
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.mDEFINE_WS_NL_OR_COMMENT(false);
            ++_cnt791;
        }
        this.match("pull");
        switch (this.LA(1)) {
            case '0': {
                this.match('0');
                break;
            }
            case '1': {
                this.match('1');
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_WS_NL_OR_COMMENT_OPT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 578;
        boolean synPredMatched530 = false;
        if (_tokenSet_18.member((int)this.LA(1))) {
            int _m530 = this.mark();
            synPredMatched530 = true;
            this.inputState.incGuessing();
            try {
                this.mDEFINE_WS_NL_OR_COMMENT(false);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched530 = false;
            }
            this.rewind(_m530);
            this.inputState.decGuessing(synPredMatched530);
        }
        if (synPredMatched530) {
            this.mDEFINE_WS_NL_OR_COMMENT(false);
            this.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    /*
     * Loose catch block
     */
    protected final String mTIMESCALE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        String values;
        block36: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block34: {
                StringBuilder timeRefs;
                boolean shouldConsume;
                block35: {
                    block37: {
                        block39: {
                            block38: {
                                values = "";
                                _token = null;
                                _begin = this.text.length();
                                _ttype = 602;
                                userMark = null;
                                finalRunnable = null;
                                boolean isTimeprecision = false;
                                shouldConsume = true;
                                timeRefs = new StringBuilder();
                                this.match('`');
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("timescale");
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        shouldConsume = false;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                int _cnt755 = 0;
                                while (true) {
                                    if (!_tokenSet_18.member((int)this.LA(1))) {
                                        if (_cnt755 >= 1) break;
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                    this.mDEFINE_WS_NL_OR_COMMENT(false);
                                    ++_cnt755;
                                }
                                isTimeprecision = this.mTIME_REF(false, timeRefs);
                                if (!_tokenSet_18.member((int)this.LA(1)) || isTimeprecision) break block37;
                                switch (this.LA(1)) {
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case '\r': 
                                    case ' ': 
                                    case '\u00a0': {
                                        this.mWS(false);
                                        break;
                                    }
                                    case '/': {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                                if (this.LA(1) != '/' || this.LA(2) != '*') break block38;
                                this.mML_COMMENT(false);
                                switch (this.LA(1)) {
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case '\r': 
                                    case ' ': 
                                    case '\u00a0': {
                                        this.mWS(false);
                                        break block39;
                                    }
                                    case '/': {
                                        break block39;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                            }
                            if (this.LA(1) != '/' || !_tokenSet_56.member((int)this.LA(2))) {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        this.mDIV(false);
                        this.mDEFINE_WS_NL_OR_COMMENT_OPT(false);
                        if (this.inputState.guessing() == 0) {
                            try {
                                timeRefs.append("/");
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mTIME_REF(false, timeRefs);
                    }
                    if (this.inputState.guessing() != 0) break block34;
                    if (!this.lS.isSkip()) break block35;
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    return "";
                }
                try {
                    try {
                        String all = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                        this.notAllowed(37, all);
                        values = timeRefs.toString();
                        this.util.addTimescale(this.getLine(), values);
                        {
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            if (shouldConsume) {
                                this.consume();
                            }
                        } else {
                            throw ex;
                        }
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return values;
    }

    protected final void mIFDEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block84: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block83: {
                int offset;
                _token = null;
                _begin = this.text.length();
                _ttype = 1;
                userMark = null;
                finalRunnable = null;
                Token id1 = null;
                Token id2 = null;
                Token id3 = null;
                Token par = null;
                VlogMacroInfo macro = null;
                String params = null;
                boolean possibleParams = false;
                Token id = new Token();
                int column = 0;
                int line = 0;
                int offset1 = offset = this.getOffset();
                int line1 = this.getLine();
                String idText = "";
                boolean nonStandard = false;
                try {
                    try {
                        this.match('`');
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            this.mDEFINE_WS(false);
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                offset1 = this.getOffset();
                                line1 = this.getLine();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.match("ifdef");
                        int _cnt642 = 0;
                        while (true) {
                            if (!_tokenSet_18.member((int)this.LA(1))) {
                                if (_cnt642 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS_NL_OR_COMMENT(false);
                            ++_cnt642;
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                offset = this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        boolean synPredMatched645 = false;
                        if (this.LA(1) == '`' && _tokenSet_48.member((int)this.LA(2)) && _tokenSet_49.member((int)this.LA(3))) {
                            int _m645 = this.mark();
                            synPredMatched645 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mPROTECTED(false, false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched645 = false;
                            }
                            this.rewind(_m645);
                            this.inputState.decGuessing(synPredMatched645);
                        }
                        if (synPredMatched645) {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    offset = this.getOffset();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.mPROTECTED(true, false);
                            id2 = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    id = id2;
                                    nonStandard = true;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else if (this.LA(1) == '`' && _tokenSet_14.member((int)this.LA(2))) {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    userMark = this.userMark();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.match('`');
                            while (_tokenSet_13.member((int)this.LA(1))) {
                                this.mDEFINE_WS(false);
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    offset = this.getOffset();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.mDEFINE_ID(true, false, true);
                            id3 = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    id = id3;
                                    nonStandard = true;
                                    if ("endif".equals(id.getText()) || "else".equals(id.getText()) || "elsif".equals(id.getText()) || "ifdef".equals(id.getText()) || "ifndef".equals(id.getText()) || "protect".equals(id.getText()) || "define".equals(id.getText())) {
                                        this.userRewind(userMark);
                                    } else {
                                        this.userRelease(userMark);
                                        macro = this.util.getDefine(id.getText(), false);
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            if (_tokenSet_57.member((int)this.LA(1)) && macro != null && macro.hasParams()) {
                                while (_tokenSet_55.member((int)this.LA(1))) {
                                    this.mDEFINE_WS_OR_COMMENT(false);
                                }
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        line = this.getLine();
                                        column = this.getColumn() + 1;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                this.mDEFINE_REPLACE_PARAMS(true, macro.getName());
                                par = this._returnToken;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        params = par.getText();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else if (macro == null || !macro.hasParams()) {
                                boolean synPredMatched653 = false;
                                int _m653 = this.mark();
                                synPredMatched653 = true;
                                this.inputState.incGuessing();
                                try {
                                    while (_tokenSet_55.member((int)this.LA(1))) {
                                        this.mDEFINE_WS_OR_COMMENT(false);
                                    }
                                    this.mLPAREN(false);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched653 = false;
                                }
                                this.rewind(_m653);
                                this.inputState.decGuessing(synPredMatched653);
                                if (synPredMatched653 && this.inputState.guessing() == 0) {
                                    try {
                                        possibleParams = macro == null;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                                    idText = id.getText();
                                    if (macro != null) {
                                        String[] parameters = VlogUtil.splitParameters(params, this.util.getToolCompat());
                                        parameters = this.util.preprocess(parameters, this.getLine(), this.parserPath, this.indexer);
                                        String replacement = macro.getReplacement(this.util, parameters, this.getLine(), this.parserPath);
                                        this.dependsOn(id.getText(), macro.getMacroText());
                                        if (!this.lS.isMacroReparsing()) {
                                            this.util.setReference(this.lS.getCurrentFileInstance(), id.getLine(), this.lS.getLastLine(), id.getOffset(), id.getText(), parameters, true);
                                        }
                                        if (this.indexer != null && !this.isMacroReparsing() && params != null) {
                                            this.indexer.index2(params, line, column, -1, false, this.lS.isSkip(), false);
                                        }
                                        if (this.indexer != null && macro != null) {
                                            this.indexer.index2(macro.getName(), line, column, -1, false, this.lS.isSkip(), true);
                                        }
                                        id.setText(replacement);
                                    } else if (possibleParams) {
                                        this.mUNDEFINED_MACRO_POSSIBLE_PARAMS(false, id.getText());
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else if (_tokenSet_58.member((int)this.LA(1))) {
                            this.mDEFINE_ID(true, false, true);
                            id1 = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    id = id1;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        if (this.inputState.guessing() != 0) break block83;
                        try {
                            this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                            if (nonStandard) {
                                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), line1, offset1, "ifdef".length(), VlogUtil.getNonStandardMessage(RfNonStandardProblem.COMPILER_GUARD, idText.replace('\ufff0', ' ')));
                            }
                            macro = this.util.getConditionDefine(id.getText(), false, this.getLineInfo(id), this.getLineInfo());
                            if (!this.lS.isSkip()) {
                                this.dependsOn(id.getText(), macro == null);
                            }
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.parentLexer = this;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = id.getText();
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 1;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (macro != null) {
                                this.util.debug("Lexing `ifdef ", id.getText());
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                newLexer.skipElseBranch = true;
                                break block83;
                            }
                            this.util.debug("Skipping `ifdef ", id.getText());
                            if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                            }
                            this.consumeTokensUntilEndif("`ifdef", 1, this.getLanguageSyntax(), new Stack<VlogLexer>());
                            this.lS.addSkipDefine(newLexer);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block84;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mIFNDEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block86: {
            int offset;
            _token = null;
            _begin = this.text.length();
            _ttype = 594;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            Token id1 = null;
            Token id2 = null;
            Token id3 = null;
            Token par = null;
            VlogMacroInfo macro = null;
            String params = null;
            boolean possibleParams = false;
            Token id = new Token();
            int column = 0;
            int line = 0;
            int offset1 = offset = this.getOffset();
            int line1 = this.getLine();
            String idText = "";
            boolean nonStandard = false;
            try {
                try {
                    this.match('`');
                    while (_tokenSet_13.member((int)this.LA(1))) {
                        this.mDEFINE_WS(false);
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            offset1 = this.getOffset();
                            line1 = this.getLine();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.match("ifndef");
                    int _cnt660 = 0;
                    while (true) {
                        if (!_tokenSet_18.member((int)this.LA(1))) {
                            if (_cnt660 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.mDEFINE_WS_NL_OR_COMMENT(false);
                        ++_cnt660;
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            offset = this.getOffset();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    boolean synPredMatched663 = false;
                    if (this.LA(1) == '`' && _tokenSet_48.member((int)this.LA(2)) && _tokenSet_49.member((int)this.LA(3))) {
                        int _m663 = this.mark();
                        synPredMatched663 = true;
                        this.inputState.incGuessing();
                        try {
                            this.mPROTECTED(false, false);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched663 = false;
                        }
                        this.rewind(_m663);
                        this.inputState.decGuessing(synPredMatched663);
                    }
                    if (synPredMatched663) {
                        if (this.inputState.guessing() == 0) {
                            try {
                                offset = this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mPROTECTED(true, true);
                        id2 = this._returnToken;
                        if (this.inputState.guessing() == 0) {
                            try {
                                id = id2;
                                nonStandard = true;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else if (this.LA(1) == '`' && _tokenSet_14.member((int)this.LA(2))) {
                        if (this.inputState.guessing() == 0) {
                            try {
                                userMark = this.userMark();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.match('`');
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            this.mDEFINE_WS(false);
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                offset = this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.mDEFINE_ID(true, false, true);
                        id3 = this._returnToken;
                        if (this.inputState.guessing() == 0) {
                            try {
                                id = id3;
                                nonStandard = true;
                                if ("endif".equals(id.getText()) || "else".equals(id.getText()) || "elsif".equals(id.getText()) || "ifdef".equals(id.getText()) || "ifndef".equals(id.getText()) || "protect".equals(id.getText()) || "define".equals(id.getText())) {
                                    this.userRewind(userMark);
                                } else {
                                    this.userRelease(userMark);
                                    macro = this.util.getDefine(id.getText(), false);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (_tokenSet_57.member((int)this.LA(1)) && macro != null && macro.hasParams()) {
                            while (_tokenSet_55.member((int)this.LA(1))) {
                                this.mDEFINE_WS_OR_COMMENT(false);
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    line = this.getLine();
                                    column = this.getColumn() + 1;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.mDEFINE_REPLACE_PARAMS(true, macro.getName());
                            par = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    params = par.getText();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else if (macro == null || !macro.hasParams()) {
                            boolean synPredMatched671 = false;
                            int _m671 = this.mark();
                            synPredMatched671 = true;
                            this.inputState.incGuessing();
                            try {
                                while (_tokenSet_55.member((int)this.LA(1))) {
                                    this.mDEFINE_WS_OR_COMMENT(false);
                                }
                                this.mLPAREN(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched671 = false;
                            }
                            this.rewind(_m671);
                            this.inputState.decGuessing(synPredMatched671);
                            if (synPredMatched671 && this.inputState.guessing() == 0) {
                                try {
                                    possibleParams = macro == null;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                                idText = id.getText();
                                if (macro != null) {
                                    String[] parameters = VlogUtil.splitParameters(params, this.util.getToolCompat());
                                    parameters = this.util.preprocess(parameters, this.getLine(), this.parserPath, this.indexer);
                                    String replacement = macro.getReplacement(this.util, parameters, this.getLine(), this.parserPath);
                                    this.dependsOn(id.getText(), macro.getMacroText());
                                    if (!this.lS.isMacroReparsing()) {
                                        this.util.setReference(this.lS.getCurrentFileInstance(), id.getLine(), this.lS.getLastLine(), id.getOffset(), id.getText(), parameters, true);
                                    }
                                    if (this.indexer != null && !this.isMacroReparsing() && params != null) {
                                        this.indexer.index2(params, line, column, -1, false, this.lS.isSkip(), false);
                                    }
                                    if (this.indexer != null && macro != null) {
                                        this.indexer.index2(macro.getName(), line, column, -1, false, this.lS.isSkip(), true);
                                    }
                                    id.setText(replacement);
                                } else if (possibleParams) {
                                    this.mUNDEFINED_MACRO_POSSIBLE_PARAMS(false, id.getText());
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else if (_tokenSet_58.member((int)this.LA(1))) {
                        this.mDEFINE_ID(true, false, true);
                        id1 = this._returnToken;
                        if (this.inputState.guessing() == 0) {
                            try {
                                id = id1;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                            if (nonStandard) {
                                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), line1, offset1, "ifndef".length(), VlogUtil.getNonStandardMessage(RfNonStandardProblem.COMPILER_GUARD, idText.replace('\ufff0', ' ')));
                            }
                            macro = this.util.getConditionDefine(id.getText(), false, this.getLineInfo(id), this.getLineInfo());
                            if (!this.lS.isSkip()) {
                                this.dependsOn(id.getText(), macro == null);
                            }
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.parentLexer = this;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = id.getText();
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 1;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (macro != null) {
                                this.util.debug("Skipping `ifndef ", id.getText());
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                this.consumeTokensUntilEndif("`ifndef", 1, this.getLanguageSyntax(), new Stack<VlogLexer>());
                                this.lS.addSkipDefine(newLexer);
                            } else {
                                this.util.debug("Lexing `ifndef ", id.getText());
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                newLexer.skipElseBranch = true;
                            }
                            newLexer.ifndefGuard = true;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block86;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mELSIF_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block86: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block85: {
                int offset;
                _token = null;
                _begin = this.text.length();
                _ttype = 596;
                userMark = null;
                finalRunnable = null;
                Token id1 = null;
                Token id2 = null;
                Token id3 = null;
                Token par = null;
                VlogMacroInfo macro = null;
                String params = null;
                boolean possibleParams = false;
                Token id = new Token();
                int column = 0;
                int line = 0;
                int offset1 = offset = this.getOffset();
                int line1 = this.getLine();
                String idText = "";
                boolean nonStandard = false;
                try {
                    try {
                        this.match('`');
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            this.mDEFINE_WS(false);
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                offset1 = this.getOffset();
                                line1 = this.getLine();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.match("elsif");
                        int _cnt681 = 0;
                        while (true) {
                            if (!_tokenSet_18.member((int)this.LA(1))) {
                                if (_cnt681 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.mDEFINE_WS_NL_OR_COMMENT(false);
                            ++_cnt681;
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                offset = this.getOffset();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        boolean synPredMatched684 = false;
                        if (this.LA(1) == '`' && _tokenSet_48.member((int)this.LA(2)) && _tokenSet_49.member((int)this.LA(3))) {
                            int _m684 = this.mark();
                            synPredMatched684 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mPROTECTED(false, false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched684 = false;
                            }
                            this.rewind(_m684);
                            this.inputState.decGuessing(synPredMatched684);
                        }
                        if (synPredMatched684) {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    offset = this.getOffset();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.mPROTECTED(true, false);
                            id2 = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    id = id2;
                                    nonStandard = true;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else if (this.LA(1) == '`' && _tokenSet_14.member((int)this.LA(2))) {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    userMark = this.userMark();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.match('`');
                            while (_tokenSet_13.member((int)this.LA(1))) {
                                this.mDEFINE_WS(false);
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    offset = this.getOffset();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.mDEFINE_ID(true, false, true);
                            id3 = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    id = id3;
                                    nonStandard = true;
                                    if ("endif".equals(id.getText()) || "else".equals(id.getText()) || "elsif".equals(id.getText()) || "ifdef".equals(id.getText()) || "ifndef".equals(id.getText()) || "protect".equals(id.getText()) || "define".equals(id.getText())) {
                                        this.userRewind(userMark);
                                    } else {
                                        this.userRelease(userMark);
                                        macro = this.util.getDefine(id.getText(), false);
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            if (_tokenSet_57.member((int)this.LA(1)) && macro != null && macro.hasParams()) {
                                while (_tokenSet_55.member((int)this.LA(1))) {
                                    this.mDEFINE_WS_OR_COMMENT(false);
                                }
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        line = this.getLine();
                                        column = this.getColumn() + 1;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                this.mDEFINE_REPLACE_PARAMS(true, macro.getName());
                                par = this._returnToken;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        params = par.getText();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else if (macro == null || !macro.hasParams()) {
                                boolean synPredMatched692 = false;
                                int _m692 = this.mark();
                                synPredMatched692 = true;
                                this.inputState.incGuessing();
                                try {
                                    while (_tokenSet_55.member((int)this.LA(1))) {
                                        this.mDEFINE_WS_OR_COMMENT(false);
                                    }
                                    this.mLPAREN(false);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched692 = false;
                                }
                                this.rewind(_m692);
                                this.inputState.decGuessing(synPredMatched692);
                                if (synPredMatched692 && this.inputState.guessing() == 0) {
                                    try {
                                        possibleParams = macro == null;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                                    idText = id.getText();
                                    if (macro != null) {
                                        String[] parameters = VlogUtil.splitParameters(params, this.util.getToolCompat());
                                        parameters = this.util.preprocess(parameters, this.getLine(), this.parserPath, this.indexer);
                                        String replacement = macro.getReplacement(this.util, parameters, this.getLine(), this.parserPath);
                                        this.dependsOn(id.getText(), macro.getMacroText());
                                        if (!this.lS.isMacroReparsing()) {
                                            this.util.setReference(this.lS.getCurrentFileInstance(), id.getLine(), this.lS.getLastLine(), id.getOffset(), id.getText(), parameters, true);
                                        }
                                        if (this.indexer != null && !this.isMacroReparsing() && params != null) {
                                            this.indexer.index2(params, line, column, -1, false, this.lS.isSkip(), false);
                                        }
                                        if (this.indexer != null && macro != null) {
                                            this.indexer.index2(macro.getName(), line, column, -1, false, this.lS.isSkip(), true);
                                        }
                                        id.setText(replacement);
                                    } else if (possibleParams) {
                                        this.mUNDEFINED_MACRO_POSSIBLE_PARAMS(false, id.getText());
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else if (_tokenSet_58.member((int)this.LA(1))) {
                            this.mDEFINE_ID(true, false, true);
                            id1 = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    id = id1;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        if (this.inputState.guessing() != 0) break block85;
                        try {
                            this.ifndefGuard = false;
                            if (this.lS.peek().preprocessingType != 1 && this.lS.peek().preprocessingType != 2) {
                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - 6, 6, "Unexpected `elsif (no starting `ifdef/`ifndef found)");
                                break block85;
                            }
                            int reparseFileLine = this.lS.peek().reparseFileLine;
                            String ifdefID = this.lS.peek().ifdefID;
                            this.lS.pop(true);
                            this.lS.peek().reparseFileLine = reparseFileLine;
                            this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                            if (nonStandard) {
                                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), line1, offset1, "elsif".length(), VlogUtil.getNonStandardMessage(RfNonStandardProblem.COMPILER_GUARD, idText.replace('\ufff0', ' ')));
                            }
                            macro = this.util.getConditionDefine(id.getText(), false, this.getLineInfo(id), this.getLineInfo());
                            if (!this.lS.isSkip()) {
                                this.dependsOn(id.getText(), macro == null);
                            }
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.parentLexer = this;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = ifdefID;
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 2;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (macro != null && this.lS.containsSkipDefine(this) && !this.skipElseBranch) {
                                this.util.debug("Lexing `elsif ", id.getText());
                                if (this.lS.fSkipDefine.size() == 1 && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                newLexer.skipElseBranch = true;
                            } else {
                                this.util.debug("Skipping `elsif ", id.getText());
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), id.getLine(), id.getColumn());
                                }
                                newLexer.skipElseBranch = this.skipElseBranch;
                                this.lS.addSkipDefine(newLexer);
                            }
                            this.lS.removeSkipDefine(this);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block86;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mELSE_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block19: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block18: {
                _token = null;
                _begin = this.text.length();
                _ttype = 595;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        this.match('`');
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            this.mDEFINE_WS(false);
                        }
                        this.match("else");
                        if (this.inputState.guessing() != 0) break block18;
                        try {
                            this.ifndefGuard = false;
                            if (this.lS.peek().preprocessingType != 1 && this.lS.peek().preprocessingType != 2) {
                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - 5, 5, "Unexpected `else (no starting `ifdef/`ifndef found)");
                                break block18;
                            }
                            String ifdefID = this.lS.peek().ifdefID;
                            this.lS.pop(true);
                            VlogLexer newLexer = new VlogLexer(this.getInputState(), (Map<ANTLRHashString, Integer>)this.literals);
                            newLexer.lS = this.lS;
                            newLexer.parentLexer = this;
                            newLexer.util = this.util;
                            newLexer.followImports = this.followImports;
                            newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                            newLexer.rfp = this.rfp;
                            newLexer.parserPath = this.parserPath;
                            newLexer.fileIndex = this.fileIndex;
                            newLexer.setFilename(this.getFilename(), this.indexer, false);
                            newLexer.ifdefID = ifdefID;
                            if (this.isMacroReparsing()) {
                                newLexer.setLockLine(this.getLine(), this.getOffset(), this.getColumn());
                                newLexer.reparseMacro = this.reparseMacro;
                                newLexer.reparseMacroName = this.reparseMacroName;
                                newLexer.reparseMacroParameters = this.reparseMacroParameters;
                                newLexer.reparseMacroUnprocessedParameters = this.reparseMacroUnprocessedParameters;
                                newLexer.reparseFileName = this.reparseFileName;
                                newLexer.reparseFileLine = this.reparseFileLine;
                                newLexer.virtualOffset = this.virtualOffset;
                            }
                            newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                            newLexer.kind = 2;
                            this.lS.push(newLexer);
                            newLexer.preprocessingType = 3;
                            newLexer.preprocessingLine = this.getLine();
                            newLexer.preprocessingFile = this.getFilename();
                            if (this.lS.containsSkipDefine(this) && !this.skipElseBranch) {
                                this.util.debug("Lexing `else");
                                if (this.lS.fSkipDefine.size() == 1 && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), this.getLine(), this.getColumn());
                                }
                            } else {
                                this.util.debug("Skipping `else ");
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineSkip(this.lS.getCurrentFileInstance(), this.getLine(), this.getColumn());
                                }
                                this.lS.addSkipDefine(newLexer);
                            }
                            this.lS.removeSkipDefine(this);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mENDIF_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block35: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block34: {
                _token = null;
                _begin = this.text.length();
                _ttype = 597;
                userMark = null;
                finalRunnable = null;
                Token dsl = null;
                String name = null;
                int line = 0;
                int offset = this.getOffset();
                try {
                    try {
                        this.match('`');
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            this.mDEFINE_WS(false);
                        }
                        this.match("endif");
                        if (this.inputState.guessing() == 0) {
                            try {
                                line = this.getLine();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        boolean synPredMatched702 = false;
                        if (_tokenSet_55.member((int)this.LA(1))) {
                            int _m702 = this.mark();
                            synPredMatched702 = true;
                            this.inputState.incGuessing();
                            try {
                                while (_tokenSet_13.member((int)this.LA(1))) {
                                    this.mDEFINE_WS(false);
                                }
                                this.match("//");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched702 = false;
                            }
                            this.rewind(_m702);
                            this.inputState.decGuessing(synPredMatched702);
                        }
                        if (synPredMatched702) {
                            while (_tokenSet_13.member((int)this.LA(1))) {
                                this.mDEFINE_WS(false);
                            }
                            this.mENDIF_SL_COMMENT(true);
                            dsl = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    name = dsl.getText().trim();
                                    name = name.replaceFirst("(`)?if(n)?def\\s+", "");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        }
                        if (this.inputState.guessing() != 0) break block34;
                        try {
                            if (this.lS.peek().preprocessingType != 1 && this.lS.peek().preprocessingType != 2 && this.lS.peek().preprocessingType != 3) {
                                this.reportError("*** Error: ", this.getFilename(), this.getLine(), offset, 6, "Unexpected `endif (no starting `ifdef/`ifndef found)");
                            } else {
                                VlogMacroInfo macro;
                                if (dsl != null && this.ifdefID != null && name != null && this.isID(name) && !name.equals(this.ifdefID)) {
                                    this.util.reportError("*** Warning: ", this.getFilename(), this.getLanguageSyntax(), this.getLine() - 1, dsl.getOffset(), dsl.getLength(), "Expecting `endif label '" + this.ifdefID + "' found '" + name + "'", this.fileIndex, null);
                                }
                                if (this.ifdefID != null && (macro = this.util.getDefine(this.ifdefID, false)) != null) {
                                    if (!this.ifndefGuard && macro.isIfndefGuard()) {
                                        macro.setDefinedConfigMacro();
                                    } else if (this.ifndefGuard && macro.isReplacementMacro() && !macro.hasReplacement()) {
                                        macro.setIfndefGuard();
                                    } else if (macro.isReplacementMacro()) {
                                        macro.setDefinedConfigMacro();
                                    }
                                }
                                int tmp = this.lS.peek().reparseFileLine;
                                this.lS.pop(true);
                                this.lS.peek().reparseFileLine = tmp;
                                this.lS.removeSkipDefine(this);
                                if (!this.lS.isSkip() && !this.lS.isMacroReparsing()) {
                                    this.util.setCodePreprocLineEnter(this.lS.getCurrentFileInstance(), line, this.getColumn());
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mLINE_DEF(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block17: {
            _token = null;
            _begin = this.text.length();
            _ttype = 598;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    this.match('`');
                    while (_tokenSet_13.member((int)this.LA(1))) {
                        this.mDEFINE_WS(false);
                    }
                    this.match("line");
                    int _cnt709 = 0;
                    while (true) {
                        if (!_tokenSet_18.member((int)this.LA(1))) {
                            if (_cnt709 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.mDEFINE_WS_NL_OR_COMMENT(false);
                        ++_cnt709;
                    }
                    this.mLINE_NUMBER(true);
                    int _cnt711 = 0;
                    while (true) {
                        if (!_tokenSet_18.member((int)this.LA(1))) {
                            if (_cnt711 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.mDEFINE_WS_NL_OR_COMMENT(false);
                        ++_cnt711;
                    }
                    this.match('\"');
                    this.mFILE_NAME(true);
                    this.match('\"');
                    int _cnt713 = 0;
                    while (true) {
                        if (!_tokenSet_18.member((int)this.LA(1))) {
                            if (_cnt713 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.mDEFINE_WS_NL_OR_COMMENT(false);
                        ++_cnt713;
                    }
                    this.mDECIMAL_DIGIT(false);
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    /*
     * Loose catch block
     */
    protected final void mBEGIN_KEYWORDS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block30: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block28: {
                Token str;
                block29: {
                    _token = null;
                    _begin = this.text.length();
                    _ttype = 608;
                    userMark = null;
                    finalRunnable = null;
                    str = null;
                    this.match('`');
                    while (_tokenSet_13.member((int)this.LA(1))) {
                        this.mDEFINE_WS(false);
                    }
                    this.match("begin_keywords");
                    int _cnt797 = 0;
                    while (true) {
                        if (!_tokenSet_18.member((int)this.LA(1))) {
                            if (_cnt797 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.mDEFINE_WS_NL_OR_COMMENT(false);
                        ++_cnt797;
                    }
                    this.mSTRING(true);
                    str = this._returnToken;
                    if (this.inputState.guessing() != 0) break block28;
                    if (!this.lS.isSkip()) break block29;
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    return;
                }
                try {
                    try {
                        String keywordsSpecifier = str.getText();
                        if (keywordsSpecifier.equals("\"1364-2001\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"1364-1995-IUS\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"1364-1995\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"1364-2005\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2005);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"1364-2001-noconfig\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"1800-2005\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2005);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"1800-2009\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"1800-2012\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2012);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"1800-2023\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2023);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"VAMS-2.3\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23);
                            break block28;
                        }
                        if (keywordsSpecifier.equals("\"SVVAMS\"")) {
                            this.util.fCurrentLanguageSyntax.push(IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_AMS);
                            break block28;
                        }
                        this.reportError("*** Error: ", this.getFilename(), str.getLine(), str.getOffset(), str.getLength(), "Unsupported keywords version specifier: \"" + keywordsSpecifier + "\"");
                        {
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mEND_KEYWORDS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 609;
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("end_keywords");
        if (this.inputState.guessing() == 0) {
            try {
                if (this.lS.isSkip()) {
                    return;
                }
                if (this.util.fCurrentLanguageSyntax.isEmpty()) {
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), this.getOffset() - 12, 12, "Unmatched `begin_keywords directive in compilation unit");
                } else {
                    this.util.fCurrentLanguageSyntax.pop();
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final String mDEFAULT_NETTYPE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        String nettype;
        block95: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block94: {
                nettype = "__wire";
                _token = null;
                _begin = this.text.length();
                _ttype = 600;
                userMark = null;
                finalRunnable = null;
                Token id = null;
                try {
                    try {
                        int _saveIndex = this.text.length();
                        this.match('`');
                        this.text.setLength(_saveIndex);
                        while (_tokenSet_13.member((int)this.LA(1))) {
                            _saveIndex = this.text.length();
                            this.mDEFINE_WS(false);
                            this.text.setLength(_saveIndex);
                        }
                        _saveIndex = this.text.length();
                        this.match("default_nettype");
                        this.text.setLength(_saveIndex);
                        int _cnt721 = 0;
                        while (true) {
                            if (!_tokenSet_18.member((int)this.LA(1))) {
                                if (_cnt721 >= 1) break;
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            _saveIndex = this.text.length();
                            this.mDEFINE_WS_NL_OR_COMMENT(false);
                            this.text.setLength(_saveIndex);
                            ++_cnt721;
                        }
                        boolean synPredMatched724 = false;
                        if (this.LA(1) == 'w' && this.LA(2) == 'i' && this.LA(3) == 'r') {
                            int _m724 = this.mark();
                            synPredMatched724 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("wire");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched724 = false;
                            }
                            this.rewind(_m724);
                            this.inputState.decGuessing(synPredMatched724);
                        }
                        if (synPredMatched724) {
                            this.match("wire");
                            if (this.inputState.guessing() == 0) {
                                try {
                                    nettype = "__wire";
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else {
                            boolean synPredMatched726 = false;
                            if (this.LA(1) == 'w' && this.LA(2) == 'a' && this.LA(3) == 'n') {
                                int _m726 = this.mark();
                                synPredMatched726 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match("wand");
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched726 = false;
                                }
                                this.rewind(_m726);
                                this.inputState.decGuessing(synPredMatched726);
                            }
                            if (synPredMatched726) {
                                this.match("wand");
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        nettype = "__wand";
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                boolean synPredMatched728 = false;
                                if (this.LA(1) == 'w' && this.LA(2) == 'o' && this.LA(3) == 'r') {
                                    int _m728 = this.mark();
                                    synPredMatched728 = true;
                                    this.inputState.incGuessing();
                                    try {
                                        this.match("wor");
                                    }
                                    catch (RecognitionException recognitionException) {
                                        synPredMatched728 = false;
                                    }
                                    this.rewind(_m728);
                                    this.inputState.decGuessing(synPredMatched728);
                                }
                                if (synPredMatched728) {
                                    this.match("wor");
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            nettype = "__wor";
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                } else {
                                    boolean synPredMatched730 = false;
                                    if (this.LA(1) == 't' && this.LA(2) == 'r' && this.LA(3) == 'i') {
                                        int _m730 = this.mark();
                                        synPredMatched730 = true;
                                        this.inputState.incGuessing();
                                        try {
                                            this.match("tri0");
                                        }
                                        catch (RecognitionException recognitionException) {
                                            synPredMatched730 = false;
                                        }
                                        this.rewind(_m730);
                                        this.inputState.decGuessing(synPredMatched730);
                                    }
                                    if (synPredMatched730) {
                                        this.match("tri0");
                                        if (this.inputState.guessing() == 0) {
                                            try {
                                                nettype = "__tri0";
                                            }
                                            catch (Exception ex) {
                                                this.userExceptionHandler(ex);
                                            }
                                        }
                                    } else {
                                        boolean synPredMatched732 = false;
                                        if (this.LA(1) == 't' && this.LA(2) == 'r' && this.LA(3) == 'i') {
                                            int _m732 = this.mark();
                                            synPredMatched732 = true;
                                            this.inputState.incGuessing();
                                            try {
                                                this.match("tri1");
                                            }
                                            catch (RecognitionException recognitionException) {
                                                synPredMatched732 = false;
                                            }
                                            this.rewind(_m732);
                                            this.inputState.decGuessing(synPredMatched732);
                                        }
                                        if (synPredMatched732) {
                                            this.match("tri1");
                                            if (this.inputState.guessing() == 0) {
                                                try {
                                                    nettype = "__tri1";
                                                }
                                                catch (Exception ex) {
                                                    this.userExceptionHandler(ex);
                                                }
                                            }
                                        } else {
                                            boolean synPredMatched734 = false;
                                            if (this.LA(1) == 't' && this.LA(2) == 'r' && this.LA(3) == 'i') {
                                                int _m734 = this.mark();
                                                synPredMatched734 = true;
                                                this.inputState.incGuessing();
                                                try {
                                                    this.match("triand");
                                                }
                                                catch (RecognitionException recognitionException) {
                                                    synPredMatched734 = false;
                                                }
                                                this.rewind(_m734);
                                                this.inputState.decGuessing(synPredMatched734);
                                            }
                                            if (synPredMatched734) {
                                                this.match("triand");
                                                if (this.inputState.guessing() == 0) {
                                                    try {
                                                        nettype = "__triand";
                                                    }
                                                    catch (Exception ex) {
                                                        this.userExceptionHandler(ex);
                                                    }
                                                }
                                            } else {
                                                boolean synPredMatched736 = false;
                                                if (this.LA(1) == 't' && this.LA(2) == 'r' && this.LA(3) == 'i') {
                                                    int _m736 = this.mark();
                                                    synPredMatched736 = true;
                                                    this.inputState.incGuessing();
                                                    try {
                                                        this.match("trior");
                                                    }
                                                    catch (RecognitionException recognitionException) {
                                                        synPredMatched736 = false;
                                                    }
                                                    this.rewind(_m736);
                                                    this.inputState.decGuessing(synPredMatched736);
                                                }
                                                if (synPredMatched736) {
                                                    this.match("trior");
                                                    if (this.inputState.guessing() == 0) {
                                                        try {
                                                            nettype = "__trior";
                                                        }
                                                        catch (Exception ex) {
                                                            this.userExceptionHandler(ex);
                                                        }
                                                    }
                                                } else {
                                                    boolean synPredMatched738 = false;
                                                    if (this.LA(1) == 't' && this.LA(2) == 'r' && this.LA(3) == 'i') {
                                                        int _m738 = this.mark();
                                                        synPredMatched738 = true;
                                                        this.inputState.incGuessing();
                                                        try {
                                                            this.match("trireg");
                                                        }
                                                        catch (RecognitionException recognitionException) {
                                                            synPredMatched738 = false;
                                                        }
                                                        this.rewind(_m738);
                                                        this.inputState.decGuessing(synPredMatched738);
                                                    }
                                                    if (synPredMatched738) {
                                                        this.match("trireg");
                                                        if (this.inputState.guessing() == 0) {
                                                            try {
                                                                nettype = "__trireg";
                                                            }
                                                            catch (Exception ex) {
                                                                this.userExceptionHandler(ex);
                                                            }
                                                        }
                                                    } else {
                                                        boolean synPredMatched740 = false;
                                                        if (this.LA(1) == 't' && this.LA(2) == 'r' && this.LA(3) == 'i') {
                                                            int _m740 = this.mark();
                                                            synPredMatched740 = true;
                                                            this.inputState.incGuessing();
                                                            try {
                                                                this.match("tri");
                                                            }
                                                            catch (RecognitionException recognitionException) {
                                                                synPredMatched740 = false;
                                                            }
                                                            this.rewind(_m740);
                                                            this.inputState.decGuessing(synPredMatched740);
                                                        }
                                                        if (synPredMatched740) {
                                                            this.match("tri");
                                                            if (this.inputState.guessing() == 0) {
                                                                try {
                                                                    nettype = "__tri";
                                                                }
                                                                catch (Exception ex) {
                                                                    this.userExceptionHandler(ex);
                                                                }
                                                            }
                                                        } else if (_tokenSet_15.member((int)this.LA(1))) {
                                                            this.mID(true);
                                                            id = this._returnToken;
                                                            if (this.inputState.guessing() == 0) {
                                                                try {
                                                                    nettype = "__none";
                                                                    if (!id.getText().equals("none")) {
                                                                        this.reportError("*** Error: ", this.getFilename(), id.getLine(), id.getOffset(), id.getLength(), "Unexpected token '" + id.getText() + "'");
                                                                    }
                                                                }
                                                                catch (Exception ex) {
                                                                    this.userExceptionHandler(ex);
                                                                }
                                                            }
                                                        } else {
                                                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if (this.inputState.guessing() != 0) break block94;
                        try {
                            if (!this.lS.isSkip()) {
                                this.util.addDefaultNettype(this.getLine(), this.getText());
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block95;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return nettype;
    }

    /*
     * Loose catch block
     */
    protected final void mPRAGMA(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block24: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block22: {
                block23: {
                    _token = null;
                    _begin = this.text.length();
                    _ttype = 610;
                    userMark = null;
                    finalRunnable = null;
                    int _saveIndex = this.text.length();
                    this.match('`');
                    this.text.setLength(_saveIndex);
                    while (_tokenSet_13.member((int)this.LA(1))) {
                        _saveIndex = this.text.length();
                        this.mDEFINE_WS(false);
                        this.text.setLength(_saveIndex);
                    }
                    _saveIndex = this.text.length();
                    this.match("pragma");
                    this.text.setLength(_saveIndex);
                    _saveIndex = this.text.length();
                    this.mWS(false);
                    this.text.setLength(_saveIndex);
                    this.mINTERNAL_ID_1(false);
                    if (_tokenSet_22.member((int)this.LA(1))) {
                        this.mWS(false);
                    }
                    boolean synPredMatched807 = false;
                    if (_tokenSet_59.member((int)this.LA(1))) {
                        int _m807 = this.mark();
                        synPredMatched807 = true;
                        this.inputState.incGuessing();
                        try {
                            this.mPRAGMA_EXPRESSION(false, false);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched807 = false;
                        }
                        this.rewind(_m807);
                        this.inputState.decGuessing(synPredMatched807);
                    }
                    if (synPredMatched807) {
                        this.mPRAGMA_EXPRESSION(false, false);
                        if (_tokenSet_22.member((int)this.LA(1))) {
                            this.mWS(false);
                        }
                        this.mPRAGMA_EXPRESSION_LIST(false);
                    }
                    if (this.inputState.guessing() != 0) break block22;
                    if (!this.lS.isSkip()) break block23;
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    return;
                }
                try {
                    try {
                        if (this.isEncrypted) {
                            this.util.setEncryptedFile(this.getFilename(), true);
                            this.grabEncryptedData();
                        }
                        _ttype = -1;
                        {
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPROTECT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 616;
        int line = this.getLine();
        int offset = this.getOffset();
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("protect");
        if (this.inputState.guessing() == 0) {
            try {
                if (this.lS.isSkip()) {
                    return;
                }
                if (this.util.isSkipProtectedCode()) {
                    this.grabProtectedData("`endprotect");
                } else {
                    this.util.addEncryptedPragma(this.parserPath, EncryptedPragmaInfo.EncryptedPragmaKind.START_PROTECT, line, offset, this.getOffset() - offset);
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPROTECTED(boolean _createToken, boolean addCodePreprocInfo) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 617;
        StringBuilder sb = new StringBuilder();
        int _saveIndex = this.text.length();
        this.match('`');
        this.text.setLength(_saveIndex);
        while (_tokenSet_13.member((int)this.LA(1))) {
            _saveIndex = this.text.length();
            this.mDEFINE_WS(false);
            this.text.setLength(_saveIndex);
        }
        this.match("protected");
        while (this.LA(1) >= '0' && this.LA(1) <= '9') {
            if (this.inputState.guessing() == 0) {
                try {
                    sb.append(this.LA(1));
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
            this.matchRange('0', '9');
        }
        if (this.inputState.guessing() == 0) {
            try {
                if (this.lS.isSkip()) {
                    return;
                }
                if (addCodePreprocInfo) {
                    this.util.setEncryptedCodeLineSkip(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                }
                this.util.setEncryptedFile(this.getFilename(), true);
                this.grabProtectedData("`endprotected" + sb.toString());
                if (addCodePreprocInfo) {
                    this.util.setEncryptedCodeLineEnter(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPROTECTED_IP(boolean _createToken, boolean addCodePreprocInfo) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 618;
        StringBuilder sb = new StringBuilder();
        int _saveIndex = this.text.length();
        this.match('`');
        this.text.setLength(_saveIndex);
        while (_tokenSet_13.member((int)this.LA(1))) {
            _saveIndex = this.text.length();
            this.mDEFINE_WS(false);
            this.text.setLength(_saveIndex);
        }
        this.match("protected_ip");
        block11: while (true) {
            switch (this.LA(1)) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    if (this.inputState.guessing() == 0) {
                        try {
                            sb.append(this.LA(1));
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.matchRange('a', 'z');
                    continue block11;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    this.matchRange('A', 'Z');
                    continue block11;
                }
                case '_': {
                    this.match('_');
                    continue block11;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.matchRange('0', '9');
                    continue block11;
                }
            }
            break;
        }
        if (this.inputState.guessing() == 0) {
            try {
                if (this.lS.isSkip()) {
                    return;
                }
                if (addCodePreprocInfo) {
                    this.util.setEncryptedCodeLineSkip(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                }
                this.util.setEncryptedFile(this.getFilename(), true);
                this.grabProtectedData("`endprotected_ip" + sb.toString());
                if (addCodePreprocInfo) {
                    this.util.setEncryptedCodeLineSkip(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mENDPROTECT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 619;
        int line = this.getLine();
        int offset = this.getOffset();
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("endprotect");
        if (this.inputState.guessing() == 0) {
            try {
                if (!this.lS.isSkip()) {
                    this.util.addEncryptedPragma(this.parserPath, EncryptedPragmaInfo.EncryptedPragmaKind.END_PROTECT, line, offset, this.getOffset() - offset);
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mENDPROTECTED(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 620;
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("endprotected");
        while (this.LA(1) >= '0' && this.LA(1) <= '9') {
            this.matchRange('0', '9');
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mENDPROTECTED_IP(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 621;
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("endprotected_ip");
        while (this.LA(1) >= '0' && this.LA(1) <= '9') {
            this.matchRange('0', '9');
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFAULT_DECAY_TIME(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block18: {
            _token = null;
            _begin = this.text.length();
            _ttype = 622;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    this.match('`');
                    while (_tokenSet_13.member((int)this.LA(1))) {
                        this.mDEFINE_WS(false);
                    }
                    this.match("default_decay_time");
                    int _cnt885 = 0;
                    while (true) {
                        if (!_tokenSet_18.member((int)this.LA(1))) {
                            if (_cnt885 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.mDEFINE_WS_NL_OR_COMMENT(false);
                        ++_cnt885;
                    }
                    switch (this.LA(1)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.mLINE_NUMBER(false);
                            if (this.LA(1) == '.') {
                                this.match('.');
                                this.mLINE_NUMBER(false);
                            }
                            break;
                        }
                        case 'i': {
                            this.match("infinite");
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mUSELIB(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 624;
        this.match('`');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
        }
        this.match("uselib");
        if (this.inputState.guessing() == 0) {
            try {
                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), this.getLine(), this.getOffset() - 6, 6, VlogUtil.getNonStandardMessage(RfNonStandardProblem.USELIB_DIRECTIVE, new Object[0]));
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        this.mUSELIB_BODY(false);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mWORKLIB(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block16: {
            _token = null;
            _begin = this.text.length();
            _ttype = 634;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            this.getOffset();
            this.getLine();
            try {
                try {
                    int _saveIndex = this.text.length();
                    this.match('`');
                    this.text.setLength(_saveIndex);
                    while (_tokenSet_13.member((int)this.LA(1))) {
                        _saveIndex = this.text.length();
                        this.mDEFINE_WS(false);
                        this.text.setLength(_saveIndex);
                    }
                    _saveIndex = this.text.length();
                    this.match("worklib");
                    this.text.setLength(_saveIndex);
                    int _cnt936 = 0;
                    while (true) {
                        if (!_tokenSet_55.member((int)this.LA(1))) {
                            if (_cnt936 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        _saveIndex = this.text.length();
                        this.mDEFINE_WS_OR_COMMENT(false);
                        this.text.setLength(_saveIndex);
                        ++_cnt936;
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.getLine();
                            this.getOffset();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.mDEFINE_ID(true, false, false);
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNOWORKLIB(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block11: {
            _token = null;
            _begin = this.text.length();
            _ttype = 635;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    int _saveIndex = this.text.length();
                    this.match('`');
                    this.text.setLength(_saveIndex);
                    while (_tokenSet_13.member((int)this.LA(1))) {
                        _saveIndex = this.text.length();
                        this.mDEFINE_WS(false);
                        this.text.setLength(_saveIndex);
                    }
                    _saveIndex = this.text.length();
                    this.match("noworklib");
                    this.text.setLength(_saveIndex);
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mREPLACE_MACRO_STRING(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block37: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block36: {
                _token = null;
                _begin = this.text.length();
                _ttype = 588;
                userMark = null;
                finalRunnable = null;
                boolean error = false;
                try {
                    try {
                        int _saveIndex = this.text.length();
                        this.match("`\"");
                        this.text.setLength(_saveIndex);
                        while (true) {
                            boolean synPredMatched600 = false;
                            if (this.LA(1) == '`' && _tokenSet_60.member((int)this.LA(2)) && _tokenSet_7.member((int)this.LA(3))) {
                                int _m600 = this.mark();
                                synPredMatched600 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match('`');
                                    this.match(_tokenSet_60);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched600 = false;
                                }
                                this.rewind(_m600);
                                this.inputState.decGuessing(synPredMatched600);
                            }
                            if (synPredMatched600) {
                                this.match('`');
                                this.match(_tokenSet_60);
                                continue;
                            }
                            boolean synPredMatched603 = false;
                            if (this.LA(1) == '`' && this.LA(2) == '\\' && this.LA(3) == '`') {
                                int _m603 = this.mark();
                                synPredMatched603 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match("`\\`\"");
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched603 = false;
                                }
                                this.rewind(_m603);
                                this.inputState.decGuessing(synPredMatched603);
                            }
                            if (synPredMatched603) {
                                this.match("`\\`\"");
                                continue;
                            }
                            boolean synPredMatched605 = false;
                            if (this.LA(1) == '`' && this.LA(2) == '`' && _tokenSet_7.member((int)this.LA(3))) {
                                int _m605 = this.mark();
                                synPredMatched605 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match("``");
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched605 = false;
                                }
                                this.rewind(_m605);
                                this.inputState.decGuessing(synPredMatched605);
                            }
                            if (synPredMatched605) {
                                this.match("``");
                                continue;
                            }
                            boolean synPredMatched607 = false;
                            if (this.LA(1) == '\\' && this.LA(2) == '\"' && _tokenSet_7.member((int)this.LA(3))) {
                                int _m607 = this.mark();
                                synPredMatched607 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match('\\');
                                    this.match('\"');
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched607 = false;
                                }
                                this.rewind(_m607);
                                this.inputState.decGuessing(synPredMatched607);
                            }
                            if (synPredMatched607) {
                                this.match('\\');
                                this.match('\"');
                                continue;
                            }
                            if (this.LA(1) == '\\' && _tokenSet_22.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                                this.mSTRING_NEWLINE(false);
                                continue;
                            }
                            if (!_tokenSet_61.member((int)this.LA(1)) || !_tokenSet_7.member((int)this.LA(2))) break;
                            this.match(_tokenSet_61);
                        }
                        switch (this.LA(1)) {
                            case '\"': {
                                _saveIndex = this.text.length();
                                this.match('\"');
                                this.text.setLength(_saveIndex);
                                break;
                            }
                            case '`': {
                                _saveIndex = this.text.length();
                                this.match("`\"");
                                this.text.setLength(_saveIndex);
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (this.inputState.guessing() != 0) break block36;
                        try {
                            try {
                                String input;
                                String replacement;
                                if (!error && !this.lS.isSkip() && (replacement = this.util.getMacroString(input = new String(this.text.getBuffer(), _begin, this.text.length() - _begin), this.util.getToolCompat(), this.lS)) != null) {
                                    replacement = "\"" + this.removeComments(replacement).trim() + "\"";
                                    this.text.setLength(_begin);
                                    this.text.append(replacement);
                                }
                            }
                            catch (VlogException vlogException) {
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_ID(boolean _createToken, boolean reportWarning, boolean doIndex) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block18: {
            _token = null;
            _begin = this.text.length();
            _ttype = 573;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            Token id = null;
            int column = this.getColumn();
            int line = this.getLine();
            try {
                try {
                    switch (this.LA(1)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': 
                        case '_': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.mINTERNAL_ID_2(true, reportWarning);
                            id = this._returnToken;
                            if (this.inputState.guessing() != 0) break;
                            try {
                                String identifier = id.getText();
                                if (!this.isMacroReparsing() && this.indexer != null) {
                                    this.indexer.index2(identifier, line, column, 542, true, this.lS.isSkip(), doIndex);
                                }
                                if (reportWarning && (identifier.startsWith("O_") || identifier.startsWith("I_") || identifier.startsWith("l_") || identifier.endsWith("_O") || identifier.endsWith("_I") || identifier.endsWith("_l"))) {
                                    this.notAllowed(9);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case '\\': {
                            this.mESCAPED_ID(false);
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        _ttype = this.testLiteralsTable(new String(this.text.getBuffer(), _begin, this.text.length() - _begin), _ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_WS_OPT(boolean _createToken, StringBuilder result) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 566;
        result.delete(0, result.length());
        block14: while (true) {
            switch (this.LA(1)) {
                case ' ': {
                    this.match(' ');
                    if (this.inputState.guessing() != 0) continue block14;
                    try {
                        result.append(' ');
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue block14;
                }
                case '\t': {
                    this.match('\t');
                    if (this.inputState.guessing() != 0) continue block14;
                    try {
                        result.append('\t');
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue block14;
                }
                case '\f': {
                    this.match('\f');
                    if (this.inputState.guessing() != 0) continue block14;
                    try {
                        result.append('\f');
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue block14;
                }
                case '\u00a0': {
                    this.match('\u00a0');
                    if (this.inputState.guessing() != 0) continue block14;
                    try {
                        result.append(' ');
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue block14;
                }
            }
            break;
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final List<VlogMacroParameter> mDEFINE_MACRO_PARAM(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        ArrayList<VlogMacroParameter> parameters;
        block40: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block39: {
                parameters = null;
                _token = null;
                _begin = this.text.length();
                _ttype = 568;
                userMark = null;
                finalRunnable = null;
                Token id1 = null;
                Token dv1 = null;
                Token id2 = null;
                Token dv2 = null;
                VlogMacroParameter parameter = null;
                try {
                    try {
                        if (this.LA(1) != '(' || !_tokenSet_62.member((int)this.LA(2)) || this.LA(3) < '\u0000' || this.LA(3) > '\ufffe') break block39;
                        int _saveIndex = this.text.length();
                        this.mLPAREN(false);
                        this.text.setLength(_saveIndex);
                        while (_tokenSet_18.member((int)this.LA(1))) {
                            _saveIndex = this.text.length();
                            this.mDEFINE_WS_NL_OR_COMMENT(false);
                            this.text.setLength(_saveIndex);
                        }
                        this.mDEFINE_ID(true, false, false);
                        id1 = this._returnToken;
                        if (this.inputState.guessing() == 0) {
                            try {
                                parameter = new VlogMacroParameter(id1.getText());
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        while (_tokenSet_18.member((int)this.LA(1))) {
                            _saveIndex = this.text.length();
                            this.mDEFINE_WS_NL_OR_COMMENT(false);
                            this.text.setLength(_saveIndex);
                        }
                        switch (this.LA(1)) {
                            case '=': {
                                this.mDEFAULT_VALUE(true);
                                dv1 = this._returnToken;
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    if (parameter == null) break;
                                    parameter.setValue(dv1.getText().trim());
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case ')': 
                            case ',': {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (parameters == null) {
                                    parameters = new ArrayList<VlogMacroParameter>();
                                }
                                parameters.add(parameter);
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        while (this.LA(1) == ',') {
                            this.mCOMMA(false);
                            while (_tokenSet_18.member((int)this.LA(1))) {
                                _saveIndex = this.text.length();
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                                this.text.setLength(_saveIndex);
                            }
                            this.mDEFINE_ID(true, false, false);
                            id2 = this._returnToken;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    parameter = new VlogMacroParameter(id2.getText());
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            while (_tokenSet_18.member((int)this.LA(1))) {
                                _saveIndex = this.text.length();
                                this.mDEFINE_WS_NL_OR_COMMENT(false);
                                this.text.setLength(_saveIndex);
                            }
                            switch (this.LA(1)) {
                                case '=': {
                                    this.mDEFAULT_VALUE(true);
                                    dv2 = this._returnToken;
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        if (parameter == null) break;
                                        parameter.setValue(dv2.getText().trim());
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case ')': 
                                case ',': {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                }
                            }
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                if (parameters == null) {
                                    parameters = new ArrayList();
                                }
                                parameters.add(parameter);
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        _saveIndex = this.text.length();
                        this.mRPAREN(false);
                        this.text.setLength(_saveIndex);
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return parameters;
    }

    protected final void mDEFAULT_VALUE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block13: {
            _token = null;
            _begin = this.text.length();
            _ttype = 569;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    int _saveIndex = this.text.length();
                    this.mEQ(false);
                    this.text.setLength(_saveIndex);
                    while (true) {
                        if (this.LA(1) == '(' || this.LA(1) == '[' || this.LA(1) == '{') {
                            this.mNESTED_DEFAULT_TEXT(false);
                            continue;
                        }
                        if (_tokenSet_63.member((int)this.LA(1))) {
                            this.mNO_NESTED_DEFAULT_NO_COMMA_TEXT(false);
                            continue;
                        }
                        break;
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNESTED_DEFAULT_TEXT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block21: {
            _token = null;
            _begin = this.text.length();
            _ttype = 570;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    switch (this.LA(1)) {
                        case '(': {
                            this.match('(');
                            while (true) {
                                if (this.LA(1) == '(' || this.LA(1) == '[' || this.LA(1) == '{') {
                                    this.mNESTED_DEFAULT_TEXT(false);
                                    continue;
                                }
                                if (!_tokenSet_64.member((int)this.LA(1))) break;
                                this.mNO_NESTED_DEFAULT_TEXT(false);
                            }
                            this.match(')');
                            break;
                        }
                        case '{': {
                            this.match('{');
                            while (true) {
                                if (this.LA(1) == '(' || this.LA(1) == '[' || this.LA(1) == '{') {
                                    this.mNESTED_DEFAULT_TEXT(false);
                                    continue;
                                }
                                if (!_tokenSet_64.member((int)this.LA(1))) break;
                                this.mNO_NESTED_DEFAULT_TEXT(false);
                            }
                            this.match('}');
                            break;
                        }
                        case '[': {
                            this.match('[');
                            while (true) {
                                if (this.LA(1) == '(' || this.LA(1) == '[' || this.LA(1) == '{') {
                                    this.mNESTED_DEFAULT_TEXT(false);
                                    continue;
                                }
                                if (!_tokenSet_64.member((int)this.LA(1))) break;
                                this.mNO_NESTED_DEFAULT_TEXT(false);
                            }
                            this.match(']');
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNO_NESTED_DEFAULT_NO_COMMA_TEXT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block23: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block22: {
                _token = null;
                _begin = this.text.length();
                _ttype = 572;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        boolean synPredMatched501 = false;
                        if (this.LA(1) == '\"' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m501 = this.mark();
                            synPredMatched501 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mSTRING(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched501 = false;
                            }
                            this.rewind(_m501);
                            this.inputState.decGuessing(synPredMatched501);
                        }
                        if (synPredMatched501) {
                            this.mSTRING(false);
                            break block22;
                        }
                        boolean synPredMatched503 = false;
                        if (this.LA(1) == '\\' && _tokenSet_25.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                            int _m503 = this.mark();
                            synPredMatched503 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mESCAPED_ID(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched503 = false;
                            }
                            this.rewind(_m503);
                            this.inputState.decGuessing(synPredMatched503);
                        }
                        if (synPredMatched503) {
                            this.mESCAPED_ID(false);
                            break block22;
                        }
                        boolean synPredMatched505 = false;
                        if (this.LA(1) == '/' && this.LA(2) == '*' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m505 = this.mark();
                            synPredMatched505 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mML_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched505 = false;
                            }
                            this.rewind(_m505);
                            this.inputState.decGuessing(synPredMatched505);
                        }
                        if (synPredMatched505) {
                            int _saveIndex = this.text.length();
                            this.mML_COMMENT(false);
                            this.text.setLength(_saveIndex);
                            break block22;
                        }
                        if (_tokenSet_63.member((int)this.LA(1)) && _tokenSet_65.member((int)this.LA(2))) {
                            this.match(_tokenSet_63);
                            break block22;
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNO_NESTED_DEFAULT_TEXT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block23: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block22: {
                _token = null;
                _begin = this.text.length();
                _ttype = 571;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        boolean synPredMatched493 = false;
                        if (this.LA(1) == '\"' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m493 = this.mark();
                            synPredMatched493 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mSTRING(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched493 = false;
                            }
                            this.rewind(_m493);
                            this.inputState.decGuessing(synPredMatched493);
                        }
                        if (synPredMatched493) {
                            this.mSTRING(false);
                            break block22;
                        }
                        boolean synPredMatched495 = false;
                        if (this.LA(1) == '\\' && _tokenSet_25.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                            int _m495 = this.mark();
                            synPredMatched495 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mESCAPED_ID(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched495 = false;
                            }
                            this.rewind(_m495);
                            this.inputState.decGuessing(synPredMatched495);
                        }
                        if (synPredMatched495) {
                            this.mESCAPED_ID(false);
                            break block22;
                        }
                        boolean synPredMatched497 = false;
                        if (this.LA(1) == '/' && this.LA(2) == '*' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m497 = this.mark();
                            synPredMatched497 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mML_COMMENT(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched497 = false;
                            }
                            this.rewind(_m497);
                            this.inputState.decGuessing(synPredMatched497);
                        }
                        if (synPredMatched497) {
                            int _saveIndex = this.text.length();
                            this.mML_COMMENT(false);
                            this.text.setLength(_saveIndex);
                            break block22;
                        }
                        if (_tokenSet_64.member((int)this.LA(1)) && _tokenSet_7.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            this.match(_tokenSet_64);
                            break block22;
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_WS_OR_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 574;
        switch (this.LA(1)) {
            case '\t': 
            case '\f': 
            case ' ': 
            case '\u00a0': {
                this.mDEFINE_WS(false);
                break;
            }
            case '/': {
                this.mML_COMMENT(false);
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void mDEFINE_MACRO_TEXT(boolean _createToken, List<StringReplace> macroText) throws RecognitionException, CharStreamException, TokenStreamException {
        block107: {
            _token = null;
            _begin = this.text.length();
            _ttype = 586;
            userMark = null;
            finalRunnable = null;
            dms = null;
            mlc = null;
            str = null;
            dme = null;
            eid = null;
            buffer = new StringBuilder();
            commentb = new StringBuilder();
            wss = new StringBuilder();
            removeComment = false;
            preprocNested = 0;
            opt = false;
            inlineComment = true;
            offset = new int[1];
            startLine = new int[1];
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (commentb.length() > 0) {
                            int[] offsets = new int[]{offset[0], VlogLexer.this.getOffset()};
                            String comment = VlogLexer.this.getTrimmedText(commentb.toString(), offsets);
                            String firstIdentifier = VlogLexer.this.getFirstIdentifier(comment);
                            VlogLexer.this.util.collectTaskTag(firstIdentifier, comment, startLine[0], offsets[0], offsets[1], VlogLexer.this.parserPath);
                        }
                    }
                };
            }
            while (true) {
                block105: {
                    try {
                        while (true) {
                            synPredMatched568 = false;
                            if (this.LA(1) == '`' && VlogLexer._tokenSet_41.member((int)this.LA(2)) && VlogLexer._tokenSet_66.member((int)this.LA(3)) && !removeComment) {
                                block104: {
                                    _m568 = this.mark();
                                    synPredMatched568 = true;
                                    this.inputState.incGuessing();
                                    try {
                                        this.match('`');
                                        while (VlogLexer._tokenSet_13.member((int)this.LA(1))) {
                                            this.mDEFINE_WS(false);
                                        }
                                        if (this.LA(1) == 'e' && this.LA(2) == 'n') {
                                            this.match("endif");
                                            break block104;
                                        }
                                        if (this.LA(1) == 'e' && this.LA(2) == 'l') {
                                            this.match("else");
                                            break block104;
                                        }
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                    catch (RecognitionException v0) {
                                        synPredMatched568 = false;
                                    }
                                }
                                this.rewind(_m568);
                                this.inputState.decGuessing(synPredMatched568);
                            }
                            if (!synPredMatched568) break block105;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    userMark = this.userMark();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.match('`');
                            this.mDEFINE_WS_OPT(false, wss);
                            if (this.LA(1) == 'e' && this.LA(2) == 'n') {
                                this.match("endif");
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        opt = true;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else if (this.LA(1) == 'e' && this.LA(2) == 'l') {
                                this.match("else");
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        opt = false;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                if (preprocNested == 0 && this.util.getToolCompat() != IBuildConfigParserConstants.ToolCompat.VCS_VLOGAN && this.util.getToolCompat() != IBuildConfigParserConstants.ToolCompat.QUESTA_VLOG && this.util.getToolCompat() != IBuildConfigParserConstants.ToolCompat.QUESTA_VCOM) {
                                    this.userRewind(userMark);
                                    if (buffer.length() > 0) {
                                        replace = buffer.toString();
                                        macroText.add(this.util.newStringReplace(replace, true));
                                        buffer.delete(0, buffer.length());
                                    }
                                    break;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block107;
                    }
                    catch (Throwable var30_51) {
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        throw var30_51;
                    }
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (opt) {
                            --preprocNested;
                            buffer.append('`').append((CharSequence)wss).append("endif");
                            continue;
                        }
                        buffer.append("`else");
                    }
                    continue;
                }
                synPredMatched574 = false;
                if (this.LA(1) == '`' && VlogLexer._tokenSet_11.member((int)this.LA(2)) && VlogLexer._tokenSet_40.member((int)this.LA(3)) && !removeComment) {
                    block108: {
                        _m574 = this.mark();
                        synPredMatched574 = true;
                        this.inputState.incGuessing();
                        try {
                            this.match('`');
                            while (VlogLexer._tokenSet_13.member((int)this.LA(1))) {
                                this.mDEFINE_WS(false);
                            }
                            if (this.LA(1) == 'i' && this.LA(2) == 'f' && this.LA(3) == 'd') {
                                this.match("ifdef");
                                break block108;
                            }
                            if (this.LA(1) == 'i' && this.LA(2) == 'f' && this.LA(3) == 'n') {
                                this.match("ifndef");
                                break block108;
                            }
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        catch (RecognitionException v1) {
                            synPredMatched574 = false;
                        }
                    }
                    this.rewind(_m574);
                    this.inputState.decGuessing(synPredMatched574);
                }
                if (synPredMatched574) {
                    this.match('`');
                    this.mDEFINE_WS_OPT(false, wss);
                    if (this.LA(1) == 'i' && this.LA(2) == 'f' && this.LA(3) == 'd') {
                        this.match("ifdef");
                        if (this.inputState.guessing() == 0) {
                            try {
                                opt = true;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else if (this.LA(1) == 'i' && this.LA(2) == 'f' && this.LA(3) == 'n') {
                        this.match("ifndef");
                        if (this.inputState.guessing() == 0) {
                            try {
                                opt = false;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    if (this.inputState.guessing() != 0) continue;
                    try {
                        ++preprocNested;
                        if (opt) {
                            buffer.append('`').append((CharSequence)wss).append("ifdef");
                            continue;
                        }
                        buffer.append('`').append((CharSequence)wss).append("ifndef");
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue;
                }
                synPredMatched577 = false;
                if (this.LA(1) == '`' && this.LA(2) == '\"' && VlogLexer._tokenSet_7.member((int)this.LA(3)) && !removeComment) {
                    _m577 = this.mark();
                    synPredMatched577 = true;
                    this.inputState.incGuessing();
                    try {
                        this.mDEFINE_MACRO_STRING(false);
                    }
                    catch (RecognitionException v2) {
                        synPredMatched577 = false;
                    }
                    this.rewind(_m577);
                    this.inputState.decGuessing(synPredMatched577);
                }
                if (synPredMatched577) {
                    this.mDEFINE_MACRO_STRING(true);
                    dms = this._returnToken;
                    if (this.inputState.guessing() != 0) continue;
                    try {
                        buffer.append(dms.getText());
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue;
                }
                synPredMatched579 = false;
                if (this.LA(1) == '/' && this.LA(2) == '*' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && !removeComment) {
                    _m579 = this.mark();
                    synPredMatched579 = true;
                    this.inputState.incGuessing();
                    try {
                        this.match("/*");
                    }
                    catch (RecognitionException v3) {
                        synPredMatched579 = false;
                    }
                    this.rewind(_m579);
                    this.inputState.decGuessing(synPredMatched579);
                }
                if (synPredMatched579) {
                    this.mDEFINE_ML_COMMENT(true);
                    mlc = this._returnToken;
                    if (this.inputState.guessing() != 0) continue;
                    try {
                        if (buffer.length() > 0) {
                            macroText.add(this.util.newStringReplace(buffer.toString(), true));
                            buffer.delete(0, buffer.length());
                        }
                        macroText.add(this.util.newStringReplace(mlc.getText(), false));
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue;
                }
                synPredMatched581 = false;
                if (this.LA(1) == '\"' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && !removeComment) {
                    _m581 = this.mark();
                    synPredMatched581 = true;
                    this.inputState.incGuessing();
                    try {
                        this.mSTRING(false);
                    }
                    catch (RecognitionException v4) {
                        synPredMatched581 = false;
                    }
                    this.rewind(_m581);
                    this.inputState.decGuessing(synPredMatched581);
                }
                if (synPredMatched581) {
                    this.mSTRING(true);
                    str = this._returnToken;
                    if (this.inputState.guessing() != 0) continue;
                    try {
                        if (buffer.length() > 0) {
                            macroText.add(this.util.newStringReplace(buffer.toString(), true));
                            buffer.delete(0, buffer.length());
                        }
                        macroText.add(this.util.newStringReplace(str.getText(), false));
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue;
                }
                synPredMatched583 = false;
                if (this.LA(1) == '\\' && VlogLexer._tokenSet_22.member((int)this.LA(2))) {
                    _m583 = this.mark();
                    synPredMatched583 = true;
                    this.inputState.incGuessing();
                    try {
                        this.mDEFINE_MACRO_ESC(false);
                    }
                    catch (RecognitionException v5) {
                        synPredMatched583 = false;
                    }
                    this.rewind(_m583);
                    this.inputState.decGuessing(synPredMatched583);
                }
                if (synPredMatched583) {
                    this.mDEFINE_MACRO_ESC(true);
                    dme = this._returnToken;
                    if (this.inputState.guessing() != 0) continue;
                    try {
                        if (removeComment) {
                            comment = commentb.toString().trim();
                            if (comment != null && comment.length() > "@DVT_LINTER_WAIVER".length() && comment.startsWith("@DVT_LINTER_WAIVER") && (comment.startsWith("@DVT_LINTER_WAIVER_START") && comment.length() > "@DVT_LINTER_WAIVER_START".length() && Character.isWhitespace(comment.charAt("@DVT_LINTER_WAIVER_START".length())) || comment.startsWith("@DVT_LINTER_WAIVER_END") && (comment.length() == "@DVT_LINTER_WAIVER_END".length() || comment.length() > "@DVT_LINTER_WAIVER_END".length() && Character.isWhitespace(comment.charAt("@DVT_LINTER_WAIVER_END".length()))))) {
                                this.reportError("*** Error: ", this.getFilename(), this.getLine() - 1, -1, -1, "Unsupported waiver pragma inside macro");
                            }
                            if (finalRunnable != null) {
                                finalRunnable.run();
                            }
                            if (comment != null && comment.length() > 0) {
                                this.notAllowed(133);
                            }
                            inlineComment = false;
                            commentb.delete(0, commentb.length());
                        }
                        removeComment = false;
                        buffer.append(dme.getText());
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue;
                }
                synPredMatched585 = false;
                if (this.LA(1) == '\\' && VlogLexer._tokenSet_25.member((int)this.LA(2)) && !removeComment) {
                    _m585 = this.mark();
                    synPredMatched585 = true;
                    this.inputState.incGuessing();
                    try {
                        this.mDEFINE_ESCAPED_ID(false);
                    }
                    catch (RecognitionException v6) {
                        synPredMatched585 = false;
                    }
                    this.rewind(_m585);
                    this.inputState.decGuessing(synPredMatched585);
                }
                if (synPredMatched585) {
                    this.mDEFINE_ESCAPED_ID(true);
                    eid = this._returnToken;
                    if (this.inputState.guessing() != 0) continue;
                    try {
                        buffer.append(eid.getText());
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    continue;
                }
                if (!VlogLexer._tokenSet_7.member((int)this.LA(1))) break;
                this.match(VlogLexer._tokenSet_7);
                if (this.inputState.guessing() != 0) continue;
                try {
                    if (removeComment && (commentb.length() != 0 || this.LA(0) != '/')) {
                        commentb.append(this.LA(0));
                    }
                    if (this.LA(0) == '/' && this.LA(1) == '/') {
                        removeComment = true;
                        offset[0] = this.getOffset() + 1;
                        startLine[0] = this.getLine();
                        continue;
                    }
                    if (removeComment) continue;
                    buffer.append(this.LA(0));
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
            if (this.inputState.guessing() == 0) {
                try {
                    if (buffer.length() > 0) {
                        replace = buffer.toString();
                        macroText.add(this.util.newStringReplace(replace, true));
                        buffer.delete(0, buffer.length());
                    }
                    if (inlineComment && commentb.length() > 0) {
                        rawComment = commentb.toString();
                        this.util.addComment(new Comment(Comment.CommentStyle.SL_KIND, this.getLine(), this.getLine(), rawComment, (DVTLexerStack)this.lS, 2));
                    }
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_REPLACE_PARAMS(boolean _createToken, String macroName) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block14: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block13: {
                _token = null;
                _begin = this.text.length();
                _ttype = 580;
                userMark = null;
                finalRunnable = null;
                if (this.LA(1) != '(') {
                    this._returnToken = this.makeToken(_ttype);
                    return;
                }
                try {
                    try {
                        this.mNESTED(false);
                        if (this.inputState.guessing() != 0) break block13;
                        try {
                            int length = this.text.length();
                            if (_begin + 1 < length && length - _begin - 2 >= 0) {
                                String resultText = new String(this.text.getBuffer(), _begin + 1, length - _begin - 2);
                                this.text.setLength(_begin);
                                this.text.append(resultText);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.reportError("*** Warning: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), "[PARSER_LIMITATION] Incomplete context for macro `" + macroName + "(...) expansion. " + ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mUNDEFINED_MACRO_POSSIBLE_PARAMS(boolean _createToken, String macroName) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 579;
        while (_tokenSet_55.member((int)this.LA(1))) {
            this.mDEFINE_WS_OR_COMMENT(false);
        }
        this.mDEFINE_REPLACE_PARAMS(false, macroName);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNESTED(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 581;
        this.match('(');
        this.mNESTED_TAIL(false);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNESTED_TAIL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 582;
        CharScanner.UserMark userMark = null;
        while (true) {
            if (this.LA(1) == '(') {
                this.mNESTED(false);
                continue;
            }
            if (!_tokenSet_67.member((int)this.LA(1))) break;
            this.mNO_NESTED(false);
        }
        if (this.LA(1) == ')') {
            this.match(')');
        } else if (this.LA(1) == '\uffff' && this.parentLexer != null) {
            if (this.inputState.guessing() == 0) {
                try {
                    this.disableUponEof = true;
                    userMark = this.userMark();
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
            this.match('\uffff');
            if (this.inputState.guessing() == 0) {
                try {
                    this.userRewind(userMark);
                    this.disableUponEof = false;
                    this.parentLexer.mNESTED_TAIL(true);
                    int length = this.text.length();
                    if (length - _begin - 1 >= 0) {
                        String resultText = new String(this.text.getBuffer(), _begin, length - _begin - 1);
                        resultText = String.valueOf(resultText) + this.parentLexer._returnToken.getText();
                        this.text.setLength(_begin);
                        this.text.append(resultText);
                    }
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else {
            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mNO_NESTED(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block39: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block38: {
                _token = null;
                _begin = this.text.length();
                _ttype = 583;
                userMark = null;
                finalRunnable = null;
                try {
                    try {
                        boolean synPredMatched542 = false;
                        if (this.LA(1) == '\"' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                            int _m542 = this.mark();
                            synPredMatched542 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mSTRING(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched542 = false;
                            }
                            this.rewind(_m542);
                            this.inputState.decGuessing(synPredMatched542);
                        }
                        if (synPredMatched542) {
                            this.mSTRING(false);
                            break block38;
                        }
                        boolean synPredMatched544 = false;
                        if (this.LA(1) == '\\' && _tokenSet_25.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                            int _m544 = this.mark();
                            synPredMatched544 = true;
                            this.inputState.incGuessing();
                            try {
                                this.mESCAPED_ID(false);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched544 = false;
                            }
                            this.rewind(_m544);
                            this.inputState.decGuessing(synPredMatched544);
                        }
                        if (synPredMatched544) {
                            this.mESCAPED_ID(false);
                            break block38;
                        }
                        boolean synPredMatched546 = false;
                        if (this.LA(1) == '/' && this.LA(2) == '/' && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff') {
                            int _m546 = this.mark();
                            synPredMatched546 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("//");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched546 = false;
                            }
                            this.rewind(_m546);
                            this.inputState.decGuessing(synPredMatched546);
                        }
                        if (synPredMatched546) {
                            int _saveIndex = this.text.length();
                            this.mDEFINE_SL_COMMENT(false);
                            this.text.setLength(_saveIndex);
                            break block38;
                        }
                        boolean synPredMatched548 = false;
                        if (this.LA(1) == '/' && this.LA(2) == '*' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                            int _m548 = this.mark();
                            synPredMatched548 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match("/*");
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched548 = false;
                            }
                            this.rewind(_m548);
                            this.inputState.decGuessing(synPredMatched548);
                        }
                        if (synPredMatched548) {
                            int _saveIndex = this.text.length();
                            this.mML_COMMENT(false);
                            this.text.setLength(_saveIndex);
                            break block38;
                        }
                        if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) >= '\u0000' && this.LA(3) <= '\uffff' && this.LA(1) == '\r' && this.LA(2) == '\n') {
                            this.match("\r\n");
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.newline();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block38;
                        }
                        if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff') {
                            this.match('\r');
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.newline();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block38;
                        }
                        if (_tokenSet_68.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff') {
                            this.match(_tokenSet_68);
                            break block38;
                        }
                        if (this.LA(1) == '\n') {
                            this.match('\n');
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.newline();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block38;
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_SL_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block20: {
            _token = null;
            _begin = this.text.length();
            _ttype = 584;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    int _saveIndex = this.text.length();
                    this.match("//");
                    this.text.setLength(_saveIndex);
                    while (_tokenSet_7.member((int)this.LA(1))) {
                        this.match(_tokenSet_7);
                    }
                    switch (this.LA(1)) {
                        case '\n': {
                            this.match('\n');
                            break;
                        }
                        case '\r': {
                            this.match('\r');
                            if (this.LA(1) == '\n' && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff') {
                                this.match('\n');
                                break;
                            }
                            if (this.LA(1) >= '\u0000' && this.LA(1) <= '\uffff') break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        case '\uffff': {
                            this.match('\uffff');
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.newline();
                            this.text.setLength(_begin);
                            this.text.append("");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mENDIF_SL_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block19: {
            _token = null;
            _begin = this.text.length();
            _ttype = 585;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    int _saveIndex = this.text.length();
                    this.match("//");
                    this.text.setLength(_saveIndex);
                    while (_tokenSet_7.member((int)this.LA(1))) {
                        this.match(_tokenSet_7);
                    }
                    switch (this.LA(1)) {
                        case '\n': {
                            this.match('\n');
                            break;
                        }
                        case '\r': {
                            this.match('\r');
                            if (this.LA(1) != '\n') break;
                            this.match('\n');
                            break;
                        }
                        case '\uffff': {
                            this.match('\uffff');
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.newline();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_MACRO_STRING(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block32: {
            Runnable finalRunnable;
            CharScanner.UserMark userMark;
            block31: {
                _token = null;
                _begin = this.text.length();
                _ttype = 589;
                userMark = null;
                finalRunnable = null;
                int line = this.getLine();
                int offset = this.getOffset();
                boolean nonStandard = false;
                try {
                    try {
                        this.match("`\"");
                        while (true) {
                            boolean synPredMatched614 = false;
                            if ((this.LA(1) == '\\' || this.LA(1) == '`') && _tokenSet_69.member((int)this.LA(2)) && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                                int _m614 = this.mark();
                                synPredMatched614 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.mDEFINE_MACRO_STRING_ESC(false);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched614 = false;
                                }
                                this.rewind(_m614);
                                this.inputState.decGuessing(synPredMatched614);
                            }
                            if (synPredMatched614) {
                                this.mDEFINE_MACRO_STRING_ESC(false);
                                continue;
                            }
                            boolean synPredMatched616 = false;
                            if (this.LA(1) == '\\' && this.LA(2) == '\"' && _tokenSet_7.member((int)this.LA(3))) {
                                int _m616 = this.mark();
                                synPredMatched616 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match('\\');
                                    this.match('\"');
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched616 = false;
                                }
                                this.rewind(_m616);
                                this.inputState.decGuessing(synPredMatched616);
                            }
                            if (synPredMatched616) {
                                this.match('\\');
                                this.match('\"');
                                continue;
                            }
                            boolean synPredMatched619 = false;
                            if (this.LA(1) == '`' && _tokenSet_60.member((int)this.LA(2)) && _tokenSet_7.member((int)this.LA(3))) {
                                int _m619 = this.mark();
                                synPredMatched619 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match('`');
                                    this.match(_tokenSet_60);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched619 = false;
                                }
                                this.rewind(_m619);
                                this.inputState.decGuessing(synPredMatched619);
                            }
                            if (synPredMatched619) {
                                this.match('`');
                                this.match(_tokenSet_60);
                                continue;
                            }
                            if (!_tokenSet_61.member((int)this.LA(1)) || !_tokenSet_7.member((int)this.LA(2))) break;
                            this.match(_tokenSet_61);
                        }
                        switch (this.LA(1)) {
                            case '\"': {
                                this.match('\"');
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    nonStandard = true;
                                    offset = this.getOffset() - 1;
                                    line = this.getLine();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case '`': {
                                this.match("`\"");
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (this.inputState.guessing() != 0) break block31;
                        try {
                            if (nonStandard) {
                                this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), line, offset, 1, VlogUtil.getNonStandardMessage(RfNonStandardProblem.MACRO_TEXT, new Object[0]));
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() != 0) {
                            throw ex;
                        }
                        this.consume();
                        this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                        this.userRelease(userMark);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_MACRO_ESC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 591;
        int line = -1;
        int offset = -1;
        boolean nonStandard = false;
        int count = 0;
        this.match('\\');
        while (_tokenSet_13.member((int)this.LA(1))) {
            this.mDEFINE_WS(false);
            if (this.inputState.guessing() != 0) continue;
            try {
                nonStandard = true;
                offset = offset == -1 ? this.getOffset() - 1 : offset;
                line = line == -1 ? this.getLine() : line;
                ++count;
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (this.LA(1) == '\r' && this.LA(2) == '\n') {
            this.match("\r\n");
            if (this.inputState.guessing() == 0) {
                try {
                    this.newline();
                    this.text.setLength(_begin);
                    this.text.append("\r\n");
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else if (this.LA(1) == '\r') {
            this.match('\r');
            if (this.inputState.guessing() == 0) {
                try {
                    this.newline();
                    this.text.setLength(_begin);
                    this.text.append("\r");
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else if (this.LA(1) == '\n') {
            this.match('\n');
            if (this.inputState.guessing() == 0) {
                try {
                    this.newline();
                    this.text.setLength(_begin);
                    this.text.append("\n");
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
            }
        } else {
            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        if (this.inputState.guessing() == 0) {
            try {
                if (nonStandard) {
                    this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), line, offset, count, VlogUtil.getNonStandardMessage(RfNonStandardProblem.MACRO_MULTILINE_DELIMITER, new Object[0]));
                }
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_ESCAPED_ID(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block44: {
            _token = null;
            _begin = this.text.length();
            _ttype = 587;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    this.match('\\');
                    int _cnt591 = 0;
                    while (true) {
                        if (!_tokenSet_25.member((int)this.LA(1)) || this.LA(1) == '\\' || this.LA(2) == '\n' && this.LA(2) == '\r' && this.LA(2) == '\t' && this.LA(2) == '\f' && this.LA(2) == ' ' && this.LA(2) == '\uffff') {
                            if (_cnt591 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.match(_tokenSet_25);
                        ++_cnt591;
                    }
                    switch (this.LA(1)) {
                        case '\r': {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    userMark = this.userMark();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.match('\r');
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.userRewind(userMark);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case '\n': {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    userMark = this.userMark();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.match('\n');
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.userRewind(userMark);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case '\uffff': {
                            this.match('\uffff');
                            break;
                        }
                        default: {
                            if (this.LA(1) == ' ') {
                                this.match(' ');
                                break;
                            }
                            if (this.LA(1) == '\t') {
                                this.match('\t');
                                break;
                            }
                            if (this.LA(1) == '\f') {
                                this.match('\f');
                                break;
                            }
                            boolean synPredMatched595 = false;
                            int _m595 = this.mark();
                            synPredMatched595 = true;
                            this.inputState.incGuessing();
                            try {
                                this.match('\\');
                                switch (this.LA(1)) {
                                    case '\n': {
                                        this.match('\n');
                                        break;
                                    }
                                    case '\r': {
                                        this.match('\r');
                                        break;
                                    }
                                    case '\t': {
                                        this.match('\t');
                                        break;
                                    }
                                    case '\f': {
                                        this.match('\f');
                                        break;
                                    }
                                    case ' ': {
                                        this.match(' ');
                                        break;
                                    }
                                    case '\uffff': {
                                        this.match('\uffff');
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                    }
                                }
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched595 = false;
                            }
                            this.rewind(_m595);
                            this.inputState.decGuessing(synPredMatched595);
                            if (synPredMatched595) {
                                if (this.inputState.guessing() == 0) {
                                    // empty if block
                                }
                                break;
                            }
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block44;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFINE_MACRO_STRING_ESC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block43: {
            _token = null;
            _begin = this.text.length();
            _ttype = 590;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            int line = -1;
            int offset = -1;
            boolean nonStandard = false;
            int count = 0;
            try {
                try {
                    switch (this.LA(1)) {
                        case '`': {
                            if (this.LA(1) == '`' && this.LA(2) == '\\') {
                                this.match("`\\`\"");
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        this.text.setLength(_begin);
                                        this.text.append("\\\"");
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                break;
                            }
                            if (this.LA(1) == '`' && this.LA(2) == '`') {
                                this.match("``");
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        this.text.setLength(_begin);
                                        this.text.append("``");
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                break;
                            }
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        case '\\': {
                            this.match('\\');
                            while (_tokenSet_13.member((int)this.LA(1))) {
                                this.mDEFINE_WS(false);
                                if (this.inputState.guessing() != 0) continue;
                                try {
                                    nonStandard = true;
                                    offset = offset == -1 ? this.getOffset() - 1 : offset;
                                    line = line == -1 ? this.getLine() : line;
                                    ++count;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            if (this.LA(1) == '\r' && this.LA(2) == '\n') {
                                this.match("\r\n");
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        this.newline();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else if (this.LA(1) == '\r' && _tokenSet_7.member((int)this.LA(2))) {
                                this.match('\r');
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        this.newline();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else if (this.LA(1) == '\n') {
                                this.match('\n');
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        this.newline();
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (nonStandard) {
                                    this.reportError(VlogUtil.getNonStandardSeverity(), this.getFilename(), line, offset, count, VlogUtil.getNonStandardMessage(RfNonStandardProblem.MACRO_MULTILINE_DELIMITER, new Object[0]));
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block43;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mLINE_NUMBER(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 599;
        int _cnt716 = 0;
        while (true) {
            if (this.LA(1) < '0' || this.LA(1) > '9') {
                if (_cnt716 >= 1) break;
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.mDECIMAL_DIGIT(false);
            ++_cnt716;
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final boolean mTIME_REF(boolean _createToken, StringBuilder timeRefs) throws RecognitionException, CharStreamException, TokenStreamException {
        boolean isTimeprecision = false;
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 603;
        Token id = null;
        Token par = null;
        VlogMacroInfo macro = null;
        String params = null;
        Token old_id = new Token();
        int column = 0;
        int line = 0;
        boolean ws = false;
        switch (this.LA(1)) {
            case '`': {
                this.match('`');
                while (_tokenSet_13.member((int)this.LA(1))) {
                    this.mDEFINE_WS(false);
                }
                this.mDEFINE_ID(true, false, false);
                id = this._returnToken;
                if (this.inputState.guessing() == 0) {
                    try {
                        old_id = id;
                        this.rfp.lintTrackMacroCall(this.parserPath, id.getText());
                        macro = this.util.getDefine(old_id.getText(), false);
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
                if (_tokenSet_57.member((int)this.LA(1)) && this.LA(2) >= '\u0000' && this.LA(2) <= '\uffff' && macro != null && macro.hasParams()) {
                    while (_tokenSet_55.member((int)this.LA(1))) {
                        this.mDEFINE_WS_OR_COMMENT(false);
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            line = this.getLine();
                            column = this.getColumn() + 1;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.mDEFINE_REPLACE_PARAMS(true, macro.getName());
                    par = this._returnToken;
                    if (this.inputState.guessing() == 0) {
                        try {
                            params = par.getText();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else if (macro == null || !macro.hasParams()) {
                    boolean synPredMatched769 = false;
                    int _m769 = this.mark();
                    synPredMatched769 = true;
                    this.inputState.incGuessing();
                    try {
                        while (_tokenSet_55.member((int)this.LA(1))) {
                            this.mDEFINE_WS_OR_COMMENT(false);
                        }
                        this.mLPAREN(false);
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched769 = false;
                    }
                    this.rewind(_m769);
                    this.inputState.decGuessing(synPredMatched769);
                    if (synPredMatched769 && this.inputState.guessing() == 0) {
                        try {
                            boolean bl = macro == null;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                if (this.inputState.guessing() != 0) break;
                try {
                    try {
                        if (this.lS.isSkip()) break;
                        this.dependsOn(old_id.getText(), macro == null ? null : macro.getMacroText());
                        if (macro != null) {
                            int index;
                            String[] parameters = VlogUtil.splitParameters(params, this.util.getToolCompat());
                            parameters = this.util.preprocess(parameters, this.getLine(), this.parserPath, this.indexer);
                            String replacement = macro.getReplacement(this.util, parameters, this.getLine(), this.parserPath);
                            if (!this.lS.isMacroReparsing()) {
                                this.util.setReference(this.lS.getCurrentFileInstance(), old_id.getLine(), this.lS.getLastLine(), old_id.getOffset(), old_id.getText(), parameters, true);
                            }
                            if (this.indexer != null && !this.isMacroReparsing() && params != null) {
                                this.indexer.index2(params, line, column, -1, false, this.lS.isSkip(), false);
                            }
                            if (this.indexer != null && macro != null) {
                                this.indexer.index2(macro.getName(), line, column, -1, false, this.lS.isSkip(), true);
                            }
                            if ((index = (replacement = replacement.trim()).indexOf(47)) == -1) {
                                this.checkTimeRef(id, replacement);
                                break;
                            }
                            String tref = replacement.substring(0, index);
                            int length = tref.length();
                            if (length != (tref = tref.trim()).length()) {
                                this.notAllowed(10);
                            }
                            this.checkTimeRef(id, tref);
                            tref = replacement.substring(index + 1);
                            length = tref.length();
                            tref = tref.trim();
                            if (length != tref.length()) {
                                this.notAllowed(10);
                            }
                            this.checkTimeRef(id, tref);
                            isTimeprecision = true;
                            timeRefs.append(tref);
                            break;
                        }
                        this.checkTimeRef(id, "null");
                    }
                    catch (VlogException e) {
                        this.reportError(e.getSeverity(), this.getFilename(), old_id.getLine(), old_id.getOffset(), old_id.getLength(), e.getMessage());
                    }
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
                break;
            }
            case '1': {
                if (this.LA(1) == '1' && this.LA(2) == '0' && _tokenSet_70.member((int)this.LA(3))) {
                    this.match("10");
                    if (this.inputState.guessing() == 0) {
                        try {
                            timeRefs.append("10");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else if (this.LA(1) == '1' && this.LA(2) == '0' && this.LA(3) == '0') {
                    this.match("100");
                    if (this.inputState.guessing() == 0) {
                        try {
                            timeRefs.append("100");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else if (this.LA(1) == '1' && _tokenSet_70.member((int)this.LA(2))) {
                    this.match("1");
                    if (this.inputState.guessing() == 0) {
                        try {
                            timeRefs.append("1");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                } else {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                if (this.inputState.guessing() == 0) {
                    try {
                        ws = true;
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                }
                while (true) {
                    boolean synPredMatched775 = false;
                    if (_tokenSet_55.member((int)this.LA(1))) {
                        int _m775 = this.mark();
                        synPredMatched775 = true;
                        this.inputState.incGuessing();
                        try {
                            this.mDEFINE_WS_OR_COMMENT(false);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched775 = false;
                        }
                        this.rewind(_m775);
                        this.inputState.decGuessing(synPredMatched775);
                    }
                    if (!synPredMatched775) break;
                    if (this.inputState.guessing() == 0) {
                        try {
                            if (ws) {
                                this.notAllowed(10);
                            }
                            ws = false;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.mDEFINE_WS_OR_COMMENT(false);
                }
                switch (this.LA(1)) {
                    case 's': {
                        this.match("s");
                        if (this.inputState.guessing() != 0) break;
                        try {
                            timeRefs.append("s");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    case 'm': {
                        this.match("ms");
                        if (this.inputState.guessing() != 0) break;
                        try {
                            timeRefs.append("ms");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    case 'u': {
                        this.match("us");
                        if (this.inputState.guessing() != 0) break;
                        try {
                            timeRefs.append("us");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    case 'n': {
                        this.match("ns");
                        if (this.inputState.guessing() != 0) break;
                        try {
                            timeRefs.append("ns");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    case 'p': {
                        this.match("ps");
                        if (this.inputState.guessing() != 0) break;
                        try {
                            timeRefs.append("ps");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    case 'f': {
                        this.match("fs");
                        if (this.inputState.guessing() != 0) break;
                        try {
                            timeRefs.append("fs");
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.mDEFINE_WS_OR_COMMENT_OPT(false);
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return isTimeprecision;
    }

    protected final void mDEFINE_WS_OR_COMMENT_OPT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 604;
        boolean synPredMatched780 = false;
        if (_tokenSet_55.member((int)this.LA(1))) {
            int _m780 = this.mark();
            synPredMatched780 = true;
            this.inputState.incGuessing();
            try {
                this.mDEFINE_WS_OR_COMMENT(false);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched780 = false;
            }
            this.rewind(_m780);
            this.inputState.decGuessing(synPredMatched780);
        }
        if (synPredMatched780) {
            this.mDEFINE_WS_OR_COMMENT(false);
            this.mDEFINE_WS_OR_COMMENT_OPT(false);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPRAGMA_EXPRESSION(boolean _createToken, boolean allowID) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 612;
        switch (this.LA(1)) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                this.mPRAGMA_KEYWORD_OR_ID(false, allowID);
                boolean synPredMatched819 = false;
                if (_tokenSet_71.member((int)this.LA(1)) && _tokenSet_72.member((int)this.LA(2))) {
                    int _m819 = this.mark();
                    synPredMatched819 = true;
                    this.inputState.incGuessing();
                    try {
                        switch (this.LA(1)) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': 
                            case '\u00a0': {
                                this.mWS(false);
                                break;
                            }
                            case '=': {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        this.match('=');
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched819 = false;
                    }
                    this.rewind(_m819);
                    this.inputState.decGuessing(synPredMatched819);
                }
                if (!synPredMatched819) break;
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case '=': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.match('=');
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case '\"': 
                    case '(': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.mPRAGMA_VALUE(false);
                break;
            }
            case '(': {
                this.match('(');
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case '\"': 
                    case '(': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.mPRAGMA_EXPRESSION(false, true);
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case ')': 
                    case ',': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                block36: while (this.LA(1) == ',') {
                    this.mCOMMA(false);
                    switch (this.LA(1)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '\u00a0': {
                            this.mWS(false);
                            break;
                        }
                        case '\"': 
                        case '(': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': 
                        case '_': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    this.mPRAGMA_EXPRESSION(false, true);
                    switch (this.LA(1)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '\u00a0': {
                            this.mWS(false);
                            continue block36;
                        }
                        case ')': 
                        case ',': {
                            continue block36;
                        }
                    }
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                this.match(')');
                break;
            }
            case '\"': {
                this.mSTRING(false);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.mNUMBER_BASE(false);
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPRAGMA_EXPRESSION_LIST(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 611;
        boolean synPredMatched813 = false;
        if (this.LA(1) == ',') {
            int _m813 = this.mark();
            synPredMatched813 = true;
            this.inputState.incGuessing();
            try {
                this.mCOMMA(false);
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case '\"': 
                    case '(': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.mPRAGMA_EXPRESSION(false, false);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched813 = false;
            }
            this.rewind(_m813);
            this.inputState.decGuessing(synPredMatched813);
        }
        if (synPredMatched813) {
            this.mCOMMA(false);
            switch (this.LA(1)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u00a0': {
                    this.mWS(false);
                    break;
                }
                case '\"': 
                case '(': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    break;
                }
                default: {
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            this.mPRAGMA_EXPRESSION(false, false);
            this.mPRAGMA_EXPRESSION_LIST(false);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPRAGMA_KEYWORD_OR_ID(boolean _createToken, boolean allowID) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 614;
        boolean synPredMatched838 = false;
        if (_tokenSet_73.member((int)this.LA(1)) && _tokenSet_74.member((int)this.LA(2)) && _tokenSet_75.member((int)this.LA(3))) {
            int _m838 = this.mark();
            synPredMatched838 = true;
            this.inputState.incGuessing();
            try {
                this.mPRAGMA_KEYWORD(false);
                this.match(_tokenSet_30);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched838 = false;
            }
            this.rewind(_m838);
            this.inputState.decGuessing(synPredMatched838);
        }
        if (synPredMatched838) {
            this.mPRAGMA_KEYWORD(false);
        } else if (_tokenSet_15.member((int)this.LA(1)) && allowID) {
            this.mINTERNAL_ID_1(false);
        } else {
            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPRAGMA_VALUE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 613;
        switch (this.LA(1)) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                this.mINTERNAL_ID_1(false);
                break;
            }
            case '(': {
                this.match('(');
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case '\"': 
                    case '(': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                this.mPRAGMA_EXPRESSION(false, true);
                switch (this.LA(1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': {
                        this.mWS(false);
                        break;
                    }
                    case ')': 
                    case ',': {
                        break;
                    }
                    default: {
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                }
                block22: while (this.LA(1) == ',') {
                    this.mCOMMA(false);
                    switch (this.LA(1)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '\u00a0': {
                            this.mWS(false);
                            break;
                        }
                        case '\"': 
                        case '(': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': 
                        case '_': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    this.mPRAGMA_EXPRESSION(false, true);
                    switch (this.LA(1)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '\u00a0': {
                            this.mWS(false);
                            continue block22;
                        }
                        case ')': 
                        case ',': {
                            continue block22;
                        }
                    }
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                this.match(')');
                break;
            }
            case '\"': {
                this.mSTRING(false);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.mNUMBER_BASE(false);
                break;
            }
            default: {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mPRAGMA_KEYWORD(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 615;
        block2 : switch (this.LA(1)) {
            case 'b': {
                this.match("begin");
                if (this.LA(1) != '_') break;
                this.match("_protected");
                if (this.inputState.guessing() != 0) break;
                try {
                    this.isEncrypted = true;
                    this.util.setEncryptedCodeLineSkip(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                    EncryptedUtils.INSTANCE.collectEncryptedCodeHeaders(this.grabProtectedData("end_protected"));
                    this.isEncrypted = false;
                    this.util.setEncryptedCodeLineEnter(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                    this.util.setEncryptedFile(this.getFilename(), true);
                    String replacement = EncryptedUtils.INSTANCE.getDecryptedCode();
                    if (replacement == null) break;
                    EncryptedUtils.INSTANCE.clear();
                    StringBuilder fullReplacement = new StringBuilder(replacement);
                    char[] charvals = new char[fullReplacement.length()];
                    fullReplacement.getChars(0, fullReplacement.length(), charvals, 0);
                    CharArrayReader charir = new CharArrayReader(charvals);
                    VlogLexer newLexer = new VlogLexer(charir, (Map<ANTLRHashString, Integer>)this.literals);
                    newLexer.lS = this.lS;
                    newLexer.parentLexer = this;
                    newLexer.util = this.util;
                    newLexer.followImports = this.followImports;
                    newLexer.defaultLanguageSyntax = this.defaultLanguageSyntax;
                    newLexer.rfp = this.rfp;
                    newLexer.parserPath = this.parserPath;
                    newLexer.fileIndex = this.fileIndex;
                    newLexer.setFilename(this.getFilename(), this.indexer, false);
                    newLexer.reparseFileName = this.reparseFileName;
                    newLexer.reparseFileLine = this.reparseFileLine;
                    newLexer.virtualOffset = this.virtualOffset == null ? new VirtualOffset() : this.virtualOffset;
                    newLexer.isPVlogPreprocessing = this.isPVlogPreprocessing;
                    newLexer.kind = 3;
                    this.lS.push(newLexer);
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
                break;
            }
            case 'a': {
                this.match("author");
                if (this.LA(1) != '_') break;
                this.match("_info");
                break;
            }
            case 'k': {
                this.match("key_");
                switch (this.LA(1)) {
                    case 'k': {
                        this.match("key");
                        switch (this.LA(1)) {
                            case 'o': {
                                this.match("owner");
                                break block2;
                            }
                            case 'n': {
                                this.match("name");
                                break block2;
                            }
                        }
                        throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    case 'm': {
                        this.match("method");
                        break block2;
                    }
                    case 'p': {
                        this.match("public_key");
                        break block2;
                    }
                    case 'b': {
                        this.match("block");
                        break block2;
                    }
                }
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            case 'c': {
                this.match("comment");
                break;
            }
            case 'v': {
                this.match("viewport");
                break;
            }
            default: {
                if (this.LA(1) == 'e' && this.LA(2) == 'n' && this.LA(3) == 'd') {
                    this.match("end");
                    if (this.LA(1) != '_') break;
                    this.match("_protected");
                    if (this.inputState.guessing() != 0) break;
                    try {
                        this.util.setEncryptedCodeLineEnter(this.lS.getCurrentFileInstance(), this.getLine(), 0);
                    }
                    catch (Exception ex) {
                        this.userExceptionHandler(ex);
                    }
                    break;
                }
                if (this.LA(1) == 'e' && this.LA(2) == 'n' && this.LA(3) == 'c') {
                    this.match("enc");
                    switch (this.LA(1)) {
                        case 'r': {
                            this.match("rypt_agent");
                            if (this.LA(1) != '_') break block2;
                            this.match("_info");
                            break block2;
                        }
                        case 'o': {
                            this.match("oding");
                            break block2;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                if (this.LA(1) == 'd' && this.LA(2) == 'a') {
                    this.match("data_");
                    switch (this.LA(1)) {
                        case 'k': {
                            this.match("key");
                            switch (this.LA(1)) {
                                case 'o': {
                                    this.match("owner");
                                    break block2;
                                }
                                case 'n': {
                                    this.match("name");
                                    break block2;
                                }
                            }
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        case 'm': {
                            this.match("method");
                            break block2;
                        }
                        case 'p': {
                            this.match("public_key");
                            break block2;
                        }
                        case 'd': {
                            this.match("decrypt_key");
                            break block2;
                        }
                        case 'b': {
                            this.match("block");
                            break block2;
                        }
                    }
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                if (this.LA(1) == 'd' && this.LA(2) == 'i') {
                    this.match("digest_");
                    switch (this.LA(1)) {
                        case 'k': {
                            this.match("key");
                            switch (this.LA(1)) {
                                case 'o': {
                                    this.match("owner");
                                    break block2;
                                }
                                case '_': {
                                    this.match("_method");
                                    break block2;
                                }
                                case 'n': {
                                    this.match("name");
                                    break block2;
                                }
                            }
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        case 'p': {
                            this.match("public_key");
                            break block2;
                        }
                        case 'd': {
                            this.match("decrypt_key");
                            break block2;
                        }
                        case 'm': {
                            this.match("method");
                            break block2;
                        }
                        case 'b': {
                            this.match("block");
                            break block2;
                        }
                    }
                    throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                if (this.LA(1) == 'd' && this.LA(2) == 'e') {
                    this.match("decrypt_license");
                    break;
                }
                if (this.LA(1) == 'r' && this.LA(2) == 'u') {
                    this.match("runtime_license");
                    break;
                }
                if (this.LA(1) == 'r' && this.LA(2) == 'e') {
                    this.match("reset");
                    break;
                }
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mDEFAULT_TRIREG_STRENGTH(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block13: {
            _token = null;
            _begin = this.text.length();
            _ttype = 623;
            CharScanner.UserMark userMark = null;
            Runnable finalRunnable = null;
            try {
                try {
                    this.match('`');
                    while (_tokenSet_13.member((int)this.LA(1))) {
                        this.mDEFINE_WS(false);
                    }
                    this.match("default_trireg_strength");
                    int _cnt892 = 0;
                    while (true) {
                        if (!_tokenSet_18.member((int)this.LA(1))) {
                            if (_cnt892 >= 1) break;
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.mDEFINE_WS_NL_OR_COMMENT(false);
                        ++_cnt892;
                    }
                    this.mLINE_NUMBER(false);
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() != 0) {
                        throw ex;
                    }
                    this.consume();
                    this.reportError("*** Error: ", this.getFilename(), this.getLine(), ex.getOffset(), ex.getLength(), ex.getMessage());
                    this.userRelease(userMark);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final String mUSELIB_BODY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        String result = "";
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 625;
        StringBuilder buff = new StringBuilder();
        while (true) {
            boolean synPredMatched900 = false;
            if (this.LA(1) == '\\' && _tokenSet_22.member((int)this.LA(2))) {
                int _m900 = this.mark();
                synPredMatched900 = true;
                this.inputState.incGuessing();
                try {
                    this.match('\\');
                    switch (this.LA(1)) {
                        case '\r': {
                            this.match('\r');
                            break;
                        }
                        case '\n': {
                            this.match('\n');
                            break;
                        }
                        default: {
                            throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched900 = false;
                }
                this.rewind(_m900);
                this.inputState.decGuessing(synPredMatched900);
            }
            if (synPredMatched900) {
                this.mDEFINE_MACRO_ESC(false);
                if (this.inputState.guessing() != 0) continue;
                try {
                    buff.append('\n');
                }
                catch (Exception ex) {
                    this.userExceptionHandler(ex);
                }
                continue;
            }
            if (!_tokenSet_7.member((int)this.LA(1))) break;
            this.match(_tokenSet_7);
            if (this.inputState.guessing() != 0) continue;
            try {
                buff.append(this.LA(0));
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (this.inputState.guessing() == 0) {
            try {
                result = buff.toString().trim();
            }
            catch (Exception ex) {
                this.userExceptionHandler(ex);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
        return result;
    }

    protected final void mC_EXPRESSION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block14: {
            _token = null;
            _begin = this.text.length();
            _ttype = 629;
            if (this.LA(1) >= '\u0000' && this.LA(1) <= '\ufffe' && !this.util.isOSX()) {
                while (true) {
                    boolean synPredMatched917 = false;
                    if (this.LA(1) == '\r' && _tokenSet_6.member((int)this.LA(2))) {
                        int _m917 = this.mark();
                        synPredMatched917 = true;
                        this.inputState.incGuessing();
                        try {
                            this.match('\r');
                            this.match(_tokenSet_6);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched917 = false;
                        }
                        this.rewind(_m917);
                        this.inputState.decGuessing(synPredMatched917);
                    }
                    if (synPredMatched917) {
                        this.match('\r');
                        if (this.inputState.guessing() == 0) {
                            try {
                                this.newline();
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.match(_tokenSet_6);
                        continue;
                    }
                    if (_tokenSet_7.member((int)this.LA(1))) {
                        this.match(_tokenSet_7);
                        continue;
                    }
                    break block14;
                    break;
                }
            }
            if (this.LA(1) >= '\u0000' && this.LA(1) <= '\ufffe' && this.util.isOSX()) {
                while (_tokenSet_7.member((int)this.LA(1))) {
                    this.match(_tokenSet_7);
                }
            } else {
                throw this.getNoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        this.mNEWLINE(false, false);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[1025];
        data[0] = 0x1000000000L;
        data[1] = 576460745995190270L;
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[1025];
        data[1] = 2393722713571604L;
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[1025];
        data[0] = 0x3000000000000L;
        data[1] = 0x500000005000000L;
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[3072];
        data[0] = 0xFFFFC9FFL;
        data[1] = Long.MIN_VALUE;
        data[2] = -4294967297L;
        int i = 3;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[3072];
        data[0] = -1L;
        int i = 1;
        while (i <= 2) {
            data[i] = -4294967297L;
            ++i;
        }
        i = 3;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[2048];
        data[0] = -4294953472L;
        data[1] = 0x7FFFFFFEFFFFFFFFL;
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[2048];
        data[0] = -1025L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[2048];
        data[0] = -9217L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[2048];
        data[0] = -9217L;
        data[1] = -268435457L;
        int i = 2;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[2048];
        data[0] = -4398046520321L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x23000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x20000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x420000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_13() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_14() {
        long[] data = new long[1025];
        data[0] = 287948905469972992L;
        data[1] = 576460746263625726L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_15() {
        long[] data = new long[1025];
        data[1] = 576460745995190270L;
        return data;
    }

    private static final long[] mk_tokenSet_16() {
        long[] data = new long[1025];
        data[0] = 21474850304L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_17() {
        long[] data = new long[2048];
        data[0] = -576478344489467905L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_18() {
        long[] data = new long[1025];
        data[0] = 140741783336448L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_19() {
        long[] data = new long[1025];
        data[0] = 0x840000000400L;
        data[1] = 576460745995190270L;
        return data;
    }

    private static final long[] mk_tokenSet_20() {
        long[] data = new long[1025];
        data[0] = 288094036709868544L;
        return data;
    }

    private static final long[] mk_tokenSet_21() {
        long[] data = new long[1025];
        data[0] = 141841294964224L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_22() {
        long[] data = new long[1025];
        data[0] = 4294981120L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_23() {
        long[] data = new long[2048];
        data[0] = -17179878401L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_24() {
        long[] data = new long[1025];
        data[0] = 140741783336448L;
        data[1] = 576460745995190270L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_25() {
        long[] data = new long[2048];
        data[0] = -4294981121L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_26() {
        long[] data = new long[1025];
        data[0] = -8935282393896438272L;
        data[1] = 360288517881856126L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_27() {
        long[] data = new long[1025];
        data[0] = -8935423135679774720L;
        data[1] = 360288513586888830L;
        return data;
    }

    private static final long[] mk_tokenSet_28() {
        long[] data = new long[2048];
        data[0] = -6341068292517536769L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_29() {
        long[] data = new long[1025];
        data[1] = 11646302039310336L;
        return data;
    }

    private static final long[] mk_tokenSet_30() {
        long[] data = new long[2048];
        data[0] = -287948969894477825L;
        data[1] = -576460745995190271L;
        int i = 2;
        while (i <= 1023) {
            data[i] = -1L;
            ++i;
        }
        return data;
    }

    private static final long[] mk_tokenSet_31() {
        long[] data = new long[1025];
        data[1] = 9403306909640832L;
        return data;
    }

    private static final long[] mk_tokenSet_32() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x1000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_33() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x3000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_34() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x20000000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_35() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x20400000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_36() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x4000000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_37() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x4002000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_38() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x10000000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_39() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x10020000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_40() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x24000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_41() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x2000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_42() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x102000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_43() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x402000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_44() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x100000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_45() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x120000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_46() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x400000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_47() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x2400000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_48() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x1000000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_49() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x5000000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_50() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x28000000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_51() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x80000000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_52() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x80800000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_53() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x400000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_54() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0xC00000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_55() {
        long[] data = new long[1025];
        data[0] = 140741783327232L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_56() {
        long[] data = new long[1025];
        data[0] = 703691736757760L;
        int i = 1;
        while (i <= 2) {
            data[i] = 0x100000000L;
            ++i;
        }
        return data;
    }

    private static final long[] mk_tokenSet_57() {
        long[] data = new long[1025];
        data[0] = 141841294955008L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_58() {
        long[] data = new long[1025];
        data[0] = 0x3FF000000000000L;
        data[1] = 576460746263625726L;
        return data;
    }

    private static final long[] mk_tokenSet_59() {
        long[] data = new long[1025];
        data[0] = 287950017866498048L;
        data[1] = 576460745995190270L;
        return data;
    }

    private static final long[] mk_tokenSet_60() {
        long[] data = new long[2048];
        data[0] = -17179869185L;
        int i = 1;
        while (i <= 1023) {
            data[i] = -1L;
            ++i;
        }
        return data;
    }

    private static final long[] mk_tokenSet_61() {
        long[] data = new long[2048];
        data[0] = -17179878401L;
        data[1] = -4294967297L;
        int i = 2;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_62() {
        long[] data = new long[1025];
        data[0] = 288089642958337536L;
        data[1] = 576460746263625726L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_63() {
        long[] data = new long[2048];
        data[0] = -20890720936961L;
        data[1] = -2882303762188206081L;
        int i = 2;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_64() {
        long[] data = new long[2048];
        data[0] = -3298534892545L;
        data[1] = -2882303762188206081L;
        int i = 2;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_65() {
        long[] data = new long[2048];
        data[0] = -9217L;
        data[1] = -2305843009750564865L;
        int i = 2;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_66() {
        long[] data = new long[1025];
        data[0] = 0x100001200L;
        data[1] = 0x502000000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_67() {
        long[] data = new long[2048];
        data[0] = -3298534883329L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_68() {
        long[] data = new long[2048];
        data[0] = -3298534892545L;
        int i = 1;
        while (i <= 1022) {
            data[i] = -1L;
            ++i;
        }
        data[1023] = Long.MAX_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_69() {
        long[] data = new long[1025];
        data[0] = 4294981120L;
        data[1] = 0x110000000L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_70() {
        long[] data = new long[1025];
        data[0] = 140741783327232L;
        data[1] = 11646302039310336L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_71() {
        long[] data = new long[1025];
        data[0] = 2305843013508675072L;
        data[2] = 0x100000000L;
        return data;
    }

    private static final long[] mk_tokenSet_72() {
        long[] data = new long[2048];
        data[0] = 2593793031375173120L;
        data[1] = 576460745995190270L;
        data[2] = 0x100000000L;
        data[1023] = Long.MIN_VALUE;
        return data;
    }

    private static final long[] mk_tokenSet_73() {
        long[] data = new long[1025];
        data[1] = 19149360797319168L;
        return data;
    }

    private static final long[] mk_tokenSet_74() {
        long[] data = new long[1025];
        data[1] = 0x20C22200000000L;
        return data;
    }

    private static final long[] mk_tokenSet_75() {
        long[] data = new long[1025];
        data[1] = 150976930907160576L;
        return data;
    }

    class MatchedWordInfo {
        private String matchedWord;
        private boolean isEndWord;
        private boolean isBeginWord;

        public MatchedWordInfo(String matchedWord, boolean isEndWord, boolean isBeginWord) {
            this.matchedWord = matchedWord;
            this.isEndWord = isEndWord;
            this.isBeginWord = isBeginWord;
        }

        public String getMatchedWord() {
            return this.matchedWord;
        }

        public void setMatchedWord(String matchedWord) {
            this.matchedWord = matchedWord;
        }

        public boolean isEndWord() {
            return this.isEndWord;
        }

        public void setEndWord(boolean isEndWord) {
            this.isEndWord = isEndWord;
        }

        public boolean isBeginWord() {
            return this.isBeginWord;
        }

        public void setBeginWord(boolean isBeginWord) {
            this.isBeginWord = isBeginWord;
        }
    }

    class VirtualOffset {
        int offset = 0;

        VirtualOffset() {
        }
    }
}

