/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.MD5InputStream;
import ro.amiq.dvt.utils.parser.DVTLexerStack;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.util.EncryptedCodeAutoWrapper;
import ro.amiq.vlogdt.parser.DVTCustomToken;
import ro.amiq.vlogdt.parser.IParsingInfo;
import ro.amiq.vlogdt.parser.LibrarySpecPath;
import ro.amiq.vlogdt.parser.MacroCallListener;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogConcurrentArray;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogLexer;
import ro.amiq.vlogdt.parser.VlogLoadedInfo;
import ro.amiq.vlogdt.parser.VlogStartedInfo;
import ro.amiq.vlogdt.parser.VlogUtil;

public final class VlogLexersStack
extends DVTLexerStack
implements TokenStream {
    private ParserPath fParserPath;
    private VlogLexer fCurrentLexer;
    private Deque<VlogLexer> fLexersStack;
    protected static final int INCLUDE = 0;
    protected static final int DEFINE = 1;
    protected static final int IFDEF = 2;
    protected static final int ENCRYPTED = 3;
    private static final int MAX_SELF_MACRO_CALL_DEPTH = 10;
    private static final int MAX_IMPORT_CALL_DEPTH = 4;
    public static final int SET_SCOPE_TOKEN_TYPE = 100000;
    protected Set<VlogLexer> fSkipDefine;
    private Object2IntMap<ParserPath> fCyclicImportMap = new Object2IntOpenHashMap();
    private Object2IntMap<String> fCyclicDefineMap = new Object2IntOpenHashMap();
    private VlogUtil fUtil;
    private DVTCustomToken fLastEofTokenLT;
    private DVTCustomToken fLastEofTokenPT;
    private DVTCustomToken fLastValidEofTokenLT;
    private VlogFileInstance fPrevFileInstanceLT;
    private VlogFileInstance fCurrFileInstanceLT;
    private int fIncludingFileLastLine;
    private String fDefaultNettypePT;
    private HidImplicit[] fTimescale;
    private List<MacroCallListener> fMacroCallListeners;
    private Thread fLexerThread;
    private VlogConcurrentArray fAsyncLexerBuffer;
    private boolean fUseMultipleThreads;
    private volatile boolean fInterrupt;
    private Map<Token, List<DVTCustomToken>> fScopeStartNewFileMap = new HashMap<Token, List<DVTCustomToken>>();
    private boolean fHasEnabledEncryptedCodeAuto;
    private boolean fHasEncryptedCodeSupport;
    private boolean fAtEOF;
    private EncryptedCodeAutoWrapper fEncryptedCodeAutoWrapper;
    private ReparseInfo fReparseInfoLT;
    private boolean fReparseMacroNameChangedLT;

    protected VlogLexersStack(VlogLexer lexer, VlogUtil util) {
        this.fLexersStack = new ArrayDeque<VlogLexer>();
        this.fSkipDefine = new HashSet<VlogLexer>();
        this.fUtil = util;
        this.fHasEnabledEncryptedCodeAuto = this.fUtil != null && this.fUtil.hasEncryptedCodeAuto();
        this.fHasEncryptedCodeSupport = this.fUtil != null && this.fUtil.hasEncryptedCodeSupport();
        this.push(lexer);
        this.fLastEofTokenLT = null;
        this.fLastEofTokenPT = null;
        this.fEncryptedCodeAutoWrapper = new EncryptedCodeAutoWrapper(this.fUtil);
    }

    protected void setMultipleThreads(boolean useMultipleThreads) {
        this.fUseMultipleThreads = useMultipleThreads;
        if (useMultipleThreads) {
            this.fAsyncLexerBuffer = new VlogConcurrentArray(15);
            this.fLexerThread = new Thread(){

                @Override
                public void run() {
                    try {
                        super.run();
                        DVTCustomToken token = null;
                        do {
                            try {
                                token = VlogLexersStack.this.nextTokenInternalLT();
                                VlogLexersStack.this.fAsyncLexerBuffer.put((Object)token);
                            }
                            catch (TokenStreamException e) {
                                token = VlogLexersStack.this.getEOFTokenLT(null);
                                VlogLexersStack.this.fAsyncLexerBuffer.put((Object)e);
                                VlogLexersStack.this.fAsyncLexerBuffer.put((Object)token);
                            }
                        } while (token == null || token.getType() != 1);
                    }
                    catch (Throwable e) {
                        DVTLogger.INSTANCE.logError(e);
                        try {
                            VlogLexersStack.this.fAsyncLexerBuffer.put(e);
                        }
                        catch (Throwable e1) {
                            DVTLogger.INSTANCE.logError(e1);
                        }
                    }
                }
            };
            this.fLexerThread.setPriority(10);
            this.fLexerThread.start();
        }
    }

    protected final ParserPath getFilename() {
        return this.fParserPath;
    }

    /*
     * Unable to fully structure code
     */
    public final Token nextToken() throws TokenStreamException {
        if (!this.fUseMultipleThreads) {
            scopeStartNewFile = null;
            block2: while (true) {
                if ((token = this.nextTokenInternalLT()).getType() == 605) {
                    this.fDefaultNettypePT = "wire";
                    this.fTimescale = this.fUtil.getEffectiveBuildConfigTimescale() != null ? this.fUtil.getEffectiveBuildConfigTimescale() : RfInstanceHolder.DEFAULT_TIMESCALE;
                    continue;
                }
                if (token.getType() == 600) {
                    this.fDefaultNettypePT = token.getText().substring(2);
                    continue;
                }
                if (token.getType() == 602) {
                    values = token.getText();
                    divIndex = values.indexOf(47);
                    if (divIndex > 0) {
                        if (this.fUtil.getBuildConfigOverrideTimescale() == null) {
                            timeunit = values.substring(0, divIndex).trim();
                            timeprecision = values.substring(divIndex + 1).trim();
                            this.fTimescale = new HidImplicit[]{RfHidImplicit.makeImplicit((String)timeunit, 283), RfHidImplicit.makeImplicit(timeprecision, 283)};
                            continue;
                        }
                        this.fTimescale = this.fUtil.getBuildConfigOverrideTimescale();
                        continue;
                    }
                    this.fTimescale = this.fUtil.getEffectiveBuildConfigTimescale() != null ? this.fUtil.getEffectiveBuildConfigTimescale() : RfInstanceHolder.DEFAULT_TIMESCALE;
                    continue;
                }
                if (token.getType() == 634) {
                    this.fUtil.getRfProject().startLibrary(token.getText(), true);
                    continue;
                }
                if (token.getType() == 635) {
                    this.fUtil.getRfProject().resetLibraryFromPreprocessor(token.getFileInstance());
                    continue;
                }
                if (token.getType() == 288) {
                    if (scopeStartNewFile == null) {
                        scopeStartNewFile = new ArrayList<DVTCustomToken>();
                    }
                    scopeStartNewFile.add(token);
                    continue;
                }
                if (token.getType() == 1) {
                    this.getEOFTokenPT(token);
                }
                if (token.getType() != 544) break;
                paths = token.getPaths();
                if (paths == null || paths.isEmpty()) continue;
                timeunit = paths.iterator();
                while (true) {
                    if (timeunit.hasNext()) ** break;
                    continue block2;
                    libSpecPath = (LibrarySpecPath)timeunit.next();
                    this.cfgLibraryDecl(libSpecPath);
                }
                break;
            }
            if (scopeStartNewFile != null && !scopeStartNewFile.isEmpty()) {
                this.fScopeStartNewFileMap.put((Token)token, scopeStartNewFile);
            }
            scopeStartNewFile = null;
            return token;
        }
        try {
            object = null;
            scopeStartNewFile = null;
            block4: while (true) {
                if (this.fAsyncLexerBuffer.isEmpty() && this.fLastEofTokenPT != null) {
                    return this.fLastEofTokenPT;
                }
                object = this.fAsyncLexerBuffer.take();
                if (object instanceof Token) {
                    token = (DVTCustomToken)object;
                    if (this.fInterrupt) {
                        return this.getEOFTokenPT(token);
                    }
                    if (token.getType() == 605) {
                        this.fDefaultNettypePT = "wire";
                        this.fTimescale = this.fUtil.getEffectiveBuildConfigTimescale() != null ? this.fUtil.getEffectiveBuildConfigTimescale() : RfInstanceHolder.DEFAULT_TIMESCALE;
                        continue;
                    }
                    if (token.getType() == 600) {
                        this.fDefaultNettypePT = token.getText().substring(2);
                        continue;
                    }
                    if (token.getType() == 602) {
                        values = token.getText();
                        divIndex = values.indexOf(47);
                        if (divIndex > 0) {
                            if (this.fUtil.getBuildConfigOverrideTimescale() == null) {
                                timeunit = values.substring(0, divIndex).trim();
                                timeprecision = values.substring(divIndex + 1).trim();
                                this.fTimescale = new HidImplicit[]{RfHidImplicit.makeImplicit(timeunit, 283), RfHidImplicit.makeImplicit(timeprecision, 283)};
                                continue;
                            }
                            this.fTimescale = this.fUtil.getBuildConfigOverrideTimescale();
                            continue;
                        }
                        this.fTimescale = this.fUtil.getEffectiveBuildConfigTimescale() != null ? this.fUtil.getEffectiveBuildConfigTimescale() : RfInstanceHolder.DEFAULT_TIMESCALE;
                        continue;
                    }
                    if (token.getType() == 634) {
                        this.fUtil.getRfProject().startLibrary(token.getText(), true);
                        continue;
                    }
                    if (token.getType() == 635) {
                        this.fUtil.getRfProject().resetLibraryFromPreprocessor(token.getFileInstance());
                        continue;
                    }
                    if (token.getType() == 288) {
                        if (scopeStartNewFile == null) {
                            scopeStartNewFile = new ArrayList<DVTCustomToken>();
                        }
                        scopeStartNewFile.add(token);
                        continue;
                    }
                    if (token.getType() == 1) {
                        this.getEOFTokenPT(token);
                    }
                    reparseInfo = token.getReparseInfo();
                    fileInstance = token.getFileInstance();
                    if (fileInstance != null) {
                        this.notifyMacroCallListenersPT(reparseInfo, fileInstance.getParserPath(), this.getLineInfo((Token)token));
                    }
                    if (token.getType() == 544) {
                        paths = token.getPaths();
                        if (paths == null || paths.isEmpty()) continue;
                        var8_17 = paths.iterator();
                        while (true) {
                            if (!var8_17.hasNext()) continue block4;
                            libSpecPath = var8_17.next();
                            this.cfgLibraryDecl(libSpecPath);
                        }
                    }
                    if (scopeStartNewFile != null && !scopeStartNewFile.isEmpty()) {
                        this.fScopeStartNewFileMap.put((Token)token, scopeStartNewFile);
                    }
                    scopeStartNewFile = null;
                    return token;
                }
                if (object instanceof TokenStreamException) {
                    throw (TokenStreamException)object;
                }
                if (object instanceof Throwable) {
                    DVTLogger.INSTANCE.logError((Throwable)object);
                    this.getEOFTokenPT(null);
                    throw new RuntimeException("Lexer thread stopped due to exception");
                }
                if (object instanceof IParsingInfo) {
                    this.fUtil.notifyParsingListenersPT((IParsingInfo)object);
                    continue;
                }
                if (!(object instanceof ProblemWrapper)) continue;
                pw = (ProblemWrapper)object;
                this.fUtil.reportError(pw.getSeverity(), pw.getFileName(), pw.getLanguageSyntax(), pw.getLine(), pw.getOffset(), pw.getLength(), pw.getMessage(), pw.getIndex(), pw.getReparseInfo(), pw.getAttributes());
            }
        }
        catch (InterruptedException v0) {
            return this.getEOFTokenPT(null);
        }
    }

    public final void setScopeNewFile(RfProject rfProject, Token consumedToken) {
        if (this.fScopeStartNewFileMap.isEmpty()) {
            return;
        }
        List<DVTCustomToken> tokens = this.fScopeStartNewFileMap.remove(consumedToken);
        if (tokens == null || tokens.isEmpty()) {
            return;
        }
        for (DVTCustomToken token : tokens) {
            rfProject.setScopeForNewIncludedFile(token.getFileInstance(), token.getNewIncludedFile());
        }
    }

    public final String getDefaultNettype() {
        if (this.fDefaultNettypePT == null) {
            return "wire";
        }
        return this.fDefaultNettypePT;
    }

    public final HidImplicit[] getTimescale() {
        if (this.fTimescale == null) {
            return this.fUtil.getEffectiveBuildConfigTimescale() != null ? this.fUtil.getEffectiveBuildConfigTimescale() : RfInstanceHolder.DEFAULT_TIMESCALE;
        }
        return this.fTimescale;
    }

    private final DVTCustomToken nextTokenInternalLT() throws TokenStreamException {
        DVTCustomToken missingEndToken;
        DVTCustomToken nextToken = null;
        boolean skip = false;
        if (this.fHasEnabledEncryptedCodeAuto && (missingEndToken = this.fEncryptedCodeAutoWrapper.getMissingAutoClosedScopeEncryptionToken(this.fAtEOF, this.fLastValidEofTokenLT, this.fPrevFileInstanceLT != null ? this.fPrevFileInstanceLT.getParserPath() : null)) != null) {
            return missingEndToken;
        }
        if (this.fCurrentLexer != null) {
            VlogFileInstance fileInstance;
            VlogFileInstance tmpFileInstance;
            long timestamp = System.currentTimeMillis();
            do {
                if (this.fCurrentLexer == null) {
                    return this.getEOFTokenLT(null);
                }
                VlogFileInstance currentFileInstance = this.fCurrFileInstanceLT;
                nextToken = (DVTCustomToken)this.fCurrentLexer.nextTokenCustom();
                int tokenType = nextToken.getType();
                while (this.fCurrentLexer != null && tokenType == 291) {
                    nextToken = (DVTCustomToken)this.fCurrentLexer.nextTokenCustom();
                    tokenType = nextToken.getType();
                }
                if (this.fHasEnabledEncryptedCodeAuto) {
                    this.fAtEOF = tokenType == 1 && nextToken.getVirtualOffset() == -1 && !this.fAtEOF;
                    VlogFileInstance tmpFileInstance2 = tokenType == 1 && currentFileInstance != null ? currentFileInstance : this.fCurrFileInstanceLT;
                    DVTCustomToken missingEndToken2 = this.fEncryptedCodeAutoWrapper.getMissingAutoClosedScopeEncryptionToken(this.fAtEOF, this.fLastValidEofTokenLT, tmpFileInstance2 != null ? tmpFileInstance2.getParserPath() : null);
                    if (missingEndToken2 != null) {
                        return missingEndToken2;
                    }
                }
                int stackSize = this.fLexersStack.size();
                boolean bl = skip = tokenType == 565 || tokenType == 287 || tokenType == 1 && stackSize != 0 || this.isSkip();
                if (tokenType != 1 || stackSize < 1) continue;
                VlogFileInstance tmpFileInstance3 = this.fPrevFileInstanceLT != null ? this.fPrevFileInstanceLT : this.fCurrFileInstanceLT;
                nextToken.setFileInstance(tmpFileInstance3);
                nextToken.setMacroZone(tmpFileInstance3.getCurrMacroZone());
                this.fLastValidEofTokenLT = nextToken;
                this.fPrevFileInstanceLT = this.fCurrFileInstanceLT;
            } while (skip && !this.fInterrupt);
            this.setLastLine(nextToken.getLine());
            int tokenType = nextToken.getType();
            VlogFileInstance vlogFileInstance = tmpFileInstance = tokenType == 1 && this.fPrevFileInstanceLT != null ? this.fPrevFileInstanceLT : this.fCurrFileInstanceLT;
            if (tmpFileInstance != null) {
                nextToken.setFileInstance(tmpFileInstance);
                nextToken.setMacroZone(tmpFileInstance.getCurrMacroZone());
            }
            this.fPrevFileInstanceLT = this.fCurrFileInstanceLT;
            if (this.fCurrentLexer != null && (this.fCurrentLexer.fReparseStack.length > 0 || this.fCurrentLexer.isMacroReparsing())) {
                ReparseInfo reparseStackLT = this.getReparseStackLT();
                nextToken.setReparseInfo(reparseStackLT, this.fReparseMacroNameChangedLT);
            }
            if (!this.fUseMultipleThreads && (fileInstance = nextToken.getFileInstance()) != null) {
                this.notifyMacroCallListenersPT(nextToken.getReparseInfo(), fileInstance.getParserPath(), this.getLineInfo((Token)nextToken));
            }
            nextToken.setLastEofValidToken(this.fLastValidEofTokenLT);
            if (this.fHasEnabledEncryptedCodeAuto && this.fUtil.hasEncryptedCodeAutoPath(nextToken.getParserPath())) {
                this.fEncryptedCodeAutoWrapper.updateNoScopeOpenedCases(nextToken);
                DVTCustomToken missingEncryptedCodeToken = this.fEncryptedCodeAutoWrapper.handleCurrentMissingToken(nextToken, this.fLastValidEofTokenLT, this.fPrevFileInstanceLT != null ? this.fPrevFileInstanceLT.getParserPath() : null);
                if (missingEncryptedCodeToken != null) {
                    return missingEncryptedCodeToken;
                }
            }
            if (this.fInterrupt || tokenType == 1) {
                return this.getEOFTokenLT(nextToken);
            }
            if (tokenType != 288 && !this.fUtil.isDisabledPreprocDependent(this.fCurrFileInstanceLT)) {
                this.fUtil.disablePreprocDependent(this.fCurrFileInstanceLT);
            }
            TestHelper.fLexTime += System.currentTimeMillis() - timestamp;
            return nextToken;
        }
        if (this.fPrevFileInstanceLT != null) {
            this.notifyParsingListeners(new VlogLoadedInfo(this.fPrevFileInstanceLT.getParserPath(), this.fUtil, this.fPrevFileInstanceLT));
        }
        return this.getEOFTokenLT(null);
    }

    protected final ReparseInfo getReparseStackLT() {
        this.fReparseMacroNameChangedLT = false;
        if (this.fCurrentLexer.reparseMacro == null) {
            return null;
        }
        ReparseInfo.ReparseElement reparseElement = ReparseInfo.ReparseElement.of(this.fCurrentLexer.reparseMacro, this.fCurrentLexer.reparseMacroParameters, this.fCurrentLexer.reparseMacroUnprocessedParameters, this.fCurrentLexer.reparseFileName, this.fCurrentLexer.reparseFileLine);
        if (this.fReparseInfoLT != null && this.fReparseInfoLT.equals(this.fCurrentLexer.fReparseStack, reparseElement)) {
            return this.fReparseInfoLT;
        }
        String prevReparseMacroName = this.fReparseInfoLT == null ? null : this.fReparseInfoLT.getLastReparseMacroName();
        this.fReparseInfoLT = new ReparseInfo(this.fCurrentLexer.fReparseStack, reparseElement);
        String currReparseMacroName = this.fReparseInfoLT.getLastReparseMacroName();
        this.fReparseMacroNameChangedLT = prevReparseMacroName == null || !prevReparseMacroName.equals(currReparseMacroName);
        return this.fReparseInfoLT;
    }

    private final DVTCustomToken getEOFTokenLT(DVTCustomToken token) {
        if (this.fLastEofTokenLT == null) {
            this.fLastEofTokenLT = new TokenEOF(token);
        } else if (token != null) {
            this.fLastEofTokenLT.setLastEofValidToken(token.getLastEofValidToken());
        }
        return this.fLastEofTokenLT;
    }

    private final DVTCustomToken getEOFTokenPT(DVTCustomToken token) {
        if (this.fLastEofTokenPT == null) {
            this.fLastEofTokenPT = new TokenEOF(token);
        } else if (token != null) {
            this.fLastEofTokenPT.setLastEofValidToken(token.getLastEofValidToken());
        }
        return this.fLastEofTokenPT;
    }

    protected final void push(VlogLexer lexer) {
        try {
            VlogLexer prevLexer = null;
            int lexerStackSize = this.fLexersStack.size();
            if (lexerStackSize > 0 && (prevLexer = this.fLexersStack.peek()).isMacroReparsing() && !lexer.getMacroTraceIgnore()) {
                if (prevLexer.fReparseStack.length > 100) {
                    lexer.fReparseStack = prevLexer.fReparseStack;
                } else {
                    lexer.fReparseStack = new ReparseInfo.ReparseElement[prevLexer.fReparseStack.length + 1];
                    System.arraycopy(prevLexer.fReparseStack, 0, lexer.fReparseStack, 0, prevLexer.fReparseStack.length);
                    lexer.fReparseStack[prevLexer.fReparseStack.length] = prevLexer.fReparseStack.length == 100 ? new ReparseInfo.OverflowReparseElement() : ReparseInfo.ReparseElement.of(prevLexer.reparseMacro, prevLexer.reparseMacroParameters, prevLexer.reparseMacroUnprocessedParameters, prevLexer.reparseFileName, prevLexer.reparseFileLine);
                    this.fReparseInfoLT = null;
                }
            }
            if (lexer.loading) {
                this.notifyParsingListeners(new VlogStartedInfo(lexer.parserPath, this.fCurrentLexer == null ? -1 : this.fCurrentLexer.getLine(), this.fCurrentLexer == null ? -1 : this.fCurrentLexer.getOffset()));
                this.fIncludingFileLastLine = this.getLastLine();
                this.setLastLine(0);
                this.fCurrFileInstanceLT = this.fUtil.getCurrentFileInstance();
                if (this.fCurrFileInstanceLT != null) {
                    this.fCurrFileInstanceLT.setLanguageSyntax(lexer.getLanguageSyntax());
                }
            }
            int line = this.fCurrentLexer == null ? 0 : this.fCurrentLexer.getLine();
            IBuildConfigParserConstants.LanguageSyntax languageSyntax = this.fCurrentLexer == null ? VlogUtil.getDefaultLanguageSyntax() : this.fCurrentLexer.getLanguageSyntax();
            String fileName = this.fCurrentLexer == null ? "" : this.fCurrentLexer.getFilename();
            this.fLexersStack.push(lexer);
            this.fCurrentLexer = lexer;
            this.fParserPath = lexer.parserPath;
            if (lexer.kind == 0) {
                if (!lexer.isMacroReparsing() && this.fSkipDefine.isEmpty()) {
                    this.fUtil.pushWaiverStack();
                }
                Integer depth = this.fCyclicImportMap.get((Object)this.fParserPath);
                ++this.fCurrentLexer.fileIndex;
                if (depth == null) {
                    this.fCyclicImportMap.put((Object)this.fParserPath, 1);
                } else if (depth >= 4) {
                    this.fUtil.reportError("*** Error: ", fileName, languageSyntax, line, "Cyclic include detected.", this.fCurrentLexer.fileIndex, null);
                    this.notifyParsingListeners(new VlogLoadedInfo(this.fParserPath, this.fUtil, this.fCurrFileInstanceLT));
                    this.fCurrFileInstanceLT = this.fUtil.getCurrentFileInstance();
                    if (this.fCurrFileInstanceLT != null) {
                        this.fCurrFileInstanceLT.setLanguageSyntax(lexer.getLanguageSyntax());
                    }
                    this.pop();
                } else {
                    depth = depth + 1;
                    this.fCyclicImportMap.put((Object)this.fParserPath, depth);
                }
            } else if (lexer.kind == 1) {
                Integer depth = this.fCyclicDefineMap.get((Object)lexer.reparseMacroName);
                if (depth == null) {
                    this.fCyclicDefineMap.put((Object)lexer.reparseMacroName, 1);
                } else if (depth >= 10) {
                    this.fUtil.reportError("*** Error: ", fileName, languageSyntax, line, "Cyclic define detected.", this.fCurrentLexer.fileIndex, null);
                    this.pop();
                } else {
                    depth = depth + 1;
                    this.fCyclicDefineMap.put((Object)lexer.reparseMacroName, depth);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public final VlogFileInstance getCurrentFileInstance() {
        return this.fCurrFileInstanceLT;
    }

    protected final void pop() {
        this.pop(false);
    }

    public final boolean isMacroReparsing() {
        return this.fLexersStack.peek().isMacroReparsing();
    }

    protected final void pop(boolean preprocessing) {
        Integer depth;
        VlogLexer lexer = this.fLexersStack.peek();
        if (this.fParserPath != null && lexer.kind == 0) {
            Integer depth2;
            if (!preprocessing && !lexer.isMacroReparsing() && this.fSkipDefine.isEmpty()) {
                this.fUtil.popWaiverStack(this.fCurrentLexer.getFilename(), this.fCurrentLexer.getLanguageSyntax(), this.fCurrentLexer.getLine());
            }
            if ((depth2 = this.fCyclicImportMap.get((Object)this.fParserPath)) != null) {
                if ((depth2 = Integer.valueOf(depth2 - 1)) == 0) {
                    this.fCyclicImportMap.remove((Object)this.fParserPath);
                } else {
                    this.fCyclicImportMap.put((Object)this.fParserPath, depth2);
                }
            }
            this.fParserPath.setMd5(lexer.getMD5());
            this.fParserPath.setSize(lexer.inputStream instanceof MD5InputStream ? ((MD5InputStream)lexer.inputStream).getFile().length() : 0L);
            RfProject rfProject = lexer.util.getRfProject();
            RfFileDef fileDef = rfProject.getFileDefUsingParserPath(this.fParserPath);
            if (fileDef != null) {
                fileDef.getParserPath().setMd5(this.fParserPath.getMd5());
                fileDef.getParserPath().setSize(this.fParserPath.getSize());
            }
        } else if (lexer.kind == 1 && (depth = this.fCyclicDefineMap.get((Object)lexer.reparseMacroName)) != null) {
            if ((depth = Integer.valueOf(depth - 1)) == 0) {
                this.fCyclicDefineMap.remove((Object)lexer.reparseMacroName);
            } else {
                this.fCyclicDefineMap.put((Object)lexer.reparseMacroName, depth);
            }
        }
        if (!(this.fCurrentLexer.preprocessingType == 0 || preprocessing || this.fCurrentLexer.ifdefID.equals("translate_off") || this.fCurrentLexer.isMacroReparsing())) {
            this.fUtil.reportError("*** Error: ", this.fCurrentLexer.preprocessingFile, this.fCurrentLexer.getLanguageSyntax(), this.fCurrentLexer.preprocessingLine, "No matching `endif (unexpected EOF)", this.fCurrentLexer.fileIndex, null);
        }
        if (this.fCurrFileInstanceLT != null) {
            this.fCurrFileInstanceLT.setNofRawLines(this.fCurrentLexer.getLine());
        }
        this.fLexersStack.pop();
        this.fReparseInfoLT = null;
        if (this.fCurrentLexer.loading && !this.fInterrupt) {
            this.notifyParsingListeners(new VlogLoadedInfo(this.fParserPath, this.fUtil, this.fCurrFileInstanceLT));
            this.fCurrFileInstanceLT = this.fUtil.getCurrentFileInstance();
            this.setLastLine(this.fIncludingFileLastLine);
        }
        if (!this.fLexersStack.isEmpty()) {
            this.fCurrentLexer = this.fLexersStack.peek();
            this.fParserPath = this.fCurrentLexer.parserPath;
        } else {
            this.fCurrentLexer = null;
        }
    }

    protected final void clean() {
        try {
            this.fCyclicImportMap.clear();
            this.fCyclicDefineMap.clear();
            this.fLexersStack = new ArrayDeque<VlogLexer>();
            this.fSkipDefine = new HashSet<VlogLexer>();
            this.fLastEofTokenLT = null;
            this.fLastEofTokenPT = null;
            this.fPrevFileInstanceLT = null;
            this.fCurrFileInstanceLT = null;
            this.fMacroCallListeners = null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected final boolean isSkip() {
        return !this.fSkipDefine.isEmpty();
    }

    protected final void addSkipDefine(VlogLexer lexer) {
        this.fSkipDefine.add(lexer);
    }

    protected final void removeSkipDefine(VlogLexer lexer) {
        this.fSkipDefine.remove(lexer);
    }

    protected final boolean containsSkipDefine(VlogLexer lexer) {
        return this.fSkipDefine.contains(lexer);
    }

    public final void setInterrupt() {
        this.fInterrupt = true;
    }

    public final boolean getInterrupt() {
        return this.fInterrupt;
    }

    public final VlogLexer peek() {
        if (this.fLexersStack.isEmpty()) {
            return null;
        }
        return this.fLexersStack.peek();
    }

    private LineInfo getLineInfo(Token t) {
        if (t == null) {
            return new LineInfo(-1, -1, -1);
        }
        LineInfo result = new LineInfo(t.getLine(), t.getOffset(), -1);
        if (t instanceof DVTCustomToken) {
            result.virtOffset = ((DVTCustomToken)t).getVirtualOffset();
        }
        return result;
    }

    public final void addMacroCallListener(MacroCallListener listener) {
        if (this.fMacroCallListeners == null) {
            this.fMacroCallListeners = new ArrayList<MacroCallListener>();
        }
        this.fMacroCallListeners.add(listener);
    }

    private final void notifyMacroCallListenersPT(ReparseInfo reparseInfo, ParserPath parserPath, LineInfo lineInfo) {
        if (this.fMacroCallListeners == null || this.fMacroCallListeners.isEmpty()) {
            return;
        }
        if (reparseInfo == null || reparseInfo.getReparseStackSize() == 0) {
            return;
        }
        if (!reparseInfo.isNotificationDone()) {
            reparseInfo.setNotificationDone(true);
            ReparseInfo.ReparseElement[] reparseElements = reparseInfo.getReparseStack();
            int i = 0;
            while (i < reparseElements.length) {
                ReparseInfo.ReparseElement reparseElement = reparseElements[i];
                ReparseInfo.ReparseElement[] tempReparseStack = new ReparseInfo.ReparseElement[i];
                System.arraycopy(reparseElements, 0, tempReparseStack, 0, i);
                ReparseInfo tempReparseInfo = new ReparseInfo(tempReparseStack, null);
                for (MacroCallListener listener : this.fMacroCallListeners) {
                    if (listener == null) continue;
                    listener.notifyMacroCall(reparseElement.getTransientReparseMacroInfo(), reparseElement.getReparseMacroParams(), tempReparseInfo, parserPath, lineInfo);
                }
                ++i;
            }
        }
    }

    protected final void removeMacroCallListener(MacroCallListener listener) {
        if (this.fMacroCallListeners == null) {
            return;
        }
        this.fMacroCallListeners.remove(listener);
    }

    protected final List<MacroCallListener> getAndClearExistingMacroCallListeners() {
        if (this.fMacroCallListeners == null) {
            return null;
        }
        ArrayList<MacroCallListener> macroCallListenersCopy = new ArrayList<MacroCallListener>(this.fMacroCallListeners);
        this.fMacroCallListeners.clear();
        return macroCallListenersCopy;
    }

    protected final void setMacroCallListeners(List<MacroCallListener> macroCallListeners) {
        this.fMacroCallListeners = macroCallListeners;
    }

    protected final void clearMacroCallListeners() {
        if (this.fMacroCallListeners == null) {
            return;
        }
        this.fMacroCallListeners.clear();
    }

    protected final void notifyParsingListeners(IParsingInfo info) {
        try {
            this.fUtil.notifyParsingListenersLT(info);
            if (this.fUseMultipleThreads) {
                this.fAsyncLexerBuffer.put(info);
            } else {
                this.fUtil.notifyParsingListenersPT(info);
            }
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void reportErrorLT(String severity, String fileName, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, int offset, int length, String message, int fileIndex, ReparseInfo reparseInfo, Map<String, Object> attributes) {
        try {
            if (this.fUseMultipleThreads) {
                this.fAsyncLexerBuffer.put(new ProblemWrapper(severity, fileName, languageSyntax, line, offset, length, message, fileIndex, reparseInfo, attributes));
            } else {
                this.fUtil.reportError(severity, fileName, languageSyntax, line, offset, length, message, fileIndex, reparseInfo, attributes);
            }
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ReparseInfo createPrevReparseInfo() {
        if (this.fCurrentLexer != null) {
            return new ReparseInfo(this.fCurrentLexer.fReparseStack, null);
        }
        return null;
    }

    public void cfgLibraryDecl(LibrarySpecPath librarySpecPath) {
        String filePath = this.fUtil.getCrossPlatformPath(librarySpecPath.path);
        File file = new File(filePath);
        if (!file.isAbsolute() || !file.exists()) {
            File callerFile = new File(librarySpecPath.fileName);
            String callerParentFile = callerFile.getParent();
            if (callerParentFile != null) {
                filePath = String.valueOf(callerParentFile) + File.separator + filePath;
            }
            file = new File(filePath);
        }
        if (!(filePath.contains("*") || filePath.contains("?") || filePath.contains("...") || file.exists())) {
            if (librarySpecPath.fileName != null) {
                this.fUtil.reportError("*** Error: ", librarySpecPath.fileName, librarySpecPath.languageSyntax, librarySpecPath.line, "No such file or directory: " + filePath, librarySpecPath.fileIndex, null);
            }
            return;
        }
        RfProject rfProject = this.fUtil.getRfProject();
        try {
            rfProject.cfgLibraryDecl(file.getCanonicalPath(), librarySpecPath.libraryName);
        }
        catch (IOException iOException) {
            rfProject.cfgLibraryDecl(file.getAbsolutePath(), librarySpecPath.libraryName);
        }
    }

    public boolean hasEncryptedCodeSupport() {
        return this.fHasEncryptedCodeSupport;
    }

    static class ProblemWrapper {
        private String fSeverity;
        private String fFileName;
        private IBuildConfigParserConstants.LanguageSyntax fLanguageSyntax;
        private int fLine;
        private int fOffset;
        private String fMessage;
        private ReparseInfo fReparseInfo;
        private Map<String, Object> fAttributes;
        private int fLength;
        private int fIndex;

        public ProblemWrapper(String severity, String fileName, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, int offset, int length, String message, int fileIndex, ReparseInfo reparseInfo, Map<String, Object> attributes) {
            this.fSeverity = severity;
            this.fFileName = fileName;
            this.fLanguageSyntax = languageSyntax;
            this.fLine = line;
            this.fOffset = offset;
            this.fLength = length;
            this.fMessage = message;
            this.fIndex = fileIndex;
            this.fReparseInfo = reparseInfo;
            this.fAttributes = attributes;
        }

        public String getSeverity() {
            return this.fSeverity;
        }

        public String getFileName() {
            return this.fFileName;
        }

        public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
            return this.fLanguageSyntax;
        }

        public int getLine() {
            return this.fLine;
        }

        public int getOffset() {
            return this.fOffset;
        }

        public int getLength() {
            return this.fLength;
        }

        public String getMessage() {
            return this.fMessage;
        }

        public ReparseInfo getReparseInfo() {
            return this.fReparseInfo;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public Map<String, Object> getAttributes() {
            return this.fAttributes;
        }
    }

    static class TokenEOF
    extends DVTCustomToken {
        public TokenEOF() {
            super(1, "FORCE INTERRUPT");
        }

        public TokenEOF(DVTCustomToken token) {
            this();
            if (token != null) {
                this.setText(token.getText());
                this.setColumn(token.getColumn());
                this.setLine(token.getLine());
                this.setFileInstance(token.getFileInstance());
                this.setMacroZone(token.getMacroZone());
                this.setLastEofValidToken(token.getLastEofValidToken());
            }
        }

        @Override
        public String getFilename() {
            if (this.getFileInstance() == null) {
                return "";
            }
            return super.getFilename();
        }
    }
}

