/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.parser.IParsingInfo;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogProblem;
import ro.amiq.vlogdt.parser.VlogUtil;
import ro.amiq.vlogdt.ui.persistenttask.TaskInfoWrapper;

public final class VlogLoadedInfo
implements IParsingInfo {
    private ParserPath fParserPath;
    private VlogUtil fUtil;
    private IBuildConfigParserConstants.LanguageSyntax fLanguageSyntax;
    private int fNofRawLines;
    private int fIndex;
    private VlogFileInstance fFileInstance;

    public VlogLoadedInfo(ParserPath parserPath, VlogUtil util, VlogFileInstance fileInstance) {
        this.fParserPath = parserPath;
        this.fUtil = util;
        this.fFileInstance = fileInstance;
    }

    @Override
    public final int getKind() {
        return 2;
    }

    public final ParserPath getParserPath() {
        return this.fParserPath;
    }

    public final List<VlogProblem> getErrors() {
        Set<VlogProblem> problems = this.fUtil.getErrors(this.fParserPath);
        if (problems == null) {
            return null;
        }
        ArrayList<VlogProblem> result = new ArrayList<VlogProblem>(problems.size());
        result.addAll(problems);
        return result;
    }

    public final List<VlogProblem> getWarnings() {
        Set<VlogProblem> problems = this.fUtil.getWarnings(this.fParserPath);
        if (problems == null) {
            return null;
        }
        ArrayList<VlogProblem> result = new ArrayList<VlogProblem>(problems.size());
        result.addAll(problems);
        return result;
    }

    public final List<TaskInfoWrapper> getTaskTags() {
        Set<TaskInfoWrapper> taskInfoWrappers = this.fUtil.getTasks(this.fParserPath);
        if (taskInfoWrappers == null) {
            return null;
        }
        ArrayList<TaskInfoWrapper> result = new ArrayList<TaskInfoWrapper>(taskInfoWrappers.size());
        result.addAll(taskInfoWrappers);
        return result;
    }

    public void setLanguageSyntax(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        this.fLanguageSyntax = languageSyntax;
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return this.fLanguageSyntax;
    }

    public int getNofRawLines() {
        return this.fNofRawLines;
    }

    public void setNofRawLines(int nofRawLines) {
        this.fNofRawLines = nofRawLines;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public void setIndex(int fIndex) {
        this.fIndex = fIndex;
    }

    public boolean isShallowCompiled() {
        return this.fFileInstance != null && this.fFileInstance.isShallowCompiled();
    }
}

