/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.ICommentBlockElement;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.HeaderCommentBlock;
import ro.amiq.vlogdt.model.reflection.IFileDocumentListener;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.views.VlogMacrosViewContributor;
import ro.amiq.vlogdt.parser.IDefinesProvider;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroText;
import ro.amiq.vlogdt.parser.VlogUtil;

public final class VlogMacroInfo
extends RfNamedElement
implements IFileDocumentListener,
ICommentBlockElement,
IMacroInfo {
    private static final long serialVersionUID = 2L;
    public static final int REPLACEMENT_MACRO = 0;
    public static final int IFNDEF_GUARD = 1;
    public static final int CONFIG_DEFINED = 2;
    public static final int CONFIG_UNDEF = 3;
    private boolean fIsUndef;
    private VlogMacroText fMacroText;
    private LineInfo fStartLine;
    private LineInfo fEndLine;
    private VlogFileInstance fInstance;
    private CommentBlock fComment;
    private VlogMacroInfo fPrevMacroInfo;
    private int fMacroKind;
    private ReparseInfo.ReparseElement fReparseElement;
    private transient Position fPosition;
    private transient IDocument fDocument;

    private VlogMacroInfo(RfProject rfProject, VlogFileInstance instance, String rawName, boolean isUndef, VlogMacroText macroText, LineInfo startLine, LineInfo endLine, ReparseInfo reparseInfo) {
        super("", false);
        String name = DVTStringUtil.unescapeIdentifier((String)rawName, (boolean)true);
        boolean isEscaped = name != null && name.length() != rawName.length();
        this.setName(name, isEscaped);
        this.fIsUndef = isUndef;
        if (macroText != null && (macroText.hasParams() || macroText.hasReplacement())) {
            this.fMacroText = macroText;
        }
        this.fStartLine = startLine;
        this.fEndLine = endLine;
        this.fReparseElement = reparseInfo != null ? reparseInfo.getLastReparseElement() : null;
        this.fInstance = instance;
        this.fComment = VlogUtil.getCommentAtLine(this.fInstance, startLine.line, true, startLine.line, true);
        this.setDefComment(this.fComment);
        this.setEnclosingScope(rfProject);
    }

    protected static VlogMacroInfo createDefineVlogMacroInfo(RfProject rfProject, VlogFileInstance instance, String name, VlogMacroText macroText, LineInfo startLine, LineInfo endLine, ReparseInfo reparseInfo) {
        return new VlogMacroInfo(rfProject, instance, name, false, macroText, startLine, endLine, reparseInfo);
    }

    protected static VlogMacroInfo createUndefVlogMacroInfo(RfProject rfProject, VlogFileInstance instance, String name, LineInfo startLine, LineInfo endLine, ReparseInfo reparseInfo) {
        return new VlogMacroInfo(rfProject, instance, name, true, null, startLine, endLine, reparseInfo);
    }

    public static VlogMacroInfo createDummyMacroInfo(RfProject rfProject, String name, String comment) {
        LineInfo line = new LineInfo(-1, -1, -1);
        VlogMacroInfo vlogMacroInfo = new VlogMacroInfo(rfProject, null, name, false, null, line, line, null);
        vlogMacroInfo.fComment = new CommentBlock(null, comment, line.line, false);
        return vlogMacroInfo;
    }

    public final VlogMacroText getMacroText() {
        return this.fMacroText;
    }

    public final boolean isUndef() {
        return this.fIsUndef;
    }

    public final boolean hasParams() {
        return this.fMacroText == null ? false : this.fMacroText.hasParams();
    }

    public final boolean hasReplacement() {
        return this.fMacroText == null ? false : this.fMacroText.hasReplacement();
    }

    @Override
    public final int getLine() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fPosition.getLength() > 0 && this.fDocument != null && (result = this.fPosition.getOffset()) >= 0) {
            this.fStartLine.realOffset = result;
            this.fStartLine.line = DVTDocumentUtils.convertPositionToLine((IDocument)this.fDocument, (int)result);
        }
        return this.fStartLine.line;
    }

    @Override
    public final int getEndLine() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fPosition.getLength() > 0 && this.fDocument != null && (result = this.fPosition.getOffset() + this.fPosition.getLength()) >= 0) {
            this.fEndLine.realOffset = result;
            this.fEndLine.line = DVTDocumentUtils.convertPositionToLine((IDocument)this.fDocument, (int)result);
        }
        return this.fEndLine.line;
    }

    public ParserPath getMacroParserPath() {
        return this.fInstance.getParserPath();
    }

    public final int getOffset() {
        return this.getRealOffset();
    }

    public final int getRealOffset() {
        this.getLine();
        return this.fStartLine.realOffset;
    }

    public final int getEndRealOffset() {
        this.getEndLine();
        return this.fEndLine.realOffset;
    }

    @Override
    public final String getComment() {
        if (this.fComment == null) {
            return "";
        }
        return this.fComment.toString().replaceFirst("^[`]?" + this.getName() + "\\s*", "");
    }

    @Override
    public final boolean hasInlineComment() {
        if (this.fComment == null) {
            return false;
        }
        return this.fComment.hasInlineComment();
    }

    @Override
    public CommentBlock getCommentBlock() {
        return this.fComment;
    }

    public final VlogFileInstance getFileInstance() {
        return this.fInstance;
    }

    public final void setFileInstance(VlogFileInstance fileInstance) {
        this.fInstance = fileInstance;
    }

    public final ReparseInfo.ReparseElement getReparseElement() {
        return this.fReparseElement;
    }

    @Override
    public final String getSignature(RfTypesResolver resolver) {
        return this.getSignature(true, false);
    }

    public final String getSignature(boolean prependTick, boolean asTemplateVariables) {
        String name;
        StringBuilder result = new StringBuilder();
        String string = name = asTemplateVariables ? this.getName().replace("$", "$$") : this.getName();
        if (prependTick) {
            result.append("`").append(name);
        } else {
            result.append(name);
        }
        if (this.fMacroText == null) {
            return result.toString();
        }
        String[] parameters = this.fMacroText.getParameters();
        if (parameters == null || parameters.length == 0) {
            return result.toString();
        }
        String templateStart = asTemplateVariables ? "${" : "";
        String templateEnd = asTemplateVariables ? "}" : "";
        result.append('(');
        int i = 0;
        while (i < parameters.length - 1) {
            String paramName = asTemplateVariables ? parameters[i].replace('$', '_') : parameters[i];
            result.append(templateStart).append(paramName).append(templateEnd).append(", ");
            ++i;
        }
        result.append(templateStart).append(parameters[parameters.length - 1]).append(templateEnd).append(')');
        return result.toString();
    }

    @Override
    public final boolean connectPositionToDocument(IDocument document, Map<Position, Position> cachedPositions, List<Position> reflectionPositions) {
        block7: {
            int offsetEnd;
            int offsetStart;
            block8: {
                block6: {
                    if (document != null) break block6;
                    return false;
                }
                this.fDocument = document;
                if (this.fStartLine.realOffset <= 0 || this.fEndLine.realOffset <= 0) break block7;
                offsetStart = this.fStartLine.realOffset;
                offsetEnd = this.fEndLine.realOffset;
                if (offsetStart >= 0 && offsetEnd >= offsetStart) break block8;
                return false;
            }
            try {
                DVTPosition position = new DVTPosition(offsetStart, offsetEnd - offsetStart);
                Position existingPosition = cachedPositions.get(position);
                if (existingPosition == null) {
                    this.fPosition = position;
                    reflectionPositions.add(this.fPosition);
                    cachedPositions.put(this.fPosition, this.fPosition);
                } else {
                    this.fPosition = existingPosition;
                }
                return true;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public final void removePosition() {
        this.fPosition = null;
        this.fDocument = null;
    }

    @Override
    public boolean isPredefined() {
        String name = this.getName();
        return name.equals("__FILE__") || name.equals("__LINE__") || name.equals("DVT_PATCH") || name.equals("__VAMS_ENABLE__") || name.equals("__VAMS_COMPACT_MODELING__");
    }

    protected final void setPrevMacroInfo(VlogMacroInfo other) {
        this.fPrevMacroInfo = other;
    }

    private final void collectLayers(List<VlogMacroInfo> result) {
        if (this.fPrevMacroInfo != null) {
            this.fPrevMacroInfo.collectLayers(result);
        }
        result.add(this);
    }

    public final List<VlogMacroInfo> getMacroZoneLayers() {
        ArrayList<VlogMacroInfo> result = new ArrayList<VlogMacroInfo>();
        this.collectLayers(result);
        return result;
    }

    @Override
    public void setEnclosingScope(RfNamedElement enclosingScope) {
        super.setEnclosingScope(enclosingScope);
        if (this.fPrevMacroInfo != null) {
            this.fPrevMacroInfo.setEnclosingScope(enclosingScope);
        }
    }

    @Override
    public boolean checkEquals(Object obj) {
        VlogMacroInfo macroInfo;
        String macroInfoName;
        if (super.checkEquals(obj)) {
            return true;
        }
        if (obj instanceof VlogMacroInfo && (macroInfoName = (macroInfo = (VlogMacroInfo)obj).getName()) != null) {
            return macroInfoName.equals(this.getName()) && macroInfo.getRfProject() == this.getRfProject();
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VlogMacroInfo)) {
            return false;
        }
        VlogMacroInfo other = (VlogMacroInfo)obj;
        if (this.fStartLine == null || other.fStartLine == null) {
            return false;
        }
        if (this.getName() == null || other.getName() == null) {
            return false;
        }
        if (this.fInstance == null || other.getFileInstance() == null) {
            return false;
        }
        if (this.fStartLine.line != other.getLine() || !this.getName().equals(other.getName())) {
            return false;
        }
        ParserPath parserPath = this.fInstance.getParserPath();
        return parserPath != null && parserPath.equals((Object)other.getFileInstance().getParserPath());
    }

    @Override
    public int hashCode() {
        String name = this.getName();
        if (name == null) {
            return 0;
        }
        return name.hashCode();
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.PREPROC_DEFINE);
    }

    public String getReplacement(IDefinesProvider definesProvider, String[] parameters, int line, ParserPath parserPath) throws VlogException {
        if (this.fMacroText == null) {
            return "";
        }
        String replacement = VlogMacroInfo.getReplacementForFileLineMacro(this.getName(), line, parserPath);
        if (replacement != null) {
            return replacement;
        }
        return this.fMacroText.getReplacement(definesProvider, parameters);
    }

    public String getReplacement(IDefinesProvider definesProvider, String[] parameters, boolean removeNewLinesInStringParams, int line, ParserPath parserPath) throws VlogException {
        if (this.fMacroText == null) {
            return "";
        }
        String replacement = VlogMacroInfo.getReplacementForFileLineMacro(this.getName(), line, parserPath);
        if (replacement != null) {
            return replacement;
        }
        return this.fMacroText.getReplacement(definesProvider, parameters, removeNewLinesInStringParams);
    }

    public String getReplacement(IDefinesProvider definesProvider, String[] parameters) throws VlogException {
        return this.getReplacement(definesProvider, parameters, 0, null);
    }

    public String getReplacement(IDefinesProvider definesProvider, String[] parameters, boolean removeNewLinesInStringParams) throws VlogException {
        return this.getReplacement(definesProvider, parameters, removeNewLinesInStringParams, 0, null);
    }

    public static String getReplacementForFileLineMacro(String macroName, int line, ParserPath parserPath) {
        if ("__LINE__".equals(macroName)) {
            return String.valueOf(line);
        }
        if ("__FILE__".equals(macroName)) {
            return "\"" + (parserPath == null ? "" : (parserPath.path == null ? "" : parserPath.path)) + "\"";
        }
        return null;
    }

    public String getLabelProviderReplacement() {
        if (this.fMacroText == null) {
            return "";
        }
        return this.fMacroText.getLabelProviderReplacement();
    }

    public Position getPosition() {
        return this.fPosition;
    }

    public void setIfndefGuard() {
        this.fMacroKind = 1;
    }

    public void setUndefConfigMacro() {
        this.fMacroKind = 3;
    }

    public void setDefinedConfigMacro() {
        this.fMacroKind = 2;
    }

    public void setReplacementMacro() {
        this.fMacroKind = 0;
    }

    public boolean isIfndefGuard() {
        return this.fMacroKind == 1;
    }

    public boolean isUndefConfigMacro() {
        return this.fMacroKind == 3;
    }

    public boolean isDefinedConfigMacro() {
        return this.fMacroKind == 2;
    }

    public boolean isReplacementMacro() {
        return this.fMacroKind == 0;
    }

    public void setDefComment(CommentBlock comment) {
        if (comment instanceof HeaderCommentBlock) {
            ((HeaderCommentBlock)comment).setTransientReference((ICommentBlockElement)this);
        }
        this.fComment = comment;
    }

    @Override
    public String getFullNameLabel(RfTypesResolver resolver) {
        return "`" + this.getName();
    }

    public boolean isAutoDefined() {
        return this.fMacroText != null && this.fMacroText.isAutoDefined();
    }

    public VlogMacrosViewContributor.CategoryWrapper getCategory() {
        if (this.isIfndefGuard()) {
            return VlogMacrosViewContributor.VlogMacroType.IFNDEF_GUARD.getCategoryWrapper();
        }
        if (this.isUndefConfigMacro() || this.isDefinedConfigMacro()) {
            return VlogMacrosViewContributor.VlogMacroType.DEF_CONFIGURATION.getCategoryWrapper();
        }
        return VlogMacrosViewContributor.VlogMacroType.REPLACEMENT.getCategoryWrapper();
    }

    public IProject getProject() {
        if (this.getRfProject() == null) {
            return null;
        }
        return this.getRfProject().getProject();
    }
}

