/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IMacroText;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.parser.IDefinesProvider;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroParameter;

public class VlogMacroText
implements Serializable,
IMacroText {
    private static final long serialVersionUID = 1L;
    private static final EnumSet<IBuildConfigParserConstants.ToolCompat> VCS_LIKE_MACRO_EXP_MODES = EnumSet.of(IBuildConfigParserConstants.ToolCompat.QUESTA_VLOG, IBuildConfigParserConstants.ToolCompat.QUESTA_QRUN, IBuildConfigParserConstants.ToolCompat.VCS_VLOGAN);
    private List<VlogMacroParameter> fParameters;
    private List<StringReplace> fReplacement;

    protected VlogMacroText(List<VlogMacroParameter> parameters, List<StringReplace> replacement) {
        this.fParameters = parameters;
        List<Object> list = this.fReplacement = replacement != null && replacement.isEmpty() ? Collections.emptyList() : replacement;
        if (replacement != null && replacement.size() == 1 && VlogMacroText.isNullOrEmpty(replacement.get(0).getString())) {
            this.fReplacement = Collections.emptyList();
        }
    }

    public final boolean hasParams() {
        return this.fParameters != null;
    }

    public final boolean hasReplacement() {
        return this.fReplacement != null && !this.fReplacement.isEmpty();
    }

    protected final int paramsSize() {
        return this.fParameters != null ? this.fParameters.size() : -1;
    }

    public final String getReplacement(IDefinesProvider definesProvider, String[] parameters) throws VlogException {
        return this.getReplacement(definesProvider, parameters, true);
    }

    public final String getReplacement(IDefinesProvider definesProvider, String[] parameters, boolean removeNewLinesInStringParams) throws VlogException {
        boolean isAutoDefinedMacro = this.isAutoDefined();
        if (parameters != null && parameters.length > 0 && !this.hasParams() && !isAutoDefinedMacro) {
            throw new VlogException("*** Error: ", "Number of macro instance parameters " + parameters.length + " not equal to macro define parameters 0");
        }
        if (parameters != null && parameters.length == 0 && this.hasParams() && !isAutoDefinedMacro) {
            throw new VlogException("*** Error: ", "Illegal macro instance; parentheses '()' required");
        }
        if (parameters != null && this.hasParams()) {
            int paramDiff;
            int noDefaults;
            int paramsSize = this.paramsSize();
            if (paramsSize < parameters.length && !isAutoDefinedMacro) {
                throw new VlogException("*** Error: ", "Number of macro instance parameters " + parameters.length + " not equal to macro define parameters " + paramsSize);
            }
            if (paramsSize > parameters.length && (noDefaults = this.numberOfParamsNoDefaults(paramDiff = paramsSize - parameters.length)) != 0 && !isAutoDefinedMacro) {
                throw new VlogException("*** Error: ", "Number of macro instance parameters " + (parameters.length + paramDiff - noDefaults) + " not equal to macro define parameters " + paramsSize);
            }
            if (this.fReplacement == null) {
                return "";
            }
            Object2ObjectMap<String, Replacement> parameterReplacements = this.getParameterReplacements(parameters, removeNewLinesInStringParams);
            StringBuilder result = new StringBuilder();
            for (StringReplace stringReplace : this.fReplacement) {
                if (stringReplace.isReplace()) {
                    CharSequence temp = stringReplace.getString();
                    boolean anyEscaped = parameterReplacements.object2ObjectEntrySet().stream().anyMatch(entry -> ((Replacement)entry.getValue()).isEscaped);
                    temp = anyEscaped ? this.parameterReplace(definesProvider, parameterReplacements, temp) : this.parameterReplaceNoEscaped(definesProvider, parameterReplacements, temp);
                    result.append(temp);
                    continue;
                }
                result.append(stringReplace.getString());
            }
            result = VlogMacroText.cleanup(definesProvider, result);
            return result.toString();
        }
        if (this.fReplacement == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (StringReplace stringReplace : this.fReplacement) {
            result.append(stringReplace.getString());
        }
        result = VlogMacroText.cleanup(definesProvider, result);
        return result.toString();
    }

    public boolean isAutoDefined() {
        List<VlogMacroParameter> macroParameters = this.getMacroParameters();
        if (macroParameters == null || macroParameters.size() != 1) {
            return false;
        }
        VlogMacroParameter vlogMacroParameter = macroParameters.get(0);
        if (vlogMacroParameter == null) {
            return false;
        }
        return "params".equals(vlogMacroParameter.getName()) && "__dvt_encrypted_code_auto_macro__".equals(vlogMacroParameter.getValue());
    }

    private final Object2ObjectMap<String, Replacement> getParameterReplacements(String[] parameters, boolean removeNewLinesInStringParams) {
        Object2ObjectOpenHashMap parameterReplacements = new Object2ObjectOpenHashMap(OptimizedUtils.noRehashSize((int)this.fParameters.size()));
        int i = 0;
        while (i < this.fParameters.size()) {
            String parameterName;
            int length;
            String parameter;
            CharSequence parameterValue;
            VlogMacroParameter macroParameter = this.fParameters.get(i);
            String defaultValue = macroParameter.getValue();
            String string = parameterValue = defaultValue == null ? "" : defaultValue;
            if (parameters.length > i && !VlogMacroText.isNullOrEmpty(parameter = parameters[i])) {
                parameterValue = removeNewLinesInStringParams || parameter.indexOf(34) == -1 ? this.removeNewLines(parameter) : parameter;
            }
            if ((length = (parameterName = macroParameter.getName()).length()) > 0 && parameterName.charAt(0) == '\\' && parameterName.charAt(length - 1) == '\ufff0') {
                parameterName = parameterName.substring(0, length - 1);
                parameterReplacements.put((Object)parameterName, (Object)new Replacement(true, parameterValue));
                String unescapedParameterName = parameterName.substring(1);
                if (RfReferencesUtils.isValidIndentifierName((String)unescapedParameterName)) {
                    parameterReplacements.put((Object)unescapedParameterName, (Object)new Replacement(false, parameterValue));
                }
            } else {
                parameterReplacements.put((Object)parameterName, (Object)new Replacement(false, parameterValue));
            }
            ++i;
        }
        return parameterReplacements;
    }

    private static final boolean isNullOrEmpty(String text) {
        if (text == null) {
            return true;
        }
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (!Character.isWhitespace(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final String getLabelProviderReplacement() {
        if (this.fReplacement == null || this.hasParams()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (StringReplace stringReplace : this.fReplacement) {
            if (stringReplace.getString() == null) continue;
            result.append(stringReplace.getString());
            break;
        }
        return result.toString();
    }

    private final StringBuilder removeNewLines(CharSequence text) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch == '\r' && i < length - 1 && text.charAt(i + 1) == '\n') {
                result.append(' ');
                ++i;
            } else if (ch == '\r' || ch == '\n') {
                result.append(' ');
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result;
    }

    protected static final StringBuilder cleanup(IDefinesProvider definesProvider, CharSequence text) throws VlogException {
        VlogMacroInfo macro;
        if (text == null) {
            return null;
        }
        CLEANUP_STATE state = CLEANUP_STATE.TRIM_WS;
        StringBuilder result = new StringBuilder();
        int length = text.length();
        int offset = 0;
        boolean backslash = false;
        boolean oddnticks = false;
        boolean vcsCompatMode = definesProvider != null && VCS_LIKE_MACRO_EXP_MODES.contains(definesProvider.getToolCompat());
        boolean vcsCompatMode2 = definesProvider != null && IBuildConfigParserConstants.ToolCompat.VCS_VLOGAN == definesProvider.getToolCompat();
        boolean lastIdIsMacro = false;
        boolean isDefineConcat = false;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            switch (state) {
                case TRIM_WS: {
                    lastIdIsMacro = false;
                    if (ch == ' ' || ch == '\t' || ch == '\f') {
                        state = CLEANUP_STATE.TRIM_WS;
                        break;
                    }
                    if (i < length - 1 && ch == '`' && text.charAt(i + 1) == '`') {
                        ++i;
                        oddnticks = !oddnticks;
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (ch == '\"') {
                        result.append(ch);
                        state = CLEANUP_STATE.STRING;
                        break;
                    }
                    if (ch == '`' && i < length - 1) {
                        offset = result.length();
                        result.append(ch);
                        char nc = text.charAt(i + 1);
                        if (!oddnticks && nc == '\\') {
                            state = CLEANUP_STATE.DEFINE_ESC;
                            break;
                        }
                        if (!oddnticks && Character.isJavaIdentifierStart(nc)) {
                            state = CLEANUP_STATE.DEFINE;
                            break;
                        }
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (ch == '\ufffe') {
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (ch == '\\') {
                        result.append(ch);
                        state = CLEANUP_STATE.TEXT_ESC;
                        break;
                    }
                    result.append(ch);
                    state = CLEANUP_STATE.TEXT;
                    break;
                }
                case TEXT: {
                    lastIdIsMacro = false;
                    if (i < length - 1 && ch == '`' && text.charAt(i + 1) == '`') {
                        ++i;
                        oddnticks = !oddnticks;
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (ch == '\"' && !backslash) {
                        boolean tick;
                        result.append(ch);
                        boolean bl = tick = oddnticks || vcsCompatMode2 && i > 0 && text.charAt(i - 1) == '`';
                        if (!tick) {
                            state = CLEANUP_STATE.STRING;
                            break;
                        }
                        state = CLEANUP_STATE.STRING_DEF;
                        break;
                    }
                    if (ch == '`' && i < length - 1) {
                        offset = result.length();
                        isDefineConcat = result.length() > 0 && Character.isJavaIdentifierPart(result.charAt(result.length() - 1));
                        result.append(ch);
                        char nc = text.charAt(i + 1);
                        if (!oddnticks && nc == '\\') {
                            state = CLEANUP_STATE.DEFINE_ESC;
                            break;
                        }
                        if (!oddnticks && Character.isJavaIdentifierStart(nc)) {
                            state = CLEANUP_STATE.DEFINE;
                            break;
                        }
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (ch == '\ufffe') {
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (ch == '\\') {
                        result.append(ch);
                        state = CLEANUP_STATE.TEXT_ESC;
                        break;
                    }
                    result.append(ch);
                    state = CLEANUP_STATE.TEXT;
                    break;
                }
                case TEXT_ESC: {
                    lastIdIsMacro = false;
                    if (Character.isWhitespace(ch)) {
                        result.append(ch);
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (i < length - 1 && ch == '`' && text.charAt(i + 1) == '`') {
                        ++i;
                        oddnticks = !oddnticks;
                        state = CLEANUP_STATE.TEXT_ESC;
                        break;
                    }
                    if (ch == '\ufffe') {
                        state = CLEANUP_STATE.TEXT_ESC;
                        break;
                    }
                    result.append(ch);
                    state = CLEANUP_STATE.TEXT_ESC;
                    break;
                }
                case DEFINE: {
                    String replacement;
                    lastIdIsMacro = false;
                    if (definesProvider != null && vcsCompatMode && i < length - 2 && ch == '`' && text.charAt(i + 1) == '`' && VlogMacroText.followingCharIsIdentifierPart(text, i + 2)) {
                        VlogMacroInfo macro2 = definesProvider.getSimpleDefine(result.substring(offset + 1));
                        if (macro2 != null && !macro2.hasParams()) {
                            result.delete(offset, result.length());
                            replacement = macro2.getReplacement(definesProvider, null);
                            if (!VlogMacroText.isNullOrEmpty(replacement)) {
                                result.append(replacement.trim());
                            }
                        }
                        ++i;
                        oddnticks = !oddnticks;
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (i < length - 1 && ch == '`' && text.charAt(i + 1) == '`') {
                        ++i;
                        oddnticks = !oddnticks;
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (ch == '\"' && !backslash) {
                        result.append(ch);
                        state = CLEANUP_STATE.STRING;
                        break;
                    }
                    if (ch == '\ufffe') {
                        state = CLEANUP_STATE.DEFINE;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(ch)) {
                        result.append(ch);
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    result.append(ch);
                    state = CLEANUP_STATE.DEFINE;
                    break;
                }
                case DEFINE_ESC: {
                    String replacement;
                    lastIdIsMacro = false;
                    if (definesProvider != null && vcsCompatMode && i < length - 3 && Character.isWhitespace(ch) && text.charAt(i + 1) == '`' && text.charAt(i + 2) == '`' && VlogMacroText.followingCharIsIdentifierPart(text, i + 3)) {
                        VlogMacroInfo macro3 = definesProvider.getSimpleDefine(String.valueOf(result.substring(offset + 1)) + '\ufff0');
                        if (macro3 != null && !macro3.hasParams()) {
                            result.delete(offset, result.length());
                            replacement = macro3.getReplacement(definesProvider, null);
                            if (!VlogMacroText.isNullOrEmpty(replacement)) {
                                result.append(replacement.trim());
                            }
                        }
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (ch == '\ufffe') {
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        result.append(ch);
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    result.append(ch);
                    state = CLEANUP_STATE.DEFINE_ESC;
                    break;
                }
                case STRING: {
                    lastIdIsMacro = false;
                    if (ch == '\"' && !backslash) {
                        result.append(ch);
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    result.append(ch);
                    state = CLEANUP_STATE.STRING;
                    break;
                }
                case STRING_DEF: {
                    if (ch == '\"' && !backslash) {
                        lastIdIsMacro = false;
                        result.append(ch);
                        state = CLEANUP_STATE.TEXT;
                        break;
                    }
                    if (!lastIdIsMacro && i < length - 1 && ch == '`' && text.charAt(i + 1) == '`' || lastIdIsMacro && i < length - 2 && ch == '`' && text.charAt(i + 1) == '`' && !Character.isJavaIdentifierPart(text.charAt(i + 2)) || lastIdIsMacro && i == length - 2 && ch == '`' && text.charAt(i + 1) == '`') {
                        lastIdIsMacro = false;
                        ++i;
                        oddnticks = !oddnticks;
                        state = CLEANUP_STATE.STRING_DEF;
                        break;
                    }
                    if (i < length - 1 && ch == '`' && Character.isJavaIdentifierPart(text.charAt(i + 1))) {
                        result.append(ch);
                        lastIdIsMacro = true;
                        state = CLEANUP_STATE.STRING_DEF;
                        break;
                    }
                    if (ch == '\ufffe') {
                        state = CLEANUP_STATE.STRING_DEF;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(ch)) {
                        lastIdIsMacro = false;
                    }
                    result.append(ch);
                    state = CLEANUP_STATE.STRING_DEF;
                }
            }
            backslash = ch == '\\' && !backslash;
            oddnticks = ch == '`' && !oddnticks;
            ++i;
        }
        if (isDefineConcat && definesProvider != null && vcsCompatMode && state == CLEANUP_STATE.DEFINE && (macro = definesProvider.getSimpleDefine(result.substring(offset + 1))) != null && !macro.hasParams()) {
            result.delete(offset, result.length());
            String replacement = macro.getReplacement(definesProvider, null);
            if (!VlogMacroText.isNullOrEmpty(replacement)) {
                result.append(replacement.trim());
            }
        }
        return result;
    }

    private static final boolean followingCharIsIdentifierPart(CharSequence text, int offset) {
        int length = text.length();
        int i = offset;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch != '\ufffe') {
                return Character.isJavaIdentifierPart(ch) || ch == '\\';
            }
            ++i;
        }
        return false;
    }

    private final CharSequence parameterReplace(IDefinesProvider definesProvider, Object2ObjectMap<String, Replacement> parameterReplacements, CharSequence text) {
        StringBuilder result = new StringBuilder();
        boolean vcsCompatMode2 = definesProvider != null && IBuildConfigParserConstants.ToolCompat.VCS_VLOGAN == definesProvider.getToolCompat();
        int length = text.length();
        REPLACE_STATE state = REPLACE_STATE.ALLOW_REPLACE;
        boolean backtickString = false;
        boolean backslash = false;
        boolean oddnticks = false;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            block0 : switch (state) {
                case ALLOW_REPLACE: {
                    boolean tick;
                    boolean bl = tick = oddnticks || vcsCompatMode2 && i > 0 && text.charAt(i - 1) == '`';
                    if (ch == '\"' && i > 0 && (backtickString && !backslash || tick)) {
                        backtickString = !backtickString;
                    } else if (ch == '\"' && (i == 0 || !tick && !backslash)) {
                        state = REPLACE_STATE.DISALLOW_REPLACE_IN_STRING;
                    }
                    result.append(ch);
                    for (Object2ObjectMap.Entry parameterReplacement : parameterReplacements.object2ObjectEntrySet()) {
                        String parameter = (String)parameterReplacement.getKey();
                        boolean isEscaped = ((Replacement)parameterReplacement.getValue()).isEscaped;
                        CharSequence replacement = ((Replacement)parameterReplacement.getValue()).parameterValue;
                        int nameLength = parameter.length();
                        if ((isEscaped || !Character.isJavaIdentifierPart(ch)) && (!isEscaped || i >= length - 1 || !Character.isWhitespace(text.charAt(i + 1))) || !this.endsWith(result, parameter) || i != length - 1 && Character.isJavaIdentifierPart(text.charAt(i + 1)) || i != nameLength - 1 && Character.isJavaIdentifierPart(text.charAt(i - nameLength)) && (!isEscaped || text.charAt(i - nameLength + 1) != '\\')) continue;
                        if (i < length - 1 && Character.isWhitespace(text.charAt(i + 1)) && text.charAt(i - nameLength) == '\\') {
                            ++i;
                            ++nameLength;
                        }
                        result.delete(result.length() - nameLength, result.length());
                        result.append('\ufffe');
                        result.append(replacement);
                        result.append('\ufffe');
                        if (!isEscaped) break block0;
                        ++i;
                        break block0;
                    }
                    break;
                }
                case DISALLOW_REPLACE_IN_STRING: {
                    if (ch == '\"' && (i == 0 || text.charAt(i - 1) != '`' && !backslash)) {
                        state = REPLACE_STATE.ALLOW_REPLACE;
                    }
                    result.append(ch);
                }
            }
            backslash = ch == '\\' && !backslash;
            oddnticks = ch == '`' && !oddnticks;
            ++i;
        }
        return result;
    }

    private final CharSequence parameterReplaceNoEscaped(IDefinesProvider definesProvider, Object2ObjectMap<String, Replacement> parameterReplacements, CharSequence text) {
        StringBuilder result = new StringBuilder();
        boolean vcsCompatMode2 = definesProvider != null && IBuildConfigParserConstants.ToolCompat.VCS_VLOGAN == definesProvider.getToolCompat();
        int length = text.length();
        REPLACE_STATE state = REPLACE_STATE.ALLOW_REPLACE;
        boolean backtickString = false;
        boolean backslash = false;
        boolean oddnticks = false;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            block0 : switch (state) {
                case ALLOW_REPLACE: {
                    boolean tick;
                    boolean bl = tick = oddnticks || vcsCompatMode2 && i > 0 && text.charAt(i - 1) == '`';
                    if (ch == '\"' && i > 0 && (backtickString && !backslash || tick)) {
                        backtickString = !backtickString;
                    } else if (ch == '\"' && (i == 0 || !tick && !backslash)) {
                        state = REPLACE_STATE.DISALLOW_REPLACE_IN_STRING;
                    }
                    result.append(ch);
                    if (i != length - 1 && (!Character.isJavaIdentifierPart(ch) || Character.isJavaIdentifierPart(text.charAt(i + 1)))) break;
                    for (Object2ObjectMap.Entry parameterReplacement : parameterReplacements.object2ObjectEntrySet()) {
                        String parameter = (String)parameterReplacement.getKey();
                        CharSequence replacement = ((Replacement)parameterReplacement.getValue()).parameterValue;
                        int nameLength = parameter.length();
                        if (i < nameLength || Character.isJavaIdentifierPart(text.charAt(i - nameLength)) || !this.endsWith(result, parameter)) continue;
                        if (i < length - 1 && Character.isWhitespace(text.charAt(i + 1)) && text.charAt(i - nameLength) == '\\') {
                            ++i;
                            ++nameLength;
                        }
                        result.delete(result.length() - nameLength, result.length());
                        result.append('\ufffe');
                        result.append(replacement);
                        result.append('\ufffe');
                        break block0;
                    }
                    break;
                }
                case DISALLOW_REPLACE_IN_STRING: {
                    if (ch == '\"' && (i == 0 || text.charAt(i - 1) != '`' && !backslash)) {
                        state = REPLACE_STATE.ALLOW_REPLACE;
                    }
                    result.append(ch);
                }
            }
            backslash = ch == '\\' && !backslash;
            oddnticks = ch == '`' && !oddnticks;
            ++i;
        }
        return result;
    }

    private final boolean endsWith(CharSequence text, CharSequence suffix) {
        int length = text.length();
        int offset = length - suffix.length();
        if (offset < 0) {
            return false;
        }
        int i = offset;
        while (i < length) {
            if (text.charAt(i) != suffix.charAt(i - offset)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final int numberOfParamsNoDefaults(int lastParameters) {
        int noDefaults = 0;
        int i = 0;
        while (i < lastParameters) {
            VlogMacroParameter parameter = this.fParameters.get(this.fParameters.size() - 1 - i);
            if (parameter.getValue() == null) {
                ++noDefaults;
            }
            ++i;
        }
        return noDefaults;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        boolean hasParams1 = this.hasParams();
        boolean hasReplacement1 = this.hasReplacement();
        if (o == null && !hasParams1 && !hasReplacement1) {
            return true;
        }
        if (!(o instanceof VlogMacroText)) {
            return false;
        }
        VlogMacroText tmp = (VlogMacroText)o;
        boolean hasParams2 = tmp.hasParams();
        boolean hasReplacement2 = tmp.hasReplacement();
        if (!(hasParams2 || hasParams1 || hasReplacement2 || hasReplacement1)) {
            return true;
        }
        if (hasParams2 && !hasParams1 || !hasParams2 && hasParams1) {
            return false;
        }
        if (hasReplacement2 && !hasReplacement1 || !hasReplacement2 && hasReplacement1) {
            return false;
        }
        if (hasParams2 && hasParams1 && !tmp.fParameters.equals(this.fParameters)) {
            return false;
        }
        return !hasReplacement2 || !hasReplacement1 || tmp.fReplacement.equals(this.fReplacement);
    }

    public final String[] getParameters() {
        if (this.fParameters == null) {
            return null;
        }
        String[] result = new String[this.fParameters.size()];
        int i = 0;
        while (i < this.fParameters.size()) {
            result[i] = this.fParameters.get(i).toString();
            ++i;
        }
        return result;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public List<StringReplace> getReplacement() {
        return this.fReplacement;
    }

    public final List<VlogMacroParameter> getMacroParameters() {
        return this.fParameters;
    }

    private static enum CLEANUP_STATE {
        TRIM_WS,
        TEXT,
        TEXT_ESC,
        DEFINE,
        DEFINE_ESC,
        STRING,
        STRING_DEF;

    }

    private static enum REPLACE_STATE {
        ALLOW_REPLACE,
        DISALLOW_REPLACE_IN_STRING;

    }

    private static class Replacement {
        private boolean isEscaped;
        private CharSequence parameterValue;

        public Replacement(boolean isEscaped, CharSequence parameterValue) {
            this.isEscaped = isEscaped;
            this.parameterValue = parameterValue;
        }
    }
}

