/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledAutoDebugUtils;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class VlogMacroZone
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient DVTLinkedHashMap<String, VlogMacroInfo> fMacroMap;
    private VlogFileInstance fIncludedFile;
    private VlogMacroZone fPrevZone;
    private volatile int fIndex;

    public VlogMacroZone(VlogMacroZone prevMacroZone) {
        this.fPrevZone = prevMacroZone;
        this.fIndex = -1;
    }

    public void setPrevZone(VlogMacroZone macroZone) {
        this.fPrevZone = macroZone;
        this.fIndex = -1;
    }

    public VlogMacroZone getPrevZone() {
        return this.fPrevZone;
    }

    public void setIncludedFile(VlogFileInstance includedFile) {
        this.fIncludedFile = includedFile;
    }

    public VlogFileInstance getIncludedFile() {
        return this.fIncludedFile;
    }

    public VlogMacroInfo getMacroInfo(String name) {
        if (this.fMacroMap == null) {
            return null;
        }
        return (VlogMacroInfo)this.fMacroMap.get((Object)name);
    }

    public void putMacroInfo(String name, VlogMacroInfo info) {
        if (this.fMacroMap == null) {
            this.fMacroMap = new DVTLinkedHashMap();
        }
        this.fMacroMap.put((Object)name, (IDVTMapElement)info);
    }

    public void putAllMacroInfo(Collection<VlogMacroInfo> macroInfos) {
        if (this.fMacroMap == null) {
            this.fMacroMap = new DVTLinkedHashMap();
        }
        for (VlogMacroInfo macroInfo : macroInfos) {
            this.fMacroMap.put(null, (IDVTMapElement)macroInfo);
        }
    }

    public Collection<VlogMacroInfo> getMacroInfos() {
        if (this.fMacroMap == null) {
            return Collections.emptyList();
        }
        return this.fMacroMap.values();
    }

    public void clear() {
        if (this.fMacroMap != null) {
            this.fMacroMap.clear();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PrecompiledAutoDebugUtils.INSTANCE.objectWritten((Object)this);
        int size = this.fMacroMap == null ? 0 : this.fMacroMap.size();
        out.writeInt(size);
        if (this.fMacroMap == null) {
            return;
        }
        for (VlogMacroInfo macro : this.fMacroMap.values()) {
            out.writeObject(macro);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        if (size == 0) {
            return;
        }
        this.fMacroMap = new DVTLinkedHashMap();
        int i = 0;
        while (i < size) {
            VlogMacroInfo macro = (VlogMacroInfo)in.readObject();
            this.fMacroMap.put(null, (IDVTMapElement)macro);
            ++i;
        }
    }

    public void deepClean() {
        if (this.fMacroMap != null) {
            this.fMacroMap.deepClean();
        }
        this.fMacroMap = null;
        if (this.fIncludedFile != null) {
            VlogFileInstance includedFile = this.fIncludedFile;
            this.fIncludedFile = null;
            includedFile.deepClean();
        }
        this.fPrevZone = null;
        this.fIndex = -1;
    }

    public int getIndex() {
        return VlogMacroZone.getIndex(this);
    }

    private static synchronized int getIndex(VlogMacroZone macroZone) {
        if (macroZone.fIndex > -1) {
            return macroZone.fIndex;
        }
        macroZone.fIndex = 0;
        Set visitedMacroZones = Collections.newSetFromMap(new IdentityHashMap());
        VlogMacroZone prevMacroZone = macroZone;
        while (prevMacroZone != null && prevMacroZone.fPrevZone != null) {
            if (visitedMacroZones.contains(prevMacroZone)) break;
            visitedMacroZones.add(prevMacroZone);
            if (prevMacroZone.fIndex > 0) {
                macroZone.fIndex += prevMacroZone.fIndex;
                break;
            }
            prevMacroZone = prevMacroZone.fPrevZone;
            ++macroZone.fIndex;
        }
        return macroZone.fIndex;
    }

    public int getInvocNumber() {
        VlogMacroZone macroZone = this;
        while (macroZone != null) {
            if (macroZone.fIncludedFile != null) {
                return macroZone.fIncludedFile.getInvocNumber();
            }
            macroZone = macroZone.fPrevZone;
        }
        return -1;
    }

    private ParserPath extractParserPath() {
        VlogFileInstance prevFileInstance = this.getIncludedFile();
        if (prevFileInstance != null) {
            return prevFileInstance.getParserPath();
        }
        return null;
    }

    private ParserPath getParserPath(boolean startFromFirst) {
        VlogMacroZone macroZone = this;
        VlogFileInstance includedFile = macroZone.getIncludedFile();
        if (includedFile != null) {
            VlogMacroZone prevMacroZone = macroZone.getPrevZone();
            return prevMacroZone.getIncludedFile() == null ? prevMacroZone.getParserPath(true) : prevMacroZone.extractParserPath();
        }
        int counter = startFromFirst ? 1 : 0;
        while (counter >= 0) {
            includedFile = (macroZone = macroZone.getPrevZone()).getIncludedFile();
            if (includedFile == null) {
                ++counter;
                continue;
            }
            --counter;
        }
        return includedFile == null ? null : includedFile.getParserPath();
    }

    public ParserPath getParserPath() {
        return this.getParserPath(false);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    private void clearIndex() {
        this.fIndex = -1;
    }

    public void clearAllPreviousIndices() {
        VlogMacroZone macroZone = this;
        while (macroZone != null) {
            macroZone.clearIndex();
            macroZone = macroZone.fPrevZone;
        }
    }
}

