/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.OptimizedHashMap;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.EncryptedPragmaInfo;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;

public class VlogPreprocessingInfo
implements Serializable {
    private static final long serialVersionUID = 7L;
    private VlogFileInstance fTopFilesInstance;
    private Map<ParserPath, List<RfMacroRefInfo>> fMacroRefsMapByFile;
    private Map<ParserPath, CodePreprocFileInfo> fCodePreprocFileInfos;
    private Map<ParserPath, Set<EncryptedPragmaInfo>> fEncryptedPragmaFileInfos;
    private Map<VlogFileInstance, List<String>> fFileNotFoundToInstanceMap;
    private transient Map<ParserPath, List<SVTBIssues>> fSVTBIssuesByFile;
    private transient Map<ParserPath, List<PostWaiver>> fWaiverPragmasByFile;

    public VlogPreprocessingInfo(RfProject rfProject) {
        this.fTopFilesInstance = new VlogFileInstance(rfProject, null, new VlogIncludingScope(null, -1, -1), 0, Collections.emptyList(), 0, false, false, false, IBuildConfigParserConstants.ToolCompat.DVT, false);
    }

    @NotNull
    public final VlogFileInstance getTopFileInstance() {
        return this.fTopFilesInstance;
    }

    public final void clear() {
        if (this.fTopFilesInstance != null) {
            this.fTopFilesInstance.clear(true);
        }
        if (this.fMacroRefsMapByFile != null) {
            this.fMacroRefsMapByFile.clear();
        }
        if (this.fCodePreprocFileInfos != null) {
            this.fCodePreprocFileInfos.clear();
        }
        if (this.fEncryptedPragmaFileInfos != null) {
            this.fEncryptedPragmaFileInfos.clear();
        }
        if (this.fSVTBIssuesByFile != null) {
            this.fSVTBIssuesByFile.clear();
        }
        if (this.fWaiverPragmasByFile != null) {
            this.fWaiverPragmasByFile.clear();
        }
        if (this.fFileNotFoundToInstanceMap != null) {
            this.fFileNotFoundToInstanceMap.clear();
        }
    }

    public void clear(ParserPath parserPath) {
        if (this.fMacroRefsMapByFile != null) {
            this.fMacroRefsMapByFile.remove(parserPath);
        }
        if (this.fCodePreprocFileInfos != null) {
            this.fCodePreprocFileInfos.remove(parserPath);
        }
        if (this.fEncryptedPragmaFileInfos != null) {
            this.fEncryptedPragmaFileInfos.remove(parserPath);
        }
        if (this.fSVTBIssuesByFile != null) {
            this.fSVTBIssuesByFile.remove(parserPath);
        }
        if (this.fWaiverPragmasByFile != null) {
            this.fWaiverPragmasByFile.remove(parserPath);
        }
    }

    public final void cleanAllComments(boolean recursive) {
        if (this.fTopFilesInstance == null) {
            return;
        }
        this.fTopFilesInstance.cleanAllComments(recursive);
    }

    public Map<ParserPath, List<RfMacroRefInfo>> getMacroRefsMapByFile() {
        if (this.fMacroRefsMapByFile == null) {
            this.fMacroRefsMapByFile = new OptimizedLinkedHashMap();
        }
        return this.fMacroRefsMapByFile;
    }

    public Map<ParserPath, CodePreprocFileInfo> getCodePreprocFileInfos() {
        if (this.fCodePreprocFileInfos == null) {
            this.fCodePreprocFileInfos = new OptimizedHashMap();
        }
        return this.fCodePreprocFileInfos;
    }

    public Map<ParserPath, Set<EncryptedPragmaInfo>> getEncrypedPragmaFileInfos() {
        if (this.fEncryptedPragmaFileInfos == null) {
            this.fEncryptedPragmaFileInfos = new OptimizedHashMap();
        }
        return this.fEncryptedPragmaFileInfos;
    }

    public Map<ParserPath, List<SVTBIssues>> getSVTBIssuesMap() {
        if (this.fSVTBIssuesByFile == null) {
            this.fSVTBIssuesByFile = new OptimizedHashMap();
        }
        return this.fSVTBIssuesByFile;
    }

    public Map<ParserPath, List<PostWaiver>> getWaiverPragmasMap() {
        if (this.fWaiverPragmasByFile == null) {
            this.fWaiverPragmasByFile = new OptimizedHashMap();
        }
        return this.fWaiverPragmasByFile;
    }

    public Map<VlogFileInstance, List<String>> getFileNotFoundMap() {
        if (this.fFileNotFoundToInstanceMap == null) {
            this.fFileNotFoundToInstanceMap = new OptimizedHashMap();
        }
        return this.fFileNotFoundToInstanceMap;
    }

    public List<PostWaiver> getAllWaivers() {
        ArrayList<PostWaiver> results = new ArrayList<PostWaiver>();
        for (List<PostWaiver> waivers : this.getWaiverPragmasMap().values()) {
            for (PostWaiver waiver : waivers) {
                results.add(waiver.clone());
            }
        }
        return results;
    }

    public void addSVTBIssue(ParserPath parserPath, int kind, int line, int offset, int virtualOffset, int optional, String info, String additionalInfo, String extraAdditionalInfo, Map<String, Object> meta, ReparseInfo reparseInfo) {
        this.fSVTBIssuesByFile = this.getSVTBIssuesMap();
        List<SVTBIssues> issuesInFile = this.fSVTBIssuesByFile.get(parserPath);
        if (issuesInFile == null) {
            issuesInFile = new ArrayList<SVTBIssues>();
            this.fSVTBIssuesByFile.put(parserPath, issuesInFile);
        }
        issuesInFile.add(new SVTBIssues(kind, line, offset, virtualOffset, optional, info, additionalInfo, extraAdditionalInfo, meta, reparseInfo));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void deepClean() {
        if (this.fTopFilesInstance != null) {
            this.fTopFilesInstance.deepClean();
        }
        if (this.fMacroRefsMapByFile != null) {
            this.fMacroRefsMapByFile.clear();
        }
        if (this.fCodePreprocFileInfos != null) {
            this.fCodePreprocFileInfos.clear();
        }
        if (this.fSVTBIssuesByFile != null) {
            this.fSVTBIssuesByFile.clear();
        }
        if (this.fWaiverPragmasByFile != null) {
            this.fWaiverPragmasByFile.clear();
        }
        if (this.fFileNotFoundToInstanceMap != null) {
            this.fFileNotFoundToInstanceMap.clear();
        }
    }

    public void includedFileNotFound(VlogFileInstance fileInstance, String fileName) {
        List<String> paths;
        if (this.fFileNotFoundToInstanceMap == null) {
            this.fFileNotFoundToInstanceMap = new OptimizedLinkedHashMap();
        }
        if ((paths = this.fFileNotFoundToInstanceMap.get(fileInstance)) == null) {
            paths = new ArrayList<String>(2);
            this.fFileNotFoundToInstanceMap.put(fileInstance, paths);
        }
        IPath filePath = Path.fromOSString((String)fileName);
        paths.add(filePath.lastSegment());
    }

    public void clearIncludedFileNotFound(VlogFileInstance fileInstance) {
        if (this.fFileNotFoundToInstanceMap != null) {
            this.fFileNotFoundToInstanceMap.remove(fileInstance);
        }
    }

    public List<VlogFileInstance> getInstancesToRecompile(IPath filePath) {
        ArrayList<VlogFileInstance> result = new ArrayList<VlogFileInstance>();
        if (filePath == null) {
            return result;
        }
        if (this.fFileNotFoundToInstanceMap == null) {
            return result;
        }
        String lastSegment = filePath.lastSegment();
        if (lastSegment == null) {
            return result;
        }
        for (Map.Entry<VlogFileInstance, List<String>> entry : this.fFileNotFoundToInstanceMap.entrySet()) {
            VlogFileInstance fileInstance = entry.getKey();
            List<String> paths = entry.getValue();
            if (paths == null || paths.isEmpty()) continue;
            for (String path : paths) {
                if (!lastSegment.equals(path)) continue;
                result.add(fileInstance);
            }
        }
        return result;
    }

    public void lintClean() {
        if (this.fSVTBIssuesByFile == null) {
            return;
        }
        this.fSVTBIssuesByFile.values().forEach(issuePerFile -> issuePerFile.clear());
        this.fSVTBIssuesByFile.clear();
    }
}

