/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.Serializable;
import java.util.Map;
import ro.amiq.dvt.model.problems.ISourceProblem;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class VlogProblem
implements ISourceProblem,
Serializable {
    private static final long serialVersionUID = 1L;
    private int fSeverity;
    private int fLine;
    private int fOffsetStart;
    private int fOffsetEnd;
    private String fFileName;
    private String fMessage;
    private ReparseInfo fReparseInfo;
    private String fPrefix;
    private int fFileIndex;
    private int fInvocNumber;
    private Map<String, Object> fAttributes;
    private transient Severity fSeverityAfterWaive;

    public VlogProblem(int severity, String filename, String prefix, int line, String message, int fileIndex, ReparseInfo reparseInfo, int invocNumber) {
        this.fFileName = DVTStringUtil.intern((String)Utils.canonicPath((String)filename));
        this.fLine = line;
        this.fMessage = message;
        this.fPrefix = DVTStringUtil.intern((String)prefix);
        this.fReparseInfo = reparseInfo;
        this.fFileIndex = fileIndex;
        this.fSeverity = severity;
        this.fInvocNumber = invocNumber;
    }

    public int getInvocNumber() {
        return this.fInvocNumber;
    }

    public int getLine() {
        return this.fLine;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.fAttributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    public void setOffsetStart(int offsetStart) {
        this.fOffsetStart = offsetStart;
    }

    public void setOffsetEnd(int offsetEnd) {
        this.fOffsetEnd = offsetEnd;
    }

    public int getOffsetStart() {
        return this.fOffsetStart;
    }

    public int getOffsetEnd() {
        return this.fOffsetEnd;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public int getFileIndex() {
        return this.fFileIndex;
    }

    public String getMessage(boolean prependPrefix) {
        if (prependPrefix &= this.fPrefix != null) {
            if (this.fFileIndex <= 0 && this.fFileIndex != -1) {
                return DVTStringUtil.appendString((Object[])new Object[]{"_", this.fPrefix, " ", this.fMessage});
            }
            return DVTStringUtil.appendString((Object[])new Object[]{this.fPrefix, " ", this.fMessage});
        }
        if (this.fFileIndex <= 0 && this.fFileIndex != -1) {
            return DVTStringUtil.appendString((Object[])new Object[]{"_", this.fMessage});
        }
        return this.fMessage;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public ReparseInfo getReparseInfo() {
        return this.fReparseInfo;
    }

    public String getReparseStack() {
        if (this.fReparseInfo == null) {
            return null;
        }
        return this.fReparseInfo.getReparseStackTrace();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VlogProblem && this.fLine == ((VlogProblem)obj).getLine() && this.fSeverity == ((VlogProblem)obj).fSeverity && this.fFileName.equals(((VlogProblem)obj).getFileName())) {
            if (this.fMessage.startsWith("NON_STANDARD_") || ((VlogProblem)obj).fMessage.startsWith("NON_STANDARD_")) {
                return this.fMessage.equals(((VlogProblem)obj).fMessage);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String result = null;
        result = this.fSeverity == 1 ? "*** Error: " : "*** Warning: ";
        result = String.valueOf(result) + this.getMessage(true) + "\n" + "    detected at line " + this.getLine() + " in '" + this.getFileName() + "'";
        if (this.fReparseInfo == null) {
            return result;
        }
        result = String.valueOf(result) + "\n" + this.getReparseStack();
        return result;
    }

    public void setFileName(String fileName) {
        this.fFileName = DVTStringUtil.intern((String)fileName);
    }

    public int hashCode() {
        if (this.fMessage.startsWith("NON_STANDARD_")) {
            return (String.valueOf(this.fMessage) + "@" + this.fSeverity + "@" + this.fLine + "@" + this.fFileName).hashCode();
        }
        return (String.valueOf(this.fSeverity) + "@" + this.fLine + "@" + this.fFileName).hashCode();
    }

    public Severity getSeverityAfterWaive() {
        return this.fSeverityAfterWaive;
    }

    public void setSeverityAfterWaive(Severity severity) {
        this.fSeverityAfterWaive = severity;
    }
}

