/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.parser;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoDefineByNameFilter;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoFilter;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.ShallowCompileFilter;
import ro.amiq.dvt.buildconfig.ShallowCompileMode;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.precompiled.PrecompiledDBManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.expr.IExprValueProvider;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.CommentsTable;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.dvt.utils.parser.HeaderCommentBlock;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNonStandardProblem;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.CompactStringReplace;
import ro.amiq.vlogdt.parser.DVTCustomToken;
import ro.amiq.vlogdt.parser.EncryptedCodeLineInfo;
import ro.amiq.vlogdt.parser.EncryptedPragmaInfo;
import ro.amiq.vlogdt.parser.IDefinesProvider;
import ro.amiq.vlogdt.parser.IParsingInfo;
import ro.amiq.vlogdt.parser.IParsingListener;
import ro.amiq.vlogdt.parser.RegularStringReplace;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.parser.VlogLexersStack;
import ro.amiq.vlogdt.parser.VlogLoadedInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroParameter;
import ro.amiq.vlogdt.parser.VlogMacroText;
import ro.amiq.vlogdt.parser.VlogMacroZone;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.parser.VlogProblem;
import ro.amiq.vlogdt.parser.VlogStartedInfo;
import ro.amiq.vlogdt.test.TestHelper;
import ro.amiq.vlogdt.ui.persistenttask.TaskInfoWrapper;
import ro.amiq.vlogdt.utils.Utils;

public class VlogUtil
implements IParsingListener,
IDefinesProvider,
IExprValueProvider {
    private static boolean fIsOSX = System.getProperty("os.name") == null ? false : System.getProperty("os.name").contains("OS X");
    private static final Boolean fIsShallowCompileGeneral = System.getenv("DVT_SHALLOW_COMPILE_GENERAL") == null ? null : Boolean.valueOf(System.getenv("DVT_SHALLOW_COMPILE_GENERAL"));
    private static final boolean DVT_DEBUG_VLOG_MACRO_STRING_EXPANSION = System.getenv("DVT_DEBUG_VLOG_MACRO_STRING_EXPANSION") != null;
    private static final int TASK_TAG_MAX_DESCRIPTION_LENGTH = 100;
    private static final int TASK_TAG_MAX_LINE_LENGTH = 100 + Math.round(10.0f);
    private static final int TASK_TAG_LIMIT = 100;
    private Map<ParserPath, Set<TaskInfoWrapper>> fTaskTableMap;
    private Map<ParserPath, Set<VlogProblem>> fErrorTableMap;
    private Map<ParserPath, Set<VlogProblem>> fWarningTableMap;
    private Map<ParserPath, Boolean> fEncryptedTableMap;
    protected static boolean fDebugMode;
    protected static final String REVISION_ID = "1.0.0";
    public static final String SEVERITY_ERROR = "*** Error: ";
    public static final String SEVERITY_WARNING = "*** Warning: ";
    protected static final String DEBUG_PREFIX = "*** Debug: ";
    protected static final String LOADING_MESSAGE = "Parsing file: ";
    protected static final String IGNORED_MESSAGE = "Skip file: ";
    private static final String NON_STANDARD_SEVERITY = "*** Warning: ";
    private static final String NON_STANDARD_COMMON_ID = "NON_STANDARD_";
    private static final int CELLDEFINE;
    private static final int DEFAULT_NETTYPE;
    private static final int DEFINE;
    private static final int ELSE;
    private static final int ELSIF;
    private static final int ENDCELLDEFINE;
    private static final int ENDIF;
    private static final int IFDEF;
    private static final int IFNDEF;
    private static final int INCLUDE;
    private static final int LINE;
    private static final int NOUNCONNECTED_DRIVE;
    private static final int RESETALL;
    private static final int TIMESCALE;
    private static final int UNCONNECTED_DRIVE;
    private static final int UNDEF;
    private static final String[] EMPTY_STRING_ARRAY;
    protected static final String DUMMY_RESOLVED_ELEMENT_NAME = "@@__DUMMY__@@";
    private static final int START_TEXT = 0;
    private static final int START_MACRO = 1;
    private static final int START_PARAM = 2;
    private static byte[] VCS_PROTECTED_HEADER;
    private VlogFileInstance fTopFileInstance;
    private VlogPreprocessingInfo fPreprocessingInfo;
    private VlogFileInstance fCurrentFileInstance;
    private int fParsingKind = 0;
    private List<IParsingListener> fParsingListenersLT = new ArrayList<IParsingListener>();
    private List<IParsingListener> fParsingListenersPT = new ArrayList<IParsingListener>();
    private Map<ParserPath, List<RfMacroRefInfo>> fMacroRefsMapByFile;
    private Map<ParserPath, CodePreprocFileInfo> fCodePreprocFileInfos;
    private Map<ParserPath, List<PostWaiver>> fWaiverPragmasByFile;
    private Map<ParserPath, Set<EncryptedPragmaInfo>> fEncryptedPragmaFileInfos;
    private boolean fEncryptedZone;
    private boolean fDisableTaskTags;
    private boolean fDisableComments;
    public boolean fIsFileInstanceUnderTop;
    private int MAX_ISSUE_KIND_PER_FILE = 100;
    private int fIndex = 1;
    private int fInvocNumber = -1;
    private int fInvocOffset;
    private IBuildConfigParserConstants.ToolCompat fToolCompat = IBuildConfigParserConstants.ToolCompat.DVT;
    private List<String> fIncdirs = Collections.emptyList();
    private boolean fUseIncludedObeysLanguageSyntax;
    private boolean fAOPSupport;
    private boolean fAMSSupport;
    private boolean fWrealSupport;
    private boolean fResetNettype;
    private final Map<Boolean, Map<Boolean, Map<Boolean, Map<IBuildConfigParserConstants.LanguageSyntax, Set<String>>>>> fRemovedKeywordsCache = new HashMap<Boolean, Map<Boolean, Map<Boolean, Map<IBuildConfigParserConstants.LanguageSyntax, Set<String>>>>>(2);
    protected final Deque<IBuildConfigParserConstants.LanguageSyntax> fCurrentLanguageSyntax = new ArrayDeque<IBuildConfigParserConstants.LanguageSyntax>();
    private boolean fCollectMacroCallsWithoutParams;
    private boolean fCollectMacroCallsWithParams;
    private Deque<Map<String, PostWaiver>> fPragmaWaiversStack;
    private RfProject fRfProject;
    private Set<String> fUndeclaredElements;
    private Set<String> fAvailableElements;
    private List<String> fResolvedElements;
    private Set<String> fNewUndeclaredElements;
    private boolean fIsVcsModeForMinusY;
    private Map<String, VlogMacroInfo> fFullBuildMacroLookupMap;
    private Map<String, String> fExtensionKeywordsetMap;
    private SkipCompileFilter fSkipCompileFilter;
    private ShallowCompileFilter fShallowCompileFilter;
    private EncryptedCodeAutoFilter fEncryptedCodeAutoFilter;
    private EncryptedCodeAutoDefineByNameFilter fEncryptedCodeAutoNameFilter;
    private boolean fEncryptedCodeSupport;
    private boolean fCompactMacros;
    private boolean fIsPrecompiledDb;
    private HidImplicit[] fBuildConfigTimescale;
    private HidImplicit[] fBuildConfigOverrideTimescale;
    private static IBuildConfigParserConstants.LanguageSyntax fDefaultLanguageSyntax;
    private static DVTCodeCommentsPreferences fCommentsPreferences;
    private static final Map<String, IBuildConfigParserConstants.LanguageSyntax> KEYWORDSET_MAP;
    private Set<ParserPath> fDirtyFilesSet;
    private Map<String, Set<ParserPath>> fDependencyMacroFilesSetMap;
    private Map<ParserPath, DVTPair<ParserPath, Boolean>> fCompiledFilesMap;
    private boolean fDisablePreprocOptimize;
    private HashSet<VlogFileInstance> disabledFileInstances;
    private Set<String> fTranslatePragmas;
    private Set<String> fCustomPragmaFirstIdentifiers;
    private Map<String, CustomPragma> fStartPragmas;
    private Map<String, CustomPragma> fEndPragmas;
    private boolean fEnableIncludeEnvVarExpansion;
    private boolean fSvxMode;
    private boolean fCpreprocEnabled;
    private Set<String> fTaskNames;
    private boolean fTaskNamesCaseSensitive;
    private boolean fHideTaskName;
    private Map<File, File[]> fIncdirsCache;
    private boolean fSkipProtectedCode;
    private List<ParserPath> fIncrementalNewIncludeFiles = new ArrayList<ParserPath>();

    static {
        CELLDEFINE = "celldefine".hashCode();
        DEFAULT_NETTYPE = "default_nettype".hashCode();
        DEFINE = "define".hashCode();
        ELSE = "else".hashCode();
        ELSIF = "elsif".hashCode();
        ENDCELLDEFINE = "endcelldefine".hashCode();
        ENDIF = "endif".hashCode();
        IFDEF = "ifdef".hashCode();
        IFNDEF = "ifndef".hashCode();
        INCLUDE = "include".hashCode();
        LINE = "line".hashCode();
        NOUNCONNECTED_DRIVE = "nounconnected_drive".hashCode();
        RESETALL = "resetall".hashCode();
        TIMESCALE = "timescale".hashCode();
        UNCONNECTED_DRIVE = "unconnected_drive".hashCode();
        UNDEF = "undef".hashCode();
        EMPTY_STRING_ARRAY = new String[0];
        byte[] byArray = new byte[16];
        byArray[0] = -46;
        byArray[1] = 73;
        byArray[2] = 105;
        byArray[3] = 50;
        byArray[4] = -29;
        byArray[5] = -77;
        byArray[6] = 42;
        byArray[7] = -14;
        byArray[8] = -1;
        byArray[10] = -61;
        byArray[11] = -119;
        byArray[12] = 34;
        byArray[13] = -63;
        byArray[14] = 8;
        byArray[15] = 116;
        VCS_PROTECTED_HEADER = byArray;
        fDefaultLanguageSyntax = IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009;
        fCommentsPreferences = new DVTCodeCommentsPreferences();
        KEYWORDSET_MAP = new HashMap<String, IBuildConfigParserConstants.LanguageSyntax>();
        KEYWORDSET_MAP.put("VAMS-2.3", IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23);
        KEYWORDSET_MAP.put("SVAMS", IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_AMS);
        KEYWORDSET_MAP.put("1364-1995-ius", IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS);
        KEYWORDSET_MAP.put("1364-1995", IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995);
        KEYWORDSET_MAP.put("1364-2001", IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001);
        KEYWORDSET_MAP.put("1364-2001-noconfig", IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig);
        KEYWORDSET_MAP.put("1364-2005", IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2005);
        KEYWORDSET_MAP.put("1800-2005", IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2005);
        KEYWORDSET_MAP.put("1800-2009", IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009);
        KEYWORDSET_MAP.put("1800-2012", IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2012);
        KEYWORDSET_MAP.put("1800-2023", IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2023);
    }

    protected VlogUtil() {
        this.fErrorTableMap = new LinkedHashMap<ParserPath, Set<VlogProblem>>();
        this.fWarningTableMap = new LinkedHashMap<ParserPath, Set<VlogProblem>>();
        this.fEncryptedTableMap = new LinkedHashMap<ParserPath, Boolean>();
        this.fTaskTableMap = new LinkedHashMap<ParserPath, Set<TaskInfoWrapper>>();
        this.fParsingListenersLT.add(this);
    }

    protected void reportClean() {
        this.fErrorTableMap = new LinkedHashMap<ParserPath, Set<VlogProblem>>();
        this.fWarningTableMap = new LinkedHashMap<ParserPath, Set<VlogProblem>>();
        this.fEncryptedTableMap = new LinkedHashMap<ParserPath, Boolean>();
        this.fTaskTableMap = new LinkedHashMap<ParserPath, Set<TaskInfoWrapper>>();
    }

    protected boolean isOSX() {
        return fIsOSX;
    }

    protected Map<ParserPath, Set<VlogProblem>> getErrorsMap() {
        return this.fErrorTableMap;
    }

    protected Map<ParserPath, Set<VlogProblem>> getWarningsMap() {
        return this.fWarningTableMap;
    }

    public Map<ParserPath, Set<TaskInfoWrapper>> getTasksMap() {
        return this.fTaskTableMap;
    }

    protected final void setEncryptedFile(String parserPath, boolean encrypted) {
        this.fEncryptedTableMap.put(new ParserPath(parserPath), encrypted);
    }

    protected void reportMessage(String severity, String filename) {
    }

    protected final boolean isProtected(InputStream in) {
        boolean isProtected = false;
        try {
            try {
                byte[] bytes = new byte[VCS_PROTECTED_HEADER.length];
                in.mark(VCS_PROTECTED_HEADER.length);
                in.read(bytes, 0, bytes.length);
                isProtected = Arrays.equals(VCS_PROTECTED_HEADER, bytes);
                if (!isProtected) {
                    in.reset();
                }
            }
            catch (Exception exception) {
                if (isProtected) {
                    DVTUtilsCommon.INSTANCE.closeClosable((Closeable)in);
                }
            }
        }
        finally {
            if (isProtected) {
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)in);
            }
        }
        return isProtected;
    }

    public void reportError(String severity, String filename, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, String message, int fileIndex, ReparseInfo reparseInfo) {
        this.reportError(severity, filename, languageSyntax, line, -1, -1, message, fileIndex, reparseInfo);
    }

    public void reportError(String severity, String filename, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, int offsetStart, int length, String message, int fileIndex, ReparseInfo reparseInfo) {
        this.reportError(severity, filename, languageSyntax, line, offsetStart, length, message, fileIndex, reparseInfo, null);
    }

    protected void reportError(String severity, String filename, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, int offsetStart, int length, String message, int fileIndex, ReparseInfo reparseInfo, Map<String, Object> attributes) {
        Set<VlogProblem> warningTable;
        String messagePrefix;
        ParserPath parserPath = new ParserPath(filename);
        if (this.fIsPrecompiledDb) {
            if (severity != null && severity.equals(SEVERITY_ERROR)) {
                PrecompiledDBManager.getInstance().reportFileSyntacticError(parserPath);
            }
            return;
        }
        if (message != null && message.length() > 1) {
            message = String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1);
        }
        boolean isNonStandard = message != null && message.startsWith(NON_STANDARD_COMMON_ID);
        String string = messagePrefix = isNonStandard ? null : String.valueOf(this.getLanguageSyntaxName(languageSyntax)) + ":";
        if (this.isPVlogPreprocessing(parserPath)) {
            length = PreprocDiffManager.INSTANCE.computePreprocErrorLength(parserPath, offsetStart, length);
        }
        if (severity != null && severity.equals(SEVERITY_ERROR)) {
            Set<VlogProblem> errorTable = this.getErrors(parserPath);
            if (errorTable.size() < this.MAX_ISSUE_KIND_PER_FILE || isNonStandard) {
                VlogProblem problem = new VlogProblem(1, filename, messagePrefix, line, message, fileIndex, reparseInfo, this.fInvocNumber + this.fInvocOffset);
                if (attributes != null && !attributes.isEmpty()) {
                    problem.setAttributes(attributes);
                }
                if (offsetStart >= 0 && length > 0) {
                    problem.setOffsetStart(offsetStart);
                    problem.setOffsetEnd(offsetStart + length);
                }
                if (!errorTable.contains(problem)) {
                    errorTable.add(problem);
                }
            }
        } else if (severity != null && severity.equals("*** Warning: ") && ((warningTable = this.getWarnings(parserPath)).size() < this.MAX_ISSUE_KIND_PER_FILE || isNonStandard)) {
            VlogProblem problem = new VlogProblem(2, filename, messagePrefix, line, message, fileIndex, reparseInfo, this.fInvocNumber + this.fInvocOffset);
            if (offsetStart >= 0 && length > 0) {
                problem.setOffsetStart(offsetStart);
                problem.setOffsetEnd(offsetStart + length);
            }
            if (!warningTable.contains(problem)) {
                warningTable.add(problem);
            }
        }
    }

    protected void setMaxIssuesKindPerFile(int maxNumber) {
        this.MAX_ISSUE_KIND_PER_FILE = maxNumber;
    }

    protected void cleanMessages(ParserPath parserPath) {
        if (this.fWarningTableMap.containsKey(parserPath)) {
            this.fWarningTableMap.remove(parserPath);
        }
        if (this.fErrorTableMap.containsKey(parserPath)) {
            this.fErrorTableMap.remove(parserPath);
        }
        if (this.fEncryptedTableMap.containsKey(parserPath)) {
            this.fEncryptedTableMap.remove(parserPath);
        }
        if (this.fTaskTableMap.containsKey(parserPath)) {
            this.fTaskTableMap.remove(parserPath);
        }
    }

    public Set<VlogProblem> getWarnings(ParserPath parserPath) {
        Set<VlogProblem> warningTable = this.fWarningTableMap.get(parserPath);
        if (warningTable != null) {
            return warningTable;
        }
        warningTable = new LinkedHashSet<VlogProblem>();
        this.fWarningTableMap.put(parserPath, warningTable);
        return warningTable;
    }

    public Set<VlogProblem> getErrors(ParserPath parserPath) {
        Set<VlogProblem> errorTable = this.fErrorTableMap.get(parserPath);
        if (this.fErrorTableMap.containsKey(parserPath)) {
            return errorTable;
        }
        errorTable = new LinkedHashSet<VlogProblem>();
        this.fErrorTableMap.put(parserPath, errorTable);
        return errorTable;
    }

    public Set<TaskInfoWrapper> getTasks(ParserPath parserPath) {
        Set<TaskInfoWrapper> taskTable = this.fTaskTableMap.get(parserPath);
        if (this.fTaskTableMap.containsKey(parserPath)) {
            return taskTable;
        }
        taskTable = new LinkedHashSet<TaskInfoWrapper>();
        this.fTaskTableMap.put(parserPath, taskTable);
        return taskTable;
    }

    public boolean isEncrypted(ParserPath parserPath) {
        if (this.fEncryptedTableMap.containsKey(parserPath)) {
            return this.fEncryptedTableMap.get(parserPath);
        }
        return false;
    }

    protected synchronized void notifyParsingListenersLT(IParsingInfo e) {
        for (IParsingListener listener : this.fParsingListenersLT) {
            listener.parsing(e);
        }
    }

    protected synchronized void notifyParsingListenersPT(IParsingInfo e) {
        for (IParsingListener listener : this.fParsingListenersPT) {
            listener.parsing(e);
        }
    }

    protected void debug(Object ... s) {
        if (fDebugMode) {
            Object[] sl = Arrays.asList(s).toArray();
            StringBuilder sb = new StringBuilder(DEBUG_PREFIX);
            int i = 0;
            while (i < sl.length) {
                if (sl[i] != null) {
                    sb.append(sl[i].toString());
                } else {
                    sb.append("null");
                }
                ++i;
            }
            TestHelper.out.println(sb.toString());
        }
    }

    protected synchronized void setDebugMode() {
        fDebugMode = true;
    }

    protected final void setReference(VlogFileInstance instance, int line, int lastTokenLine, int offset, String macroName, String[] parameters, boolean isCall) {
        if (!RfMacroRefInfo.ALLOWED_REFERENCES.contains(macroName)) {
            if (!(this.fCollectMacroCallsWithoutParams || parameters != null && parameters.length != 0)) {
                return;
            }
            if (!this.fCollectMacroCallsWithParams && parameters != null && parameters.length != 0) {
                return;
            }
        }
        ParserPath parserPath = instance.getParserPath();
        RfMacroRefInfo ref = new RfMacroRefInfo(parserPath, line, offset, VlogUtil.getCommentAtLine((IDVTFileInstance)instance, line, lastTokenLine, true, line, true), macroName, parameters, isCall);
        List<RfMacroRefInfo> refsInFile = this.fMacroRefsMapByFile.get(parserPath);
        if (refsInFile == null) {
            refsInFile = new ArrayList<RfMacroRefInfo>();
            this.fMacroRefsMapByFile.put(parserPath, refsInFile);
        }
        refsInFile.add(ref);
    }

    protected final void addEncryptedPragma(ParserPath parserPath, EncryptedPragmaInfo.EncryptedPragmaKind kind, int line, int offset, int length) {
        Set<EncryptedPragmaInfo> pragmasInFile = this.fEncryptedPragmaFileInfos.get(parserPath);
        if (pragmasInFile == null) {
            pragmasInFile = new LinkedHashSet<EncryptedPragmaInfo>();
            this.fEncryptedPragmaFileInfos.put(parserPath, pragmasInFile);
        }
        pragmasInFile.add(new EncryptedPragmaInfo(kind, line, offset, length));
        if (kind == EncryptedPragmaInfo.EncryptedPragmaKind.START_PROTECT) {
            this.fEncryptedZone = true;
        } else if (kind == EncryptedPragmaInfo.EncryptedPragmaKind.END_PROTECT) {
            this.fEncryptedZone = false;
        }
    }

    protected final boolean isEncryptedZone() {
        return this.fEncryptedZone;
    }

    protected final void setCodePreprocLineEnter(VlogFileInstance instance, int line, int column) {
        this.setCodePreprocLineInfo(instance, new CodePreprocLineInfo(0, line, column));
    }

    protected final void setCodePreprocLineSkip(VlogFileInstance instance, int line, int column) {
        this.setCodePreprocLineInfo(instance, new CodePreprocLineInfo(1, line, column));
    }

    protected final void setEncryptedCodeLineEnter(VlogFileInstance instance, int line, int column) {
        this.setCodePreprocLineInfo(instance, new EncryptedCodeLineInfo(0, line, column));
    }

    protected final void setEncryptedCodeLineSkip(VlogFileInstance instance, int line, int column) {
        this.setCodePreprocLineInfo(instance, new EncryptedCodeLineInfo(1, line, column));
    }

    private final void setCodePreprocLineInfo(VlogFileInstance instance, CodePreprocLineInfo info) {
        CodePreprocLineInfo oldLineInfo;
        if (instance == null) {
            return;
        }
        ParserPath parserPath = instance.getParserPath();
        CodePreprocFileInfo fileInfo = this.fCodePreprocFileInfos.get(parserPath);
        if (fileInfo == null) {
            fileInfo = new CodePreprocFileInfo();
            this.fCodePreprocFileInfos.put(parserPath, fileInfo);
        }
        if ((oldLineInfo = fileInfo.getInfo(info.getLine())) == null) {
            fileInfo.putInfo(info.getLine(), info);
        } else if (oldLineInfo.getType() == 1 && info.getType() == 0) {
            if (oldLineInfo.getColumn() == info.getColumn()) {
                fileInfo.putInfo(info.getLine(), info);
            } else {
                fileInfo.putInfo(info.getLine() + 1, info);
            }
        } else if (oldLineInfo.getType() == 0 && info.getType() == 1 && oldLineInfo.getLine() + 1 == info.getLine()) {
            fileInfo.putInfo(info.getLine(), info);
        }
    }

    protected VlogFileInstance getTopFileInstance() {
        return this.fTopFileInstance;
    }

    protected void restorePreprocessing(VlogPreprocessingInfo preprocessingInfo, RfProject project, ParserPath parserPath) {
        this.fRfProject = project;
        this.fPreprocessingInfo = preprocessingInfo;
        this.fTopFileInstance = preprocessingInfo.getTopFileInstance();
        this.fTopFileInstance.setFileName(parserPath);
        this.fMacroRefsMapByFile = preprocessingInfo.getMacroRefsMapByFile();
        this.fCodePreprocFileInfos = preprocessingInfo.getCodePreprocFileInfos();
        this.fWaiverPragmasByFile = preprocessingInfo.getWaiverPragmasMap();
        this.fEncryptedPragmaFileInfos = preprocessingInfo.getEncrypedPragmaFileInfos();
        Invocation firstInvocation = BuildConfigManager.getFirstInvocation((IProject)this.fRfProject.getProject());
        this.fInvocOffset = firstInvocation != null && !firstInvocation.hasTopFiles() ? 0 : 1;
    }

    protected VlogMacroInfo getDefine(String macroName, boolean cStyle) {
        return this.getDefine(macroName, cStyle, null);
    }

    protected VlogMacroInfo getDefine(String macroName, boolean cStyle, DVTCustomToken token) {
        macroName = cStyle ? "###_" + macroName : macroName;
        VlogMacroInfo define = this.internalGetDefine(macroName = DVTStringUtil.unescapeIdentifier((String)macroName, (boolean)false), true, token);
        if (define == null || define.isUndefConfigMacro()) {
            return null;
        }
        return define;
    }

    protected VlogMacroInfo getConditionDefine(String macroName, boolean cStyle, LineInfo startLine, LineInfo endLine) {
        macroName = cStyle ? "###_" + macroName : macroName;
        VlogMacroInfo define = this.internalGetDefine(macroName = DVTStringUtil.unescapeIdentifier((String)macroName, (boolean)false), true);
        if (define == null) {
            define = this.fCurrentFileInstance.addDefine(macroName, new VlogMacroText(null, new ArrayList<StringReplace>()), startLine, endLine, null, this);
            define.setUndefConfigMacro();
            return null;
        }
        if (define.isUndefConfigMacro()) {
            return null;
        }
        if (!define.isIfndefGuard()) {
            define.setDefinedConfigMacro();
        }
        return define;
    }

    @Override
    public VlogMacroInfo getSimpleDefine(String macroName) {
        macroName = DVTStringUtil.unescapeIdentifier((String)macroName, (boolean)false);
        if (this.fFullBuildMacroLookupMap != null) {
            VlogMacroInfo info = this.fFullBuildMacroLookupMap.get(macroName);
            if (info == null || info.isUndef()) {
                return null;
            }
            return info;
        }
        assert (this.fCurrentFileInstance != null);
        return this.fCurrentFileInstance.getDefine(macroName);
    }

    @Override
    public IBuildConfigParserConstants.ToolCompat getToolCompat() {
        return this.fToolCompat;
    }

    private final VlogMacroInfo internalGetDefine(String macroName, boolean secondEval, DVTCustomToken token) {
        boolean isAutoDefined;
        boolean bl = isAutoDefined = token != null && secondEval && this.fEncryptedCodeAutoNameFilter != null && this.fEncryptedCodeAutoNameFilter.hasEncryptedCodeAutoPath(macroName);
        if (this.fFullBuildMacroLookupMap != null) {
            VlogMacroInfo info = this.fFullBuildMacroLookupMap.get(macroName);
            if (info == null) {
                return isAutoDefined ? this.getAutoDefinedVlogMacroInfo(macroName, token) : null;
            }
            if (this.fEncryptedCodeAutoNameFilter != null && this.fEncryptedCodeAutoNameFilter.isDebug() && isAutoDefined && info.isAutoDefined() && token != null) {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getRfProject().getProject()).print("Encrypted code auto-macro: (update) " + macroName + "\n\t in file " + this.getCurrentFileInstance().getParserPath().path + " at line " + token.getLine());
            }
            if (info.isUndef()) {
                return null;
            }
            return this.internalDefineSecondEval(info, secondEval);
        }
        assert (this.fCurrentFileInstance != null);
        VlogMacroInfo info = this.fCurrentFileInstance.getDefine(macroName);
        return this.internalDefineSecondEval(info, secondEval);
    }

    private final VlogMacroInfo internalGetDefine(String macroName, boolean secondEval) {
        return this.internalGetDefine(macroName, secondEval, null);
    }

    private VlogMacroInfo getAutoDefinedVlogMacroInfo(String macroName, DVTCustomToken token) {
        StringReplace stringReplace = this.newStringReplace("", true);
        ArrayList<StringReplace> stringReplaceList = new ArrayList<StringReplace>();
        stringReplaceList.add(stringReplace);
        VlogMacroParameter param = new VlogMacroParameter("params");
        param.setValue("__dvt_encrypted_code_auto_macro__");
        ArrayList<VlogMacroParameter> params = new ArrayList<VlogMacroParameter>();
        params.add(param);
        LineInfo startLine = new LineInfo(token.getLine(), token.getOffset(), token.getVirtualOffset());
        VlogMacroText macroText = new VlogMacroText(params, stringReplaceList);
        VlogMacroInfo addAutoDefine = this.fTopFileInstance.addAutoDefine(macroName, macroText, startLine, startLine, this);
        addAutoDefine.setDefComment(new CommentBlock(null, "Auto defined macro", false));
        RfProject rfProject = this.getRfProject();
        if (rfProject != null && this.fEncryptedCodeAutoNameFilter.isDebug()) {
            IProject project = rfProject.getProject();
            DVTBuildConsoleRegistry.getConsole((IProject)project).print("Encrypted code auto-macro: " + macroName + "\n\t in file " + this.getCurrentFileInstance().getParserPath().path + " at line " + token.getLine());
        } else if (!this.fEncryptedCodeAutoNameFilter.isDebug()) {
            this.fEncryptedCodeAutoNameFilter.incrementDefinedMacros();
        }
        return addAutoDefine;
    }

    private VlogMacroInfo internalDefineSecondEval(VlogMacroInfo define, boolean secondEval) {
        if (!secondEval || define == null || define.hasParams() || !define.hasReplacement()) {
            return define;
        }
        try {
            VlogMacroInfo define2;
            String replacement = define.getReplacement(this, null);
            if (replacement != null && replacement.charAt(0) == '`' && (define2 = this.internalGetDefine(replacement.substring(1), false)) != null && define2.hasParams()) {
                return define2;
            }
        }
        catch (Exception exception) {}
        return define;
    }

    protected void addDefine(String macroName, VlogMacroText macroText, boolean isSkip, LineInfo startLine, LineInfo endLine, int lastTokenLine, ReparseInfo reparseInfo, boolean cStyle) throws VlogException {
        if (isSkip) {
            return;
        }
        assert (this.fCurrentFileInstance != null);
        if (this.isCompilerDirective(macroName)) {
            throw new VlogException(SEVERITY_ERROR, "Cannot redefine compiler directive: `" + macroName);
        }
        macroName = cStyle ? "###_" + macroName : macroName;
        macroName = DVTStringUtil.unescapeIdentifier((String)macroName, (boolean)true);
        VlogMacroInfo define = this.internalGetDefine(macroName, false);
        boolean equals = false;
        VlogMacroZone prevMacroZone = this.fCurrentFileInstance.getMacroZoneBeforeIncremental();
        if (define != null && !define.isUndefConfigMacro()) {
            this.checkMacroChangedRemoved(macroName, macroText, prevMacroZone);
            if (define.getMacroText() == null && !macroText.hasParams() && !macroText.hasReplacement()) {
                equals = true;
            } else if (define.getMacroText() != null && define.getMacroText().equals(macroText)) {
                equals = true;
            } else {
                boolean isOverrideOfABuildConfigDefine;
                VlogFileInstance defineFileInstance = define.getFileInstance();
                boolean bl = isOverrideOfABuildConfigDefine = defineFileInstance != null && !this.fCurrentFileInstance.isBuildConfigFileInstance() && defineFileInstance.isBuildConfigFileInstance();
                if (isOverrideOfABuildConfigDefine) {
                    this.setReference(this.fCurrentFileInstance, startLine.line, lastTokenLine, startLine.realOffset, define.getName(), null, false);
                    throw new VlogException("*** Warning: ", "Ignored definition of macro name: " + macroName + " (defined in the build configuration)");
                }
                this.checkMacroChanged(macroName, macroText, prevMacroZone);
                this.fCurrentFileInstance.addDefine(macroName, macroText, startLine, endLine, reparseInfo, this);
                this.setReference(this.fCurrentFileInstance, startLine.line, lastTokenLine, startLine.realOffset, macroName, macroText.getParameters(), false);
                throw new VlogException("*** Warning: ", "Redefinition of macro name: " + macroName);
            }
        }
        if (!equals && this.fDirtyFilesSet != null && this.fDependencyMacroFilesSetMap.containsKey(macroName)) {
            this.fDirtyFilesSet.addAll((Collection<ParserPath>)this.fDependencyMacroFilesSetMap.get(macroName));
        }
        this.checkMacroChanged(macroName, macroText, prevMacroZone);
        this.fCurrentFileInstance.addDefine(macroName, macroText, startLine, endLine, reparseInfo, this);
        this.setReference(this.fCurrentFileInstance, startLine.line, lastTokenLine, startLine.realOffset, macroName, macroText.getParameters(), false);
    }

    private VlogMacroInfo getPrevMacroInfoIncremental(String macroName, VlogMacroZone prevMacroZone) {
        if (prevMacroZone == null) {
            return null;
        }
        VlogMacroInfo macroInfo = prevMacroZone.getMacroInfo(macroName);
        if (macroInfo == null || macroInfo.getMacroText() == null || this.fRfProject == null || this.fRfProject.getIncrementalDeltaContainer() == null) {
            return null;
        }
        return macroInfo;
    }

    private void checkMacroChangedRemoved(String macroName, VlogMacroText macroText, VlogMacroZone prevMacroZone) {
        VlogMacroInfo macroInfo = this.getPrevMacroInfoIncremental(macroName, prevMacroZone);
        if (macroInfo == null) {
            return;
        }
        if (macroInfo.getMacroText().equals(macroText)) {
            this.fRfProject.getIncrementalDeltaContainer().removeChangedMacro(macroName);
        }
    }

    private void checkMacroChanged(String macroName, VlogMacroText macroText, VlogMacroZone prevMacroZone) {
        VlogMacroInfo macroInfo = this.getPrevMacroInfoIncremental(macroName, prevMacroZone);
        if (macroInfo == null) {
            return;
        }
        if (!macroInfo.getMacroText().equals(macroText)) {
            this.fRfProject.getIncrementalDeltaContainer().addChangedMacro(macroName);
        }
    }

    protected void addUndef(String macroName, boolean isSkip, LineInfo startLine, LineInfo endLine, int lastTokenLine, ReparseInfo reparseInfo) throws VlogException {
        boolean isOverrideOfABuildConfigDefine;
        if (isSkip) {
            return;
        }
        assert (this.fCurrentFileInstance != null);
        VlogMacroInfo define = this.internalGetDefine(macroName = DVTStringUtil.unescapeIdentifier((String)macroName, (boolean)true), false);
        VlogFileInstance defineFileInstance = define == null ? null : define.getFileInstance();
        boolean bl = isOverrideOfABuildConfigDefine = defineFileInstance != null && !this.fCurrentFileInstance.isBuildConfigFileInstance() && defineFileInstance.isBuildConfigFileInstance();
        if (define != null && isOverrideOfABuildConfigDefine) {
            this.setReference(this.fCurrentFileInstance, startLine.line, lastTokenLine, startLine.realOffset, define.getName(), null, false);
            throw new VlogException("*** Warning: ", "Ignored definition of macro name: " + macroName + " (defined in the build configuration)");
        }
        if (define == null || define.isUndef() || define.isUndefConfigMacro()) {
            this.fCurrentFileInstance.addUndef(macroName, startLine, endLine, reparseInfo, this);
            this.setReference(this.fCurrentFileInstance, startLine.line, lastTokenLine, startLine.realOffset, macroName, null, false);
            throw new VlogException("*** Warning: ", "Macro name: " + macroName + " is not defined");
        }
        if (this.fDirtyFilesSet != null) {
            if (this.fDependencyMacroFilesSetMap.containsKey(macroName)) {
                this.fDirtyFilesSet.addAll((Collection<ParserPath>)this.fDependencyMacroFilesSetMap.get(macroName));
            }
            if (!define.isUndef()) {
                this.fDirtyFilesSet.add(this.fCurrentFileInstance.getParserPath());
                VlogFileInstance fileInstance = define.getFileInstance();
                if (fileInstance != null) {
                    ParserPath parserPath = fileInstance.getParserPath();
                    if (parserPath != null) {
                        this.fDirtyFilesSet.add(parserPath);
                    }
                    while ((fileInstance = fileInstance.getIncludingFileInfo()) != null) {
                        parserPath = fileInstance.getParserPath();
                        if (parserPath == null) continue;
                        this.fDirtyFilesSet.add(parserPath);
                    }
                }
            }
        }
        this.fCurrentFileInstance.addUndef(macroName, startLine, endLine, reparseInfo, this);
        VlogMacroText macroText = define.getMacroText();
        String[] parameters = macroText == null ? null : macroText.getParameters();
        this.setReference(this.fCurrentFileInstance, startLine.line, lastTokenLine, startLine.realOffset, define.getName(), parameters, false);
    }

    protected void undefAllMacros(boolean isSkip, boolean fullUndef) {
        if (isSkip) {
            return;
        }
        assert (this.fCurrentFileInstance != null);
        ArrayList<VlogMacroInfo> allDefines = new ArrayList<VlogMacroInfo>();
        this.fCurrentFileInstance.getAllDefines(allDefines);
        for (VlogMacroInfo macro : allDefines) {
            try {
                VlogMacroInfo define;
                VlogFileInstance fileInstance;
                if (!fullUndef && (fileInstance = macro.getFileInstance()) == this.getTopFileInstance() || (define = this.internalGetDefine(macro.getName(), false)) == null || define.isUndef() || define.isUndefConfigMacro()) continue;
                LineInfo line = new LineInfo(-1, -1, -1);
                this.addUndef(macro.getName(), false, line, line, -1, null);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    protected boolean isCompilerDirective(String name) {
        int hash = name.hashCode();
        return hash == CELLDEFINE || hash == DEFAULT_NETTYPE || hash == DEFINE || hash == ELSE || hash == ELSIF || hash == ENDCELLDEFINE || hash == ENDIF || hash == IFDEF || hash == IFNDEF || hash == INCLUDE || hash == LINE || hash == NOUNCONNECTED_DRIVE || hash == RESETALL || hash == TIMESCALE || hash == UNCONNECTED_DRIVE || hash == UNDEF;
    }

    protected void setParsingKind(int parsingKind, Set<String> availableElements, boolean isVcsModeForMinusY) {
        this.fParsingKind = parsingKind;
        if (this.fParsingKind == 0) {
            this.fAvailableElements = availableElements;
            this.fUndeclaredElements = new LinkedHashSet<String>();
        }
        if (this.fParsingKind == 1 || this.fParsingKind == 2) {
            if (this.fResolvedElements == null) {
                this.fResolvedElements = new ArrayList<String>();
            }
            if (this.fNewUndeclaredElements == null) {
                this.fNewUndeclaredElements = new HashSet<String>();
            }
            this.fIsVcsModeForMinusY = isVcsModeForMinusY;
        }
    }

    protected boolean isMinusYLibFileFullBuild() {
        return this.fParsingKind == 1;
    }

    protected boolean isLibFileFullBuild() {
        return this.fParsingKind == 1 || this.fParsingKind == 2 || this.fParsingKind == 7;
    }

    public void setUndeclaredElements(List<String> undeclaredElements, boolean isVcsModeForMinusY) {
        if (this.fParsingKind == 3) {
            this.fUndeclaredElements = undeclaredElements == null ? null : new LinkedHashSet<String>(undeclaredElements);
            this.fIsVcsModeForMinusY = isVcsModeForMinusY;
        }
    }

    public Set<String> getUndeclaredElements() {
        return this.fUndeclaredElements;
    }

    public List<String> getAndClearResolvedElements() {
        List<String> result = this.fResolvedElements;
        this.fResolvedElements = null;
        return result;
    }

    public boolean isVcsModeForMinusY() {
        return this.fIsVcsModeForMinusY;
    }

    public void addAvailableElement(String element) {
        if (this.fParsingKind == 1 || this.fParsingKind == 2 || this.fParsingKind == 0) {
            if (this.fAvailableElements == null || this.fUndeclaredElements == null) {
                return;
            }
            this.fAvailableElements.add(element);
            this.fUndeclaredElements.remove(element);
            if (this.fNewUndeclaredElements != null) {
                this.fNewUndeclaredElements.remove(element);
            }
            if (this.fResolvedElements != null && (this.fParsingKind == 1 || this.fParsingKind == 2)) {
                this.fResolvedElements.add(element);
            }
        }
    }

    public void addUndeclaredElement(String element) {
        if (this.fParsingKind == 1 || this.fParsingKind == 2 || this.fParsingKind == 0) {
            if (this.fAvailableElements == null || this.fUndeclaredElements == null) {
                return;
            }
            if (!this.fAvailableElements.contains(element)) {
                if (this.fNewUndeclaredElements != null && !this.fAvailableElements.contains(element) && !this.fUndeclaredElements.contains(element)) {
                    this.fNewUndeclaredElements.add(element);
                }
                this.fUndeclaredElements.add(element);
            }
        } else if (this.fParsingKind == 8) {
            if (this.fUndeclaredElements == null) {
                this.fUndeclaredElements = new LinkedHashSet<String>();
            }
            this.fUndeclaredElements.add(element);
        }
    }

    public void addResolvedElement(VlogFileInstance instance, String name) {
        if (this.fParsingKind == 1 && this.fIsVcsModeForMinusY || this.fParsingKind == 2 || this.fParsingKind == 8) {
            instance.addUndeclaredElement(name);
        }
        if (this.fParsingKind == 1 && this.fIsVcsModeForMinusY) {
            instance.setVcsModeForMinusY(true);
        }
    }

    public Set<String> getAndClearNewUndeclaredElements(boolean clear) {
        Set<String> result = this.fNewUndeclaredElements;
        if (clear) {
            this.fNewUndeclaredElements = null;
        }
        return result;
    }

    public void setAvailableElements(Set<String> availableElementsToInstantiate) {
        if (this.fParsingKind == 1 || this.fParsingKind == 2 || this.fParsingKind == 8) {
            this.fAvailableElements = availableElementsToInstantiate;
        }
    }

    protected void setCurrentFile(VlogFileInstance fileToParse) {
        this.fCurrentFileInstance = fileToParse;
    }

    protected void setInvocationProperties(int invocNumber, IBuildConfigParserConstants.ToolCompat toolCompat, List<String> incdirs, boolean hasAOPSupport, boolean hasAMSSupport, boolean hasWrealSupport, boolean resetNettype) {
        this.fToolCompat = toolCompat;
        this.fIncdirs = incdirs;
        this.fAOPSupport = hasAOPSupport;
        this.fAMSSupport = hasAMSSupport;
        this.fWrealSupport = hasWrealSupport;
        this.fResetNettype = resetNettype;
        this.fInvocNumber = invocNumber;
        this.fInvocOffset = 0;
    }

    protected int getInvocationNumber() {
        return this.fInvocNumber;
    }

    public final List<String> getIncdirs() {
        if (this.fIncdirs == null) {
            return Collections.emptyList();
        }
        return this.fIncdirs;
    }

    @Override
    public final void parsing(IParsingInfo info) {
        switch (info.getKind()) {
            case 1: {
                VlogStartedInfo msInfo = (VlogStartedInfo)info;
                ParserPath parserPath = msInfo.getParserPath();
                if (this.fDirtyFilesSet != null) {
                    this.fDirtyFilesSet.remove(parserPath);
                }
                if (this.fParsingKind == 0) {
                    if (this.fCurrentFileInstance == null || parserPath.equals((Object)this.fTopFileInstance.getParserPath())) {
                        this.setCurrentFile(this.fTopFileInstance);
                        this.addCompiledFile(this.fTopFileInstance);
                    } else {
                        VlogIncludingScope includingScope = new VlogIncludingScope(this.fCurrentFileInstance, msInfo.getIncludingLine(), msInfo.getIncludingOffset());
                        VlogFileInstance fileInstance = new VlogFileInstance(this.fRfProject, parserPath, includingScope, this.fIndex, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
                        this.addCompiledFile(fileInstance);
                        if (this.fResetNettype) {
                            fileInstance.addDefaultNettype(0, "wire");
                            this.fResetNettype = false;
                        }
                        this.setCurrentFile(fileInstance);
                        ++this.fIndex;
                    }
                } else if (this.fParsingKind == 1 || this.fParsingKind == 2 || this.fParsingKind == 7) {
                    VlogFileInstance fileInstance = null;
                    if (!this.fIsFileInstanceUnderTop && this.fCurrentFileInstance == null || parserPath.equals((Object)new ParserPath(String.valueOf(this.fTopFileInstance.getParserPath().path) + ".libfile"))) {
                        VlogIncludingScope includingScope = new VlogIncludingScope(this.fTopFileInstance, -1, -1);
                        ParserPath includeFileParserPath = new ParserPath(String.valueOf(this.fTopFileInstance.getParserPath().path) + ".libfile");
                        fileInstance = new VlogFileInstance(this.fRfProject, includeFileParserPath, includingScope, 0, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
                    } else {
                        VlogIncludingScope includingScope;
                        if (this.fIsFileInstanceUnderTop && this.fCurrentFileInstance == null) {
                            includingScope = new VlogIncludingScope(this.fTopFileInstance, -1, -1);
                            ParserPath includeFileParserPath = new ParserPath(String.valueOf(this.fTopFileInstance.getParserPath().path) + ".libfile");
                            fileInstance = new VlogFileInstance(this.fRfProject, includeFileParserPath, includingScope, -1, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
                            this.setCurrentFile(fileInstance);
                            this.fIsFileInstanceUnderTop = false;
                        }
                        includingScope = new VlogIncludingScope(this.fCurrentFileInstance, msInfo.getIncludingLine(), msInfo.getIncludingOffset());
                        fileInstance = new VlogFileInstance(this.fRfProject, parserPath, includingScope, this.fIndex, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
                        ++this.fIndex;
                    }
                    this.addCompiledFile(fileInstance);
                    this.setCurrentFile(fileInstance);
                    if (this.fParsingKind == 1 && this.isVcsModeForMinusY() || this.fParsingKind == 2 || this.fParsingKind == 7) {
                        fileInstance.addUndeclaredElement(DUMMY_RESOLVED_ELEMENT_NAME);
                    }
                    if (this.fParsingKind == 1 && this.fIsVcsModeForMinusY) {
                        fileInstance.setVcsModeForMinusY(true);
                    }
                } else if (this.fParsingKind == 4) {
                    assert (this.fCurrentFileInstance != null);
                    if (BuildConfigManager.getPrecompiledDbMode((IProject)this.fRfProject.getProject()).equals((Object)BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD)) {
                        PrecompiledDBManager.getInstance().addFileWithIncludesChangedInIncremental(this.fCurrentFileInstance.getParserPath());
                    }
                    VlogIncludingScope includingScope = new VlogIncludingScope(this.fCurrentFileInstance, msInfo.getIncludingLine(), msInfo.getIncludingOffset());
                    VlogFileInstance fileInstance = this.createFileInstanceForNewIncludedFile(parserPath, includingScope);
                    this.addCompiledFile(fileInstance);
                    if (this.fResetNettype) {
                        fileInstance.addDefaultNettype(0, "wire");
                        this.fResetNettype = false;
                    }
                    this.setCurrentFile(fileInstance);
                    this.fIncrementalNewIncludeFiles.add(parserPath);
                } else if (this.fParsingKind == 3) {
                    assert (this.fCurrentFileInstance != null);
                    this.fCurrentFileInstance.prepareForReparse(true);
                } else if (this.fParsingKind == 8) {
                    VlogFileInstance fileInstance = null;
                    if (this.fCurrentFileInstance == null || parserPath.equals((Object)new ParserPath(String.valueOf(this.fTopFileInstance.getParserPath().path) + ".libfile"))) {
                        VlogIncludingScope includingScope = new VlogIncludingScope(this.fTopFileInstance, -1, -1);
                        ParserPath includeFileParserPath = new ParserPath(String.valueOf(this.fTopFileInstance.getParserPath().path) + ".libfile");
                        fileInstance = new VlogFileInstance(this.fRfProject, includeFileParserPath, includingScope, 0, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
                        this.addCompiledFile(fileInstance);
                        this.setCurrentFile(fileInstance);
                    } else if (this.fCurrentFileInstance != null && !parserPath.equals((Object)this.fCurrentFileInstance.getParserPath())) {
                        VlogIncludingScope includingScope = new VlogIncludingScope(this.fCurrentFileInstance, msInfo.getIncludingLine(), msInfo.getIncludingOffset());
                        fileInstance = new VlogFileInstance(this.fRfProject, parserPath, includingScope, this.fCurrentFileInstance.getIndex(), this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
                        ++this.fIndex;
                        this.addCompiledFile(fileInstance);
                        this.setCurrentFile(fileInstance);
                    } else {
                        assert (this.fCurrentFileInstance != null);
                        this.fCurrentFileInstance.prepareForReparse(true);
                    }
                }
                msInfo.setLanguageSyntax(this.fCurrentFileInstance.getLanguageSyntax());
                break;
            }
            case 2: {
                List<VlogFileInstance> fileInstances;
                VlogLoadedInfo mlInfo = (VlogLoadedInfo)info;
                mlInfo.setLanguageSyntax(this.fCurrentFileInstance.getLanguageSyntax());
                mlInfo.setNofRawLines(this.fCurrentFileInstance.getNofRawLines());
                mlInfo.setIndex(this.fCurrentFileInstance.getIndex());
                ParserPath parserPath = mlInfo.getParserPath();
                if (this.fParsingKind == 2 && (fileInstances = this.fTopFileInstance.getFileInstances(this.fCurrentFileInstance.getParserPath())) != null && !fileInstances.isEmpty()) {
                    mlInfo.setNofRawLines(fileInstances.get(0).getNofRawLines());
                }
                if (this.fParsingKind == 3 && this.fRfProject != null) {
                    this.fCurrentFileInstance.cleanRemovedIncludedFiles();
                }
                if (!this.fCurrentFileInstance.getParserPath().equals((Object)parserPath)) break;
                VlogFileInstance fileInstance = this.fCurrentFileInstance.getIncludingFileInfo();
                this.setCurrentFile(fileInstance);
                break;
            }
        }
    }

    protected void restoreIncludedFile(String parserPath, int line, int offset) {
        assert (this.fCurrentFileInstance != null);
        this.fCurrentFileInstance.restoreIncludedFile(new ParserPath(parserPath), line, offset);
    }

    protected List<IDVTFileInstance> getFileInstances(ParserPath parserPath) {
        ArrayList<IDVTFileInstance> fileInstances = new ArrayList<IDVTFileInstance>();
        if (this.fTopFileInstance == null) {
            return fileInstances;
        }
        if (this.fTopFileInstance.getParserPath().equals((Object)parserPath)) {
            fileInstances.add(this.fTopFileInstance);
            return fileInstances;
        }
        fileInstances.addAll(this.fTopFileInstance.getFileInstances(parserPath));
        return fileInstances;
    }

    public VlogFileInstance getCurrentFileInstance() {
        return this.fCurrentFileInstance;
    }

    public synchronized void addParsingListenerLT(IParsingListener l) {
        this.fParsingListenersLT.add(l);
    }

    public synchronized void removeParsingListenerLT(IParsingListener l) {
        this.fParsingListenersLT.remove(l);
    }

    public synchronized void addParsingListenerPT(IParsingListener l) {
        this.fParsingListenersPT.add(l);
    }

    public synchronized void removeParsingListenerPT(IParsingListener l) {
        this.fParsingListenersPT.remove(l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getMacroString(String string, IBuildConfigParserConstants.ToolCompat toolCompat, VlogLexersStack lS) throws VlogException {
        boolean reiterate = false;
        String original = string;
        StringBuilder reparseStackTrace = new StringBuilder();
        do {
            if (lS != null && lS.getInterrupt()) {
                return string;
            }
            reiterate = false;
            int whitespaces = 0;
            int length = string.length();
            char[] charArray = new char[length];
            string.getChars(0, length, charArray, 0);
            int state = 0;
            StringBuilder macroName = null;
            StringBuilder macroParam = null;
            int nested = 0;
            int startIndex = 0;
            int endIndex = 0;
            boolean backslash = false;
            int i = 0;
            block6: while (i < charArray.length) {
                char ch = charArray[i];
                endIndex = i;
                switch (state) {
                    case 0: {
                        if (backslash || ch != '`') break;
                        startIndex = i;
                        macroName = new StringBuilder();
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (ch == '\\') {
                            state = 0;
                            break;
                        }
                        if (whitespaces == 0 && Character.isJavaIdentifierPart(ch)) {
                            reiterate = true;
                            if (macroName == null) break;
                            macroName.append(ch);
                            break;
                        }
                        if (Character.isWhitespace(ch)) {
                            ++whitespaces;
                            break;
                        }
                        if (ch == '(' && macroName != null) {
                            VlogMacroInfo macro = this.getDefine(macroName.toString(), false);
                            if (macro == null || !macro.hasParams()) break;
                            macroParam = new StringBuilder();
                            state = 2;
                            break;
                        }
                        endIndex = endIndex - whitespaces - 1;
                        break block6;
                    }
                    case 2: {
                        if (ch == '(') {
                            ++nested;
                            if (macroParam == null) break;
                            macroParam.append(ch);
                            break;
                        }
                        if (ch == ')' && nested == 0) break block6;
                        if (ch == ')') {
                            --nested;
                            if (macroParam == null) break;
                            macroParam.append(ch);
                            break;
                        }
                        if (macroParam == null) break;
                        macroParam.append(ch);
                    }
                }
                backslash = ch == '\\' ? !backslash : false;
                ++i;
            }
            if (macroName != null && reiterate) {
                String macroNameText = macroName.toString();
                VlogMacroInfo macro = this.getDefine(macroNameText, false);
                if (macro == null) {
                    String message = null;
                    if (macroNameText.startsWith("VMM_HW_")) {
                        message = macroNameText.substring(7).replace("_", " ");
                        throw new VlogException(SEVERITY_ERROR, message, reparseStackTrace.toString());
                    }
                    message = "Undefined macro name: `" + macroNameText;
                    throw new VlogException(SEVERITY_ERROR, message, reparseStackTrace.toString());
                }
                reparseStackTrace.append(MessageFormat.format("    inside macro {0} at line {1} in ''{2}''", macroName.insert(0, "`").toString(), macro.getLine(), Utils.getInstance().getFileName(macro.getFileInstance().getParserPath().path))).append("\n");
                String[] parameters = macroParam == null ? null : VlogUtil.splitParameters(macroParam.toString(), toolCompat);
                String replacement = macro.getReplacement(this, parameters);
                string = string.substring(0, startIndex) + replacement + string.substring(endIndex + 1);
                if (DVT_DEBUG_VLOG_MACRO_STRING_EXPANSION) {
                    StringBuilder messageSB = new StringBuilder().append("DVT_DEBUG_MACRO_STRING: Expanded macro: ").append((CharSequence)macroName).append("(");
                    if (parameters != null) {
                        int i2 = 0;
                        while (i2 < parameters.length) {
                            messageSB.append(parameters[i2]);
                            if (i2 < parameters.length - 1) {
                                messageSB.append(", ");
                            }
                            ++i2;
                        }
                    }
                    messageSB.append(")");
                    DVTLogger.INSTANCE.logError(messageSB.toString());
                }
            }
            if (!DVT_DEBUG_VLOG_MACRO_STRING_EXPANSION) continue;
            DVTLogger.INSTANCE.logError("DVT_DEBUG_MACRO_STRING: Original: " + original + " => Expansion: " + string);
        } while (reiterate);
        return VlogMacroText.cleanup(this, string).toString();
    }

    public static String[] splitParameters(String text, IBuildConfigParserConstants.ToolCompat toolCompat) {
        if (text == null) {
            return EMPTY_STRING_ARRAY;
        }
        int nested = 0;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        int p = 0;
        boolean isString1 = false;
        boolean isString2 = false;
        boolean escapedID = false;
        boolean backslash = false;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!isString2 && !escapedID && p == 96 && c == '\"') {
                isString1 = !isString1;
            } else if (!(isString1 || escapedID || backslash || c != '\"')) {
                isString2 = !isString2;
            } else if (!isString2 && !isString1 && backslash && !Character.isWhitespace(c)) {
                escapedID = true;
            } else if (escapedID && c == '\ufff0') {
                escapedID = false;
            }
            if (isString1 || isString2) {
                sb.append(c);
            } else if (!(escapedID || c != '{' && c != '(' && c != '[')) {
                sb.append(c);
                ++nested;
            } else if (!(escapedID || c != '}' && c != ')' && c != ']')) {
                sb.append(c);
                --nested;
            } else if (!escapedID && c == ',' && nested == 0) {
                params.add(VlogUtil.trimCustom(sb));
                sb.delete(0, sb.length());
            } else if (toolCompat != IBuildConfigParserConstants.ToolCompat.VCS_VLOGAN || c != '\r' && c != '\n') {
                sb.append(c);
            }
            p = c;
            backslash = c == '\\' ? !backslash : false;
            ++i;
        }
        params.add(VlogUtil.trimCustom(sb));
        return params.toArray(new String[params.size()]);
    }

    private StringBuilder preprocess(CharSequence text, int line, ParserPath parserPath, IIdentifierIndexerExtension indexer) throws VlogException {
        VlogMacroInfo macro;
        if (text == null) {
            return null;
        }
        PREPROC_STATE state = PREPROC_STATE.TEXT;
        StringBuilder result = new StringBuilder();
        int length = text.length();
        int offset = 0;
        boolean backslash = false;
        boolean oddnticks = false;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            switch (state) {
                case TEXT: {
                    if (ch == '\"' && !backslash) {
                        state = !oddnticks ? PREPROC_STATE.STRING : PREPROC_STATE.STRING_DEF;
                    } else if (ch == '`' && i < length - 1) {
                        offset = result.length();
                        char nc = text.charAt(i + 1);
                        state = !oddnticks && nc == '\\' ? PREPROC_STATE.DEFINE_ESC : (!oddnticks && Character.isJavaIdentifierStart(nc) ? PREPROC_STATE.DEFINE : PREPROC_STATE.TEXT);
                    } else {
                        state = ch == '\\' ? PREPROC_STATE.TEXT_ESC : PREPROC_STATE.TEXT;
                    }
                    result.append(ch);
                    break;
                }
                case TEXT_ESC: {
                    state = Character.isWhitespace(ch) ? PREPROC_STATE.TEXT : PREPROC_STATE.TEXT_ESC;
                    result.append(ch);
                    break;
                }
                case DEFINE: {
                    String replacement;
                    VlogMacroInfo macro2;
                    state = ch == '\"' && !backslash ? PREPROC_STATE.STRING : (!Character.isJavaIdentifierPart(ch) ? PREPROC_STATE.TEXT : PREPROC_STATE.DEFINE);
                    if (state != PREPROC_STATE.DEFINE && (macro2 = this.getDefine(result.substring(offset + 1), false)) != null && !macro2.hasParams()) {
                        indexer.index2(macro2.getName(), line, -1, 542, true, false, true);
                        result.delete(offset, result.length());
                        replacement = macro2.getReplacement(this, null, line, parserPath);
                        if (replacement != null && !replacement.isEmpty()) {
                            result.append(replacement);
                            this.fRfProject.lintTrackMacroCall(parserPath, macro2.getName());
                        }
                    }
                    result.append(ch);
                    break;
                }
                case DEFINE_ESC: {
                    VlogMacroInfo macro3;
                    state = Character.isWhitespace(ch) ? PREPROC_STATE.TEXT : PREPROC_STATE.DEFINE_ESC;
                    result.append(ch);
                    if (state == PREPROC_STATE.DEFINE_ESC || (macro3 = this.getDefine(String.valueOf(result.substring(offset + 1, result.length() - 1)) + '\ufff0', false)) == null || macro3.hasParams()) break;
                    indexer.index2(macro3.getName(), line, -1, 542, true, false, true);
                    result.delete(offset, result.length());
                    String replacement = macro3.getReplacement(this, null, line, parserPath);
                    if (replacement == null || replacement.isEmpty()) break;
                    result.append(replacement);
                    this.fRfProject.lintTrackMacroCall(parserPath, macro3.getName());
                    break;
                }
                case STRING: {
                    state = ch == '\"' && !backslash ? PREPROC_STATE.TEXT : PREPROC_STATE.STRING;
                    result.append(ch);
                    break;
                }
                case STRING_DEF: {
                    state = ch == '\"' && !backslash ? PREPROC_STATE.TEXT : PREPROC_STATE.STRING_DEF;
                    result.append(ch);
                }
            }
            boolean bl = ch == '\\' ? !backslash : (backslash = false);
            oddnticks = ch == '`' ? !oddnticks : false;
            ++i;
        }
        if (state == PREPROC_STATE.DEFINE && (macro = this.getDefine(result.substring(offset + 1), false)) != null && !macro.hasParams()) {
            indexer.index2(macro.getName(), line, -1, 542, true, false, true);
            result.delete(offset, result.length());
            String replacement = macro.getReplacement(this, null, line, parserPath);
            if (replacement != null && !replacement.isEmpty()) {
                result.append(replacement);
                this.fRfProject.lintTrackMacroCall(parserPath, macro.getName());
            }
        }
        return result;
    }

    protected String[] preprocess(String[] params, int line, ParserPath parserPath, IIdentifierIndexerExtension indexer) throws VlogException {
        if (params == null) {
            return null;
        }
        String[] preprocessedParams = new String[params.length];
        int i = 0;
        while (i < params.length) {
            StringBuilder paramPreprocess = this.preprocess(params[i], line, parserPath, indexer);
            boolean isEscapedID = paramPreprocess.length() > 0 && this.isEscaped(paramPreprocess.toString());
            preprocessedParams[i] = isEscapedID ? paramPreprocess.toString() : VlogUtil.trimCustom(paramPreprocess);
            ++i;
        }
        return preprocessedParams;
    }

    private boolean isEscaped(String paramPreprocess) {
        if (paramPreprocess == null || paramPreprocess.isEmpty()) {
            return false;
        }
        boolean hasBackSlash = false;
        int i = 0;
        while (i < paramPreprocess.length()) {
            if (paramPreprocess.charAt(i) == '\\') {
                hasBackSlash = true;
                break;
            }
            ++i;
        }
        return hasBackSlash && Character.isWhitespace(paramPreprocess.charAt(paramPreprocess.length() - 1));
    }

    protected static String trimCustom(StringBuilder text) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\ufff0') {
                indexes.add(i);
                text.setCharAt(i, '?');
            }
            ++i;
        }
        String result = text.toString().trim();
        if (indexes.isEmpty()) {
            return result;
        }
        int offset = text.toString().indexOf(result);
        text = new StringBuilder(result);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            text.setCharAt(index - offset, ' ');
        }
        result = text.toString();
        return result;
    }

    protected boolean hasAMSSupport() {
        return this.fAMSSupport;
    }

    protected Set<String> getRemovedKeywordsSet(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        Set<String> languageMap;
        Map<IBuildConfigParserConstants.LanguageSyntax, Set<String>> aopSupportMap;
        Map<Boolean, Map<IBuildConfigParserConstants.LanguageSyntax, Set<String>>> wrealSupportMap;
        Map<Boolean, Map<Boolean, Map<IBuildConfigParserConstants.LanguageSyntax, Set<String>>>> amsSupportMap = this.fRemovedKeywordsCache.get(this.fAMSSupport);
        if (amsSupportMap == null) {
            amsSupportMap = new HashMap<Boolean, Map<Boolean, Map<IBuildConfigParserConstants.LanguageSyntax, Set<String>>>>(2);
            this.fRemovedKeywordsCache.put(this.fAMSSupport, amsSupportMap);
        }
        if ((wrealSupportMap = amsSupportMap.get(this.fWrealSupport)) == null) {
            wrealSupportMap = new HashMap<Boolean, Map<IBuildConfigParserConstants.LanguageSyntax, Set<String>>>(2);
            amsSupportMap.put(this.fWrealSupport, wrealSupportMap);
        }
        if ((aopSupportMap = wrealSupportMap.get(this.fAOPSupport)) == null) {
            aopSupportMap = new EnumMap<IBuildConfigParserConstants.LanguageSyntax, Set<String>>(IBuildConfigParserConstants.LanguageSyntax.class);
            wrealSupportMap.put(this.fAOPSupport, aopSupportMap);
        }
        if ((languageMap = aopSupportMap.get(languageSyntax)) == null) {
            languageMap = VlogUtil.getKeywordsRemoveSet(languageSyntax, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport);
            aopSupportMap.put(languageSyntax, languageMap);
        }
        return languageMap;
    }

    protected String getLanguageSyntaxName(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        String result;
        switch (languageSyntax) {
            case VERILOG_1364_1995: {
                result = "VERILOG_1995";
                break;
            }
            case VERILOG_1364_1995_IUS: {
                result = "VERILOG_IUS_95";
                break;
            }
            case VERILOG_1364_2001: {
                result = "VERILOG_2001";
                break;
            }
            case VERILOG_1364_2001_noconfig: {
                result = "VERILOG_2001_NOCONFIG";
                break;
            }
            case VERILOG_1364_2005: {
                result = "VERILOG_2005";
                break;
            }
            case SYSTEMVERILOG_1800_2005: {
                result = "SYSTEM_VERILOG_2005";
                break;
            }
            case SYSTEMVERILOG_1800_2009: {
                result = "SYSTEM_VERILOG_2009";
                break;
            }
            case SYSTEMVERILOG_1800_2023: {
                result = "SYSTEM_VERILOG_2023";
                break;
            }
            case VERILOG_AMS_23: {
                return "VERILOG_AMS_2.3";
            }
            case SYSTEMVERILOG_AMS: {
                return "SYSTEM_VERILOG_AMS";
            }
            default: {
                result = "SYSTEM_VERILOG_2012";
            }
        }
        if (this.fAMSSupport) {
            result = result.concat("_AMS_2.3");
        } else if (this.fWrealSupport) {
            result = result.concat("_WREAL");
        }
        return result;
    }

    public static final HashSet<String> getKeywordsRemoveSet(IBuildConfigParserConstants.LanguageSyntax languageSyntax, boolean hasAOESupport, boolean hasAMSSupport, boolean hasWrealSupport) {
        HashSet<String> removedVerilogKeywords = new HashSet<String>();
        if (!hasAOESupport) {
            removedVerilogKeywords.add("after");
            removedVerilogKeywords.add("around");
            removedVerilogKeywords.add("dominates");
            removedVerilogKeywords.add("endextends");
            removedVerilogKeywords.add("hide");
            removedVerilogKeywords.add("hard");
            removedVerilogKeywords.add("rules");
            removedVerilogKeywords.add("virtuals");
        }
        if (languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_AMS) {
            removedVerilogKeywords.add("endconnectmodule");
        }
        if (!(hasAMSSupport || languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2023 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2012 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2005 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2005 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS)) {
            removedVerilogKeywords.add("above");
            removedVerilogKeywords.add("abs");
            removedVerilogKeywords.add("absdelay");
            removedVerilogKeywords.add("absdelta");
            removedVerilogKeywords.add("abstol");
            removedVerilogKeywords.add("access");
            removedVerilogKeywords.add("acos");
            removedVerilogKeywords.add("acosh");
            removedVerilogKeywords.add("ac_stim");
            removedVerilogKeywords.add("aliasparam");
            removedVerilogKeywords.add("analog");
            removedVerilogKeywords.add("analysis");
            removedVerilogKeywords.add("asin");
            removedVerilogKeywords.add("asinh");
            removedVerilogKeywords.add("atan");
            removedVerilogKeywords.add("atan2");
            removedVerilogKeywords.add("atanh");
            removedVerilogKeywords.add("branch");
            removedVerilogKeywords.add("ceil");
            removedVerilogKeywords.add("connect");
            removedVerilogKeywords.add("connectmodule");
            removedVerilogKeywords.add("connectrules");
            removedVerilogKeywords.add("continuous");
            removedVerilogKeywords.add("cos");
            removedVerilogKeywords.add("cosh");
            removedVerilogKeywords.add("dynamicparam");
            if (languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2023 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2012 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2005) {
                removedVerilogKeywords.add("cross");
            }
            removedVerilogKeywords.add("ddt");
            removedVerilogKeywords.add("ddt_nature");
            removedVerilogKeywords.add("ddx");
            removedVerilogKeywords.add("discipline");
            removedVerilogKeywords.add("discrete");
            removedVerilogKeywords.add("domain");
            removedVerilogKeywords.add("driver_update");
            removedVerilogKeywords.add("endconnectrules");
            removedVerilogKeywords.add("enddiscipline");
            removedVerilogKeywords.add("endnature");
            removedVerilogKeywords.add("endparamset");
            removedVerilogKeywords.add("exclude");
            removedVerilogKeywords.add("exp");
            removedVerilogKeywords.add("final_step");
            removedVerilogKeywords.add("flicker_noise");
            removedVerilogKeywords.add("floor");
            removedVerilogKeywords.add("flow");
            removedVerilogKeywords.add("from");
            removedVerilogKeywords.add("ground");
            removedVerilogKeywords.add("hypot");
            removedVerilogKeywords.add("idt");
            removedVerilogKeywords.add("idtmod");
            removedVerilogKeywords.add("idt_nature");
            removedVerilogKeywords.add("inf");
            removedVerilogKeywords.add("initial_step");
            removedVerilogKeywords.add("laplace_nd");
            removedVerilogKeywords.add("laplace_np");
            removedVerilogKeywords.add("laplace_zd");
            removedVerilogKeywords.add("laplace_zp");
            removedVerilogKeywords.add("last_crossing");
            removedVerilogKeywords.add("limexp");
            removedVerilogKeywords.add("ln");
            removedVerilogKeywords.add("log");
            removedVerilogKeywords.add("max");
            removedVerilogKeywords.add("merged");
            removedVerilogKeywords.add("min");
            removedVerilogKeywords.add("nature");
            removedVerilogKeywords.add("net_resolution");
            removedVerilogKeywords.add("noise_table");
            removedVerilogKeywords.add("noise_table_log");
            removedVerilogKeywords.add("paramset");
            removedVerilogKeywords.add("potential");
            removedVerilogKeywords.add("pow");
            removedVerilogKeywords.add("realresolve");
            removedVerilogKeywords.add("resolveto");
            removedVerilogKeywords.add("sin");
            removedVerilogKeywords.add("sinh");
            removedVerilogKeywords.add("slew");
            removedVerilogKeywords.add("split");
            removedVerilogKeywords.add("sqrt");
            if (languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2023 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2012 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2005) {
                removedVerilogKeywords.add("string");
            }
            removedVerilogKeywords.add("tan");
            removedVerilogKeywords.add("tanh");
            removedVerilogKeywords.add("timer");
            removedVerilogKeywords.add("transition");
            removedVerilogKeywords.add("units");
            removedVerilogKeywords.add("white_noise");
            if (!hasWrealSupport) {
                removedVerilogKeywords.add("wreal");
            }
            removedVerilogKeywords.add("zi_nd");
            removedVerilogKeywords.add("zi_np");
            removedVerilogKeywords.add("zi_zd");
            removedVerilogKeywords.add("zi_zp");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2005 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2005 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS) {
            removedVerilogKeywords.add("implements");
            removedVerilogKeywords.add("interconnect");
            removedVerilogKeywords.add("nettype");
            removedVerilogKeywords.add("soft");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2005 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2005 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS) {
            removedVerilogKeywords.add("accept_on");
            removedVerilogKeywords.add("checker");
            removedVerilogKeywords.add("endchecker");
            removedVerilogKeywords.add("eventually");
            removedVerilogKeywords.add("global");
            removedVerilogKeywords.add("nexttime");
            removedVerilogKeywords.add("implies");
            removedVerilogKeywords.add("let");
            removedVerilogKeywords.add("reject_on");
            removedVerilogKeywords.add("restrict");
            removedVerilogKeywords.add("s_nexttime");
            removedVerilogKeywords.add("s_always");
            removedVerilogKeywords.add("s_eventually");
            removedVerilogKeywords.add("s_until");
            removedVerilogKeywords.add("s_until_with");
            removedVerilogKeywords.add("strong");
            removedVerilogKeywords.add("sync_accept_on");
            removedVerilogKeywords.add("sync_reject_on");
            removedVerilogKeywords.add("until");
            removedVerilogKeywords.add("until_with");
            removedVerilogKeywords.add("untyped");
            removedVerilogKeywords.add("weak");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2005 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS) {
            removedVerilogKeywords.add("alias");
            removedVerilogKeywords.add("always_comb");
            removedVerilogKeywords.add("always_ff");
            removedVerilogKeywords.add("always_latch");
            removedVerilogKeywords.add("assert");
            removedVerilogKeywords.add("assume");
            removedVerilogKeywords.add("before");
            removedVerilogKeywords.add("bind");
            removedVerilogKeywords.add("bins");
            removedVerilogKeywords.add("binsof");
            removedVerilogKeywords.add("bit");
            removedVerilogKeywords.add("break");
            removedVerilogKeywords.add("byte");
            removedVerilogKeywords.add("chandle");
            removedVerilogKeywords.add("class");
            removedVerilogKeywords.add("clocking");
            removedVerilogKeywords.add("const");
            removedVerilogKeywords.add("constraint");
            removedVerilogKeywords.add("context");
            removedVerilogKeywords.add("continue");
            removedVerilogKeywords.add("cover");
            removedVerilogKeywords.add("covergroup");
            removedVerilogKeywords.add("coverpoint");
            if (!hasAMSSupport && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23 && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_AMS) {
                removedVerilogKeywords.add("cross");
            }
            removedVerilogKeywords.add("dist");
            removedVerilogKeywords.add("do");
            removedVerilogKeywords.add("endclass");
            removedVerilogKeywords.add("endclocking");
            removedVerilogKeywords.add("endgroup");
            removedVerilogKeywords.add("endinterface");
            removedVerilogKeywords.add("endpackage");
            removedVerilogKeywords.add("endprogram");
            removedVerilogKeywords.add("endproperty");
            removedVerilogKeywords.add("endsequence");
            removedVerilogKeywords.add("enum");
            removedVerilogKeywords.add("expect");
            removedVerilogKeywords.add("export");
            removedVerilogKeywords.add("extends");
            removedVerilogKeywords.add("extern");
            removedVerilogKeywords.add("final");
            removedVerilogKeywords.add("first_match");
            removedVerilogKeywords.add("foreach");
            removedVerilogKeywords.add("forkjoin");
            removedVerilogKeywords.add("iff");
            removedVerilogKeywords.add("ignore_bins");
            removedVerilogKeywords.add("illegal_bins");
            removedVerilogKeywords.add("import");
            removedVerilogKeywords.add("inside");
            removedVerilogKeywords.add("int");
            removedVerilogKeywords.add("interface");
            removedVerilogKeywords.add("intersect");
            removedVerilogKeywords.add("join_any");
            removedVerilogKeywords.add("join_none");
            removedVerilogKeywords.add("local");
            removedVerilogKeywords.add("logic");
            removedVerilogKeywords.add("longint");
            removedVerilogKeywords.add("matches");
            removedVerilogKeywords.add("modport");
            removedVerilogKeywords.add("new");
            removedVerilogKeywords.add("null");
            removedVerilogKeywords.add("option");
            removedVerilogKeywords.add("package");
            removedVerilogKeywords.add("packed");
            removedVerilogKeywords.add("priority");
            removedVerilogKeywords.add("program");
            removedVerilogKeywords.add("property");
            removedVerilogKeywords.add("protected");
            removedVerilogKeywords.add("pure");
            removedVerilogKeywords.add("rand");
            removedVerilogKeywords.add("randc");
            removedVerilogKeywords.add("randcase");
            removedVerilogKeywords.add("randsequence");
            removedVerilogKeywords.add("randomize");
            removedVerilogKeywords.add("ref");
            removedVerilogKeywords.add("return");
            removedVerilogKeywords.add("sequence");
            removedVerilogKeywords.add("shortint");
            removedVerilogKeywords.add("shortreal");
            removedVerilogKeywords.add("solve");
            removedVerilogKeywords.add("static");
            if (!hasAMSSupport && languageSyntax != IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23) {
                removedVerilogKeywords.add("string");
            }
            removedVerilogKeywords.add("struct");
            removedVerilogKeywords.add("super");
            removedVerilogKeywords.add("tagged");
            removedVerilogKeywords.add("this");
            removedVerilogKeywords.add("throughout");
            removedVerilogKeywords.add("timeprecision");
            removedVerilogKeywords.add("timeunit");
            removedVerilogKeywords.add("type");
            removedVerilogKeywords.add("typedef");
            removedVerilogKeywords.add("union");
            removedVerilogKeywords.add("unique");
            removedVerilogKeywords.add("var");
            removedVerilogKeywords.add("virtual");
            removedVerilogKeywords.add("void");
            removedVerilogKeywords.add("wait_order");
            removedVerilogKeywords.add("wildcard");
            removedVerilogKeywords.add("with");
            removedVerilogKeywords.add("within");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS) {
            removedVerilogKeywords.add("uwire");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS) {
            removedVerilogKeywords.add("automatic");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995) {
            removedVerilogKeywords.add("cell");
            removedVerilogKeywords.add("config");
            removedVerilogKeywords.add("design");
            removedVerilogKeywords.add("endconfig");
            removedVerilogKeywords.add("incdir");
            removedVerilogKeywords.add("include");
            removedVerilogKeywords.add("liblist");
            removedVerilogKeywords.add("library");
            removedVerilogKeywords.add("use");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS) {
            removedVerilogKeywords.add("generate");
            removedVerilogKeywords.add("endgenerate");
            removedVerilogKeywords.add("genvar");
            removedVerilogKeywords.add("localparam");
        }
        if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995) {
            removedVerilogKeywords.add("pulsestyle_onevent");
            removedVerilogKeywords.add("pulsestyle_ondetect");
            removedVerilogKeywords.add("showcancelled");
            removedVerilogKeywords.add("noshowcancelled");
        }
        return removedVerilogKeywords;
    }

    protected void setKeywordSetByExtension(Map<String, String> extensionKeywordsetMap) {
        this.fExtensionKeywordsetMap = extensionKeywordsetMap;
    }

    protected IBuildConfigParserConstants.LanguageSyntax getLanguageSyntaxByExtension(String parserPath) {
        if (this.fExtensionKeywordsetMap == null) {
            return VlogUtil.getDefaultLanguageSyntax();
        }
        String extension = "." + Path.fromOSString((String)parserPath).getFileExtension();
        if (this.fExtensionKeywordsetMap.containsKey(extension)) {
            String keywordSet = this.fExtensionKeywordsetMap.get(extension);
            if (KEYWORDSET_MAP.containsKey(keywordSet)) {
                return KEYWORDSET_MAP.get(keywordSet);
            }
            return VlogUtil.getDefaultLanguageSyntax();
        }
        return VlogUtil.getDefaultLanguageSyntax();
    }

    protected void setUseIncludedObeysLanguageSyntax(boolean useIncludedObeysLanguageSyntax) {
        this.fUseIncludedObeysLanguageSyntax = useIncludedObeysLanguageSyntax;
    }

    protected boolean isUseIncludeExtensionLanguageSyntax() {
        return this.fUseIncludedObeysLanguageSyntax;
    }

    public String getCrossPlatformPath(String inputPath) {
        return DVTUtilsCommon.INSTANCE.getCrossPlatformPath(inputPath);
    }

    public String getFileSubstitute(String filePath) {
        if (this.fRfProject == null) {
            return filePath;
        }
        return DVTUtilsCommon.INSTANCE.getFileSubstitute(this.fRfProject.getProject(), filePath);
    }

    public void setSkipCompileFilter(SkipCompileFilter skipCompileFilter) {
        this.fSkipCompileFilter = skipCompileFilter;
    }

    public void setShallowCompileFilter(ShallowCompileFilter shallowCompileFilter) {
        this.fShallowCompileFilter = shallowCompileFilter;
    }

    public void setEncryptedCodeAutoFilter(EncryptedCodeAutoFilter encryptedCodeAutoFilter) {
        this.fEncryptedCodeAutoFilter = encryptedCodeAutoFilter;
    }

    public void setEncryptedCodeAutoNameFilter(EncryptedCodeAutoDefineByNameFilter encryptedCodeAutoNameFilter) {
        this.fEncryptedCodeAutoNameFilter = encryptedCodeAutoNameFilter;
    }

    public boolean isIgnored(File file) {
        if (this.fSkipCompileFilter == null) {
            return false;
        }
        ParserPath parserPath = new ParserPath(file.getAbsolutePath());
        return this.fSkipCompileFilter.shouldSkip(parserPath, true);
    }

    public boolean isShallowCompiled(RfNamedElement namedElement, ShallowCompileMode shallowMode) {
        if (namedElement == null) {
            return false;
        }
        if (fIsShallowCompileGeneral != null) {
            return fIsShallowCompileGeneral;
        }
        if (this.fShallowCompileFilter == null) {
            return false;
        }
        RfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return false;
        }
        ParserPath parserPath = declaration.getParserPath();
        if (parserPath == null) {
            return false;
        }
        return this.fShallowCompileFilter.shouldShallow(parserPath.path, namedElement.getFullName(), shallowMode);
    }

    public boolean hasEncryptedCodeAutoPath(ParserPath parserPath) {
        if (this.fEncryptedCodeAutoFilter == null) {
            return false;
        }
        return this.fEncryptedCodeAutoFilter.hasEncryptedCodeAutoPath(parserPath);
    }

    public boolean hasEncryptedCodeAuto() {
        return this.fEncryptedCodeAutoFilter == null ? false : this.fEncryptedCodeAutoFilter.hasEnabledEncryptedCodeAuto();
    }

    public EncryptedCodeAutoFilter getEncryptedCodeAutoFilter() {
        return this.fEncryptedCodeAutoFilter;
    }

    public void setEncryptedCodeSupport(boolean encryptedCodeSupport) {
        this.fEncryptedCodeSupport = encryptedCodeSupport;
    }

    public boolean hasEncryptedCodeSupport() {
        return this.fEncryptedCodeSupport;
    }

    protected void resetIndex() {
        this.fIndex = 1;
    }

    protected int getIndex() {
        return this.fIndex;
    }

    public static CommentBlock getHeaderCommentBlock(IDVTFileInstance fileInstance, int startLine) {
        if (fileInstance == null) {
            return null;
        }
        CommentsTable comments = fileInstance.getComments();
        if (comments == null) {
            return null;
        }
        HeaderCommentBlock headerCandidateAttachedToFirstElement = comments.getHeaderCandidateOnce();
        int lastCommentLine = 0;
        int glueLine = 0;
        int firstLineOfCode = comments.getFirstLineOfCode();
        boolean skipComment = true;
        String commentString = "";
        int firstLineOfAboveComment = -1;
        while (lastCommentLine < firstLineOfCode && skipComment) {
            StringBuilder commentSB = new StringBuilder();
            lastCommentLine = glueLine;
            glueLine = -1;
            int line = lastCommentLine + 1;
            while (line < firstLineOfCode) {
                Comment commentLine = comments.get(line);
                if (!Comment.isComment((Comment)commentLine)) break;
                int commentStartLine = commentLine.getStartLine();
                int commentEndLine = commentLine.getEndLine();
                if (commentStartLine != glueLine + 1 && glueLine >= 0) break;
                glueLine = commentEndLine;
                comments.remove(line);
                commentSB.append(commentLine.getComment()).append('\n');
                if (firstLineOfAboveComment < 0) {
                    firstLineOfAboveComment = commentStartLine;
                }
                ++line;
            }
            if ((commentString = commentSB.toString()).isEmpty()) break;
            boolean bl = skipComment = commentString.trim().isEmpty() || VlogUtil.matchesPattern(commentString, fCommentsPreferences.getExtractHeaderCommentIgnorePatterns()) || VlogUtil.matchesRegex(commentString, fCommentsPreferences.getExtractHeaderCommentIgnoreRegexes());
        }
        if (!commentString.isEmpty()) {
            return new CommentBlock(null, commentString, firstLineOfAboveComment, false, Comment.CommentStyle.NONE_KIND, Comment.CommentStyle.NONE_KIND);
        }
        if (headerCandidateAttachedToFirstElement != null) {
            return headerCandidateAttachedToFirstElement.getOnlyHeaderComment();
        }
        return null;
    }

    private static boolean matchesRegex(String commentString, Collection<Pattern> patternsToIgnore) {
        if (patternsToIgnore == null || patternsToIgnore.isEmpty()) {
            return false;
        }
        for (Pattern pattern : patternsToIgnore) {
            Matcher m = pattern.matcher(commentString);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesPattern(String commentString, Set<StringMatcher> patternsToIgnore) {
        if (patternsToIgnore == null || patternsToIgnore.isEmpty()) {
            return false;
        }
        for (StringMatcher pattern : patternsToIgnore) {
            if (!pattern.match(commentString)) continue;
            return true;
        }
        return false;
    }

    public static CommentBlock getCommentAtLine(IDVTFileInstance fileInstance, int startLine, boolean addAbove, int endLine, boolean addInline, boolean addHeader) {
        CommentBlock result = VlogUtil.getCommentAtLine(fileInstance, startLine, addAbove, endLine, addInline);
        if (!(addHeader &= fCommentsPreferences.getUseHeaderComment())) {
            return result;
        }
        CommentBlock headerCommentBlock = VlogUtil.getHeaderCommentBlock(fileInstance, startLine);
        if (headerCommentBlock == null) {
            return result;
        }
        if (result == null) {
            return headerCommentBlock;
        }
        result.setHeaderComment(headerCommentBlock.getRawAboveComment());
        return result;
    }

    public static CommentBlock getCommentAtLine(IDVTFileInstance fileInstance, int startLine, boolean addAbove, int endLine, boolean addInline) {
        return VlogUtil.getCommentAtLine(fileInstance, startLine, 0, addAbove, endLine, addInline);
    }

    public static CommentBlock getCommentAtLine(IDVTFileInstance fileInstance, int startLine, int upperLineLimit, boolean addAbove, int endLine, boolean addInline) {
        boolean isHeaderCandidate;
        if (startLine == -1 || endLine == -1) {
            return null;
        }
        if (fileInstance == null) {
            return null;
        }
        int currentLine = startLine;
        CommentsTable comments = fileInstance.getComments();
        if (comments == null) {
            return null;
        }
        if (!(addAbove &= fCommentsPreferences.getUseAboveComment()) && !(addInline &= fCommentsPreferences.getUseInlineComment())) {
            return null;
        }
        boolean isProtected = false;
        Comment protectedFlag = comments.get(startLine);
        if (Comment.isComment((Comment)protectedFlag)) {
            isProtected = protectedFlag.isProtected();
        }
        Comment commentInline = null;
        if (addInline) {
            commentInline = comments.get(endLine);
            comments.remove(endLine);
        }
        if (!addAbove) {
            if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
                return null;
            }
            return new CommentBlock(commentInline.getRawComment(), null, -1, isProtected, commentInline.getKind(), Comment.CommentStyle.NONE_KIND);
        }
        Comment commentAbove = comments.get(--currentLine);
        while (Comment.isEmptyLine((Comment)commentAbove) && currentLine > upperLineLimit && currentLine > startLine - 1 - fCommentsPreferences.getEmptyLinesAboveToSkip()) {
            commentAbove = comments.get(--currentLine);
        }
        if (!Comment.isComment((Comment)commentAbove) || commentAbove.isInline()) {
            if (!Comment.isComment((Comment)commentAbove)) {
                comments.remove(currentLine);
            }
            if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
                return null;
            }
            return new CommentBlock(commentInline.getRawComment(), null, -1, isProtected, commentInline.getKind(), Comment.CommentStyle.NONE_KIND);
        }
        int firstLineOfCode = comments.getFirstLineOfCode();
        boolean bl = isHeaderCandidate = firstLineOfCode < 0 || startLine == firstLineOfCode;
        if (commentAbove.getKind() == Comment.CommentStyle.ML_KIND || commentAbove.getKind() == Comment.CommentStyle.ML2_KIND) {
            comments.remove(currentLine);
            if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
                CommentBlock commentResult = new CommentBlock(null, commentAbove.getRawComment(), commentAbove.getStartLine(), isProtected, Comment.CommentStyle.NONE_KIND, commentAbove.getKind());
                if (isHeaderCandidate) {
                    commentResult = new HeaderCommentBlock(commentResult);
                    comments.setHeaderCommentBlock(commentResult);
                }
                return commentResult;
            }
            CommentBlock commentResult = new CommentBlock(commentInline.getRawComment(), commentAbove.getRawComment(), commentAbove.getStartLine(), isProtected, commentInline.getKind(), commentAbove.getKind());
            if (isHeaderCandidate) {
                commentResult = new HeaderCommentBlock(commentResult);
                comments.setHeaderCommentBlock(commentResult);
            }
            return commentResult;
        }
        StringBuilder result = new StringBuilder("");
        int endCommentLine = currentLine;
        int startCommentLine = currentLine;
        while (commentAbove.getKind() == Comment.CommentStyle.SL_KIND) {
            commentAbove = comments.get(--startCommentLine);
            if (startCommentLine > upperLineLimit && Comment.isComment((Comment)commentAbove) && !commentAbove.isInline() && commentAbove.getKind() == Comment.CommentStyle.SL_KIND) continue;
            ++startCommentLine;
            break;
        }
        Comment.CommentStyle commentType = Comment.CommentStyle.NONE_KIND;
        int i = startCommentLine;
        while (i < endCommentLine + 1) {
            commentAbove = comments.get(i);
            comments.remove(i);
            if (commentAbove != null) {
                commentType = commentAbove.getKind();
                String rawComment = commentAbove.getRawComment();
                result.append(VlogUtil.removeTrailingNewLines(rawComment)).append("\n");
            }
            ++i;
        }
        if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
            CommentBlock commentResult = new CommentBlock(null, result.toString(), startCommentLine, isProtected, Comment.CommentStyle.NONE_KIND, commentType);
            if (isHeaderCandidate) {
                commentResult = new HeaderCommentBlock(commentResult);
                comments.setHeaderCommentBlock(commentResult);
            }
            return commentResult;
        }
        CommentBlock commentResult = new CommentBlock(commentInline.getRawComment(), result.toString(), startCommentLine, isProtected, commentInline.getKind(), commentType);
        if (isHeaderCandidate) {
            commentResult = new HeaderCommentBlock(commentResult);
            comments.setHeaderCommentBlock(commentResult);
        }
        return commentResult;
    }

    private static String removeTrailingNewLines(String string) {
        int index = string.length();
        int i = string.length() - 1;
        while (i >= 0) {
            char charAt = string.charAt(i);
            if (charAt != '\n' && charAt != '\r') break;
            --index;
            --i;
        }
        return string.substring(0, index);
    }

    public static String getNonStandardSeverity() {
        return "*** Warning: ";
    }

    public static String getNonStandardMessage(RfNonStandardProblem problem, Object ... arguments) {
        return problem.getID() + problem.name() + ": " + problem.getMessage(arguments);
    }

    public void setCollectMacroCallsWithoutParams(boolean collect) {
        this.fCollectMacroCallsWithoutParams = collect;
    }

    public void setCollectMacroCallsWithParams(boolean collect) {
        this.fCollectMacroCallsWithParams = collect;
    }

    public synchronized void setDefaultKeywordsSet(String keywordSet) {
        fDefaultLanguageSyntax = KEYWORDSET_MAP.containsKey(keywordSet) ? KEYWORDSET_MAP.get(keywordSet) : IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2009;
    }

    public static IBuildConfigParserConstants.LanguageSyntax getDefaultLanguageSyntax() {
        return fDefaultLanguageSyntax;
    }

    public WaiverStatus isLinterSeverity(String severity) {
        return WaiverStatus.from(severity);
    }

    public void startLinterWaiverPragma(String file, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, WaiverStatus status, String[] rules, String waiverName, String waiverDescription, boolean isUVMFCustomPragma) {
        try {
            Map<String, PostWaiver> pragmaWaiversStack;
            PostWaiver waiver = new PostWaiver();
            waiver.setPathRegexType("simple");
            waiver.setName(waiverName);
            waiver.setStatus(status);
            waiver.setType(isUVMFCustomPragma ? WaiverType.UVMF_CUSTOM_PRAGMA : WaiverType.PRAGMA);
            waiver.addLineRange(new LineRange(line, line));
            String path = DVTStringUtil.intern((String)ro.amiq.dvt.utils.Utils.canonicPath((String)file));
            waiver.addRawPath(path);
            waiver.addPath(path);
            if (rules != null) {
                int i = 0;
                while (i < rules.length) {
                    if (rules[i].trim().length() != 0) {
                        waiver.addCheckName(rules[i]);
                    }
                    ++i;
                }
            }
            if (waiverName == null || waiverName.isEmpty()) {
                waiverName = "@" + new File(file).getName() + "-" + line + ":" + line;
                waiver.setName(waiverName);
            }
            if (waiverDescription != null && !waiverDescription.isEmpty()) {
                waiver.setDescription(waiverDescription);
            }
            if ((pragmaWaiversStack = this.currentWaiversStack()) == null) {
                return;
            }
            if (pragmaWaiversStack.containsKey(waiverName)) {
                int errorLine;
                String errorMessage;
                if (isUVMFCustomPragma) {
                    errorMessage = "Unexpected uvmf begin pragma with same name: " + waiverName + " at line: " + (pragmaWaiversStack.get(waiverName).getLineRanges().get(0).getStartLine() - 1) + ".";
                    errorLine = line - 1;
                } else {
                    errorMessage = "Unexpected @DVT_LINTER_WAIVER_START with same name: " + waiverName + " at line: " + pragmaWaiversStack.get(waiverName).getLineRanges().get(0).getStartLine() + ".";
                    errorLine = line;
                }
                this.reportError(SEVERITY_ERROR, file, languageSyntax, errorLine, errorMessage, this.fCurrentFileInstance == null ? 0 : this.fCurrentFileInstance.getIndex(), null);
                return;
            }
            pragmaWaiversStack.put(waiverName, waiver);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void endLinterWaiverPragma(String file, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, String waiverName, boolean isUVMFCustomPragma) {
        try {
            Map<String, PostWaiver> pragmaWaiversStack = this.currentWaiversStack();
            if (pragmaWaiversStack == null || pragmaWaiversStack.isEmpty()) {
                int errorLine;
                String errorMessage;
                if (isUVMFCustomPragma) {
                    errorMessage = "Unexpected uvmf end pragma (no starting uvmf begin pragma found)";
                    errorLine = line + 1;
                } else {
                    errorMessage = "Unexpected @DVT_LINTER_WAIVER_END (no starting @DVT_LINTER_WAIVER_START found)";
                    errorLine = line;
                }
                this.reportError(SEVERITY_ERROR, file, languageSyntax, errorLine, errorMessage, this.fCurrentFileInstance == null ? 0 : this.fCurrentFileInstance.getIndex(), null);
                return;
            }
            PostWaiver waiver = pragmaWaiversStack.get(waiverName);
            if (waiver == null && waiverName != null && !waiverName.isEmpty()) {
                int errorLine;
                String errorMessage;
                if (isUVMFCustomPragma) {
                    errorMessage = "Unexpected uvmf end pragma (no starting uvmf begin pragma found with the name: '" + waiverName + "')";
                    errorLine = line + 1;
                } else {
                    errorMessage = "Unexpected @DVT_LINTER_WAIVER_END (no starting @DVT_LINTER_WAIVER_START found with the name: '" + waiverName + "')";
                    errorLine = line;
                }
                this.reportError(SEVERITY_ERROR, file, languageSyntax, errorLine, errorMessage, this.fCurrentFileInstance == null ? 0 : this.fCurrentFileInstance.getIndex(), null);
                return;
            }
            if (waiver == null && (waiverName == null || waiverName.isEmpty())) {
                Map.Entry<String, PostWaiver> lastEntry = null;
                Iterator<Map.Entry<String, PostWaiver>> iterator = pragmaWaiversStack.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, PostWaiver> entry;
                    lastEntry = entry = iterator.next();
                }
                if (lastEntry != null) {
                    waiver = (PostWaiver)lastEntry.getValue();
                }
            }
            if (waiver == null) {
                return;
            }
            pragmaWaiversStack.remove(waiver.getName());
            if (waiver.getStatus() == WaiverStatus.NONE) {
                return;
            }
            waiver.getLineRanges().get(0).setEndLine(line);
            String fileName = new File(waiver.getPaths().get(0)).getName();
            String lineRange = waiver.getLineRanges().get(0).toString();
            if (waiver.getName() == null || waiver.getName().trim().isEmpty() || waiver.getName().equals("@" + fileName + "-" + waiver.getLineRanges().get(0).getStartLine() + ":" + waiver.getLineRanges().get(0).getStartLine())) {
                waiver.setName("@" + fileName + "-" + lineRange);
            }
            if (waiver.getDescription() == null || waiver.getDescription().isEmpty()) {
                waiver.setDescription("Code Waiver in file '" + fileName + "' lines " + lineRange);
            }
            this.addWaiverPragma(waiver);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void cleanWaiverStack(String file, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line) {
        Map<String, PostWaiver> pragmaWaiversStack = this.currentWaiversStack();
        if (pragmaWaiversStack != null && !pragmaWaiversStack.isEmpty()) {
            for (PostWaiver pragmaWaiver : pragmaWaiversStack.values()) {
                String errorMessage = pragmaWaiver.getType() == WaiverType.UVMF_CUSTOM_PRAGMA ? "Expecting uvmf end pragma waiver pragma started at " + (pragmaWaiver.getLineRanges().get(0).getStartLine() - 1) + "." : "Expecting @DVT_LINTER_WAIVER_END waiver pragma started at " + pragmaWaiver.getLineRanges().get(0).getStartLine() + ".";
                this.reportError(SEVERITY_ERROR, file, languageSyntax, Math.max(1, line), errorMessage, this.fCurrentFileInstance == null ? 0 : this.fCurrentFileInstance.getIndex(), null);
            }
            pragmaWaiversStack.clear();
        }
    }

    private Map<String, PostWaiver> currentWaiversStack() {
        if (this.fPragmaWaiversStack == null || this.fPragmaWaiversStack.isEmpty()) {
            return null;
        }
        return this.fPragmaWaiversStack.peek();
    }

    public void pushWaiverStack() {
        if (this.fPragmaWaiversStack == null) {
            this.fPragmaWaiversStack = new ArrayDeque<Map<String, PostWaiver>>();
        }
        this.fPragmaWaiversStack.push(new LinkedHashMap());
    }

    public void popWaiverStack(String file, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line) {
        try {
            this.cleanWaiverStack(file, languageSyntax, line);
            this.fPragmaWaiversStack.pop();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected final void addWaiverPragma(PostWaiver waiver) {
        if (!this.fRfProject.isLintingEnabled()) {
            return;
        }
        if (waiver.getStatus() == WaiverStatus.NONE) {
            return;
        }
        ParserPath parserPath = new ParserPath(waiver.getPaths().get(0));
        List<PostWaiver> waiversInFile = this.fWaiverPragmasByFile.get(parserPath);
        if (waiversInFile == null) {
            waiversInFile = new ArrayList<PostWaiver>();
            this.fWaiverPragmasByFile.put(parserPath, waiversInFile);
        }
        waiversInFile.add(waiver);
    }

    public void newLine(int line) {
        this.fCurrentFileInstance.newLine(line);
    }

    public void nextTokenLine(int line, boolean usePrevFileInstance) {
        if (usePrevFileInstance && this.fCurrentFileInstance.getIncludingFileInfo() != null) {
            this.fCurrentFileInstance.getIncludingFileInfo().nextTokenLine(line);
        } else {
            this.fCurrentFileInstance.nextTokenLine(line);
        }
    }

    public void addComment(Comment comment) {
        if (this.fDisableComments) {
            return;
        }
        if (!fCommentsPreferences.getAddSingleLineComment() && comment.getKind() == Comment.CommentStyle.SL_KIND) {
            return;
        }
        if (!fCommentsPreferences.getAddMultiLineComment() && comment.getKind() == Comment.CommentStyle.ML_KIND) {
            return;
        }
        if (!fCommentsPreferences.getAddMulti2LineComment() && comment.getKind() == Comment.CommentStyle.ML2_KIND) {
            return;
        }
        this.fCurrentFileInstance.addComment(comment);
    }

    public void addDefaultNettype(int line, String defaultNettype) {
        this.fCurrentFileInstance.addDefaultNettype(line, defaultNettype);
    }

    public void addTimescale(int line, String values) {
        this.fCurrentFileInstance.addTimescale(line, values);
    }

    public void resetTimescale(int line) {
        this.fCurrentFileInstance.resetTimescale(line, this.getEffectiveBuildConfigTimescale());
    }

    public static synchronized void setCommentsPreferences(DVTCodeCommentsPreferences commentsPreferences) {
        fCommentsPreferences = commentsPreferences == null ? new DVTCodeCommentsPreferences() : commentsPreferences;
    }

    protected final void createFullBuildMacroLookupMap(boolean cleanPrevInvocationDefines) {
        if (cleanPrevInvocationDefines) {
            this.fCurrentFileInstance = this.getTopFileInstance();
            if (this.fCurrentFileInstance != null) {
                this.undefAllMacros(false, true);
            }
        }
        this.fFullBuildMacroLookupMap = new HashMap<String, VlogMacroInfo>();
        this.fDependencyMacroFilesSetMap = new HashMap<String, Set<ParserPath>>();
        this.fCompiledFilesMap = new HashMap<ParserPath, DVTPair<ParserPath, Boolean>>();
        this.fDirtyFilesSet = new HashSet<ParserPath>();
        this.disabledFileInstances = new HashSet();
    }

    protected final void removeFullBuildMacroLookupMap() {
        this.fFullBuildMacroLookupMap = null;
        this.fDependencyMacroFilesSetMap = null;
        this.fCompiledFilesMap = null;
        this.fDirtyFilesSet = null;
        this.disabledFileInstances = null;
    }

    protected final void putMacroLookupInfo(String name, VlogMacroInfo currInfo) {
        if (this.fFullBuildMacroLookupMap != null) {
            this.fFullBuildMacroLookupMap.put(name, currInfo);
        }
    }

    public final void dependsOn(String macroName, boolean undefined) {
        VlogFileInstance instance = this.fCurrentFileInstance;
        do {
            this.addMacroDependecy(macroName, instance.getParserPath());
        } while ((instance = instance.getIncludingFileInfo()) != null);
    }

    public final void dependsOn(String macroName, VlogMacroText replacement) {
        VlogFileInstance instance = this.fCurrentFileInstance;
        do {
            this.addMacroDependecy(macroName, instance.getParserPath());
        } while ((instance = instance.getIncludingFileInfo()) != null);
    }

    private final void addMacroDependecy(String name, ParserPath parserPath) {
        if (this.fDisablePreprocOptimize) {
            return;
        }
        if (this.fDependencyMacroFilesSetMap == null) {
            return;
        }
        Set<ParserPath> dependencyMacroFilesSet = this.fDependencyMacroFilesSetMap.get(name);
        if (dependencyMacroFilesSet == null) {
            dependencyMacroFilesSet = new HashSet<ParserPath>();
            this.fDependencyMacroFilesSetMap.put(name, dependencyMacroFilesSet);
        }
        dependencyMacroFilesSet.add(parserPath);
    }

    protected final boolean shouldRecompile(File file, int line, int offset) {
        if (this.fDisablePreprocOptimize) {
            return true;
        }
        if (this.fCompiledFilesMap == null) {
            return true;
        }
        if (this.fDirtyFilesSet == null) {
            return true;
        }
        ParserPath parserPath = new ParserPath(file.getAbsolutePath());
        DVTPair<ParserPath, Boolean> pair = this.fCompiledFilesMap.get(parserPath);
        if (pair == null || ((Boolean)pair.getValue()).booleanValue()) {
            return true;
        }
        Boolean recompile = (Boolean)pair.getValue();
        recompile = this.fDirtyFilesSet.contains(parserPath);
        if (!recompile.booleanValue()) {
            if (this.fParsingKind == 0) {
                if (this.fCurrentFileInstance != null && !parserPath.equals((Object)this.fTopFileInstance.getParserPath())) {
                    VlogIncludingScope includingScope = new VlogIncludingScope(this.fCurrentFileInstance, line, offset);
                    VlogFileInstance fileInstance = new VlogFileInstance(this.fRfProject, parserPath, includingScope, this.fIndex, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
                    fileInstance.getParserPath().setMd5(((ParserPath)pair.getKey()).getMd5());
                    fileInstance.getParserPath().setSize(((ParserPath)pair.getKey()).getSize());
                    fileInstance.setOptimizeSkip();
                    if (this.fResetNettype) {
                        fileInstance.addDefaultNettype(0, "wire");
                        this.fResetNettype = false;
                    }
                    ++this.fIndex;
                }
            } else if (this.fParsingKind == 1 || this.fParsingKind == 2) {
                if (this.fCurrentFileInstance != null && !parserPath.equals((Object)new ParserPath(String.valueOf(this.fTopFileInstance.getParserPath().path) + ".libfile"))) {
                    VlogIncludingScope includingScope = new VlogIncludingScope(this.fCurrentFileInstance, line, offset);
                    VlogFileInstance fileInstance = new VlogFileInstance(this.fRfProject, parserPath, includingScope, this.fIndex, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
                    fileInstance.getParserPath().setMd5(((ParserPath)pair.getKey()).getMd5());
                    fileInstance.getParserPath().setSize(((ParserPath)pair.getKey()).getSize());
                    fileInstance.setOptimizeSkip();
                    ++this.fIndex;
                }
            } else if (this.fParsingKind == 3) {
                assert (this.fCurrentFileInstance != null);
                this.fCurrentFileInstance.prepareForReparse(true);
            }
        }
        return recompile;
    }

    public VlogFileInstance createIncrementalLibFileInstance(VlogIncludingScope includingScope) {
        ParserPath includeFileParserPath = new ParserPath(String.valueOf(this.fTopFileInstance.getParserPath().path) + ".libfile");
        VlogFileInstance fileInstance = new VlogFileInstance(this.fRfProject, includeFileParserPath, includingScope, -1, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
        return fileInstance;
    }

    protected final void addCompiledFile(VlogFileInstance fileInstance) {
        if (this.fDisablePreprocOptimize) {
            return;
        }
        if (this.fCompiledFilesMap == null) {
            return;
        }
        ParserPath parserPath = fileInstance.getParserPath();
        DVTPair<ParserPath, Boolean> recompile = this.fCompiledFilesMap.get(parserPath);
        if (recompile == null || ((Boolean)recompile.getValue()).booleanValue()) {
            this.fCompiledFilesMap.put(parserPath, (DVTPair<ParserPath, Boolean>)new DVTPair((Object)parserPath, (Object)false));
        }
    }

    protected final void removeCompiledFile(VlogFileInstance fileInstance) {
        if (this.fCompiledFilesMap == null) {
            return;
        }
        ParserPath parserPath = fileInstance.getParserPath();
        this.fCompiledFilesMap.remove(parserPath);
    }

    public final void setDisablePreprocOptimize(boolean disablePreprocOptimize) {
        this.fDisablePreprocOptimize = disablePreprocOptimize;
    }

    protected final void disablePreprocDependent(VlogFileInstance fileInstance) {
        if (this.fDisablePreprocOptimize || fileInstance == null) {
            return;
        }
        if (this.fCompiledFilesMap == null) {
            return;
        }
        VlogFileInstance instance = fileInstance;
        do {
            DVTPair pair;
            if ((pair = this.fCompiledFilesMap.get(instance.getParserPath())) == null) {
                pair = new DVTPair((Object)instance.getParserPath(), (Object)true);
            } else {
                pair.setValue((Object)true);
            }
            this.fCompiledFilesMap.put(instance.getParserPath(), (DVTPair<ParserPath, Boolean>)pair);
            this.setDisabledPreprocDependent(instance);
        } while ((instance = instance.getIncludingFileInfo()) != null);
    }

    public RfProject getRfProject() {
        return this.fRfProject;
    }

    private void setDisabledPreprocDependent(VlogFileInstance instance) {
        if (this.disabledFileInstances == null) {
            return;
        }
        this.disabledFileInstances.add(instance);
    }

    public boolean isDisabledPreprocDependent(VlogFileInstance instance) {
        if (this.disabledFileInstances == null) {
            return false;
        }
        return this.disabledFileInstances.contains(instance);
    }

    protected final void setCustomPragmas(List<CustomPragma> customPragmas) {
        if (customPragmas == null) {
            return;
        }
        this.fStartPragmas = new HashMap<String, CustomPragma>();
        this.fEndPragmas = new HashMap<String, CustomPragma>();
        this.fCustomPragmaFirstIdentifiers = new HashSet<String>();
        for (CustomPragma pragma : customPragmas) {
            if (!pragma.isEnabled() || pragma.isOverriden()) continue;
            this.fStartPragmas.put(pragma.getStartPragma(), pragma);
            this.fEndPragmas.put(pragma.getEndPragma(), pragma);
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier((String)pragma.getStartPragma()));
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier((String)pragma.getEndPragma()));
        }
    }

    protected final String processComment(String comment) {
        if (this.fStartPragmas == null || this.fEndPragmas == null || this.fStartPragmas.isEmpty() || this.fEndPragmas.isEmpty() || comment == null) {
            return null;
        }
        return DVTStringUtil.collapseWhitespaces((String)comment);
    }

    protected final CustomPragma getStartCustomPragma(String processedComment) {
        if (this.fStartPragmas == null || this.fStartPragmas.isEmpty() || processedComment == null) {
            return null;
        }
        return this.fStartPragmas.get(processedComment);
    }

    protected final CustomPragma getEndCustomPragma(String processedComment) {
        if (this.fEndPragmas == null || this.fEndPragmas.isEmpty() || processedComment == null) {
            return null;
        }
        return this.fEndPragmas.get(processedComment);
    }

    protected final boolean isCustomPragmaFirstIdentifier(String firstIdentifier) {
        if (this.fCustomPragmaFirstIdentifiers == null || firstIdentifier == null) {
            return false;
        }
        return this.fCustomPragmaFirstIdentifiers.contains(firstIdentifier);
    }

    public void addCustomPragmaUsage(CustomPragmaUsage pragma) {
        this.fCurrentFileInstance.addCustomPragma(pragma);
    }

    protected final void setTranslatePragmas(Set<String> translatePragmas) {
        this.fTranslatePragmas = translatePragmas;
    }

    protected final String getTranslateUsingPragma(String identifier, String comment) {
        if (this.fTranslatePragmas == null) {
            return comment;
        }
        if (this.fTranslatePragmas.contains(identifier)) {
            return comment.substring(identifier.length()).trim();
        }
        return comment;
    }

    public boolean isDefined(String text) {
        return this.getDefine(text, true) != null;
    }

    public String getValue(String text) {
        String result = "0";
        try {
            VlogMacroInfo define = this.getDefine(text, true);
            if (define != null) {
                result = define.hasReplacement() ? define.getReplacement(this, null) : "1";
            }
        }
        catch (Exception exception) {}
        return result;
    }

    protected final void setEnableIncludeEnvVarExpansion(boolean enableIncludeEnvVarExpansion) {
        this.fEnableIncludeEnvVarExpansion = enableIncludeEnvVarExpansion;
    }

    protected final boolean isEnableIncludeEnvVarExpansion() {
        return this.fEnableIncludeEnvVarExpansion;
    }

    public void setSvxMode(boolean fSvxMode) {
        this.fSvxMode = fSvxMode;
    }

    public boolean isSvxMode() {
        return this.fSvxMode;
    }

    public void setCpreprocEnabled(boolean fCpreprocEnabled) {
        this.fCpreprocEnabled = fCpreprocEnabled;
    }

    public boolean isCpreprocEnabled() {
        return this.fCpreprocEnabled;
    }

    protected final void setTaskTagsProperties(Set<String> taskNames, boolean caseSensitive, boolean hideTaskName) {
        if (caseSensitive) {
            this.fTaskNames = taskNames;
        } else if (taskNames == null) {
            this.fTaskNames = null;
        } else {
            this.fTaskNames = new HashSet<String>();
            for (String taskName : taskNames) {
                this.fTaskNames.add(taskName.toUpperCase());
            }
        }
        this.fTaskNamesCaseSensitive = caseSensitive;
        this.fHideTaskName = hideTaskName;
    }

    public void collectTaskTag(String firstIdentifier, String comment, int line, int offsetStart, int offsetEnd, ParserPath parserPath) {
        if (this.fDisableTaskTags) {
            return;
        }
        try {
            if (this.fTaskNames == null || firstIdentifier == null) {
                return;
            }
            int commentStartWithNewLine = comment.indexOf(firstIdentifier);
            int index = 0;
            while (index < commentStartWithNewLine) {
                if (comment.charAt(index) == '\n') {
                    ++line;
                    break;
                }
                ++index;
            }
            String commentToScan = comment;
            int commentLength = commentToScan.length();
            int i = 0;
            while (i < commentLength) {
                char ch = commentToScan.charAt(i);
                while (!Character.isJavaIdentifierPart(ch) && ch != '@') {
                    if (ch == '\n') {
                        ++line;
                    }
                    if (i >= commentLength - 1) {
                        return;
                    }
                    ch = commentToScan.charAt(++i);
                }
                StringBuilder possibleTaskTag = new StringBuilder();
                int startIndex = i;
                while (Character.isJavaIdentifierPart(ch) || ch == '@') {
                    possibleTaskTag.append(ch);
                    if (i == commentLength - 1) {
                        this.checkAndExtractPossibleTaskTag(line, parserPath, commentToScan, i, possibleTaskTag, startIndex, offsetStart);
                        return;
                    }
                    ch = commentToScan.charAt(++i);
                }
                i = this.checkAndExtractPossibleTaskTag(line, parserPath, commentToScan, i, possibleTaskTag, startIndex, offsetStart);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int checkAndExtractPossibleTaskTag(int line, ParserPath parserPath, String commentToScan, int currentIndex, StringBuilder possibleTaskTag, int startIndex, int offsetStart) {
        String taskTagCandidate;
        int possLength = possibleTaskTag.length();
        if (possLength >= 1 && !Character.isJavaIdentifierPart(possibleTaskTag.charAt(possLength - 1))) {
            possibleTaskTag = possibleTaskTag.deleteCharAt(possLength - 1);
        }
        String string = taskTagCandidate = this.fTaskNamesCaseSensitive ? possibleTaskTag.toString() : possibleTaskTag.toString().toUpperCase();
        if (this.fTaskNames.contains(taskTagCandidate)) {
            Set<TaskInfoWrapper> taskTable;
            String commentToDisplay = commentToScan.substring(startIndex, Math.min(startIndex + TASK_TAG_MAX_LINE_LENGTH, commentToScan.length()));
            commentToDisplay = DVTFileUtils.getInstance().cropFirstLine(commentToDisplay, 100);
            int newLineIndex = commentToScan.indexOf(10, currentIndex += commentToDisplay.length() - taskTagCandidate.length() - 1);
            if (newLineIndex > 0) {
                currentIndex = newLineIndex;
            }
            if ((taskTable = this.getTasks(parserPath)).size() < 100 || taskTagCandidate.equals("@DVT_EXPAND_MACRO_INLINE_START")) {
                int length = commentToDisplay.length();
                commentToDisplay = DVTFileUtils.getInstance().displayUpperCaseTaskTag(this.fTaskNamesCaseSensitive, this.fHideTaskName, commentToDisplay, taskTagCandidate);
                int taskTagStartOffset = offsetStart + startIndex;
                TaskInfoWrapper taskInfoWrapper = new TaskInfoWrapper(taskTagCandidate, line, taskTagStartOffset, taskTagStartOffset + length, commentToDisplay);
                taskTable.add(taskInfoWrapper);
            }
        }
        return currentIndex;
    }

    public void setIncdirCacheEnable(boolean isIncdirsCacheEnabled) {
        if (!isIncdirsCacheEnabled) {
            return;
        }
        if (this.fIncdirsCache == null) {
            this.fIncdirsCache = new HashMap<File, File[]>();
        }
    }

    protected Map<File, File[]> getIncdirsCache() {
        return this.fIncdirsCache;
    }

    protected void setIncdirsCache(Map<File, File[]> incdirsCache) {
        this.fIncdirsCache = incdirsCache;
    }

    protected HidImplicit[] getEffectiveBuildConfigTimescale() {
        return this.fBuildConfigOverrideTimescale != null ? this.fBuildConfigOverrideTimescale : this.fBuildConfigTimescale;
    }

    protected HidImplicit[] getBuildConfigOverrideTimescale() {
        return this.fBuildConfigOverrideTimescale;
    }

    protected final boolean isFile(File file) {
        IFileInfo fileInfo;
        if (this.fIncdirsCache != null) {
            File directory;
            File[] existingFiles;
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            if ((existingFiles = this.fIncdirsCache.get(directory = file.getParentFile())) == null) {
                existingFiles = directory.listFiles();
                if (existingFiles == null) {
                    existingFiles = new File[]{};
                }
                this.fIncdirsCache.put(directory, existingFiles);
            }
            File[] fileArray = existingFiles;
            int n = existingFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File existingFile = fileArray[n2];
                if (existingFile.hashCode() == file.hashCode() && existingFile.equals(file)) {
                    IPath filePath = DVTFileUtils.getInstance().pathOf(file);
                    IFileInfo fileInfo2 = DVTAutoLinkManager.getInstance().fetchFileInfo(filePath);
                    return fileInfo2.exists() && !fileInfo2.isDirectory();
                }
                ++n2;
            }
            return false;
        }
        IPath filePath = DVTFileUtils.getInstance().pathOf(file);
        if (!(this.fParsingKind != 4 && this.fParsingKind != 3 || (fileInfo = DVTAutoLinkManager.getInstance().getCachedFileInfo(filePath)) == null || fileInfo.exists())) {
            DVTAutoLinkManager.getInstance().removeFileInfo(filePath);
        }
        return (fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(filePath)).exists() && !fileInfo.isDirectory();
    }

    public void removeFullBuildCachedInfos() {
        if (this.fAvailableElements != null) {
            this.fAvailableElements.clear();
        }
        if (this.fIncdirsCache != null) {
            this.fIncdirsCache.clear();
            this.fIncdirsCache = null;
        }
    }

    public String replaceAllSystemVariables(String input) {
        final IProject project = this.fRfProject.getProject();
        if (project == null) {
            return input;
        }
        return DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)input, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, new DVTUtilsCommon.IEnvironmentProvider(){

            public String getenv(String name) {
                List invocations = BuildConfigManager.getInvocations((IProject)project);
                if (invocations == null || invocations.size() <= VlogUtil.this.fInvocNumber) {
                    return name;
                }
                return BuildConfigManager.getenv((Invocation)((Invocation)invocations.get(VlogUtil.this.fInvocNumber)), (String)name);
            }
        });
    }

    public void setSkipProtectedCode(boolean skipProtectedCode) {
        this.fSkipProtectedCode = skipProtectedCode;
    }

    public boolean isSkipProtectedCode() {
        return this.fSkipProtectedCode;
    }

    public void createIncrBuildMacrosLookupMap() {
        this.fCurrentFileInstance.createIncrBuildMacrosLookupMap();
    }

    public void setDisableComments(boolean disableComments) {
        this.fDisableComments = disableComments;
    }

    public void setDisableTaskTags(boolean disableTaskTags) {
        this.fDisableTaskTags = disableTaskTags;
    }

    protected final boolean isNewIncludedFile(File file) {
        IncrementalDeltaContainer incrementalDeltaContainer;
        if (this.fParsingKind == 4) {
            return false;
        }
        ParserPath parserPath = new ParserPath(file.getAbsolutePath());
        assert (this.fCurrentFileInstance != null);
        boolean isNewIncludedFile = this.fCurrentFileInstance.isNewIncludedFile(parserPath);
        if (this.fRfProject != null && isNewIncludedFile && (incrementalDeltaContainer = this.fRfProject.getIncrementalDeltaContainer()) != null) {
            incrementalDeltaContainer.addChangedParserPath(parserPath, true);
        }
        return isNewIncludedFile;
    }

    protected ParserPath getIncludedFile(String fileSuffix) {
        if (this.fParsingKind != 4 && this.fParsingKind != 3) {
            return null;
        }
        return this.fCurrentFileInstance.getIncludedFile(fileSuffix);
    }

    protected void startNewIncludedFile() {
        this.fParsingKind = 4;
    }

    protected void endNewIncludedFile() {
        this.fParsingKind = 3;
    }

    private VlogFileInstance createFileInstanceForNewIncludedFile(ParserPath parserPath, VlogIncludingScope includingScope) {
        VlogFileInstance includingInstance = includingScope.getIncludingInstance();
        if (includingInstance != null && parserPath.equals((Object)includingInstance.getParserPath())) {
            return includingInstance;
        }
        boolean isIncludingScopeNonTopFile = false;
        if (includingInstance != null) {
            isIncludingScopeNonTopFile = includingInstance.getIndex() == 0 || includingInstance.getIndex() == -2;
        }
        VlogFileInstance fileInstance = null;
        int indexOfFileInstance = isIncludingScopeNonTopFile ? -2 : -1;
        List<IDVTFileInstance> fileInstances = this.getFileInstances(parserPath);
        if (fileInstances != null && !fileInstances.isEmpty()) {
            for (IDVTFileInstance candidate : fileInstances) {
                if (candidate.getIndex() != 0 && candidate.getIndex() != -2) continue;
                ((VlogFileInstance)candidate).updateMacroZone(includingScope, indexOfFileInstance);
                fileInstance = (VlogFileInstance)candidate;
                this.cleanMessages(parserPath);
                this.fRfProject.quickFixRemoveNonTopFile(parserPath);
                break;
            }
        }
        if (fileInstance == null) {
            fileInstance = new VlogFileInstance(this.fRfProject, parserPath, includingScope, indexOfFileInstance, this.fIncdirs, this.fInvocNumber, this.fAOPSupport, this.fAMSSupport, this.fWrealSupport, this.fToolCompat, this.fIsPrecompiledDb);
        }
        return fileInstance;
    }

    public void clearSyntaxErrorsOnIncrementalNewIncludeFiles() {
        this.fIncrementalNewIncludeFiles.clear();
    }

    public void updateSyntaxErrorsOnIncrementalNewIncludeFiles() {
        for (ParserPath parserPath : this.fIncrementalNewIncludeFiles) {
            this.fRfProject.updateSyntaxErrors(parserPath, this.getErrors(parserPath), this.getWarnings(parserPath), this.getTasks(parserPath));
        }
    }

    public void includedFileNotFound(String origFileName) {
        this.fPreprocessingInfo.includedFileNotFound(this.fCurrentFileInstance, origFileName);
    }

    public void clearIncludedFileNotFound(VlogFileInstance fileInstance) {
        this.fPreprocessingInfo.clearIncludedFileNotFound(fileInstance);
    }

    public boolean isCompactMacros() {
        return this.fCompactMacros;
    }

    public void setCompactMacros(boolean fCompactMacros) {
        this.fCompactMacros = fCompactMacros;
    }

    public StringReplace newStringReplace(String replacement, boolean replace) {
        if (this.isCompactMacros() && replacement.length() > 20) {
            return new CompactStringReplace(replacement, replace);
        }
        return new RegularStringReplace(replacement, replace);
    }

    public Map<ParserPath, Boolean> getEncryptedTableMap() {
        return this.fEncryptedTableMap;
    }

    protected boolean isPVlogPreprocessing(ParserPath parserPath) {
        return PreprocDiffManager.INSTANCE.hasPreprocMacros(parserPath);
    }

    protected int getPVlogCompilationOffset(ParserPath parserPath, int offset) {
        return PreprocDiffManager.INSTANCE.getCompilationOffset(parserPath, offset);
    }

    protected int getPVlogCompilationLine(ParserPath parserPath, int compilationOffset) {
        return PreprocDiffManager.INSTANCE.getCompilationLine(parserPath, compilationOffset);
    }

    protected boolean isInsidePVlogRegion(ParserPath parserPath, int compilationOffset) {
        return PreprocDiffManager.INSTANCE.isInsidePreprocMacro(parserPath, compilationOffset);
    }

    protected InputStream createPVlogCompilationInputStream(ParserPath parserPath) {
        return PreprocUtils.getInstance().createPreprocCompilationInputStream(parserPath);
    }

    public void setFirstFileIndexOffset(int offset) {
        this.fIndex += offset;
    }

    public void setPrecompiledDb(boolean iPrecompiledDb) {
        this.fIsPrecompiledDb = iPrecompiledDb;
    }

    public void setBuildConfigTimescale(HidImplicit[] buildConfigTimescale) {
        this.fBuildConfigTimescale = buildConfigTimescale;
    }

    public void setBuildConfigOverrideTimescale(HidImplicit[] buildConfigOverrideTimescale) {
        this.fBuildConfigOverrideTimescale = buildConfigOverrideTimescale;
    }

    public boolean isPrecompiledDb() {
        return this.fIsPrecompiledDb;
    }

    public VlogMacroInfo createDummyMacroInfo(RfProject rfp, String preprocFilesDummyToken) {
        IMacroInfo dummyMacroInfo = PreprocUtils.getInstance().getDummyMacroInfo((IRfSingleLangProject)rfp);
        if (dummyMacroInfo == null) {
            dummyMacroInfo = VlogMacroInfo.createDummyMacroInfo(rfp, preprocFilesDummyToken, preprocFilesDummyToken);
            PreprocUtils.getInstance().putDummyMacroInfo((IRfSingleLangProject)rfp, dummyMacroInfo);
        }
        if (!(dummyMacroInfo instanceof VlogMacroInfo)) {
            return null;
        }
        return (VlogMacroInfo)dummyMacroInfo;
    }

    private static enum PREPROC_STATE {
        TEXT,
        TEXT_ESC,
        DEFINE,
        DEFINE_ESC,
        STRING,
        STRING_DEF;

    }
}

