/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.precompiled;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import ro.amiq.dvt.buildconfig.ActiveBuildConfig;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceCancelException;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.precompiled.PrecompiledAutoDebugUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBManager;
import ro.amiq.dvt.precompiled.PrecompiledDBSaveConfig;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.precompiled.PrecompiledDbStats;
import ro.amiq.dvt.precompiled.PrecompiledLoadedDB;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.builders.VlogBuilderUtils;
import ro.amiq.vlogdt.model.persistence.Persistence;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElementVisitor2Adapter;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroZone;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.parser.VlogSVlog;
import ro.amiq.vlogdt.test.TestHelper;
import ro.amiq.vlogdt.utils.SourceFileToBuildFileMapping;

public class VlogPrecompiledDBUtils {
    private static Thread updateDatabaseExcludedByPathThread;

    public static void savePrecompiledLibrary(String libName, RfProject rfProject, Persistence persistence, ActiveBuildConfig activeBuildConfig, CopyType copyType, int nrOfInvocations, boolean clearDirContent, boolean includeMacros, PrecompiledDbStats stats) {
        try {
            IProject project = rfProject.getProject();
            BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode = BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbSave((String)(copyType == CopyType.FILTER_NEG ? null : libName));
            if (clearDirContent) {
                String libraryLocation = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)"", (boolean)false, (BuildConfigManagerCommon.PersistenceModeWrapper)persistenceMode);
                PrecompiledDBUtils.clearPrecompiledDBDirectory((String)libraryLocation);
            }
            PrecompiledAutoDebugUtils.INSTANCE.beginLibrary(libName);
            RfProject newRfProject = new RfProject(project, rfProject.getMixedLangProjectParent());
            newRfProject.setBuildProgressMonitor(rfProject.getBuildProgressMonitor());
            newRfProject.setRfProjectContent(new RfProject.RfProjectContent());
            long startCopyReflection = System.currentTimeMillis();
            VlogPrecompiledDBUtils.copyRfProject(project, newRfProject, rfProject, libName, copyType);
            stats.copyReflectionTime = (int)(System.currentTimeMillis() - startCopyReflection);
            long startSave = System.currentTimeMillis();
            persistence.save(newRfProject, false, false, false, persistenceMode);
            stats.persistenceTime = System.currentTimeMillis() - startSave;
            VlogPrecompiledDBUtils.writeSaveConfigYml(libName, newRfProject, activeBuildConfig, copyType, nrOfInvocations, includeMacros, project, persistenceMode, (int)stats.persistenceTime);
            PrecompiledAutoDebugUtils.INSTANCE.endLibrary(libName);
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void savePrecompiledAutoLibrary(String libName, RfProject rfProject, Persistence persistence, ActiveBuildConfig activeBuildConfig, PrecompiledDbStats stats) {
        VlogPrecompiledDBUtils.savePrecompiledLibrary(libName, rfProject, persistence, activeBuildConfig, CopyType.FILTER, 1, true, false, stats);
    }

    public static void savePrecompiledManualLibrary(RfProject rfProject, Persistence persistence, ActiveBuildConfig activeBuildConfig, PrecompiledDbStats stats) throws IOException {
        IProject project = rfProject.getProject();
        if (rfProject.getLibraries().stream().map(RfNamedElement::getName).anyMatch(libName -> libName != null && libName.equals("dvt_uvm_library"))) {
            VlogPrecompiledDBUtils.savePrecompiledLibrary("dvt_uvm_library", rfProject, persistence, activeBuildConfig, CopyType.FILTER, 1, true, false, stats);
            persistence.setDirty();
            VlogPrecompiledDBUtils.savePrecompiledLibrary("dvt_uvm_library", rfProject, persistence, activeBuildConfig, CopyType.FILTER_NEG, activeBuildConfig.getCachedInfo().size() - 1, false, false, stats);
            return;
        }
        PrecompiledDBUtils.clearMD5CheckFile((IProject)project, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualSave());
        rfProject.getPreprocessingTable().getTopFileInstance().clearAllMacroZoneIndices();
        long startSave = System.currentTimeMillis();
        persistence.save(rfProject, false, false, true, BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualSave());
        int saveDuration = (int)(System.currentTimeMillis() - startSave);
        List dhTopsList = BuildConfigManager.getTopConfigurationProperties((IProject)project).stream().map(property -> property.getValue()).collect(Collectors.toList());
        boolean syntacticErrors = VlogPrecompiledDBUtils.didLibraryHaveSyntacticErrors(rfProject, "dvt_all_libraries_placeholder");
        boolean semanticErrors = VlogPrecompiledDBUtils.didLibraryHaveSemanticErrors("dvt_all_libraries_placeholder");
        PrecompiledDBManager.getInstance().writePrecompiledDBSaveConfig(project, new PrecompiledDBSaveConfig(activeBuildConfig.getUVMReuse(), dhTopsList, activeBuildConfig.getCachedInfo().size(), syntacticErrors, semanticErrors, null, null, saveDuration), BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualSave());
    }

    public static void savePrecompiledAutoLibraryExcludedByPath(String libName, RfProject rfProject) {
        IProject project = rfProject.getProject();
        BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode = BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbSave((String)libName);
        long start = System.currentTimeMillis();
        PrecompiledDBSaveConfig newSaveConfig = new PrecompiledDBSaveConfig(true);
        PrecompiledDBManager.getInstance().writePrecompiledDBSaveConfig(project, newSaveConfig, persistenceMode);
        Persistence persistence = RfManager.getInstance().getPersistence(project);
        try {
            RfCompiledFiles compiledFiles = new RfCompiledFiles();
            compiledFiles.fCompiledFiles = new HashSet(((RfProject.RfProjectContent)rfProject.getRfProjectContent()).getParserPath2FileDefMap().entrySet().stream().filter(e -> {
                if (Thread.currentThread().isInterrupted()) {
                    throw new CancellationException("The task was cancelled because a new one was started");
                }
                RfFileDef fileDef = (RfFileDef)e.getValue();
                List<RfNamedElement> namedElements = fileDef.getNamedElements();
                if (namedElements != null && !namedElements.isEmpty()) {
                    for (RfNamedElement namedElement : namedElements) {
                        if (namedElement == null || namedElement.getEnclosingLibrary() == null || !libName.equals(namedElement.getEnclosingLibrary().getName())) continue;
                        return true;
                    }
                }
                return false;
            }).map(a -> (ParserPath)a.getKey()).collect(Collectors.toSet()));
            if (Thread.currentThread().isInterrupted()) {
                throw new CancellationException("The task was cancelled because a new one was started");
            }
            persistence.writeCompiledFiles(compiledFiles, persistenceMode);
            if (BuildConfigManager.isPrecompiledDbDebugMode((IProject)project).booleanValue()) {
                DVTLogger.INSTANCE.logInfo("Write compiled files for " + libName + " took " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        catch (CancellationException | BuildCancelException e2) {
            throw e2;
        }
        catch (Exception e3) {
            DVTLogger.INSTANCE.logError((Throwable)e3);
        }
    }

    public static void startLoadingPrecompiledDatabases(RfProject rfProject, List<Invocation> precompiledInvocations, BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode, Map<Invocation, Future<PrecompiledLoadedDB>> loadedInvocations) {
        if (precompiledInvocations.isEmpty()) {
            return;
        }
        Persistence persistence = RfManager.getInstance().getPersistence(rfProject.getProject());
        persistence.setGlobalRestoreMonitor(rfProject.getBuildProgressMonitor());
        VlogPrecompiledDBUtils.loadPrecompiledLibraries(rfProject, precompiledInvocations, precompiledDbMode, loadedInvocations);
    }

    public static int mergeManualPrecompiledLibraries(RfProject rfProject, List<Invocation> precompiledInvocations, Map<Invocation, Future<PrecompiledLoadedDB>> loadedInvocations, VlogSVlog vlogParser, int currentFileIndex, Map<ParserPath, IBuildConfigParserConstants.LanguageSyntax> resources2CreateMap) {
        if (precompiledInvocations.isEmpty()) {
            return 0;
        }
        int filesFromManualPCDBs = 0;
        for (Invocation invocation : precompiledInvocations) {
            if (!BuildConfigManager.isPrecompiledDbLoadInvocation((Invocation)invocation)) continue;
            filesFromManualPCDBs += VlogPrecompiledDBUtils.mergePrecompiledLibrary(invocation, rfProject, loadedInvocations, vlogParser, currentFileIndex + filesFromManualPCDBs, resources2CreateMap, false);
        }
        return filesFromManualPCDBs;
    }

    public static List<Invocation> getPrecompiledInvocations(IProject project) {
        List invocations = BuildConfigManager.getInvocations((IProject)project);
        ArrayList<Invocation> precompiledInvocations = new ArrayList<Invocation>();
        int i = 0;
        while (i < invocations.size()) {
            Invocation invocation = (Invocation)invocations.get(i);
            boolean isManualPCDB = BuildConfigManager.isPrecompiledDbLoadInvocation((Invocation)invocation);
            if (isManualPCDB || PrecompiledDBManager.getInstance().getLibrariesToBeLoaded().containsKey(invocation.getState().invocationNumber)) {
                precompiledInvocations.add(invocation);
            }
            ++i;
        }
        return precompiledInvocations;
    }

    private static void loadPrecompiledLibraries(RfProject rfProject, List<Invocation> precompiledInvocations, BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode, Map<Invocation, Future<PrecompiledLoadedDB>> loadedInvocations) {
        TestHelper.fPrecompiledLoadStats = new PrecompiledDbStats();
        TestHelper.fPrecompiledLoadStats.loadStartTime = System.currentTimeMillis();
        HashMap<Invocation, Integer> libraryTimes = new HashMap<Invocation, Integer>();
        HashSet<String> xilinxAlteraLibrariesAlreadyLoaded = new HashSet<String>();
        Iterator<Invocation> invocationIterator = precompiledInvocations.iterator();
        while (invocationIterator.hasNext()) {
            Invocation invocation = invocationIterator.next();
            if (precompiledDbMode == BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_LOAD && xilinxAlteraLibrariesAlreadyLoaded.contains(invocation.getPrecompiledLibName())) {
                invocationIterator.remove();
                continue;
            }
            String libraryPath = null;
            boolean isManualPCDB = BuildConfigManager.isPrecompiledDbLoadInvocation((Invocation)invocation);
            libraryPath = isManualPCDB ? BuildConfigManager.getModelPersistenceLocation((IProject)rfProject.getProject(), (String)"", (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualLoad((Invocation)invocation)) : (String)PrecompiledDBManager.getInstance().getLibrariesToBeLoaded().get(invocation.getState().invocationNumber);
            int time = PrecompiledDBManager.getInstance().getPrecompiledDBSaveConfig(libraryPath).getSaveTime();
            libraryTimes.put(invocation, time);
            if (precompiledDbMode == BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_LOAD) {
                xilinxAlteraLibrariesAlreadyLoaded.add(invocation.getPrecompiledLibName());
            }
            loadedInvocations.put(invocation, new CompletableFuture());
        }
        List librariesByInvocationOrder = precompiledInvocations.stream().sorted((a, b) -> a.getState().invocationNumber - b.getState().invocationNumber).collect(Collectors.toList());
        List librariesBySaveDurationDesc = libraryTimes.entrySet().stream().sorted((a, b) -> (Integer)b.getValue() - (Integer)a.getValue()).map(a -> (Invocation)a.getKey()).collect(Collectors.toList());
        int maxJobs = BuildConfigManager.getPrecompiledDbMaxNofThreads((IProject)rfProject.getProject());
        int nOfSlowThreads = Math.max(1, (int)Math.ceil((double)maxJobs * 0.2));
        int nOfFastThreads = Math.max(1, maxJobs - nOfSlowThreads);
        ExecutorService invocationOrderExecutor = PrecompiledDBUtils.initExecutorService((Integer)nOfFastThreads);
        int i = 0;
        while (i < librariesByInvocationOrder.size()) {
            invocationOrderExecutor.execute(VlogPrecompiledDBUtils.getLoadPrecompiledLibrariesWorker((Invocation)librariesByInvocationOrder.get(i), rfProject, loadedInvocations));
            ++i;
        }
        ExecutorService saveDurationDescExecutor = PrecompiledDBUtils.initExecutorService((Integer)nOfSlowThreads);
        int i2 = 0;
        while (i2 < librariesBySaveDurationDesc.size()) {
            saveDurationDescExecutor.execute(VlogPrecompiledDBUtils.getLoadPrecompiledLibrariesWorker((Invocation)librariesBySaveDurationDesc.get(i2), rfProject, loadedInvocations));
            ++i2;
        }
        saveDurationDescExecutor.shutdown();
        invocationOrderExecutor.shutdown();
    }

    private static Runnable getLoadPrecompiledLibrariesWorker(Invocation invocation, RfProject rfProject, Map<Invocation, Future<PrecompiledLoadedDB>> loadedInvocations) {
        SubProgressMonitor childMonitor = new SubProgressMonitor((IProgressMonitor)(rfProject.getBuildProgressMonitor() != null ? rfProject.getBuildProgressMonitor() : new NullProgressMonitor()), 1);
        return () -> {
            if (childMonitor.isCanceled()) {
                return;
            }
            Class<VlogPrecompiledDBUtils> clazz = VlogPrecompiledDBUtils.class;
            synchronized (VlogPrecompiledDBUtils.class) {
                if (PrecompiledDBManager.getInstance().getLibraryStartedLoading(invocation.getState().invocationNumber)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                PrecompiledDBManager.getInstance().setLibraryStartedLoading(invocation.getState().invocationNumber);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                VlogPrecompiledDBUtils.loadPrecompiledLibrary(rfProject, invocation, loadedInvocations, (IProgressMonitor)childMonitor);
                TestHelper.fPrecompiledLoadStats.loadEndTime.set(System.currentTimeMillis());
                return;
            }
        };
    }

    private static void loadPrecompiledLibrary(RfProject rfProject, Invocation invocation, Map<Invocation, Future<PrecompiledLoadedDB>> loadedInvocations, IProgressMonitor monitor) {
        VlogPrecompiledDBUtils.loadPrecompiledLibrary(rfProject, invocation, loadedInvocations, monitor, null);
    }

    private static void loadPrecompiledLibrary(RfProject rfProject, Invocation invocation, Map<Invocation, Future<PrecompiledLoadedDB>> loadedInvocations, IProgressMonitor monitor, String librarySubfolder) {
        Invocation invocationToBeLoaded = invocation;
        if (librarySubfolder != null) {
            invocationToBeLoaded = BuildConfigManager.getInvocations((IProject)rfProject.getProject()).stream().filter(inv -> inv.getState().invocationNumber == invocation.getState().invocationNumber + 1).findFirst().orElse(null);
            loadedInvocations.put(invocationToBeLoaded, new CompletableFuture());
        }
        CompletableFuture libraryFuture = (CompletableFuture)loadedInvocations.get(invocationToBeLoaded);
        try {
            PrecompiledDbStats stats = new PrecompiledDbStats();
            RfProject loadedRfProject = new RfProject(rfProject.getProject(), rfProject.getMixedLangProjectParent());
            loadedRfProject.setBuildProgressMonitor(monitor);
            loadedRfProject.precompiledDbLoad(invocation, stats, librarySubfolder);
            String message = DVTStringUtil.appendString((Object[])new Object[]{"Done loading ", stats.dbLocation, " [", stats.persistenceTime, " ms load time] "});
            DVTBuildConsoleRegistry.getConsole((IProject)rfProject.getProject()).print(message, DVTBuildConsoleCommon.MessageSink.CONSOLE);
            libraryFuture.complete(new PrecompiledLoadedDB((IRfSingleLangProject)loadedRfProject, stats));
        }
        catch (BuildCancelException | PersistenceCancelException throwable) {
            libraryFuture.cancel(true);
        }
    }

    public static int mergePrecompiledLibrary(Invocation invocation, RfProject rfProject, Map<Invocation, Future<PrecompiledLoadedDB>> loadedInvocations, VlogSVlog vlogParser, int currentFileIndex, Map<ParserPath, IBuildConfigParserConstants.LanguageSyntax> resources2CreateMap, boolean isAuto) throws PersistenceBase.PrecompiledDbLoadFailException {
        return VlogPrecompiledDBUtils.mergePrecompiledLibrary(invocation, rfProject, loadedInvocations, vlogParser, currentFileIndex, resources2CreateMap, isAuto, null);
    }

    private static int mergePrecompiledLibrary(Invocation invocation, RfProject rfProject, Map<Invocation, Future<PrecompiledLoadedDB>> loadedInvocations, VlogSVlog vlogParser, int currentFileIndex, Map<ParserPath, IBuildConfigParserConstants.LanguageSyntax> resources2CreateMap, boolean isAuto, String librarySubfolder) throws PersistenceBase.PrecompiledDbLoadFailException {
        try {
            BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode = BuildConfigManager.getPrecompiledDbMode((IProject)rfProject.getProject());
            String precompiledDbLocation = BuildConfigManager.getModelPersistenceLocation((IProject)rfProject.getProject(), (String)"", (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbLoad((Invocation)invocation, (String)(isAuto ? invocation.getPrecompiledLibName() : null)));
            int uvmLibFileInstances = 0;
            boolean isUvmLibPresent = false;
            if (librarySubfolder == null && precompiledDbMode != BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD) {
                isUvmLibPresent = PrecompiledDBUtils.precompiledLibraryContainsUvmLibrary((String)precompiledDbLocation, (String)"dvt_uvm_library");
                if (!PrecompiledDBManager.getInstance().isUvmLoaded() && isUvmLibPresent) {
                    VlogPrecompiledDBUtils.loadPrecompiledLibrary(rfProject, invocation, loadedInvocations, rfProject.getBuildProgressMonitor(), "dvt_uvm_library");
                    uvmLibFileInstances = VlogPrecompiledDBUtils.mergePrecompiledLibrary(invocation, rfProject, loadedInvocations, vlogParser, currentFileIndex, resources2CreateMap, isAuto, "dvt_uvm_library");
                    currentFileIndex += uvmLibFileInstances;
                    PrecompiledDBManager.getInstance().setUvmLoaded();
                }
            }
            if (!isAuto) {
                ++currentFileIndex;
            }
            if (uvmLibFileInstances > 0 && PrecompiledDBUtils.countFilesInDir((String)precompiledDbLocation) <= 1L) {
                return uvmLibFileInstances;
            }
            if (librarySubfolder != null) {
                precompiledDbLocation = Paths.get(precompiledDbLocation, librarySubfolder).toString();
            }
            Invocation invocationToBeMerged = invocation;
            if (librarySubfolder != null) {
                invocationToBeMerged = loadedInvocations.keySet().stream().filter(inv -> inv.getState().invocationNumber == invocation.getState().invocationNumber + 1).findFirst().orElse(null);
            }
            if (invocationToBeMerged == null || loadedInvocations.get(invocationToBeMerged) == null) {
                throw new PersistenceBase.PrecompiledDbLoadFailException("Could not load precompiled library for invocation " + invocation.getState().invocationNumber);
            }
            CompletableFuture future = (CompletableFuture)loadedInvocations.get(invocationToBeMerged);
            long startWait = System.currentTimeMillis();
            PrecompiledLoadedDB loadedLibrary = (PrecompiledLoadedDB)future.get();
            long waitTime = System.currentTimeMillis() - startWait;
            if (loadedLibrary == null || loadedLibrary.getLibraryContent() == null) {
                throw new PersistenceBase.PrecompiledDbLoadFailException("Could not load precompiled library for invocation " + invocation.getState().invocationNumber);
            }
            long time = System.currentTimeMillis();
            RfProject loadedRfProject = (RfProject)loadedLibrary.getLibraryContent();
            PrecompiledDbStats stats = loadedLibrary.getStats();
            VlogPreprocessingInfo preprocessingTable = loadedRfProject.getPreprocessingTable();
            VlogFileInstance topInstance = preprocessingTable.getTopFileInstance();
            int libFilesNumber = 0;
            List<VlogFileInstance> allInstances = VlogBuilderUtils.getRecursiveFileInstances(topInstance.getIncludedInstances());
            if (allInstances != null) {
                for (VlogFileInstance fileInstance : allInstances) {
                    PrecompiledDBUtils.addToPrecompiledFilesCache((IProject)loadedRfProject.getProject(), (String)fileInstance.getParserPath().path, (boolean)isAuto);
                }
                allInstances.add(0, topInstance);
                libFilesNumber = VlogPrecompiledDBUtils.precompiledLoadCleanup(loadedRfProject.getProject(), allInstances, currentFileIndex, resources2CreateMap, invocation.getState().invocationNumber, isAuto, (RfProject.RfProjectContent)loadedRfProject.getRfProjectContent(), uvmLibFileInstances > 0, isUvmLibPresent);
                if (!isAuto && !BuildConfigManager.isPrecompiledDbMD5ChecksumDisabled((IProject)loadedRfProject.getProject(), (Invocation)invocation)) {
                    Set parserPaths = allInstances.stream().map(instance -> instance.getParserPath()).collect(Collectors.toSet());
                    PrecompiledDBUtils.checkPrecompiledFilesMD5(parserPaths, (String)precompiledDbLocation, (int)invocation.getState().invocationNumber, (boolean)true);
                }
            }
            loadedRfProject.getRfProjectContent().setEnclosingScope((IRfSingleLangProject)rfProject);
            VlogPrecompiledDBUtils.copyRfProject(rfProject.getProject(), rfProject, loadedRfProject);
            stats.copyReflectionTime = System.currentTimeMillis() - time;
            String message = DVTStringUtil.appendString((Object[])new Object[]{"Done ", stats.dbLocation, " [", stats.copyReflectionTime, " ms merge time, " + waitTime + " ms wait time] ..."});
            DVTBuildConsoleRegistry.getConsole((IProject)rfProject.getProject()).print(message, DVTBuildConsoleCommon.MessageSink.CONSOLE);
            if (TestHelper.fPrecompiledLoadStats == null) {
                TestHelper.fPrecompiledLoadStats = new PrecompiledDbStats();
            }
            TestHelper.fPrecompiledLoadStats.persistenceTime += stats.persistenceTime;
            TestHelper.fPrecompiledLoadStats.copyReflectionTime += stats.copyReflectionTime;
            int numOfFileInstances = VlogBuilderUtils.nofFileInstances(topInstance) - libFilesNumber;
            vlogParser.setIndex(numOfFileInstances);
            return numOfFileInstances += uvmLibFileInstances;
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return 0;
        }
    }

    private static void copyRfProject(IProject project, RfProject destRfProject, RfProject loadedRfProject) throws Exception {
        VlogPrecompiledDBUtils.copyRfProject(project, destRfProject, loadedRfProject, null, CopyType.EVERYTHING);
    }

    private static void copyRfProject(IProject project, RfProject destRfProject, RfProject sourceRfProject, String libraryToBeCopied, CopyType copyType) throws Exception {
        boolean precompileSave = copyType == CopyType.FILTER || copyType == CopyType.FILTER_NEG;
        VlogPrecompiledDBUtils.initializeDestProject(destRfProject);
        RfProject.RfProjectContent destProjectContent = (RfProject.RfProjectContent)destRfProject.getRfProjectContent();
        RfProject.RfProjectContent sourceProjectContent = (RfProject.RfProjectContent)sourceRfProject.getRfProjectContent();
        PrecompiledLibraryFilteringInformation libraryInformation = new PrecompiledLibraryFilteringInformation();
        PrecompiledProjectContentWrapper destWrapper = VlogPrecompiledDBUtils.prepareProjectWrapper(precompileSave, project, destProjectContent, sourceProjectContent, libraryToBeCopied, libraryInformation, copyType);
        VlogPrecompiledDBUtils.copyRfProjectContent(precompileSave, libraryToBeCopied, sourceProjectContent, destRfProject, libraryInformation, destWrapper, copyType);
        if (destProjectContent.getParserPath2FileDefMap() != null) {
            for (RfFileDef fileDef : destProjectContent.getParserPath2FileDefMap().values()) {
                fileDef.setRfProject(destRfProject);
            }
        }
        if (destProjectContent.getPreprocessingTable() != null) {
            VlogPrecompiledDBUtils.copyPreprocessingTable(precompileSave, sourceRfProject, destRfProject, libraryInformation);
        }
    }

    private static void initializeDestProject(RfProject destRfProject) {
        RfProject.RfProjectContent destProjectContent = (RfProject.RfProjectContent)destRfProject.getRfProjectContent();
        if (destProjectContent.getFileToLibraryWildcardMapping() == null) {
            destProjectContent.setFileToLibraryWildcardMapping(new LinkedHashMap<String, String>());
        }
        if (destProjectContent.getFileToLibraryExplicitMapping() == null) {
            destProjectContent.setFileToLibraryExplicitMapping(new LinkedHashMap<String, String>());
        }
        if (destProjectContent.getLibraries() == null) {
            destProjectContent.setLibraries((DVTLinkedHashMap<String, RfLibrary>)new DVTLinkedHashMap());
        }
        if (destProjectContent.getParserPath2FileDefMap() == null) {
            destProjectContent.setParserPath2FileDefMap(new HashMap<ParserPath, RfFileDef>());
        }
        if (destProjectContent.getPreprocessingTable() == null) {
            destProjectContent.setPreprocessingTable(new VlogPreprocessingInfo(destRfProject));
        }
        if (destProjectContent.getSourceFileToBuildFileMapping() == null) {
            destProjectContent.setSourceFileToBuildFileMapping(new SourceFileToBuildFileMapping());
        }
        if (destProjectContent.fInvocationIndicesByPath == null) {
            destProjectContent.fInvocationIndicesByPath = new HashMap<ParserPath, Set<Integer>>();
        }
        if (destProjectContent.fAutoConfiguredParserPaths == null) {
            destProjectContent.fAutoConfiguredParserPaths = new HashSet<ParserPath>();
        }
        if (destProjectContent.fWildcardConfiguredParserPaths == null) {
            destProjectContent.fWildcardConfiguredParserPaths = new HashSet<ParserPath>();
        }
    }

    private static PrecompiledProjectContentWrapper prepareProjectWrapper(boolean precompileSave, IProject project, RfProject.RfProjectContent destProjectContent, RfProject.RfProjectContent sourceProjectContent, String libraryToBeCopied, PrecompiledLibraryFilteringInformation libraryInformation, CopyType copyType) throws Exception {
        PrecompiledProjectContentWrapper destWrapper = new PrecompiledProjectContentWrapper(new HashMap<ParserPath, RfFileDef>(sourceProjectContent.getParserPath2FileDefMap()), sourceProjectContent.getFileToLibraryWildcardMapping(), sourceProjectContent.getFileToLibraryExplicitMapping(), sourceProjectContent.fAutoConfiguredParserPaths, sourceProjectContent.fWildcardConfiguredParserPaths, new SourceFileToBuildFileMapping());
        if (precompileSave) {
            VlogPrecompiledDBUtils.computeLibraryFilteringInformation(libraryInformation, libraryToBeCopied, project, sourceProjectContent, copyType);
            VlogPrecompiledDBUtils.filterProjectContentByLibrary(libraryToBeCopied, sourceProjectContent, libraryInformation, destWrapper, copyType);
            destProjectContent.getParserPath2FileDefMap().putAll(destWrapper.fParserPath2FileDefMap);
        } else {
            destWrapper.fSourceFileToBuildFileMapping.addAllIncludedTopFiles(sourceProjectContent.getSourceFileToBuildFileMapping().getIncludedTopFilesMap());
            destWrapper.fSourceFileToBuildFileMapping.addAllIncludedLibraries(sourceProjectContent.getSourceFileToBuildFileMapping().getIncludedLibrariesMap());
            VlogPrecompiledDBUtils.sanitizeFileToLibraryMapping(destWrapper.fFileToLibraryExplicitMapping);
            VlogPrecompiledDBUtils.sanitizeFileToLibraryMapping(destWrapper.fFileToLibraryWildcardMapping);
            VlogPrecompiledDBUtils.copyFileDefs(destWrapper, destProjectContent);
        }
        return destWrapper;
    }

    private static void computeLibraryFilteringInformation(PrecompiledLibraryFilteringInformation libraryInformation, String libraryToBeCopied, IProject project, RfProject.RfProjectContent sourceProjectContent, CopyType copyType) {
        libraryInformation.libraryInvocations.addAll(BuildConfigManager.getInvocations((IProject)project).stream().filter(inv -> copyType == CopyType.FILTER_NEG ? !inv.getPrecompiledLibName().equals(libraryToBeCopied) : inv.getPrecompiledLibName().equals(libraryToBeCopied)).map(inv -> inv.getState().invocationNumber).collect(Collectors.toSet()));
        libraryInformation.libraryParserPaths.addAll(sourceProjectContent.fInvocationIndicesByPath.entrySet().stream().filter(pathsInvocationIndices -> ((Set)pathsInvocationIndices.getValue()).stream().anyMatch(in -> precompiledLibraryFilteringInformation.libraryInvocations.contains(in))).map(p -> ((ParserPath)p.getKey()).toString()).collect(Collectors.toSet()));
    }

    private static void filterProjectContentByLibrary(String libraryToBeCopied, RfProject.RfProjectContent sourceProjectContent, PrecompiledLibraryFilteringInformation libraryInformation, PrecompiledProjectContentWrapper wrapper, CopyType copyType) {
        wrapper.fParserPath2FileDefMap = sourceProjectContent.getParserPath2FileDefMap().entrySet().stream().filter(e -> {
            RfFileDef fileDef = (RfFileDef)e.getValue();
            List<RfNamedElement> namedElements = fileDef.getNamedElements();
            if (namedElements != null && !namedElements.isEmpty()) {
                for (RfNamedElement namedElement : namedElements) {
                    if (namedElement == null || namedElement.getEnclosingLibrary() == null || (copyType != CopyType.FILTER || !libraryToBeCopied.equals(namedElement.getEnclosingLibrary().getName())) && (copyType != CopyType.FILTER_NEG || libraryToBeCopied.equals(namedElement.getEnclosingLibrary().getName()))) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        wrapper.fFileToLibraryWildcardMapping = sourceProjectContent.getFileToLibraryWildcardMapping().entrySet().stream().filter(e -> precompiledLibraryFilteringInformation.libraryParserPaths.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        wrapper.fFileToLibraryExplicitMapping = sourceProjectContent.getFileToLibraryExplicitMapping().entrySet().stream().filter(e -> precompiledLibraryFilteringInformation.libraryParserPaths.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        wrapper.fAutoConfiguredParserPaths = sourceProjectContent.fAutoConfiguredParserPaths.stream().filter(e -> precompiledLibraryFilteringInformation.libraryParserPaths.contains(e.toString())).collect(Collectors.toSet());
        wrapper.fWildcardConfiguredParserPaths = sourceProjectContent.fWildcardConfiguredParserPaths.stream().filter(e -> precompiledLibraryFilteringInformation.libraryParserPaths.contains(e.toString())).collect(Collectors.toSet());
        wrapper.fSourceFileToBuildFileMapping.addAllIncludedTopFiles(sourceProjectContent.getSourceFileToBuildFileMapping().getIncludedTopFilesMap().entrySet().stream().filter(p -> precompiledLibraryFilteringInformation.libraryInvocations.contains(p.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        wrapper.fSourceFileToBuildFileMapping.addAllIncludedLibraries(sourceProjectContent.getSourceFileToBuildFileMapping().getIncludedLibrariesMap().entrySet().stream().filter(p -> precompiledLibraryFilteringInformation.libraryInvocations.contains(p.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static void copyFileDefs(PrecompiledProjectContentWrapper wrapper, RfProject.RfProjectContent destProjectContent) throws Exception {
        for (Map.Entry<ParserPath, RfFileDef> entry : wrapper.fParserPath2FileDefMap.entrySet()) {
            ParserPath parserPath = entry.getKey();
            RfFileDef loadedFileDef = entry.getValue();
            if (!destProjectContent.getParserPath2FileDefMap().containsKey(parserPath)) {
                destProjectContent.getParserPath2FileDefMap().put(parserPath, loadedFileDef);
                continue;
            }
            RfFileDef toMergeFileDef = destProjectContent.getParserPath2FileDefMap().get(parserPath);
            VlogPrecompiledDBUtils.mergeFileDefNamedElements(toMergeFileDef, loadedFileDef);
        }
    }

    private static void mergeFileDefNamedElements(RfFileDef toMergeFileDef, RfFileDef loadedFileDef) throws Exception {
        final HashMap<RfDefElement, RfDefElement> loadedDefs = new HashMap<RfDefElement, RfDefElement>();
        VlogPrecompiledDBUtils.getDefRecursive(loadedDefs, loadedFileDef);
        toMergeFileDef.visit(new IRfDefElementVisitor(){

            @Override
            public boolean visit(RfDefElement defElement) throws Exception {
                return true;
            }

            @Override
            public void preVisit(RfDefElement defElement) throws Exception {
            }

            @Override
            public void postVisit(RfDefElement defElement) throws Exception {
                RfDefElement loadedDef = (RfDefElement)loadedDefs.get(defElement);
                if (loadedDef == null) {
                    return;
                }
                List<RfNamedElement> loadedNamedElements = loadedDef.getNamedElements();
                if (loadedNamedElements != null && !loadedNamedElements.isEmpty()) {
                    for (RfNamedElement loadedNamedElement : loadedNamedElements) {
                        defElement.addNamedElement(loadedNamedElement);
                    }
                }
                if (defElement instanceof RfFieldDef) {
                    ((RfFieldDef)defElement).putAllDataTypes(((RfFieldDef)loadedDef).getAllDataTypes());
                }
                if (defElement instanceof RfFunctionDef) {
                    ((RfFunctionDef)defElement).putAllTypeInfos(((RfFunctionDef)loadedDef).getAllTypeInfos());
                }
            }
        });
    }

    private static void getDefRecursive(Map<RfDefElement, RfDefElement> result, RfDefElement def) {
        if (result.containsKey(def)) {
            return;
        }
        result.put(def, def);
        Collection<RfDefElement> children = def.getChildren();
        if (children == null) {
            return;
        }
        for (RfDefElement child : children) {
            if (!(child instanceof RfDefElement)) continue;
            VlogPrecompiledDBUtils.getDefRecursive(result, child);
        }
    }

    private static void sanitizeFileToLibraryMapping(Map<String, String> fileToLibraryMapping) {
        for (Map.Entry<String, String> fileLibrary : fileToLibraryMapping.entrySet()) {
            String libraryName = fileLibrary.getValue();
            fileLibrary.setValue(PrecompiledDBUtils.getLibNameWithoutInvocationSuffix((String)libraryName));
        }
    }

    private static void copyRfProjectContent(boolean precompileSave, String libraryToBeCopied, RfProject.RfProjectContent sourceProjectContent, RfProject destProject, PrecompiledLibraryFilteringInformation libraryFilteringInformation, PrecompiledProjectContentWrapper wrapper, CopyType copyType) {
        RfProject.RfProjectContent destProjectContent = (RfProject.RfProjectContent)destProject.getRfProjectContent();
        for (RfLibrary rfLibrary : sourceProjectContent.getLibraries().values()) {
            if (precompileSave && (copyType == CopyType.FILTER && !rfLibrary.getName().equals(libraryToBeCopied) || copyType == CopyType.FILTER_NEG && rfLibrary.getName().equals(libraryToBeCopied))) continue;
            String libraryName = rfLibrary.getName();
            if (!precompileSave) {
                libraryName = PrecompiledDBUtils.getLibNameWithoutInvocationSuffix((String)libraryName);
            }
            RfLibrary oldLibrary = (RfLibrary)destProjectContent.getLibraries().get((Object)libraryName);
            rfLibrary.setName(libraryName, false);
            if (oldLibrary == null) {
                destProjectContent.getLibraries().put((Object)libraryName, (IDVTMapElement)rfLibrary);
            } else {
                oldLibrary.copyLibraryContent(rfLibrary);
            }
            rfLibrary.setEnclosingScope(destProject);
        }
        if (wrapper.fFileToLibraryWildcardMapping != null) {
            destProjectContent.getFileToLibraryWildcardMapping().putAll(wrapper.fFileToLibraryWildcardMapping);
        }
        if (wrapper.fFileToLibraryExplicitMapping != null) {
            destProjectContent.getFileToLibraryExplicitMapping().putAll(wrapper.fFileToLibraryExplicitMapping);
        }
        if (wrapper.fAutoConfiguredParserPaths != null) {
            destProjectContent.fAutoConfiguredParserPaths.addAll(wrapper.fAutoConfiguredParserPaths);
        }
        if (wrapper.fWildcardConfiguredParserPaths != null) {
            destProjectContent.fWildcardConfiguredParserPaths.addAll(wrapper.fWildcardConfiguredParserPaths);
        }
        destProjectContent.getSourceFileToBuildFileMapping().addAllIncludedTopFiles(wrapper.fSourceFileToBuildFileMapping.getIncludedTopFilesMap());
        destProjectContent.getSourceFileToBuildFileMapping().addAllIncludedLibraries(wrapper.fSourceFileToBuildFileMapping.getIncludedLibrariesMap());
        if (sourceProjectContent.fInvocationIndicesByPath != null) {
            for (Map.Entry entry : sourceProjectContent.fInvocationIndicesByPath.entrySet()) {
                if (precompileSave && !libraryFilteringInformation.libraryParserPaths.contains(((ParserPath)entry.getKey()).toString())) continue;
                Set<Integer> invocIn = destProjectContent.fInvocationIndicesByPath.get(entry.getKey());
                if (invocIn == null) {
                    invocIn = new HashSet<Integer>();
                }
                if (precompileSave) {
                    invocIn.addAll(((Set)entry.getValue()).stream().filter(idx -> precompiledLibraryFilteringInformation.libraryInvocations.contains(idx)).collect(Collectors.toSet()));
                } else {
                    invocIn.addAll((Collection)entry.getValue());
                }
                destProjectContent.fInvocationIndicesByPath.put((ParserPath)entry.getKey(), invocIn);
            }
        }
        if (sourceProjectContent.getModulesNamesByLibrary() != null) {
            for (Map.Entry entry : sourceProjectContent.getModulesNamesByLibrary().entrySet()) {
                String libName = (String)entry.getKey();
                if (precompileSave && (copyType == CopyType.FILTER && !libName.equals(libraryToBeCopied) || copyType == CopyType.FILTER_NEG && libName.equals(libraryToBeCopied))) continue;
                libName = PrecompiledDBUtils.getLibNameWithoutInvocationSuffix((String)libName);
                TreeMap<String, TreeSet<String>> destModulesByLibraryFilePath = destProjectContent.getModulesNamesByLibrary().get(libName);
                if (destModulesByLibraryFilePath == null) {
                    destModulesByLibraryFilePath = new TreeMap();
                }
                for (Map.Entry sourceLibraryModulesByLibraryPath : ((TreeMap)entry.getValue()).entrySet()) {
                    String sourceFilePath = (String)sourceLibraryModulesByLibraryPath.getKey();
                    TreeSet<String> destModuleSet = destModulesByLibraryFilePath.get(sourceFilePath);
                    if (destModuleSet == null) {
                        destModuleSet = new TreeSet();
                    }
                    destModuleSet.addAll((Collection)sourceLibraryModulesByLibraryPath.getValue());
                    destModulesByLibraryFilePath.put(sourceFilePath, destModuleSet);
                }
                destProjectContent.getModulesNamesByLibrary().put(libName, destModulesByLibraryFilePath);
            }
        }
    }

    private static void copyPreprocessingTable(boolean precompileSave, RfProject sourceProject, RfProject destRfProject, PrecompiledLibraryFilteringInformation libraryInformation) throws Exception {
        VlogFileInstance destTopInstance = destRfProject.getPreprocessingTable().getTopFileInstance();
        VlogFileInstance sourceTopInstance = sourceProject.getPreprocessingTable().getTopFileInstance();
        if (destTopInstance != null && sourceTopInstance != null) {
            Optional<String> srcLibNameOpt;
            destTopInstance.setFileName(sourceTopInstance.getParserPath());
            List<DVTPair<VlogMacroZone, VlogFileInstance>> sourceFirstLevel = sourceTopInstance.getIncludedInstancesWithMacroZones();
            RfLibrary destLib = null;
            if (!precompileSave && (srcLibNameOpt = sourceProject.getLibraries().stream().filter(lib -> !lib.getName().equals("<std>")).map(lib -> lib.getName()).findFirst()).isPresent()) {
                String srcLibName = PrecompiledDBUtils.getLibNameWithoutInvocationSuffix((String)srcLibNameOpt.get());
                destLib = destRfProject.getLibraries().stream().filter(lib -> lib.getName().equals(srcLibName)).findFirst().orElse(null);
            }
            for (DVTPair<VlogMacroZone, VlogFileInstance> pair : sourceFirstLevel) {
                VlogMacroZone macroZone = (VlogMacroZone)pair.getKey();
                VlogFileInstance file = (VlogFileInstance)pair.getValue();
                sourceProject.checkBuildCanceled(true);
                if (precompileSave && (!libraryInformation.libraryParserPaths.contains(file.getParserPath().toString()) || !libraryInformation.libraryInvocations.contains(file.getInvocNumber()))) continue;
                file.setIncludingInstance(destTopInstance);
                file.setRfProject(destRfProject);
                RfNamedElement semanticScope = file.getSemanticScope();
                if (semanticScope instanceof RfProject) {
                    file.setSemanticScope(destRfProject);
                } else if (!precompileSave && destLib != null && semanticScope != null && semanticScope instanceof RfLibrary) {
                    file.setSemanticScope(destLib);
                }
                Collection<VlogMacroInfo> macroInfos = macroZone.getMacroInfos();
                if (macroInfos != null) {
                    for (VlogMacroInfo macroInfo : macroInfos) {
                        for (VlogMacroInfo layer : macroInfo.getMacroZoneLayers()) {
                            if (layer.getFileInstance() == sourceTopInstance) {
                                layer.setFileInstance(destTopInstance);
                            }
                            if (!(layer.getEnclosingScope() instanceof RfProject)) continue;
                            layer.setEnclosingScope(destRfProject);
                        }
                    }
                }
                destTopInstance.addIncludedFile(file, macroZone.getMacroInfos());
            }
            if (precompileSave) {
                destTopInstance.clearAllMacroZoneIndices();
            }
        }
        destRfProject.getPreprocessingTable().getMacroRefsMapByFile().putAll(!precompileSave ? sourceProject.getPreprocessingTable().getMacroRefsMapByFile() : sourceProject.getPreprocessingTable().getMacroRefsMapByFile().entrySet().stream().filter(e -> precompiledLibraryFilteringInformation.libraryParserPaths.contains(((ParserPath)e.getKey()).toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        destRfProject.getPreprocessingTable().getCodePreprocFileInfos().putAll(!precompileSave ? sourceProject.getPreprocessingTable().getCodePreprocFileInfos() : sourceProject.getPreprocessingTable().getCodePreprocFileInfos().entrySet().stream().filter(e -> precompiledLibraryFilteringInformation.libraryParserPaths.contains(((ParserPath)e.getKey()).toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        destRfProject.getPreprocessingTable().getEncrypedPragmaFileInfos().putAll(!precompileSave ? sourceProject.getPreprocessingTable().getEncrypedPragmaFileInfos() : sourceProject.getPreprocessingTable().getEncrypedPragmaFileInfos().entrySet().stream().filter(e -> precompiledLibraryFilteringInformation.libraryParserPaths.contains(((ParserPath)e.getKey()).toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        destRfProject.getPreprocessingTable().getFileNotFoundMap().putAll(!precompileSave ? sourceProject.getPreprocessingTable().getFileNotFoundMap() : sourceProject.getPreprocessingTable().getFileNotFoundMap().entrySet().stream().filter(e -> precompiledLibraryFilteringInformation.libraryParserPaths.contains(((VlogFileInstance)e.getKey()).toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static int precompiledLoadCleanup(IProject project, List<VlogFileInstance> allLibraryInstances, int libraryStartIndex, Map<ParserPath, IBuildConfigParserConstants.LanguageSyntax> resources2CreateMap, final int precompiledLoadInvocationNumber, final boolean isAuto, RfProject.RfProjectContent rfProjectContent, final boolean uvmLibWasLoaded, final boolean isUvmLibPresent) {
        VlogPrecompiledDBUtils.updateSourceFileToBuildFileMapping(precompiledLoadInvocationNumber, project, isAuto, rfProjectContent, uvmLibWasLoaded, isUvmLibPresent);
        for (RfLibrary lib : rfProjectContent.getLibraries()) {
            lib.accept(null, new RfNamedElementVisitor2Adapter(){

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    namedElement.updateImportExportInvocationNumber(precompiledLoadInvocationNumber, isAuto, uvmLibWasLoaded, isUvmLibPresent);
                    return true;
                }

                @Override
                public boolean visitNonPersistent() {
                    return false;
                }
            });
        }
        allLibraryInstances.sort((i1, i2) -> i1.getIndex() - i2.getIndex());
        int index = 0;
        int libFilesNumber = 0;
        for (VlogFileInstance instance : allLibraryInstances) {
            if (!instance.isPrecompiledDbFile()) continue;
            instance.updateInvocNumber(precompiledLoadInvocationNumber, isAuto, uvmLibWasLoaded, isUvmLibPresent);
            if (instance.getParserPath().path.endsWith(".libfile")) {
                ++libFilesNumber;
                continue;
            }
            instance.setIndex(libraryStartIndex + index++);
            if (resources2CreateMap == null) continue;
            ParserPath parserPath = instance.getParserPath();
            resources2CreateMap.put(parserPath, instance.getLanguageSyntax());
        }
        return libFilesNumber;
    }

    private static void updateSourceFileToBuildFileMapping(int precompiledInvocationNumber, IProject project, boolean isAuto, RfProject.RfProjectContent rfProjectContent, boolean uvmLibWasLoaded, boolean isUvmLibPresent) {
        if (isAuto) {
            return;
        }
        SourceFileToBuildFileMapping sourceFileToBuildFileMapping = rfProjectContent.getSourceFileToBuildFileMapping();
        if (sourceFileToBuildFileMapping == null) {
            return;
        }
        Invocation precompiledInvocation = (Invocation)BuildConfigManager.getInvocations((IProject)project).get(precompiledInvocationNumber);
        BuildFilePathLine precompiledPathLine = new BuildFilePathLine(precompiledInvocation.getFilename(), precompiledInvocation.getLine());
        HashMap<Integer, Map<Integer, BuildFilePathLine>> newIncludedTopFilesMap = new HashMap<Integer, Map<Integer, BuildFilePathLine>>();
        VlogPrecompiledDBUtils.updateSourceFileToBuildFileMapping(newIncludedTopFilesMap, sourceFileToBuildFileMapping.getIncludedTopFilesMap(), precompiledPathLine, precompiledInvocationNumber, project, uvmLibWasLoaded, isUvmLibPresent);
        HashMap<Integer, Map<String, BuildFilePathLine>> invocIncludedLibraries = new HashMap<Integer, Map<String, BuildFilePathLine>>();
        VlogPrecompiledDBUtils.updateSourceFileToBuildFileMapping(invocIncludedLibraries, sourceFileToBuildFileMapping.getIncludedLibrariesMap(), precompiledPathLine, precompiledInvocationNumber, project, uvmLibWasLoaded, isUvmLibPresent);
        sourceFileToBuildFileMapping = new SourceFileToBuildFileMapping();
        sourceFileToBuildFileMapping.addAllIncludedTopFiles(newIncludedTopFilesMap);
        sourceFileToBuildFileMapping.addAllIncludedLibraries(invocIncludedLibraries);
        rfProjectContent.setSourceFileToBuildFileMapping(sourceFileToBuildFileMapping);
    }

    private static <K> void updateSourceFileToBuildFileMapping(Map<Integer, Map<K, BuildFilePathLine>> result, Map<Integer, Map<K, BuildFilePathLine>> topByInvocationMap, BuildFilePathLine precompiledPathLine, int precompiledInvocationNumber, IProject project, boolean uvmLibWasLoaded, boolean isUvmLibPresent) {
        if (topByInvocationMap == null || topByInvocationMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, Map<K, BuildFilePathLine>> topFilesByInvocation : topByInvocationMap.entrySet()) {
            HashMap<K, BuildFilePathLine> invocIncludedTopFiles = new HashMap<K, BuildFilePathLine>();
            if (topFilesByInvocation.getValue() == null || topFilesByInvocation.getValue().isEmpty()) continue;
            for (Map.Entry<K, BuildFilePathLine> topInclusion : topFilesByInvocation.getValue().entrySet()) {
                invocIncludedTopFiles.put(topInclusion.getKey(), precompiledPathLine);
                PropertiesManager.addSessionProperty((IResource)project.getFile(Path.fromOSString((String)topInclusion.getValue().getPath())), (String)PropertyTypes.QN_IMPORTED_FILE, null);
            }
            int invNum = VlogPrecompiledDBUtils.getCleanupInvocationNumber(precompiledInvocationNumber, topFilesByInvocation.getKey(), false, uvmLibWasLoaded, isUvmLibPresent);
            result.put(invNum, invocIncludedTopFiles);
        }
    }

    public static int getCleanupInvocationNumber(int precompiledInvocationNumber, int oldInvocationNumber, boolean isAuto, boolean uvmLibWasLoaded, boolean isUvmLibPresent) {
        int invNum = 0;
        invNum = isAuto ? precompiledInvocationNumber : (uvmLibWasLoaded || !isUvmLibPresent ? oldInvocationNumber + 1 + precompiledInvocationNumber : oldInvocationNumber + precompiledInvocationNumber);
        return invNum;
    }

    private static boolean didLibraryHaveSyntacticErrors(RfProject rfProject, String libName) {
        return VlogPrecompiledDBUtils.didLibraryHaveSyntacticErrors(rfProject, libName, false);
    }

    private static boolean didLibraryHaveSyntacticErrors(RfProject rfProject, String libName, boolean negated) {
        Set filesWithSyntacticErrors = PrecompiledDBManager.getInstance().getFilesWithSyntacticErrors();
        if ("dvt_all_libraries_placeholder".equals(libName)) {
            return !filesWithSyntacticErrors.isEmpty();
        }
        List invocations = BuildConfigManager.getInvocations((IProject)rfProject.getProject());
        for (ParserPath filePath : filesWithSyntacticErrors) {
            Set fileInvocNumbers = (Set)rfProject.getRfProjectContent().getInvocationIndicesByPath().get(filePath);
            if (fileInvocNumbers == null) continue;
            Iterator iterator = fileInvocNumbers.iterator();
            while (iterator.hasNext()) {
                int invNum = (Integer)iterator.next();
                String invocationLibName = ((Invocation)invocations.get(invNum)).getPrecompiledLibName();
                if (invocationLibName == null || (negated || !invocationLibName.equals(libName)) && (!negated || invocationLibName.equals(libName))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean didLibraryHaveSemanticErrors(String libName) {
        return VlogPrecompiledDBUtils.didLibraryHaveSemanticErrors(libName, false);
    }

    private static boolean didLibraryHaveSemanticErrors(String libName, boolean negated) {
        Set libsWithSemanticErrors = PrecompiledDBManager.getInstance().getLibsWithSemanticErrors();
        if (libsWithSemanticErrors == null) {
            return false;
        }
        if ("dvt_all_libraries_placeholder".equals(libName)) {
            return !libsWithSemanticErrors.isEmpty();
        }
        return !negated && libsWithSemanticErrors.contains(libName) || negated && !libsWithSemanticErrors.contains(libName);
    }

    private static void writeSaveConfigYml(String libName, RfProject rfProject, ActiveBuildConfig activeBuildConfig, CopyType copyType, int nrOfInvocations, boolean includeMacros, IProject project, BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode, int saveDuration) {
        List dhTopsList = BuildConfigManager.getTopConfigurationPropertiesForLib((IProject)project, (String)libName, (copyType == CopyType.FILTER_NEG ? 1 : 0) != 0);
        boolean syntacticErrors = VlogPrecompiledDBUtils.didLibraryHaveSyntacticErrors(rfProject, libName, copyType == CopyType.FILTER_NEG);
        boolean semanticErrors = VlogPrecompiledDBUtils.didLibraryHaveSemanticErrors(libName, copyType == CopyType.FILTER_NEG);
        Map<String, String> macroMap = null;
        if (includeMacros) {
            macroMap = VlogPrecompiledDBUtils.getMacroMap(rfProject, libName);
        }
        Map homesMap = PrecompiledDBManager.getInstance().getLibraryHomesMap();
        PrecompiledDBSaveConfig newSaveConfig = new PrecompiledDBSaveConfig(activeBuildConfig.getUVMReuse(), dhTopsList, nrOfInvocations, syntacticErrors, semanticErrors, macroMap, homesMap, saveDuration);
        PrecompiledDBManager.getInstance().writePrecompiledDBSaveConfig(project, newSaveConfig, persistenceMode);
    }

    private static Map<String, String> getMacroMap(RfProject rfProject, String libName) {
        HashMap<String, String> controlMacros = new HashMap<String, String>();
        for (VlogMacroInfo macro : rfProject.getAllMacros()) {
            if (!macro.isDefinedConfigMacro() && !macro.isUndefConfigMacro()) continue;
            controlMacros.put(macro.getName(), macro.isDefinedConfigMacro() ? macro.getLabelProviderReplacement() : "DVT_UNDEFINED_MACRO");
        }
        List libraryInvocations = BuildConfigManager.getInvocations((IProject)rfProject.getProject()).stream().filter(i -> i.getPrecompiledLibName().equals(libName)).collect(Collectors.toList());
        if (libraryInvocations.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashSet invocationsDefines = new HashSet();
        for (Invocation invocation : libraryInvocations) {
            invocationsDefines.addAll(invocation.getProperties().stream().filter(p -> p.getKind() == 1).collect(Collectors.toSet()));
        }
        HashMap<String, String> libraryControlMacros = new HashMap<String, String>();
        for (String controlMacroName : controlMacros.keySet()) {
            Optional<BuildConfigProperty> macro = invocationsDefines.stream().filter(prop -> prop.getName().equals(controlMacroName)).findFirst();
            if (macro.isPresent()) {
                libraryControlMacros.put(macro.get().getName(), macro.get().getValue());
                continue;
            }
            libraryControlMacros.put(controlMacroName, "DVT_UNDEFINED_MACRO");
        }
        return libraryControlMacros;
    }

    private static Set<String> checkWhichLibrariesAreExcludedByPath(RfProject rfProject, Map<ParserPath, Set<Integer>> invocationIndicesByPath) {
        HashSet<String> excludedLibraries = new HashSet<String>();
        List excludedPathsStrings = BuildConfigManager.getPrecompiledDbAutoExcludedPaths((IProject)rfProject.getProject());
        if (excludedPathsStrings.isEmpty()) {
            return excludedLibraries;
        }
        List<StringMatcher> stringMatchers = VlogPrecompiledDBUtils.convertToStringMatcher(excludedPathsStrings);
        HashSet<Integer> excludedInvocations = new HashSet<Integer>();
        block0: for (Map.Entry<ParserPath, Set<Integer>> pathInvocations : invocationIndicesByPath.entrySet()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new CancellationException("The task was cancelled because a new one was started");
            }
            ParserPath parserPath = pathInvocations.getKey();
            Set<Integer> invocations = pathInvocations.getValue();
            for (StringMatcher matcher : stringMatchers) {
                if (!matcher.match(parserPath.path)) continue;
                excludedInvocations.addAll(invocations);
                continue block0;
            }
        }
        for (Invocation invocation : BuildConfigManager.getInvocations((IProject)rfProject.getProject())) {
            if (!BuildConfigParser.InvocationPrecompiledState.isAny((BuildConfigParser.InvocationPrecompiledState)invocation.getState().fPrecompiledState, (BuildConfigParser.InvocationPrecompiledState[])new BuildConfigParser.InvocationPrecompiledState[]{null, BuildConfigParser.InvocationPrecompiledState.AUTO_LOAD}) || !excludedInvocations.contains(invocation.getState().invocationNumber)) continue;
            excludedLibraries.add(invocation.getPrecompiledLibName());
        }
        return excludedLibraries;
    }

    public static Set<String> checkWhichLibrariesAreExcludedByPathFullBuild(RfProject rfProject) {
        return VlogPrecompiledDBUtils.checkWhichLibrariesAreExcludedByPath(rfProject, rfProject.getRfProjectContent().getInvocationIndicesByPath());
    }

    public static Set<String> checkWhichLibrariesAreExcludedByPathIncrementalBuild(RfProject rfProject) {
        HashMap<ParserPath, Set<Integer>> invocationIndicesByPath = new HashMap<ParserPath, Set<Integer>>();
        for (VlogFileInstance instance : VlogBuilderUtils.getRecursiveFileInstances(rfProject.getPreprocessingTable().getTopFileInstance().getIncludedInstances())) {
            HashSet<Integer> indices = (HashSet<Integer>)invocationIndicesByPath.get(instance.getParserPath());
            if (indices == null) {
                indices = new HashSet<Integer>();
                invocationIndicesByPath.put(instance.getParserPath(), indices);
            }
            indices.add(instance.getInvocNumber());
        }
        return VlogPrecompiledDBUtils.checkWhichLibrariesAreExcludedByPath(rfProject, invocationIndicesByPath);
    }

    private static List<StringMatcher> convertToStringMatcher(List<String> matcherStrings) {
        ArrayList<StringMatcher> result = new ArrayList<StringMatcher>();
        if (matcherStrings == null) {
            return null;
        }
        for (String path : matcherStrings) {
            String filterPath = DVTStringUtil.translatePathPatternToOSPattern((String)path);
            if (filterPath == null) continue;
            filterPath = BaseUtils.canonicPath((String)filterPath);
            result.add(new StringMatcher(filterPath, false, false, true));
        }
        return result;
    }

    private static Set<String> getLibraryNamesFromInvocationNumbers(IProject project, Set<Integer> invocationNumbers) {
        HashSet<String> libraryNames = new HashSet<String>();
        for (Invocation invocation : BuildConfigManager.getInvocations((IProject)project)) {
            if (!invocationNumbers.contains(invocation.getState().invocationNumber)) continue;
            libraryNames.add(invocation.getPrecompiledLibName());
        }
        return libraryNames;
    }

    private static Set<String> getLibrariesWithIncludesChanged(RfProject rfProject, Set<ParserPath> filesWithIncludesChangedInIncremental) {
        if (filesWithIncludesChangedInIncremental.isEmpty()) {
            return Set.of();
        }
        HashSet<Integer> changedInvocationNumbers = new HashSet<Integer>();
        for (ParserPath parserPath : filesWithIncludesChangedInIncremental) {
            changedInvocationNumbers.addAll((Collection)rfProject.getRfProjectContent().getInvocationIndicesByPath().get(parserPath));
        }
        return VlogPrecompiledDBUtils.getLibraryNamesFromInvocationNumbers(rfProject.getProject(), changedInvocationNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementalUpdateDatabasesExcludedByPath(RfProject rfProject, Set<ParserPath> changedFiles) {
        BuildConfigManagerCommon.PrecompileGlobalMode precompiledMode = BuildConfigManager.getPrecompiledDbMode((IProject)rfProject.getProject());
        if (precompiledMode != BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD) {
            return;
        }
        Class<VlogPrecompiledDBUtils> clazz = VlogPrecompiledDBUtils.class;
        synchronized (VlogPrecompiledDBUtils.class) {
            if (updateDatabaseExcludedByPathThread != null && updateDatabaseExcludedByPathThread.isAlive()) {
                updateDatabaseExcludedByPathThread.interrupt();
                try {
                    updateDatabaseExcludedByPathThread.join(200L);
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            updateDatabaseExcludedByPathThread = new Thread(() -> {
                HashSet<Integer> changedInvocationNumbers = new HashSet<Integer>();
                for (ParserPath parserPath : changedFiles) {
                    Set invocationIndicesOfPath = (Set)rfProject.getRfProjectContent().getInvocationIndicesByPath().get(parserPath);
                    if (invocationIndicesOfPath == null) continue;
                    changedInvocationNumbers.addAll(invocationIndicesOfPath);
                }
                Set<String> changedLibraries = VlogPrecompiledDBUtils.getLibraryNamesFromInvocationNumbers(rfProject.getProject(), changedInvocationNumbers);
                Set filesWithIncludesChangedInIncremental = PrecompiledDBManager.getInstance().getFilesWithIncludesChangedInIncremental();
                try {
                    try {
                        Set<String> librariesWithIncludesChanged = VlogPrecompiledDBUtils.getLibrariesWithIncludesChanged(rfProject, filesWithIncludesChangedInIncremental);
                        Set<String> excludedLibraries = VlogPrecompiledDBUtils.checkWhichLibrariesAreExcludedByPathIncrementalBuild(rfProject);
                        for (String library : changedLibraries) {
                            if (!excludedLibraries.contains(library) || librariesWithIncludesChanged.contains(library)) continue;
                            PrecompiledDBUtils.deletePrecompiledDatabaseDirectory((IProject)rfProject.getProject(), (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbSave((String)library));
                            VlogPrecompiledDBUtils.savePrecompiledAutoLibraryExcludedByPath(library, rfProject);
                        }
                        for (String library : librariesWithIncludesChanged) {
                            if (excludedLibraries.contains(library)) {
                                PrecompiledDBUtils.deletePrecompiledDatabaseDirectory((IProject)rfProject.getProject(), (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbSave((String)library));
                                VlogPrecompiledDBUtils.savePrecompiledAutoLibraryExcludedByPath(library, rfProject);
                                PrecompiledDBManager.getInstance().getLibrariesExcludedByPath().add(library);
                                continue;
                            }
                            if (!PrecompiledDBManager.getInstance().getLibrariesExcludedByPath().contains(library)) continue;
                            PrecompiledDBManager.getInstance().getLibrariesExcludedByPath().remove(library);
                            PrecompiledDBUtils.deletePrecompiledDatabaseDirectory((IProject)rfProject.getProject(), (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbSave((String)library));
                        }
                    }
                    catch (CancellationException | BuildCancelException throwable) {
                        filesWithIncludesChangedInIncremental.clear();
                    }
                }
                finally {
                    filesWithIncludesChangedInIncremental.clear();
                }
            });
            updateDatabaseExcludedByPathThread.start();
            return;
        }
    }

    public static enum CopyType {
        EVERYTHING,
        FILTER,
        FILTER_NEG;

    }

    private static class PrecompiledLibraryFilteringInformation {
        public Set<String> libraryParserPaths = new HashSet<String>();
        public Set<Integer> libraryInvocations = new HashSet<Integer>();

        private PrecompiledLibraryFilteringInformation() {
        }
    }

    private static class PrecompiledProjectContentWrapper {
        public Map<ParserPath, RfFileDef> fParserPath2FileDefMap;
        public Map<String, String> fFileToLibraryWildcardMapping;
        public Map<String, String> fFileToLibraryExplicitMapping;
        public Set<ParserPath> fAutoConfiguredParserPaths;
        public Set<ParserPath> fWildcardConfiguredParserPaths;
        public SourceFileToBuildFileMapping fSourceFileToBuildFileMapping;

        public PrecompiledProjectContentWrapper(Map<ParserPath, RfFileDef> filteredParserPath2FileDefMap, Map<String, String> filteredFileToLibraryWildcardMapping, Map<String, String> filteredFileToLibraryExplicitMapping, Set<ParserPath> filteredAutoConfiguredParserPaths, Set<ParserPath> filteredWildcardConfiguredParserPaths, SourceFileToBuildFileMapping filteredSourceFileToBuildFileMapping) {
            this.fParserPath2FileDefMap = filteredParserPath2FileDefMap;
            this.fFileToLibraryWildcardMapping = filteredFileToLibraryWildcardMapping;
            this.fFileToLibraryExplicitMapping = filteredFileToLibraryExplicitMapping;
            this.fAutoConfiguredParserPaths = filteredAutoConfiguredParserPaths;
            this.fWildcardConfiguredParserPaths = filteredWildcardConfiguredParserPaths;
            this.fSourceFileToBuildFileMapping = filteredSourceFileToBuildFileMapping;
        }
    }
}

