/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class R2LExternFunction
extends RfNamedElement {
    private static final long serialVersionUID = 1L;
    private RfFunction fFunction;
    private boolean fHasReturnType;
    private boolean fHasClassPrefix;
    private String fClassName;
    private boolean fWithMethodKeyword;

    public R2LExternFunction(String className, RfFunction function, boolean hasReturnType, boolean hasClassPrefix, boolean withMethodKeyword) {
        super(function.getName(), false);
        this.fFunction = function;
        this.fClassName = className;
        this.fHasReturnType = hasReturnType;
        this.fHasClassPrefix = hasClassPrefix;
        this.fWithMethodKeyword = withMethodKeyword;
    }

    public boolean hasReturnType() {
        return this.fHasReturnType;
    }

    public boolean hasClassPrefix() {
        return this.fHasClassPrefix;
    }

    public String getClassName() {
        return this.fClassName;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        if (this.fFunction.isFunction()) {
            return "extern function " + this.fFunction.getAssociatedTypeName() + " " + this.fClassName + "::" + this.fFunction.getName() + "\n" + "(" + this.fFunction.printArguments(resolver, true, null, false, false, MethodSignatureUseCase.TOOLTIP_TEXT, false) + ")";
        }
        if (this.fFunction.isTask()) {
            return "extern task " + this.fClassName + "::" + this.fFunction.getName() + "\n" + "(" + this.fFunction.printArguments(resolver, true, null, false, false, MethodSignatureUseCase.TOOLTIP_TEXT, false) + ")";
        }
        if (this.fFunction.isConstructor()) {
            return "extern constructor " + this.fClassName + "::" + this.fFunction.getName() + "\n" + "(" + this.fFunction.printArguments(resolver, true, null, false, false, MethodSignatureUseCase.TOOLTIP_TEXT, false) + ")";
        }
        return null;
    }

    public RfFunction getFunction() {
        return this.fFunction;
    }

    @Override
    public Image getImage() {
        Image initialImage = null;
        initialImage = this.fFunction.isTask() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK) : (this.fFunction.isConstructor() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRUCTOR) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD));
        ImageDescriptor[] overlayImages = new ImageDescriptor[5];
        overlayImages[1] = DVTImages.OVR_EXTERN;
        overlayImages[2] = DVTImages.DESC_OVR_IMPLEMENTS;
        DecorationOverlayIcon icon = new DecorationOverlayIcon(initialImage, overlayImages);
        return DVTImages.imageCache.getImage((ImageDescriptor)icon);
    }

    public boolean hasMethodKeyword() {
        return this.fWithMethodKeyword;
    }
}

