/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

public abstract class R2LFEBaseProposal
extends RfNamedElement {
    private static final long serialVersionUID = 1L;
    protected String replacementString;
    protected String lineDelimiter;

    protected R2LFEBaseProposal(RfProject project) {
        super("", false);
        this.lineDelimiter = project == null ? System.lineSeparator() : DVTDocumentCommon.getLineDelimiterByProject((IProject)project.getProject());
    }

    @Override
    public String getName() {
        return this.getDisplayString();
    }

    public String getTooltipComment() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentUtils.getInstance().wrapIntoItalic(this.getDescription()));
        sb.append(CommentUtils.getInstance().getNewLine());
        String resultString = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.LINKED_POSITION_PATTERN, (CharSequence)this.getReplacementString(), (String)"");
        sb.append(CommentUtils.getInstance().wrapIntoPre(DVTStringUtil.unindentLinesToLevel((String)resultString, (String)this.lineDelimiter), CommentUtils.useHtml()));
        return sb.toString();
    }

    public String getReplacementPreview() {
        return this.getReplacementString();
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    @Override
    public abstract Image getImage();

    public abstract String getDisplayString();

    public abstract String getDescription();
}

