/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementFilterAndList;
import ro.amiq.dvt.model.reflection.RfElementFilterOrList;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;

public class R2LFilters {
    private static final int DEFAULT_MAX_SIZE = 50;

    public static IRfElementFilter allowEnum(final boolean allow) {
        return new IRfElementFilter(){

            public boolean allowEnumElement() {
                return allow;
            }

            public int resultMaxSize() {
                return 50;
            }

            public boolean validElement(IRfNamedElement candidate) {
                return true;
            }
        };
    }

    public static IRfElementFilter maxSize(final int maxSize) {
        return new IRfElementFilter(){

            public boolean allowEnumElement() {
                return true;
            }

            public int resultMaxSize() {
                return maxSize;
            }

            public boolean validElement(IRfNamedElement candidate) {
                return true;
            }
        };
    }

    public static IRfElementFilter and(IRfElementFilter ... filters) {
        RfElementFilterAndList filterList = new RfElementFilterAndList();
        IRfElementFilter[] iRfElementFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IRfElementFilter filter = iRfElementFilterArray[n2];
            filterList.addElementFilter(filter);
            ++n2;
        }
        return filterList;
    }

    public static IRfElementFilter or(IRfElementFilter ... filters) {
        RfElementFilterOrList filterList = new RfElementFilterOrList();
        IRfElementFilter[] iRfElementFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IRfElementFilter filter = iRfElementFilterArray[n2];
            filterList.addElementFilter(filter);
            ++n2;
        }
        return filterList;
    }

    public static IRfElementFilter toFilter(final Predicate<IRfNamedElement> condition) {
        return new IRfElementFilter(){

            public boolean allowEnumElement() {
                return true;
            }

            public int resultMaxSize() {
                return 50;
            }

            public boolean validElement(IRfNamedElement candidate) {
                return condition.test(candidate);
            }
        };
    }

    public static IRfElementFilter actionBlockIsAlwaysBlock(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfActionBlock)) {
                return false;
            }
            RfActionBlock actionBlock = (RfActionBlock)candidate;
            boolean condition = actionBlock.isAlways();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter assocTypeHasFilter(IRfElementFilter filter) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfTypeAlias)) {
                return false;
            }
            RfTypeAlias typeAlias = (RfTypeAlias)candidate;
            return filter.validElement(typeAlias.getAssociatedType());
        });
    }

    public static IRfElementFilter candidateOrAssocTypeHasFilter(IRfElementFilter filter) {
        return R2LFilters.or(filter, R2LFilters.assocTypeHasFilter(filter));
    }

    public static IRfElementFilter translatedTypeHasFilter(IRfElementFilter filter) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfTypeAlias)) {
                return false;
            }
            RfTypeAlias typeAlias = (RfTypeAlias)candidate;
            return filter.validElement(typeAlias.getTranslatedType());
        });
    }

    public static IRfElementFilter candidateOrTranslatedTypeHasFilter(IRfElementFilter filter) {
        return R2LFilters.or(filter, R2LFilters.translatedTypeHasFilter(filter));
    }

    public static IRfElementFilter classIsInterfaceClass(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfClass)) {
                return false;
            }
            RfClass clazz = (RfClass)candidate;
            boolean condition = clazz.isInterfaceClass();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter clockingBlockHasClocking(boolean allow, RfModport modport) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfClockingBlock)) {
                return false;
            }
            boolean condition = modport.hasClocking(candidate.getName());
            return allow ? condition : !condition;
        });
    }

    public static <T> IRfElementFilter mapContainsCandidateKey(boolean allow, DVTLinkedHashMap<T, ?> map, Function<IRfNamedElement, T> keyConverter) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = map.containsKey(keyConverter.apply((IRfNamedElement)candidate));
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter namedElementIsObjectStatic(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfNamedElement)) {
                return false;
            }
            RfNamedElement element = (RfNamedElement)candidate;
            boolean condition = element.isObjectStatic();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter namedElementIsDeclaredBefore(boolean allow, RfProject rfProject, RfNamedElement otherElement) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfNamedElement)) {
                return false;
            }
            RfNamedElement element = (RfNamedElement)candidate;
            boolean condition = element.isDeclaredBefore(rfProject, otherElement);
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldElementIsParameter(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof IRfFieldElement)) {
                return false;
            }
            IRfFieldElement field = (IRfFieldElement)candidate;
            boolean condition = field.isParameter();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldElementIsTypeParameter(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof IRfFieldElement)) {
                return false;
            }
            IRfFieldElement field = (IRfFieldElement)candidate;
            boolean condition = field.isTypeParameter();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldIsArgument(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)candidate;
            boolean condition = field.isArgument();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldIsEnum(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)candidate;
            boolean condition = field.isEnumElement();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldIsField(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)candidate;
            boolean condition = field.isField();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldIsParameter(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)candidate;
            boolean condition = field.isParameter();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldIsSignal(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)candidate;
            boolean condition = field.isSignal();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldIsGenvar(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)candidate;
            boolean condition = field.isGenvar();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldIsVariable(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)candidate;
            boolean condition = field.isVariable();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter fieldIsTypeParameter(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)candidate;
            boolean condition = field.isTypeParameter();
            return allow ? condition : !condition;
        });
    }

    @SafeVarargs
    public static IRfElementFilter fromClassSet(boolean allow, Class<? extends IRfNamedElement> ... c) {
        HashSet<Class<? extends IRfNamedElement>> classes = new HashSet<Class<? extends IRfNamedElement>>(Arrays.asList(c));
        return R2LFilters.toFilter(candidate -> {
            boolean condition = classes.contains(candidate.getClass());
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter functionHasImplementation(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition;
            if (!(candidate instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)candidate;
            boolean bl2 = condition = function.getImplementation() != null;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter functionHasReturnType(boolean allow, String returnType) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)candidate;
            String dataTypeName = "";
            DataType dataType = function.getDataType();
            if (dataType != null) {
                String rawTypeName = dataType.getType();
                dataTypeName = rawTypeName == null || rawTypeName.isEmpty() ? "logic" : rawTypeName;
            }
            boolean condition = dataTypeName.equals(returnType);
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter functionIsConstructor(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)candidate;
            boolean condition = function.isConstructor();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter functionIsExtern(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)candidate;
            boolean condition = function.isExtern();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter functionIsPredefined(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)candidate;
            boolean condition = function.isPredefined();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter functionIsTask(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)candidate;
            boolean condition = function.isTask();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter functionIsVirtual(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)candidate;
            boolean condition = function.isVirtual();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter hasName(boolean allow, String name) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate.getName().equals(name);
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isChecker(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfChecker;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isClass(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfClass;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isConstraint(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfConstraint;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isCovergroup(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfCovergroup;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isCoverpoint(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfCoverpoint;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isDesignElement(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof IRfDesignElement;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isField(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfField;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isFieldElement(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof IRfFieldElement;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isFunction(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfFunction;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isInEnclosingClass(boolean allow, IRfScopeElement scope) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition;
            HashSet<Class<RfPredefinedClass>> validScopes = new HashSet<Class<RfPredefinedClass>>();
            validScopes.add(RfClass.class);
            validScopes.add(RfSpecializedClass.class);
            validScopes.add(RfPredefinedClass.class);
            boolean bl2 = condition = candidate.getEnclosingScope(validScopes) == scope;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isDeclaredInFile(boolean allow, ParserPath file) {
        return R2LFilters.toFilter(candidate -> {
            IRfDefElement declaration = candidate.getDeclaration();
            if (declaration == null) {
                return !allow;
            }
            ParserPath parserPath2 = declaration.getParserPath();
            if (parserPath2 == null) {
                return !allow;
            }
            boolean condition = parserPath2.equals((Object)file);
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isInterface(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfInterface;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isLibrary(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfLibrary;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isLibraryElement(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof IRfLibraryElement;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isModule(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfModule;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isNamedElement(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfNamedElement;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isNonStandard(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate.isNonStandard();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isNull(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition;
            boolean bl2 = condition = candidate == null;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isPackage(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfPackage;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isPackageElement(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof IRfPackageElement;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isPortElement(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof IRfPortElement;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isProgram(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfProgram;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isTypeAlias(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfTypeAlias;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter libraryIsNonTopFiles(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfLibrary)) {
                return false;
            }
            RfLibrary library = (RfLibrary)candidate;
            boolean condition = library.isNonTopFilesLibrary();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter modifiedCandidateHasFilter(UnaryOperator<IRfNamedElement> modifier, IRfElementFilter filter) {
        return R2LFilters.toFilter(candidate -> filter.validElement((IRfNamedElement)modifier.apply((IRfNamedElement)candidate)));
    }

    public static <T> IRfElementFilter nullableSetContainsCandidateKey(boolean allow, Set<T> set, Function<IRfNamedElement, T> keyConverter) {
        return R2LFilters.or(R2LFilters.toFilter(c -> set == null), R2LFilters.setContainsCandidateKey(allow, set, keyConverter));
    }

    public static IRfElementFilter nullableSetContainsCandidateName(boolean allow, Set<String> set) {
        return R2LFilters.or(R2LFilters.toFilter(c -> set == null), R2LFilters.setContainsCandidateName(allow, set));
    }

    public static IRfElementFilter sameReference(boolean allow, Object o) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition;
            boolean bl2 = condition = candidate == o;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter setContainsCandidate(boolean allow, Set<IRfNamedElement> set) {
        return R2LFilters.setContainsCandidateKey(allow, set, Function.identity());
    }

    public static IRfElementFilter setContainsCandidateClass(boolean allow, Set<Class<? extends IRfNamedElement>> set) {
        return R2LFilters.setContainsCandidateKey(allow, set, Object::getClass);
    }

    public static IRfElementFilter setContainsCandidateName(boolean allow, Set<String> set) {
        return R2LFilters.setContainsCandidateKey(allow, set, IRfNamedElement::getName);
    }

    public static <T> IRfElementFilter setContainsCandidateKey(boolean allow, Set<T> set, Function<IRfNamedElement, T> keyConverter) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = set.contains(keyConverter.apply((IRfNamedElement)candidate));
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter portIsInput(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfPort)) {
                return false;
            }
            RfPort port = (RfPort)candidate;
            boolean condition = port.isInput();
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter isPort(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition = candidate instanceof RfPort;
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter functionOrTaskIsPredefined(boolean allow) {
        return R2LFilters.toFilter(candidate -> {
            boolean condition;
            if (!(candidate instanceof RfFunction)) {
                return true;
            }
            RfFunction func = (RfFunction)candidate;
            boolean bl2 = condition = func.isPredefined() || func.isTask() && func.getName().charAt(0) == '$';
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter hasDataType(boolean allow, String dataTypeName) {
        return R2LFilters.toFilter(candidate -> {
            if (!(candidate instanceof RfAssociatedType)) {
                return false;
            }
            RfAssociatedType assocType = (RfAssociatedType)candidate;
            DataType dataType = assocType.getDataType();
            if (dataType == null) {
                return false;
            }
            String type = dataType.getType();
            boolean condition = dataTypeName.equals(type == null || type.isEmpty() ? "logic" : type);
            return allow ? condition : !condition;
        });
    }

    public static IRfElementFilter portHasDataType(boolean allow, String dataTypeName) {
        return R2LFilters.and(R2LFilters.isPort(allow), R2LFilters.hasDataType(allow, dataTypeName));
    }

    public static IRfElementFilter fieldHasDataType(boolean allow, String dataTypeName) {
        return R2LFilters.and(R2LFilters.isField(allow), R2LFilters.hasDataType(allow, dataTypeName));
    }

    public static IRfElementFilter isStdPredefined(String prefix, IRfScopeElement scope) {
        return R2LFilters.toFilter(candidate -> {
            if ("<std>".equals(candidate.getName())) {
                return false;
            }
            if (prefix != null && !prefix.isEmpty()) {
                return true;
            }
            IRfScopeElement candidateEnclosingScope = candidate.getEnclosingScope();
            return scope != null && "std".equals(scope.getName()) || !"std".equals(candidate.getName()) && (candidateEnclosingScope == null || !"std".equals(candidateEnclosingScope.getName()));
        });
    }
}

