/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAmbiguous;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfFunctionCallDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNamespaceElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.RfUtilities;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.r2lparser.R2LResultContainer;
import ro.amiq.vlogdt.r2lparser.R2LScopeContainer;

public abstract class R2LManager {
    public static final int UNDEF_ACCESS = -1;
    public static final int DOT_ACCESS = 0;
    public static final int COLON_ACCESS = 1;
    public static final int COLON_COLON_ACCESS = 2;
    public static final int CLASS_NAME = 1;
    public static final int FUNCTION_NAME = 2;
    public static final int RETURN_NAME = 3;
    protected static VlogMacroInfo DEFAULT_NETTYPE = VlogMacroInfo.createDummyMacroInfo(null, "default_nettype", "Controls the net type created for implicit net declarations. It can be used only outside design elements. When no &lt;b&gt;`default_nettype&lt;/b&gt; directive is present or if the &lt;b&gt;`resetall&lt;/b&gt; directive is specified, implicit nets are of type &lt;b&gt;wire&lt;/b&gt;. When the &lt;b&gt;`default_nettype&lt;/b&gt; is set to &lt;b&gt;none&lt;/b&gt;, all nets shall be explicitly declared. If a net is not explicitly declared, an error is generated.");
    protected IRfScope fInitialScope;
    protected DVTEditor fEditor;
    protected IDocument fDocument;
    protected int fDocumentOffset;
    protected int fScopeOffset;
    protected int fDocumentLine;
    protected RfProject fRfProject;
    protected Deque<RfWNamedElementAndScope> fElementAndScopeStack;
    protected RfFileDef fFileDef;
    protected RfInstance fInstance;
    protected ParserPath fResource;
    protected RfAssociatedType fThisElement;
    private IProgressMonitor progressMonitor;

    protected R2LManager(DVTEditor textEditor, RfProject rfProject, IRfScope initialScope, RfInstance instance, ParserPath file, IDocument document, int documentOffset, int scopeOffset, IProgressMonitor progressMonitor) {
        try {
            this.fFileDef = file == null || rfProject == null ? null : rfProject.getFile(file);
            this.fInitialScope = initialScope;
            this.fInstance = instance;
            this.fResource = file;
            this.fDocument = document;
            this.fScopeOffset = scopeOffset;
            this.fDocumentOffset = documentOffset;
            this.fDocumentLine = this.fDocument.getLineOfOffset(documentOffset) + 1;
            this.fRfProject = rfProject;
            this.progressMonitor = progressMonitor;
            this.fEditor = textEditor;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public abstract R2LResultContainer getProposals();

    public abstract IRfNamedElementAndScope getElement();

    public final R2LScopeContainer getScope(R2LScopeContainer scopeContainer, int accessKind, String name, DataType dataType, boolean methodCall, List<String> selects, boolean isPackageOrClass, RfTypesResolver resolver) {
        ElementPath bcPath;
        DVTEditor editor;
        IELMemory memory;
        IRfDesignElement iRfDesignElement;
        IRfSingleLangProject rfProject;
        IRfScopeElement enclosingModule;
        IRfDesignElement tmpResultScope;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        if ("output".equals(name) || "input".equals(name) || "inout".equals(name) || "ref".equals(name) || name.startsWith("`")) {
            return scopeContainer;
        }
        final R2LScopeContainer result = new R2LScopeContainer(scopeContainer);
        if (this.isNumber(name)) {
            result.isNumber = true;
            this.pushElementAndScope(scopeContainer.scope, null, selects, null);
            return result;
        }
        if ("local".equals(name)) {
            result.isLocal = true;
            this.pushElementAndScope(scopeContainer.scope, null, selects, null);
            return result;
        }
        result.scope = null;
        if (accessKind == 1 && scopeContainer.isNumber) {
            accessKind = 0;
        }
        boolean isFirst = scopeContainer.path == null || scopeContainer.path.isEmpty() || scopeContainer.path.size() == 1 && scopeContainer.isLocal;
        IRfNamedElement.AccessModifier accessModifier = isFirst || scopeContainer.path.size() == 1 && scopeContainer.path.get(0).equals("this") ? IRfNamedElement.AccessModifier.SHOW_PRIVATE : IRfNamedElement.AccessModifier.SHOW_PROTECTED;
        IRfNamedElement candidate = null;
        if (!(scopeContainer.scope instanceof IRfScope)) {
            IRfScopeElement scopeElement = scopeContainer.scope;
            if (scopeElement instanceof IRfPackageElement) {
                candidate = ((IRfPackageElement)scopeElement).getImportedSymbol(name);
            } else {
                RfLibrary initialScopeLibrary;
                IRfDesignElement architecture;
                if (scopeElement instanceof IRfDesignElement && (architecture = ((IRfDesignElement)scopeElement).getArchitecture()) != null) {
                    candidate = architecture.getBlockWithPrefix(name, 9);
                    if (candidate == null) {
                        candidate = architecture.getInstanceWithPrefix(name, 9);
                    }
                    if (candidate == null) {
                        candidate = architecture.getSignalWithPrefix(name, 9);
                    }
                }
                if (candidate == null) {
                    candidate = scopeElement.getInstanceWithPrefix(name, 9);
                }
                if (candidate == null && (initialScopeLibrary = this.fInitialScope.getEnclosingLibrary()) instanceof RfLibrary && (scopeElement instanceof IRfDesignElement || scopeElement instanceof RfGenerateBlock || scopeElement instanceof RfInstance)) {
                    candidate = initialScopeLibrary.getBindInstance(name, (IRfNamedElement)scopeElement, ElementPath.create(scopeContainer.path));
                }
            }
        } else {
            IRfLibraryElement library;
            RfNamedElement namedElementScope;
            IRfScopeElement scope = scopeContainer.scope;
            if ("$root".equals(name) || "$unit".equals(name)) {
                while (scope != null && !(scope instanceof RfLibrary)) {
                    scope = scope.getEnclosingScope();
                }
                result.scope = scope instanceof RfLibrary ? new RfNamespaceElement(name, false, (RfLibrary)scope) : scope;
                this.pushElementAndScope(result.scope, candidate, selects, null);
                return result;
            }
            accessModifier = this.getAccessModifierCorrection(scope, accessModifier);
            R2LScopeContainer randomizeScope = null;
            randomizeScope = this.getRandomizeWithScope(scopeContainer);
            if (randomizeScope != null && randomizeScope.scope instanceof RfClass && (randomizeScope = this.getScope(randomizeScope, accessKind, name, dataType, methodCall, selects, isPackageOrClass, resolver)) != null && randomizeScope.scope != null) {
                return randomizeScope;
            }
            RfNamedElement rfNamedElement = namedElementScope = scope instanceof RfDefElement ? ((RfDefElement)scope).getLastNamedElement() : (RfNamedElement)scope;
            if (isPackageOrClass) {
                candidate = namedElementScope.getMember(name, DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM, null, isFirst, false, true, true, false);
            }
            if (candidate == null && namedElementScope != null) {
                candidate = namedElementScope.getMember(name, null, null, isFirst, false, true, false, false);
            }
            if (candidate instanceof RfAmbiguous) {
                candidate = null;
            }
            if (candidate == null && (library = scope.getEnclosingLibrary()) instanceof RfLibrary && (scope instanceof IRfDesignElement || scope instanceof RfGenerateBlock || scope instanceof RfInstance)) {
                candidate = ((RfLibrary)library).getBindInstance(name, (IRfNamedElement)scope, ElementPath.create(scopeContainer.path));
            }
            if (this.fInstance != null) {
                IRfNamedElement bindScope = this.fInstance.getBindInstanceScope();
                if (bindScope != null) {
                    if (this.fInstance.getName().equals(name)) {
                        result.candidate = this.fInstance;
                        result.scope = bindScope;
                        result.isBind = true;
                        return result;
                    }
                    scopeContainer.scope = bindScope;
                } else if (this.fInstance.getName().equals(name)) {
                    result.candidate = this.fInstance;
                    result.scope = scopeContainer.scope;
                    return result;
                }
                if (scopeContainer.scope instanceof IRfScope) {
                    scope = scopeContainer.scope;
                }
                if (scopeContainer.scope instanceof IRfDesignElement && candidate == null) {
                    candidate = ((IRfDesignElement)scopeContainer.scope).getInstanceWithPrefix(name, 1);
                }
            }
            if (candidate == null) {
                RfFunction functionScope = null;
                if (scopeContainer.candidate instanceof RfFunction) {
                    functionScope = (RfFunction)scopeContainer.candidate;
                } else if (scope instanceof RfFunction) {
                    functionScope = (RfFunction)scope;
                }
                RfNamedElement rfNamedElement2 = namedElementScope = functionScope == null ? namedElementScope : functionScope;
                if (namedElementScope != null) {
                    candidate = namedElementScope.semanticGetActionBlockOrField(name);
                }
            }
        }
        if (candidate == null || candidate == this.fThisElement) {
            scopeContainer.scope = null;
            scopeContainer.candidate = result.candidate;
            this.pushElementAndScope(result.scope, candidate, selects, null);
            return scopeContainer;
        }
        if (candidate instanceof RfNamedElement) {
            result.candidate = (RfNamedElement)candidate;
        }
        if (candidate instanceof RfFunction && ((RfFunction)candidate).isTask() || candidate instanceof RfActionBlock) {
            scopeContainer.scope = candidate;
            scopeContainer.candidate = result.candidate;
            this.pushElementAndScope(result.scope, null, selects, null);
            return scopeContainer;
        }
        result.scope = candidate;
        DataTypeDimensions dimensions = new DataTypeDimensions(null);
        if (result.scope instanceof RfTypeAlias) {
            result.scope = ((RfTypeAlias)result.scope).getTranslatedType(resolver, false, dimensions, null);
        } else {
            dimensions = new DataTypeDimensions(candidate);
        }
        IRfNamedElement nextScope = null;
        if (result.scope instanceof IRfAssociatedTypeElement) {
            if (result.scope instanceof RfAssociatedType) {
                nextScope = ((RfAssociatedType)result.scope).getAssociatedType(resolver);
                if (nextScope instanceof RfTypeAlias) {
                    nextScope = ((RfTypeAlias)nextScope).getTranslatedType(resolver, false, dimensions, null);
                }
            } else {
                nextScope = ((IRfAssociatedTypeElement)result.scope).getAssociatedType();
            }
        }
        if (selects != null && !selects.isEmpty() && result.scope instanceof RfAssociatedType) {
            String select;
            int index = 0;
            while (nextScope instanceof IRfListType && index < selects.size()) {
                select = selects.get(index);
                ++index;
                int length = select.length();
                if (length < 2 || select.charAt(0) != '[' || select.charAt(length - 1) != ']') continue;
                if (!RfUtilities.isRange(select, 1, length - 1)) {
                    nextScope = ((IRfListType)nextScope).getAssociatedType();
                    this.decreaseUnpackedDimension(dimensions);
                    if (!(nextScope instanceof RfTypeAlias)) continue;
                    nextScope = ((RfTypeAlias)nextScope).getTranslatedType(resolver, false, dimensions, null);
                    continue;
                }
                this.resizeUnpackedDimension(dimensions, select);
            }
            while (nextScope != null && index < selects.size()) {
                select = selects.get(index);
                ++index;
                if (select.indexOf(":") == -1) {
                    this.decreasePackedDimension(dimensions);
                    continue;
                }
                this.resizePackedDimension(dimensions, select);
            }
            dimensions.packed = DataTypeDimensions.appendDimension(dimensions.packedResized, dimensions.packed);
            dimensions.unpacked = DataTypeDimensions.appendDimension(dimensions.unpackedResized, dimensions.unpacked);
            dimensions.packedResized = null;
            dimensions.unpackedResized = null;
        }
        if (nextScope != null) {
            result.scope = nextScope;
        }
        if (result.scope instanceof IRfListType && ((IRfListType)result.scope).isUnboundedArray()) {
            result.scope = ((IRfListType)result.scope).getAssociatedType();
        }
        if (result.scope instanceof IRfDesignElement && ((IRfDesignElement)result.scope).getKind() == IRfNamedElement.ElementKind.VHDL_COMPONENT && (tmpResultScope = ((IRfDesignElement)result.scope).getResolvedElement()) != null) {
            result.scope = tmpResultScope;
        }
        if ((result.scope instanceof RfInterface || result.scope instanceof RfPredefinedClass && result.scope.getName().equals("interface")) && candidate instanceof IRfPortElement && (enclosingModule = candidate.getEnclosingScope()) instanceof IRfDesignElement && (rfProject = (iRfDesignElement = (IRfDesignElement)enclosingModule).getRfProject()) != null && (memory = RfMixedLangManager.getInstance().getELMemory(rfProject.getProject())) != null && (editor = this.fRfProject.getEditor(this.fResource)) != null && (bcPath = DesignPathManager.getInstance().getPathFor(editor, (IRfNamedElement)((IRfDesignElement)enclosingModule), false)) != null) {
            final IRfPortElement portCandidate = (IRfPortElement)candidate;
            memory.visitBindings(new IELMemory.IELMemoryVisitor(){

                public boolean visitBindings(ElementPath path, ELInstance instance) {
                    if (instance.getBinding(false) == enclosingModule && path.equals((Object)bcPath.toElaborationForm())) {
                        ELSpecialization.InterfacePortInstance interfacePortInstance = instance.getInterfacePortInstance(portCandidate.getName());
                        if (interfacePortInstance != null) {
                            result.scope = interfacePortInstance.getType();
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        if (result.scope == null) {
            scopeContainer.scope = null;
            scopeContainer.candidate = result.candidate;
            this.pushElementAndScope(result.scope, candidate, selects, dimensions);
            return scopeContainer;
        }
        if (candidate instanceof RfNamedElement && (((RfNamedElement)candidate).isRand() || ((RfNamedElement)candidate).isRandc()) && result.scope instanceof RfNamedElement) {
            result.isRand = true;
        }
        this.pushElementAndScope(result.scope, candidate, selects, dimensions);
        return result;
    }

    protected R2LScopeContainer getRandomizeWithScope(R2LScopeContainer scopeContainer) {
        RfFunctionCall functionCallContainer;
        RfNamedElement namedElementScope;
        if (!(scopeContainer.scope instanceof IRfScope)) {
            return null;
        }
        IRfScope scope = (IRfScope)scopeContainer.scope;
        RfNamedElement rfNamedElement = namedElementScope = scope instanceof RfDefElement ? ((RfDefElement)scope).getNamedElement() : (RfNamedElement)scope;
        if (namedElementScope instanceof RfActionBlock && (functionCallContainer = namedElementScope.getEnclosingScope(RfFunctionCall.class)) != null && functionCallContainer.hasWith()) {
            scope = functionCallContainer;
        }
        if (scope instanceof RfFunctionCallDef) {
            scope = ((RfFunctionCallDef)scope).getNamedElement();
        }
        if (!(scope instanceof RfFunctionCall) || !((RfFunctionCall)scope).hasWith()) {
            return null;
        }
        RfNamedElement calledFromScope = ((RfFunctionCall)scope).getCalledFromScope();
        if (calledFromScope != null && !scopeContainer.isLocal) {
            R2LScopeContainer result = new R2LScopeContainer(calledFromScope);
            result.path = new ArrayList<String>();
            result.path.add(calledFromScope.getName());
            return result;
        }
        return null;
    }

    protected IRfNamedElement.AccessModifier getAccessModifierCorrection(IRfScopeElement scope, IRfNamedElement.AccessModifier accessModifier) {
        if (accessModifier != IRfNamedElement.AccessModifier.SHOW_PRIVATE) {
            IRfScope temp = this.fInitialScope;
            while ((temp = temp.getEnclosingScope()) != null) {
                if (temp != scope) continue;
                accessModifier = IRfNamedElement.AccessModifier.SHOW_PRIVATE;
                break;
            }
        }
        return accessModifier;
    }

    private void resizePackedDimension(DataTypeDimensions dimensions, String select) {
        dimensions.packed = DataTypeDimensions.decreaseDimension(dimensions.packed);
        if (select != null && select.length() > 1) {
            dimensions.packedResized = DataTypeDimensions.appendDimension(dimensions.packedResized, new IndexType(select.substring(1, select.length() - 1)));
        }
    }

    private void decreasePackedDimension(DataTypeDimensions dimensions) {
        dimensions.packed = DataTypeDimensions.decreaseDimension(dimensions.packed);
    }

    private void resizeUnpackedDimension(DataTypeDimensions dimensions, String select) {
        dimensions.unpacked = DataTypeDimensions.decreaseDimension(dimensions.unpacked);
        if (select != null && select.length() > 1) {
            dimensions.unpackedResized = DataTypeDimensions.appendDimension(dimensions.unpackedResized, new IndexType(select.substring(1, select.length() - 1)));
        }
    }

    private void decreaseUnpackedDimension(DataTypeDimensions dimensions) {
        dimensions.unpacked = DataTypeDimensions.decreaseDimension(dimensions.unpacked);
    }

    protected void pushElementAndScope(IRfScopeElement scope, IRfNamedElement element, List<String> selects, DataTypeDimensions dimensions) {
        if (this.fElementAndScopeStack == null) {
            return;
        }
        RfWNamedElementAndScope newElementAndScope = new RfWNamedElementAndScope(element, scope, selects, dimensions);
        this.fElementAndScopeStack.push(newElementAndScope);
    }

    protected void pushElementAndScope(IRfScopeElement scope, IRfNamedElement element, IRfNamedElement elementAssocType, Hid hid) {
        if (this.fElementAndScopeStack == null) {
            return;
        }
        RfWNamedElementAndScope newElementAndScope = new RfWNamedElementAndScope(element, scope, (IRfScopeElement)elementAssocType, null, hid, null);
        this.fElementAndScopeStack.push(newElementAndScope);
    }

    protected boolean isNumber(String name) {
        if (name.length() > 2 && name.charAt(0) == '\'') {
            name = name.substring(2);
        }
        return DVTStringUtil.isNumber((String)name);
    }

    protected boolean contains(IRfScopeElement scope, IRfScope parentScope) {
        if (scope == parentScope) {
            return true;
        }
        if (scope instanceof RfNamedElement) {
            scope = ((RfNamedElement)scope).getDeclaration();
        }
        if (scope instanceof RfNamedElement) {
            parentScope = ((RfNamedElement)scope).getDeclaration();
        }
        if (scope instanceof RfDefElement && parentScope instanceof RfDefElement) {
            boolean result;
            ParserPath parentScopeParserPath;
            ParserPath scopeParserPath = ((RfDefElement)scope).getParserPath();
            if (scopeParserPath != (parentScopeParserPath = ((RfDefElement)parentScope).getParserPath()) || scopeParserPath == null) {
                return false;
            }
            boolean bl = result = ((RfDefElement)scope).getStartOffset() <= ((RfDefElement)parentScope).getStartOffset() && ((RfDefElement)scope).getEndOffset() >= ((RfDefElement)parentScope).getEndOffset();
            if (result) {
                return result;
            }
            if (parentScope instanceof RfFunctionDef) {
                RfNamedElement element = ((RfFunctionDef)parentScope).getNamedElement();
                parentScope = element.getDeclaration();
            } else if (parentScope instanceof RfActionBlockDef) {
                RfNamedElement element = ((RfActionBlockDef)parentScope).getNamedElement();
                while (element != null && !(element instanceof RfFunction)) {
                    element = element.getEnclosingScope();
                }
                if (element == null) {
                    return false;
                }
                parentScope = element.getDeclaration();
            }
            result = ((RfDefElement)scope).getStartOffset() <= ((RfDefElement)parentScope).getStartOffset() && ((RfDefElement)scope).getEndOffset() >= ((RfDefElement)parentScope).getEndOffset();
            return result;
        }
        return false;
    }

    protected void searchInstances(ElementPath searchInstancePath, Map<String, IRfInstanceElement> result, boolean allowInstanceToBind, ElementPath instancePath, Collection<? extends IRfNamedElement> instancesOrInstanceHolders) {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            return;
        }
        if (instancesOrInstanceHolders == null || instancesOrInstanceHolders.isEmpty()) {
            return;
        }
        if (instancePath.startsWith(searchInstancePath) && !instancePath.equals((Object)searchInstancePath)) {
            return;
        }
        ELManager elManager = this.fRfProject.getELManager();
        DVTEditor editor = this.fRfProject.getEditor(this.fResource);
        for (IRfNamedElement iRfNamedElement : instancesOrInstanceHolders) {
            ElementPath currentElementPath;
            ElementPath newInstancePath;
            if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                return;
            }
            if (iRfNamedElement instanceof RfGenerateBlock && !((RfGenerateBlock)iRfNamedElement).hasInstances() || !allowInstanceToBind && iRfNamedElement instanceof IRfInstanceElement && ((IRfInstanceElement)iRfNamedElement).isInstanceToBind() || (newInstancePath = (currentElementPath = DesignPathManager.getInstance().getPathFor(editor, iRfNamedElement, true))) == null || newInstancePath.isEmpty()) continue;
            if (newInstancePath != null && newInstancePath.length() > 0 && newInstancePath.lastSegment() != null && newInstancePath.lastSegment().equals(searchInstancePath.firstSegment())) {
                newInstancePath = newInstancePath.removeLastSegment();
            }
            String[] stringArray = searchInstancePath.getSegments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                newInstancePath = ElementPath.join((ElementPath)newInstancePath, (String)segment);
                ++n2;
            }
            Map subTreeInstances = elManager.getMemory().subtreeOf(newInstancePath, false);
            if (subTreeInstances == null) continue;
            for (Map.Entry subTreeInstance : subTreeInstances.entrySet()) {
                IRfInstanceElement instanceElement;
                ELInstance subInstance;
                ElementPath subInstancePath = (ElementPath)subTreeInstance.getKey();
                if (subInstancePath == null || (subInstance = (ELInstance)subTreeInstance.getValue()) == null || subInstancePath.getSegments().length != newInstancePath.getSegments().length + 1 || (instanceElement = subInstance.getDescription()) == null) continue;
                result.put(instanceElement.getName(), instanceElement);
            }
        }
    }

    protected RfStruct internalGetStructInitScope(R2LScopeContainer scopeContainer, String fieldName, String[] positions, int nested) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        IRfNamedElement[] fieldCandidates = this.getExprCandidates(scopeContainer, null, -1, fieldName, false, false, false, false, false, false);
        if (fieldCandidates == null || fieldCandidates.length == 0 || !(fieldCandidates[0] instanceof RfField) && !(fieldCandidates[0] instanceof RfStruct) && !(fieldCandidates[0] instanceof RfTypeAlias)) {
            return null;
        }
        IRfNamedElement scope = fieldCandidates[0];
        IRfScopeElement initialScope = scopeContainer.scope;
        if (initialScope instanceof RfDefElement) {
            initialScope = ((RfDefElement)initialScope).getNamedElement();
        }
        RfTypesResolver resolver = RfTypesResolver.create(initialScope, scope.getRfProject(), 0);
        while (nested >= 0) {
            if (scope instanceof RfField) {
                scope = ((RfField)scope).getAssociatedType(resolver);
            }
            if (scope instanceof RfTypeAlias) {
                scope = ((RfTypeAlias)scope).getTranslatedType(resolver);
            }
            if (scope == null) {
                return null;
            }
            if (nested > 0) {
                if (scope instanceof RfListType) {
                    if ((scope = ((RfListType)scope).getAssociatedType()) instanceof RfTypeAlias) {
                        scope = ((RfTypeAlias)scope).getTranslatedType();
                    }
                } else if (scope instanceof RfStruct) {
                    List<RfField> structFields = ((RfStruct)scope).getLocalFields();
                    if (nested > positions.length) {
                        return null;
                    }
                    int index = Integer.parseInt(positions[nested - 1]);
                    if (structFields == null || structFields.isEmpty() || index >= structFields.size()) {
                        return null;
                    }
                    scope = structFields.get(index);
                }
            }
            --nested;
        }
        if (scope instanceof RfStruct) {
            return (RfStruct)scope;
        }
        return null;
    }

    public abstract IRfNamedElement[] getEnumCandidates(R2LScopeContainer var1, Set<String> var2, String var3);

    public abstract IRfNamedElement[] getRandomizeArgsCandidates(R2LScopeContainer var1, Set<String> var2, String var3);

    public abstract IRfNamedElement[] getCovercrossCandidates(R2LScopeContainer var1, Set<String> var2, String var3);

    public abstract IRfNamedElement[] getCoverpointCandidates(R2LScopeContainer var1, int var2, String var3);

    public abstract IRfNamedElement[] getExprCandidates(R2LScopeContainer var1, R2LScopeContainer var2, int var3, String var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10);

    public abstract IRfNamedElement[] getBindCandidates(String var1, String var2, R2LScopeContainer var3, boolean var4, String var5);

    public abstract IRfNamedElement[] getMacroCandidates(String var1);

    public abstract File[] getIncludeCandidates(String var1);

    public abstract IRfNamedElement[] getPortCandidates(String var1, String var2, List<String> var3, String var4);

    public abstract IRfNamedElement[] getParametersCandidates(String var1, String var2, List<String> var3, String var4);

    public abstract IRfNamedElement[] getInterfaceClassCandidates(Set<String> var1, String var2);

    public abstract IRfNamedElement[] getClassCandidates(String var1, R2LScopeContainer var2, String var3);

    public abstract IRfNamedElement[] getImportCandidates(String var1, String var2);

    public abstract IRfNamedElement[] getFunctionCandidates(R2LScopeContainer var1, String var2, String var3, String var4, boolean var5, boolean var6);

    public abstract IRfNamedElement[] getConstraintCandidates(R2LScopeContainer var1, String var2, String var3, boolean var4, boolean var5);

    public abstract IRfNamedElement[] getIfdefCandidates(String var1);

    public abstract IRfNamedElement[] getTypeCandidates(R2LScopeContainer var1, int var2, String var3, boolean var4);

    public abstract IRfNamedElement[] getEndOfIdentifier(R2LScopeContainer var1, String var2, String var3);

    public abstract IRfNamedElement[] getStructFieldCandidates(R2LScopeContainer var1, String var2, String[] var3, int var4, String var5);

    public abstract IRfNamedElement[] getFunctionArgsCandidates(R2LScopeContainer var1, R2LScopeContainer var2, R2LScopeContainer var3, int var4, List<String> var5, String var6, String var7, boolean var8);

    public abstract IRfNamedElement[] getLibraryModuleCandidates(R2LScopeContainer var1, int var2, String var3, boolean var4);

    public IDocument getDocument() {
        return this.fDocument;
    }

    public int getDocumentLine() {
        return this.fDocumentLine;
    }

    public RfProject getProject() {
        return this.fRfProject;
    }

    public RfFileDef getFileDef() {
        return this.fFileDef;
    }

    public boolean isOffsetOnDataType() {
        return false;
    }
}

