/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;

public class R2LOverrideFunction
extends RfNamedElement {
    private static final long serialVersionUID = 1L;
    private RfFunction function;
    private boolean hasReturnType;
    private boolean hasExtern;
    private boolean withMethodKeyword;

    public R2LOverrideFunction(RfFunction function, boolean hasReturnType, boolean hasExtern, boolean withMethodKeyword) {
        super(function.getName(), false);
        this.function = function;
        this.hasReturnType = hasReturnType;
        this.hasExtern = hasExtern;
        this.withMethodKeyword = withMethodKeyword;
    }

    public RfFunction getFunction() {
        return this.function;
    }

    public boolean hasReturnType() {
        return this.hasReturnType;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        this.function.setSignatureUseCase(MethodSignatureUseCase.METHOD_OVERRIDE_CODE_GENERATION);
        return this.function.getSignature();
    }

    public boolean hasExtern() {
        return this.hasExtern;
    }

    @Override
    public Image getImage() {
        Image initialImage = null;
        initialImage = this.function.isTask() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK) : (this.function.isConstructor() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRUCTOR) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD));
        ImageDescriptor overlayImage = null;
        if (this.function.isConstructor()) {
            overlayImage = DVTImages.DESC_OVR_IMPLEMENTS;
        } else if (this.function.isPredefined()) {
            RfFunction parentFunction = RfBatchUtils.getParentPredefinedFunction(this.function, true);
            overlayImage = parentFunction == null ? DVTImages.DESC_OVR_IMPLEMENTS : DVTImages.DESC_OVR_OVERRIDES;
        } else if (this.function.isPure()) {
            overlayImage = DVTImages.DESC_OVR_IMPLEMENTS;
        } else if (this.function.isVirtual()) {
            overlayImage = DVTImages.DESC_OVR_OVERRIDES;
        }
        DecorationOverlayIcon icon = new DecorationOverlayIcon(initialImage, overlayImage, 2);
        return DVTImages.imageCache.getImage((ImageDescriptor)icon);
    }

    public boolean hasMethodKeyword() {
        return this.withMethodKeyword;
    }
}

