/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser;

import java.util.List;
import java.util.StringJoiner;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class R2LStructAssignmentPattern
extends RfNamedElement {
    private static final long serialVersionUID = 1L;
    private static final String VALUE_PLACEHOLDER = "tbd_val";
    private static final String ITALIC_VALUE_PLACEHOLDER = "<i>tbd_val</i>";
    private RfStruct assignedStruct;

    protected R2LStructAssignmentPattern(RfStruct struct) {
        super(struct.getName(), struct.isEscaped());
        this.assignedStruct = struct;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return String.valueOf(this.getName()) + ".\n" + "It works recursively for nested structs.\n";
    }

    @Override
    public String getComment() {
        return "You can expect something similar to this:\nmy_struct = '{\n&emsp;field1 : <i>tbd_val</i>,\n&emsp;field2 : <i>tbd_val</i>,\n&emsp;inner_struct : '{\n&emsp;&emsp;inner_field1 : <i>tbd_val</i>,\n&emsp;&emsp;inner_field2 : <i>tbd_val</i>\n&emsp;},\n&emsp;field3 : <i>tbd_val</i>\n};";
    }

    @Override
    public String getName() {
        return "Use assignment pattern";
    }

    public RfStruct getAssignedStruct() {
        return this.assignedStruct;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.ASSIGNMENT_PATTERN);
    }

    public static String computeStructFields(RfStruct struct, boolean useMultipleLines, String lineDelimiter) {
        StringJoiner resultJoiner = new StringJoiner(", " + (useMultipleLines ? lineDelimiter : ""));
        List<RfField> fields = struct.getFields();
        for (RfField field : fields) {
            IRfNamedElement associatedType = field.getAssociatedType();
            if (associatedType instanceof RfTypeAlias) {
                associatedType = ((RfTypeAlias)associatedType).getTranslatedType(RfTypesResolver.create(associatedType.getEnclosingScope(), field.getRfProject(), 8));
            }
            if (associatedType instanceof RfStruct && !((RfStruct)associatedType).isEnum()) {
                resultJoiner.add(String.valueOf(field.getName()) + " : " + R2LStructAssignmentPattern.computeStructFields((RfStruct)associatedType, useMultipleLines, lineDelimiter));
                continue;
            }
            resultJoiner.add(String.valueOf(field.getName()) + " : " + "${" + VALUE_PLACEHOLDER + "}");
        }
        return "'{" + (useMultipleLines ? lineDelimiter : "") + resultJoiner.toString() + (useMultipleLines ? lineDelimiter : "") + "}";
    }
}

