/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.r2lparser.R2LToken;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;

public class R2LTokenizer
implements TokenStream {
    private static final int MAX_INCLUDE_PATH_LENGTH = 2500;
    private static final int MAX_TOKEN_LENGTH = 20000;
    private static final int THREAD_YIELD_PERIOD_MS = 2000;
    private IDocumentExtension3 fDocument;
    private int fInitialOffset;
    private DVTCharacterScanner fScanner;
    private boolean fFirstToken = true;
    private Map<String, Integer> fTokensMap = new HashMap<String, Integer>();
    private RfProject fRfProject;
    private String fExpanded = "";
    private boolean fIsTooltip;
    private R2LTokenizer fExpandTokenizer;
    private R2LTokenizer fParentTokenizer;
    private boolean fDisableMacroExpansion;
    private boolean fIsMethodProposal;
    private boolean fIsClassOrPackage;
    private boolean fIsIdFollows;
    private boolean fIsParamFollows;
    private boolean fStopTokenizer;
    private int fPathTokenOffset;
    private boolean fIsColonAccess;
    private ParserPath fFile;
    private int fLine;
    private MacroScanner fMacroScanner;
    private IRfScope fInitialScope;

    public DVTCharacterScanner getfScanner() {
        return this.fScanner;
    }

    public R2LTokenizer(IRfScope initialScope, RfProject rfProject, ParserPath file, IDocument document, int offset, int line, boolean isTooltip) {
        this.fDocument = (IDocumentExtension3)document;
        this.fInitialScope = initialScope;
        this.fFile = file;
        this.fLine = line;
        this.fRfProject = rfProject;
        this.fIsTooltip = isTooltip;
        this.fStopTokenizer = false;
        this.fPathTokenOffset = -1;
        this.fInitialOffset = this.adjustTooltipOffset(document, isTooltip, offset);
        if (this.fInitialOffset < 0) {
            return;
        }
        this.fScanner = new DVTCharacterScanner(100, document, Math.max(0, this.fInitialOffset - 1), false);
        this.fTokensMap.put("event", 105);
        this.fTokensMap.put("class", 111);
        this.fTokensMap.put("extends", 112);
        this.fTokensMap.put("function", 116);
        this.fTokensMap.put("task", 116);
        this.fTokensMap.put("bind", 118);
        this.fTokensMap.put("import", 119);
        this.fTokensMap.put("export", 119);
        this.fTokensMap.put("inside", 121);
        this.fTokensMap.put("coverpoint", 123);
        this.fTokensMap.put("cross", 124);
        this.fTokensMap.put("`include", 114);
        this.fTokensMap.put("`ifdef", 115);
        this.fTokensMap.put("`ifndef", 115);
        this.fTokensMap.put("`elsif", 115);
        this.fTokensMap.put("`define", 115);
        this.fTokensMap.put("`undef", 115);
        this.fTokensMap.put("protected", 131);
        this.fTokensMap.put("static", 131);
        this.fTokensMap.put("local", 131);
        this.fTokensMap.put("virtual", 132);
        this.fTokensMap.put("typedef", 137);
        this.fTokensMap.put("return", 142);
        this.fTokensMap.put("module", 130);
        this.fTokensMap.put("interface", 130);
        this.fTokensMap.put("program", 130);
        this.fTokensMap.put("package", 130);
        this.fTokensMap.put("checker", 130);
        this.fTokensMap.put("clocking", 130);
        this.fTokensMap.put("covergroup", 130);
        this.fTokensMap.put("primitive", 130);
        this.fTokensMap.put("property", 130);
        this.fTokensMap.put("sequence", 130);
        this.fTokensMap.put("endfunction", 129);
        this.fTokensMap.put("endtask", 129);
        this.fTokensMap.put("endclass", 129);
        this.fTokensMap.put("endmodule", 129);
        this.fTokensMap.put("endinterface", 129);
        this.fTokensMap.put("endprogram", 129);
        this.fTokensMap.put("endpackage", 129);
        this.fTokensMap.put("endchecker", 129);
        this.fTokensMap.put("endclocking", 129);
        this.fTokensMap.put("endgroup", 129);
        this.fTokensMap.put("endprimitive", 129);
        this.fTokensMap.put("endproperty", 129);
        this.fTokensMap.put("endsequence", 129);
        this.fTokensMap.put("begin", 139);
        this.fTokensMap.put("end", 140);
        this.fTokensMap.put("library", 138);
        this.fTokensMap.put("design", 138);
        this.fTokensMap.put("liblist", 138);
        this.fTokensMap.put("always", 141);
        this.fTokensMap.put("always_ff", 141);
        this.fTokensMap.put("constraint", 143);
        this.fMacroScanner = new MacroScanner();
    }

    public ParserPath getFile() {
        return this.fFile;
    }

    public boolean isMethodProposal() {
        return this.fIsMethodProposal;
    }

    public boolean isClassOrPackage() {
        return this.fIsClassOrPackage;
    }

    public boolean isColonAccess() {
        return this.fIsColonAccess;
    }

    public boolean isIdFollows() {
        return this.fIsIdFollows;
    }

    public boolean isParamFollows() {
        return this.fIsParamFollows;
    }

    private int adjustTooltipOffset(IDocument document, boolean enableLeftScan, int offset) {
        boolean isEscaped;
        block16: {
            if (!enableLeftScan) {
                return offset;
            }
            isEscaped = false;
            this.fScanner = new DVTCharacterScanner(100, document, offset, true);
            if (this.fDocument.getDocumentPartitioner("__vlog_partitioning") == null) break block16;
            String content = this.fDocument.getContentType("__vlog_partitioning", this.fScanner.getOffset(), false);
            if (content.equals("__vlog_escaped_id")) {
                ITypedRegion region = this.fDocument.getPartition("__vlog_partitioning", this.fScanner.getOffset(), false);
                if (region != null) {
                    offset = region.getOffset() + region.getLength();
                }
                isEscaped = true;
                break block16;
            }
            if (content.equals("__dftl_partition_content_type")) break block16;
            this.fScanner = new DVTCharacterScanner(100, document, offset - 1, true);
            content = this.fDocument.getContentType("__vlog_partitioning", this.fScanner.getOffset(), false);
            if (content.equals("__dftl_partition_content_type") || content.equals("__vlog_escaped_id")) break block16;
            return -1;
        }
        try {
            int[] mark = new int[]{offset, -1};
            char ch = '0';
            while (!isEscaped) {
                mark = this.mark();
                ch = this.readChar();
                if (!Character.isJavaIdentifierPart(ch)) break;
            }
            while (Character.isWhitespace(ch) && ch != '\uffff') {
                ch = this.readChar();
            }
            if (ch == '(') {
                this.fIsMethodProposal = true;
                this.fIsClassOrPackage = false;
                this.fIsColonAccess = false;
            } else if (ch == ':') {
                this.fIsColonAccess = true;
                ch = this.readChar();
                if (ch == ':') {
                    this.fIsClassOrPackage = true;
                }
            } else if (Character.isJavaIdentifierStart(ch)) {
                this.fIsIdFollows = true;
            } else if (ch == '#') {
                this.fIsParamFollows = true;
            }
            return mark[0];
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return offset;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char readChar() {
        try {
            block7: {
                if (this.fScanner.getOffset() == 0 && this.fParentTokenizer != null) {
                    this.fParentTokenizer.fExpandTokenizer = null;
                    return this.fParentTokenizer.readChar();
                }
                if (this.fExpandTokenizer != null) {
                    return this.fExpandTokenizer.readChar();
                }
                while (this.fScanner.getOffset() > 0) {
                    String content;
                    if (this.fScanner.getOffset() > ((IDocument)this.fDocument).getLength()) {
                        return '\uffff';
                    }
                    if (this.fDocument.getDocumentPartitioner("__vlog_partitioning") != null && !(content = this.fDocument.getContentType("__vlog_partitioning", this.fScanner.getOffset() - 1, false)).equals("__dftl_partition_content_type") && !content.equals("__vlog_escaped_id")) {
                        this.fScanner.read();
                        continue;
                    }
                    break block7;
                }
                return '\uffff';
            }
            char ch = (char)this.fScanner.read();
            if (this.fPathTokenOffset < 0) return ch;
            if (this.fScanner.getOffset() - this.fPathTokenOffset <= 2500) return ch;
            return '\uffff';
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return '\uffff';
        }
    }

    public Token nextToken() throws TokenStreamException {
        if (this.fInitialOffset < 0) {
            return new R2LToken(-1, 1, "");
        }
        if (this.fExpandTokenizer != null) {
            Token result = this.fExpandTokenizer.nextToken();
            return result;
        }
        Token result = this.internalNextToken();
        this.fFirstToken = false;
        if (this.fStopTokenizer) {
            return new R2LToken(-1, 1, "");
        }
        if (result.getText() != null && result.getText().length() > 20000) {
            this.fStopTokenizer = true;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private Token internalNextToken() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int[] mark() {
        return new int[]{this.fScanner.getOffset(), this.fParentTokenizer == null ? -1 : this.fParentTokenizer.fScanner.getOffset()};
    }

    protected void rewind(int[] offset) {
        if (this.fParentTokenizer != null) {
            this.fParentTokenizer.rewind(new int[]{offset[1], -1});
        }
        if (offset[0] == -1) {
            offset[0] = this.fInitialOffset;
            this.fFirstToken = true;
        }
        this.fPathTokenOffset = -1;
        while (this.fScanner.getOffset() < offset[0]) {
            this.fScanner.unread();
        }
        if (this.fScanner.getOffset() == this.fInitialOffset) {
            this.fFirstToken = true;
        }
    }

    public void setPathTokenOffset() {
        this.fPathTokenOffset = this.fScanner.getOffset();
    }

    public void resetPathTokenOffset() {
        this.fPathTokenOffset = -1;
    }

    public int getUvmDoOffsetBoundary() {
        if (this.fInitialScope == null) {
            return -1;
        }
        if (this.fInitialScope instanceof RfFunctionDef) {
            return ((RfFunctionDef)this.fInitialScope).getStartOffset();
        }
        RfFunction enclosingFunction = (RfFunction)this.fInitialScope.getEnclosingScope(RfFunction.class);
        if (enclosingFunction == null) {
            return -1;
        }
        return enclosingFunction.getStartOffset();
    }
}

