/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser.contexts;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEUtils;
import ro.amiq.vlogdt.r2lparser.R2LManager;
import ro.amiq.vlogdt.r2lparser.R2LProposalManager;
import ro.amiq.vlogdt.r2lparser.R2LScopeContainer;
import ro.amiq.vlogdt.r2lparser.contexts.R2LAlwaysBlockContext;
import ro.amiq.vlogdt.r2lparser.contexts.R2LBaseContext;
import ro.amiq.vlogdt.r2lparser.contexts.R2LContext;
import ro.amiq.vlogdt.r2lparser.contexts.R2LExprInClassContext;
import ro.amiq.vlogdt.r2lparser.contexts.R2LFunctionInClassContext;
import ro.amiq.vlogdt.r2lparser.contexts.R2LUvmRegistrationContext;

public class R2LContextUtils {
    private static final List<Function<R2LBaseContext, ? extends R2LContext>> contextCheckers = new ArrayList<Function<R2LBaseContext, ? extends R2LContext>>();
    private static final Function<R2LBaseContext, ? extends R2LContext> classContextChecker = baseContext -> {
        IRfScopeElement scope = baseContext.initialScopeContainer.scope;
        if (!(scope instanceof IRfScope)) {
            return null;
        }
        RfNamedElement namedElement = ((IRfScope)scope).getNamedElement();
        if (namedElement == null) {
            return null;
        }
        if (!(namedElement instanceof RfClass)) {
            return null;
        }
        if (((RfClass)namedElement).isInterfaceClass()) {
            return null;
        }
        return new R2LExprInClassContext((R2LBaseContext)baseContext, (RfClass)namedElement);
    };
    private static final Function<R2LBaseContext, ? extends R2LContext> functionContextChecker = baseContext -> {
        IRfScopeElement scope = baseContext.initialScopeContainer.scope;
        while (scope != null) {
            if (!(scope instanceof IRfScope)) {
                return null;
            }
            RfNamedElement namedElement = ((IRfScope)scope).getNamedElement();
            if (namedElement == null) {
                return null;
            }
            if (namedElement instanceof RfFunction) {
                RfNamedElement enclosingClass = namedElement.getEnclosingScope().getNamedElement();
                if (!(enclosingClass instanceof RfClass)) {
                    return null;
                }
                return new R2LFunctionInClassContext((R2LBaseContext)baseContext, (RfFunction)namedElement);
            }
            scope = scope.getEnclosingScope();
        }
        return null;
    };
    private static final Function<R2LBaseContext, ? extends R2LContext> uvmRegistrationContextChecker = baseContext -> {
        IRfScopeElement scope = baseContext.initialScopeContainer.scope;
        while (scope != null) {
            if (!(scope instanceof IRfScope)) {
                return null;
            }
            RfNamedElement namedElement = ((IRfScope)scope).getNamedElement();
            if (namedElement instanceof RfClass && R2LContextUtils.isUvmRegistrationContext((RfClass)namedElement, baseContext.manager)) {
                return new R2LUvmRegistrationContext((R2LBaseContext)baseContext, (RfClass)namedElement);
            }
            scope = scope.getEnclosingScope();
        }
        return null;
    };
    private static final Function<R2LBaseContext, ? extends R2LContext> alwaysBlockContextChecker = baseContext -> {
        IRfScopeElement scope = baseContext.initialScopeContainer.scope;
        while (scope != null) {
            if (!(scope instanceof IRfScope)) {
                return null;
            }
            RfNamedElement namedElement = ((IRfScope)scope).getNamedElement();
            if (namedElement == null) {
                return null;
            }
            if (!(namedElement instanceof RfActionBlock)) {
                scope = scope.getEnclosingScope();
                continue;
            }
            RfActionBlock actionBlock = (RfActionBlock)namedElement;
            if (actionBlock.isAlways()) {
                return new R2LAlwaysBlockContext((R2LBaseContext)baseContext);
            }
            scope = scope.getEnclosingScope();
        }
        return null;
    };

    static {
        contextCheckers.add(uvmRegistrationContextChecker);
        contextCheckers.add(functionContextChecker);
        contextCheckers.add(alwaysBlockContextChecker);
        contextCheckers.add(classContextChecker);
    }

    public static R2LContext getContext(R2LManager manager, R2LScopeContainer initialScopeContainer, R2LScopeContainer rightScopeContainer, R2LScopeContainer leftScopeContainer, int walkerRule) {
        R2LBaseContext baseContext = new R2LBaseContext(manager, initialScopeContainer, rightScopeContainer, leftScopeContainer, walkerRule);
        if (!(manager instanceof R2LProposalManager)) {
            return baseContext;
        }
        for (Function<R2LBaseContext, ? extends R2LContext> contextChecker : contextCheckers) {
            R2LContext result = contextChecker.apply(baseContext);
            if (result == null) continue;
            return result;
        }
        return baseContext;
    }

    private static boolean isUvmRegistrationContext(RfClass clazz, R2LManager manager) {
        if (clazz == null || manager == null) {
            return false;
        }
        RfProject project = manager.getProject();
        RfFileDef fileDef = manager.getFileDef();
        IDocument document = manager.getDocument();
        int documentLine = manager.getDocumentLine();
        return FEUtils.isOvmUvmRegistrationArea(project, fileDef, document, clazz, 1, documentLine);
    }
}

