/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser.contexts;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.ClassModel;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FERegistrationArea;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FieldModel;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.XVMElementModel;
import ro.amiq.vlogdt.r2lparser.R2LFEAllFieldsAndClassProposal;
import ro.amiq.vlogdt.r2lparser.R2LFEBaseOperationProposal;
import ro.amiq.vlogdt.r2lparser.R2LFEClassProposal;
import ro.amiq.vlogdt.r2lparser.R2LProposalManager;
import ro.amiq.vlogdt.r2lparser.VlogR2LCompletionProposal;
import ro.amiq.vlogdt.r2lparser.contexts.R2LBaseContext;
import ro.amiq.vlogdt.r2lparser.contexts.R2LContext;

public class R2LExprInClassContext
extends R2LContext {
    private RfClass enclosingClass;

    public R2LExprInClassContext(R2LBaseContext baseContext, RfClass enclosingClass) {
        super(baseContext.manager, baseContext.initialScopeContainer, baseContext.rightScopeContainer, baseContext.leftScopeContainer, baseContext.walkerRule);
        this.enclosingClass = enclosingClass;
    }

    @Override
    public IRfNamedElement[] getProposals(int accessKind, String prefix, boolean isEvent, boolean isImply, boolean isEqual, boolean isArgument, boolean disableEnums, boolean isCoverpoint) {
        boolean hasPrefix;
        R2LProposalManager proposalManager = (R2LProposalManager)this.manager;
        List<VlogR2LCompletionProposal> proposals = proposalManager.getExprInClassContextCandidates(this.rightScopeContainer, this.leftScopeContainer, accessKind, prefix, isEvent, isImply, isEqual, isArgument, disableEnums, this.enclosingClass, this.walkerRule);
        IRfNamedElement[] sortedCandidates = proposalManager.relevanceBasedSortResult(proposals, prefix);
        sortedCandidates = this.addClassContextFEProposals(sortedCandidates, prefix, this.enclosingClass);
        sortedCandidates = proposalManager.addUvmOvmFieldEditorProposal(sortedCandidates);
        boolean bl = hasPrefix = prefix != null && !prefix.isEmpty();
        if (this.walkerRule == 100 || this.walkerRule == 165 && hasPrefix) {
            sortedCandidates = proposalManager.addWizardElements(sortedCandidates, prefix);
        }
        sortedCandidates = proposalManager.addNamespaceElements(sortedCandidates, this.rightScopeContainer, prefix);
        if (isEqual) {
            sortedCandidates = proposalManager.addStructAssignmentPatternProposal(sortedCandidates, this.leftScopeContainer, this.rightScopeContainer, prefix);
        }
        return sortedCandidates;
    }

    public IRfNamedElement[] addClassContextFEProposals(IRfNamedElement[] candidates, String prefix, RfClass enclosingClass) {
        R2LProposalManager proposalManager = (R2LProposalManager)this.manager;
        if (prefix != null && !prefix.isEmpty()) {
            return candidates;
        }
        FERegistrationArea regArea = proposalManager.computeRegistrationArea(enclosingClass);
        if (regArea == null) {
            return candidates;
        }
        ClassModel originalClassModel = regArea.getOriginalClassModel();
        if (originalClassModel == null || originalClassModel.isRegistered()) {
            return candidates;
        }
        ClassModel modifiedClassModel = originalClassModel.clone();
        modifiedClassModel.setRegistered(true);
        List<XVMElementModel> fieldModels = regArea.getOriginalModels();
        ArrayList<XVMElementModel> registeredFields = new ArrayList<XVMElementModel>();
        for (XVMElementModel model : fieldModels) {
            FieldModel fieldModel = (FieldModel)model;
            if (fieldModel.getStatus() != 0) continue;
            FieldModel clonedField = fieldModel.clone();
            clonedField.setRegistered(true);
            clonedField.setOperation(1, true);
            registeredFields.add(clonedField);
        }
        R2LFEBaseOperationProposal newCandidate = null;
        if (registeredFields.isEmpty()) {
            modifiedClassModel.makeSingleLineMacro();
            newCandidate = R2LFEClassProposal.createProposal(regArea, modifiedClassModel);
        } else {
            newCandidate = R2LFEAllFieldsAndClassProposal.createProposal(regArea, registeredFields, modifiedClassModel);
        }
        if (newCandidate == null) {
            return candidates;
        }
        IRfNamedElement[] newCandidates = new IRfNamedElement[candidates.length + 1];
        newCandidates[0] = newCandidate;
        System.arraycopy(candidates, 0, newCandidates, 1, candidates.length);
        return newCandidates;
    }
}

