/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser.strategies;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.r2lparser.strategies.DVTR2LBaseStrategy;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;

public class VlogR2LScopeStrategy
extends DVTR2LBaseStrategy {
    private IRfScopeElement scope;

    public VlogR2LScopeStrategy(IRfScopeElement scope) {
        this.scope = scope;
    }

    public int getRelevance(IRfNamedElement candidate) {
        if (this.scope == null) {
            return 0;
        }
        if (candidate.isPredefined()) {
            return 0;
        }
        DistanceToScope candidateScope = this.internalGetRelevantScope((IRfScopeElement)candidate, false);
        DistanceToScope proposalScope = this.internalGetRelevantScope(this.scope, true);
        if (candidateScope != null && proposalScope != null) {
            if (proposalScope.scope instanceof RfSpecializedClass && ((RfSpecializedClass)proposalScope.scope).getGenericClass().equals(candidateScope.scope) || candidateScope.scope.equals(proposalScope.scope)) {
                return 5 + candidateScope.distance;
            }
            if (this.isClassParent(candidateScope.scope, proposalScope.scope)) {
                return 5 + candidateScope.distance - 1;
            }
        }
        return 0;
    }

    private DistanceToScope internalGetRelevantScope(IRfScopeElement element, boolean checkSelfIsScopeLimit) {
        if (element == null) {
            return null;
        }
        int distance = 0;
        if (checkSelfIsScopeLimit && this.isScopeLimit(element)) {
            return new DistanceToScope(distance, element);
        }
        IRfScopeElement enclosingScope = element.getEnclosingScope();
        while (enclosingScope != null && !this.isScopeLimit(enclosingScope)) {
            enclosingScope = enclosingScope.getEnclosingScope();
            ++distance;
        }
        if (enclosingScope == null) {
            return null;
        }
        return new DistanceToScope(distance, enclosingScope);
    }

    private boolean isScopeLimit(IRfScopeElement element) {
        return element instanceof RfClass || element instanceof RfModule || element instanceof RfInterface || element instanceof RfPackage || element instanceof RfFunction && ((RfFunction)element).isLet();
    }

    private boolean isClassParent(IRfScopeElement candidateScope, IRfScopeElement proposalScope) {
        if (!(candidateScope instanceof RfClass) || !(proposalScope instanceof RfClass)) {
            return false;
        }
        RfClass candidateClass = (RfClass)candidateScope;
        RfClass proposalClass = (RfClass)proposalScope;
        RfClass parent = proposalClass.getParent();
        while (parent != null) {
            if (parent.getGenericClass() != null && parent.getGenericClass().equals(candidateClass)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static class DistanceToScope {
        int distance;
        IRfScopeElement scope;

        public DistanceToScope(int distance, IRfScopeElement scope) {
            this.distance = distance;
            this.scope = scope;
        }
    }
}

