/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.r2lparser.strategies;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.r2lparser.strategies.DVTR2LBaseStrategy;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SEvaluator;

public class VlogR2LTypeCompatibilityStrategy
extends DVTR2LBaseStrategy {
    private IRfNamedElement leftAssociatedType;
    private IRfNamedElement leftElement;
    private ParserPath parserPath;

    public VlogR2LTypeCompatibilityStrategy(IRfNamedElement leftAssociatedType, IRfNamedElement leftElement, ParserPath parserPath) {
        this.leftAssociatedType = leftAssociatedType;
        this.leftElement = leftElement;
        this.parserPath = parserPath;
    }

    public int getRelevance(IRfNamedElement candidate) {
        if (this.leftAssociatedType == null) {
            return 0;
        }
        if (this.leftElement instanceof RfFunction) {
            return 0;
        }
        if (!(candidate instanceof RfAssociatedType)) {
            if (this.isTypeCompatible(candidate)) {
                return 10;
            }
            return 0;
        }
        RfTypesResolver resolver = RfTypesResolver.create(candidate.getEnclosingScope(), candidate.getRfProject(), 14);
        IRfNamedElement candidateAssociatedType = ((RfAssociatedType)candidate).getAssociatedType(resolver);
        if (candidateAssociatedType instanceof RfTypeAlias) {
            candidateAssociatedType = ((RfTypeAlias)candidateAssociatedType).getTranslatedType(resolver);
        }
        if (candidateAssociatedType instanceof RfComputedListType) {
            candidateAssociatedType = new RfListType(((RfComputedListType)candidateAssociatedType).getName(), ((RfComputedListType)candidateAssociatedType).getDataType(), ((RfComputedListType)candidateAssociatedType).getOccurrence());
        }
        if (this.leftAssociatedType.equals(candidateAssociatedType)) {
            return 20;
        }
        if (this.isTypeCompatible(candidate)) {
            return 10;
        }
        return 0;
    }

    private boolean isTypeCompatible(IRfNamedElement candidate) {
        if (!(this.leftElement instanceof RfNamedElement) || !(candidate instanceof RfNamedElement)) {
            return false;
        }
        RfProject rfProject = ((RfNamedElement)candidate).getRfProject();
        if (rfProject == null) {
            rfProject = ((RfNamedElement)this.leftElement).getRfProject();
        }
        if (rfProject == null) {
            return false;
        }
        ConfigInfo configInfo = new ConfigInfo(false, rfProject, null, true, rfProject.getToolCompat());
        ISDataAbstract result = SEvaluator.INSTANCE.checkTypeCompatibility(this.leftElement, candidate, false, false, (IRfNamedElement)this.leftElement.getEnclosingScope(), configInfo);
        return SDataUtils.getUndefinedDataType((ISDataAbstract)result) == null;
    }
}

