/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramBatch;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableData;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.fsm.utils.FSMDiagramProcessors;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.specador.templates.IAlwaysBlockWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.specador.FSMRowWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public class AlwaysBlockWrapper
extends Wrapper
implements IAlwaysBlockWrapper {
    IRfActionBlockElement alwaysBlock;
    IRfFieldElement fsmVariable;
    IFSMModel fsmModel;

    AlwaysBlockWrapper(SpecadorModel model, IRfActionBlockElement namedElement, IRfFieldElement iRfFieldElement, IFSMModel ifsmModel) {
        super(model, (RfNamedElement)namedElement);
        this.alwaysBlock = namedElement;
        this.fsmVariable = iRfFieldElement;
        this.fsmModel = ifsmModel;
    }

    @Override
    public String getKind() {
        return "always-block";
    }

    public String getName() {
        if (!this.alwaysBlock.isAnonymous() && !this.alwaysBlock.getName().isEmpty()) {
            return String.valueOf(this.alwaysBlock.getName()) + " : ";
        }
        return "";
    }

    public String getType() {
        if (this.alwaysBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS)) {
            return IRfActionBlockElement.BlockQualifier.ALWAYS.name().toLowerCase();
        }
        if (this.alwaysBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB)) {
            return IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.name().toLowerCase();
        }
        if (this.alwaysBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_FF)) {
            return IRfActionBlockElement.BlockQualifier.ALWAYS_FF.name().toLowerCase();
        }
        if (this.alwaysBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH)) {
            return IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.name().toLowerCase();
        }
        return "";
    }

    public String getSensitivityList() {
        if (!this.alwaysBlock.isAlways()) {
            return "";
        }
        List sensitivityLists = this.alwaysBlock.getHidOperators(DesignUtils.EVENT_CONTROL_QUALIFIERS, false);
        if (sensitivityLists == null || sensitivityLists.isEmpty()) {
            return "";
        }
        StringBuilder signature = new StringBuilder();
        for (IHidOperator op : sensitivityLists) {
            signature.append(op.getLHValue().toString());
        }
        return signature.toString().replace(",", " or");
    }

    public boolean containsFSMDiagram() {
        return this.fsmVariable != null && this.getModel().getFSMDiagrams();
    }

    public Set<String> getCommonExpressions() {
        if (!this.getModel().getFSMFilterCommonExpressionsInConditions()) {
            return Collections.emptySet();
        }
        return FSMDiagramProcessors.computeCommonExpressions((FSMModel)((FSMModel)this.fsmModel), (DProgressMonitor)DProgressMonitor.wrap((IProgressMonitor)new NullProgressMonitor(), null, null));
    }

    public List<FSMRowWrapper> getRows() {
        FSMDiagramBatch fsmDiagramBatch = new FSMDiagramBatch((IRfNamedElement)this.fsmVariable, this.fsmVariable.getName(), (FSMModel)this.fsmModel, new FSMTransitionTableData(), FSMDiagramConfiguration.getPreferencesSpecador((SpecadorModel)this.getModel()));
        SpecadorSVGDiagramFactory.exportDiagram((DDiagram)fsmDiagramBatch, (String)"", (boolean)false, null);
        return fsmDiagramBatch.getFSMTransitionTable().getRows().stream().map(row -> new FSMRowWrapper(this.getModel(), this.alwaysBlock, (FSMTransitionTableRow)row)).collect(Collectors.toList());
    }

    public String getFSMDiagramVariableName() {
        return this.fsmVariable.getName();
    }

    public String getFSMDiagramName() {
        return SpecadorConstants.getMessage((String)SpecadorConstants.fsmDiagramFileName, (Object[])new Object[]{this.alwaysBlock.getEnclosingScope().getName(), this.fsmVariable.getName()});
    }

    @Override
    public String getFullPath() {
        return String.valueOf(super.getFullPath()) + "modules" + File.separator;
    }
}

