/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.specador.templates.IAssertWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.specador.Wrapper;

public class AssertWrapper
extends Wrapper
implements IAssertWrapper {
    RfAssertExpect assertElement;

    AssertWrapper(SpecadorModel model, RfAssertExpect element) {
        super(model, element);
        this.assertElement = element;
    }

    public String getLinkToRef() {
        return this.getLinkToRef(this.assertElement.getEnclosingScope(Stream.of(RfModule.class, RfClass.class, RfInterface.class).collect(Collectors.toSet())));
    }

    public boolean isConcurrentAssertion() {
        return this.assertElement.isConcurrentAssertionStatement();
    }

    public String getAssertionKind(boolean forAggregatedPage) {
        StringBuilder sb = new StringBuilder();
        if (!forAggregatedPage) {
            if (this.assertElement.isImmediate()) {
                sb.append("immediate ");
            } else if (this.assertElement.isDeferred()) {
                sb.append("deferred immediate ");
            } else if (this.assertElement.isConcurrentAssertionStatement()) {
                sb.append("concurent ");
            }
        }
        String signature = this.assertElement.getSignature();
        sb.append(signature.substring(0, signature.indexOf(" ")));
        return sb.toString();
    }

    public String getCompleteAssertionName() {
        StringBuilder name = new StringBuilder();
        String packageName = this.assertElement.getEnclosingScopeName(RfPackage.class);
        String enclosingScopeName = this.assertElement.getEnclosingScopeName(RfModule.class, RfInterface.class, RfClass.class);
        if (packageName.equals("")) {
            name.append(enclosingScopeName).append(".");
        } else {
            name.append(packageName).append("::").append(enclosingScopeName).append(".");
        }
        name.append(this.getAssertionName());
        return name.toString();
    }

    public String getAssertionName() {
        if (this.assertElement.isAnonymous()) {
            return "[anonymous]";
        }
        return this.assertElement.getName();
    }

    @Override
    public String getFullPath() {
        if (this.assertElement.getEnclosingScope() instanceof RfModule) {
            return String.valueOf(super.getFullPath()) + "modules" + File.separator;
        }
        if (this.assertElement.getEnclosingScope() instanceof RfInterface) {
            return String.valueOf(super.getFullPath()) + "interfaces" + File.separator;
        }
        return super.getFullPath();
    }

    public String getAssertionExpression() {
        return this.assertElement.getExpressionText();
    }
}

