/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHModel;
import ro.amiq.dvt.diagrams.ch.editor.actions.DCHFiltersDialogUtils;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldFactory;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IBitFieldWrapper;
import ro.amiq.dvt.specador.templates.IClassWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IStructWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.vlogdt.diagrams.chd.VlogCHModel;
import ro.amiq.vlogdt.diagrams.uml.model.VlogUMLModel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.specador.AssertWrapper;
import ro.amiq.vlogdt.specador.BitFieldWrapper;
import ro.amiq.vlogdt.specador.ConstraintWrapper;
import ro.amiq.vlogdt.specador.CoverGroupWrapper;
import ro.amiq.vlogdt.specador.FunctionWrapper;
import ro.amiq.vlogdt.specador.MemberWrapper;
import ro.amiq.vlogdt.specador.ParameterWrapper;
import ro.amiq.vlogdt.specador.TypeWrapper;
import ro.amiq.vlogdt.specador.TypedefWrapper;
import ro.amiq.vlogdt.specador.VariableWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public class ClassWrapper
extends Wrapper
implements IClassWrapper {
    RfClass clazz;
    protected static final String UVM_TEST = "uvm_test";
    private static final String PACKAGE_CLASS_SEPARATOR = " :: ";
    private static final String LINK_END = ">`";
    private static final String FILE_SEPARATOR = "/";
    private static final String LINK_START = " <../";
    private static final String BACK_ONE_LEVEL = "../";
    private static final String DOC_START = ":doc:`";

    ClassWrapper(SpecadorModel model, RfClass namedElement) {
        super(model, namedElement);
        this.clazz = namedElement;
    }

    public boolean isUvmTestClass() {
        return this.clazz.isUvmTestClass();
    }

    public String getFormatedName() {
        if (this.clazz == null) {
            return "";
        }
        return this.formatSpecialCharacters(this.clazz.getFullName());
    }

    public List<IFreeMarkerWrapper> getVariables() {
        LinkedList<IFreeMarkerWrapper> variables = new LinkedList<IFreeMarkerWrapper>();
        List<RfField> fields = this.clazz.getFields();
        if (fields == null) {
            return Collections.emptyList();
        }
        for (RfField rfField : fields) {
            if (rfField instanceof RfPort || rfField.isPredefined() || rfField.isFromEmbeddedCovergroupDef() || rfField.getDeclaration().hasNameInsideMacro() || LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)rfField)) continue;
            variables.add(new VariableWrapper(this.getModel(), rfField));
        }
        return variables;
    }

    public List<IFreeMarkerWrapper> getParameters() {
        List<RfField> parameters = this.clazz.getParametersWithPrefix("", 384, 2, 1);
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        return parameters.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).filter(p -> p.isRegularParameter()).map(p -> new ParameterWrapper(this.getModel(), (RfField)p)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getLocalparams() {
        List<RfField> parameters = this.clazz.getLocalParameters(384);
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        return parameters.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).filter(p -> p.isLocalParameter()).map(p -> new ParameterWrapper(this.getModel(), (RfField)p)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getConstructors() {
        List<RfFunction> constructors = this.clazz.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (constructors == null || constructors.isEmpty()) {
            return Collections.emptyList();
        }
        return constructors.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t) && !t.isPredefined()).map(c -> new FunctionWrapper(this.getModel(), (RfFunction)c)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getEvents() {
        List<RfField> events = this.clazz.getEvents();
        if (events == null || events.isEmpty()) {
            return Collections.emptyList();
        }
        return events.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t) && !t.isPredefined()).map(e -> new MemberWrapper(this.getModel(), (RfNamedElement)e)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getFunctions() {
        List<RfFunction> functions = this.clazz.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (functions == null || functions.isEmpty()) {
            return Collections.emptyList();
        }
        return functions.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2) && !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro()).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getTasks() {
        List<RfFunction> tasks = this.clazz.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (tasks == null || tasks.isEmpty()) {
            return Collections.emptyList();
        }
        return tasks.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t) && !t.isPredefined() && !t.getDeclaration().hasNameInsideMacro()).map(t -> new FunctionWrapper(this.getModel(), (RfFunction)t)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getPureTypeAliases() {
        return this.getTypedefAliases(Wrapper.TypedefKinds.TYPEDEF).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t) && !t.isPredefined() && !t.getDeclaration().hasNameInsideMacro()).map(t -> new TypedefWrapper(this.getModel(), (RfTypeAlias)t)).collect(Collectors.toList());
    }

    public List<IStructWrapper> getStructTypeAliases() {
        return this.getTypedefAliases(Wrapper.TypedefKinds.STRUCT).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t) && !t.isPredefined() && !t.getDeclaration().hasNameInsideMacro()).map(s -> new TypeWrapper(this.getModel(), (RfTypeAlias)s)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getEnumTypeAliases() {
        return this.getTypedefAliases(Wrapper.TypedefKinds.ENUM).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t) && !t.isPredefined() && !t.getDeclaration().hasNameInsideMacro()).map(e -> new TypeWrapper(this.getModel(), (RfTypeAlias)e)).collect(Collectors.toList());
    }

    private List<RfTypeAlias> getTypedefAliases(Wrapper.TypedefKinds wantedKind) {
        ArrayList<RfTypeAlias> result = new ArrayList<RfTypeAlias>();
        if (this.clazz == null || wantedKind == null) {
            return new ArrayList<RfTypeAlias>();
        }
        Collection<RfTypeAlias> typeAliases = this.clazz.getTypeAliases();
        if (typeAliases == null) {
            return new ArrayList<RfTypeAlias>();
        }
        typeAliases.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t) && !(t instanceof RfForwardTypedef) && wantedKind.equals((Object)this.getAliasKind((IRfNamedElement)t))).forEach(t -> {
            boolean bl = result.add((RfTypeAlias)t);
        });
        return result;
    }

    private Wrapper.TypedefKinds getAliasKind(IRfNamedElement namedElement) {
        if (namedElement instanceof RfTypeAlias) {
            namedElement = ((RfTypeAlias)namedElement).getTranslatedType();
        }
        if (!(namedElement instanceof RfStruct)) {
            return Wrapper.TypedefKinds.TYPEDEF;
        }
        if (((RfStruct)namedElement).isEnum()) {
            return Wrapper.TypedefKinds.ENUM;
        }
        if (((RfStruct)namedElement).isStruct() || ((RfStruct)namedElement).isUnion()) {
            return Wrapper.TypedefKinds.STRUCT;
        }
        return Wrapper.TypedefKinds.TYPEDEF;
    }

    public List<IFreeMarkerWrapper> getConstraints() {
        ArrayList<IFreeMarkerWrapper> result = new ArrayList<IFreeMarkerWrapper>();
        if (!(this.namedElement instanceof RfClass)) {
            return result;
        }
        List<RfConstraint> constraints = this.namedElement.getLocalMembers(RfConstraint.class);
        if (constraints == null || constraints.isEmpty()) {
            return result;
        }
        constraints.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).forEach(c -> {
            boolean bl = result.add(new ConstraintWrapper(this.getModel(), (RfConstraint)c));
        });
        result.sort(this.alphabeticComparator);
        return result;
    }

    public List<IFreeMarkerWrapper> getCoverGroups() {
        ArrayList<IFreeMarkerWrapper> result = new ArrayList<IFreeMarkerWrapper>();
        List<RfCovergroup> covergroups = this.namedElement.getLocalMembers(RfCovergroup.class);
        if (covergroups == null || covergroups.isEmpty()) {
            return result;
        }
        covergroups.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).forEach(c -> {
            boolean bl = result.add(new CoverGroupWrapper(this.getModel(), (RfCovergroup)c));
        });
        result.sort(this.alphabeticComparator);
        return result;
    }

    public List<IClassWrapper> getInnerClasses() {
        ArrayList<IClassWrapper> result = new ArrayList<IClassWrapper>();
        List<RfClass> classes = this.namedElement.getLocalMembers(RfClass.class);
        if (classes == null || classes.isEmpty()) {
            return result;
        }
        classes.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).forEach(c -> {
            boolean bl = result.add(new ClassWrapper(this.getModel(), (RfClass)c));
        });
        result.sort(this.alphabeticComparator);
        return result;
    }

    public List<String> getClassHierarchy(boolean isPreview) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.clazz.getParent() == null) {
            return result;
        }
        RfClass parent = this.clazz;
        ArrayList<RfClass> hierarchy = new ArrayList<RfClass>();
        hierarchy.add(parent);
        while (parent.getParent() != null) {
            if (hierarchy.contains(parent = parent.getParent())) break;
            hierarchy.add(parent);
        }
        StringBuilder computedPathToRoot = new StringBuilder(BACK_ONE_LEVEL);
        computedPathToRoot.append(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getPathToUpperMostClass((IRfNamedElement)this.clazz));
        if (!(this.clazz.getEnclosingScope() instanceof RfLibrary)) {
            computedPathToRoot.append(BACK_ONE_LEVEL);
        }
        for (RfClass rfClass : hierarchy) {
            if (rfClass.getEnclosingLibrary() == null) continue;
            RfPackage destinationPackage = rfClass.getEnclosingPackage();
            RfModule destinationModule = rfClass.getEnclosingScope(RfModule.class);
            String libraryName = rfClass.getEnclosingLibrary().getName();
            String libraryFileName = LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getLibraryName((IRfNamedElement)rfClass);
            StringBuilder sb = new StringBuilder();
            if (destinationModule != null) {
                String moduleName = destinationModule.getName();
                if (!this.getModel().getVlogLibrariesWithModules().contains(libraryName) || isPreview) {
                    sb.append(rfClass.getName());
                } else {
                    sb.append(DOC_START).append(rfClass.getName());
                    sb.append(LINK_START).append((CharSequence)computedPathToRoot).append(libraryFileName).append(FILE_SEPARATOR).append("modules").append(FILE_SEPARATOR).append(moduleName).append(FILE_SEPARATOR).append(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)rfClass, true)).append(LINK_END);
                }
            } else if (destinationPackage != null) {
                String packageName = rfClass.getEnclosingPackage().getName();
                if (!this.getModel().getVlogLibrariesWithPackages().containsKey(libraryName) || !((Set)this.getModel().getVlogLibrariesWithPackages().get(libraryName)).contains(packageName) || isPreview) {
                    sb.append(packageName).append(PACKAGE_CLASS_SEPARATOR).append(rfClass.getName());
                } else {
                    sb.append(DOC_START).append(packageName);
                    sb.append(LINK_START).append((CharSequence)computedPathToRoot).append(libraryFileName).append(FILE_SEPARATOR).append("packages").append(FILE_SEPARATOR).append(packageName).append(FILE_SEPARATOR).append("index").append(LINK_END);
                    sb.append(PACKAGE_CLASS_SEPARATOR).append(DOC_START).append(rfClass.getName());
                    sb.append(LINK_START).append((CharSequence)computedPathToRoot).append(libraryFileName).append(FILE_SEPARATOR).append("packages").append(FILE_SEPARATOR).append(packageName).append(FILE_SEPARATOR).append(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)rfClass, true)).append(LINK_END);
                }
            } else {
                sb.append(DOC_START).append(rfClass.getName());
                sb.append(LINK_START).append((CharSequence)computedPathToRoot).append(libraryFileName).append(FILE_SEPARATOR).append("classes").append(FILE_SEPARATOR).append(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)rfClass, true)).append(LINK_END);
            }
            result.add(0, sb.toString());
        }
        return result;
    }

    public List<IFreeMarkerWrapper> getInheritedVariables() {
        ArrayList<IFreeMarkerWrapper> result = new ArrayList<IFreeMarkerWrapper>();
        HashSet<String> collectedFieldNames = new HashSet<String>();
        RfClass parent = this.clazz;
        List<RfField> localFields = parent.getFields();
        if (localFields != null) {
            localFields.forEach(f2 -> {
                boolean bl = collectedFieldNames.add(f2.getName());
            });
        }
        while ((parent = parent.getParent()) != null) {
            List<RfField> fields = parent.getFields();
            if (fields == null || fields.isEmpty()) continue;
            for (RfField field : fields) {
                if (collectedFieldNames.contains(field.getName()) || field.getDeclaration().hasNameInsideMacro() || LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)field)) continue;
                collectedFieldNames.add(field.getName());
                result.add(new VariableWrapper(this.getModel(), field));
            }
        }
        return result;
    }

    public List<IFreeMarkerWrapper> getInheritedMisc(String type) {
        ArrayList<IFreeMarkerWrapper> result = new ArrayList<IFreeMarkerWrapper>();
        HashSet<String> collectedNames = new HashSet<String>();
        RfClass parent = this.clazz;
        List<RfFunction> localFunctions = null;
        if (type.equals("tasks")) {
            localFunctions = parent.getLocalTasks();
        } else if (type.equals("functions")) {
            localFunctions = parent.getLocalFunctions();
        }
        if (localFunctions != null) {
            for (RfFunction function : localFunctions) {
                collectedNames.add(function.getName());
            }
        }
        while ((parent = parent.getParent()) != null) {
            List<RfFunction> functions = null;
            if (type.equals("tasks")) {
                functions = parent.getLocalTasks();
            } else if (type.equals("functions")) {
                functions = parent.getLocalFunctions();
            }
            if (functions == null || functions.isEmpty()) continue;
            for (RfFunction function : functions) {
                if (collectedNames.contains(function.getName()) || function.getDeclaration().hasNameInsideMacro() || LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)function)) continue;
                collectedNames.add(function.getName());
                result.add(new FunctionWrapper(this.getModel(), function));
            }
        }
        return result;
    }

    public boolean generateComponentDiagram(File location, IProgressMonitor monitor, int depth) {
        if (!this.getModel().getUvmTestDiagram()) {
            return false;
        }
        RfXvmObject xvmObject = this.getObjectFromFactory(this.clazz);
        if (xvmObject == null) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"component", this.getName()}));
        monitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
        String svg = this.newUVMComponentDiagram(xvmObject, this.getModel().getProject(), "", true, LanguageKind.VLOG, depth);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)monitor, (int)0);
    }

    public RfXvmObject getObjectFromFactory(RfClass clazz) {
        RfXvmFactory factory = RfVHUtils.getXvmFactory(this.getModel().getProject());
        if (factory == null || factory.isEmpty()) {
            return null;
        }
        return factory.getRegisteredObject(clazz);
    }

    public String newUVMComponentDiagram(RfXvmObject element, IProject project, String fontsFilePath, boolean hasURLs, LanguageKind modelNature, int preferredDepth) {
        int diagramDepth = preferredDepth;
        if (preferredDepth < 1 || preferredDepth > 25) {
            diagramDepth = 25;
        }
        if (this.getModel().isForPDF()) {
            diagramDepth = 2;
        }
        DVTTreeElementWrapper wrapper = new DVTTreeElementWrapper((Object)element);
        wrapper.setProject(project);
        wrapper.setParent((IDVTElementWrapper)new DVTTreeElementWrapper((Object)TreePath.TOP_DUMMY_TREE_PATH));
        CHConfig config = new CHConfig(null, LanguageKind.VLOG);
        config = DCHFiltersDialogUtils.INSTANCE.getConfig(config, LanguageKind.VLOG, "Driver & Monitor (predefined)", "reducePorts\ncolor instances, types matching .*(driver|drv).* using lightgreen\ncolor instances, types matching .*(monitor|mon).* using lightskyblue", false, false);
        return SpecadorSVGDiagramFactory.exportDiagram((DDiagram)new CHDiagram2((IDVTElementWrapper)wrapper, project, (ICHModel)VlogCHModel.getInstance(), config, diagramDepth, true), (String)fontsFilePath, (boolean)hasURLs, (LanguageKind)modelNature);
    }

    public boolean generateUMLInheritanceDiagram(File location, IProgressMonitor monitor) {
        if (!this.clazz.hasChildren()) {
            return false;
        }
        ArrayList<RfNamedElement> elements = new ArrayList<RfNamedElement>();
        elements.add(this.namedElement);
        SpecadorModel model = this.getModel();
        if (model.getUMLClassInheritanceDiagram()) {
            UMLDiagramConfiguration config = UMLDiagramConfiguration.getSpecadorConfig((boolean)model.getOrthogonalClassDiagrams());
            VlogUMLModel umlModel = VlogUMLModel.createModel(config, model.getProject());
            umlModel.setDiagramKind(UMLModel.DiagramKind.INHERITANCE);
            if (!elements.isEmpty()) {
                umlModel.setRightTypes(elements);
                umlModel.publicAssociationsOnly = model.isPublicOnlyAPI();
                File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"uml", this.getName()}));
                monitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
                String svg = SpecadorSVGDiagramFactory.newUMLDiagram((String)this.getName(), (UMLModel)umlModel, (String)"", (boolean)true, (LanguageKind)LanguageKind.VLOG);
                location.mkdirs();
                return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)model, (File)file, (String)svg, (IProgressMonitor)monitor, (int)0);
            }
        }
        return false;
    }

    public boolean generateUMLCollaborationDiagram(File location, IProgressMonitor monitor) {
        List<RfField> fields = this.clazz.getFields();
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        boolean hasAssociations = false;
        for (RfField field : fields) {
            IRfNamedElement associatedType = field.getAssociatedType();
            if (field.isPrivate() || !(associatedType instanceof RfClass) || ((RfClass)associatedType).equals(this.clazz)) continue;
            hasAssociations = true;
        }
        if (!hasAssociations) {
            return false;
        }
        ArrayList<RfNamedElement> elements = new ArrayList<RfNamedElement>();
        elements.add(this.namedElement);
        SpecadorModel model = this.getModel();
        if (model.getUMLCollaborationDiagram()) {
            UMLDiagramConfiguration config = UMLDiagramConfiguration.getSpecadorCollaborationConfig((boolean)model.getOrthogonalClassDiagrams());
            VlogUMLModel umlModel = VlogUMLModel.createModel(config, model.getProject());
            umlModel.setDiagramKind(UMLModel.DiagramKind.COLLABORATION);
            if (!elements.isEmpty()) {
                umlModel.setRightTypes(elements);
                umlModel.publicAssociationsOnly = model.isPublicOnlyAPI();
                File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"collaboration", this.getName()}));
                monitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
                String svg = SpecadorSVGDiagramFactory.newUMLDiagram((String)this.getName(), (UMLModel)umlModel, (String)"", (boolean)true, (LanguageKind)LanguageKind.VLOG);
                location.mkdirs();
                return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)model, (File)file, (String)svg, (IProgressMonitor)monitor, (int)0);
            }
        }
        return false;
    }

    public boolean generateBitfieldDiagram(File location, IProgressMonitor monitor) {
        if (!this.getModel().getBitfieldDiagram()) {
            return false;
        }
        BitFieldModel model = BitFieldFactory.getModel((IRfNamedElement)this.clazz, null);
        if (model == null) {
            return false;
        }
        File file = new File(location, "bitfield_" + this.getName() + ".svg");
        monitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
        String svg = Wavedrom.getInstance().generateSpecadorBitfieldSVG(model);
        if (svg == null || svg.isEmpty()) {
            return false;
        }
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)monitor, (int)0);
    }

    public List<IBitFieldWrapper> getBitFields() {
        BitFieldModel bitfieldModel = BitFieldFactory.getModel((IRfNamedElement)this.namedElement, null);
        if (bitfieldModel == null) {
            return new ArrayList<IBitFieldWrapper>();
        }
        return bitfieldModel.getBitFields().stream().filter(b -> !b.getName().isEmpty()).map(b -> new BitFieldWrapper(this.getModel(), (BitField)b)).collect(Collectors.toList());
    }

    public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        this.addLinksToAPI(segments, insertions, this.getFunctions(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getTasks(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getEvents(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getConstructors(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getEnumTypeAliases(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getCoverGroups(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getStructTypeAliases(), codeLocation);
        List<IClassWrapper> innerClasses = this.getInnerClasses();
        this.addLinksToPage(segments, insertions, innerClasses, codeLocation);
        innerClasses.stream().forEach(cls -> cls.addLinks(segments, insertions, codeLocation));
    }

    public Object getEnclosingPackage() {
        return this.clazz.getEnclosingPackage();
    }

    public boolean isInnerClass() {
        return this.clazz.getEnclosingScope().getEnclosingScope(RfClass.class) != null;
    }

    public int getNumberOfClasses() {
        return LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getNumberOfClassesWithInner((IRfNamedElement)this.clazz);
    }

    @Override
    public String getFullPath() {
        if (this.clazz.getEnclosingPackage() != null) {
            return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.clazz.getEnclosingPackage().getName() + File.separator + LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)this.clazz, false) + File.separator;
        }
        if (this.clazz.getEnclosingScope(RfModule.class) != null) {
            return String.valueOf(super.getFullPath()) + "modules" + File.separator + this.clazz.getEnclosingScope(RfModule.class).getName() + File.separator + LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)this.clazz, false) + File.separator;
        }
        return String.valueOf(super.getFullPath()) + "classes" + File.separator + LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)this.clazz, false) + File.separator;
    }

    public List<IFreeMarkerWrapper> getAssertions() {
        return Arrays.asList(this.clazz.getRfProject().getAllAssertExpects()).stream().filter(a -> a.getEnclosingScope(RfClass.class) == this.clazz).map(a -> new AssertWrapper(this.getModel(), (RfAssertExpect)a)).collect(Collectors.toList());
    }
}

