/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IAssertWrapper;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.specador.templates.ISpecadorContributor;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.specador.AssertWrapper;
import ro.amiq.vlogdt.specador.ClassWrapper;
import ro.amiq.vlogdt.specador.CoverGroupWrapper;
import ro.amiq.vlogdt.specador.InstanceWrapper;
import ro.amiq.vlogdt.specador.InterfaceWrapper;
import ro.amiq.vlogdt.specador.LibraryWrapper;
import ro.amiq.vlogdt.specador.MacroWrapper;
import ro.amiq.vlogdt.specador.ModuleWrapper;
import ro.amiq.vlogdt.specador.SpecadorVlogLinkResolver;

public class Contributor
implements ISpecadorContributor {
    private SpecadorModel model;

    public List<ILibraryWrapper> getLibraries(SpecadorModel model) {
        if (!model.hasVlogNature()) {
            return Collections.emptyList();
        }
        return this.getLibraries(RfManager.getInstance().getRfProject(model.getProject()));
    }

    public List<ILibraryWrapper> getLibraries(RfMixedLangProject rfMixedLangProject) {
        RfProject project = (RfProject)rfMixedLangProject.getSingleLangProject(LanguageKind.VLOG.NATURE_ID);
        return this.getLibraries(project);
    }

    private List<ILibraryWrapper> getLibraries(RfProject project) {
        return project.getLibraries().stream().filter(l -> !l.getName().equals("non-top-files") && !this.shouldFilter((IRfNamedElement)l)).map(l -> new LibraryWrapper(this.getModel(), (RfNamedElement)l)).collect(Collectors.toList());
    }

    public List<ILibraryWrapper> getSelectedLibraries(SpecadorModel model) {
        if (!model.hasVlogNature() || !model.isExportVlogLibraries()) {
            return Collections.emptyList();
        }
        return this.getLibraries(model).stream().filter(lib -> model.getVlogSelectedLibraryNames().contains(lib.getName())).collect(Collectors.toList());
    }

    public List<String> getPackages(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        List<RfPackage> pkgs = rfProject.getAllPackages(false);
        ArrayList<String> pkgsNames = new ArrayList<String>();
        if (pkgs == null) {
            pkgsNames = new ArrayList();
        } else {
            for (RfPackage rfPackage : pkgs) {
                pkgsNames.add(rfPackage.getName());
            }
        }
        return pkgsNames;
    }

    private boolean isElementExported(RfNamedElement element, List<RfNamedElement> libraries, Set<String> librariesWithModules, Set<String> librariesWithInterfaces, Map<String, Set<String>> librariesWithPackages) {
        RfNamedElement scope = element;
        while (scope != null) {
            if (scope instanceof RfLibrary) {
                return libraries.contains(scope);
            }
            if (scope instanceof RfModule) {
                return librariesWithModules.contains(scope.getEnclosingLibrary().getName());
            }
            if (scope instanceof RfInterface) {
                return librariesWithInterfaces.contains(scope.getEnclosingLibrary().getName());
            }
            if (scope instanceof RfPackage) {
                return librariesWithPackages.containsKey(scope.getEnclosingLibrary().getName()) && librariesWithPackages.get(scope.getEnclosingLibrary().getName()).contains(scope.getName());
            }
            scope = scope.getEnclosingScope();
        }
        return false;
    }

    private boolean isMacroExported(VlogMacroInfo macro, List<RfNamedElement> libraries, Set<String> librariesWithModules, Set<String> librariesWithInterfaces, Map<String, Set<String>> librariesWithPackages) {
        if (macro.getFileInstance() == null) {
            return true;
        }
        return this.isElementExported(macro.getFileInstance().getSemanticScope(), libraries, librariesWithModules, librariesWithInterfaces, librariesWithPackages);
    }

    private List<IFreeMarkerWrapper> getAllMacros(SpecadorModel model, Predicate<VlogMacroInfo> checkMacroType) {
        IProject project = model.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        List selectedLibraries = this.getSelectedLibraries(model).stream().map(l -> (RfNamedElement)l.getNamedElement()).collect(Collectors.toList());
        Set librariesWithModules = model.getVlogLibrariesWithModules();
        Set librariesWithInterfaces = model.getVlogLibrariesWithInterfaces();
        Map librariesWithPackages = model.getVlogLibrariesWithPackages();
        HashSet uniqueMacros = new HashSet();
        return RfManager.getInstance().getRfProject(project).getAllMacros().stream().filter(m -> !this.shouldFilter((IRfNamedElement)m)).filter(m -> checkMacroType.test((VlogMacroInfo)m)).filter(m -> this.isMacroExported((VlogMacroInfo)m, selectedLibraries, librariesWithModules, librariesWithInterfaces, librariesWithPackages)).filter(m -> uniqueMacros.add(m.getName()) && !m.isPredefined()).map(m -> new MacroWrapper(this.getModel(), (VlogMacroInfo)m)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getDefinedControlDefines(SpecadorModel model) {
        if (!model.hasVlogNature() || !model.isExportVlogControlDefines()) {
            return Collections.emptyList();
        }
        return this.getAllMacros(model, m -> m.isDefinedConfigMacro());
    }

    public List<IFreeMarkerWrapper> getUndefinedControlDefines(SpecadorModel model) {
        if (!model.hasVlogNature() || !model.isExportVlogControlDefines()) {
            return Collections.emptyList();
        }
        return this.getAllMacros(model, m -> m.isUndefConfigMacro());
    }

    public List<IFreeMarkerWrapper> getDefines(SpecadorModel model) {
        if (!model.hasVlogNature() || !model.isExportVlogMacros()) {
            return Collections.emptyList();
        }
        return this.getAllMacros(model, m -> m.isReplacementMacro());
    }

    public List<IFreeMarkerWrapper> getIfndefGuards(SpecadorModel model) {
        if (!model.hasVlogNature() || !model.isExportVlogIfndefGuards()) {
            return Collections.emptyList();
        }
        return this.getAllMacros(model, m -> m.isIfndefGuard());
    }

    public List<IRfNamedElement> getVerificationTops(SpecadorModel model) {
        if (!model.hasVlogNature()) {
            return Collections.emptyList();
        }
        IProject project = model.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        RfXvmFactory factory = RfVHUtils.getXvmFactory(project);
        if (factory == null || factory.isEmpty()) {
            return Collections.emptyList();
        }
        Set<RfXvmObject> nonTopUnits = Collections.newSetFromMap(new IdentityHashMap());
        Set<RfXvmObject> candidates = Collections.newSetFromMap(new IdentityHashMap());
        candidates.addAll(factory.getObjects());
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        for (RfXvmObject cand : candidates) {
            for (RfXvmObjectInstance child : RfXvmFactory.getChildInstances(cand)) {
                RfXvmObject object = child.getObject();
                if (RfXvmBase.Type.TEST.equals((Object)RfXvmFactory.getObjectType(object)) || RfXvmBase.Type.ROOT.equals((Object)RfXvmFactory.getObjectType(object))) continue;
                nonTopUnits.add(object);
            }
        }
        for (RfXvmObject nonTop : nonTopUnits) {
            candidates.remove(nonTop);
        }
        ArrayList<IRfNamedElement> verificationTops = new ArrayList<IRfNamedElement>();
        for (RfXvmObject candidate : candidates) {
            RfClass clazz;
            if (!RfXvmBase.Type.TEST.equals((Object)RfXvmFactory.getObjectType(candidate)) && !RfXvmBase.Type.ROOT.equals((Object)RfXvmFactory.getObjectType(candidate)) || (clazz = candidate.getRfClass()) == null || !clazz.isSubClass("uvm_test", false) || "uvm_test".equals(clazz.getName()) || !this.getModel().getVlogSelectedLibraryNames().contains(clazz.getEnclosingLibrary().getName()) || clazz.getEnclosingPackage() != null && !this.getModel().getVlogSelectedPackageNames().contains(clazz.getEnclosingPackage().getName()) || this.shouldFilter(clazz)) continue;
            verificationTops.add(clazz);
        }
        return verificationTops;
    }

    public List<IAssertWrapper> getAssertions(IProject project) {
        if (project == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(RfManager.getInstance().getRfProject(project).getAllAssertExpects()).stream().map(a -> new AssertWrapper(this.getModel(), (RfAssertExpect)a)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getCovergroups(SpecadorModel model) {
        if (!model.hasVlogNature() || !model.isExportVlogCovergroups()) {
            return Collections.emptyList();
        }
        if (model.getProject() == null) {
            return Collections.emptyList();
        }
        List selectedLibraries = this.getSelectedLibraries(model).stream().map(l -> (RfNamedElement)l.getNamedElement()).collect(Collectors.toList());
        Set librariesWithModules = model.getVlogLibrariesWithModules();
        Set librariesWithInterfaces = model.getVlogLibrariesWithInterfaces();
        Map librariesWithPackages = model.getVlogLibrariesWithPackages();
        return Arrays.asList(RfManager.getInstance().getRfProject(model.getProject()).getAllCovergroups()).stream().filter(c -> c.getEnclosingScope() instanceof RfClass).filter(c -> !this.shouldFilter((IRfNamedElement)c)).filter(c -> this.isElementExported((RfNamedElement)c, selectedLibraries, librariesWithModules, librariesWithInterfaces, librariesWithPackages)).map(c -> new CoverGroupWrapper(this.getModel(), (RfCovergroup)c)).collect(Collectors.toList());
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public String getHyperlink(IRfNamedElement namedElement) {
        if (!(namedElement instanceof RfNamedElement)) {
            return "";
        }
        RfNamedElement element = (RfNamedElement)namedElement;
        if (this.shouldFilter(element)) {
            return "";
        }
        if (element instanceof RfGenerateBlock) {
            return "";
        }
        if (element == RfClass.CIRCULAR_INHERITANCE) {
            return "";
        }
        String link = SpecadorVlogLinkResolver.getInstance().getLinkToElement(element, ".html", "#");
        if (link.isEmpty()) {
            return "";
        }
        return link;
    }

    public String getDesignTopFile(IRfDesignElement top) {
        if (!(top instanceof RfModule)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("libraries").append(File.separator).append(this.getLibraryName((IRfNamedElement)top)).append(File.separator);
        result.append("modules").append(File.separator).append(top.getName());
        return result.toString();
    }

    public String getVerificationTopPath(IRfNamedElement element) {
        if (!(element instanceof RfClass)) {
            return "";
        }
        StringBuilder scopeName = new StringBuilder();
        scopeName.append("libraries/").append(String.valueOf(this.getLibraryName(element)) + "/");
        if (element.getEnclosingScope(RfModule.class) != null) {
            scopeName.append("modules/").append(((RfModule)element.getEnclosingScope(RfModule.class)).getName());
        } else if (element.getEnclosingScope(RfPackage.class) != null) {
            scopeName.append("packages/").append(((RfClass)element).getEnclosingPackage().getName());
        } else {
            scopeName.append("classes");
        }
        String classPath = this.getClassPath(element, false);
        if (!classPath.isEmpty()) {
            scopeName.append("/" + classPath);
        }
        return scopeName.toString();
    }

    public String getPathToUpperMostClass(IRfNamedElement element) {
        if (!(element instanceof RfClass)) {
            return "";
        }
        RfClass clazz = (RfClass)element;
        DVTStringBuilder pathToUpperMostClass = new DVTStringBuilder();
        clazz = clazz.getEnclosingScope().getEnclosingScope(RfClass.class);
        while (clazz != null) {
            pathToUpperMostClass.append("../");
            clazz = clazz.getEnclosingScope().getEnclosingScope(RfClass.class);
        }
        return pathToUpperMostClass.toString();
    }

    public String getClassPath(IRfNamedElement element, boolean includeClass) {
        if (!(element instanceof RfClass)) {
            return "";
        }
        DVTStringBuilder classPath = new DVTStringBuilder(includeClass ? element.getName() : "");
        RfClass clazz = ((RfClass)element).getEnclosingScope().getEnclosingScope(RfClass.class);
        while (clazz != null) {
            classPath.prepend(String.valueOf(clazz.getName()) + "/");
            clazz = clazz.getEnclosingScope().getEnclosingScope(RfClass.class);
        }
        String result = classPath.toString();
        if (!result.isEmpty() && !includeClass) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    public boolean isPublic(IRfNamedElement namedElement) {
        RfNamedElement element = (RfNamedElement)namedElement;
        if (element.getCommentBlock() != null && element.getCommentBlock().isProtected()) {
            return false;
        }
        return element.isPublic();
    }

    public boolean isFilteredByName(IRfNamedElement namedElement) {
        StringMatcher[] namePatterns = this.getModel().getNamePatterns();
        if (namePatterns == null) {
            return false;
        }
        RfNamedElement element = (RfNamedElement)namedElement;
        StringMatcher[] stringMatcherArray = namePatterns;
        int n = namePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            StringMatcher matcher = stringMatcherArray[n2];
            if (element instanceof VlogMacroInfo && (matcher.match("`" + element.getName()) || matcher.match("`" + element.getFullName()))) {
                return true;
            }
            if (matcher.match(element.getName()) || matcher.match(element.getFullName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getParserPath(IRfNamedElement namedElement) {
        if (!(namedElement instanceof VlogMacroInfo)) {
            return super.getParserPath(namedElement);
        }
        VlogMacroInfo macro = (VlogMacroInfo)namedElement;
        VlogFileInstance fileInstance = macro.getFileInstance();
        if (fileInstance == null || fileInstance.getParserPath() == null) {
            return "";
        }
        return fileInstance.getParserPath().path;
    }

    public IDesignInstanceWrapper getInstance(IRfDesignElement namedElement, ElementPath elementpath, String name) {
        return new InstanceWrapper(this.getModel(), namedElement, elementpath, name);
    }

    public String getKind(IRfNamedElement element) {
        return RfKind.of(element).getName().replace(" ", "-");
    }

    public String getFullNameLabel(IRfNamedElement element) {
        return Integer.toHexString(Objects.hashCode(((RfNamedElement)element).getFullName()));
    }

    public String getURL(IRfNamedElement element) {
        RfNamedElement namedElement = (RfNamedElement)element;
        SpecadorModel model = this.getModel();
        if (model == null) {
            return "";
        }
        StringBuilder url = new StringBuilder(File.separator);
        url.append(model.getOutputFolderName()).append(File.separator);
        url.append("libraries/").append(namedElement.getEnclosingLibrary().getName()).append(File.separator);
        if (namedElement instanceof RfModule) {
            url.append("modules/");
        } else if (namedElement instanceof RfInterface) {
            url.append("interfaces/");
        } else if (namedElement instanceof RfClass) {
            if (namedElement.getEnclosingPackage() != null) {
                url.append("packages/").append(namedElement.getEnclosingPackage().getName()).append("/");
            } else if (namedElement.getEnclosingScope(RfModule.class) != null) {
                url.append("modules/").append(namedElement.getEnclosingScope(RfModule.class).getName()).append("/");
            } else {
                url.append("classes/");
            }
            url.append(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)namedElement, false)).append("/");
        } else {
            return "";
        }
        return url.toString();
    }

    public IFreeMarkerWrapper getWrapper(IRfNamedElement namedElement) {
        if (namedElement instanceof RfClass) {
            return new ClassWrapper(this.getModel(), (RfClass)namedElement);
        }
        if (namedElement instanceof RfInterface) {
            return new InterfaceWrapper(this.getModel(), (RfInterface)namedElement);
        }
        if (namedElement instanceof RfModule) {
            return new ModuleWrapper(this.getModel(), (RfModule)namedElement);
        }
        return null;
    }

    public boolean isValidForHTMLPreview(IRfNamedElement namedElement) {
        return namedElement instanceof RfClass || namedElement instanceof RfInterface || namedElement instanceof RfModule;
    }

    public void addSpecadorPreviewListenerToBuildListeners() {
        BuildEventManager.getInstance().registerListener((IBuildEventManagerListener)SpecadorPreviewListener.INSTANCE);
    }

    public void removeSpecadorPreviewListenerFromBuildListeners() {
        BuildEventManager.getInstance().unregisterListener((IBuildEventManagerListener)SpecadorPreviewListener.INSTANCE);
    }

    public String getFullPath(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return "";
        }
        String file = SpecadorVlogLinkResolver.getInstance().getLinkToElement((RfNamedElement)element, ".rst", "#");
        if (file.isEmpty()) {
            return "";
        }
        if (file.contains("#")) {
            file = file.substring(0, file.indexOf("#"));
        }
        return String.valueOf(this.getModel().getLocation()) + File.separator + "source" + File.separator + file;
    }

    public String getLibraryName(IRfNamedElement element) {
        if (element.getEnclosingLibrary() == null) {
            return "work-sv";
        }
        return String.valueOf(element.getEnclosingLibrary().getName()) + "-sv";
    }

    public int getNumberOfClassesWithInner(IRfNamedElement element) {
        if (!(element instanceof RfClass)) {
            return 0;
        }
        RfClass clazz = (RfClass)element;
        List<RfClass> classes = clazz.getLocalMembers(RfClass.class);
        if (classes == null || classes.isEmpty()) {
            return 1;
        }
        return 1 + classes.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).mapToInt(c -> this.getNumberOfClassesWithInner((IRfNamedElement)c)).sum();
    }

    public SpecadorModel getModel() {
        return this.model;
    }

    public void setModel(SpecadorModel model) {
        SpecadorVlogLinkResolver.getInstance().setModel(model);
        this.model = model;
    }
}

