/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.specador.VariableWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public class CoverGroupWrapper
extends Wrapper {
    RfCovergroup coverGroup;

    CoverGroupWrapper(SpecadorModel model, RfCovergroup namedElement) {
        super(model, namedElement);
        this.coverGroup = namedElement;
    }

    public List<VariableWrapper> getCovergroupItems() {
        List<RfField> fields;
        ArrayList<VariableWrapper> result = new ArrayList<VariableWrapper>();
        List<RfCoverpoint> coverpoints = this.coverGroup.getLocalMembers(RfCoverpoint.class);
        if (coverpoints != null && !coverpoints.isEmpty()) {
            coverpoints.stream().filter(c -> !c.isPredefined()).collect(Collectors.toList()).forEach(coverpoint -> {
                boolean bl = result.add(new VariableWrapper(this.getModel(), (RfField)coverpoint));
            });
        }
        if ((fields = this.coverGroup.getFields()) != null && !fields.isEmpty()) {
            fields.forEach(field -> {
                boolean bl = result.add(new VariableWrapper(this.getModel(), (RfField)field));
            });
        }
        result.sort(this.alphabeticComparator);
        return result;
    }

    @Override
    public String getFullPath() {
        return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator;
    }

    public String getLinkToRef() {
        return this.getLinkToRef(this.coverGroup);
    }

    public String getFullyQualifiedName() {
        return this.coverGroup.getFullName();
    }
}

