/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.specador.FunctionWrapper;
import ro.amiq.vlogdt.specador.MemberWrapper;
import ro.amiq.vlogdt.specador.ParameterWrapper;
import ro.amiq.vlogdt.specador.PortWrapper;
import ro.amiq.vlogdt.specador.SpecadorVlogLinkResolver;
import ro.amiq.vlogdt.specador.VariableWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public abstract class DesignElementWrapper
extends Wrapper {
    RfInstanceHolder element;
    List<ELInstance> instances = new LinkedList<ELInstance>();

    DesignElementWrapper(SpecadorModel model, RfInstanceHolder namedElement) {
        super(model, namedElement);
        this.element = namedElement;
        this.instances = model.getElaboratedInstances((IRfNamedElement)namedElement);
    }

    public List<IFreeMarkerWrapper> getParameters() {
        List<RfField> parameters = this.element.getParametersWithPrefix("", 384, 2, 1);
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        return parameters.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).filter(p -> p.isRegularParameter()).map(p -> new ParameterWrapper(this.getModel(), (RfField)p)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getLocalparams() {
        List<RfField> parameters = this.element.getLocalParameters(384);
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        return parameters.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).filter(p -> p.isLocalParameter()).map(p -> new ParameterWrapper(this.getModel(), (RfField)p)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getPorts() {
        List<RfPort> ports = this.element.getPortsWithPrefix("", 2);
        if (ports == null || ports.isEmpty()) {
            return Collections.emptyList();
        }
        return ports.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(p -> new PortWrapper(this.getModel(), (RfPort)p)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getVariables() {
        LinkedList<IFreeMarkerWrapper> variables = new LinkedList<IFreeMarkerWrapper>();
        List<RfField> fields = this.element.getFields();
        if (fields == null) {
            return Collections.emptyList();
        }
        for (RfField rfField : fields) {
            if (rfField instanceof RfPort || LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)rfField)) continue;
            variables.add(new VariableWrapper(this.getModel(), rfField));
        }
        return variables;
    }

    public List<IFreeMarkerWrapper> getFunctions() {
        List<RfFunction> functions = this.element.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (functions == null || functions.isEmpty()) {
            return Collections.emptyList();
        }
        return functions.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getTasks() {
        List<RfFunction> tasks = this.element.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (tasks == null || tasks.isEmpty()) {
            return Collections.emptyList();
        }
        return tasks.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getClockingBlocks() {
        List<RfClockingBlock> clockingBlocks = this.element.getLocalMembers(RfClockingBlock.class);
        if (clockingBlocks == null || clockingBlocks.isEmpty()) {
            return Collections.emptyList();
        }
        return clockingBlocks.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new MemberWrapper(this.getModel(), (RfNamedElement)f2)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getEvents() {
        List<RfField> events = this.element.getEvents();
        if (events == null || events.isEmpty()) {
            return Collections.emptyList();
        }
        return events.stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new MemberWrapper(this.getModel(), (RfNamedElement)f2)).collect(Collectors.toList());
    }

    public Map<String, List<IDesignInstanceWrapper>> getInstances(List<IRfDesignElement> topDesigns) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getModel().getProject());
        if (elManager == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<IDesignInstanceWrapper>> result = new LinkedHashMap<String, List<IDesignInstanceWrapper>>();
        IELMemory memory = elManager.getMemory();
        for (ELInstance instance : this.instances) {
            String[] pathElements = instance.getHierarchyPath().toString().split("\\.");
            ElementPath elementPath = ElementPath.EMPTY_PATH;
            String[] stringArray = pathElements;
            int n = pathElements.length;
            int n2 = 0;
            while (n2 < n) {
                IRfNamedElement parent;
                ElementPath elaborationForm;
                IRfNamedElement binding;
                String pathElement = stringArray[n2];
                if (pathElement != null && !"$root".equals(pathElement) && (binding = memory.bindingFor(elaborationForm = (elementPath = ElementPath.join((ElementPath)elementPath, (String)pathElement)), false)) instanceof IRfDesignElement && (parent = memory.bindingFor(elementPath.removeLastSegment(), false)) instanceof IRfDesignElement) {
                    if (topDesigns.contains(parent)) {
                        result.put("top", new LinkedList());
                        ((List)result.get("top")).add(LanguageContributor.get((LanguageKind)parent.getLanguageKind()).getInstance((IRfDesignElement)parent, elaborationForm, elaborationForm.getName()));
                    }
                    if (!result.containsKey(SpecadorVlogLinkResolver.getInstance().getID(parent))) {
                        result.put(SpecadorVlogLinkResolver.getInstance().getID(parent), new LinkedList());
                    }
                    if (!(DesignUtils.isBlock((Object)binding) && ((List)result.get(SpecadorVlogLinkResolver.getInstance().getID(parent))).stream().anyMatch(ins -> ins.getName().equals(binding.getName())) || !((List)result.get(SpecadorVlogLinkResolver.getInstance().getID(parent))).stream().allMatch(el -> !el.getInstanceName().equals(elaborationForm.lastSegment())))) {
                        ((List)result.get(SpecadorVlogLinkResolver.getInstance().getID(parent))).add(LanguageContributor.get((LanguageKind)binding.getLanguageKind()).getInstance((IRfDesignElement)binding, elaborationForm, elaborationForm.getName()));
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        this.addLinksToAPI(segments, insertions, this.getFunctions(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getTasks(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getEvents(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getClockingBlocks(), codeLocation);
    }

    @Override
    public String getScopeName() {
        return "";
    }
}

