/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.specador.Wrapper;

public class FSMRowWrapper
extends Wrapper {
    FSMTransitionTableRow row;
    RfActionBlock alwaysBlock;

    FSMRowWrapper(SpecadorModel model, FSMTransitionTableRow row) {
        super(model, null);
        this.row = row;
    }

    FSMRowWrapper(SpecadorModel model, IRfActionBlockElement alwaysBlock, FSMTransitionTableRow row) {
        super(model, null);
        this.row = row;
        this.alwaysBlock = (RfActionBlock)alwaysBlock;
    }

    public int getTransitionIndex() {
        return this.row.getTransitionIndex();
    }

    public String getCurrentState() {
        if (this.getModel().isForPDF()) {
            return this.formatSpecialCharacters(this.row.getCurrentState().getNiceID());
        }
        return this.formatSpecialCharacters(this.row.getCurrentState().getNiceID().replace("`", "\\`"));
    }

    public String getNextState() {
        if (this.getModel().isForPDF()) {
            return this.formatSpecialCharacters(this.row.getNextState().getNiceID());
        }
        return this.formatSpecialCharacters(this.row.getNextState().getNiceID().replace("`", "\\`"));
    }

    public String getCondition() {
        if (this.getModel().isForPDF()) {
            return this.formatSpecialCharacters(this.row.getCondition().toString());
        }
        return this.formatSpecialCharacters(this.row.getCondition().toString().replace("`", "\\`"));
    }

    @Override
    public String getKind() {
        return "";
    }

    public String getDeclarationLine() {
        return this.getCommentLine();
    }

    public String getCommentLine() {
        Set markers = this.row.getTransition().getMarkers();
        if (!markers.isEmpty()) {
            return String.valueOf(((GoToInfo)markers.iterator().next()).line);
        }
        return "-1";
    }

    public List<SpecadorCommentWrapper> getTransitionComment() {
        Set markers = this.row.getTransition().getMarkers();
        RfFileDef fileDef = this.alwaysBlock.getFile();
        if (fileDef == null) {
            return Collections.emptyList();
        }
        return LanguageContributor.get((LanguageKind)this.alwaysBlock.getLanguageKind()).getTransitionComment(markers, fileDef.getParserPath(), this.alwaysBlock.getRfProject().getProject(), "__vlog_partitioning", "__vlog_sl_comment", "__vlog_ml_comment", (IFreeMarkerWrapper)this);
    }
}

