/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.specador.SpecadorVlogLinkResolver;
import ro.amiq.vlogdt.specador.Wrapper;

public class FieldWrapper
extends Wrapper {
    RfField element;

    public FieldWrapper(SpecadorModel model, RfField namedElement) {
        super(model, namedElement);
        this.element = namedElement;
    }

    public String getType() {
        if (this.isListType()) {
            DVTStringBuilder type = new DVTStringBuilder(((RfListType)this.element.getAssociatedType()).getDataType().getType());
            if (type.toString().equals("logic")) {
                type.prepend("wire ");
            }
            return type.toString();
        }
        if (this.isTypeAlias() || this.isClass()) {
            String[] netTypeAndType = DVTStringUtil.split((String)" ", (String)this.getTypeName());
            return netTypeAndType[0];
        }
        return "";
    }

    public String getTypeName() {
        return this.element.getAssociatedTypeName(true);
    }

    public boolean isListType() {
        return this.element.getAssociatedType() instanceof RfListType;
    }

    public boolean isUnpackedArrayType() {
        if (!this.isListType()) {
            return false;
        }
        IRfNamedElement associatedType = this.element.getAssociatedType();
        DataType dataType = ((RfListType)associatedType).getDataType();
        if (dataType == null) {
            return false;
        }
        List<IndexType> indexTypes = dataType.getUnpackedDimension();
        return indexTypes != null;
    }

    public boolean isTypeAlias() {
        return this.element.getAssociatedType() instanceof RfTypeAlias;
    }

    public boolean isTypeParameter() {
        return this.element.isTypeParameter();
    }

    public boolean isClass() {
        return this.element.getAssociatedType() instanceof RfClass && !this.element.getAssociatedType().isPredefined();
    }

    public boolean hasHyperlinks() {
        return this.isListType() || this.isTypeAlias() || this.isClass();
    }

    public String getNetType() {
        if (this.element.getDataType() != null && this.element.getDataType().getNetType() != null) {
            return this.element.getDataType().getNetType();
        }
        if (this.element.implicitSpecificNetType() != null) {
            return this.element.implicitSpecificNetType();
        }
        return "";
    }

    public String getSimpleTypeLink() {
        IRfNamedElement listType;
        RfTypeAlias typeAlias = null;
        IRfNamedElement associatedType = this.element.getAssociatedType(1);
        if (associatedType instanceof RfTypeAlias) {
            typeAlias = (RfTypeAlias)associatedType;
        } else if (associatedType instanceof RfListType && (listType = ((RfListType)associatedType).getAssociatedType()) instanceof RfTypeAlias) {
            typeAlias = (RfTypeAlias)listType;
        }
        return typeAlias != null ? SpecadorVlogLinkResolver.getInstance().getLinkToRef(typeAlias) : "";
    }

    public List<List<String>> getUnpackedTypeWithUrls() {
        ArrayList<List<String>> typesListWithUrls = new ArrayList<List<String>>();
        IRfNamedElement associatedType = this.element.getAssociatedType();
        if (associatedType instanceof RfListType) {
            DataType dataType = ((RfListType)associatedType).getDataType();
            if (dataType == null) {
                return typesListWithUrls;
            }
            List<IndexType> indexTypes = dataType.getUnpackedDimension();
            if (indexTypes == null) {
                return typesListWithUrls;
            }
            typesListWithUrls.addAll(this.getTypesFromIndex(indexTypes));
        }
        return typesListWithUrls;
    }

    public List<List<String>> getPackedTypeWithUrls() {
        ArrayList<List<String>> typesListWithUrls = new ArrayList<List<String>>();
        IRfNamedElement associatedType = this.element.getAssociatedType();
        if (associatedType instanceof RfListType) {
            DataType dataType = ((RfListType)associatedType).getDataType();
            if (dataType == null) {
                return typesListWithUrls;
            }
            List<IndexType> indexTypes = dataType.getPackedDimension();
            if (indexTypes == null) {
                return typesListWithUrls;
            }
            typesListWithUrls.addAll(this.getTypesFromIndex(indexTypes));
        }
        return typesListWithUrls;
    }

    private List<List<String>> getTypesFromIndex(List<IndexType> indexTypes) {
        LinkedList<List<String>> result = new LinkedList<List<String>>();
        for (IndexType indexType : indexTypes) {
            IHidObject type = indexType.getRangeObject();
            if (type == null) continue;
            ArrayList<String> typeUrls = new ArrayList<String>();
            if (type instanceof RfHidOperator) {
                typeUrls.addAll(this.getOperatorWithUrls((RfHidOperator)type));
            } else if (type instanceof RfHid) {
                typeUrls.add(this.formatSpecialCharacters(((RfHid)type).getName()));
                typeUrls.add(this.getUrlFromHid((Hid)type));
            } else {
                typeUrls.add(this.formatSpecialCharacters(type.toString()));
                typeUrls.add("");
            }
            result.add(typeUrls);
        }
        return result;
    }

    private List<String> getOperatorWithUrls(RfHidOperator operator) {
        ArrayList<String> operatorWithUrls = new ArrayList<String>();
        Set hids = HidUtils.flattenToHids((IHidObject)operator, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
        String operatorText = operator.toString().replace("[", "").replace("]", "");
        String[] splitOperatorText = DVTStringUtil.split((String)" ", (String)operatorText);
        int i = 0;
        while (i < splitOperatorText.length) {
            String element = splitOperatorText[i];
            String url = "";
            for (IHid hid : hids) {
                if (!(hid instanceof Hid) || !element.equals(hid.getName())) continue;
                url = this.getUrlFromHid((Hid)hid);
                break;
            }
            operatorWithUrls.add(this.formatSpecialCharacters(element));
            operatorWithUrls.add(url);
            ++i;
        }
        return operatorWithUrls;
    }

    private String getUrlFromHid(Hid hid) {
        if (!(hid instanceof RfHid)) {
            return "";
        }
        IRfNamedElement namedElement = ((RfHid)hid).getElement();
        if (!(namedElement instanceof RfNamedElement) || namedElement.isPredefined()) {
            return "";
        }
        String url = SpecadorVlogLinkResolver.getInstance().getID(namedElement);
        if (url == null) {
            return "";
        }
        return url;
    }
}

