/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.IRfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.specador.VariableWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public class FunctionWrapper
extends Wrapper {
    RfFunction function;

    FunctionWrapper(SpecadorModel model, RfFunction namedElement) {
        super(model, namedElement);
        this.function = namedElement;
    }

    public String getQualifiers() {
        StringBuilder result = new StringBuilder();
        boolean showAccessQualifiers = false;
        RfNamedElement enclosingScope = this.function.getEnclosingScope();
        if (enclosingScope instanceof RfClass) {
            showAccessQualifiers = true;
        }
        if (this.function.isExportDPI()) {
            result.append("export ");
        }
        if (this.function.isImportDPI()) {
            result.append("import ");
        }
        if (showAccessQualifiers) {
            if (this.function.isPrivate()) {
                result.append("local ");
            }
            if (this.function.isProtected()) {
                result.append("protected ");
            }
        }
        if (this.function.isConst()) {
            result.append("const ");
        }
        if (this.function.hasObjectStaticQualifier()) {
            result.append("static ");
        }
        if (this.function.hasObjectAutomaticQualifier()) {
            result.append("automatic ");
        }
        if (this.function.isVirtual()) {
            result.append("virtual ");
        }
        return result.toString() == null ? "" : result.toString();
    }

    public String getReturnTypeName() {
        block4: {
            try {
                if (!this.function.isConstructor() && !this.function.isTask()) break block4;
                return "";
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "";
            }
        }
        DVTStringBuilder returnTypeName = new DVTStringBuilder(this.function.getAssociatedTypeName(true));
        if (returnTypeName.toString().isEmpty() || returnTypeName.toString().startsWith("[")) {
            returnTypeName.prepend("logic");
        }
        return returnTypeName.toString();
    }

    public List<VariableWrapper> getFunctionArgumentsList() {
        ArrayList<VariableWrapper> result = new ArrayList<VariableWrapper>();
        List<RfField> arguments = this.function.getArgumentsWithPrefix("", 2);
        if (arguments == null || arguments.isEmpty()) {
            return result;
        }
        arguments.stream().forEach(a -> {
            boolean bl = result.add(new VariableWrapper(this.getModel(), (RfField)a));
        });
        return result;
    }

    public IRfNamedElement getReturnType() {
        IRfNamedElement type;
        block10: {
            block9: {
                try {
                    if (!this.function.isConstructor()) break block9;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            type = this.function.getAssociatedTypeInGenericScope();
            if (type != null) break block10;
            return null;
        }
        if (type instanceof RfModport) {
            return type;
        }
        if (type instanceof RfListType) {
            return ((RfListType)type).getAssociatedType();
        }
        if (type instanceof RfTypeAlias) {
            return type;
        }
        if (type instanceof IRfAssociatedType) {
            return ((IRfAssociatedType)type).getResolvedType(true);
        }
        if (type instanceof RfClass) {
            return type;
        }
        return null;
    }

    public String getLinkToReturnType() {
        return this.getLinkToRef(this.getReturnType());
    }

    public String getParentName() {
        return this.function.getEnclosingScope() == null ? "" : this.function.getEnclosingScope().getName();
    }

    public String getParentPackageName() {
        return this.function.getEnclosingPackage() == null ? "" : this.function.getEnclosingPackage().getName();
    }

    public String getLinkToParent() {
        if (this.function.getEnclosingScope() == null) {
            return "";
        }
        return this.getLinkToRef(this.function.getEnclosingScope());
    }

    public String getLinkToPackage() {
        if (this.function.getEnclosingPackage() == null) {
            return "";
        }
        return this.getLinkToRef(this.function.getEnclosingPackage());
    }

    public String getLinkToParentMethod() {
        return this.getLinkToRef(this.function);
    }

    public String getDocumentationLocation(File codeLocation) {
        String fileName = this.function.getEnclosingPackage() != null ? this.getPackageName() : this.getLibraryName();
        String documentationPath = SpecadorConstants.getMessage((String)SpecadorConstants.documentationLocation, (Object[])new Object[]{this.getFullPath(), fileName});
        StringBuilder link = new StringBuilder(codeLocation.toPath().relativize(Paths.get(documentationPath, new String[0])).toString());
        link.append("#").append(this.getID());
        return link.toString();
    }

    @Override
    public String getFullPath() {
        if (this.function.getEnclosingScope() instanceof RfModule) {
            return String.valueOf(super.getFullPath()) + "modules" + File.separator;
        }
        if (this.function.getEnclosingScope() instanceof RfInterface) {
            return String.valueOf(super.getFullPath()) + "interfaces" + File.separator;
        }
        if (this.function.getEnclosingScope() instanceof RfPackage) {
            return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator;
        }
        if (this.namedElement.getEnclosingScope() instanceof RfClass) {
            RfClass clazz = (RfClass)this.namedElement.getEnclosingScope();
            String classPath = LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)clazz, false);
            if (!classPath.isEmpty()) {
                classPath = String.valueOf(classPath) + File.separator;
            }
            if (clazz.getEnclosingScope(RfModule.class) != null) {
                return String.valueOf(super.getFullPath()) + "modules" + File.separator + classPath;
            }
            if (clazz.getEnclosingPackage() != null) {
                return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator + classPath;
            }
            return String.valueOf(super.getFullPath()) + "classes" + File.separator + classPath;
        }
        return super.getFullPath();
    }

    public List<String> getFunctionArguments() {
        return this.getFunctionArgumentsList().stream().map(argument -> argument.getName()).collect(Collectors.toList());
    }
}

