/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.specador.Wrapper;

public class InstanceWrapper
extends Wrapper
implements IDesignInstanceWrapper {
    IRfDesignElement designElement;
    ElementPath elementPath;
    String instanceName;

    public InstanceWrapper(SpecadorModel model, IRfDesignElement namedElement, ElementPath elementpath, String name) {
        super(model, (RfNamedElement)namedElement);
        this.designElement = namedElement;
        this.elementPath = elementpath;
        this.instanceName = name;
    }

    public String getInstanceName() {
        if (DesignUtils.isBlock((Object)this.designElement)) {
            return this.designElement.getName();
        }
        return this.instanceName;
    }

    public boolean hasHyperlink() {
        if (this.designElement instanceof RfInterface && !this.getModel().getVlogLibrariesWithInterfaces().contains(this.designElement.getEnclosingLibrary().getName())) {
            return false;
        }
        if (this.designElement instanceof RfModule && !this.getModel().getVlogLibrariesWithModules().contains(this.designElement.getEnclosingLibrary().getName())) {
            return false;
        }
        return !(this.designElement instanceof RfPrimitive) && !DesignUtils.isBlock((Object)this.designElement) && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)this.designElement);
    }

    public boolean isBlock() {
        return DesignUtils.isBlock((Object)this.designElement);
    }

    public String getName() {
        if (this.designElement instanceof RfPrimitive) {
            return "";
        }
        return super.getName();
    }

    public String getInstanceParams() {
        if (!this.getModel().isExportInstanceParameters()) {
            return "";
        }
        if (DesignUtils.isBlock((Object)this.designElement)) {
            return "";
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getModel().getProject());
        if (elManager == null) {
            return "";
        }
        ELInstance instanceFor = elManager.getMemory().instanceFor(this.elementPath.toElaborationForm());
        if (instanceFor == null) {
            return "";
        }
        ELParamValues paramValues = instanceFor.getParamValues();
        if (paramValues == null) {
            return "";
        }
        String documentationString = paramValues.toDocumentationString(false);
        if (documentationString.isEmpty()) {
            return "";
        }
        return "#(" + documentationString + ")";
    }

    public String getDocLocation() {
        if (this.designElement instanceof RfModule) {
            return "/libraries/" + this.getLibraryName() + "/modules/";
        }
        if (this.designElement instanceof RfInterface) {
            return "/libraries/" + this.getLibraryName() + "/interfaces/";
        }
        return "";
    }

    public String getExpression() {
        if (!this.isBlock()) {
            return "";
        }
        RfGenerateBlock block = (RfGenerateBlock)this.designElement;
        if (block.isIf() || block.isIfGenerate()) {
            return "";
        }
        return block.getExpression() == null ? "" : block.getExpression();
    }
}

