/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IInterfaceWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.specador.AssertWrapper;
import ro.amiq.vlogdt.specador.DesignElementWrapper;
import ro.amiq.vlogdt.specador.ModportWrapper;

public class InterfaceWrapper
extends DesignElementWrapper
implements IInterfaceWrapper {
    RfInterface iinterface;

    InterfaceWrapper(SpecadorModel model, RfInterface namedElement) {
        super(model, namedElement);
        this.iinterface = namedElement;
    }

    public List<IFreeMarkerWrapper> getModports() {
        List<RfModport> modports = this.iinterface.getLocalMembers(RfModport.class);
        if (modports == null || modports.isEmpty()) {
            return Collections.emptyList();
        }
        return modports.stream().filter(m -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)m)).map(m -> new ModportWrapper(this.getModel(), (RfModport)m)).collect(Collectors.toList());
    }

    public boolean generateBlockDiagram(File location, IProgressMonitor progressMonitor) {
        if (this.getPorts().isEmpty() && this.getParameters().isEmpty()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"block", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newBlockDiagram2((IRfNamedElement)this.iinterface, (String)"", (LanguageKind)LanguageKind.VLOG);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    @Override
    public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        super.addLinks(segments, insertions, codeLocation);
        this.addLinksToAPI(segments, insertions, this.getModports(), codeLocation);
    }

    @Override
    public String getFullPath() {
        return String.valueOf(super.getFullPath()) + "interfaces" + File.separator;
    }

    public List<IFreeMarkerWrapper> getAssertions() {
        return Arrays.asList(this.iinterface.getRfProject().getAllAssertExpects()).stream().filter(a -> a.getEnclosingScope(RfInterface.class) == this.iinterface).map(a -> new AssertWrapper(this.getModel(), (RfAssertExpect)a)).collect(Collectors.toList());
    }

    public List<ELInstance> getInstancesFromMemory() {
        return null;
    }

    public IRfDesignElement getDesignElement() {
        return null;
    }
}

