/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IClassWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IInterfaceWrapper;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.specador.templates.IModuleWrapper;
import ro.amiq.dvt.specador.templates.IPackageWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.specador.ClassWrapper;
import ro.amiq.vlogdt.specador.FunctionWrapper;
import ro.amiq.vlogdt.specador.InterfaceWrapper;
import ro.amiq.vlogdt.specador.MemberWrapper;
import ro.amiq.vlogdt.specador.ModuleWrapper;
import ro.amiq.vlogdt.specador.PackageWrapper;
import ro.amiq.vlogdt.specador.TypeWrapper;
import ro.amiq.vlogdt.specador.TypedefWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public class LibraryWrapper
extends Wrapper
implements ILibraryWrapper {
    RfLibrary library;

    LibraryWrapper(SpecadorModel model, RfNamedElement namedElement) {
        super(model, namedElement);
        this.library = (RfLibrary)namedElement;
    }

    public String getFileName() {
        return LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getLibraryName((IRfNamedElement)this.library);
    }

    public List<IClassWrapper> getClasses() {
        return this.library.getClassesWithPrefix("", 2, 1).stream().filter(c -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)c)).map(c -> new ClassWrapper(this.getModel(), (RfClass)c)).collect(Collectors.toList());
    }

    public List<IModuleWrapper> getModules(SpecadorModel model) {
        if (!model.hasVlogNature() || !model.getVlogLibrariesWithModules().contains(this.getName())) {
            return Collections.emptyList();
        }
        return this.library.getModulesWithPrefix("", 2, 1).stream().filter(m -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)m)).map(m -> new ModuleWrapper(this.getModel(), (RfModule)m)).collect(Collectors.toList());
    }

    public boolean hasModules(boolean hasVlogNature) {
        if (!hasVlogNature) {
            return false;
        }
        return !this.library.getModulesWithPrefix("", 2, 1).isEmpty();
    }

    public List<IInterfaceWrapper> getInterfaces(SpecadorModel model) {
        if (!model.hasVlogNature() || !model.getVlogLibrariesWithInterfaces().contains(this.getName())) {
            return Collections.emptyList();
        }
        return this.library.getInterfacesWithPrefix("", 2, 1).stream().filter(i -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)i)).map(i -> new InterfaceWrapper(this.getModel(), (RfInterface)i)).collect(Collectors.toList());
    }

    public boolean hasInterfaces(boolean hasVlogNature) {
        if (!hasVlogNature) {
            return false;
        }
        return !this.library.getInterfacesWithPrefix("", 2, 1).isEmpty();
    }

    public List<IPackageWrapper> getPackages(SpecadorModel model) {
        if (!model.hasVlogNature()) {
            return Collections.emptyList();
        }
        return this.library.getPackagesWithPrefix("", 2).stream().filter(p -> p.getEnclosingLibrary().getName().equals(this.library.getName()) && model.getVlogLibrariesWithPackages().containsKey(this.getName()) && ((Set)model.getVlogLibrariesWithPackages().get(this.getName())).contains(p.getName()) && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)p)).map(p -> new PackageWrapper(this.getModel(), (RfPackage)p)).collect(Collectors.toList());
    }

    public List<String> getPackageNames(boolean hasNature) {
        if (!hasNature) {
            return Collections.emptyList();
        }
        return this.library.getPackagesWithPrefix("", 2).stream().filter(p -> p.getEnclosingLibrary().getName().equals(this.library.getName()) && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)p)).map(p -> p.getName()).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getTypedefs() {
        List<IFreeMarkerWrapper> typedefs = this.library.getTypeAliasesWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).map(t -> new TypedefWrapper(this.getModel(), (RfTypeAlias)t)).filter(t -> !t.getAssociatedTypeSignature().contains(RfKind.STRUCT.getName()) && !t.getAssociatedTypeSignature().contains(RfKind.ENUM.getName()) && !t.getAssociatedTypeSignature().contains(RfKind.UNION.getName()) && !t.getAssociatedTypeSignature().contains(RfKind.CLASS.getName())).collect(Collectors.toList());
        typedefs.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return typedefs;
    }

    public List<IFreeMarkerWrapper> getEnums() {
        List<IFreeMarkerWrapper> enums = this.library.getTypeAliasesWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).map(e -> new TypeWrapper(this.getModel(), (RfTypeAlias)e)).filter(e -> e.getAssociatedTypeSignature().contains(RfKind.ENUM.getName())).collect(Collectors.toList());
        enums.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return enums;
    }

    public List<IFreeMarkerWrapper> getStructs() {
        List<IFreeMarkerWrapper> structs = this.library.getTypeAliasesWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).map(s -> new TypeWrapper(this.getModel(), (RfTypeAlias)s)).filter(s -> s.getAssociatedTypeSignature().contains(RfKind.STRUCT.getName()) || s.getAssociatedTypeSignature().contains(RfKind.UNION.getName())).collect(Collectors.toList());
        structs.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return structs;
    }

    public List<IFreeMarkerWrapper> getFunctions() {
        List<IFreeMarkerWrapper> functions = this.library.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(f2 -> !f2.isTask() && !f2.isDPI() && !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro() && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
        functions.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return functions;
    }

    public List<IFreeMarkerWrapper> getDPIExports() {
        List<IFreeMarkerWrapper> functions = this.library.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(f2 -> f2.isExportDPI() && !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro() && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
        functions.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return functions;
    }

    public List<IFreeMarkerWrapper> getDPIImports() {
        List<IFreeMarkerWrapper> functions = this.library.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(f2 -> f2.isImportDPI() && !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro() && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
        functions.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return functions;
    }

    public List<IFreeMarkerWrapper> getTasks() {
        List<IFreeMarkerWrapper> tasks = this.library.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(f2 -> !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro() && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
        tasks.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return tasks;
    }

    public List<IFreeMarkerWrapper> getEvents() {
        List<RfField> list = this.library.getEvents();
        if (list == null) {
            return Collections.emptyList();
        }
        List<IFreeMarkerWrapper> events = list.stream().filter(event -> event.getEnclosingPackage() == null && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)event)).map(e -> new MemberWrapper(this.getModel(), (RfNamedElement)e)).collect(Collectors.toList());
        events.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return events;
    }
}

