/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.specador.Wrapper;

public class MacroWrapper
extends Wrapper {
    private static final String IFNDEF_GUARD_MACRO = "ifndef";
    private static final String IFDEF_GUARD_MACRO = "ifdef";
    private static final String DEFINE_MACRO = "defined";
    VlogMacroInfo macro;

    MacroWrapper(SpecadorModel model, VlogMacroInfo namedElement) {
        super(model, namedElement);
        this.macro = namedElement;
    }

    public String getName() {
        return this.macro.getSignature().replace(">", "&gt;").replace("<", "&lt;").replace("`", "");
    }

    public String getType() {
        if (this.macro.isIfndefGuard()) {
            return IFNDEF_GUARD_MACRO;
        }
        if (this.macro.isUndefConfigMacro() || this.macro.isDefinedConfigMacro()) {
            return IFDEF_GUARD_MACRO;
        }
        return DEFINE_MACRO;
    }

    public String getValue() {
        String result;
        block5: {
            block4: {
                try {
                    if (this.getType().equals(DEFINE_MACRO)) break block4;
                    return "";
                }
                catch (VlogException vlogException) {
                    return "";
                }
            }
            result = this.macro.getReplacement(null, null);
            if (result != null && result.indexOf(10) == -1 && result.indexOf(13) == -1) break block5;
            return "";
        }
        return this.formatSpecialCharacters(result.replace("`", "")).replace("\"", "\\\"").replace("'", "\\'");
    }

    @Override
    public String getFullPath() {
        return String.valueOf(this.getModel().getLocation()) + File.separator + "source" + File.separator;
    }
}

