/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.specador.Wrapper;

public class MemberWrapper
extends Wrapper {
    MemberWrapper(SpecadorModel model, RfNamedElement namedElement) {
        super(model, namedElement);
    }

    @Override
    public String getFullPath() {
        if (this.namedElement.getEnclosingScope() instanceof RfModule) {
            return String.valueOf(super.getFullPath()) + "modules" + File.separator;
        }
        if (this.namedElement.getEnclosingScope() instanceof RfInterface) {
            return String.valueOf(super.getFullPath()) + "interfaces" + File.separator;
        }
        if (this.namedElement.getEnclosingScope() instanceof RfPackage) {
            return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator;
        }
        if (this.namedElement.getEnclosingScope() instanceof RfClass) {
            RfClass clazz = (RfClass)this.namedElement.getEnclosingScope();
            String classPath = LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)clazz, false);
            if (!classPath.isEmpty()) {
                classPath = String.valueOf(classPath) + File.separator;
            }
            if (clazz.getEnclosingScope(RfModule.class) != null) {
                return String.valueOf(super.getFullPath()) + "modules" + File.separator + classPath;
            }
            if (clazz.getEnclosingPackage() != null) {
                return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator + classPath;
            }
            return String.valueOf(super.getFullPath()) + "classes" + File.separator + classPath;
        }
        return super.getFullPath();
    }
}

