/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.netlist.utils.NLFilterSet;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.fsm.convert.FSMConverter;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IAlwaysBlockWrapper;
import ro.amiq.dvt.specador.templates.IClassWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IModuleWrapper;
import ro.amiq.dvt.specador.templates.IStructWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.specador.AlwaysBlockWrapper;
import ro.amiq.vlogdt.specador.AssertWrapper;
import ro.amiq.vlogdt.specador.ClassWrapper;
import ro.amiq.vlogdt.specador.DesignElementWrapper;
import ro.amiq.vlogdt.specador.TypeWrapper;
import ro.amiq.vlogdt.specador.TypedefWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public class ModuleWrapper
extends DesignElementWrapper
implements IModuleWrapper {
    RfModule module;

    public ModuleWrapper(SpecadorModel model, RfModule module) {
        super(model, module);
        this.module = module;
    }

    public List<IAlwaysBlockWrapper> getAlwaysBlocks() {
        ArrayList<IAlwaysBlockWrapper> result = new ArrayList<IAlwaysBlockWrapper>();
        Collection<? extends IRfActionBlockElement> blocks = this.module.getLocalActionBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return result;
        }
        int parallelism = 4;
        int timeout = 200;
        Map variablesWithModels = FSMConverter.convert((IRfNamedElement)this.module, (int)parallelism, (long)timeout, (IProgressMonitor)new NullProgressMonitor());
        for (IRfActionBlockElement iRfActionBlockElement : blocks) {
            if (!iRfActionBlockElement.isAlways()) continue;
            Map.Entry fsmData = LanguageContributor.get((LanguageKind)iRfActionBlockElement.getLanguageKind()).getFSMModelForBlock(iRfActionBlockElement, variablesWithModels);
            if (iRfActionBlockElement.isAnonymous() && !this.getModel().isExportUnnamedAlwaysBlocks() || iRfActionBlockElement.getComment().isEmpty() && fsmData == null) continue;
            if (fsmData != null) {
                result.add(new AlwaysBlockWrapper(this.getModel(), iRfActionBlockElement, (IRfFieldElement)fsmData.getKey(), (IFSMModel)fsmData.getValue()));
                continue;
            }
            result.add(new AlwaysBlockWrapper(this.getModel(), iRfActionBlockElement, null, null));
        }
        return result;
    }

    public List<IFreeMarkerWrapper> getTypeAliases() {
        return this.getAliasesByKind(Wrapper.TypedefKinds.TYPEDEF).stream().map(t -> new TypedefWrapper(this.getModel(), (RfTypeAlias)t)).collect(Collectors.toList());
    }

    public List<IStructWrapper> getStructTypeAliases() {
        return this.getAliasesByKind(Wrapper.TypedefKinds.STRUCT).stream().map(s -> new TypeWrapper(this.getModel(), (RfTypeAlias)s)).collect(Collectors.toList());
    }

    private List<RfTypeAlias> getAliasesByKind(Wrapper.TypedefKinds kind) {
        if (this.module == null || kind == null) {
            return new ArrayList<RfTypeAlias>();
        }
        Collection<RfTypeAlias> typeAliases = this.module.getTypeAliases();
        if (typeAliases == null) {
            return new ArrayList<RfTypeAlias>();
        }
        return typeAliases.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t) && !(t instanceof RfForwardTypedef) && kind.equals((Object)this.getAliasKind((IRfNamedElement)t)) && (!t.isPredefined() || t.getDeclaration().hasNameInsideMacro())).collect(Collectors.toList());
    }

    private Wrapper.TypedefKinds getAliasKind(IRfNamedElement namedElement) {
        if (namedElement instanceof RfTypeAlias) {
            namedElement = ((RfTypeAlias)namedElement).getTranslatedType();
        }
        if (!(namedElement instanceof RfStruct)) {
            return Wrapper.TypedefKinds.TYPEDEF;
        }
        if (((RfStruct)namedElement).isEnum()) {
            return Wrapper.TypedefKinds.ENUM;
        }
        if (((RfStruct)namedElement).isStruct() || ((RfStruct)namedElement).isUnion()) {
            return Wrapper.TypedefKinds.STRUCT;
        }
        return Wrapper.TypedefKinds.TYPEDEF;
    }

    @Override
    public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        super.addLinks(segments, insertions, codeLocation);
        this.addLinksToAlwaysBlocks(segments, insertions, this.getAlwaysBlocks(), codeLocation);
    }

    private void addLinksToAlwaysBlocks(List<String> segments, List<String> insertions, List<IAlwaysBlockWrapper> alwaysBlocks, File codeLocation) {
        block0: for (IFreeMarkerWrapper iFreeMarkerWrapper : alwaysBlocks) {
            int currentLength = 0;
            int startOffset = iFreeMarkerWrapper.getOffset();
            for (String segment : segments) {
                if (startOffset - currentLength > segment.length()) {
                    currentLength += segment.length();
                    continue;
                }
                int index = segments.indexOf(segment);
                segments.remove(index);
                segments.add(index, segment.substring(0, startOffset - currentLength));
                segments.add(index + 1, segment.substring(startOffset - currentLength));
                insertions.add(index, SpecadorConstants.getMessage((String)SpecadorConstants.linkToCodeWithAnchor, (Object[])new Object[]{this.getDocumentationLocation(codeLocation), SpecadorConstants.getMessage((String)SpecadorConstants.elementID, (Object[])new Object[]{"always-block", alwaysBlocks.indexOf(iFreeMarkerWrapper)})}));
                continue block0;
            }
        }
    }

    public boolean generateBlockDiagram(File location, IProgressMonitor progressMonitor) {
        if (this.getPorts().isEmpty() && this.getParameters().isEmpty()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"block", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newBlockDiagram2((IRfNamedElement)this.module, (String)"", (LanguageKind)LanguageKind.VLOG);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public boolean generateFlowDiagram(File location, IProgressMonitor progressMonitor, NLFilterSet filters) {
        if (!this.hasSubInstances()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"flow", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newFlowDiagram((IRfNamedElement)this.module, (String)"", (boolean)true, (LanguageKind)LanguageKind.VLOG, (NLFilterSet)filters);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public boolean generateSubInstancesDiagram(File location, IProgressMonitor progressMonitor, NLFilterSet filters) {
        if (!this.getModel().getDesignSubInstancesDiagram() || this.getModel().isForPDF()) {
            return false;
        }
        if (!this.hasSubInstances()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"subinstances", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newSubInstancesDiagram((IRfNamedElement)this.module, (String)"", (boolean)true, (LanguageKind)LanguageKind.VLOG, (NLFilterSet)filters);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public boolean generateSchematicDiagram(File location, IProgressMonitor progressMonitor, NLFilterSet filters) {
        if (!this.getModel().getDesignSchematicDiagram() || this.getModel().isForPDF()) {
            return false;
        }
        if (!this.hasSubInstances()) {
            return false;
        }
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"schematic", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newSchematicDiagram((IRfNamedElement)this.module, (String)"", (boolean)true, (LanguageKind)LanguageKind.VLOG, (NLFilterSet)filters);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public boolean isValidInstance(IRfNamedElement namedElement) {
        return namedElement instanceof IRfDesignElement && !DesignUtils.isBlock((Object)namedElement) && !(namedElement instanceof ErrorDesignElement) && !(namedElement instanceof RfPrimitive);
    }

    public void generateFSMDiagrams(File location, IProgressMonitor progressMonitor) {
        long startTime = System.nanoTime();
        Map newFSMDiagrams = SpecadorSVGDiagramFactory.newFSMDiagrams((IRfNamedElement)this.module, (String)"", (IProgressMonitor)new NullProgressMonitor(), (SpecadorModel)this.getModel());
        if (!this.getModel().isExportUnnamedAlwaysBlocks()) {
            List variableNames = this.getAlwaysBlocks().stream().filter(p -> p.containsFSMDiagram()).map(p -> p.getFSMDiagramVariableName()).collect(Collectors.toList());
            for (String FSMVariable : newFSMDiagrams.keySet()) {
                if (variableNames.contains(FSMVariable)) continue;
                newFSMDiagrams.remove(FSMVariable);
            }
        }
        if (newFSMDiagrams.entrySet().isEmpty()) {
            return;
        }
        location.mkdirs();
        long duration = (System.nanoTime() - startTime) / (long)newFSMDiagrams.entrySet().size();
        for (Map.Entry diagram : newFSMDiagrams.entrySet()) {
            String variableName = (String)diagram.getKey();
            String svgDiagram = (String)((DVTPair)diagram.getValue()).getKey();
            File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.fsmDiagramFileName, (Object[])new Object[]{this.getName(), variableName}));
            progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
            if (progressMonitor instanceof SpecadorProgressMonitor) {
                ((SpecadorProgressMonitor)progressMonitor).overwriteDuration(duration);
            }
            FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svgDiagram, (IProgressMonitor)progressMonitor, (int)0);
        }
    }

    @Override
    public String getFullPath() {
        return String.valueOf(super.getFullPath()) + "modules" + File.separator;
    }

    public List<IFreeMarkerWrapper> getAssertions() {
        return Arrays.asList(this.module.getRfProject().getAllAssertExpects()).stream().filter(a -> a.getEnclosingScope(RfModule.class) == this.module).map(a -> new AssertWrapper(this.getModel(), (RfAssertExpect)a)).collect(Collectors.toList());
    }

    private Stream<RfClass> getClassStream() {
        return this.module.getClassesWithPrefix("", 2, 1).stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2));
    }

    public List<IClassWrapper> getClasses() {
        List<IClassWrapper> classes = this.getClassStream().map(c -> new ClassWrapper(this.getModel(), (RfClass)c)).collect(Collectors.toList());
        classes.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return classes;
    }

    public int getNumberOfClasses() {
        return this.getClassStream().mapToInt(c -> LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getNumberOfClassesWithInner((IRfNamedElement)c)).sum();
    }

    public List<ELInstance> getInstancesFromMemory() {
        return this.instances;
    }

    public IRfDesignElement getDesignElement() {
        return this.module;
    }
}

