/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IClassWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IPackageWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.specador.ClassWrapper;
import ro.amiq.vlogdt.specador.FunctionWrapper;
import ro.amiq.vlogdt.specador.MemberWrapper;
import ro.amiq.vlogdt.specador.ParameterWrapper;
import ro.amiq.vlogdt.specador.TypeWrapper;
import ro.amiq.vlogdt.specador.TypedefWrapper;
import ro.amiq.vlogdt.specador.VariableWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public class PackageWrapper
extends Wrapper
implements IPackageWrapper {
    RfPackage pkg;

    PackageWrapper(SpecadorModel model, RfPackage namedElement) {
        super(model, namedElement);
        this.pkg = namedElement;
    }

    private Stream<RfClass> getClassStream() {
        return this.pkg.getClassesWithPrefix("", 2, 1).stream().filter(f2 -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2));
    }

    public List<IClassWrapper> getClasses() {
        List<IClassWrapper> classes = this.getClassStream().map(c -> new ClassWrapper(this.getModel(), (RfClass)c)).collect(Collectors.toList());
        classes.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return classes;
    }

    public List<IFreeMarkerWrapper> getTypedefs() {
        List<IFreeMarkerWrapper> typedefs = this.pkg.getTypeAliasesWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).map(t -> new TypedefWrapper(this.getModel(), (RfTypeAlias)t)).filter(t -> !t.getAssociatedTypeSignature().contains(RfKind.STRUCT.getName()) && !t.getAssociatedTypeSignature().contains(RfKind.ENUM.getName()) && !t.getAssociatedTypeSignature().contains(RfKind.UNION.getName()) && !t.getAssociatedTypeSignature().contains(RfKind.CLASS.getName())).collect(Collectors.toList());
        typedefs.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return typedefs;
    }

    public List<IFreeMarkerWrapper> getEnums() {
        List<IFreeMarkerWrapper> enums = this.pkg.getTypeAliasesWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).map(e -> new TypeWrapper(this.getModel(), (RfTypeAlias)e)).filter(e -> e.getAssociatedTypeSignature().contains(RfKind.ENUM.getName())).collect(Collectors.toList());
        enums.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return enums;
    }

    public List<IFreeMarkerWrapper> getParameters() {
        List<RfField> parameters = this.pkg.getParametersWithPrefix("", 384, 2, 1);
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        return parameters.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).filter(p -> p.isRegularParameter()).map(p -> new ParameterWrapper(this.getModel(), (RfField)p)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getLocalParameters() {
        List<RfField> parameters = this.pkg.getLocalParameters(384);
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        return parameters.stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).filter(p -> p.isLocalParameter()).map(p -> new ParameterWrapper(this.getModel(), (RfField)p)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getStructs() {
        List<IFreeMarkerWrapper> structs = this.pkg.getTypeAliasesWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(t -> !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)t)).map(s -> new TypeWrapper(this.getModel(), (RfTypeAlias)s)).filter(s -> s.getAssociatedTypeSignature().contains(RfKind.STRUCT.getName()) || s.getAssociatedTypeSignature().contains(RfKind.UNION.getName())).collect(Collectors.toList());
        structs.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return structs;
    }

    public List<IFreeMarkerWrapper> getFunctions() {
        List<IFreeMarkerWrapper> functions = this.pkg.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(f2 -> !f2.isTask() && !f2.isDPI() && !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro() && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
        functions.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return functions;
    }

    public List<IFreeMarkerWrapper> getDPIExports() {
        List<IFreeMarkerWrapper> functions = this.pkg.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(f2 -> f2.isExportDPI() && !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro() && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
        functions.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return functions;
    }

    public List<IFreeMarkerWrapper> getDPIImports() {
        List<IFreeMarkerWrapper> functions = this.pkg.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(f2 -> f2.isImportDPI() && !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro() && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
        functions.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return functions;
    }

    public List<IFreeMarkerWrapper> getTasks() {
        List<IFreeMarkerWrapper> tasks = this.pkg.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE).stream().filter(f2 -> !f2.isPredefined() && !f2.getDeclaration().hasNameInsideMacro() && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)f2)).map(f2 -> new FunctionWrapper(this.getModel(), (RfFunction)f2)).collect(Collectors.toList());
        tasks.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return tasks;
    }

    public List<IFreeMarkerWrapper> getEvents() {
        List<RfField> list = this.pkg.getEvents();
        if (list == null) {
            return Collections.emptyList();
        }
        List<IFreeMarkerWrapper> events = list.stream().filter(event -> event.getEnclosingPackage() == null && !LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)event)).map(e -> new MemberWrapper(this.getModel(), (RfNamedElement)e)).collect(Collectors.toList());
        events.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        return events;
    }

    public List<IFreeMarkerWrapper> getVariables() {
        LinkedList<IFreeMarkerWrapper> variables = new LinkedList<IFreeMarkerWrapper>();
        List<RfField> fields = this.pkg.getFields();
        if (fields == null) {
            return Collections.emptyList();
        }
        for (RfField rfField : fields) {
            if (rfField instanceof RfPort || LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)rfField)) continue;
            variables.add(new VariableWrapper(this.getModel(), rfField));
        }
        return variables;
    }

    public int getNumberOfClasses() {
        return this.getClassStream().mapToInt(c -> LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getNumberOfClassesWithInner((IRfNamedElement)c)).sum();
    }

    @Override
    public String getFullPath() {
        return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator;
    }

    public String getDocumentationName() {
        return "index";
    }

    public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        this.addLinksToAPI(segments, insertions, this.getFunctions(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getTasks(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getEvents(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getEnums(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getTypedefs(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getStructs(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getDPIExports(), codeLocation);
        this.addLinksToAPI(segments, insertions, this.getDPIImports(), codeLocation);
        List<IClassWrapper> classes = this.getClasses();
        this.addLinksToPage(segments, insertions, classes, codeLocation);
        classes.stream().forEach(cls -> cls.addLinks(segments, insertions, codeLocation));
    }
}

