/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.specador.FieldWrapper;

public class ParameterWrapper
extends FieldWrapper {
    RfField parameter;

    ParameterWrapper(SpecadorModel model, RfField namedElement) {
        super(model, namedElement);
        this.parameter = namedElement;
    }

    public String getValue() {
        String initialValue = this.parameter.getInitialValue(true);
        if (initialValue == null) {
            return "";
        }
        return this.formatSpecialCharacters(initialValue).replace("\"", "\\\"").replace("'", "\\'");
    }

    public List<SpecadorCommentWrapper> getComment() {
        if (!this.getModel().isForPDF()) {
            return super.getComment();
        }
        LinkedList<SpecadorCommentWrapper> comment = new LinkedList<SpecadorCommentWrapper>();
        CommentBlock commentBlock = this.namedElement.getCommentBlock();
        if (commentBlock == null) {
            return Collections.emptyList();
        }
        if (commentBlock.getRawUntrimmedAboveComment() != null) {
            comment.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.NONE, this.clearComment(commentBlock.getRawUntrimmedAboveComment(), commentBlock.getAboveCommentStyle()), DVTComment.CommentFormat.OLD_VERBATIM, this.getDeclarationLine(), this.getDeclarationLine()));
        }
        if (commentBlock.getRawUntrimmedInlineComment() != null) {
            comment.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.NONE, this.clearComment(commentBlock.getRawUntrimmedInlineComment(), commentBlock.getInlineCommentStyle()), DVTComment.CommentFormat.OLD_VERBATIM, this.getDeclarationLine(), this.getDeclarationLine()));
        }
        return comment;
    }

    @Override
    public String getNetType() {
        if (this.isTypeAlias()) {
            return "";
        }
        return super.getNetType();
    }

    @Override
    public String getFullPath() {
        if (this.namedElement.getEnclosingScope() instanceof RfModule) {
            return String.valueOf(super.getFullPath()) + "modules" + File.separator;
        }
        if (this.namedElement.getEnclosingScope() instanceof RfInterface) {
            return String.valueOf(super.getFullPath()) + "interfaces" + File.separator;
        }
        return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator;
    }
}

