/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.specador.FieldWrapper;

public class PortWrapper
extends FieldWrapper {
    public PortWrapper(SpecadorModel model, RfPort port) {
        super(model, port);
    }

    public String getDirection() {
        return this.formatSpecialCharacters(this.element.getDirectionString().replace("interface", "inout"));
    }

    public String getAssociatedTypeName() {
        DVTStringBuilder portTypeName = new DVTStringBuilder(this.element.getAssociatedTypeName(true));
        if (portTypeName.toString().isEmpty() || portTypeName.toString().endsWith(" ")) {
            portTypeName.append("logic");
        }
        if (this.element.getDataType() != null && this.element.getDataType().getNetType() != null) {
            return this.formatSpecialCharacters(portTypeName.toString());
        }
        if (this.element.implicitSpecificNetType() != null && !this.element.implicitSpecificNetType().isEmpty()) {
            portTypeName.prepend(" ").prepend(this.element.implicitSpecificNetType());
        }
        return this.formatSpecialCharacters(portTypeName.toString());
    }

    @Override
    public String getType() {
        if (this.isListType()) {
            return ((RfListType)this.element.getAssociatedType()).getDataType().getType();
        }
        if (this.isTypeAlias()) {
            String[] netTypeAndType = DVTStringUtil.split((String)" ", (String)this.getTypeName());
            return netTypeAndType[0];
        }
        return "";
    }

    public List<SpecadorCommentWrapper> getComment() {
        if (!this.getModel().isForPDF()) {
            return super.getComment();
        }
        LinkedList<SpecadorCommentWrapper> comment = new LinkedList<SpecadorCommentWrapper>();
        CommentBlock commentBlock = this.namedElement.getCommentBlock();
        if (commentBlock == null) {
            return Collections.emptyList();
        }
        if (commentBlock.getRawUntrimmedAboveComment() != null) {
            comment.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.NONE, this.clearComment(commentBlock.getRawUntrimmedAboveComment(), commentBlock.getAboveCommentStyle()), DVTComment.CommentFormat.OLD_VERBATIM, this.getDeclarationLine(), this.getDeclarationLine()));
        }
        if (commentBlock.getRawUntrimmedInlineComment() != null) {
            comment.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.NONE, this.clearComment(commentBlock.getRawUntrimmedInlineComment(), commentBlock.getInlineCommentStyle()), DVTComment.CommentFormat.OLD_VERBATIM, this.getDeclarationLine(), this.getDeclarationLine()));
        }
        return comment;
    }

    @Override
    public String getFullPath() {
        if (this.namedElement.getEnclosingScope() instanceof RfModule) {
            return String.valueOf(super.getFullPath()) + "modules" + File.separator;
        }
        return String.valueOf(super.getFullPath()) + "interfaces" + File.separator;
    }
}

