/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.fsm.convert.FSMConverter;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedPackage;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.utils.VlogLinkResolver;

public class SpecadorVlogLinkResolver
extends VlogLinkResolver {
    private static SpecadorVlogLinkResolver instance;
    private SpecadorModel model;

    public static SpecadorVlogLinkResolver getInstance() {
        if (instance == null) {
            instance = new SpecadorVlogLinkResolver();
        }
        return instance;
    }

    public void setModel(SpecadorModel model) {
        this.model = model;
    }

    public String linkInternalDocumentation(IRfNamedElement element, String linkElementName, String label, ITextEditor editor) {
        Collection<IRfNamedElement> candidates;
        Object[] parsedLink;
        int indexOfPackageDelimiter;
        boolean isAbsolutePath = false;
        String packageName = "";
        String originalLinkElementName = label;
        if (linkElementName.contains("#")) {
            linkElementName = linkElementName.substring(0, linkElementName.indexOf("#")).trim();
        }
        if ((indexOfPackageDelimiter = linkElementName.indexOf("::")) > 0 && !(packageName = linkElementName.substring(0, indexOfPackageDelimiter)).isEmpty() && !packageName.contains(".")) {
            linkElementName = linkElementName.substring(indexOfPackageDelimiter + 2);
            isAbsolutePath = true;
        }
        if (CommentUtils.getInstance().containsUnpermittedPatterns(linkElementName)) {
            return "";
        }
        boolean startsLikeAMacro = linkElementName.contains("`");
        if (startsLikeAMacro) {
            linkElementName = linkElementName.substring(1);
        }
        if ((parsedLink = DVTStringUtil.split((Pattern)CommentConstants.LINK_SPLIT_PATTERN, (String)DVTStringUtil.unescapeXMLString((String)linkElementName, (boolean)true))).length == 0 || startsLikeAMacro && parsedLink.length > 1) {
            return "";
        }
        parsedLink = CommentUtils.getInstance().cleanArray((String[])parsedLink);
        Collection<IRfNamedElement> collection = candidates = isAbsolutePath ? this.getPackageCandidates(packageName, this.model.getProject()) : this.getInitialCandidates(element, null);
        if ((candidates == null || candidates.isEmpty()) && isAbsolutePath) {
            candidates = this.getInitialCandidates(element, null);
            parsedLink = (String[])ArrayUtils.add((Object[])parsedLink, (int)0, (Object)packageName);
            isAbsolutePath = false;
        }
        if (candidates == null) {
            candidates = new ArrayList<IRfNamedElement>();
        }
        if (!isAbsolutePath) {
            candidates.add(element);
        }
        try {
            IRfNamedElement foundElement = this.solveHyperlinkForAllCandidates(element, candidates, (String[])parsedLink, System.currentTimeMillis() + 500L);
            if (foundElement != null) {
                return this.createLinkToElement(element, foundElement, originalLinkElementName);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (linkElementName.endsWith("s")) {
            return this.linkInternalDocumentation(element, linkElementName.substring(0, linkElementName.length() - 1), originalLinkElementName, editor);
        }
        return "";
    }

    protected String createLinkToElement(IRfNamedElement commentOrigin, IRfNamedElement element, String elementName) {
        if (!(element instanceof RfNamedElement) || !this.isDocumented((RfNamedElement)element)) {
            return elementName;
        }
        if (this.model.isForPDF()) {
            return "[" + elementName.replace("_", "\\\\_") + "](" + this.getID(element) + ")";
        }
        String extension = ".html";
        String anchor = "#";
        if (element instanceof VlogMacroInfo) {
            return CommentUtils.getInstance().wrapIntoA("index-macros" + extension, elementName, true);
        }
        String link = this.getLinkToElement((RfNamedElement)element, extension, anchor);
        if (link.isEmpty()) {
            return "";
        }
        return CommentUtils.getInstance().wrapIntoA(link, elementName, true);
    }

    public String getKind(IRfNamedElement element) {
        return LanguageContributor.get((LanguageKind)element.getLanguageKind()).getKind(element);
    }

    public String getFullNameLabel(IRfNamedElement element) {
        return LanguageContributor.get((LanguageKind)element.getLanguageKind()).getFullNameLabel(element);
    }

    public String getID(IRfNamedElement element) {
        return SpecadorConstants.getMessage((String)SpecadorConstants.elementID, (Object[])new Object[]{this.getKind(element), this.getFullNameLabel(element)});
    }

    public String getLinkToRef(IRfNamedElement type) {
        if (type == null || type.isPredefined() || type.getEnclosingScope() instanceof RfPredefinedPackage || !this.isDocumented((RfNamedElement)type)) {
            return "";
        }
        if (type instanceof RfListType) {
            type = ((RfListType)type).getResolvedType(true);
        }
        if (type instanceof RfListType) {
            return "";
        }
        if (type == null || type.isPredefined() || !this.isDocumented((RfNamedElement)type)) {
            return "";
        }
        return this.getID(type);
    }

    private String getLinkToType(RfNamedElement element, String extension, String anchor) {
        if (element == null || element.isPredefined() || !this.isDocumented(element)) {
            return "";
        }
        if (element instanceof RfAssociatedType && !(element instanceof RfTypeAlias)) {
            IRfNamedElement resolvedType = ((RfAssociatedType)element).getResolvedType(true);
            if (!(resolvedType instanceof RfNamedElement)) {
                return "";
            }
            element = (RfNamedElement)resolvedType;
        }
        if (element.isPredefined() || element.getEnclosingLibrary() == null) {
            return "";
        }
        String libraryFolder = "libraries/" + LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getLibraryName((IRfNamedElement)element) + "/";
        RfNamedElement scope = element;
        if (scope instanceof RfTypeAlias) {
            scope = scope.getEnclosingScope();
        }
        if (scope instanceof RfModule) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "modules", String.valueOf(scope.getName()) + extension, anchor, this.getID(element)});
        }
        if (scope instanceof RfInterface) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "interfaces", String.valueOf(scope.getName()) + extension, anchor, this.getID(element)});
        }
        if (scope instanceof RfPackage) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "packages", String.valueOf(scope.getName()) + "/" + scope.getName() + extension, anchor, this.getID(element)});
        }
        RfPackage enclosingPackage = element.getEnclosingPackage();
        RfModule enclosingModule = element.getEnclosingScope(RfModule.class);
        if (scope instanceof RfClass) {
            if (enclosingPackage != null) {
                return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "packages/" + enclosingPackage.getName(), String.valueOf(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)scope, true)) + extension, anchor, this.getID(element)});
            }
            if (enclosingModule != null) {
                return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "modules/" + enclosingModule.getName(), String.valueOf(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)scope, true)) + extension, anchor, this.getID(element)});
            }
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "classes", String.valueOf(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)scope, true)) + extension, anchor, this.getID(element)});
        }
        if (scope instanceof RfLibrary) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{libraryFolder, String.valueOf(scope.getName()) + extension, anchor, this.getID(element)});
        }
        return "";
    }

    private String getAlwaysBlockID(IRfActionBlockElement alwaysBlock) {
        RfModule module = (RfModule)alwaysBlock.getEnclosingScope();
        Collection<? extends IRfActionBlockElement> blocks = module.getLocalActionBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return "";
        }
        int index = 0;
        int parallelism = 4;
        int timeout = 200;
        Map variablesWithModels = FSMConverter.convert((IRfNamedElement)module, (int)parallelism, (long)timeout, (IProgressMonitor)new NullProgressMonitor());
        for (IRfActionBlockElement iRfActionBlockElement : blocks) {
            if (!iRfActionBlockElement.isAlways()) continue;
            Map.Entry fsmData = LanguageContributor.get((LanguageKind)alwaysBlock.getLanguageKind()).getFSMModelForBlock(iRfActionBlockElement, variablesWithModels);
            if (iRfActionBlockElement.getComment().isEmpty() && fsmData == null) continue;
            if (iRfActionBlockElement.equals(alwaysBlock)) {
                return "always-block-" + index;
            }
            ++index;
        }
        return "";
    }

    public String getLinkToElement(RfNamedElement element, String extension, String anchor) {
        String scopeName;
        String link = this.getLinkToType(element, extension, anchor);
        if (!(link.isEmpty() || element instanceof RfFunction || element instanceof RfField)) {
            return link;
        }
        String libraryFolder = "libraries/" + LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getLibraryName((IRfNamedElement)element);
        DVTStringBuilder classPath = new DVTStringBuilder();
        RfNamedElement scope = element.getEnclosingScope();
        if (scope instanceof RfClass) {
            classPath.append(LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)scope, true));
            if (classPath.length() > 0) {
                classPath.prepend("/");
            }
            scope = scope.getEnclosingPackage() != null ? scope.getEnclosingPackage() : (scope.getEnclosingScope(RfModule.class) != null ? (RfNamedElement)scope.getEnclosingScope(RfModule.class) : (scope.getEnclosingScope(RfInterface.class) != null ? (RfNamedElement)scope.getEnclosingScope(RfInterface.class) : scope.getEnclosingLibrary()));
        }
        String string = scopeName = scope instanceof RfLibrary ? LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getLibraryName((IRfNamedElement)element) : scope.getName();
        if (scope instanceof RfModule) {
            if (element instanceof IRfActionBlockElement && ((IRfActionBlockElement)element).isAlways()) {
                return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "/modules", String.valueOf(scopeName) + classPath + extension, anchor, this.getAlwaysBlockID((IRfActionBlockElement)element)});
            }
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "/modules", String.valueOf(scopeName) + classPath + extension, anchor, this.getID(element)});
        }
        if (scope instanceof RfInterface) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "/interfaces", String.valueOf(scopeName) + classPath + extension, anchor, this.getID(element)});
        }
        if (scope instanceof RfPackage) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{String.valueOf(libraryFolder) + "/packages", String.valueOf(scopeName) + (classPath.toString().isEmpty() ? "/" + scopeName : classPath) + extension, anchor, this.getID(element)});
        }
        if (scope instanceof RfLibrary) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{libraryFolder, String.valueOf(element.getEnclosingScope() instanceof RfClass ? "classes" + classPath : scopeName) + extension, anchor, this.getID(element)});
        }
        return "";
    }

    private boolean isDocumented(RfNamedElement element) {
        String enclosingLibraryName;
        if (LanguageContributor.get((LanguageKind)LanguageKind.VLOG).shouldFilter((IRfNamedElement)element)) {
            return false;
        }
        if (element instanceof VlogMacroInfo) {
            VlogMacroInfo macro = (VlogMacroInfo)element;
            if (macro.isUndefConfigMacro() || macro.isDefinedConfigMacro()) {
                return this.model.isExportVlogControlDefines();
            }
            if (macro.isIfndefGuard()) {
                return this.model.isExportVlogIfndefGuards();
            }
            return this.model.isExportVlogMacros();
        }
        String string = enclosingLibraryName = element.getEnclosingLibrary() == null ? "work" : element.getEnclosingLibrary().getName();
        if (!this.model.isExportVlogLibraries() || !this.model.getVlogSelectedLibraryNames().contains(enclosingLibraryName)) {
            return false;
        }
        if (element instanceof RfModule || element.getEnclosingScope() instanceof RfModule) {
            return this.model.getVlogLibrariesWithModules().contains(enclosingLibraryName);
        }
        if (element instanceof RfInterface || element.getEnclosingScope() instanceof RfInterface) {
            return this.model.getVlogLibrariesWithInterfaces().contains(enclosingLibraryName);
        }
        RfPackage pkg = element.getEnclosingPackage();
        if (pkg != null && !pkg.getName().isEmpty()) {
            return this.model.getVlogLibrariesWithPackages().containsKey(enclosingLibraryName) && ((Set)this.model.getVlogLibrariesWithPackages().get(enclosingLibraryName)).contains(pkg.getName());
        }
        return true;
    }
}

