/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldFactory;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IStructWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.specador.BitFieldWrapper;
import ro.amiq.vlogdt.specador.VariableWrapper;
import ro.amiq.vlogdt.specador.Wrapper;

public class TypeWrapper
extends Wrapper
implements IStructWrapper {
    RfTypeAlias aliasType;
    boolean hasBitField;
    private static final String PACKED_STRUCT = "typedef struct packed ";
    private static final String STRUCT = "typedef struct ";

    TypeWrapper(SpecadorModel model, RfTypeAlias namedElement) {
        super(model, namedElement);
        this.aliasType = namedElement;
    }

    public String getName() {
        return this.aliasType.getName();
    }

    public String getAssociatedTypeSignature() {
        DataType typeInfo = this.aliasType.getDataType();
        if (typeInfo == null) {
            return "";
        }
        String typeNameWithParamAssignments = typeInfo.getTypeNameWithParamAssignments();
        return typeNameWithParamAssignments == null ? "" : typeNameWithParamAssignments;
    }

    public int getQualifiers() {
        return this.aliasType.getQualifiers();
    }

    public String getLinkToRefType() {
        return this.getLinkToRef(this.aliasType.getAssociatedType(1));
    }

    public List<VariableWrapper> getEnumItems() {
        ArrayList<VariableWrapper> result = new ArrayList<VariableWrapper>();
        IRfNamedElement translatedType = this.aliasType.getTranslatedType();
        if (translatedType == null || !(translatedType instanceof RfNamedElement) || ((RfNamedElement)translatedType).getFields() == null) {
            return result;
        }
        ((RfNamedElement)translatedType).getFields().forEach(v -> {
            boolean bl = result.add(new VariableWrapper(this.getModel(), (RfField)v));
        });
        return result;
    }

    public String getDefinition() {
        return this.hasBitField ? PACKED_STRUCT + this.getName() : STRUCT + this.getName();
    }

    public boolean generateBitfieldDiagram(File location, IProgressMonitor monitor) {
        String svg;
        File file;
        block5: {
            BitFieldModel model;
            block4: {
                try {
                    model = BitFieldFactory.getModel((IRfNamedElement)this.aliasType, null);
                    if (model != null) break block4;
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return true;
                }
            }
            file = new File(location, "bitfield_" + this.getName() + ".svg");
            monitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), file.getName()}));
            svg = Wavedrom.getInstance().generateSpecadorBitfieldSVG(model);
            if (svg != null && !svg.isEmpty()) break block5;
            return false;
        }
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)this.getModel(), (File)file, (String)svg, null, (int)0);
    }

    public List<BitFieldWrapper> getBitFields() {
        BitFieldModel bitfieldModel = BitFieldFactory.getModel((IRfNamedElement)this.namedElement, null);
        if (bitfieldModel == null) {
            return new ArrayList<BitFieldWrapper>();
        }
        return bitfieldModel.getBitFields().stream().filter(b -> !b.getName().isEmpty()).map(b -> new BitFieldWrapper(this.getModel(), (BitField)b)).collect(Collectors.toList());
    }

    public void setBitField(boolean hasBitField) {
        this.hasBitField = hasBitField;
    }

    public boolean hasBitField() {
        return this.hasBitField;
    }

    public String getDocumentationLocation(File codeLocation) {
        String fileName = this.aliasType.getEnclosingPackage() != null ? "index" : this.getLibraryName();
        String documentationPath = SpecadorConstants.getMessage((String)SpecadorConstants.documentationLocation, (Object[])new Object[]{this.getFullPath(), fileName});
        StringBuilder link = new StringBuilder(codeLocation.toPath().relativize(Paths.get(documentationPath, new String[0])).toString());
        link.append("#").append(this.getID());
        return link.toString();
    }

    @Override
    public String getFullPath() {
        if (this.aliasType.getEnclosingScope() instanceof RfModule) {
            return String.valueOf(super.getFullPath()) + "modules" + File.separator;
        }
        if (this.aliasType.getEnclosingScope() instanceof RfInterface) {
            return String.valueOf(super.getFullPath()) + "interfaces" + File.separator;
        }
        if (this.aliasType.getEnclosingScope() instanceof RfPackage) {
            return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator;
        }
        return super.getFullPath();
    }
}

