/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.specador.FieldWrapper;

public class VariableWrapper
extends FieldWrapper {
    RfField variable;
    private static final Pattern WIRE_PATTERN = Pattern.compile("wire");

    VariableWrapper(SpecadorModel model, RfField namedElement) {
        super(model, namedElement);
        this.variable = namedElement;
    }

    public String getInitialValue() {
        String initialValue = "";
        if (this.namedElement instanceof RfPort) {
            initialValue = ((RfPort)this.namedElement).getInitialValue(false);
        } else if (this.namedElement instanceof RfField) {
            initialValue = ((RfField)this.namedElement).getInitialValue(false);
        }
        return initialValue == null ? "" : initialValue;
    }

    public String getLinkToRefType() {
        DataType dataType = this.variable.getDataType();
        if (dataType != null && dataType.hasUnpackedDimension() && dataType.getUnpackedDimension().stream().allMatch(indexType -> indexType.getType().isEmpty())) {
            return "";
        }
        return this.getLinkToRef(this.variable.getAssociatedType());
    }

    @Override
    public String getSimpleTypeLink() {
        if (this.variable.getAssociatedType() instanceof RfClass) {
            return this.getLinkToRefType();
        }
        return super.getSimpleTypeLink();
    }

    public String getAssociatedTypeName() {
        DVTStringBuilder typeName = new DVTStringBuilder(this.element.getAssociatedTypeName(true));
        if (typeName.toString().isEmpty() || typeName.toString().endsWith(" ")) {
            typeName.append("logic");
        } else if (typeName.toString().equals("logic")) {
            typeName.prepend("wire ");
        } else if (typeName.toString().startsWith("[")) {
            typeName.prepend("logic");
        } else if (typeName.toString().contains("wire [")) {
            String associatedName = typeName.toString();
            typeName.clear();
            typeName.append(WIRE_PATTERN.matcher(associatedName).replaceFirst("wire logic"));
        }
        DataType dataType = this.element.getDataType();
        if (dataType == null) {
            return typeName.toString();
        }
        if (dataType.getOrderedParamAssignments() != null || dataType.getNamedParamAssignments() != null) {
            return dataType.getTypeNameWithParamAssignments(null, null, false, true);
        }
        return typeName.toString();
    }

    public String getEnclosingClassName() {
        return this.variable.getEnclosingScope() == null ? "" : this.variable.getEnclosingScope().getName();
    }

    public String getParentName() {
        return this.variable.getEnclosingScope() == null ? "" : this.variable.getEnclosingScope().getName();
    }

    public String getLinkToParent() {
        String linkToRef = this.getLinkToRef(this.variable);
        if (linkToRef.equals("")) {
            return "";
        }
        return linkToRef;
    }

    @Override
    public String getFullPath() {
        if (this.namedElement.getEnclosingScope() instanceof RfModule) {
            return String.valueOf(super.getFullPath()) + "modules" + File.separator;
        }
        if (this.namedElement.getEnclosingScope() instanceof RfInterface) {
            return String.valueOf(super.getFullPath()) + "interfaces" + File.separator;
        }
        if (this.namedElement.getEnclosingScope() instanceof RfPackage) {
            return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator;
        }
        if (this.namedElement.getEnclosingScope() instanceof RfClass) {
            RfClass clazz = (RfClass)this.namedElement.getEnclosingScope();
            String classPath = LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getClassPath((IRfNamedElement)clazz, false);
            if (!classPath.isEmpty()) {
                classPath = String.valueOf(classPath) + File.separator;
            }
            if (clazz.getEnclosingScope(RfModule.class) != null) {
                return String.valueOf(super.getFullPath()) + "modules" + File.separator + classPath;
            }
            if (clazz.getEnclosingPackage() != null) {
                return String.valueOf(super.getFullPath()) + "packages" + File.separator + this.getPackageName() + File.separator + classPath;
            }
            return String.valueOf(super.getFullPath()) + "classes" + File.separator + classPath;
        }
        return super.getFullPath();
    }

    public List<SpecadorCommentWrapper> getComment(CommentBlock commentBlock) {
        if (commentBlock != null && !commentBlock.isEmpty()) {
            return super.getComment(commentBlock);
        }
        String commentFromEnclosingScope = this.variable.getComment();
        if (commentFromEnclosingScope == null || commentFromEnclosingScope.isEmpty()) {
            return Collections.emptyList();
        }
        return super.getComment(new CommentBlock(commentFromEnclosingScope, "", false));
    }

    @Override
    public String getType() {
        DataType dataType = this.element.getDataType();
        if (dataType != null && (dataType.getOrderedParamAssignments() != null || dataType.getNamedParamAssignments() != null)) {
            return dataType.getTypeNameWithParamAssignments(null, null, false, true);
        }
        return super.getType();
    }
}

